var tipuesearch = {'pages': [
{"title":"Altium Designer Documentation","text":"Altium Designer combines a multitude of features and functionality, including:\t\t\tAdvanced routing technology\t\t\t\tSupport for cutting-edge rigid-flex board design\t\t\t\tPowerful data management tools\t\t\t\tPowerful design reuse tools\t\t\t\tReal-time cost estimation and tracking\t\t\t\tDynamic supply chain intelligence\t\t\t\tNative 3D visualizations and clearance checking\t\t\t\tFlexible release management tools\tUnderlying Altium Designer is the X2 Integration Platform, which brings together Altium Designer&#039;s various editors and software engines and provides a consistent user interface across all the tools and editors. All of this functionality is delivered through, and the entire design process is performed within, a single Unified Design Environment \u2013 the only one of its kind, and it is engineered to deliver optimal productivity.\u00a0A consistent selection and editing paradigm across different editors allows you to easily and smoothly switch between various design tasks within the Altium Designer environment.\u00a0The Altium Designer environment is fully customizable, which allows\u00a0you to set up the design space to suit the way you work.The unified nature of Altium Designer allows for seamless movement of design data from one design realm to the next. At the start, the perceived steep learning curve can appear to be a formidable blockade to this productivity-enhancing landscape, and the wealth of features it contains. This, the core space for documentation specific to Altium Designer, provides all the information needed to quickly get you up and running with the software. From high-level overviews and stepped walk-throughs, to full coverage of all the nuts and bolts resources delivered through the software&#039;s intuitive interface, the Altium Designer documentation provides a tree of knowledge at your fingertips.\tThe Altium Designer documentation is versioned. You can switch to a particular version&#039;s documentation set manually, directly through your web browser, or you can sit back and access the correct version automatically from within Altium Designer. F1 mapping functionality and other documentation links are instilled that allow you to arrive at the correct documentation destination for the version of the software in which you are actively designing.\tIf you like what you see but are not yet a customer, why not take Altium Designer for a test drive? By filling out a simple form, you can try Altium Designer for free with 15 days of access to the full software. That&#039;s right, the ability to evaluate the full Altium Designer experience with no technical limitations gives you unrestricted access to the world&#039;s finest PCB design product. Click the link below, fill out the form then see for yourself why more engineers and designers choose Altium Designer than any other product available!\t\tAltium Designer Free Trial\t\tComing from a different design tool? Not a problem. Scoot on over to the area of the documentation that looks at Interfacing to Other Design Tools. No matter whether you&#039;re coming from PADS\u00ae, EAGLE\u2122, Expedition\u00ae, xDX Designer\u00ae, Allegro\u00ae, or some other supported interface, Altium Designer has the importer and\/or exporter to make joining Altium Designer a smooth and reassuring experience.\tRead about Installing and Extending Altium Designer. Read about Getting Altium Designer Licensed. Read about Altium Design Environment.Jumping into PCB Design (and Altium Designer)\tNew to board design and\/or Altium Designer, and wondering where to begin? This tutorial will take you from a blank schematic sheet all the way to generating the files needed to fabricate the bare board for a simple nine-component circuit.The design you will be capturing and then designing a printed circuit board (PCB) for is a simple astable multivibrator. The circuit \u2013 shown to the left \u2013 uses two general-purpose NPN transistors configured as a self-running astable multivibrator.The tutorial touches on many of the areas of the software that you will need to become familiar with in your day-to-day design work. What better way to familiarize yourself with and get to know your powerful design &#039;partner&#039;?\tRead more...Designing with a Connected Workspace\tTo handle your valuable design data while affording unparalleled collaboration, Altium Designer can connect to, and work with, a Workspace. The Workspace not only provides rock-solid, secure storage of data but also enables re-release of data as distinctly separate revisions \u2013 essentially tracking design changes over time without overwriting any previously released data. It also caters to the lifecycle of the data to be managed, allowing people that need to use the data to see at a glance what stage the data has reached in its &#039;life&#039; and, therefore, what it can be safely used for.The Workspace is used to manage all design data, including components, domain models, schematic sheets of circuitry, and design templates. Indeed, you can even create and manage your entire design projects directly within the Workspace.By furnishing a set of reusable design &#039;building blocks&#039; within the Workspace, you can embark on fresh projects safe in the knowledge that each model, component, and higher-order design element has been ratified and approved for use, without having to reinvent the wheel as it were. The Workspace becomes both the source and destination of design elements, with each new design utilizing elements released to and managed through the Workspace. Additionally, by designing only with elements from the Workspace, the integrity of those designs is inherently assured.Altium Designer connects to a Workspace. That Workspace can be delivered in one of the following ways:\t\t\tA Workspace hosted on the Altium 365 cloud-based infrastructure platform,\u00a0also referred to as an Altium 365 Workspace.\t\t\t\t\t\tA Workspace provided through the Altium On-Prem Enterprise Server. Also referred to as an Enterprise Server Workspace, this\u00a0is installed and managed by your own IT department.\t\t\tWith an Altium 365 Workspace, you&#039;ll benefit from a richer set of collaborative features, including Global Sharing. And because it is cloud-based, you get the latest version of the Workspace without having to worry about manual upgrades.\t    Key Benefits of an Altium 365 Workspace    Some of the key benefits that Altium 365 brings to the design table:\t\t\t\t\t\t\tSecurely share PCB designs with internal and external stakeholders with a web link with which they can view and comment on the design via a web browser on any platform (Mac, Windows, Android, or iOS) and any device (desktop or mobile).\t\t\t\t\t\t\tCommunicate true design intent early and collaboratively through commenting, co-creation, and visualization of PCB designs. Work from anywhere and connect with anyone with ease. Built-in storage and version control (tightly integrated with Altium Designer) ensure that the latest data is available at any time from any device.\t\t\t\t\t\t\tConduct more effective design reviews by allowing users to highlight and mark up a specific component or area on a schematic or layout. Internal\/external stakeholders (e.g., managers, other designers, part suppliers, etc.,) can comment and mark up designs simultaneously (much like a collaboration on a Google\u00ae document).\t\t\t\t\t\t\tCollaborate with multiple designers. The web browser platform simplifies how designs are visualized and marked up while allowing other designers to connect to the same PCB design with Altium Designer to author changes.\t\t\t\t\t\t\tCo-design with mechanical designers. Electrical and mechanical engineers can push and pull design data backward and forward in real-time with each being notified when changes have been made by the other. Altium 365 provides native integration between electronic and mechanical domains through a built-in co-designer capability that provides native integration with a variety of MCAD software tools.\t\t\t\t\t\t\tReduce miscommunication and redesign iterations with manufacturing. Compress design cycles with the capability to create formal atomic design releases ensuring a coherent set of manufacturing data. Create a manufacturing package that can be bundled up according to the needs of your specific manufacturing partner.\t\t\t\t\tRead about Accessing Your Workspace. Read about\u00a0Configuring and Administrating Your Workspace.Capturing Your Design Idea as a Schematic\tSchematic capture is the process of creating a logical representation of an electronic circuit. When you capture a schematic, you are connecting a collection of symbols (components) together in a unique way, creating your unique electronic product. When you perform your schematic capture electronically, you can create more than a\u00a0high-quality printed representation of the design,\u00a0perform related design tasks, such as a circuit simulation, and\u00a0transfer the design to a PCB layout tool.\tRead more...Analyzing Your Design using Circuit Simulation\tCircuit simulation allows the designer to explore their ideas before committing to manufacture. Concepts can be verified and the circuit can be tuned quickly and accurately. Circuit simulation also gives the designer the opportunity to perform\u00a0measurements that may not be physically possible on the workbench.The Simulator is a true mixed-signal simulator, meaning that it can analyze circuits that include both analog and digital devices. It is fully SPICE3f5 compatible, as well as providing support for a range of PSpice\u00ae\u00a0and LTSpice\u00ae\u00a0device models.\tRead more...Laying Out Your PCB\tInside every electronics product is a printed circuit board or PCB.\u00a0Today, the components have shrunken so much they are measured in fractions of a millimeter rather than centimeters, and track widths have shrunken from being 10 mil wide, well-spaced lines, to thin, 2 or 3 mil hair-like lines that are tightly packed together. Rising signal speeds have also seen the PCB interconnects change from being simple copper conduits that carry electrical energy, to behaving as high-speed transmission lines, requiring design techniques to cater to this. The mechanical requirements have also become more complex. Compact, unusually shaped modern electronic products require compact, unusually shaped printed circuit boards which are often implemented as rigid-flex structures - these boards can have curved edges and cutouts, requiring carefully positioned components.These challenges can be met with Altium PCB design technologies.\tRead more...ECAD-MCAD Co-Design\tMost electronic products that are designed are fixed to some kind of mechanical structure \u2013 either a chassis or an enclosure. Finding a mechanical conflict between the board (ECAD) and chassis\/enclosure (MCAD) late in the design process can be a costly experience. And while you could get a 3D model exported from Altium Designer, it is a manual process that needs a conscious decision and action to do so. In reality, this is performed very infrequently, with the result being that the MCAD designer is never quite sure if what they&#039;ve got is the latest and greatest. It really shouldn\u2019t be so hard to ensure you\u2019re not about to waste a pile of money just because your tools don\u2019t talk.Working between the electronic and mechanical design domains brings unique challenges. Small and complex product enclosures that house multiple, irregular shaped printed circuit boards - to successfully design these products the ECAD and MCAD designers must be able to fluidly pass design changes back and forth between their design domains.Passing complex and detailed design changes between different design software is much more than just being able to save data in another format. The electronic and mechanical design teams work independently and need to be able to selectively transfer design changes at any point in their design process.A Workspace provides native ECAD to MCAD collaboration where data flows seamlessly between domains. No more polling for updates and no more uncertainty. Data is pushed between domains as the design evolves, ensuring design coherence.The following MCAD platforms are supported when using the latest Altium CoDesigner plugins:\t\t\tDassault Systemes SOLIDWORKS\u00ae\t\t\t\tAutodesk Inventor Professional\u00ae\t\t\t\tPTC Creo Parametric\u00ae\t\t\t\tAutodesk Fusion 360\u00ae\t\t\t\tSiemens NX\u00ae\tThe versions of MCAD tools officially supported will depend on the version of\u00a0Altium CoDesigner plugin being used. This information can be found on the New in CoDesigner page.\tMCAD CoDesigner synchronizes the PCB design between electrical and mechanical engineers. It works directly with ECAD and MCAD data via the MCAD CoDesigner panel on the Altium Designer side, and a corresponding panel plugged-in to your MCAD software. The latter is provided through the installation (and registration to the MCAD software) of the Altium CoDesigner plugin. Obtain the corresponding plugin for your MCAD software from the MCAD CODESIGNER PLUGINS section on the Downloads page of the altium.com site.\tRead more...Streamlining Board Design Documentation with Draftsman\tDraftsman provides an advanced, yet flexible graphical editing environment for creating board design production documents. Based on a dedicated file format and set of drawing tools, the Draftsman drawing system provides an interactive approach to bringing together fabrication and assembly drawings with custom templates, annotations, dimensions, callouts, and notes.Draftsman\u00a0offers automated placement of assembly and fabrication drawings on demand and includes a wide range of manual drawing tools that can be used to add important details and highlighting to its multi-page documents.\tRead more...Preparing Your Design for Manufacture\tThe final phase of the board design cycle is to generate the output files needed to fabricate, assemble and test the printed circuit board. To do this, you need to generate a variety of output files\u00a0in a variety of formats.As the designer, you have the choice of individually configuring and generating the outputs via the schematic and PCB editor, or alternatively, you can add all of the required outputs into an OutputJob\u00a0and then generate them as part of the project release process.\tRead more...Designing with Multiple PCBs\tMany products include multiple, interconnected printed circuit boards. Bringing these boards together inside the enclosure and ensuring they correctly connect to each other is a challenging phase of the product development process. Have the nets been assigned correctly on each connector? Are the connectors oriented correctly? Do the plug-in boards fit together? Do all of the connected boards fit into the enclosure?Managing this requires a design environment that supports system-level design. Ideally, this will be a design space where you can define both the functional or logical system, as well as a space where you can plug together the various boards and verify that they connect correctly, both logically and physically.Altium Designer brings system-level design to the electronic product development process.\tRead more...Harness Design\tThe Harness Design functionality allows engineers of various types (involved in the Product Design process) to work in Altium Designer. It brings comprehensive harness design support into the same environment as PCB and system design, removing the previous heavy reliance on third-party software.The Harness Design functionality allows you\u00a0to create a full wiring harness design, from the individual pin-to-pin connections right through to manufacturing documentation. A harness design can be created as a standalone project, or as part of a Multi-board project. In the latter case, the logical connections between PCBs in the Multi-board project are used to define the connectivity within the harness.\tRead more...Building &amp; Maintaining Your Components and Libraries\tAn electronics design is a collection of connected components. The rewarding part of product development is coming up with cool ways of solving those engineering challenges, and connecting those components to craft your unique design.However, a large part of the work, and to many designers, the more tedious part, is creating the components. While it might not be exciting, the components become a valuable resource for your company, and it is essential that they accurately represent the real-world component.The component that you buy and solder onto the board is the real component, but that component has to be modeled in each of the electronic design domains in which you want to use it.\tRead more...Learn As You Go\tBacking Altium Designer is a comprehensive set of online documentation. Wherever you are in the environment, over a menu command, a dialog, a panel, or a design object, press F1 to display comprehensive information about whatever was under the cursor.Within this comprehensive information, there are links to related information about how to place it, edit it, or use it. You also will find links to richer content about how it fits into the overall design process.If you prefer to browse and explore the overall structure, use the navigation tree on the left.Available shortcuts also are listed in the various panels;\u00a0look for the shortcut keystrokes displayed next to the controls in the panel.\tWhile you are\u00a0running a command, for example, during Interactive Routing, press Shift+F1 to display a list of in-command shortcuts.\u00a0","tags":"","url":"altium-designer\/24\/documentation-altium-designer.html"},
{"title":"New in Altium Designer","text":"\u00a0h6 {font-size: 21px;margin: 22px 0 16px;}.Container {position:relative; user-select:none; display:inline-block; margin:0 30px 0 30px;}.SlidesTable td {border:none;padding:0;}.FirstText {border:none; display:inherit;padding: 0 30px 0 40px;}.FirstText {border:solid 1px lightgray; display:block;}.OverlayText {border::none;; display:none;padding: 0 30px 0 40px;}.OverlayText {border:solid 1px lightgray; display:block;}h5 {font-family:dinpro-medium; line-height:1.2; font-size:17px; letter-spacing:normal; color:#424242; margin: 0 0 12px;}.Next,.Previous {font-size:25px; cursor:pointer; position:absolute; top:40%; color:blue; padding:2px 8px 5px 8px;}.Next {right:-30px;}.Previous {left:-30px;}a.Next, a.Previous {opacity:0.6; transition:0.3s;}a:hover.Next, a:hover.Previous {opacity:1; background-color:lightgray; text-decoration:none;}.Overlay {z-index:-1; position:absolute; top:0; transition:0.5s ease; opacity:0;  padding:10px; border:solid 1px; border-color:lightgray;}.First {transition:1s ease-in; padding:10px; border:solid 1px; border-color:lightgray;}.blob {height:15px; width:15px; margin:0 5px; background-color:#bbb; border-radius:50%; display:inline-block; cursor:pointer;}.blobs {text-align:center; padding:0; color:blue;}.Counter {display:none;}This page details the improvements included in the initial release of Altium Designer 24, as well as those added in subsequent updates. Along with delivering a range of improvements that develop and mature the existing technologies, each update also incorporates a large number of fixes and enhancements across the software based on feedback raised by customers through the AltiumLive Community&#039;s BugCrunch system, helping you continue to create cutting-edge electronics technology.\tYou can choose to continue with your current version, update your current version, or install Altium Designer 24 alongside your current version to access the latest features. Your current version can be updated from within the software\u00a0in the Extensions and Updates view. If you prefer to install Altium Designer 24\u00a0alongside your current version, visit the Altium Downloads page to download the installer, then choose New Installation on the Installation Mode page of the installer.\t\tFree Trial!\t\tIf you like what you see but are not yet a customer, why not take Altium Designer for a test drive? By filling out a simple form, you can try Altium Designer for free\u00a0with 15 days of access to the full software. That&#039;s right, you will have the ability to evaluate the full Altium Designer experience\u00a0with no technical limitations with unfettered access to the world&#039;s finest PCB design product. Click the link below, fill out the form, and see for yourself why more engineers and designers choose Altium than any other product available!\t\tAltium Designer Free Trial.\tAltium Designer 24.10Released: 10 October 2024 \u2013 Version 24.10.1 (build 45)Release Notes for Altium DesignerSchematic Capture ImprovementSupport for Empty Sub-parts in Normal ModeImproved single\/multi-part symbol handling, extending the same features and functionality available for Alternate display modes, to the Normal display mode. For example, a component can now be represented by a single symbol in the Normal display mode and by two symbols in its Alternate mode, as shown in the image below. \t\t\tIf a multi-part component only has primitives defined in one sub-part, the designator suffix is hidden when that sub-part is placed on a schematic sheet,\u00a0regardless of the current display mode and which sub-parts have primitives (the first sub-part or not).\t\t\t\t\t\tIf a multi-part component has empty sub-parts in its view mode (either the Normal or an Alternate mode), these sub-parts are omitted during placement.\t\t\t\t\t\tAn Unused sub-part in component violation will not occur when running a design validation if a component has sub-parts without primitives and these sub-parts are not placed on the schematic,\u00a0regardless of the display mode.\t\t\tAlso, it is now possible to change part or display mode to one without any primitives. A warning icon is shown next to the corresponding entries in the Properties panel when an empty sub-part or display mode is selected ().For more information, refer to the\u00a0Searching for &amp; Placing Components page.PCB ImprovementsWire Bonding (Open Beta)In this\u00a0release, support for designing hybrid boards with chip-on-board (CoB) technology using Wire Bonding has been added. This feature allows you to create a component with defined Die Pads (corresponding to pins of the schematic symbol). Once placed on a schematic and synchronized (through ECO) to the PCB, it can be wired to regular pads (or any copper) on the main board\u00a0using Bond Wires. When connecting to a regular pad, that pad takes on the likeness of a Bond Finger pad.You can define a complete, simple package with defined die pads, bond finger pads, and bond wires, all as part of the component footprint.\t\t\tSupport for adding die pads is provided courtesy of a predefined Die component layer pair (Top Die\u00a0\/\u00a0Bottom Die). Note that when a die pad is placed on an extruded 3D body (also on the\u00a0Top Die\u00a0\/\u00a0Bottom Die layer), it will be automatically placed at the Overall Height of this 3D body.\t\t\t\t\t\tFor placement of bond wires (from die pad to bond finger pad, die pad to die pad, etc.), a predefined Wire Bonding\u00a0component layer pair is provided (Top Wire Bonding\u00a0\/\u00a0Bottom Wire Bonding). Use the Place \u00bb Bond Wire command or\u00a0\u00a0on the Active Bar\u00a0to place a bond wire. Use the fields in the\u00a0Profile region of the Properties panel to specify the desired values of the Loop Height and Diameter of a bond wire, as well as the Die Bond Type (Ball or Wedge) \u2013 .\t\t\t\t\t\tRegular pads to which bond wires are connected (bond finger pads) can be aligned with bond wires. To do this, select bond wires and bond finger pads connected to them, right-click the selection, and then choose the Pad Actions \u00bb Align Bond Finger with Bond Wire command from the right-click menu.\t\t\t\tAn example of a footprint (in 2D and 3D views) that features wire bonding.When using the Chip-on-Board approach, you can also place bond wires manually to connect the die pads of the chip to any copper on the main board. A bond wire will inherit the net of its source die pad. Multiple bond wires can emanate from the same die pad, and conversely, multiple bond wires can finish on the same copper on the main board. \tAn example of a PCB that features wire bonding.A new Wire Bonding design rule has been added in the Routing category to support wire bonding and can be defined in the All Rules view of the Constraint Manager when accessed from a PCB and the PCB Rules and Constraints Editor dialog (when using the older approach to design rule definition and management).\u00a0The rule enables constraints to be defined for the permissible distance between adjacent bond wires (Wire To Wire), Min and Max Wire Length, and Bond Finger Margin, which is the distance\/padding between a bond wire and the edge of the bond finger pad to which it is wired.\u00a0The Wire Bonding design rule is supported by the batch DRC. Electrical rule checks (Un-Routed Net and Short Circuit) also apply to Wire Bonding. In terms of manufacturing documentation, Draftsman supports wire bonding in both its regular board assembly view (for the main Chip-on-Board approach) and also the component view (for where the wire bonding \u2018package\u2019 has been fully defined within the footprint). Wire bonding information is also supported when generating regular PCB prints.A wire bonding table report that provides information in relation to die pads and bond finger pads can be generated (in the CSV format). Use the\u00a0Wire Bonding Table Report\u00a0output from the Assembly Outputs region of an outjob file to add a new output of this type, or select the\u00a0File\u00a0\u00bb Assembly Outputs\u00a0\u00bb Wire Bonding Table Report\u00a0command from the main menus of the PCB editor to generate the report. \tThis feature is in Open Beta and available when the\u00a0PCB.Wirebonding\u00a0option is enabled in the\u00a0Advanced Settings dialog.\tFor more information, refer to the\u00a0Wire Bonding page.Phase Matching for Differential Pairs (Open Beta)This release includes the ability to enable phase matching between the sides of a differential pair, as part of automatic diff pair length tuning.To perform phase matching between the sides of required differential pair(s) according to the applicable Matched Lengths constraint with the\u00a0Within Differential Pair Length option selected, select primitives of these diff pairs and choose the Route\u00a0\u00bb Automatic Length Tuning command from the main menus. In the Auto Tuning Process dialog that opens, open a new Sawtooth tab and configure parameters of the sawtooth-based pattern as required.\u00a0After clicking OK in the dialog, the sawtooth tuning patterns will be added to the sides of the differential pairs to equalize their lengths. \tThis feature is in Open Beta and available when the\u00a0PCB.TraceTuning.PhaseTuning\u00a0option is enabled in the\u00a0Advanced Settings dialog.\tFor more information, refer to the\u00a0Length Tuning page.Dynamic Phase Matching for Differential Pairs (Open Beta)This release brings dynamic phase matching support for differential pairs, which is an essential consideration for high-speed PCB designs. For maximum efficiency of differential signal transmission, differential pairs need to be both statically (equalizing the length of the two sides in a pair) and dynamically (matching the phase along the entire length of the pair) phase-matched. New dynamic phase matching constraints and automatic tuning with phase compensation have been implemented, to avoid time-consuming phase mismatch detection and elimination.The Matched Length design rule has been extended with the ability to specify dynamic phase matching constraints. When the Within Differential Pair Length option is selected, a new Dynamic Phase Matching checkbox is available. When it is enabled, you can define the following constraints:\t\t\tDynamic Phase Tolerance\u00a0\/\u00a0Dynamic Phase Delay Tolerance \u2013 the permissible phase mismatch between the tracks in a pair above which compensation is required.\t\t\t\tMatching Distance \u2013 the distance after exceeding the tolerance, for which compensation must be applied.\tDepending on if Length Units or Delay Units are selected in the rule, the above constraints are defined in millimeters or picoseconds, respectively.Support for this enhanced rule is available in both the All Rules view of the Constraint Manager (accessed from PCB) and the PCB Rules and Constraints Editor dialog (when using the older approach to design rule definition and management). \tDynamic phase matching constraints configured in the Constraint Manager \tDynamic phase matching constraints configured in the PCB Rules and Constraints Editor dialog\u200b\u200b\u200b\u200b\u200bDetected rule violations will be marked with a hatched pattern on corresponding traces in the design space (with the hatching starting at the detected point of phase mismatch, i.e., defined tolerance exceeded). You can use the Automatic Length Tuning tool to eliminate violations of dynamic phase matching. Select the required diff pairs (any tracks of the diff pairs) and choose the\u00a0Route \u00bb Automatic Length Tuning\u00a0command from the main menus. On the Sawtooth tab of the Auto Tuning Process dialog that opens, set phase matching parameters as required and click OK to add sawtooth patterns required to provide dynamic phase matching of the diff pairs. Note that the electrical types of pads at either end of a routed diff pair are taken into account, so that if a source\/load has been specified, tuning will be applied moving along the diff pair in the appropriate direction. \tThis feature is in Open Beta and available when the\u00a0PCB.Rules.DiffpairPhaseMatching\u00a0option is enabled in the\u00a0Advanced Settings dialog.\tFor more information, refer to the\u00a0High Speed Rule Types page.Routing Topology DRC Support (Open Beta)Implementation of custom topologies defined using From-Tos can now be checked as part of the Batch DRC process. Enable the Batch option for the\u00a0Routing Topology design rule type in the Design Rule Checker dialog (Tools \u00bb Design Rule Check) to detect violations. A violation is detected if there is an electrical connection between the pads of a From-To, and the shortest path contains at least one other pad of this net.\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\tJavascript ID: RoutingTopology_FromTos_AD24_5\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTwo From-Tos are created between three pads \u2013 from pad 1 to pad 2 and from pad 2 to pad 3\t\t\t\t\t\t\t\t\t\t\t\t\t\tRouting is created according to the configuration of From-Tos \u2013 there is routing between pads 1 and 2 and between pads 2 and 3. No violation of the Routing Topology rule is detected.\t\t\t\t\t\t\t\t\t\t\t\t\t\tRouting is created in a T-branch manner. There are no additional pads in paths according to the From-To configuration, so no violation of the Routing Topology rule is detected.\t\t\t\t\t\t\t\t\t\t\t\t\t\tRouting is created between pad 1 and pad 3 and from pad 2 and pad 3. This routing does not match the From-To configuration because there is an additional pad 3 at the path between pad 1 and pad 2, so a violation of the Routing Topology rule for the From-To between pads 1 and 2 is detected.\t\t\t\t\t\t\t\t\t\t\t\t\t\tViolations will not be detected for nets with a large number of pads (more than 20) or primitives (more than 1024).\t\tThis feature is in Open Beta and available when the\u00a0PCB.Rules.CheckRoutingTopology\u00a0option is enabled in the\u00a0Advanced Settings dialog.\tFor more information, refer to the\u00a0Understanding Connectivity on Your PCB page.PCB CoDesign ImprovementsDisplay of Primitive Names in ConflictsWhen a conflict between primitives of a group object is detected, names of these primitives are now included in the list of conflicts in the\u00a0PCB CoDesign panel. In the image shown below, names of primitives within a group object in conflict (pads of a component) are shown before the properties of the primitives. For more information, refer to the\u00a0PCB CoDesign page.Merging Object PropertiesWhen the same object properties are changed from both sides and there are no conflicts in property values, these changes no longer create a conflict and can be merged, significantly reducing the number of object conflicts.\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\tJavascript ID: PCBCoDesigner_MergeProperties_AD24_10\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tA PCB area and properties of component J4 in the base version of the PCB document are shown here.\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn the remote version of the PCB, 3D body opacity and pad numbers of J4 have been updated.\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn the local working copy of the PCB, pad numbers of J4 have been updated in the same way as in the remote version.\t\t\t\t\t\t\t\t\t\t\t\t\t\tAfter performing a comparison using the PCB CoDesigner panel, there is no conflict caused by changes in J4. These changes can be merged into the local copy of the PCB.\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0PCB CoDesign page.Constraint Manager ImprovementsAbility to Migrate to the Constraint Manager (Open Beta)Included with this release is the ability to perform a one-time, one-way migration from using the PCB Rules and Constraints Editor dialog to using the Constraint Manager.Use the Design \u00bb\u00a0Migrate Project to Constraint Manager Flow command from the main menus in the PCB and schematic editors.\u00a0The Migration Required dialog opens to warn that the migration will take place and it cannot be undone after the\u00a0 button is clicked. Both PCB design rules and schematic directives will be transferred into applicable corresponding constraints within the Constraint Manager. Once the migration has successfully concluded, the Constraint Manager will be opened (in the context of which editor was active when you performed the migration).\t\tIf a design rule with a default scope does not exist in the PCB Rules and Constraints Editor dialog (e.g., there is no Width rule with the scope All), it will be created in the Constraint Manager as part of the migration process.\t\tThis feature is in Open Beta and available when the\u00a0ConstraintManager.ProjectMigrationWizard\u00a0option is enabled in the\u00a0Advanced Settings dialog.\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page.Improvements to DirectivesAdd, Update, and Remove Constraints to Imported DirectivesFor an already-imported directive, it is now possible to add, update and remove constraints for it using the Properties panel.To apply changes to the data in the Constraint Manager, click the\u00a0 button at the top-right of the Constraint Manager when it is accessed from the schematic side.For more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page. Warning about Discrepancy in ECOWhen preparing the ECO to pass changes from the schematic to the PCB, a warning is now presented if there are directives that exist on the schematics that were not previously imported. For more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page. Harness Design ImprovementAuto-group WiresFor the Bulkhead Connector (the connector with the largest number of cavities), automatic grouping is applied to the wiring list in a harness manufacturing document (*.HarDwf), ensuring that all of its cavities are correctly grouped in the From column.\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\tJavascript ID: HD_AutoGroupWires_AD24_10\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn this design, component MAIN CONTROLLER is considered the Bulkhead Connector as it has the largest number of cavities.\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn the manufacturing drawing, all cavities of MAIN CONTROLLER are grouped in the From column.\t\t\t\t\t\t\t\t\t\t\t\t\tPlatform ImprovementView Only Mode for Harness and Multi-board Designs (Open Beta)A view only mode has been introduced for Harness and Multi-board projects and their associated documents. This allows you to now see and explore features that were perhaps not accessible to you previously and collaborate with colleagues working on these types of projects.When in view only mode, no updates to projects and documents are allowed\/accessible. When a project has been opened in view only mode, the Projects panel will display View Only, as shown below.\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\tJavascript ID: MB_ViewOnly_AD24_8\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAn example of view only mode for a Multi-board project. The project is labeled as View Only in the Open Project dialog and the Projects panel.\t\t\t\t\t\t\t\t\t\t\t\t\t\tWhen a source document of a project is opened (as shown here for a Multi-board schematic document), it is also labeled as View Only, and the document cannot be modified.\t\t\t\t\t\t\t\t\t\t\t\t\t\tWhile you cannot modify anything, you can generate outputs, such as PDFs, of source documents and defined outputs from associated OutJobs.\t\tThis feature is in Open Beta and available when the\u00a0System.ViewOnlyMode.Support\u00a0option is enabled in the\u00a0Advanced Settings dialog.\tFor more information, refer to the\u00a0Designing with Multiple PCBs\u00a0and\u00a0Harness Design pages.Data Management ImprovementsRequirements Management (Open Beta)For PCB design projects stored in a connected Altium 365 Workspace, this release delivers the ability to work with system requirements defined through the Requirements and Systems Portal. The latter\u00a0is an advanced engineering management application used to ensure specification and performance compliance during system design development.When enabled for your Altium 365 Workspace, the Requirements and Systems Portal integrates with your PCB design projects through the exchange of design data and formalized Requirement\u00a0instances.\u00a0The system requirements, as created in the Requirements and Systems Portal, can be placed as active instances on your design documents, referenced as tasks, and ultimately marked as verified to confirm requirement compliance.In Altium Designer, the requirements are managed through the Requirements panel.\u00a0Placed requirements are available in real-time to collaborating users \u2013 those that have shared access to the document \u2013 and are saved to the Workspace independently of the project without altering its constituent documents in any way.\tThis feature is in Open Beta and available when the\u00a0EDMS.Requirements\u00a0option is enabled in the\u00a0Advanced Settings dialog.\tFor more information, refer to the\u00a0Working with Requirements page.Ability to Change Project Parameters from a Local TemplateWhen creating a new project using the\u00a0Create Project\u00a0dialog (File \u00bb New \u00bb Project), you can now change (names and\/or values) or remove parameters sourced from the selected local project template. For more information, refer to the\u00a0Creating Projects and Documents\u00a0page.SI Analyzer by Keysight (Open Beta)More and more modern electronic devices incorporate high-speed PCB designs, and signal speeds grow as the technologies\u00a0evolve\u00a0(17 GHz in DDR6, 400 Gbps in QSFP++, etc.). Ensuring signal integrity (SI) is a crucial step in the high-speed design. Failure to meet the requirements of the interface developer is very likely to cause problems in further design stages, manufacturing, and performance.To provide PCB designers with a tool for signal integrity analysis, a new solution is now available \u2013 SI Analyzer by Keysight. Provided as a software extension and available right in the Altium Designer environment, the SI Analyzer by Keysight\u00a0allows performing a range of SI post-layout checks to cover the most important high-speed design parameters:\t\t\tImpedance\t\t\t\t\t\tDelay\t\t\t\t\t\tInsertion Losses (IL)\t\t\t\t\t\tReturn Losses (RL)\t\t\t \tThis feature is in Open Beta and available when the SI Analyzer by Keysight extension is installed.\u00a0Creating a new analysis document, adding\/configuring nets for an analysis, as well as the review of existing SI analysis results and generation of an SI analysis report, can all be performed by anyone with a valid Altium Designer license. Performing a new SI analysis requires a valid Signal Analyzer by Keysight license.\u00a0If no\u00a0Signal Analyzer by Keysight license is available when running a new SI analisys, you can request a 14-day free trial using the dialog that opens.\tFor more information, refer to the\u00a0SI Analyzer by Keysight\u00a0page.Features Made Fully Public in Altium Designer 24.10The following features are now officially Public with this release:\t\t\tPad Hole Clearance Check Improvement \u2013\u00a0available from 24.1\t\t\t\t\t\tFootprint Mirroring Prevention \u2013\u00a0available from 24.5\t\t\tAltium Designer 24.9Released: 11 September 2024 \u2013 Version 24.9.1 (build 31)Release Notes for Altium Designer\t    Key Highlights    \t\tSchematic Capture Improvement\t\t\tEmpty Sub-parts Omitted during Placement\tIf a multi-part component has empty sub-parts in its alternate view mode, these sub-parts are now omitted during placement.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: MultiPart_Placement_AD24_9\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAn example of a schematic symbol of a dual op amp component. The normal mode represents the component in two sub-parts. An alternate mode represents the component as a single sub-part.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWhen placing the component in its alternate view mode, the empty sub-part B is not placed.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the Searching for &amp; Placing Components page.\t\t\t\tPCB Design Improvement\t\t\tAbility to Overlap Courtyard Outlines\tIt is now possible to place components close enough that their courtyard outlines exactly overlap. When the Check clearance by component boundary option is enabled, and the Minimum Horizontal Clearance value is set to 0 in the corresponding Component Clearance design rule, there will not be any violations of this rule when component courtyard outlines exactly overlap, as shown below.\t\t\t\t\t\tWhen the selection bounding box of a component\u00a0is defined by the courtyard layer tracks, the centerline of these tracks is used to define the bounding box (as selecting the component shows \u2013 ). Note that this is only the case when the shape defined on the courtyard layer is a closed shape, with the track end vertices being coincident (exactly touching). Otherwise, the bounding box is defined by the smallest rectangle that encloses all of the objects on the courtyard layer, and placing components so their courtyard outlines exactly overlap will result in a violation of the Component Clearance design rule.\t\t\t\tFor more information, refer to the\u00a0Placement Rule Types page.\t\t\t\tConstraint Manager Improvements\t\t\tAbility to Apply Default Keepout Rule\tThe Apply zero Keepout\u00a0clearance option has been added to the\u00a0Clearances Settings region in the\u00a0Clearance options and\u00a0Physical options\u200b\u200b\u200b\u200b\u200b Properties panels. When this option is enabled, a default clearance rule is applied, with a gap of \u20180\u2019, between a keep out and all other primitives in the design. Note that this rule is not visible on any of the Constraint Manager views and, therefore, cannot be modified. If disabled, the regular clearance matrix values will be followed.\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page. \t\t\t\tAbility to Enable\/Disable Basic Rules\tYou can now enable\/disable basic rules defined in the\u00a0Constraint Manager&#039;s\u00a0All Rules view when accessed from the PCB.\u00a0Double-click a cell in the Enabled\u00a0column and toggle the state of a specific basic rule between True\u00a0(enabled) and\u00a0False\u00a0(disabled). Cells corresponding to disabled basic rules are labeled (Disabled)\u00a0and grayed out in the Physical and Electrical views.\t\t\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page.\t\t\t\tEnhanced Representation of the Clearance Matrix in the All Rules View and ECO Dialog\tPresentation of the Clearances Matrix on the All Rules view (when accessed from the PCB) has been improved, with all custom values now displayed as separate lines.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: CM_ClearanceMatrixRep_AD24_9\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn the Clearance Matrix, there are specific rules between each net class and all nets.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tOn the All Rules view, these rules are displayed as separate lines.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn addition, the entries and level of detail presented in the Engineering Change Order dialog when passing changes made to the Clearances Matrix have also been improved. All rules included in the matrix are now listed, including information about the scope and affected layers, as well as changes in scopes (added\/removed).\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page.\t\t\t\tConfiguring Constraint Sets for Different Layer Stacks\tWhen accessing the Constraint Manager from the schematic and configuring constraints for different layer stacks (e.g., for different boards in the same project), constraint sets now remember which layer stack they were created in. For the currently chosen layer stack, it is no longer possible to assign or modify a constraint set that was created for a different layer stack. The message This Constraint Set was created for a different layer stack will appear in the Properties panel when this is the case.\t\t \t\tIn addition, a caution is provided when opening a project that has constraint sets saved for custom layer stacks in an older version of the software.\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page.\t\t\t\t3D-MID Design Improvements\t\t\tAdded Net Color Override Feature\tYou can now override the color of specific nets in a 3D-MID document (*.PcbDoc3D). Use checkboxes for nets in the Nets mode of the PCB panel to enable and disable the Net Color Override feature for these nets.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: 3DMID_NetColorOverride_AD24_9\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tA 3D-MID document with the Net Color Override feature enabled for all nets.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tA 3D-MID document with the Net Color Override feature disabled for all nets.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a03D-MID Design page.\t\t\t\tAdded Ability to Edit Tracks\tAdded the ability to edit a track by clicking and dragging.\t\t\t\t\t\t\tClick and drag a track to add a new vertex.\t\t\t\t\t\t\tClick and drag\u00a0a vertex to move it.\t\t\t\t\t\t\t\tFor more information, refer to the\u00a03D-MID Design page.\t\t\t\tHarness Design Improvements\t\t\tProject Releaser for Harness Designs (Open Beta)\tThis release introduces high-integrity harness design release management using the Project Releaser, a process long-enjoyed by those preparing their PCB design projects for manufacture.\t\tThe harness design release process is automated and repeatable. One-touch releasing enables you to release your design projects without the risks associated with manual release procedures. From taking a snapshot of the design files through validation and output generation, there is no interaction. If a part of the process fails, the release fails. You also get to review all generated data before finalizing the release.\t\tThe user interface to the Project Releaser is provided courtesy of a dedicated Release view. Access this view using the Project Releaser command, available from the main Project menu (with a source document for the project open as the active document) and the right-click context menu for the harness project&#039;s entry in the Projects panel.\t\t \t\tCurrently, releasing to a connected Altium 365 Workspace and local releases (offline) are supported.\t\t\t\tThis feature is in Open Beta and available when the\u00a0HarnessDesign.ProjectReleaser\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Design Project Release page.\t\t\t\tData Management Improvements\t\t\tAbility to Change Project Parameters from a Workspace Template\tWhen creating a new project using the Create Project dialog (File \u00bb New \u00bb Project), you can now change (names and\/or values) or remove parameters sourced from the selected Workspace project template.\t\t\t\tFor more information, refer to the\u00a0Creating Projects and Documents page. \t\t\t\tAbility to Copy Workspace-side Project-level Parameters\tFrom the Parameters tab of the Project Options dialog (Project \u00bb Project Options), you can now copy Workspace-side project parameters (those that appear with the\u00a0 icon in the dialog). Right-click the parameter entry and select the Copy command from the context menu to copy the name and value of the parameter.\t\t\t\tFor more information, refer to the\u00a0Accessing, Defining &amp; Managing Project Options page.\t\t\t\tAbility to Share Read-only Project Snapshots\tThis release brings back the ability to share a read-only snapshot of a Workspace project using the\u00a0Share\u00a0dialog, which has been hidden since Altium Designer 24.4.\t\t \t\tFor more information, refer to the\u00a0Sharing a Design page.\t\t\t\tUpdated Message for Subscriptions of Perpetual Licenses\tText throughout the License Management UI has been updated to make it clear that subscription renewals are no longer available for perpetual licenses. After expiration, a perpetual license can still be used, but you will not have access to later updates for Altium Designer beyond that point (no new features\/functionality), nor will you have access to cloud capabilities delivered through and by the Altium 365 platform.\t\t\t\tFor more information, refer to the\u00a0License Management page.\t\tFeature Made Fully Public in Altium Designer 24.9\tThe following feature is now officially Public with this release:\t\t\t\t\t\t\tAdded Support for Importing Design Directives \u2013 available from 24.3\t\t\t\tAltium Designer 24.8Released: 21 August 2024 \u2013 Version 24.8.2 (build 39)Release Notes for Altium Designer\t    Key Highlights    \t\tPCB Design Improvements\t\t\tSingle Layer PCB Support (Open Beta)\tThis release adds the ability to create a single-layer PCB, with corresponding support in the Layer Stack Manager, PCB and Draftsman documents, and generated outputs.\t\tWith this support, you can now delete either the top or bottom layer from a 2-layer stack in the Layer Stack Manager.\t\t \t\tIn a 2-layer PCB, you can now delete either the Top or Bottom Layer from its layer stack.\t\t\t\t\t\t\t\t\t\t\tA single-layer stack can be created for a PCB but not a footprint.\t\t\t\t\t\t\t\t\t\tWhen the layer stack has a single copper layer, the Via Types tab and the Back Drills feature will not be available in the Layer Stack Manager. Also, you can only create impedance profiles of Single-Coplanar and Differential-Coplanar\u00a0types\u00a0on the Impedance tab of the Layer Stack Manager for a single-layer PCB.\t\t\t\t\t\t\t\t\t\tThe Tools\u00a0\u00bb Presets menu now includes a\u00a0preset for a single-layer stack \u2013 show image.\t\t\t\t\t\t\tIf a PCB has a single signal layer, it will be reflected in the PCB editor user interface (layer tabs, the board&#039;s\u00a0Properties panel, and the View Configuration panel) and in the PCB&#039;s layer stack table and drill table.\t\t\t\tThe removed layer is referenced as a side where applicable. For example, if the bottom\u00a0layer is removed, it is called Bottom Side in the Drill Layer Pair column of a\u00a0drill table, as shown in the image below.\t\t\t\tA single-layer PCB is supported in a Draftsman document and in the following outputs: Gerber, Gerber X2, ODB++, IPC-2581, Pick and Place, NC Drill, Layer Stack Report, and PCB prints.\u00a0\t\t\t\tWhen there are unplated thru-hole pads in a single-layer PCB, they will not be flagged in the\u00a0Unplated multi-layer pad(s) detected section of the DRC report.\t\t\t\t\t\tThis feature is in Open Beta and\u00a0available when the\u00a0PCB.SingleLayerStack.Support\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Defining the Layer Stack\u00a0page.\t\t\t\tPredefined Donut Pad Shapes (Open Beta)\tA\u00a0predefined round\u00a0Donut shape has been added to the listing of pad shapes available when defining the padstack. Use the Shape drop-down in the Properties panel to apply the Donut shape to a pad. The round Donut shape is represented as a full circle arc and is supported in the PCB List panel, Find Similar Objects dialog, and when using expressions. They are also supported on\u00a0Paste\/Solder Mask layers, and also when defining thermal relief connection points to a polygon pour.\t\t\t\tThe outer diameter of the\u00a0round Donut pad shape is represented by\u00a0D\u00a0and the width is represented by\u00a0W in the Properties panel,\u00a0as shown in the above image highlighted in purple. Click in the respective cell to change the values.\t\tRound Donut pad shapes are supported in ODB++, Gerber, Gerber X2, PCB prints, IPC-2581, and DXF\/DWG outputs, and in PCB CoDesigner when comparing PCB documents. Also, round Donut pads are supported when importing an Xpedition design\/library.\t\tWhen defining a pad template, automated naming is applied in accordance with the IPC-7351 standard.\t\t\t\tWhen opening a PCB using Donut-shaped pads in a previous version of the software, the information will be lost. In fact, the Donut shape will simply be converted into a series of arcs.\t\t\t\t\t\tThis feature is in Open Beta and available when the\u00a0PCB.Pad.CustomShape.Donut\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Working with Pads &amp; Vias page.\t\t\t\tRouting Neck-down Rule (Open Beta)\tThis release implements a new routing neck-down design rule to assist you with routing in dense areas of a board.\t\tWith modern component technology, it is not uncommon for a net to be routed at different widths as the routing travels across the board. For example, routing into or out of a BGA will often require escape routes narrower than the preferred width routes allowed by the applied impedance profile.\u00a0The new rule lets you define the maximum allowed total length of such narrower traces so that the route still delivers the required impedance.\t\tThe Routing Neck-Down rule can be defined in both the Physical view of the Constraint Manager and the PCB Rules and Constraints Editor dialog. Use the Neck-Down Length field to define the maximum allowed length of continuous routes (in each net scoped by the rule) whose width is between the Min Width and Preferred Width defined by the applicable Routing Width rule.\t\tMin Width \u2264 Actual Neck-down Width &lt; Preferred Width\t\tAlternatively, use the grid to define the allowed length per layer basis.\t\t\t\tEnable the Routing Neck-Down rule type check for online and\/or batch checking in the Design Rule Checker dialog to detect violations of the Routing Neck-Down rules in corresponding DRC modes. Detected rule violations will be marked with a hatched pattern on corresponding traces in the design space.\t\t\t\t\t\tThis feature is in Open Beta and\u00a0available when the PCB.Rules.RoutingNeckdown option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Routing Rule Types\u00a0page.\t\t\t\tRouting Auto-shrinking (Open Beta)\tIn cases when a trace being routed using the interactive router cannot be routed between obstacles with the currently chosen routing width, this new feature allows to automatically shrink the width to a value that would allow routing of the trace in this location\u00a0(provided that this shrunk trace would not violate the minimum allowed width from the corresponding constraint). Enable the Auto Shrinking option on the PCB Editor \u2013 Interactive Routing page of the Preferences dialog and the Properties panel during interactive routing\u00a0to enable the feature.\t\t\t\tNote that auto-shrinking is not applied in Ignore Obstacles and Stop At First Obstacle routing conflict resolution modes. Learn more about\u00a0Available Routing Conflict Resolution Modes.\t\t\t\t\t\t\t\tThis feature is in Open Beta and\u00a0available when the\u00a0PCB.Routing.EnableAutoShrinking\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Interactive Routing\u00a0page.\t\t\t\tTrace Centering (Open Beta)\tA common desire of many designers is to center the routes when they pass between pads or vias\u00a0whenever possible. The current behavior of the routing engine is to place track segments at the minimum allowed clearance defined in the design rules, leaving the\u00a0task of spreading or centering the routes between the pads.\t\tThe new centering feature helps with the centering process\u00a0by adding an additional clearance between the net being routed or dragged and existing pads\/vias. The routing engine understands that this additional clearance is desired rather than required, so it can take some or all of it back if needed, for example, when pushing a second or third route between the existing pads\/vias. If the routing engine is required to take back some of the clearance, it will take it from both sides of the routing so that it remains centered\u00a0where possible.\t\tThe trace centering behavior can be configured using the new options available on the PCB Editor \u2013 Interactive Routing page of the Preferences dialog and the Properties panel during interactive routing, interactive differential pair routing\u00a0or interactive sliding.\t\t\t\t\t\t\tApply Trace Centering\u00a0\u2013 enables the trace centering functionality. When enabled, the following options are available to configure the functionality:\t\t\t\t\t\t\t\t\t\t\t\tAdjust Vias\u00a0\u2013 when the option is enabled, vias will be pushed to maintain the additional clearance where possible.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTo prevent vias from being pushed by trace centering, you can either:\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tdisable the Adjust Vias option. In this case, centering will not be applied between unlocked vias or\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tdisable\u00a0the Allow Via Pushing option. In this case, vias will not be pushed (even to ensure the minimum clearance from the Clearance constraint).\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAdded Clearance Ratio \u2013 a multiplier of the applicable clearance, which is then added to the clearance. For example, if the applicable clearance is\u00a00.15mm, setting the option to\u00a02\u00a0would instruct the routing engine to clear existing pads and vias by\u00a00.15 + 2*0.15 = 0.45mm\u00a0whenever possible.\u00a0The routing engine can then reduce this clearance down to the specified clearance if required.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tDisable Trace Centering When Dragging\u00a0\u2013\u00a0when the option is enabled,\u00a0trace centering is not applied during interactive sliding (even if the Apply Trace Centering option is enabled).\t\t\t\t\t\tThe trace centering options in the Preferences dialog\t\t\u00a0\u00a0\t\tThe trace centering options in the Properties\u00a0panel\t\t\t\t\t\tAdditional clearance can be added around pads and vias to center the routes.\t\t\t\tThis feature is available in all routing modes, including Any Angle.\t\t\t\t\t\tThis feature is in Open Beta and available when the PCB.EnableTraceCentering option is enabled in the Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Interactive Routing page.\t\t\t\tTrue Zero Mitering (Open Beta)\tDuring interactive routing,\u00a0interactive differential pair routing\u00a0or interactive sliding, a miter is now not created if the Miter Ratio\u00a0value is set to 0\u00a0(in the corresponding Properties panel or in the PCB Editor \u2013 Interactive Routing page of the Preferences dialog), which allows you to create acute corners.\u00a0In previous versions, a short miter fully covered by adjacent traces was created when\u00a0Miter Ratio\u00a0=\u00a00.\t\t\t\tAn example of a zero-miter joint between tracks during interactive routing.\t\t\t\tThis feature is in Open Beta and\u00a0available when the\u00a0PCB.ZeroMitersRemoving\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Interactive Routing page.\t\t\t\tConstraint Manager Improvements\t\t\tModifying Directives Imported from Read-only Documents\tDirectives that have been imported from read-only documents (for example, device sheets and managed sheets) cannot be modified if the Make Device Sheets In Projects Read-Only option is enabled (checked) on the Data Management - Device Sheets page of the Preferences dialog. When the option is disabled (unchecked), the directives can be modified.\t\t\t\tAfter directives have been imported (with the option enabled), the rule is highlighted in blue in the Constraint Manager.\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page. \t\t\t\tAbility to Enable\/Disable Advanced Rules\tYou can now enable\/disable advanced rules that are defined in the All Rules view when the Constraint Manager is accessed from a PCB.\t\tA new Enabled column is now included in the view. The column reflects the state of each\u00a0advanced rule:\u00a0True (enabled) or False (disabled).\u00a0Double-click a cell in the column and toggle the state of a specific advanced rule. Alternatively, toggle the enabled state of advanced rules of a particular type, category, or all advanced rules using commands available from the right-click context menu for the corresponding entry in the Rule Class tree.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: CM_EnableDisableAdvancedRules_AD24_8\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe Enabled column reflects the state of each advanced rule.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tDouble-click a cell in the Enabled column to toggle the state of a specific advanced rule.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tRight-click a rule type entry in the Rule Class tree to enable\/disable advanced rules of this type.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tRight-click a rule category entry in the Rule Class tree to enable\/disable advanced rules in this category.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tRight-click the Rule Class heading to enable\/disable all advanced rules.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page.\t\t\t\tAbility to Configure Constraint Values per Layer\tWhen accessing the Constraint Manager from the schematic, it is now possible to configure the Width and Differential Pairs Routing constraints for layers in a chosen layer stack.\t\tUsing a new drop-down at the top of the Constraint Manager, select\u00a0an entry for a specific PCB document of the design project. If the selected PCB contains multiple layer stacks, you can choose the required stack for which constraints need to be configured using tabs in the lower part of the Constraint Manager when the corresponding rule is selected. Also, you can use a chosen Impedance Profile (where defined as part of the selected PCB\u2019s layer stack).\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page.\t\t\t\tImport\/Export Constraints between Designs\tAdded the ability to export and import constraints between designs. To access this new feature, right-click in the Clearances, Physical, or Electrical view of the Constraint Manager, then select Export \u00bb Export Constraints for selected lines or Import \u00bb Import Constraints.\t\tExporting Constraints\t\tAfter selecting one or more cells in the\u00a0Clearances\u00a0view or one or more lines in the\u00a0Physical\u00a0or Electrical view and then choosing Export \u00bb Export Constraints for selected lines, the Constraints for Export dialog opens with constraints for all objects that have been selected prior to choosing the command listed in the grid.\u00a0Select the constraints you want to export using checkboxes (constraints related to the current view will be selected in the dialog by default). After clicking OK, the selected constraints will be exported into a file with the extension *.CstrDot. The file can then be imported into another design.\t\t\t\tImporting Constraints\t\tAfter\u00a0selecting\u00a0Import \u00bb Import Constraints,\u00a0the standard\u00a0File Explorer\u00a0dialog opens in which you can select a\u00a0*.CstrDot\u00a0file to import. In the\u00a0Constraints for Import\u00a0dialog that opens, select the constraints you want to import from the file, then click\u00a0OK. The selected constraints will be applied to corresponding objects in the target design.\t\t\t\t\t\t\t\t\t\t\t\t\tIf a net\u00a0selected for import does not exist in the target design, an entry for it will be added to the Constraint Manager. Since there is no such net in the design, the entry will be marked with the\u00a0 icon. Constraint values can be copied from this entry and pasted into an existing object. The issue can be resolved by adding a net with the same net to the design and then refreshing the data in the Constraint Manager. Alternatively, an unmatched object can be removed from the Constraint Manager by right-clicking its entry and selecting Delete unmatched object \u2013 show image.\u00a0\t\t\t\t\t\t\t\t\t\tIf a diff pair or xNet\u00a0selected for import does not exist in the target design, it will not be added to the design.\t\t\t\t\t\t\t\t\t\tIf a net \/ diff pair \/ xNet class selected for import does not exist in the target design, it will be added to the design automatically.\t\t\t\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page.\t\t\t\t3D-MID Design Improvements\t\t\tAbility to Drag Multiple Components\tIn a 3D-MID document, you can now drag more than one component. Select multiple components (using the Shift+Click\u00a0shortcut or other selection methods), then use\u00a0Click, Hold&amp;Drag\u00a0on the selection to move all selected components at once.\t\t\t\t\t\tFor more information, refer to the\u00a03D-MID Design page. \t\t\t\tDisplaying the 3D Substrate File Name\tThe name of (and full path to) the 3D substrate file is now presented in the Properties panel. When no object is selected in the 3D-MID document, open the panel&#039;s Parameters tab and locate the\u00a0Pcb 3d Substrate File Name parameter.\t\t\t\t\t\tThe\u00a0Pcb 3d Substrate File Name parameter value will be updated if you change the 3D substrate using the File \u00bb Change Substrate command from the main menus. Note that it will not be updated if the 3D substrate file is renamed (e.g., through the Windows\u00a0File Explorer).\t\t\t\tFor more information, refer to the\u00a03D-MID Design page.\t\t\t\tHarness Design Improvements\t\t\tAbility to Place Draftsman Comments\tThe ability to add comments to a Draftsman document (*.HarDwf) has been added. Comments, which are notes a user adds, can be applied to a point, object, or area and can be replied to by other users. Placement can be done using the Place menu, the right-click context menu, the \u00a0icon at the top right of the design space, or the Ctrl+Alt+C shortcut keys. A comment placed in a Draftsman document is shown in the image below.\t\t\t\tFor more information, refer to the\u00a0Document Commenting page. \t\t\t\tLayout Label Text Display in BOM\tThis release adds the ability to display the text value for a layout label in the BOM. Enable the Label Text column in the ActiveBOM document or the BOM table placed in a Draftsman document to display the layout label text. Note that a layout label is shown in the BOM when its Type is set to Standard.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: HD_LayoutLabelTextBOM_AD24_8\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe Type property of layout labels on the Layout Drawing is set to Standard.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn the ActiveBOM document, use the Properties panel to enable visibility of the Label Text column for the BOM.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn the Draftsman document, use the Properties panel to enable visibility of the Label Text column for the BOM table when it is selected.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Creating the Layout Drawing\u00a0page.\t\t\t\tSupport for Strip Length and Pull Off Length for Crimp-type Cavities\tYou can now specify the\u00a0Strip Length and Pull Off Length when defining a crimp-type cavity in the Wiring Diagram (*.WirDoc).\t\t \t\tBoth properties are included in the wiring list and connection table objects in a Draftsman document (*.HarDwf)\u00a0with column headings as follows:\t\t\t\t\t\t\tFor a wiring list:\t\t\t\t\t\t\t\t\t\t\t\tFromCrimpStripLength\t\t\t\t\t\t\t\t\t\t\t\t\tFromCrimpPullOffLength\t\t\t\t\t\t\t\t\t\t\t\t\tToCrimpStripLength\t\t\t\t\t\t\t\t\t\t\t\t\tToCrimpPullOffLength\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor a connection table:\t\t\t\t\t\t\t\t\t\t\t\tCrimpPullOffLength\t\t\t\t\t\t\t\t\t\t\t\t\tCrimpStripLength\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Defining the Wiring Diagram page.\t\t\t\tPlatform Improvement\t\t\tSwitching to\u00a0.NET 6\tWith this release, Altium Designer switches from using .NET Framework 4.8 to .NET 6. The main reason for the switch is that Microsoft considers the .NET Framework obsolete. Although Microsoft will continue to support it for many years, it will not add any new functionality or features. All new developments and features happen in the .NET Core family that .NET 6 is part of. As a result, the switch is necessary at some point.\t\tAdditionally, .NET 6 is much faster than .NET Framework. In our tests, schematic and Draftsman showed great improvements. Many other areas, such as BOM, compilation, and library creation, show smaller improvements.\u00a0\t\tLastly, we do not need to install any .NET Framework; we can bundle .NET 6 with Altium Designer. This will remove the issues caused by installing the .NET Framework and when Windows updates interfered.\t\t\t\tAny Third Party extensions that were found to be incompatible with .NET 6 have been removed from the software, starting at this release. If later, updated versions of these extensions are made to be compatible with Altium Designer 24.8 (or beyond), contact beta.program@altium.com to get them added back to the installation.\t\t\t\tFor more information, refer to the\u00a0System Requirements page.\t\t\t\tData Management Improvements\t\t\tNew &#039;Number of Pads Exceeds Number of Pins&#039; Check for Components\tAdded the new\u00a0Number of Pads exceeds Number of Pins\u00a0violation type as part of the validation checks that can be configured for a Workspace component. A violation of this type occurs when the number of pads (SMD pads placed on copper layers and plated thru-hole pads) in a footprint model assigned to a component being validated exceeds the number of pins in the component&#039;s schematic symbol model.\u00a0\t\t\t\tIn this example, two violations appear for a component \u2013 one for each footprint where the number of pads exceeds the number of schematic symbol pins.\t\tThe default mode of the\u00a0Number of Pads exceeds Number of Pins\u00a0violation is\u00a0Error. If required, it can be configured on the\u00a0Data Management \u2013 Component Rule Checks page\u00a0of the\u00a0Preferences\u00a0dialog.\t\t\t\tFor more information, refer to the\u00a0Validating a Component page.\t\t\t\tSupport for Item ID Matching to an External DB Parameter\tA database parameter can now be mapped to a Workspace component&#039;s Item ID for a database component synchronization process. Use the Parameter Mapping region of the Properties panel when the required table is selected in the CmpSync document to map the ID parameter to a\u00a0source database parameter. \u00a0\t\t\t\tFor more information, refer to the\u00a0Component Database to Workspace Data Synchronization page.\t\tFeature Made Fully Public in Altium Designer 24.8\tThe following feature is now officially Public with this release:\t\t\t\t\t\t\tAbility to Disable Automatic Update of Drill Symbol Data \u2013 available from 24.6\t\t\t\tAltium Designer 24.7Released: 23 July 2024 \u2013 Version 24.7.2 (build 38)Release Notes for Altium Designer\t    Key Highlights    \t\tSchematic Capture Improvements\t\t\tEnhancement to Multi-part Components\tIf a multi-part component only has primitives defined in one sub-part, the designator suffix is now hidden when that sub-part is placed on a schematic sheet. This is only for alternate display modes; the suffix is always shown for the Normal display mode. Also, it is no longer possible to select a sub-part (or alternate display mode) when that sub-part\/mode has no primitives.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: MiltiPart_DisplayModes_Properties\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAn example of a schematic symbol of a dual op amp component. The normal mode represents the component in two sub-parts. An alternate mode represents the component as a single sub-part.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tOn the schematic sheet, the designator suffix is not shown for the sub-part when it is the only sub-part in the selected alternate mode.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIt is no longer possible to select a sub-part when that sub-part has no primitives.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIt is no longer possible to select a alternate display mode when that mode has no primitives.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the Creating a Schematic Symbol page.\t\t\t\tAdded New Port Violation\tA new violation type has been added to the Violations Associated with Nets category on the\u00a0Project Options dialog&#039;s Error Reporting tab to detect a flat design port\u00a0that does not have a corresponding\/matching port in any source schematic documents. The Port with no matching ports error violation will occur when there is no matching port, or a port is not connected. The default status of the violation is No Report.\t\tThis violation type will only be detected if the Net Identifier Scope\u00a0option on the Options tab of the Project Options dialog is set to either Flat (Only ports global) or Global (Netlabels and ports global).\t\t\t\tFor more information, refer to the Validating Your Design Project page.\t\tAbility to Keep Symbol\/Footprint Unchanged for Alternate Parts\tYou can now choose an alternate part with no changes to a symbol on a schematic or needing to add a footprint to the PCB.\u00a0In the Properties panel, enable the Do not overwrite schematic symbol and\/or Do not overwrite PCB footprint options as needed, as shown in the image below. Parameters for the chosen alternate are faithfully presented in the ActiveBOM.\t\t \t\tFor more information, refer to the Working with the Variant Manager page.\t\tPCB Design Improvements\t\t\tAdded Additional Options to Layer Stack Manager\tParameters have been added to the Layer Stack Manager Properties panel for a few key parameters that are important for Power Integrity simulation. Copper Resistance\u00a0and\u00a0Via Plating Thickness\u00a0can be defined using the Properties panel as part of the properties for a board\u2019s layer stack.\t\t \t\tThese parameters are included when exporting the board into Ansys EDB format.\u00a0The Power Analyzer by Keysight tool also supports the Via Plating Thickness parameter. The value of this parameter is displayed in the\u00a0Configuration\u00a0region of the analyzer document.\t\t \t\tFor more information, refer to the Defining the Layer Stack\u00a0page.\t\t\t\tReturn Path Via Check (Open Beta)\tWhen a high-speed signal passes from one reference plane to another, there should also be return vias to pass the return signals between the planes. In order to check if such a via exists within a specific distance from a signal via, the Return Path rule has been extended with a new Max Stitch Via Distance option with which you can define if a return path via should be present within a given distance\u00a0(a default value is 1.5mm) from a via of the scoped signal. The return path via should provide connection to the reference layer defined in\u00a0Layer Stack Manager\u00a0for the corresponding impedance profile.\t\t\t\tAn example of the max stitch via distance constraint configured in the Constraint Manager\t\t\t\tAn example of the max stitch via distance constraint configured in the PCB Rules and Constraints Editor dialog\t\tWhen the Max Stitch Via Distance\u00a0option is enabled in the rule and a non-zero value is defined for it, the presence of a return path via within the specified distance is checked as part of the Batch DRC.\t\t\t\tAn example of the max stitch via distance constraint violation. Here, a via of net\u00a0DQS4R_N\u00a0has no return path via at the specified distance.\t\t\t\tThis feature is\u00a0in Open Beta and available\u00a0when the\u00a0PCB.Rules.CheckReturnPathVia\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\tFor more information, refer to the\u00a0High Speed Design page.\t\t\t\tEnhanced Trace Loop Removal (Open Beta)\t\t\t\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\t\t\tIntroduced a new implementation of automatic loop removal in the Interactive Router. This update improves behavior when using the loop removal functionality when routing using the\u00a0Any Angle corner style, improves behavior of via removal after loop removal (see below), and lays the foundation for future enhancements.\t\t\t\t\t\t\t\tRemove Via After Loop Removal\t\tWhen there is a direct via-to-pad connection, the via will now be removed if deemed no longer needed after loop removal (provided the Remove Loops With Vias option is enabled in the Properties panel for interactive routing).\t\t\t\t\t\t\t\tThis feature is in Open Beta and available when the\u00a0Legacy.PCB.Routing.LoopRemoval\u00a0option is disabled in the\u00a0Advanced Settings dialog.\t\tFor more information, refer to the\u00a0Interactive Routing and\u00a0Differential Pair Routing\u00a0pages.\t\tPCB CoDesign Improvement\tAdded Ability to Leave Feedback to Altium\tA Leave Feedback control has been added to the PCB CoDesign panel, allowing you to send feedback directly to Altium Developers with suggestions or issues related only to the PCB CoDesign feature.\t\t\t\tFor more information, refer to the PCB CoDesign\u00a0page.\t\t\t\tConstraint Manager Improvements\t\t\tImport\/Export of Constraint Sets between Designs\tThis feature allows you to import and export constraint sets, which enables you to\u00a0quickly reuse constraint information between different board designs. To access this new feature, right-click in the Clearances, Physical, or Electrical view of the Constraint Manager, then select Export Constraint Sets or Import Constraint Sets.\t\tExporting Constraint Sets\t\tAfter selecting\u00a0Export Constraint Sets, the Constraint Sets for Export dialog opens with all constraint sets that are currently present in the design listed in the grid. Select the constraint sets you want to export using checkboxes, then click OK.\u00a0The selected constraint sets will be exported into a file with the extension *.CstrDot. The file can then be imported into another design.\t\t\t\tImporting Constraint Sets\t\tAfter\u00a0selecting\u00a0Import Constraint Sets,\u00a0the standard File Explorer dialog opens in which you can select a *.CstrDot\u00a0file to import. In the Constraint Sets for Import dialog that opens, select the constraint sets you want to import from the file, then click OK. Imported constraint sets can be inspected in the Properties panel when the corresponding view of the Constraint Manager is selected and can be applied to objects.\t\t\t\tFor more information, refer to the Defining Design Requirements Using the Constraint Manager\u00a0page.\t\t\t\tGlobal Option to Ignore Pad-to-Pad Clearance within Footprint\tA new global option allows you\u00a0to specify whether clearances between pads in the same component footprint are ignored. The option is available from the Clearances and Physical views when the Constraint Manager is accessed from either the schematic or PCB.\u00a0Toggle the\u00a0Ignore Pad to Pad clearances within a footprint option\u00a0in the Clearances Settings region of the Properties panel to apply the setting to all defined clearance rules.\t\t \t\tFor more information, refer to the Defining Design Requirements Using the Constraint Manager\u00a0page.\t\t\t\tHarness Design Improvements\t\t\tDisplay Options for Cavities in Connection Table\tYou now have the ability to control the type of cavities that are displayed in a Connection Table of a Harness Manufacturing document (*.HarDwf). Use the Display drop-down in the Properties panel to select the desired cavities to be displayed:\t\t\t\t\t\t\tWires Only\u00a0\u2013 show only pins that have wires connected to them\t\t\t\t\t\t\tWires &amp; Parts\u00a0\u2013 show pins that have wires connected to them and any cavity parts added such as a plug in case of a sealed connector with no wire\t\t\t\t\t\t\tAll Cavities\u00a0\u2013\u00a0show all pins of all components, irrespective of connected wires and added cavities\u00a0(for example if there\u00a0is a 10-pin component,\u00a0all the 10 pins will be shown in the table)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: HD_MD_ConnectionTable_Display_AD24_7\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Creating a Manufacturing Drawing for a Harness Design page.\t\tAbility to Place Comments\tThe ability to add comments to a Wiring Diagram (*.WirDoc) and Layout Drawing (*.LdrDoc) has been added. Comments, which are notes a user adds, can be applied to a point, object, or area on a document and may be replied to by other users. Placement can be done using the Place menu, the right-click context menu, the\u00a0 icon at the top right of the design space, or the Ctrl+Alt+C shortcut keys. A placed comment in a Layout Drawing is shown in the image below.\t\t\t\t\t\tThis feature is controlled by the\u00a0Harness.Comments\u00a0advanced option in the Advanced Settings dialog\u00a0and is enabled by default.\u00a0\t\tFor more information, refer to the\u00a0Document Commenting page.\t\tData Management Improvement\t\t\tRenamed &#039;Clone&#039; Menu Command\tThe Clone command has been renamed Make a copy throughout the UI to clarify its function. The images below are examples of a few locations.\t\t\u00a0 \u00a0\u00a0\t\t\t\tImport\/Export Improvement\t\t\tOptions to Define Parameter Mapping for xDX Designer Imports\tThe Mentor xDX Designer Import Wizard now includes options that allow you to define substitution parameters for component mapping for Footprint, Designator, Comment,\u00a0and Description. You can list multiple parameters in the text box by using &quot;;&quot; as a separator, as shown in the image below.\u00a0If the first parameter does not exist, the next will be used in sequence.\t\t\t\tFor more information, refer to the\u00a0Importing a Design from xDX Designer page.\t\tFeature Made Fully Public in Altium Designer 24.7\tThe following feature is now officially Public with this release:\t\t\t\t\t\t\tPad Corner Radius\/Chamfer as an Absolute Value - available from 24.3\t\t\t\tAltium Designer 24.6Released: 18 June 2024\u00a0\u2013 Version 24.6.1 (build 21)Release Notes for Altium Designer\t    Key Highlights    \tPCB Design Improvement\t\t\tAbility to Disable Automatic Update of Drill Symbol Data (Open Beta)\tTo improve performance, the automatic (live) update of drill symbols is now disabled.\t\t\t\t\t\t\tTo update drill symbol data in the PCB panel in its\u00a0Hole Size Editor mode,\u00a0right-click within a region of the panel in this mode and select the Refresh command.\t\t\t\t\t\t\tTo update drill symbol data in a drill table, click the Refresh button in the Actions region of the Properties panel when the drill table is selected.\t\t\t\t\t\tThe drill symbol data is updated automatically when saving the PCB document and for any outputs that contain this data.\t\t\u00a0\t\t\t\tThis feature is in Open Beta and available when the\u00a0PCB.LiveDrillSymbols\u00a0option is disabled in the\u00a0Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Working with Pads &amp; Vias\u00a0and\u00a0Including Design Details pages.\t\t\t\t3D-MID Design Improvements\t\t\tSupport for Fills and Regions in Footprints\tAdded support for the placement of components onto a substrate when footprints contain not just standard pads but also solid regions and\/or fills. This enables you to place components with more complex-shaped footprints onto your substrates, including RF shapes (e.g., antennas).\t\t\t\t\t\tFor more information, refer to the\u00a03D-MID Design page.\t\t\t\tSupport Routing Along &#039;Natural&#039; Lines\tAdded the ability to route along more &#039;natural&#039; lines on the surface of the 3D substrate by using the new \u2018UV\u2019 Plane Kind for the alignment grid. Rather than the more rigid grids generated using the traditional XYZ planes, the UV plane generates a grid based on the surfaces of the substrate, providing more natural gridlines that follow the curves of the substrate.\t\tWhen no object is selected in the design space of the 3D-MID document, select UV from the Plane Kind drop-down in the Alignment grid region of the Properties panel to select the new plane kind.\u00a0\u00a0\t\t\t\t\t\tFor more information, refer to the\u00a03D-MID Design page.\t\t\t\tAbility to Override Snapping Priority\tThe ability to override snapping priority has been added, making it possible to snap to the grid rather than to that trace&#039;s centerline when routing to\/from an existing trace.\u00a0The snapping priority controls are accessed using the Objects for snapping button () on the Active Bar.\t\t \t\t\t\tFor more information, refer to the\u00a03D-MID Design page.\t\t\t\tData Management Improvements\t\t\tAdded Ability to Preserve Lifecycle State when Releasing\tAdded ability to preserve a component&#039;s current lifecycle state when releasing into a new revision in the connected Workspace from the Component Editor (in its Single Component Editing or Batch Component Editing mode).\u00a0Control is provided courtesy of a new option \u2013 Preserve lifecycle state (not recommended) \u2013 available in the Edit Revision dialog when re-releasing.\t\t \t\tThis ability is available for\u00a0those with assigned Allow to skip lifecycle state change for new revisions operational permission (learn more about Setting Global Operation Permissions for a Workspace).\t\t \t\t\t\tFor more information, refer to the\u00a0Building &amp; Maintaining Your Components and Libraries page.\t\t\t\tAdded Favorite Filters in the Manufacturer Part Search Panel\t&#039;Favorite filter&#039; functionality has been added to the Manufacturer Part Search panel, which allows you to select certain parameter types as favorites. Once selected, they move to the top of the list in the current component category. To select a favorite, hover to the right of a parameter filter\u2019s name, then click the star icon.\u00a0Favorite filter settings apply to and are saved for individual component categories.\t\t\t\t\t\tFor more information, refer to the\u00a0Searching for Manufacturer Parts page.\t\t\t\tSupport SiliconExpert Data in Non-Workspace Projects\tColumns of data from SiliconExpert can now be added to the ActiveBOM document not only\u00a0of a project hosted in the connected Workspace but also a non-Workspace project.\t\t\t\tFor more information, refer to the\u00a0Pulling Part Data from SiliconExpert page.\t\t\t\tImport\/Export Improvements\t\t\tKiCad Importer Improvement\tYou can now import KiCad designs created using KiCad version 7 or 8 software into Altium Designer.\t\t\t\tFor more information, refer to the\u00a0Interfacing to Other Design Tools page.\t\t\t\tAnsys EDB Exporter Improvements\tWhen exporting a PCB into Ansys EDB format, net classes and differential pairs are now\u00a0supported and the &#039;Negative&#039; attribute is now disabled for plane layers.\t\t\t\tFor more information, refer to the\u00a0Exporting a Design to Ansys EDB Format page.\t\t\t\tRebranded SiSoft to MathWorks\tIn accordance with external rebranding, SiSoft has been replaced with MathWorks throughout the UI (in the File \u00bb Export main menu of the PCB editor, the Add New Export Output menu in an OutJob file, the exporter on the Configure Platform page of the Extensions and Updates view, and the Altium Designer installation wizard).\t\t\t\tBackward compatibility of defined MathWorks outputs in an OutJob file in Altium Designer 24.6 (and later) is not supported. As such, outputs will not be visible when opening the OutJob in an older version of Altium Designer. SiSoft outputs configured in an OutJob file in a previous version of Altium Designer will, however, be transformed into MathWorks outputs when the file is opened in Altium Designer 24.6 (and later).\t\t\t\tFor more information, refer to the\u00a0Exporting a Design to MathWorks CSV Format page.\t\tAltium Designer 24.5Released: 22 May 2024 \u2013 Version 24.5.2 (build 23) HotFix 1Release Notes for Altium Designer\t    Key Highlights    \tSchematic Capture Improvement\t\t\tAutomatic Addition of Supply Nets Rule (Open Beta)\tWhen updating the PCB document, the Supply Nets design rule is now suggested to be added to each power net (i.e. a net containing a power port or that has been assigned the\u00a0Power Net parameter through a parameter set).\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: SchSupplyNetsRule_AD24_5\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tA Supply Nets rule is added to a net with an attached power port object.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tA Supply Nets rule is added to a net with an attached parameter set for which the Power Net option is enabled.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThis feature is in Open Beta and available when the\u00a0Schematic.AutoGenerateSupplyNetsRule\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Signal Integrity Rule Types page.\t\t\t\tPCB Design Improvement\t\t\tFootprint Mirroring Prevention (Open Beta)\tThis release adds measures to prevent inadvertent mirroring of a footprint along its X\/Y axes, typically the result of using the associated keyboard shortcuts to mirror a component or the room to which it has been associated. Such mirrored footprints can, if undetected, lead to costly re-spins. To cater for early detection of such mirroring, the following have been implemented:\t\t\t\t\t\t\tA new warning dialog is presented when using a keyboard shortcut to mirror a component\/room that asks you to explicitly confirm that mirroring on the same side of the board is indeed what you truly mean to do. By default, the No\u00a0button is highlighted, making it more of a conscious decision to\u00a0click Yes to proceed with mirroring.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tA new Components with Mirrored Footprints\u00a0check (disabled by default) has been added to the Components region of the PCB Health Check Monitor (which is configured on the Health Check tab of the Properties panel when no object is selected in the PCB document), which detects changes in pins between a placed component footprint in the PCB design space and the corresponding footprint in the applicable source library. You can fix such an issue, which removes mirroring for the placed footprint instance so that it is the same as defined in the source library.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tNote that only mirroring-related elements (pins, overlays and 3D bodies) are considered when applying the fix. Other changes to the placed component footprint, such as rotation, remain untouched.\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe Update From PCB Libraries tool (Tools \u00bb Update From PCB Libraries) has been enhanced to detect changes in designators and 3D bodies (across all layers), with differences listed on the Properties tab. Fixes to inadvertent mirroring of footprints effected through an ECO generated from the tool are exactly the same as those applied from the Health Check Monitor.\t\t\t\t\t\t\t\t\t\t\t\tThe Footprint Comparison Report that can be generated from the Update From PCB Libraries tool (or through an OutJob) has also been enhanced to support the \u2018mirrored footprint detection\u2019 \u2013 show image.\t\t\t\t\t\t\t\t\tThis feature is in Open Beta and available when the\u00a0PCB.Component.MirroredFootprint\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\t\t\tFor more information, refer to the\u00a0Simple Placement,\u00a0PCB Health Check Monitor, and\u00a0Updating Footprints from Libraries pages.\t\t\t\t\t\tODB++ Improvements (Open Beta)\tThis release sees enhancements\u00a0in ODB++ output generation described below.\t\tAbility to Switch between ODB++ Versions\t\tThis feature allows you to switch between ODB++ version 8.1 and legacy version 7.0. Use the ODB++ Version option in the ODB++ Setup dialog to select the required version.\t\t\t\t\t\tWhen the feature&#039;s advanced option is disabled, ODB++ version 8.0 formatted outputs are generated.\t\tWhen the v. 8.1\u00a0option is selected as the ODB++ Version in the\u00a0ODB++ Setup dialog, you can select Millimeters or Inches as the Units. When the v. 7.0\u00a0option is selected, Inches are selected by default and cannot be changed.\t\tSupport for Design Variants\t\tWhen generating ODB++ version 8.1 formatted outputs, information about all\u00a0design variants\u00a0(including &#039;No Variations&#039;) can be included by enabling the\u00a0Include\u00a0Variants Data\u00a0option in the\u00a0ODB++ Setup dialog.\t\t\t\tWhen this option is enabled, the following information is included in the outputs:\t\t\t\t\t\t\tState of each component inside any exported variant\u00a0(fitted \/ not fitted).\t\t\t\t\t\t\tInformation about alternate part(s) on the component level for any exported variant.\t\t\t\t\t\t\tParameters of each component according to the variation.\t\t\t\t\t\t\tCustom parameters applied to each variant\/component.\t\t\t\tWhen this option is disabled, the output is generated for the variant selected in the Outjob file or, when the output is generated directly from the PCB editor (File \u00bb Fabrication Outputs\u00a0\u00bb ODB++), the currently active variant selected in the Projects panel.\t\t\t\t\t\t\t\t\t\t\tWhen ODB++ generation is configured from an Outjob file, and\u00a0the\u00a0Include\u00a0Variants Data\u00a0option is enabled, all design variants are included in the ODB++ output, irrespective of which variant is selected for the Outjob file or for the output.\t\t\t\t\t\t\t\t\t\tNote that\u00a0variations for paste masks\u00a0are not considered. If paste mask variations should be included, make sure that the Allow Variation for Paste Mask option is enabled in the settings of required variants and generate outputs for each variant individually, with the\u00a0Include\u00a0Variants Data\u00a0option disabled in the\u00a0ODB++ Setup dialog.\t\t\t\t\t\t\tSupport for Layer Subtypes\t\tTo provide support for rigid-flex PCB manufacturing, information about rigid and flex layer subtypes is included when generating ODB++ version 8.1 formatted outputs. The following layer subtypes are supported:\t\t\t\t\t\t\tCOVERLAY \u2013 clearances of a coverlay layer.\t\t\t\t\t\t\tSTIFFENER \u2013\u00a0shapes and locations where stiffener material is placed on the PCB.\t\t\t\t\t\t\tBEND_AREA \u2013 for labeling areas on the PCB bent when the PCB is in use.\t\t\t\t\t\t\tFLEX_AREA \u2013\u00a0stores the geometries of the flex portions of the board.\t\t\t\t\t\t\tRIGID_AREA \u2013\u00a0stores the geometries of the rigid portions of the board.\t\t\t\t\t\t\tSIGNAL_FLEX \u2013\u00a0signal (copper) layer on flex laminate. Used to distinguish from signal on rigid laminate in rigid-flex boards.\t\t\t\t\t\t\tPG_FLEX \u2013\u00a0power and ground (copper) layer on flex laminate. Used to distinguish from power and ground layer on rigid laminate in rigid-flex boards.\t\t\t\tSupport for Zones\t\tWhen generating ODB++ version 8.1 formatted outputs for rigid-flex boards, the zones file\u00a0is now generated. The resulting zones file (located in the \\steps\\pcb folder of the generated output) contains information about all of the zones (board regions) defined in the design, including layers involved and coordinates for each zone\u2019s outline.\t\tSupport for Geometry on the Stiffener Layer\t\tWhen generating ODB++ output in v8.1 format, support has been added for generating geometry information (profile and thickness) on the stiffener layer\u00a0\u2013 show image.\t\tUpdates for Backdrill Generation\t\tIn order to correctly treat backdrills, they are now stopping in the previous layer to that defined in the Layer Stack Manager in generated ODB++ version 8.1 formatted outputs.\t\t\t\tThis feature is in Open Beta and available when the\u00a0ODB.Improvement\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Preparing Fabrication Data page.\t\t\t\tConstraint Manager Improvements\tImporting Directives Enhancements\t\t\t\t\t\tThe new Import values to Constraint Manager dialog\u00a0displays a summary of the import from the schematic to the Constraint Manager that will be completed by clicking the Import button in the dialog. The dialog is accessed by right-clicking in the Constraint Manager (when accessed from a schematic document). Click the Import button to import the listed changes to the Constraint Manager.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tDirectives that have been imported are displayed in blue, and the symbols for a parameter set and differential pairs have been updated, as shown below.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWhen directives have been imported, the Properties panel now displays the rules from the Constraint Manager, as shown below.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page.\t\tSupport for xNets on PCB Side\tAdded support for creating xNets and xNet classes in the Constraint Manager, when accessed from the PCB.\t\t\t\tDefined xNets and xNet classes can be propagated between the PCB and schematic sides through the bidirectional ECO process.\t\t\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page.\t\tCreate xSignals Automatically for 2-pin Nets\txSignals are now automatically created for 2-pin nets. When the Custom topology is selected for a 2-pin net, its pins are automatically added as nodes to the topology editing area, and the proposed xSignal is automatically selected.\u00a0\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page.\t\t\t\tHarness Design Improvements\t\t\tAdded BOM Control for Harness Objects\tA Type field has been added to various objects in the Wiring Diagram (*.WirDoc) and Layout Drawing (*.LdrDoc) to control inclusion in the BOM. Use the drop-down associated with the field in the Properties panel, then choose the desired option: Standard or Standard (No BOM). The objects for which this control is available are listed below.\t\tWiring Diagram\t\t\t\t\t\t\tHarness Wire\t\t\t\t\t\t\t\t\t\tHarness Cable\t\t\t\t\t\t\t\t\t\tShield\t\t\t\t\t\t\tLayout Drawing\t\t\t\t\t\t\tHarness Covering\t\t\t\t\t\t\t\t\t\tLayout Label\t\t\t\t\t\t\t \t\t\t\tFor more information, refer to the\u00a0Defining the Wiring Diagram and Creating the Layout Drawing pages.\t\t\t\tAdded Support for Templates in a Workspace\tSupport has been added for creating, uploading, editing, and reusing Harness Wiring Diagram and Harness Layout Drawing templates in a connected Altium 365 Workspace.\t\tUse the Data Management \u2013 Templates page of the Preferences dialog to manage your templates. Use the Harness Wiring and Harness Layout commands in the drop-down of the Add button to add a new template of the corresponding type or use the right-click menu to manage existing templates.\t\t\t\tThe\u00a0Harness Wiring Template and Harness Layout Template content types and\u00a0Harness Wiring Templates and\u00a0Harness Layout Templates folder types provide for storing templates of corresponding types in the Workspace.\t\t\t\tFor more information, refer to the\u00a0Creating Harness Template Documents page.\t\t\t\tSingle Wire Color Parameter Visibility\tSecondary and tertiary color parameters that are assigned to a wire in the Wiring Diagram (*.WirDoc) no longer have a separate visibility icon in the Properties panel. The Color parameter controls the visibility of the parameter and displays the combined value of all defined wire colors, as shown in the image below.\u00a0\t\t \t\t\t\tFor more information, refer to the\u00a0Defining the Wiring Diagram page.\t\t\t\t\t\tAdded &#039;Include Cut&#039; Parameter to Wires\tA new Include Cut parameter has been added to the wire object. The parameter controls whether to include the wire in the Wiring List that is placed in a Harness Draftsman document (*.HarDwf). By default, the Value for this parameter is Yes (include); change the Value to No to exclude. The parameter is added automatically for a newly placed wire. The parameter must be added manually for existing wires if you do not want them included in the Wiring List.\t\t\t\t\t\tFor more information, refer to the\u00a0Defining the Wiring Diagram page.\t\t\t\tData Management Improvements\tPreventing Saving Files in Conflict States to Workspace\tWhen attempting to use the Save to Server command when local conflicts still exist (i.e. a project contains files in the state now called Conflict Prevention, with the  VCS icon in the Projects\u00a0panel), the new Action Required information dialog will be presented, listing the conflicting file(s) that need resolution. Such files will now have the Conflict Detected state with the  VCS icon. Use the VCS content menu of a document in the\u00a0Conflict Detected state to resolve the conflict by updating the document with its latest revision from the Workspace or by using the local document.\t\t\t\t\t\tFor more information, refer to the\u00a0Saving Projects and Documents page.\t\t\t\tUpdated VCS Context Menus\tThe context menu accessed by clicking the version control status icons in the Projects panel has been updated with more focused actions that can be performed, depending on the type of document\u00a0for documents in\u00a0Modified, Out of date and Conflict Prevention states.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Pnl_Projects_VCSMenu_AD24_5\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe VCS context menu of documents in\u00a0Out of date, Conflict Prevention and\u00a0Conflict Detected states includes a new Open Remote Document Version command that opens the latest document revisions from the Workspace in a new document tab.\t\tFor schematic and PCB documents in\u00a0Modified, Out of date, Conflict Prevention, and\u00a0Conflict Detected states, the menu also includes a command to compare the local document with the\u00a0latest document revisions in the Workspace using the Workspace&#039;s schematic comparison functionality for a schematic document or the PCB CoDesign functionality for a PCB document.\t\t\t\t\t\t\t\t\t\t\tFor documents\u00a0that have a graphical design space (schematic document, Draftsman document, etc.), a notification banner that shows the document&#039;s\u00a0Out of date, Conflict Prevention or Conflict Detected VCS\u00a0state and provides controls to perform appropriate actions is now presented at the bottom of the design space \u2013 show image.\t\t\t\t\t\t\t\t\t\tWhen a project contains only documents in Out of date and No Modification states, an Update from Server\u00a0control now appears next to the project name in the Projects panel. Click the control to retrieve the latest documents of outdated files from the Workspace \u2013 show image.\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Managing Project Documents page.\t\t\t\tSupport for Pulling Part Data from Z2Data\tIn this release, support for pulling advanced parametric data for parts from Z2Data has been added.\u00a0If you have access to the Z2Data integration functionality, you can pull high-quality data provided by Z2Data for manufacturer parts, such as part parameters and alternatives. The Z2Data integration provides advanced comprehensive supply chain and component data, including detailed part datasheet, lifecycle data, RoHS &amp; REACH status, and Z2Data\u2019s proprietary 6-point part scoring algorithm.\t\t\t\tThe Z2Data integration is paid functionality that is currently in the early access stage. To become an early adopter of the functionality, contact Altium using the form on the\u00a0Altium 365 Z2Data Integration page.\t\t\t\tNote that after gaining access to the functionality, the Z2Data application must be configured on the\u00a0Admin \u2013 Apps page\u00a0of your Altium 365 Workspace&#039;s browser interface \u2013\u00a0learn more.\t\t\t\t\t\tFor more information, refer to the\u00a0Pulling Part Data from Z2Data page.\t\t\t\tAdded SiliconExpert Datasheet References\tDatasheets provided by SiliconExpert can now be accessed from Altium Designer.\t\t\t\t\t\t\tThe Manufacturer Part Search panel lists a datasheet from SiliconExpert in the Datasheets region when the manufacturer part is selected.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe Datasheet button in part choices and solutions in ActiveBOM opens a datasheet from SiliconExpert.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tDatasheets provided by SiliconExpert are presented by default. Therefore, there is no need to request SiliconExpert data for a part (and hence, use the quota from your SiliconExpert package) to access a SiliconExpert datasheet for it.\t\t\t\tFor more information, refer to the\u00a0Pulling Part Data from SiliconExpert page.\t\tFeature Made Fully Public in Altium Designer 24.5\tThe following feature is\u00a0now officially Public with this release:\t\t\t\t\t\t\tSupport for Draftsman Documents in Multi-board Projects \u2013\u00a0available from 24.1\t\t\t\tAltium Designer 24.4Released: 16 April 2024 \u2013 Version 24.4.1 (build 13)Release Notes for Altium Designer\t    Key Highlights    \tSchematic Capture Improvement\t\t\tUse of Multi-part Components with Alternate Modes\tThis release announces support for presenting a multi-part component as either a single symbol (all sub-parts) or multiple symbols (one for each individual sub-part) using only a single component through defined Normal and Alternate Modes.\t\t\t\tAn example of a schematic symbol of a dual op amp component. The normal mode represents the component in two symbols. An alternate mode represents the component as a single symbol.\t\tNow, if a component has sub-parts without primitives, not placing these sub-parts on the schematic will no longer cause an Unused sub-part in component violation when running a design validation (provided parts with no primitives are listed below all parts that have primitives in the list of symbol parts that can be seen in the SCH Library panel).\t\t\t\t\t\tFor more information, refer to the\u00a0Creating a Schematic Symbol page.\t\t\t\tPCB Design Improvements\t\t\tSelection Box for Component &#039;Push&#039; and &#039;Avoid&#039;\tUser-defined geometries for the component selection bounding box (following the PCB.ComponentSelection\u00a0advanced setting \u2013\u00a0learn more) are now observed when moving a component in Push\u00a0or\u00a0Avoid Obstacles mode.\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Advanced Placement Tools page.\t\tAdded &#039;Obey Rules&#039; Option for Polygon Pour Properties\tFor a placed solid polygon pour, a new Obey Rules option is available as part of its properties, which is used when removing necks less than a certain width. Enabled by default for new polygons, it takes the value from the applicable minimum Width constraint.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: PolygonPour_ObeyRules\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWhen the Obey Rules option is disabled for a\u00a0polygon pour, the minimum width of allowed necks\u00a0is determined by the Remove Necks Less Than field. In this example, this value is 0.12mm, and necks of approximately\u00a00.14 mm are allowed.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWhen the Obey Rules option is enabled, the\u00a0minimum width of allowed necks\u00a0is determined by the minimum width value from the applicable Width constraint. In this example, this value is 0.15mm, and necks less than this value are removed.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Polygons on Signal Layers page.\t\t\t\tConstraint Manager Improvements\tAdded Indication of Sync Status with Directives\tThis release adds an indicator of sync status between a constraint in the Constraint Manager and the equivalent defined in a directive placed on a schematic.\t\t\t\t\t\t\tWhen an object in the schematic has a parameter set or differential pair directive placed on it, and this directive has constraint values that differ from values defined for the same object in the Constraint Manager, these values will be marked with an orange bar at the left side of the corresponding cell in the\u00a0Physical or Electrical view of the Constraint Manager\u00a0when the\u00a0Constraint Manager\u00a0is accessed from a schematic (e.g., ).\t\t\t\t\t\t\tWhen values of the constraint are in sync between the Constraint Manager and the directive, the indication changes to a green bar (e.g., ).\t\t\t\tWhen the object has no existing constraints, use the\u00a0Import from Directives\u00a0command from the right-click menu of the view to import data from directives to the Constraint Manager. Note that if a constraint value that has been synchronized with a directive is edited in the Constraint Manager after using the\u00a0Import from Directives\u00a0command, it will not be synchronized after subsequently using the\u00a0Import from Directives\u00a0command again.\t\t\t\tNote that after synchronizing data by importing data from directives to the Constraint Manager\u00a0and saving changes in the Constraint Manager,\u00a0the controls to add a new or edit\/remove an existing net class, diff pair class, components class, or rule will be grayed out in the Properties panel for the corresponding\u00a0directives.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: CM_ImportFromDirectives_SyncIndication\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tNet A00 has a Parameter Set directive placed on it, and this directive has a Width constraint assigned.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn the Physical view of the\u00a0Constraint Manager, cells related to width constraints of net A00 have an orange bar that indicates these values are not in sync with the directive.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAfter using the\u00a0Import from Directives\u00a0command, data from directives are imported to the Constraint Manager, and the cells now\u00a0have a green bar that indicates that these values are in sync with the directive.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tNote that in directive properties, controls to add, edit and remove classes and rules are now\u00a0grayed out.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager\u00a0page.\t\tPropagating Width\/Gap Values\tFrom the Physical view of the Constraint Manager, a value entered in the top grid for a single net or xNet (Min Width or Preferred Width), differential pair (Min Width, Preferred Width, or Preferred Diff Pair Gap), or net\/xNet\/diff pair class will now be propagated to corresponding width (Min Width\/Preferred Width\/Max Width) or gap (Min Gap\/Preferred Gap\/Max Gap) fields in the constraint regions below. Note that an entered value will be propagated to\u00a0other fields only if the object does not have the specific rule defined.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: CM_PropagateWidth\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tNet A00 currently has no width constraint\u00a0assigned (i.e.\u00a0these constraints are inherited from the All Nets net class).\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAfter entering a value for the\u00a0width constraint of the net (the Min Width constraint in this example)...\u00a0\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t...the value propagates to other fields of the width constraint (Preferred Width and Max Width).\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager\u00a0page.\t\t\t\tDraftsman Improvement\tShow Only Not Fitted Components in BOM Table\tSupport is now available for placing a BOM table into a manufacturing drawing created for a PCB design project (*.PCBDwf), presenting only those components that are Not Fitted for the currently selected\u00a0design variant. To do this, select the Not Fitted option from the Show Components drop-down in the Properties panel for the selected BOM table.\t\t\u00a0\t\t\t\tYou can also select the\u00a0Replaced\u00a0option from the drop-down to show only components for which alternate parts have been selected or fitted components with varied parameter values in the current variant.\t\t\t\tCurrently, a BOM table with the Fitted, Not Fitted or Replaced options selected for Show Components works with Base and Flat\u00a0options for View Mode (not Consolidated).\t\t\t\tFor more information, refer to the\u00a0Bill Of Materials page.\t\t\t\tData Management Improvements\tShow Real Value for SiliconExpert YTEOL Parameter\tWhen a part has the YTEOL parameter provided by SiliconExpert with a value greater than 5 years, the real value of this parameter is now presented in all places where summary data on the part is presented (e.g., the header of the\u00a0Details\u00a0pane in the\u00a0Manufacturer Part Search\u00a0or Components panel, or part choices) instead of the 5+ years entry.\t\t\t\t\t\tFor more information, refer to the\u00a0Pulling Part Data from SiliconExpert\u00a0page.\t\tReferences to SiliconExpert Compliance Datasheets\tAdded support for references to SiliconExpert compliance datasheets to various places where SiliconExpert data can be used, including ActiveBOM (*.BomDoc), Manufacturer Part Search,\u00a0Components,\u00a0and\u00a0Explorer panels, and when generating a BOM output (in PDF or Excel format) through an Output Job.\t\t\t\tAn example of accessing a compliance datasheet from an ActiveBOM document.\t\t\t\tAn example of accessing a compliance datasheet from the\u00a0Manufacturer Part Search panel.\t\t\t\tFor more information, refer to the\u00a0Pulling Part Data from SiliconExpert\u00a0page.\t\tDisplay Item Name for Workspace Content\tFor a Workspace content type that can be directly edited, the name of the item being created, cloned or edited is now shown in the Projects panel and the document tab, rather than its Item-Revision ID.\t\t\t\tAn example of editing Workspace content (schematic snippet, managed schematic sheet, component template, Draftsman sheet template, and layerstack) and displaying item names in the Projects panel and document tab.\t\t\t\tFor more information, refer to the\u00a0Creating &amp; Editing Content\u00a0page.\t\tAdded Support for Latest MS Access Database File Format\tWhen using Database to Workspace component synchronization (*.CmpSync) and part supplier synchronization (*.PrtSync), files in the latest MS Access database format (*.accdb) can now be used as the data source.\u00a0\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: accdb_support_AD24_4\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Component Database to Workspace Data Synchronization\u00a0and Supply Chain Database to Workspace Data Synchronization pages.\t\tFeatures Made Fully Public in Altium Designer 24.4\tThe following features are now officially Public with this release:\t\t\t\t\t\t\tRendering of Self-intersected Regions\u00a0\u2013 available from 22.8\t\t\t\t\t\t\tPreventing Self-Intersections\u00a0\u2013 available from 22.8\t\t\t\t\t\t\tAbility to Inherit a Component Template\u00a0\u2013 available from 23.10\t\t\t\tAltium Designer 24.3Released: 19 March 2024 \u2013 Version 24.3.1 (build 35)Release Notes for Altium Designer\t    Key Highlights    \tPCB Design Improvements\t\t\tPad Corner Radius\/Chamfer as an Absolute Value (Open Beta)\tIn this release,\u00a0the ability to define pad corner radius\/chamfer as an absolute value (in mil or mm) has been added.\t\tWhen a pad of the Rounded Rectangle or Chamfered\u00a0Rectangle shape (on a copper, paste or solder\u00a0layer) is selected in the PCB or PCB Footprint editor, enter a value to the Corner Radius\u00a0field to define the radius\/chamfer as an absolute value (with the default measurement units). Note that the absolute value of the pad corner radius\/chamfer must be less than or equal to half of the shortest pad side. The calculated percentage value will be shown at the right of the field.\t\t\t\tEnter a value to the Corner Radius field to define it as an absolute value.\t\tEnter a value followed by the % symbol to define the radius\/chamfer as the percentage of\u00a0half of the pad&#039;s shortest side (as in previous versions).\u00a0\u00a0\t\tThe absolute value of the pad corner radius chamfer is also supported by the PCB List and PCBLIB List panels, the Find Similar Objects dialog,\u00a0and the Pad\/Via Template editor. Also, the following query keywords can now be used in expressions:\t\t\t\t\t\t\t\t\t\t\tKeyword\t\t\t\tSummary\t\t\t\t\t\t\t\t\t\t\t\t\t\tPad_CornerRadius_Value_AllLayers\t\t\t\t\t\t\t\tPad_CornerRadius_Value_TopLayer\t\t\t\t\t\t\t\tPad_CornerRadius_Value_BottomLayer\t\t\t\t\t\t\t\tPad_CornerRadius_Value_MidLayer\t\t\t\t\t(where n = 1..30)\t\t\t\t\t\t\t\t\t\t\t\tReturn pad objects whose Pad Corner Radius Size property for the corresponding layer complies with the query.\t\t\t\t\t\t\t\tFor example, the\u00a0AsMM(Pad_CornerRadius_Value_TopLayer) &gt; &#039;0.1&#039;\u00a0query returns pad objects whose\u00a0Pad Corner Radius Size\u00a0(Top Layer)\u00a0property is greater than 0.1mm.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tPad_CornerRadius_UsesPercent_AllLayers\t\t\t\t\t\t\t\tPad_CornerRadius_UsesPercent_TopLayer\t\t\t\t\t\t\t\tPad_CornerRadius_UsesPercent_BottomLayer\t\t\t\t\t\t\t\tPad_CornerRadius_UsesPercent_MidLayer\t\t\t\t\t(where n = 1..30)\t\t\t\t\t\t\t\t\t\t\t\tReturn pad objects whose Pad Corner Radius Uses Percent property for the corresponding layer complies with the query.\t\t\t\t\t\t\t\tFor example, the\u00a0Pad_CornerRadius_UsesPercent_MidLayer2 = &#039;False&#039;\u00a0query returns pad objects whose\u00a0Pad Corner Radius Uses Percent (Mid Layer 2)\u00a0property is disabled (i.e. an absolute value is used to define the pad radius on this layer).\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tNote that the existing Pad_CornerRadius_AllLayers, Pad_CornerRadius_TopLayer, Pad_CornerRadius_BottomLayer and Pad_CornerRadius_MidLayer (where n = 1..30) are still used to scope pad objects whose Pad Corner Radius (%) property for the corresponding layer complies with the query.\t\tSupport for pad corner radius\/chamfer defined as an absolute value has also been added to the Import Wizard\u00a0when importing an Xpedition design.\t\t\t\tThis feature is in Open Beta and available when the\u00a0PCB.Pad.CustomShape.CornerRadiusAbsolute\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Working with Pads &amp; Vias page.\t\tPCB Replication Improvements\tEnhanced Error Notifications\t\tIf\u00a0a missing pin connection in the selected Source Block is detected\u00a0when running the Layout Replication tool, the warning dialog will notify you about the missing connection.\t\t \t\tClick the link in the dialog to cross-probe to the offending object.\t\tAdded &#039;Busy&#039; State for PCB\u00a0Replication\t\tTo provide a more responsive UI for the PCB replication process, the indicators of the feature &#039;busy&#039;\u00a0state were added in this release.\t\t\t\t\t\t\tWhen running the Layout Replication tool, an indication that replication data is\u00a0loading, with the possibility to cancel out of the process,\u00a0appears before opening the PCB Layout Replication dialog.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAfter clicking the Replicate button in the PCB Layout Replication dialog,\u00a0the cursor indicates &#039;in progress&#039; () before the first block is placed (or ready for placement in interactive mode).\t\t\t\t\t\tFor more information, refer to the\u00a0PCB Layout Replication page.\t\t\t\tConstraint Manager Improvements\tAdded Support for Importing Design Directives (Open Beta)\tYou can now import constraints from design directives, placed and defined on your schematic source documents, into the Constraint Manager. This is performed from the Physical or Electrical view (when accessing the Constraint Manager from a schematic) using the new Import from Directives\u00a0command (from the right-click context menu) and supports rule, net class, diff pair, and diff pair class directives.\t\t\t\tNote that any existing constraints already defined for nets\/net classes\/diff pairs\/diff pair classes through the Constraint Manager will take precedence and are, therefore, kept when an import is processed.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: CM_ImportDirectives_AD24_3\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tOn a schematic, some Parameter Set and Differential Pair directives are placed.\u00a0These directives\u00a0define a diff pair, a net class and Width rules.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tUse the Import from Directives command from the right-click menu in\u00a0the Constraint Manager.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe data from the directives will be imported into the Constraint Manager.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThis feature is in Open Beta and available when the\u00a0ConstraintManager.ImportFromDirectives\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager\u00a0page.\t\tNew &#039;Diff Pairs&#039; Tab\tA new Diff Pairs tab is now available from the Electrical constraints view for explicitly defining and managing differential pairs. A hierarchical list of the differential pairs in the design is shown on this tab. Select a cell for a differential pair or\u00a0differential pair class\u00a0to present constraints for it in the bottom region of the Constraint Manager.\t\t\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager\u00a0page.\t\tSupport for Creepage in the Clearance Matrix\tA Creepage rule can now be specified when defining electrical clearances between classes of nets and\/or differential pairs using the matrix in the Clearances view.\t\t\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager\u00a0page.\t\tSupport for Multi-editing in the Clearance Matrix\tAdded support to the clearance matrix (the Clearance view) for multi-editing within a selected row\/column. In the\u00a0detailed clearance settings of the\u00a0Constraint Manager, select a row or column,\u00a0type the required value, and press Enter or click to apply this value to all cells of the row\/column.\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager\u00a0page.\t\tDraftsman Improvement\tAbility to Change the Resolution of a Board Realistic View\tThe resolution for a placed Board Realistic View can now be configured in the\u00a0Resolution(DPI) field in the Properties region of the\u00a0Properties panel by entering the desired resolution in the field. Previously, the view was a static rendered image with no way to change the resolution. The minimum setting is 75 DPI,\u00a0and the default setting is 300 DPI.\t\t\t\t\t\tFor more information, refer to the\u00a0Working with Additional Views page.\t\t\t\tHarness Design Improvements\tCavity Enhancements\tSpecifying Cavity Types\t\tYou can now specify the type of cavity for each pin of a harness component in the Wiring Diagram (*.WirDoc). On the Cavities tab of the Properties panel, select the desired pin, then click Add. Choose the cavity type from the drop-down. In the Select Connector dialog that opens, select the specific desired connector for the pin.\t\t\t\tOnly one cavity of a particular type can be added to a pin. Once a cavity of a particular type has been added, the entry is unavailable (grayed out) in the drop-down, as shown in the image below for Pin 3.\t\t\t\t\t\tFor more information, refer to the\u00a0Defining the Harness Wiring Diagram\u00a0page.\t\tAdded New Cavity Types to\u00a0Wiring List and Connection Table\t\tSeals, plugs and other cavity parts can be displayed in a wiring list and connection table in a manufacturing drawing. Enable the visibility of the desired columns in the Columns tab of the Properties panel when the placed table is selected in the design space.\t\t\t\t\t\tFor more information, refer to the\u00a0Creating a Manufacturing Drawing\u00a0page.\t\tAdded Cavity BOM Line Numbers to Callouts on the Manufacturing Drawing\t\tWhen a callout set to display the BOM Item is added to the physical view of a component on a layout drawing view, it will include BOM line numbers for all assigned cavities.\t\t\t\t\t\tFor more information, refer to the\u00a0Creating a Manufacturing Drawing\u00a0page.\t\tVisibility and Lock Options for Harness Bundle Length Parameter\tThe Length parameter of a harness bundle in a Layout Drawing (*.LdrDoc) now includes visibility and lock options.\t\t\t\t\t\tFor more information, refer to the\u00a0Creating the Harness Layout Drawing page.\t\tHighlight Bundles with Wires from Split Cables\tAll harness bundles that include wires from a split harness cable are now highlighted on the Layout Drawing\u00a0when the cable is selected in the Bundle Objects region of the Properties panel. For a split cable, the length of the longest wire is shown in BOM.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: HD_SplitCable_AD24_3\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tCable C1 is split between different connectors.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWhen clicking the cable entry in the Bundle Objects region of the Properties panel for the selected bundle, all bundles that include wires from C1 are now highlighted.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn BOM, the length of the longest wire (a wire that passes through bundles B1 and B3\u00a0in this example) is shown for C1.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAdded Twist Object Designator to the Wiring List\tThe designator of a twist object is now displayed in the wiring list as shown in the image below.\u00a0\t\t\t\t\t\tFor more information, refer to the\u00a0Creating a Manufacturing Drawing page.\t\tBoard Detail View Renamed Harness Detail View\tThe Board Detail View\u00a0in a Harness Draftsman document (*.HarDwf) has been renamed Harness Detail View.\t\t\t\t\t\tFor more information, refer to the\u00a0Creating a Manufacturing Drawing page.\t\tDisplay Individual Wire Lengths in Wiring List and Connection Table\tThe Length column in a wiring list and connection table now displays the individual wire lengths for each wire in a cable.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: HD_IndividualWireLength_AD24_3\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWires W1, W2 and W3 are\u00a0part of a cable.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIndividual lengths of these wires are now shown in a wiring list and connection table.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Creating a Manufacturing Drawing page.\t\tDisplay Total Length of Wires and Cables in BOM\tFor harness wiring components, the Length column in the ActiveBOM document and BOM Table in a manufacturing drawing now presents the total length for wires\/cables of the same BOM item rather than their individual lengths.\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Creating a Manufacturing Drawing page.\t\t\t\tData Management Improvements\tSupport for Custom Pricing\tWhen you have a configured connection to a specific supplier account through the browser interface of your Altium 365 Workspace (learn more), you can now see custom pricing\u00a0where applicable\u00a0in the ActiveBOM and all places where part choices are accessed. Also, suppliers that provide custom prices are labeled as such in the Project Part Providers Preferences dialog, which can be accessed by clicking the Edit button in the Favorite Suppliers List field in the Properties panel for the ActiveBOM document.\t\t\t\tAdded BOM Checks for SiliconExpert Parameters\tSupport for a range of checks based on SiliconExpert parameters was added to ActiveBOM. You can enable or disable these checks\u00a0in the Violations Associated with Part Choices\u00a0category in the BOM Checks dialog.\u00a0Open the dialog\u00a0by clicking the\u00a0 button in the BOM Checks region of the Properties panel.\t\t\t\t\t\tFor more information, refer to the\u00a0Pulling Part Data from SiliconExpert and\u00a0Finalizing Your BOM\u00a0pages.\t\tAdded Comment Resolved Status to Exported PDF\tWhen exporting comments to PDF, the status for resolved simple comments (i.e., those not assigned as &#039;tasks&#039;) is now included in the export.\t\t\t\t\t\tFor more information, refer to the\u00a0Document Commenting page.\t\tAdded Compiled IntLib to Downloaded Manufacturer Part Zip\tWhen downloading a component from the Manufacturer Part Search panel as a file library, the compiled Integrated library (*.IntLib) is now included as part of the Zip file.\t\t\t\t\t\tFor more information, refer to the\u00a0Searching for Manufacturer Parts page.\t\t\t\tImport\/Export Improvement\tXpedition Library Import Enhancements\tThis release adds the following improvements when importing an Xpedition library into Altium Designer.\t\t\t\t\t\t\tAdded support for &#039;Round Donut&#039; pad shapes defined in footprints within an Xpedition library. Note that this first step enables such footprint pads to be imported (as custom pad shapes). There is no dedicated \u2018Round Donut\u2019 pad shape in PCB\/PCB Footprint editors.\t\t\t\t\t\t\tDefined pad hole tolerances are now included when importing an Xpedition library.\t\t\t\t\t\t\tAdded support for replicated text strings in footprints (i.e., mounting hole &#039;A&#039;s) when importing an Xpedition library. The original string, its replicates, and associated parameters are imported.\t\t\t\t\t\t\tAdded support for zero-width lines defined for a footprint on the Placement Outline layer when importing an Xpedition library.\t\t\t\t\t\tFor more information, refer to the\u00a0Importing a Design from Xpedition page.\t\t\t\tCircuit Simulation Improvements\t\t\tSimulation S-Parameters Analysis (Open Beta)\tThis release adds the ability to run an analysis of S-parameters (scattering parameters). Such parameters facilitate an approach for describing networks based on the ratio of incident and reflected microwaves (for a device under test, how much power passes from one port to another, and how much power is reflected back). These ratios can be subsequently used to calculate the properties of a circuit, including input impedance, frequency response and isolation. While this type of analysis is primarily for RF circuits and components, it is equally useful for any circuit with at least two sources (ports).\t\tThis new analysis is done by enabling the S-Parameters Analysis option\u00a0in the AC Sweep region of the Simulation Dashboard panel. Define the ports (sources) involved and set an impedance for each (default is 50 ohms). If a device has more than two ports, these can be added and defined accordingly, which will result in more S-parameters involved in the resulting \u2018S-matrix.\u2019\u00a0Once the AC sweep analysis is run, the S-parameters data will be available on the S-parameters Analysis chart in the SDF document.\t\t\t\tThe simulation engine also calculates Y-parameters (admittance) and Z-parameters (impedance), which can be added to plots in the chart as desired.\t\t\t\tThis feature is in Open Beta and available when the\u00a0Simulation.SParametersAnalysis\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Configuring &amp; Running a Simulation page.\t\tAdded Ability to Present SPICE Models in the Components Panel\tIn this release, a new\u00a0Show in Components Panel option has been added to the Simulation \u2013 General page of the Preferences dialog. When this option is enabled, the SPICE Libraries category is available in the Components panel, and the libraries\u00a0contained in the Model Path folder specified on the Simulation \u2013 General page of the Preferences dialog are listed in this category.\u00a0The category structure\u00a0reflects\u00a0the structure of the specified folder.\t\t\t\tAs part of this, a folder of Analog Devices&#039; SPICE models has\u00a0been added to the Mixed Simulation extension&#039;s default installation Library folder (\\ProgramData\\Altium\\Altium Designer \\Extensions\\Mixed Simulation\\Library\\SPICE Models\\Analog Devices).\t\t\t\tFor more information, refer to the\u00a0Simulation Preferences page.\t\tAdded Enable Simulation Generic Components Library Option\tA new Enable Simulation Generic Components Library\u00a0option has been added to the Simulation \u2013 General page of the Preferences dialog, allowing you to control the library\u2019s visibility within the Components panel.\t\t\t\tIn addition, the library has been removed from the Installed tab of the Libraries Preferences dialog.\t\t\t\tFor more information, refer to the\u00a0Simulation Preferences page.\t\tAdded Support for the &#039;TEMP&#039; Keyword in Constant Parameters\tFor temperature analysis, the\u00a0keyword TEMP can now be used in constant parameters.\t\t\t\tThe keyword\u00a0TEMP can be used in constant parameters. The image shows the TEMP keyword being used to calculate the\u00a0IS parameter of transistor\u00a0Q11.\t\tThe TEMP value (the actual operating temperature of the circuit in \u00b0C) is set on the\u00a0Advanced\u00a0tab\u00a0of the\u00a0Advanced\u00a0Analysis Settings\u00a0dialog\u00a0accessed by clicking\u00a0Settings\u00a0in the\u00a0Analysis Setup &amp; Run\u00a0region of the\u00a0Simulation Dashboard\u00a0panel.\t\t\t\tNote that if\u00a0the TEMP keyword is used in a constant parameter, the simulator will not be able to perform a DC Sweep analysis when the Temp parameter is selected as a parameter\u00a0to be stepped for this analysis.\t\t\t\tFor more information, refer to the\u00a0Configuring &amp; Running a Simulation page.\t\tAdded Support for the LTspice &#039;AKO&#039; Model Keyword\tWhen creating a model based on another model, you can now use\u00a0the\u00a0AKO model keyword.\t\tIn the example shown below,\u00a0model QP has all the same parameters as model QP350, except that BF is changed and VA is set.\t\t.MODEL QP350 PNP(IS=1.4E-15 BF=70 CJE=.012P CJC=.06P RE=20 RB=350 RC=200)\t\t.MODEL QP AKO:QP350 PNP(BF=150 VA=100)\t\t\t\tError detection is applied when using the AKO syntax, in cases where the model definition involves:\t\t\t\t\t\t\t\t\t\t\tinfinite recursion \u2013\u00a0 show image, or\t\t\t\t\t\t\t\t\t\ta missing base model \u2013\u00a0 show image.\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the Creating a Simulation Model page.\t\tFeatures Made Fully Public in Altium Designer 24.3\tThe following features are now officially Public with this release:\t\t\t\t\t\t\tPrint Not Fitted Components \u2013 available from 22.3\t\t\t\t\t\t\tAny Angle Retrace \u2013 available from 23.10\t\t\t\t\t\t\tReplication of PCB Layout \u2013 available from 23.11\t\t\t\t\t\t\tAutomatic Tuning of Multiple Nets \u2013 available from 23.11\t\t\t\t\t\t\tAny Angle Diff Pair Router \u2013 available from 24.0\t\t\t\t\t\t\tAbility to Store TrueType Fonts \u2013 available from 24.1\t\t\t\tAltium Designer 24.2Released: 15\u00a0February 2024 \u2013 Version 24.2.2\u00a0(build 26)Release Notes for Altium Designer\t    Key Highlights    \tPCB Design Improvements\t\t\tAdded the Ability to Choose Components Manually while Replicating\tThis release extends the functionality of the PCB Layout Replication tool\u00a0with the ability to manually map components in target blocks where multiple components have been detected by the tool as having similar connections. This allows you to manually choose between available components that are able to replace each other faithfully without violating circuit connectivity.\t\tWhen multiple components with similar connections are detected by the tool, corresponding target blocks in the PCB Layout Replication dialog will have the  icon (when the block is collapsed), and each component with available replacements will have the  icon (when the block is expanded). Use the drop-down in the Designator field of the component with detected replacements to choose the required component.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Dlg_PCBLayoutReplication_Alternate_AD24_2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0PCB Layout Replication page.\t\t\t\tAdded Differential Pair Common Mode Impedance in Layer Stack Manager\tWhen\u00a0Differential is selected as the\u00a0Type\u00a0in the Properties panel to define an Impedance Profile for a differential pair, a field has been added that shows the common mode impedance for the selected Impedance Profile. This value, which is displayed as Impedance (Zcomm), is taken from Simbeor&#039;s calculated transmission line data.\t\t\t\t\t\tFor more information, refer to the\u00a0Controlled Impedance Routing page.\t\t\t\tUse of Tuning Miter Parameter for Connecting an Accordion to a Route\tWhen interactively tuning the length of a route by adding an accordion, the Miter parameter defined for the accordion in the Properties panel is now also used to\u00a0miter the traces that connect the accordion to the route. Previously, the Miter Ratio parameter defined for the interactive routing was used for these traces.\t\t\t\tThe Miter value from\u00a0the accordion properties is now also applied to traces connecting that accordion to the route.\t\t\t\tFor more information, refer to the\u00a0Length Tuning page.\t\t\t\tConstraint Manager Improvement\tEnhanced Ability to Transfer Constraints from PCB to Schematic\tIn this release, the ability to transfer constraints defined on the Physical and Electrical views of the Constraint Manager has been added. In the PCB editor, select the\u00a0Design\u00a0\u00bb Update Schematics in \u00a0command from the main menus and use the Engineering Change Order\u00a0dialog that opens to explore, validate\u00a0and execute the changes in constraints.\t\t\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page.\t\tMulti-board Design Improvement\t\t\tAdded Bookmarks Panel for Multi-board Draftsman Documents\tThe Bookmarks panel is now available in Draftsman when working with a manufacturing drawing of a multi-board design (*.MbDwf). The panel gives a tree view of the sheets on the\u00a0Draftsman document. Each sheet entry can be expanded and collapsed; when expanded, the appropriate\u00a0contents of each sheet are displayed as shown in the image below.\t\t \t\tYou can use the panel to easily navigate in the design space. When an item is selected in the panel or design space, the Properties panel (if open)\u00a0displays the properties and settings of the selected item. Additionally, when you select an item in the Bookmarks panel, the design space zooms to the selected item.\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Creating a Manufacturing Drawing page.\t\t\t\tHarness Design Improvements\tDuplicate Designator Violation Removed for Cable, Shield\u00a0and Twist Objects\tOn the Wiring Diagram, the Duplicate Designator (WD) violation check\u00a0does not report an issue when Cable\/Shield\/Twist objects use the same designator. This can now be split and used in different places using the same designator.\t\t\t\t\t\tFor more information, refer to the\u00a0Validating the Harness Design page.\t\t\t\tHighlight Wires for Twists and Shields\tIf a twist\/shield is associated with wires in multiple places on the Wiring Diagram (using the same designator), selecting a twist\/shield instance will highlight all associated wires in the group with a neon green color.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Harness_WD_Highlight\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAn example of a Wiring Diagram where two twists with the same designator are placed on different groups of wires. While only one of these twists is selected, all wires covered by these twists are highlighted.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAn example of a Wiring Diagram where two shields with the same designator are placed on different groups of wires. While only one of these shields is selected, all wires covered by these shields are highlighted.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Defining the Harness Wiring Diagram page.\t\t\t\tAdded Support for Multi-part Components\tThe ability to transfer multi-part component data from the Wiring Diagram to the Layout Drawing has been added. When multi-part components are\u00a0placed on the Wiring Diagram, designators are correctly assigned to the components in the Layout Drawing. If multiple parts of the same component are placed on the Wiring Diagram, only one instance of the component is placed on the Layout Drawing.\t\t\t\t\t\tFor more information, refer to the\u00a0Defining the Harness Wiring Diagram page.\t\t\t\tAdded Support to Connect Shields to a Connection Point\tA shield with a connection object that is defined on the Wiring Diagram can now be assigned to a connection point in the Layout Drawing. Use the Add Assigned Objects dialog (accessed by clicking the Add button in the Assigned Objects region of the Properties panel) when the connection point is selected to choose the shield with a connection to be assigned to that connection point.\u00a0\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Harness_ShieldConnection_CP\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Creating the Harness Layout Drawing page.\t\t\t\tAdded Support for Multicolored Wires\tMulticolored wires are now supported in the Wiring Diagram by choosing a wire&#039;s secondary and tertiary colors. (The primary color is the color of the placed wire.) In the Properties panel, click the Add drop-down at the bottom of the Parameters region then choose\u00a0Secondary and Tertiary to define the desired colors; the parameter for the chosen color will appear in the Parameters region. Click the color icon in the panel to open the color options; click the desired color.\u00a0You can also define the border color for the wire using the same drop-down then selecting Border. Click through the slideshow below for examples.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: MultiColorWire\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWire with the secondary color defined\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWire with the tertiary color defined\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWire with the border color defined\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWire with all color options defined\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Creating the Harness Wiring Diagram page.\t\tMulticolored wires are also supported in\u00a0harness design Draftsman documents (*.HarDwf). Additional columns for secondary, tertiary and border colors can be made visible in placed tables, and corresponding Color cells are split to show the secondary and\u00a0tertiary colors assigned to the wire.\t\t\t\t\t\tFor more information, refer to the\u00a0Creating a Manufacturing Drawing page.\t\t\t\tAdded Support for Multiple Wiring Diagrams in Draftsman Documents\tThe Harness Draftsman document (*.HarDwf) now supports multiple Wiring Diagram documents (*.WirDoc) in the same project. This feature lets you choose the wiring diagram document from which a placed wiring diagram view should be generated and updated. Use the Document drop-down in the Properties region of the Properties panel when the wiring diagram view is selected to choose the wiring diagram document for this view.\t\t\t\t\t\tFor more information, refer to the\u00a0Creating a Manufacturing Drawing page.\t\t\t\tAdded Bookmarks Panel for Harness Draftsman Documents\tThe Bookmarks panel is now available in Draftsman when working with a manufacturing drawing of a harness design (*.HarDwf). The panel gives a tree view of the sheets on the\u00a0Draftsman document. Each sheet entry can be expanded and collapsed. When expanded, the appropriate\u00a0contents of each sheet are displayed as shown in the image below.\t\t \t\tYou can use the panel to easily navigate in the design space. When an item is selected in the panel or design space, the Properties panel (if open)\u00a0displays the properties and settings of the selected item. Additionally, when you select an item in the Bookmarks panel, the design space zooms to the selected item.\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Creating a Manufacturing Drawing page.\t\tData Management Improvements\t\t\tSiliconExpert Enhancements\tAdded SiliconExpert Product Change Notice\t\tThe Product Change Notice (PCN) provided by\u00a0SiliconExpert has been added to the Manufacturer Part Search panel and to all places where part choices can be accessed. By default, the latest PCN data is shown. Use\u00a0the Historical Details control to open the\u00a0Product Change Notice Historical Details dialog, where details on previous PCNs can be browsed.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: SE_PCN\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAccess the latest and historical PCNs from the Manufacturer Part Search panel.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAccess the latest and historical PCNs from a part choice (the Components panel is shown as an example here).\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAdded SiliconExpert &#039;Free&#039; Parameters Support\t\tThe Lifecycle, YTEOL and RoHS Status parameters provided by SiliconExpert are now presented by default in the Manufacturer Part Search panel and all places where part choices are presented. Therefore, there\u00a0is no need to request data for this part (and hence, use the quota from your SiliconExpert package) to access these &#039;free&#039; parameters.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: FreeSEParameters_AD24_2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAccess &#039;free&#039; parameters provided by SiliconExpert from the Manufacturer Part Search panel.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAccess &#039;free&#039; parameters provided by SiliconExpert from a part choice (the Components panel is shown as an example here).\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAlso, these SiliconExpert &#039;free&#039; parameters can be used in ActiveBOM (by adding corresponding columns to the ActiveBOM document) without requesting all other SiliconExpert parameters.\t\tAdded Display of the\u00a0YTEOL Parameter\t\tThe YTEOL parameter is now displayed in the following locations:\t\t\t\t\t\t\tIn the header of the Details pane\u00a0when a manufacturer part is selected in the Manufacturer Part Search panel.\t\t\t\t\t\t\tIn the header of the Details pane\u00a0when a component\u00a0is selected in the Components panel.\t\t\t\t\t\t\tIn all places where part choices are presented.\t\t\t\t\t\t\tIn the Properties panel\u00a0when a component placed on a schematic sheet is selected.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: SE_YTEOL_AD24_2\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tDisplaying the YTEOL parameter in the Manufacturer Part Search panel.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tDisplaying the YTEOL parameter in the Components panel and in part choices.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tDisplaying the YTEOL parameter in the Properties panel for the selected component.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAdded Support for SiliconExpert Parameters when Comparing Manufacturer Parts\t\tSiliconExpert parameters are now supported in the Selected Part Details\u00a0pane of the Manufacturer Part Search panel when comparing two selected parts.\t\t\t\t\t\tFor more information, refer to the\u00a0Pulling Part Data from SiliconExpert page.\t\tAdded Support for Aggregated Lifecycles to Manufacturer Links\tWhen exploring a solution added in the form of a manufacturer\u00a0link to\u00a0an ActiveBOM document\u00a0if there are multiple sources of the lifecycle data for that manufacturer link (Altium Parts Provider powered by Octopart or IHS Markit\u00ae\u00a0and\u00a0SiliconExpert),\u00a0the lifecycle information from all available\u00a0sources is now accessible for the link.\u00a0Hover the cursor over the manufacturer lifecycle state\u00a0or use the drop-down to see the lifecycle information from all sources in the tooltip\/pop-up.\t\t\t\t\t\tFor more information, refer to the\u00a0Managing the Solutions page.\t\t\t\tImport\/Export Improvement\tImporting the Footprints into Existing Project Structure for Xpedition\tFor an Xpedition library (*.lmc) whose schematic symbols (only) were previously imported using the xDX Designer Import Wizard with the Import Symbols Only option enabled, you can now choose to import footprint models into a PCBLib as part of the existing project structure. Footprints will be renamed in accordance with the naming defined in the existing CSV file generated as part of the xDX Designer import process.\t\t\t\tNote that starting from this release, footprint names with specific prefixes (BGA, CAP, CAPC, CGA, COUP, DFN, DIO, DR, FILT, FUSE, INDC, INDM, ISOL, LEDC, LEDS, LGA, MECM, OSC, PQ, PS, QFN, QFP, RESC, RESM, SO, TO, VAR, XTA) will include the component height values multiplied by 100\u00a0in the generated\u00a0CSV files\u00a0to provide unique naming of footprints with differing 3D Body heights. For example, a footprint of height 1.4\u00a0and named\u00a0CAPC2013N will be added to the CSV file as CAPC2013X140N.\t\tWhen adding an Xpedition library file on the Importing Mentor Expedition Library Files page of\u00a0the Import Wizard, if previously imported libraries are detected, a confirmation dialog will ask if you would like to import footprints as described above.\u00a0If you click No, footprints will be imported into a separate folder for generated PCBLib files, and no footprint renaming will be performed.\t\t\t\t\t\tFor more information, refer to the\u00a0Importing a Design from Xpedition page.\t\tFeature Made Fully Public in Altium Designer 24.2\tThe following feature is now officially Public with this release:\t\t\t\t\t\t\tPCB Section View - available from 23.5\t\t\t\tAltium Designer 24.1Released: 16 January 2024 \u2013 Version 24.1.2 (build 44)Release Notes for Altium Designer\u00a0\t    Key Highlights    \tSchematic Capture Improvement\t\t\tAdded Violation Checks\u00a0for Objects Connected to a Harness Connector\tIn this release, new violation checks have been added to detect violations associated with signal harnesses in the schematics of your PCB design projects:\t\t\t\t\t\t\tThe Invalid Connection to a Harness Connector violation check detects a situation when\u00a0a wire, bus, or signal harness ends inside or is connected to the edge of a harness connector but is not connected to a harness entry.\t\t\t\t\t\t\tThe Unconnected Harness Entry violation check detects an unconnected harness entry.\t\t\t\t\t\tSettings for these violation types can be found in the Violation Associated with Harnesses group on the Error Reporting tab of the Project Options dialog.\t\t\t\t\t\tFor more information, refer to the\u00a0Validating Your Design Project page.\t\tPCB Design Improvements\t\t\tPad Hole Clearance Check Improvement (Open Beta)\tIn this release, the behavior of detecting clearance from pads with no annular ring has been improved.\t\tWhen a pad has a hole size greater than or equal to the pad size and, therefore, has no annular ring, the clearance value defined for the Hole by the applicable constraint in the Constraint Manager or by the Clearance design rule\u00a0is applied rather than the maximum of\u00a0Hole and\u00a0TH Pad clearances.\t\t\t\tAn example of clearances configured in the Constraint Manager.\t\t\t\tAn example of clearances configured in the Clearance design rule.\t\t\t\tThe new pad hole clearance behavior.\t\tNote\u00a0that the default values of Hole clearance in newly created Clearance constraints and Clearance design rules\u00a0have\u00a0been updated with the 10mil\u00a0\/ 0.254mm value.\t\t\t\tThis feature is in Open Beta and available when the\u00a0PCB.Rules.HoleClearance\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Electrical Rule Types page.\t\t\t\tAbility to Store TrueType Fonts (Open Beta)\tThis release has added the ability to automatically store geometries of text objects that use TrueType fonts inside PCB documents. When objects (text strings\/frames, dimensions, drill tables, and\/or layer stack tables) in a PCB document use\u00a0a TrueType font, these objects will be shown using the same font geometry when the PCB document is opened on another computer, even if that\u00a0TrueType font is not installed.\t\tWhen an object that uses a missing font is selected, a warning message appears at the top of the Properties panel. When changing object properties that affect its text (e.g., the text height or text itself), the Missing fonts dialog opens in which you can select a replacement font.\t\t\t\tThe dialog also appears when changing text-related properties from the PCB List panel.\t\tWhen trying to edit multiple objects using different missing fonts, the dialog allows you to select a replacement for each missing font.\t\t \t\t\t\tThis feature is in Open Beta and\u00a0available when the\u00a0PCB.Text.TTFontSaving\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\tNote that with this feature enabled, the options of the\u00a0PCB Editor \u2013 True Type Fonts page of the Preferences dialog are no longer relevant, so this page is not available in the Preferences dialog (when the\u00a0PCB.Text.TTFontSetting.Hide\u00a0option is enabled in the\u00a0Advanced Settings dialog).\t\t\t\t\t\tFor more information, refer to the\u00a0PCB Placement &amp; Editing Techniques page.\t\t\t\tEnhanced Pad Properties Panel\tThe Pad Stack region of the Pad Properties panel has been enhanced for better usability.\u00a0When a section is selected, the section name is highlighted in blue and the entire section is displayed in a different shade than the background.\t\t\t\t\t\tFor more information, refer to the\u00a0Working with Pads &amp; Vias page.\t\t\t\tPCB CoDesign Improvements\tAbility to Highlight Category Changes\tWith the Show on PCB option\u00a0enabled in the PCB CoDesign panel, you can now highlight all changes in a specific category when that category is selected in the panel&#039;s list of changes.\t\t\t\tGrouping Changes by Unions\tAdded support for comparison of, and application of changes to, unions (defined groupings of primitives on the PCB). Union-related changes are shown in the Unions category\u00a0in the PCB CoDesign\u00a0panel&#039;s list of changes. Also, changes in other categories are grouped now by unions if corresponding objects belong to any.\t\t\t\tUpdates to &#039;Merged&#039; State\tAfter merging changes using the PCB CoDesign panel, the PCB document will remain in the Merged\u00a0state (the\u00a0 icon in the Projects panel) until there is a new conflict. Saving changes locally will no longer change the state to Modified.\t\tAlso, note that\u00a0documents in Merged\u00a0state are always enabled for saving\u00a0to the Workspace in the Save to Server dialog and cannot\u00a0be disabled.\t\t\t\tFor more information, refer to the\u00a0PCB CoDesign page.\t\t\t\tConstraint Manager Improvements\tAbility to Choose Usage of the Constraint Manager for a New Project\tWhen creating a new PCB project, you now have the ability to control whether it will use the Constraint Manager or the older design rules system. In the Create Project dialog (File \u00bb New \u00bb Project), enable the Constraint Management option to use the Constraint Manager for the project being created.\t\t \t\t&#039;View Only&#039; Mode\tIf the Constraint Manager\u00a0was enabled for the PCB project, the\u00a0Constraint Manager\u00a0will present in\u00a0View Only\u00a0mode when opened by a user without Altium Designer Pro\/Enterprise Subscription. In this case, the user can see, but not modify, defined constraints.\u00a0The message at the top of the Constraint Manager\u00a0notifies you when the Constraint Manager is in View Only mode.\t\t \t\tUpdates to xSignal Creation\tThis release sees some updates in defining xSignals using the Constraint Manager:\t\t\t\t\t\t\tThe list of proposed xSignals is now divided into two groups:\u00a0xSignals going from a source to a destination point (S-T) and\u00a0xSignals going from one destination point to another (T-T). Use checkboxes for groups to select\/deselect all xSignals in corresponding groups.\t\t\t\t\t\t\tThe list of proposed xSignals now includes xSignals\u00a0going from a source to each destination (not an xSignal going from a source to the closest destination only).\t\t\t\t\t\t\tFor a better representation of proposed xSignals, they are now named in the list using the following scheme:\t\t\t\t\t\t ( \u2192 )\t\t\t\t\t\tNote that for names of created xSignals that can be seen on the xSignals tab to the Constraint Manager or in the PCB document, the previous\u00a0__\u00a0scheme is used.\t\t\t\t\t\t\t\t\tImproved Class Selection\tThe right-click menu of entries in\u00a0the Physical and Electrical views has been updated to quickly add objects to an existing class right from the menu. To do this, right-click one or more selected objects and choose an existing class from the Classes \u00bb Add Selected to Class sub-menu.\t\t\t\tWhen there are more than 30 classes, the\u00a0Classes \u00bb Add Selected to Class \u00bb Existing Class command is available in the menu instead of the list of classes. Use this\u00a0command to access a dialog where you can select an existing class to which the selected object(s) are to be added.\t\t\t\tAdded Line Numbers in Grid\tLine numbers have been added to the Constraint Manager grid to help you more easily identify and distinguish items in the list.\u00a0\u00a0\t\t \t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page.\t\tMulti-board Design Improvements\t\t\tSupport for Draftsman Documents in Multi-board Projects (Open Beta)\tYou can now add a Draftsman document (*.MbDwf) to a Multi-board project to create a manufacturing drawing for the Multi-board assembly in this project.\t\tThe views that can be placed in a\u00a0Draftsman document of a\u00a0Multi-board project are:\t\t\t\t\t\t\tMulti-board view \u2013\u00a0an automated graphic composite of the outlines of PCBs and 3D models constituting the\u00a0multi-board assembly.\t\t\t\t\t\t\tSection view \u2013\u00a0a profile slice, or sectional, drawing taken from a nominated &#039;cut&#039; point through a placed multi-board view.\t\t\t\t\t\t\tBoard detail view \u2013\u00a0a floating, magnified view of\u00a0a multi-board view&#039;s\u00a0defined area.\t\t\t\t\t\t\tBoard realistic view \u2013 a scalable 3D rendering of the current\u00a0multi-board assembly.\t\t\t\tDraftsman&#039;s annotation, dimensioning\u00a0and\u00a0graphical tools, as well as BOM\u00a0and generic tables, are also available.\t\t\t\tAn example of a Multi-board\u00a0project\u00a0Draftsman drawing.\t\t\t\tThis feature is in Open Beta and\u00a0available when the\u00a0MBA.Draftsman\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Creating a Manufacturing Drawing page.\t\t\t\tAbility to Move a Module Entry Group\tThe ability to move a selected group of module entries in a multi-board schematic document (*.MbsDoc) has been added. This new feature speeds up the editing process by not requiring you to move each module entry individually.\u00a0In the design space, select more than one module entry, then use the left mouse button to drag the group to the desired location. A red dot displays at each entry while they are dragged to the new location. Release the mouse button to place the group at the current location.\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Capturing the Logical System Design page.\t\t\t\tHarness Design Improvements\t\t\tChanged &#039;Crimps&#039; to &#039;Cavities&#039;\t&#039;Crimps&#039; have been renamed &#039;Cavities&#039; in the UI of the Wiring Diagram and Layout Drawing.\t\t \t\t\t\tFor more information, refer to the\u00a0Defining the Harness Wiring Diagram page.\t\t\t\tAdded Designator Field to Shield and Twist Objects\tThe Designator field has been added to the properties of shields and twists in the harness wiring diagram.\t\t \t\t\t\tFor more information, refer to the\u00a0Defining the Harness Wiring Diagram page.\t\t\t\tAdded Wire Break Object for Multiple Sheet Capability\tA full Wiring Diagram can now be defined over multiple sheets\u00a0(in a &#039;flat&#039; design fashion), each represented by its own\u00a0*.WirDoc document, with the ability to split a wire using the new Wire Break object.\t\t\t\tA Wire Break is placed using the Place menu or from the Active Bar as shown below.\t\t \t\t\t\tFor more information, refer to the\u00a0Defining the Harness Wiring Diagram page.\t\t\t\tTreat Coverings as Components in BOM\tHarness coverings in the Layout Drawing are now treated as components in the BOM, with support for part choices and grouping.\t\t\t\t\t\tFor more information, refer to the\u00a0Creating the Harness Layout Drawing page.\t\t\t\tDisplay Component Properties for Additional Physical Views\tWhen an additional physical view of a harness component is selected in the design space, the Properties panel now displays the properties of the component itself as it does\u00a0for the main (first) physical view. In the below image, a second physical view has been selected in the design space; the Harness Component Properties panel displays the properties of the original (first) physical view.\t\t\t\t\t\tFor more information, refer to the\u00a0Creating the Harness Layout Drawing page.\t\t\t\tImproved the Wiring List\tAdded Ability to &#039;Split&#039; Wiring List\t\tThe wiring list of an advanced harness design may have a large number of entries, which can be difficult to fit into a drawing document as a single table. Rather than resorting to font and table scaling, multiple custom table entries, or an external document, you now have the ability to\u00a0&#039;split&#039; a Wiring List in a Harness Draftsman document so that the Wiring List will be\u00a0presented over a number of &#039;pages.&#039; In the Properties panel for a placed Wiring List, enable the Limit Page Height option in the Pages region\u00a0to use the new feature.\u00a0This will restrict the height of the Wiring List table to the nominated height entry (Max Page Height) and, therefore, the number of lines shown in the table.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Harness_MD_WiringList_LimitPageHeight\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe editor detects that the entire Wiring List\u00a0is not shown, as indicated by the panel&#039;s\u00a0Page\u00a0entry (for example,\u00a01 from 2), and the associated drop-down menu allows you to nominate which page is shown. To add further pages of the Wiring List, place another Wiring List (Place \u00bb Wiring List) and specify the next\u00a0Page\u00a0in the\u00a0Pages\u00a0region of the\u00a0Properties\u00a0panel.\t\t\t\tEnhanced Wiring List for\u00a0&#039;Shield with Connection&#039; Objects\t\tDesignators of\u00a0shield with connector objects are now displayed in the Wiring List when a wire is connected to the shield&#039;s connector.\t\t\t\t\t\tFor more information, refer to the\u00a0Creating a Manufacturing Drawing for a Harness Design page.\t\t\t\tAdded Ability to Display Connection Table for Splices\tThe ability to show the connection table for individual splices has been added. Previously, the ability to show the Connection Table for only components and connectors was possible.\t\t\t\t\t\t For more information, refer to the\u00a0Creating a Manufacturing Drawing for a Harness Design page.\t\t\t\tLinks Added to Text Frame and Note Objects for Cross-Probing\tObject designators can now be added as active links in text frames and notes. The links provide cross-probe capabilities in the Wiring Diagram and Layout Drawing. To create active links, place a text frame or note object in either the Wiring Diagram or Layout Drawing. In the Text field in the Properties region of the Properties panel, enter &quot;@&quot;. A drop-down of all designators will appear. Double-click the desired designator from the list; the link is created in the Text field and in the design space. Click the link in the design space to cross-probe to that object in the associated document (i.e., the document that is not currently active). The process is demonstrated in the video below.\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Defining the Harness Wiring Diagram and Creating the Harness Layout Drawing pages.\t\tData Management Improvements\t\t\tManufacturer Lifecycle State Message Enhancement\tWhen using the SiliconExpert integration functionality, manufacturer part lifecycle data can be obtained from different sources: Altium Parts Provider (powered by Octopart or IHS Markit\u00ae) and SiliconExpert. To provide better visibility of this lifecycle data from different sources, the lifecycle information from all available\u00a0sources is now accessible.\t\tWhen exploring\u00a0manufacturer part data (e.g., an entry in the Manufacturer\u00a0Part Search panel,\u00a0a part choice of\u00a0a Workspace library component,\u00a0or a solution in an AcitveBOM document), hover the cursor over the manufacturer lifecycle state\/bar or use the drop-down to see the lifecycle information from all sources in the tooltip.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: ManufacturerLifecycle_MultipleSources_AD24_1\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Adding Supply Chain Information to a Component\u00a0and\u00a0Pulling Part Data from SiliconExpert pages.\t\t\t\tAdded General Tab to Project Options for Offline Workspace Projects\tAdded the General tab to the Project Options dialog for offline Workspace projects. This feature is available for working with a project when you are disconnected from its Workspace.\u00a0The only control\u00a0on the tab that is accessible is the\u00a0Turn Off Synchronization button. Click this button to turn off synchronization. This ensures that the local copy will not be linked to the one that resides on the Workspace. The project located in the Workspace will remain untouched.\t\t\t\t\t\tFor more information, refer to the\u00a0Accessing, Defining &amp; Managing Project Options page.\t\t\t\tRemoved Commit Command\u00a0for Git-based Projects\tFor Git-based projects, the Commit command has been removed from the History &amp; Version Control sub-menu of the right-click menu of project entry in the Projects panel and the Project main menu, aiming to remove confusion about where data was being committed (to the local repository and not the remote repository) when using the command.\u00a0Visibility of the command is controlled by the VCS.AllowGitCommit option from the\u00a0 Advanced Settings dialog (OFF by default). You can use the Save to Server command to commit the project to the local repository and push it to the remote repository in one action.\t\t\t\tFor more information, refer to the\u00a0Saving Projects and Documents page.\t\t\t\tImport\/Export Improvement\t\t\tMentor Xpedition Placement Outline and Insertion Ouline Layer Mapping\tWhen Mentor Xpedition PCB and footprint library files\u00a0are imported, Placement Outline layer types are now mapped as Courtyard layer types and the Insertion Outline layers\u00a0are now mapped to the Component Outline layer types in Altium Designer.\t\t\t\t\t\tFor more information, refer to the\u00a0Importing a Design from Xpedition page.\t\t\t\tCircuit Simulation Improvement\t\t\tSimulation Stress Analysis (Open Beta)\tStress Analysis is used to calculate operating conditions for each individual component, such as maximum voltages, currents, and power dissipations, and check them against limits defined in the stress model of the component.\t\tIn this release, a new\u00a0Stress Analysis\u00a0option has been added to the\u00a0Transient\u00a0region of the\u00a0Simulation Dashboard. When this option is enabled and the Transient analysis is performed, the Stress analysis results\u00a0are available on the additional\u00a0Stress\u00a0chart of the\u00a0simulation result document.\t\t\t\tUse the new Stress Analysis to test your circuits against defined limits.\t\tThe stress model of a component is configured on the new Stress tab of the Sim Model dialog accessed for the component&#039;s simulation model. From here, you can select the required Device Type and define parameter values.\t\t\t\tStress analysis parameters for a component can be set on the Stress tab of the Sim Model dialog.\t\t\t\tThis feature is in Open Beta and available when the\u00a0Simulation.StressAnalysis\u00a0option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Configuring &amp; Running a Simulation page.\t\tFeature Made Fully Public in Altium Designer 24.1\tThe following feature is\u00a0now officially made Public with this release:\t\t\t\t\t\t\tCustom Paste\/Solder Masks \u2013 available from 23.8\t\t\t\tAltium Designer 24.0Released: 13 December 2023 \u2013 Version 24.0.1 (build 36)\u00a0Release Notes for Altium Designer\t    Key Highlights    \tPCB Design Improvements\t\t\tAny Angle Diff Pair Router (Open Beta)\tThis release introduces support for any angle differential pair routing. When routing a diff pair using the Interactive Differential Pair Routing tool (Route \u00bb Interactive Differential Pair Routing), you can now select the Any Angle corner style () when configuring the properties of routing in the Properties panel in its Differential Pair Routing mode.\t\t\t\t\t\t\tAny angle differential pair routing supports symmetrical pad entry and gap changing.\t\t\t\t\t\t\tWhen starting differential pair routing from an antenna, the tool will maintain the left-to-right order of nets (i.e., the continuation of the left side stays on the left) and support snapping to the original direction.\t\t\t\t\t\t\tWhen routing a diff pair using the Any Angle corner style, press and hold the Shift key to route the diff pair using tangent arcs.\t\t\t\t\t\t\t\tDemonstration of any angle differential pair routing.\t\tNote that this feature also enables an updated angle diff pair glossing algorithm when using the Route \u00bb Gloss Selected command.\t\t\t\tThe current main limitations of any angle diff\u00a0pair routing are:\t\t\t\t\t\t\t\t\t\t\tRouting transitions through borders of rooms with different design rules are not currently supported.\t\t\t\t\t\t\t\t\t\tThe SMD Entry design rule is not currently supported.\t\t\t\t\t\t\t\t\t\tAutomatic loop removal is not currently supported.\t\t\t\t\t\t\t\t\tThis feature is in Open Beta and is available when the PCB.Routing.AnyAngleDiffPairRouter option is enabled in the Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Differential Pair Routing\u00a0page.\t\t\t\tEnhanced Layer Stack Report Setup Dialog (Open Beta)\tThe Layer Stack Report Setup dialog (File\u00a0\u00bb Fabrication Outputs\u00a0\u00bb Report Board Stack) has been enhanced and now includes all columns that are present in the Layer Stack. Use the dialog to select the columns you want to be displayed in the Layer Stack Report.\t\t\t\t\t\tThis feature is in Open Beta and available when the PCB.ModernBoardStackGenerator option is enabled in the Advanced Settings dialog.\t\t\t\tFor more information, refer to the\u00a0Preparing Fabrication Data page.\t\t\t\tPCB CoDesign Improvements\tEnhanced Copper Conflict Display and Resolution\tConflicts of copper objects are now grouped in pin-to-pin connection groups where applicable to ease exploring and resolving the changes.\t\t\t\tCopper conflicts can now be resolved on the pin-to-pin connection level.\t\tAdded Ability to Configure Color Legend\tIn the View Configuration\u00a0panel, you can now select colors for objects that have been\u00a0added, modified, removed, and not changed (unchanged objects of a pin-to-pin connection when it is selected in the PCB CoDesign panel).\t\t\t\tUse the View Configuration panel to configure the comparison color legend.\t\tOther PCB CoDesign UI Changes\t\t\t\t\t\tThe pop-up that shows that the comparison is in progress now appears right after running the comparison.\t\t\t\t\t\t\tAdded the ability to select and deselect entries in the change list. When an entry is selected (by clicking on it), click it again to deselect the entry and reset the object highlighting in the design space.\t\t\t\t\t\t\tThe Save to Server command has been added to the menu of the\u00a0Project panel&#039;s Merged icon\u00a0() shown after merging changes using the PCB CoDesign panel \u2013 show image.\t\t\t\t\t\t\tWhen clicking the Save to Server button in the PCB CoDesigner panel after merging changes, only the merged PCB document is selected in the Save to Server dialog by default \u2013 show image.\t\t\t\t\t\t\tWhen merging the changes is run, a new pop-up showing that merging is in progress is now displayed \u2013 show image.\t\t\t\t\t\tFor more information, refer to the\u00a0PCB CoDesign page.\t\t\t\tConstraint Manager Improvements\tAbility to Add Differential Pair Classes to the Clearance Matrix\tStarting from this release, you can add not only net classes but also differential pair classes\u00a0to the Clearance Matrix (the Clearances view).\t\t\t\tEditing Custom Topology on the PCB Side\tIt is now possible to define the topology of a net as Custom and edit it as required in the Constraint Manager when it is accessed from the PCB side.\t\t\t\tPropagating Topology Changes when Editing the\u00a0Constraint Set\tWhen editing a Constraint Set that includes a custom topology, changes made to the topology are now propagated to other objects to which this Constraint Set is applied.\t\t\t\t\t\tAbility to Remove xSignals\tIt is now possible\u00a0to remove an xSignal from the xSignals\u00a0tab of the\u00a0Electrical view. To do this, right-click an xSignal and select the xSignals \u00bb Remove xSignal command from the context menu.\t\t \t\tCross Select From and To the Constraint Manager\tIn this release, an ability to cross-select objects from and to the Constraint Manager has been added. When cross-select mode is enabled (using the Cross Select Mode command from the Tools main menu of the Constraint Manager, the schematic or PCB editor), objects selected in the Constraint Manager are also selected in the schematic and PCB documents, and vice versa.\t\t\t\tEnhanced the Expand\/Collapse State\tAll nodes, except for those that are predefined (e.g., All Nets), are now collapsed in the Physical and Electrical views by default. You can use the new Expand All and Collapse All\u00a0right-click menu commands to control the grid nodes.\t\t\t\t\t\tFor more information, refer to the\u00a0Defining Design Requirements Using the Constraint Manager page.\t\t \t\t3D-MID Design (Open Beta)\t3D-MID technology combines electrical circuits with three-dimensional mechanical parts. This fusion of functionality opens up a world of possibilities within a vast range of application areas.\t\tHistorically, designers of 3D-MIDs have generally been restricted to MCAD packages due to the lack of suitable ECAD tools. There are many problems inherent to this way of working, not least is the absence of any electrical intelligence to drive the circuit layout and the difficulties associated with projecting 2D manually drawn sketches onto 3D surfaces.\t\tThe new 3D-MID editor in Altium Designer allows you to place standard surface mount components onto a 3D shape\u00a0in a 3D-MID document and route traces along the surface of the shape to complete the layout.\t\t\t\tThe completed design can then be exported in the file format required by the Laser Direct Structuring (LDS) manufacturing process.\t\t\t\tTo learn more about this functionality, see\u00a03D-MID Design.\t\t\t\tNote that the 3D-MID functionality is not supported with the Altium Designer Standard Subscription. If you are interested in 3D-MID and have a Standard Subscription, talk to your Altium sales representative about your evaluation options.\t\t\t\tThis feature is in Open Beta and is available when the System.3DMID option is enabled in the Advanced Settings dialog.\t\t\t\tHarness Design Improvements\t\t\tTreat Layout Labels as Components in BOM\tLayout labels in the Layout Drawing are now treated as components in the BOM, with support for part choices and grouping.\t\t\t\t\t\tFor more information, refer to the\u00a0Creating the Harness Layout Drawing page.\t\t\t\tAdded Columns to the\u00a0Connection Table and Wiring List\tAdditional columns have been added to the Connection Table and Wiring List in a Manufacturing Drawing (*.HarDwf) that allow you to easily view the additional information in the design space.\u00a0Crimp\u00a0(part number), Cable, ToPin, and ToPart have been added to the Connection Table; FromCrimp, ToCrimp, and Cable have been added to the Wiring List. Toggle the eye icon in the Properties panel to display\/hide the desired columns in the connection table.\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Creating a Manufacturing Drawing for a Harness Design page.\t\tPlatform Improvement\t\t\tSupport for Long Path Names (Open Beta)\tSupport for long path names has been implemented in this release. When a file path with the\u00a0file name exceeds 256 characters, the actions on files are now supported, including:\t\t\t\t\t\t\tOpening a project from the connected Workspace.\t\t\t\t\t\t\tMaking a local project available in the Workspace.\t\t\t\t\t\t\tChanging the folder path in\u00a0an Outjob file.\t\t\t\t\t\t\tGenerating outputs using an Outjob file or the Project Releaser.\t\t\t\t\t\t\tSaving a project as a project template to the Workspace.\t\t\t\tStarting from Windows 10\u00a0version 1607,\u00a0MAX_PATH\u00a0limitations have been removed from common Win32 files and directory functions. However, you must opt-in to the new behavior by changing a registry key on the computer where Altium Designer is installed. Refer\u00a0to the\u00a0Support for Long Path Names page for details. After doing so, ensure that your computer is rebooted.\t\t\t\tWARNING: Modifying the registry improperly can result in Windows becoming unusable. Use the Registry Editor only at your own risk and only after backing up the registry as outlined in the Microsoft article\u00a0How to back up and restore the registry in Windows.\t\t\t\tWhen releasing a project that uses a long path to an Enterprise Server Workspace, the PC where the Altium On-Prem Enterprise Server is installed should also be configured: learn more.\t\t\t\tThis feature is in Open Beta and is available when the\u00a0System.LongPathsSupport option is enabled in the Advanced Settings dialog. Note that this option is available only when the\u00a0LongPathsEnabled\u00a0registry key is set to 1.\t\t\t\tFor more information, refer to the\u00a0Support for Long Path Names page.\t\t\t\tImport\/Export Improvements\t\t\txDX Designer Import Enhancements\tThis release delivers a number of key improvements and fixes in relation to the import of xDX Designer design files into Altium Designer.\t\tAdded Ability to Import Symbols Only\t\tThe Reporting Options page of the Mentor xDxDesigner Import Wizard now includes the Import symbols only option that allows to import symbols only. When this option\u00a0is enabled, identical symbols from the library database will be imported as a single schematic symbol, even if it is used by many components in the original library, and parameters are not imported to symbols in Altium Designer.\t\t\t\tAlso, when this option is enabled, the next page of the Wizard will suggest generating\u00a0part-symbol and pin mapping data in CSV format by enabling the Generate Pin Mapping and Component Models\/Parameters Combined CSV option. When this option is enabled, use the available fields to define Oracle DB connection parameters and a parameter mapping file.\t\t\t\tMulti-part Symbol Import Improvements\t\tWhen imported to Altium Designer, a multi-part symbol receives a Design Item ID combined with the first and last part names defined in xDX Designer. These combined Design Item IDs are also used in the generated CSV files.\t\tAlso, the order of parts in symbols imported to Altium Designer is now the same as defined in the original library.\t\tSymbol Import Improvements\t\tOther import improvements include:\t\t\t\t\t\t\tStatic text strings in symbols are\u00a0now imported.\t\t\t\t\t\t\tThe &#039;~&#039; characters used for negation in xDX Designer are now transformed into &#039;\\&#039; characters in pin names to correctly represent negation symbols in Altium Designer.\t\t\t\t\t\t\tThe Reporting Options page of the Mentor xDxDesigner Import Wizard now includes the Import pin customizations (font size)\u00a0option. When this option is enabled, pin designators and names are imported to Altium Designer with the same font size as in xDX Designer.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor more information, refer to the\u00a0Importing a Design from xDX Designer or DxDesigner page.\t\t\t\tMentor Expedition Import Improvements\tAdded Ability to Choose Extruded Body Layer\t\tYou now have the ability to choose the layer when creating extruded bodies when importing Mentor Expedition files using the Import Wizard. After adding the Mentor PCB and Library files to be imported, choose from\u00a0Placement Outline\u00a0or\u00a0Assembly Outline\u00a0using the Create extruded body from\u00a0drop-down on the Current User Layer Mappings page. When the option is enabled, the default is Placement Outline.\t\t \t\tPlacement Outline Improvement\t\tPlacement Outlines can now be imported as primitives on the Placement Outline layer\u00a0on the Top\/Bottom 3D Body assembly layers.\t\t\t\tFor more information, refer to the\u00a0Importing a Design from Xpedition page.\t\t\t\t\t\tCircuit Simulation Improvement\t\t\tOutput Currents for P-Channel Transistors Inverted\tOutput currents for P-Channel transistors (BJT, JFET, MOSFET, MESFET) are now treated as inflow currents, making them consistent with N-Channel transistors.\t\t\t\tFor more information, refer to the\u00a0Creating a Simulation Model page.\t\t \t\tAnsys CoDesigner (Open Beta)\tThis release presents the first steps into true collaborative design (CoDesign) between the ECAD and Simulation domains. Up until now, engineers in these two siloed camps have had to rely on manual export\/import file processes that have no connection with a revision of a design and communication of changes and results, typically by email, outside of the design arena.\t\tNow, with the arrival of the Ansys CoDesigner feature, the ECAD engineer (using Altium Designer) can seamlessly collaborate on a design with their SIM engineer colleague (using Ansys Electronics Desktop (AEDT)). Collaboration is facilitated through an Altium 365 Workspace, which acts as a bridge between the two domains. This initial release includes support for the following key elements:\t\t\t\t\t\t\tBi-directional push\/pull of design changes between the two domains. From Altium Designer, changes to layer stack and materials, components, and primitives are detected and can be applied in AEDT. From AEDT, proposed changes to layer stack and materials can be pushed through the EDB file and detected\/applied in Altium Designer.\t\t\t\t\t\t\tSimulation results are pushed from AEDT to the Altium 365 Workspace and associated with a revision of the design, with the ability to view through the Workspace\u2019s browser interface and preview within Altium Designer.\t\t\t\t\t\t\tBi-directional communication using the commenting system, with each comment thread attached to a specific component in a design.\t\t\t\t\t\t\t\tCurrently, AEDT of version 2023 R1 and 2023 R2 is\u00a0supported by\u00a0Ansys CoDesigner.\t\t\t\t\u00a0For more information, refer to the\u00a0Ansys CoDesigner page.\t\t\t\tNote that Ansys CoDesigner is not supported with the Altium Designer Standard Subscription.\t\t\t\tThis feature is in Open Beta and is available when the Ansys CoDesigner\u00a0(for Altium Designer) and\u00a0Altium Link\u00a0(for Ansys Electronics Desktop) extensions are installed. The latter can be obtained by contacting ansyscollaboration@altium.com.\t\tPower Analyzer by Keysight Improvement\t\t\tAdded Ability to Assign Currents for Multiple Nets on the Same Component\tIn\u00a0this release, the\u00a0ability to assign\u00a0currents for multiple nets on the same component for different series elements has been added.\t\tWhen configuring a load of the IC (Current) type, you can see all pins of the load component that connect it with the source\u00a0through different serial components, with the ability to select the required pins.\t\tIn the example shown below, the 5V power net is connected to two pins of the LCD1 component through R4 and R5 series\u00a0components. After extending the power net and adding\u00a0LCD1 as the load, both pins can be selected and configured as required in the Load Properties dialog.\t\t\t\t\t\tFor more information, refer to the\u00a0Power Analyzer QuickStart Guide page.\t\tFeatures Made Fully Public in Altium Designer 24.0\tThe following features are now officially made Public with this release:\t\t\t\t\t\t\tConstraint Manager\u00a0- available from 23.11\t\t\t\t\t\t\tPCB CoDesign\u00a0- available from 23.10\t\t\t\t\t\t\tHarness Design\u00a0- available from 23.0\t\t\t\t\t\t\tImproved Detection of Minimum Annular Ring Violation\u00a0- available from 22.10\t\t\t\t        var p = document.getElementsByClassName(&quot;Counter&quot;);        for (k = 0; k &lt; p.length; k++) {            Bloberator(p[k].id, &quot;0&quot;);        }        document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);        document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);        function Update(ss, n) {            var g = (document.getElementById(ss).innerHTML) - 1;            var TextArray = document.getElementsByClassName(ss + ss);            var ImageArray = document.getElementsByClassName(ss);            if ((g == 0) &amp; (n == -1)) {                n = 0;            }            ImageArray[g].style.opacity = &quot;0&quot;;            ImageArray[g].style.zIndex = &quot;-1&quot;;            if (g &lt; TextArray.length) {                TextArray[g].style.display = &quot;none&quot;;            }            g = g + (n);            if (g == ImageArray.length) {                g = 0;            }            ImageArray[g].style.opacity = &quot;1&quot;;            ImageArray[g].style.zIndex = &quot;1&quot;;            if (g &lt; TextArray.length &gt; 0) {                TextArray[g].style.display = &quot;inherit&quot;;            }            document.getElementById(ss).innerHTML = g + 1;            Bloberator(ss, g);        }        function Bloberator(sss, m) {            var dots = &quot;&quot;;            var IR = document.getElementsByClassName(sss);            for (d = 0; d &lt; IR.length; d++) {                if (d == m) {                    dots = dots + &quot;&quot;;                } else {                    dots = dots + &quot;&quot;;                }            }            var dotrows = document.getElementsByName(sss);            for (x = 0; x &lt; dotrows.length; x++) {                dotrows[x].innerHTML = dots;            }        }","tags":"","url":"altium-designer\/24\/documentation-altium-designer-new.html"},
{"title":"Public Release Notes","text":"\u00a0The following sections list the release notes for publicly released versions of Altium Designer 24. Use the Version selector at the top of the page to access release notes for previous versions.\tFor a summary of new features and subsequent improvements in Altium Designer 24, see New in Altium Designer.\tVersion 24.10.1Build:\u00a045\u00a0Date: 10 October 2024Schematic\t\t\t\t\t\t61654\t\t\tInstances of managed sheets placed within a design are now presented in the Web Viewer.\t\t\t\t\t\t\t62392\t\t\tImproved single\/multi-part symbol handling, extending the same features and functionality available for Alternate display modes, to the &#039;Normal&#039; display mode. (I:9891)\t\t\t\t\t\t\t62663\t\t\tIn a specific case, a company logo graphic (in SVG format) was no longer being displayed on the schematic.\t\t\t\t\t\t\t62869\t\t\tWhen editing the values of multiple parameters for a selected component (one after another) in the Properties panel, a second click into a field was needed to edit its value. (BC:24126)\t\t\t\t\t\t\t63054\t\t\tIn some cases when working with the Properties panel, the error &quot;System.Runtime.InteropServices.InvalidComObjectException: COM object that has been separated from its underlying RCW cannot be used&quot; would be encountered.\t\t\tPCB\t\t\t\t\t\t55389\t\t\tIn some cases when trying to change parameters for a region placed on a plane layer, through the PCB List panel, an Access Violation would be encountered.\t\t\t\t\t\t\t59269\t\t\tSVG geometry generated for the solder mask layer did not include cutouts (openings) for route tool paths.\t\t\t\t\t\t\t59866\t\t\tAdded Dynamic Phase Matching support for differential pairs, including Matched Lengths rule expanded with dynamic phase matching constraints, batch DRC support and automatic length tuning with phase compensation. (I:14281)\t\t\t\t\t\t\t60119\t\t\tAdded Routing Topology design rule as part of DRC, checking custom topologies (essentially that all From-Tos have the correct implementation).\t\t\t\t\t\t\t60464\t\t\tIn some cases with the &#039;Component pushing&#039; option set to &#039;Push&#039;, moving a rotated component (or a component with an irregular courtyard) would result in the component &#039;jumping&#039; rather than moving smoothly.\t\t\t\t\t\t\t60663\t\t\tAdded the ability to enable phase matching between the sides of a differential pair as part of automatic diff pair length tuning.\t\t\t\t\t\t\t60883\t\t\tAdded support for designing hybrid boards with chip-on-board (CoB) technology using Wire Bonding. (I:3207)\t\t\t\t\t\t\t61404\t\t\tIn some cases with the &#039;Component pushing&#039; option set to &#039;Avoid&#039;, a component would become stuck when attempting to move it, not able to be moved smoothly as expected.\t\t\t\t\t\t\t61409\t\t\tWith the &#039;Component pushing&#039; option set to &#039;Avoid&#039;, moving a component did not observe the applicable clearance rule.\t\t\t\t\t\t\t61587\t\t\tFor a polygon pour with &#039;Remove Necks Less Than&#039; and &#039;Obey Rules&#039; options enabled, thermal connections to pads in the polygon were incorrectly allowed to become smaller than the allowable width rule.\t\t\t\t\t\t\t62084\t\t\tWhen rerouting from an existing diff-pair using a &#039;45\/90 with arc&#039; corner style, the arcs were not concentric.\t\t\t\t\t\t\t62140\t\t\tThere was a noticeable delay when starting to pan within the design space, when an interactive command (e.g. Move Object, Interactive Routing, etc...) was running.\t\t\t\t\t\t\t62316\t\t\tFor a specific design, generation of ODB++ data in either v8 or v7.1 format would result in an arc in the design being generated as a full circle.\t\t\t\t\t\t\t62434\t\t\tWhen changing the shape of a pad to &#039;Custom Shape&#039;, the shape used for that pad immediately before was not being applied\/inherited.\t\t\t\t\t\t\t62442\t\t\tFor a specific footprint, flipping it to the bottom layer and back resulted in a shifting of copper objects within the footprint.\t\t\t\t\t\t\t62617\t\t\tThe Test Queries feature, in the PCB Rules and Constraints Editor dialog, was not working correctly. (BC:24002, BC:24087)\t\t\t\t\t\t\t62716\t\t\tThe &#039;Footprint Mirroring Prevention&#039; and &#039;Enhanced Hole Clearance Detection&#039; features are now officially made Public with this release (both ON by default).\t\t\t\t\t\t\t62788\t\t\tWhen editing polygon and solid region corners, information for &#039;Radius&#039; and &#039;Angles&#039; was missing from the heads-up display. (BC:24095)\t\t\t\t\t\t\t62848\t\t\tThe &#039;Enhanced Return Path Rule&#039; feature, delivered by the PCB.Rules.CheckReturnPathVia option (Advanced Settings), remains in Open Beta but is now ON by default with this release.\t\t\t\t\t\t\t62883\t\t\tThe &#039;Auto-shrinking During Interactive Routing&#039; feature, delivered by the PCB.Routing.EnableAutoShrinking option (Advanced Settings), remains in Open Beta but is now ON by default with this release.\t\t\t\t\t\t\t62899\t\t\tThe &#039;Routing Neck-Down Rule&#039; feature, delivered by the PCB.Rules.NeckDown option (Advanced Settings), remains in Open Beta but is now ON by default with this release.\t\t\t\t\t\t\t63051\t\t\tStaggered vias were not being displayed correctly in 2D\/3D View modes.\t\t\t\t\t\t\t63057\t\t\tIn some cases when working with the Health Check tab on the Properties panel (for the board itself), the error &quot;System.ArgumentNullException: Value cannot be null. (Parameter &quot;source&quot;)&quot; would be encountered.\t\t\tPCB CoDesign\t\t\t\t\t\t62226\t\t\tDeleted primitives were not being displayed in the Conflicts region of the PCB CoDesign panel.\t\t\t\t\t\t\t62457\t\t\tDisplay of conflicts between primitives of group objects has been enhanced in the PCB CoDesign panel, with the primitive name now included before its property.\t\t\t\t\t\t\t62458\t\t\tOnline DRC is now suppressed when merging, making the merge process faster.\t\t\t\t\t\t\t62478\t\t\tChanging the origin of the board would cause component coordinates to change, leading to conflicts when running a comparison.\t\t\t\t\t\t\t62536\t\t\tAdded the ability to merge object properties, where there are no conflicts in value, significantly reducing the number of object conflicts.\t\t\tConstraint Manager\t\t\t\t\t\t61707\t\t\tIt was possible to add a net class with the same name as a differential pair class (e.g. in the Physical view), leading to an error being encountered when trying to add the second class to the Clearances matrix.\t\t\t\t\t\t\t61829\t\t\tAdded the ability to perform a one-time, one-way migration, from using the old rules management system to using the Constraint Manager.\t\t\t\t\t\t\t62623\t\t\tFor an already-imported directive, it is now possible to add, update and remove constraints for it through the Properties panel, with changes made directly to the data in the Constraint Manager.\t\t\t\t\t\t\t62626\t\t\tWhen preparing the ECO to pass changes from the schematic to the PCB, a warning is now presented if there are directives that exist on the schematics that were not imported into the Constraint Manager.\t\t\t\t\t\t\t62635\t\t\tIn the Physical and Electrical (Nets) views, when accessed from the Schematic, the &#039;Remove rule&#039;, &#039;Remove rules from scope&#039; and &#039;Delete unmatched object&#039; commands did not work correctly for multiple selected entities.\t\t\t\t\t\t\t62785\t\t\tWhen accessing the Constraint Manager (from PCB) for a project in Altium Designer 24.7\/24.8\/24.9, the All Rules view was empty. (BC:24081)\t\t\t\t\t\t\t62955\t\t\tIn a specific case, after updating the PCB from schematics and enabling the &#039;Remove Clearance Constraint [xxx] All&#039; entry in the ECO, the Clearances view in the Constraint Manager (accessed from the PCB) was empty, and subsequent attempts to synchronize (add clearance constraints from schematic side) was not possible. (BC:24181)\t\t\t\t\t\t\t62966\t\t\tIn some cases when updating the PCB from the schematics, an Access Violation &quot;EOleException: Value cannot be null. (Parameter &quot;input&quot;)&quot; would be encountered.\u00a0(BC:24258)\t\t\tDraftsman\t\t\t\t\t\t62832\t\t\tIn some cases when importing changes from a project&#039;s PCB to its Draftsman document, Altium Designer would close unexpectedly if the PCB.OpenCascadeLatestVersion option (Advanced Settings dialog) was enabled.\t\t\t3D-MID Design\t\t\t\t\t\t62240\t\t\tImproved performance when working with designs containing regions.\t\t\tHarness Design\t\t\t\t\t\t61563\t\t\tFor the Bulkhead Connector (connector with the largest number of cavities), automatic grouping is applied to the wiring list in a harness manufacturing document, ensuring that all of its cavities are correctly grouped in the From column.\t\t\t\t\t\t\t61913\t\t\tIn some cases when working with a Wiring Diagram, the error &quot;EOleException: An item with the same key has already been added&quot; would be encountered.\t\t\tPlatform\t\t\t\t\t\t61714\t\t\tWhen using Altium Designer with Standard Subscription or a Viewer license, Harness and Multi-board design projects (and their associated documents) will now present in &#039;View Only&#039; mode\t\t\t\t\t\t\t62657\t\t\tIn some cases, the highlighting boundary was partially absent for a selected field on the System - Account Management page of the Preferences dialog.\t\t\t\t\t\t\t62773\t\t\tAltium Designer would disconnect from the active Altium 365 Workspace whenever exiting Windows Hibernation mode. (BC:23671)\t\t\t\t\t\t\t62859\t\t\tWhen configuring layers on the Pages tab of the new Print dialog (UI.Unification.PrintPreviewDialog option enabled in Advanced Settings) to generate prints through an OutJob file (e.g., Assembly Drawings), it was not possible to change layer ordering or disable visibility of layers.\u00a0(BC:24244)\t\t\tData Management\t\t\t\t\t\t59115\t\t\tPart choice data was not presented correctly in the ActiveBOM, if a component was sourced from the Altium Content Vault.\t\t\t\t\t\t\t61248\t\t\tRemoved a secondary, redundant dialog that was appearing when migrating a local project (under external VCS) to a connected Altium 365 Workspace&#039;s native Git repository.\t\t\t\t\t\t\t61295\t\t\tIn some cases when working with comments, the error &quot;System.NullReferenceException...&quot; would be encountered.\t\t\t\t\t\t\t62052\t\t\tAn error would be encountered when trying to make a copy of a component (through the Components panel), if the Pins panel was also docked and visible.\t\t\t\t\t\t\t62182\t\t\tIn some cases, there was a noticeable performance degradation when conducting the first search in the Manufacturer Part Search panel.\t\t\t\t\t\t\t62406\t\t\tFiltering by &#039;Assignee&#039; was not functioning correctly in the Comments and Tasks panel. (BC:23892)\t\t\t\t\t\t\t62482\t\t\tWhen adding a comment within the Altium 365 Web Viewer, an included apostrophe (&#039;) would incorrectly appear in HTML form (&#039;) when viewing that comment in Altium Designer.\t\t\t\t\t\t\t62489\t\t\tThe checkbox associated with the Explorer panel&#039;s &#039;Show Hidden Revisions&#039; option would disappear when switching Workspaces. (BC:22587)\t\t\t\t\t\t\t62490\t\t\tWhen placing a comment with the &lt; character, followed by text other than a space, the error &quot;System.ServiceModel.FaultException: Potentially unsafe input detected&quot; would be encountered. (BC:23563)\t\t\t\t\t\t\t62499\t\t\tWhen cloning a schematic template through the Explorer panel, multiple clones would appear in the Projects panel if a free document was open in the panel. (BC:23781)\t\t\t\t\t\t\t62504\t\t\tAdded the ability, for PCB design projects stored in a connected Altium 365 Workspace, to work with system requirements defined through the Requirements and Systems Portal.\t\t\t\t\t\t\t62597\t\t\tUsing the Explorer panel, it was not possible to drag-and-drop a project between sub-folders in a connected Altium 365 Workspace&#039;s projects folder structure. (BC:23971)\t\t\t\t\t\t\t62636\t\t\tWhen editing a Workspace component (in Batch Component Editing mode), removing a default model (taken from the associated component template) and attempting to save, would result in an Access Violation (in module &#039;UnifiedComponent.DLL&#039;).\t\t\t\t\t\t\t62660\t\t\tWithin the contextual commenting window, there were no icons associated to the commands (Cut, Copy, Paste) on the right-click context menu.\t\t\t\t\t\t\t62673\t\t\tAttempting to drag a Workspace component entry from within the Explorer panel would result in a &quot;System.NullReferenceException&quot; error. (BC:23971)\t\t\t\t\t\t\t62698\t\t\tAdded the ability to view and modify parameters for a local project template, when creating a new project in the Create Project dialog.\t\t\t\t\t\t\t62729\t\t\tIn some cases, attempting to save a component to a Workspace (from the Manufacturer Part Search panel) would result in the &quot;Runtime error 231&quot; being encountered, when the user had disconnected from that Workspace on a second instance of Altium Designer.\t\t\t\t\t\t\t62887\t\t\tParameters from local project templates were missing when creating a new project. (BC:24164)\t\t\tAdditional Note: In the near future, SVN will no longer be supported in the Altium On-Prem Enterprise Server product. We will update you during the next few releases regarding the timeline as to when support will end. Learn more about how you can migrate a project from an SVN repository to the Enterprise Server&#039;s built-in Git repository.Import\/Export\t\t\t\t\t\t61660\t\t\tAltium Designer would unexpectedly close when trying to import PADS library files, on a computer running Windows 11 Pro (64-bit). (BC:23889)\t\t\t\t\t\t\t61964\t\t\tWhen importing a KiCad v8 design, component designators in replicated hierarchical sheets were not being annotated correctly.\t\t\t\t\t\t\t62339\t\t\tWhen attempting to import a specific KiCad design, the Import Wizard would crash with a &quot;Catastrophic Failure&quot;.\t\t\t\t\t\t\t62362\t\t\tWhen attempting to import a specific PADS ASCII file (and associated .c, .d and .p library files), Altium Designer would crash and close.\t\t\tSI Analyzer by Keysight\t\t\t\t\t\t62333\t\t\tAdded an enhanced approach to signal integrity analysis directly within the Altium Designer environment, using the SI Analyzer by Keysight.\t\t\tOther\t\t\t\t\t\t62464\t\t\tFor components in a specific Altium 365 Workspace, the system parameter &#039;Description&#039; was not being pushed to the MCAD side when using Altium MCAD CoDesigner.\t\t\tVersion 24.9.1Build:\u00a031\u00a0Date: 11 September 2024Schematic\t\t\t\t\t\t59348\t\t\tIn some cases when releasing a project, the exception &quot;Index was outside the bounds of the array&quot; would be encountered. In addition, and for a specific project, attempting to configure a BOM in an OutJob would result in an &quot;Ambiguous match found&quot; error being encountered.\u00a0(BC:24021)\t\t\t\t\t\t\t61606\t\t\tEmpty sub-parts in alternate views of a multi-part component are now omitted during placement. (I:9891)\t\t\t\t\t\t\t61822\t\t\tThe list of component parameters was not being automatically refreshed after choosing a replacement component through the Properties panel.\t\t\tPCB\t\t\t\t\t\t56380\t\t\tIn some cases when opening Altium Designer with a PCB and the (pinned) PCB Rules And Violations panel visible, right-clicking on the &#039;Component Clearance Constraint&#039; entry in the panel would result in an Access Violation (in module ADVPCB.DLL).\t\t\t\t\t\t\t59683\t\t\tIn some cases when editing an object or using an interactive command, an Access Violation (at address 000000015CEEC132 in module &quot;ADVPCB.DLL&quot;) would be encountered.\t\t\t\t\t\t\t61376\t\t\tIn some cases after copying\/pasting an error-free union of precisely placed components elsewhere in a design, some of the replicated groups of components would produce component clearance violations.\t\t\t\t\t\t\t61955\t\t\tIt is now possible to place components close enough that their courtyard outlines exactly overlap. To disable clearance checking (when a design requires overlapping components) enter a negative value for the Minimum Horizontal Clearance in the applicable Component Clearance rule. (BC:3247,\u00a0BC:22953, I:21187)\t\t\t\t\t\t\t62115\t\t\tFor a selected Workspace component, it is now possible to select and copy its footprint name, from the Footprint Name field in the Properties panel.\t\t\t\t\t\t\t62407\t\t\tA Clearance design rule scoped with InStructureClass vs InStructureClass was not generating DRC violations. (BC:23901)\t\t\tPCB CoDesign\t\t\t\t\t\t62134\t\t\tRule priorities were being inadvertently changed after a new rule was added.\t\t\t\t\t\t\t62185\t\t\tIt was not possible to revert local changes when a local commit was not pushed.\t\t\t\t\t\t\t62195\t\t\tIn some cases after using the Update from Server command, documents were not being reopened to present the latest data pulled from the connected Workspace.\t\t\t\t\t\t\t62323\t\t\tAn error would be encountered when trying to merge a design that contained unions with duplicate names.\t\t\tConstraint Manager\t\t\t\t\t\t61643\t\t\tFrom the Physical view (accessed from PCB), it was not possible to remove impedance-based width values, edit Preferred Width fields, or change the Impedance Profile constraint to &#039;No Impedance&#039;, after removing all Impedance Profiles from the Layer Stack Manager.\t\t\t\t\t\t\t61754\t\t\tWith the &#039;Altium Dark Gray&#039; theme active, the incorrect coloring was being used for the &#039;Constraint set intersection found&#039; dialog.\t\t\t\t\t\t\t61828\t\t\tIt is now possible to enable\/disable basic rules defined in the All Rules view (when accessed from the PCB).\t\t\t\t\t\t\t61832\t\t\tEnhanced the entries and level of detail presented in the ECO dialog, when passing changes made to the Clearances Matrix.\t\t\t\t\t\t\t61833\t\t\tImproved presentation of the Clearances Matrix on the All Rules view (when accessed from the PCB), with all custom values now displayed as separate lines.\t\t\t\t\t\t\t61834\t\t\tAdded an option to &#039;Apply zero Keepout clearance&#039;, as part of the Constraint Manager&#039;s &#039;Clearances Settings&#039; properties.\t\t\tDraftsman\t\t\t\t\t\t60237\t\t\tIn some cases, it was not possible to save a Draftsman document (PCBDwf) using the regular save controls. (BC:9186)\t\t\t\t\t\t\t61051\t\t\tFor a specific PCB design, some components on the paste mask layer, for a specific variant, were missing from the placed Board Fabrication View.\t\t\t\t\t\t\t62373\t\t\tIn the Draftsman document of a specific design, the fills on a particular layer of a placed Board Assembly View were incorrectly rotated.\t\t\t3D-MID Design\t\t\t\t\t\t61575\t\t\tAdded the ability to edit a track by clicking and dragging on one of its vertices, and to create a new vertex by clicking and dragging part way along an existing track segment.\t\t\t\t\t\t\t61984\t\t\tAdded support for the &#039;Net Color Override&#039; feature when working with a 3D-MID document (PcbDoc3D).\t\t\tHarness Design\t\t\t\t\t\t59678\t\t\tIntroduced high-integrity harness design release management using the Project Releaser.\u00a0(BC:23627)\t\t\t\t\t\t\t61057\t\t\tAfter updating a Workspace component in the Layout Drawing to its latest revision, its physical models would have their rotation reset to 0 if they had been previously rotated using the Spacebar.\t\t\t\t\t\t\t61827\t\t\tIn a specific case, opening a HarDwf document that included a Wiring Diagram View or Layout Drawing View containing a text frame with an empty line, would result in the error &quot;Object reference not set to an instance of an object&quot;.\t\t\tPlatform\t\t\t\t\t\t57606\t\t\tIn some cases when accessing the Columns Editor for a TListView object in a scripting Form, an Access Violation (in module &#039;EditScript.DLL&#039;) would be encountered. (BC:21877)\t\t\t\t\t\t\t61421\t\t\tUpdated text throughout the License Management UI to make it clear that subscription renewals are no longer available for perpetual licenses. After expiration, a perpetual license can still be used, but you won&#039;t have access to later updates for Altium Designer beyond that point (no new features\/functionality), nor will you have access to cloud capabilities delivered through, and by, the Altium 365 platform.\t\t\t\t\t\t\t62546\t\t\tWith the advanced settings option &#039;System.UseCefSharp123&#039; ON, a crash would be encountered when opening a second instance of Altium Designer.\t\t\t\t\t\t\t62555\t\t\tIn some cases after updating to Altium Designer 24.8, launching the software would result in the crash &quot;An error occurred during loading dynamic resources&quot; being encountered.\t\t\tData Management\t\t\t\t\t\t56824\t\t\tWhen using the Project Releaser, the revision of the Source Data set was incorrectly being used in the generated data of other data sets. (BC:18641)\t\t\t\t\t\t\t61387\t\t\tIn some cases when adding a freehand drawing to an existing comment (e.g. on a schematic or PCB), the error &quot;ImageBase64 must include mime type&quot; would be encountered. (BC:23737)\t\t\t\t\t\t\t61760\t\t\tWith Altium Designer set to use Japanese localization, attempting to switch the Component editor to its Batch Editing mode would result in the error &quot;Could not convert variant of type (Null) into type (OleStr)&quot;.\t\t\t\t\t\t\t61938\t\t\tThe ability to share a read-only snapshot of a Workspace project, hidden since Altium Designer 24.4, has been brought back in this release.\t\t\t\t\t\t\t62014\t\t\tWhen creating a new project in a connected &#039;On-Prem&#039; server, an error would be encountered when trying to change the Repository Folder using the ellipsis (...) button.\t\t\t\t\t\t\t62041\t\t\tAdded the ability to copy Workspace-side project-level parameters (on the Parameters tab of the Project Options dialog).\t\t\t\t\t\t\t62141\t\t\tIn some cases when connected to an on-prem server and working with a project in an external Git repository, &#039;401 errors&#039; would be encountered and sometimes a lockout from that repository.\t\t\t\t\t\t\t62177\t\t\tAdded the ability to view and modify parameters for a Workspace project template, when creating a new project in the Create Project dialog.\t\t\t\t\t\t\t62600\t\t\tWhen using the &#039;Component Database to Workspace Data Synchronization&#039; feature, attempting to add a DbLib (connected to a MySQL database) to the .CmpSync document would result in an error being encountered.\t\t\tImport\/Export\t\t\t\t\t\t58206\t\t\tIn some cases when defining Allegro library files to be imported through the Import Wizard, an Access Violation (in module &quot;LoadAllegro.IWZ&quot;) would be encountered.\t\t\t\t\t\t\t61722\t\t\tWhen importing a specific Allegro design, the generated PCB document was empty.\t\t\tOther\t\t\t\t\t\t60385\t\t\tIn some cases, an Access Violation (in module &quot;X2.EXE&quot;) would be encountered.\t\t\t\t\t\t\t61005\t\t\tIn some cases when accessing a menu that included a network printer (using IPP protocol, port WSD set as default), an Access Violation (in module &quot;X2.EXE&quot;) would be encountered.\t\t\tVersion 24.8.2Build:\u00a039\u00a0Date: 21 August 2024Schematic\t\t\t\t\t\t60624\t\t\tIn some cases, the error &quot;Cannot set Visibility or call Show, ShowDialog, or WindowInteropHelper.EnsureHandle after a Window has closed&quot; would be encountered.\t\t\t\t\t\t\t61353\t\t\tWhen using Board Level Annotation, a document channel set to not use &#039;Designator Index Control&#039; had incorrect designator indexing applied.\t\t\t\t\t\t\t61429\t\t\tParameter update settings defined in the Library Update Settings dialog (Item Manager advanced update options) were not being retained.\t\t\tPCB\t\t\t\t\t\t56711\t\t\tThe Interactive Routing tools now support the ability to configure and apply &quot;Trace Centering&quot;, allowing for traces to be centered between obstacles as you route.\t\t\t\t\t\t\t57986\t\t\tInteractive Routing tools now support true &quot;Zero Mitering&quot;. If the Miter Ratio = 0, no miter will be created (previously, a short miter fully covered by adjacent traces was created).\t\t\t\t\t\t\t59164\t\t\tAdded a new &#039;Routing Neck-Down&#039; rule enabling you to define the maximum allowed length of a Neck-Down trace when its width is less than the Preferred Width. (I:11512)\t\t\t\t\t\t\t59341\t\t\tAdded the ability to create a single layer PCB, with corresponding support in the PCB editor, Layer Stack Manager and generated outputs. (I:10797)\t\t\t\t\t\t\t59835\t\t\tAdded a round &#039;Donut&#039; shape to the listing of predefined pad shapes available when defining the padstack. (I:18588)\t\t\t\t\t\t\t60366\t\t\tAn &#039;Auto-Shrinking&#039; option has been added to the Interactive Router (single-ended routing), allowing a trace to be narrowed to the applicable width in tight places as you route.\t\t\t\t\t\t\t60618\t\t\tAfter exporting a PCB to EDB format, opening the file in Ansys revealed arcs not to be very smooth in places.\t\t\t\t\t\t\t61062\t\t\tAfter importing a DXF file, attempting to select and convert all individual shapes into a single region (Tools \u00bb Convert \u00bb Create Region from Selected Primitives) would only convert one of them.\t\t\t\t\t\t\t61083\t\t\tWhen selecting holes through the PCB panel&#039;s Hole Size Editor, only one via from each selected group (in the Unique Holes section) was getting selected within the main design area. (BC:23361)\t\t\t\t\t\t\t61208\t\t\tFor a specific design, Altium Designer would hang when running a DRC if the advanced option PCB.Rules.Width.CopperLoopsCalculation was enabled and when the &#039;Check Min\/Max Width for Physically Connected&#039; option was also enabled in a Width rule. (BC:23283)\t\t\t\t\t\t\t61418\t\t\tWhen using the Constraint Manager with a project, specific clearances defined for net classes were not being observed when interactively routing and dragging. (BC:23164)\t\t\t\t\t\t\t61448\t\t\tDifferent clearances were being applied between a component&#039;s SMD pads and a polygon pour if the SMD pads had their &#039;Plated&#039; property incorrectly set to ON. (BC:20733)\t\t\t\t\t\t\t61610\t\t\tRemoved the &#039;[nOhm]&#039; entry from the label for the Copper Resistance field (when configuring Layer Stack properties through the Properties panel). Value entered is in n\u03a9.\t\t\t\t\t\t\t61729\t\t\tWhen routing a differential pair between existing routed parts of the pair, it was not possible to end the route at any point on existing Diffpair track.\t\t\t\t\t\t\t61748\t\t\tThe Interactive Router would ignore a closed region as being an obstacle, resulting in a dragged track (within the region) suddenly being pushed outside of it.\t\t\t\t\t\t\t61916\t\t\tIn some cases when using the Automatic Length Tuning feature (with default parameters), the resulting tuning patterns would create short-circuit violations.\t\t\t\t\t\t\t62025\t\t\tFor a Workspace component referencing a PCB Footprint with an empty Name, using the Update From PCB Libraries feature would show this as a failed match item and &quot;Component Is Not Properly Linked And Synchronized. No Comparison Data Available.&quot;\t\t\t\t\t\t\t62030\t\t\tThe feature to control whether or not drill symbols are automatically updated (live update) is now officially made Public with this release (OFF by default).\t\t\t\t\t\t\t62232\t\t\tWhen viewing a board in 3D, clicking to select a component would select the 3D body instead, presenting information for the latter in the Properties panel instead of that of the component.\t\t\t\t\t\t\t62345\t\t\tWhile interactively routing, it was not possible to change the Via Diameter or Via Hole Size through the Properties panel.\t\t\tPCB CoDesign\t\t\t\t\t\t61267\t\t\tAdded support for &#039;Copper Resistance&#039; and &#039;Via Plating Thickness&#039; parameters (defined as part of Layer Stack Manager properties).\t\t\tConstraint Manager\t\t\t\t\t\t57002\t\t\tIn some cases after successfully passing changes from the schematic to the PCB through ECO, accessing the ECO again would list the same &#039;Change Rules&#039; actions.\t\t\t\t\t\t\t59635\t\t\tValues set (on the PCB side) for Min Width\/Preferred Width\/Max Width for inner layers were being reset to defaults, after executing an ECO to update the PCB with changes made on the schematic. (BC:23198)\t\t\t\t\t\t\t60732\t\t\tAdded the ability to export and import constraints between designs.\t\t\t\t\t\t\t60823\t\t\tSome of the icons used within the UI were inconsistent.\t\t\t\t\t\t\t61024\t\t\tWhen accessing the Constraint Manager from the schematic, it is now possible to choose and configure specific width constraints (per layer) for any PCB document in the same design project, and independently across layer stacks defined for that chosen board. This applies when configuring Width and Differential Pairs Routing constraints (from the Physical view).\u00a0(BC:23866)\t\t\t\t\t\t\t61082\t\t\tAfter saving a selected cell as a constraint set from the Clearances view (accessed from PCB), the constraint set was not being displayed after saving changes and then closing\/reopening the Constraint Manager.\t\t\t\t\t\t\t61195\t\t\tIn a specific case, changing a value for a cell in the Clearances view (accessed from PCB) and then clicking another cell, would result in the AV &quot;The given key was not present&quot; being encountered.\t\t\t\t\t\t\t61200\t\t\tThe constraint UI for the Clearance rule when accessed from the All Rules tab has been corrected, now matching that seen from the main Clearances view.\t\t\t\t\t\t\t61227\t\t\tThe command to access the Constraint Manager, from the Schematic side, has been moved up in the main Design menu to make it positionally similar to that on the PCB side.\t\t\t\t\t\t\t61320\t\t\tIn some cases, changing the layer stack for a PCB and then accessing the (already open) Constraint Manager would result in the error &quot;An item with the same key has already been added&quot; being encountered.\t\t\t\t\t\t\t61629\t\t\tAfter changing the size of a room on a PCB and saving, making and saving any subsequent change in the Constraint Manager would result in the room being set back to its previous size.\t\t\t\t\t\t\t61702\t\t\tIt is now possible to enable\/disable advanced rules defined in the All Rules view (when the Constraint Manager is accessed from the PCB).\t\t\t\t\t\t\t61791\t\t\tBy default, directives imported from read-only documents (device sheets, managed sheets) cannot be modified unless the &#039;Make Device Sheets in Projects Read-only&#039; option is disabled (Data Management - Device Sheets page of Preferences).\t\t\t\t\t\t\t61836\t\t\tAdded the ability to enable use of a chosen Impedance Profile, when configuring a Width or Differential Pairs Routing rule on the schematic side (through the Edit PCB Rule (From Schematic) dialog).\t\t\tDraftsman\t\t\t\t\t\t60961\t\t\tIn some cases after deleting merged cells in a placed table, the error &quot;Index was outside the bounds of the array&quot; would be encountered. The document could not be opened again if saved after this.\t\t\t3D-MID Design\t\t\t\t\t\t56593\t\t\tThe menus for the 3D PCB environment are now loaded correctly from the outset, without any manual configuration required.\t\t\t\t\t\t\t61576\t\t\tAdded the ability to select and drag multiple components on the substrate.\t\t\t\t\t\t\t61580\t\t\tThe name of (and full path to) the 3D substrate file is now presented in the Properties panel.\t\t\tMulti-board Design\t\t\t\t\t\t60594\t\t\tAfter swapping pin numbers of a mated part, the net name of the System Connector and Mated part were not matching, making it look like two different nets were getting shorted together.\t\t\t\t\t\t\t61035\t\t\tIn some cases, importing changes from a child project into the multi-board schematic resulted in the repetitive error &quot;The Reference Pin is in the net&quot; being encountered.\t\t\t\t\t\t\t61479\t\t\tChanges to Module Net naming was not preserved in the Connection Manager, nor visible in the Properties panel, but was transferred to child projects through the ECO process.\t\t\tHarness Design\t\t\t\t\t\t60593\t\t\tAdded ability to specify &#039;Strip Length&#039; and &#039;Pull Off Length&#039; when defining a crimp-type cavity in the Wiring Diagram. These properties are included in the wiring list and connection table objects in a HarDwf document.\t\t\t\t\t\t\t60765\t\t\tAdded support for splitting a cable by adding splices to selected wires of the cable.\t\t\t\t\t\t\t61137\t\t\t&#039;No Connect&#039; objects placed within a Wiring Diagram were displayed with the generic &#039;NC&#039; entry in the HarDwf&#039;s Wiring List and Connection Table, instead of real designator naming.\t\t\t\t\t\t\t61331\t\t\tAdded the ability to display the text value for a layout label in the BOM.\t\t\t\t\t\t\t61684\t\t\tAdded support for using commenting and tasks features in a Harness Draftsman document (.HarDwf).\t\t\tPlatform\t\t\t\t\t\t61372\t\t\tIn some cases when changing the main monitor display (and with Altium Designer open with a Draftsman document active), the error &quot;UCEERR_RENDERTHREADFAILURE (Exception from HRESULT:0x88980406)&quot; would be encountered. (BC:20761)\t\t\t\t\t\t\t61422\t\t\tThe &#039;Open Any Existing Document&#039; button would disappear from the Quick Access Bar when connected to a Workspace.\t\t\t\t\t\t\t61704\t\t\tIt was not possible to enter a space character in the Project Name field when creating a new project.\t\t\t\t\t\t\t62073\t\t\tWith this release, Altium Designer switches from using .NET Framework 4.8 to .NET 6.\t\t\tData Management\t\t\t\t\t\t60805\t\t\t&#039;History &amp; Version Control&#039; right-click context menu (Projects panel) updated with minor terminology changes and comparison commands in context with the document under the cursor when accessed.\t\t\t\t\t\t\t61213\t\t\tWhen cloning a component with defined part choice(s) in the Component editor&#039;s Batch Editing mode, the part choice data was not being included.\t\t\t\t\t\t\t61216\t\t\tFor an opened Workspace design, trying to make a schematic or integrated library when not connected to the Workspace would result in the error &quot;Access denied! User login required for this service&quot;. (BC:23254)\t\t\t\t\t\t\t61299\t\t\tThe &#039;Save Project as Template to Server&#039; command has been removed from the File menu for a Scripting project, since it is not applicable to this type of project.\t\t\t\t\t\t\t61527\t\t\tIn some cases, using the Window \u00bb Close All command right after connection to a Workspace, would result in the error &quot;Unable to cast COM object of type &quot;System.__ComObject&quot;...&quot;.\t\t\t\t\t\t\t61604\t\t\tIt was not possible to assign a default OutJob document through the Defaults tab of the Data Management - Templates page of Preferences. (BC:23553)\t\t\t\t\t\t\t61608\t\t\tAdded a new violation type &#039;Number of Pads exceeds Number of Pins&#039; as part of the validation checks that can be configured for a Workspace component. (I:17154)\t\t\t\t\t\t\t61692\t\t\tWhen defining a Components Synchronization Configuration document (*.CmpSync) for Database to Workspace component synchronization, you can now map a database parameter to the Workspace component&#039;s Item ID.\t\t\t\t\t\t\t61693\t\t\tIn some cases and for some suppliers, ActiveBOM was not able to find supplier data for file-based components with linked supplier data. (BC:23454)\t\t\t\t\t\t\t61694\t\t\tWhen batch releasing changes to components (Batch Component Editing), all components were being disabled for release by default, if a part choice for at least one had been changed through the preview window.\t\t\t\t\t\t\t61941\t\t\tIt was not possible to choose the native Git repository as the target, when making a local project available on a connected Altium On-Prem Enterprise Server.\t\t\t\t\t\t\t61973\t\t\tIn some cases when working with the Components panel, the following error would be encountered &quot;System.AggregateException: One or more errors occurred. ---&gt; System.ServiceModel.FaultException: Access denied! User login required for this service&quot;.\t\t\t\t\t\t\t62277\t\t\tIn some cases when generating a report of exported comments through an OutJob, the error &quot;Object reference not set to an instance of an object&quot; would be encountered.\t\t\t\t\t\t\t62367\t\t\tWhen creating a new component in a connected Workspace, switching to Batch Component Editing mode would see the defined target folder path truncated to a maximum of &#039;2 child folders&#039; below the &#039;Components&#039; parent folder.\t\t\tImport\/Export\t\t\t\t\t\t58148\t\t\tWhen importing a specific xDX Designer design, the &#039;Symbol name&#039; parameter was missing for all imported parts.\t\t\t\t\t\t\t60290\t\t\tWhen importing an Xpedition design\/library, support has been added for round &#039;Donut&#039; pads.\t\t\t\t\t\t\t60990\t\t\tWhen importing an xDX Designer design, active low net labels were being imported as active high (net label negation was not supported), causing different nets (with same name) to be incorrectly connected.\t\t\t\t\t\t\t61337\t\t\tWhen importing a specific Allegro design (brd + dcfx), clearance values for Fill-Fill, Poly-Poly and Region-Region were incorrect, when compared to the &#039;Shape To Shape&#039; value defined in Allegro.\t\t\t\t\t\t\t61338\t\t\tWhen importing a specific Allegro design (and dcfx file), the imported Routing Width rule referred to the physical CSet name instead of the actual Net name.\t\t\t\t\t\t\t61803\t\t\tWhen importing a KiCad v.8 design, designators were not being imported correctly on the generated PCB, instead appearing as &#039;Unx&#039;, which broke component linking to the schematic-side components.\t\t\tCircuit Simulation\t\t\t\t\t\t60625\t\t\tIn some cases when opening a project and the Simulation Dashboard panel was active, the error &quot;ValueFactory attempted to access the Value property of this instance&quot; would be encountered.\t\t\tOther\t\t\t\t\t\t56818\t\t\tAltium Designer would freeze when connected to an Altium On-Prem Enterprise Server and attempting to publish custom extensions using the Altium DXP Developer interface.\t\t\tVersion 24.7.2Build:\u00a038\u00a0Date: 23 July 2024Schematic\t\t\t\t\t\t59542\t\t\tIn some cases when using Smart Paste to paste an object in an array, the row spacing value would lead to incorrect placement of the object in relation to defined columns for the array. (BC:22584)\t\t\t\t\t\t\t60079\t\t\tAdded the ability to choose a component as an alternate part in a variant, without changing the symbol on the schematic or adding a footprint to the PCB. (I:4369, I:18678)\t\t\t\t\t\t\t60725\t\t\tImproved single\/multi-part symbol handling. If a multi-part component only has primitives defined in one sub-part, the designator suffix is now hidden. No longer possible to select a sub-part (or alternate display mode) when that sub-part \/ mode is empty (has no primitives).\t\t\t\t\t\t\t61121\t\t\tAdded a new &#039;Port with no matching ports&#039; violation type to the Error Reporting tab (Project options) for detecting, in a flat design, a port that has no corresponding\/matching port across source schematics. (I:5885)\t\t\t\t\t\t\t61122\t\t\tThere was a visual bug with Port names on compiled sheets (and generated PDF output) in multi-channel designs not being displayed correctly. The channel suffix was being used, rather than taking the higher level naming.\t\t\t\t\t\t\t61124\t\t\tFor a project using a managed sheet and a defined variant with an alternate component, running Board Level Annotation loaded the alternate as an additional component each time.\t\t\t\t\t\t\t61214\t\t\tIn some cases when adding an alternate part for a variant, the error &quot;Illegal characters in path...&quot; would be encountered.\t\t\t\t\t\t\t61659\t\t\tIn some cases, Altium Designer would &#039;freeze&#039; when moving objects on schematics in a large design, and where the Properties panel was open.\t\t\tPCB\t\t\t\t\t\t59354\t\t\tWhen entering a value (without units) for a pad&#039;s Corner Radius, the default unit was being unexpectedly changed, so the expected value (in %) would instead be added as that value in mil. (BC:23124)\t\t\t\t\t\t\t59993\t\t\tExtended the Return Path rule, with ability to specify a &#039;Max Stitch Via Distance&#039;, with Batch DRC support to flag a violation if this distance is exceeded. (I:12747)\t\t\t\t\t\t\t60682\t\t\tIntroduced a new implementation of automatic loop removal in the Interactive Router, improving behavior in the case of any angle routing and laying the foundation for future enhancements.\t\t\t\t\t\t\t61026\t\t\tThe Gap value, for a Clearance rule shown in the Applicable Binary Rules dialog, did not match the value defined in the Constraint Manager.\t\t\t\t\t\t\t61037\t\t\tWith PCB.Pad.CustomShape.CornerRadiusAbsolute enabled, the corner radius (%) defined in a PvLib created with a previous version of the software (","tags":"","url":"altium-designer\/24\/documentation-altium-designer-public-release-notes.html"},
{"title":"Tutorial - A Complete Design Walkthrough with Altium Designer","text":"Welcome to the world of electronic product development in Altium&#039;s world-class electronic design software. This tutorial will help you get started by taking you through the entire process of designing a simple PCB \u2013 from idea to output files.The DesignThe design for which you will be creating the schematic and designing a printed circuit board (PCB) is a simple astable multivibrator. The circuit is shown below; it uses two general-purpose NPN transistors configured as a self-running astable multivibrator.\tCircuit for the multivibrator \tAnimation of the designed PCBSigning in to an Altium Account and Connecting to a WorkspaceMain pages:\u00a0Signing in to Your Altium Account,\u00a0Accessing Your WorkspaceAltium Designer can connect to a Workspace to provide a single, secure data source and storage while affording unparalleled collaboration. It could be an Altium 365 Workspace \u2013 a Workspace hosted on the Altium 365 cloud-based infrastructure platform, or an\u00a0Enterprise Server Workspace \u2013 a Workspace provided through the\u00a0Altium On-Prem Enterprise Server,\u00a0installed and managed by your own IT department.Learn more about Designing with a Connected WorkspaceThis tutorial focuses on using Altium Designer with a connected Workspace \u2013 the most streamlined and empowered environment for your design needs.\u00a0To complete this tutorial, you will need to be connected to a Workspace. It is assumed that your Workspace has been activated\/installed with the sample data.First, you need to connect to your Altium Account if you have not already.\u00a0Your Altium Account provides access to Altium on-demand services, including a connection to an Altium 365 Workspace and manufacturer part data.\t\t\tWhen\u00a0you are not signed in to your Altium Account, the Current User control at the top right of the design space is presented as\u00a0. Click it and then select the\u00a0 entry from the associated menu.\t\t\t\t \t\t\t\t\t\tIn the Sign In dialog that opens, click the\u00a0 button to open a new page in your default browser from which you can sign in to your Altium Account.\t\t\t\t \t\t\t\t\t\tOnce you are signed in, the Current User control will change to reflect that you have\u00a0signed in to your Altium Account by displaying your Altium profile picture, or avatar (e.g.,\u00a0).\t\t\t\t \t\t\t\t\t\tMake sure that you are using a valid Altium Designer license. License selection is performed on the License Management view accessed by clicking the\u00a0Current User control and selecting the\u00a0 entry from the associated menu.\t\t\t\t \t\t\t\tRefer to the\u00a0License Management page to learn more about available license types and how to manage them.\t\t\t\t\t\tClose the\u00a0License Management view by right-clicking\u00a0its tab at the top of the design space and selecting the Close License Management\u00a0command from the context menu.\t\t\t\t \t\t\tThen connect to your Workspace, either Altium 365 Workspace or Enterprise Server Workspace.\u00a0When\u00a0you are not connected to a Workspace, the Active Workspace control at the top right of the design space is presented as\u00a0.Connecting to an Altium 365 WorkspaceClick the Active Workspace control and then select the entry for the specific Altium 365 Workspace you wish to connect to from the associated menu.\u00a0The Active Workspace control will change to reflect that you have connected to an Altium 365 Workspace by displaying\u00a0the name of the Workspace (e.g., ). Connecting to an Enterprise Server Workspace\t\t\tClick the\u00a0Current User control at the top right of the design space\u00a0(e.g.,\u00a0) and then select the\u00a0\u00a0entry from the associated menu.\t\t\t\t \t\t\t\t\t\tIn the Sign in dialog that opens, enter the URL for the Workspace (Server Address) and your Workspace access credentials (User Name and Password), then click the \u00a0button.\u00a0The Active Workspace control will change to reflect that you have connected to an Enterprise Server Workspace by displaying\u00a0the name of the Workspace.\t\t\t\t \t\t\t\tYou are ready to begin capturing (drawing) the schematic. The first step is to create a PCB project.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-tutorial-complete-design-walkthrough.html"},
{"title":"Creating the Project and Schematic Document","text":"In Altium Designer, a PCB design project is the set of documents (files) required to specify and manufacture a printed circuit board. The project file (*.PrjPCB) is an ASCII file that lists the documents in the project\u00a0as well as other project-level settings, such as the required electrical rule checks.Creating a New PCB ProjectMain page:\u00a0Creating Projects and DocumentsA new design project is created using the Create Project dialog.\t\t\tSelect the\u00a0File \u00bb New \u00bb Project\u00a0command from the main menus.\t\t\t\t \t\t\t\t\t\tThe Create Project dialog will open. In this dialog:\t\t\t\t\t\t\t\t\t\t\tSelect the connected Workspace in the list of Locations. In the image below, the Workspace is named\u00a0Company Workspace.\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn the Project Type region of the dialog, select  under the PCB entry.\t\t\t\t\t\t\t\t\t\t\t\t\t\tEnter a suitable name in the Project Name field, e.g.,\u00a0Multivibrator.\t\t\t\t\t\t\t\t\t\t\t\t\t\tEnter a suitable description in the Description field, e.g.,\u00a0Simple multivibrator design for the tutorial.\t\t\t\t\t\t\t\t\t\t\t\t\t\tWhen connected to an Altium 365 Workspace, ensure the Version Control\u00a0option is enabled.\t\t\t\t\t\t\t\t\t\t\t\t\tWhen connected to an Enterprise Server Workspace, the Version Control option is not available in the Create Project dialog. In this case, the\u00a0option is effectively checked.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tEnable the Constraint Management option.\t\t\t\t\t\t\t\t\t\t\t\t\tIf the Constraint Management option is not available\u00a0in the Create Project dialog, the design rule system will be used for the project.\u00a0Depending on whether the\u00a0Constraint Manager\u00a0or the design rule system is used, this tutorial will provide relevant guides to complete the design.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tClick the Advanced control. The Folder field defines the name of the folder in the Workspace where your project will\u00a0be stored. The default is to have a Projects folder in the Workspace.\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn the Local Storage field, select a suitable location to store the working copy of the project. A folder of the same name as the project will automatically be created in this location, and the working copy of the project file will be saved in it.\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\tClick the\u00a0\u00a0button at the bottom right of the dialog to close it and create the project. This will take a few moments, as the project is created in the working folder and\u00a0in the Workspace.\t\t\tAn entry for the new project, Multivibrator.PrjPCB, will appear in the Projects panel. A small green check () will be displayed next to the project entry. This indicates that the version of the document opened in Altium Designer is the same as the version of the document stored in the Workspace (they are synchronized).\tA panel that is not currently visible can be opened via the  button at the bottom right of the design space.\u00a0Panels that are currently visible are marked with a check in the menu.\t \tTo provide a quick visual summary of document states, document entries in the Projects panel are accompanied by icons that indicate their open\/modified status and their status in relation to the version control system (VCS). Some document icons that you might encounter when working on this tutorial project and their meanings are listed below.\t\t\t\t\t\t\t\t\t\t \t\t\t\tOpen\t\t\t\tThe document is open.\t\t\t\t\t\t\t\t\t\t \t\t\t\tOpen and locally modified\t\t\t\tThe document is open and has been modified (yet to be saved locally).\t\t\t\t\t\t\t\t\t\t \t\t\t\tNo modification\t\t\t\tThe local copy of the document matches the document in the Workspace and is up to date.\t\t\t\t\t\t\t\t\t\t \t\t\t\tModified\t\t\t\tThe local copy of the document has been modified and saved locally but is not yet saved to the Workspace.\t\t\t\t\t\t\tTo learn more about document status indication, refer to\u00a0Indicating Document Status.\tAdding a Schematic Document to the ProjectMain page:\u00a0Creating Projects and DocumentsThe next step is to add a new schematic document to the project.\t\t\tRight-click on the project entry in the Projects panel\u00a0then select the\u00a0Add New to Project \u00bb Schematic\u00a0command from the context menu. A blank schematic sheet named Sheet1.SchDoc will open in the design space and an entry for this schematic will appear linked to the project in the Projects panel\u00a0under the Source Documents entry.\t\t\t\t\t\t\tWhen connected to the Enterprise Server Workspace, the Select configuration item dialog will open after selecting Add New to Project \u00bb Schematic. Select a schematic template from those\u00a0stored in your Workspace (e.g.,\u00a0ANSI B Landscape) and click the OK button ().\t\t\t\t\t\t\tWhen the blank schematic sheet opens, you will notice that the design space changes. The main menu\u00a0bar includes new items, and a bar with buttons becomes visible at the top of the design space \u2013 you are now in the Schematic editor. Each editor presents its own set of menus and panels and supports its own set of shortcut keys.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Tutorial_AddNewSchematic_AD24\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTo save the new schematic document locally, select the Save As\u00a0command from the right-click menu of the document entry in the Projects panel. The Save As dialog will open, ready to save the schematic in the same location as the project file. Type the name Multivibrator in the File name field and click the\u00a0Save\u00a0button.\t\t\t\t\t\t\tThere is no need to type in the file extension\u00a0as it will be added automatically.\t\t\t\t\t\t\t \t\t\t\t\t\tBecause a new document was added to the project, the project file has changed. Right-click on the project entry in the Projects panel\u00a0then select Save from the context menu to save the project locally. The VCS status of the project file will change to Modified indicated by the\u00a0\u00a0icon.\t\t\t\t \t\t\t\t\t\tSave the new schematic and the modified project file to the Workspace. To do this:\t\t\t\t\t\t\t\t\t\t\tClick the Save to Server control next to the project entry in the Projects panel.\t\t\t\t\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\tThe Save to Server dialog will open. Enter a meaningful comment the describes\u00a0the change into\u00a0the Comment field (e.g., A new blank schematic sheet added), then click the OK button. When saving is complete, the VCS status of the project file and the schematic document\u00a0will change to No modification indicated by the\u00a0\u00a0icon.\t\t\t\t\t\t\t\t \t\t\t\t\t\t\t\t\t\t\tTo navigate in a schematic sheet, use Ctrl+Mouse Wheel\u00a0to zoom in and out and Right-Click, Hold&amp;Drag\u00a0to pan.\u00a0There are also a number of useful commands in the View main menu, such as Fit All Objects (Ctrl+PgDn).\tConfiguring Schematic Document OptionsMain page: Setting Up a Schematic DocumentBefore you start capturing the circuit, it is good to set up the schematic document options as required, including the sheet size, as well as the snap and visible grids. The properties of most entities, including the schematic sheet, are configured in the interactive Properties panel. The panel displays the properties of the selected object, or if no object is selected, it displays the properties of the schematic sheet.\t\t\tMake the\u00a0Properties panel visible by\u00a0clicking the  button at the bottom right of the design space and selecting\u00a0Properties from the menu that opens.\t\t\t\t \t\t\t\t\t\tSelect a template for the schematic sheet from those that are stored in your Workspace.\t\t\t\t\t\t\tWhen connected to the Enterprise Server Workspace, skip this step because the required template was already selected when you created the schematic document.\t\t\t\t\t\t\tTo do this:\t\t\t\t\t\t\t\t\t\t\tIn the\u00a0Page Options region of the General tab, select Template\u00a0for the Formatting and Size\u00a0option, then select the ANSI B Landscape\u00a0template under the entry of your connected Workspace in the Template drop-down.\t\t\t\t\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\tThe Update Template\u00a0dialog will open. Select Just this document for the Choose Document Scope option and Add new parameters that exist in the template only for the Choose Parameter Actions\u00a0option, then click the OK button. In the information dialog that opens, click the OK button.\t\t\t\t\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\tIn the\u00a0General\u00a0region of the General tab, set the 100mil value for the Visible Grid and Snap Grid.\t\t\t\t \t\t\t\t\t\tTo make the document fill the design space, select the\u00a0View \u00bb Fit Document\u00a0command from the main menus.\t\t\t\t \t\t\t\t\t\tSave the schematic document locally by right-clicking its entry in the Projects panel and selecting\u00a0Save\u00a0from the context menu.\t\t\t\tWith the project and schematic document created, the next step is to\u00a0search for the required components and save them to your connected Workspace.\tvar p = document.getElementsByClassName(&quot;Counter&quot;);for (k = 0; k &lt; p.length; k++) {Bloberator(p[k].id, &quot;0&quot;);}document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);function Update(ss, n) {var g = (document.getElementById(ss).innerHTML) - 1;var TextArray = document.getElementsByClassName(ss + ss);var ImageArray = document.getElementsByClassName(ss);if ((g == 0) &amp; (n == -1)) {n = 0;}ImageArray[g].style.opacity = &quot;0&quot;;ImageArray[g].style.zIndex = &quot;-1&quot;;if (g &lt; TextArray.length) {TextArray[g].style.display = &quot;none&quot;;}g = g + (n);if (g == ImageArray.length) {g = 0;}var v = ImageArray[g].getElementsByTagName(&quot;video&quot;)[0];if (v != null) {v.currentTime = 0;v.play();}ImageArray[g].style.opacity = &quot;1&quot;;ImageArray[g].style.zIndex = &quot;1&quot;;if (g &lt; TextArray.length &gt; 0) {TextArray[g].style.display = &quot;inherit&quot;;}document.getElementById(ss).innerHTML = g + 1;Bloberator(ss, g);}function Bloberator(sss, m) {var dots = &quot;&quot;;var IR = document.getElementsByClassName(sss);for (d = 0; d &lt; IR.length; d++) {if (d == m) {dots = dots + &quot;&quot;;} else {dots = dots + &quot;&quot;;}}var dotrows = document.getElementsByName(sss);for (x = 0; x &lt; dotrows.length; x++) {dotrows[x].innerHTML = dots;}}","tags":"","url":"altium-designer\/24\/documentation-altium-designer-tutorial-creating-project-schematic-document.html"},
{"title":"Searching for and Acquiring the Components","text":"Main page:\u00a0Searching for Manufacturer PartsA real-world component that gets mounted on the board is represented as a schematic symbol during design capture and as a PCB footprint for board design.\u00a0Components for a PCB design project can be created in your company&#039;s Workspace library, from where they are then placed using the Components panel.A new Workspace library component is created using the Component editor (that can operate in either the Single Component Editing or Batch Component Editing mode), where you can define all component data (schematic symbol, PCB footprint, parameters, part choices, etc.) manually or use data provided through the Manufacturer Part Search panel. This panel gives you instant and up-to-date access to a powerful component search and aggregation system, detailing millions of components from thousands of manufacturers, each with real-time supply chain information. Many of the components have a symbol and a footprint.A new Workspace library component can be created based on the data of any part in the Manufacturer Part Search panel \u2013 that effectively means that any listed part can be acquired to your Workspace. This involves creating a new component using the Component editor in its Single Component Editing mode, pre-filled with information from the selected part.For this tutorial, all required components will be created in your connected Workspace using the manufacturer part data.\tThe\u00a0Manufacturer Part Search\u00a0panel can operate in two modes: normal and compact. In this tutorial, the panel in its normal mode is shown and described. Make the panel wider so it is displayed in its normal mode. The button at the top right of the panel is shown as\u00a0 when the panel is in its normal mode. When it is in its compact mode, the controls will rearrange, so they may not present exactly as it is shown and described here.\tFinding and Acquiring the Transistor\t\t\tOpen the Manufacturer Part Search panel. To do this,\u00a0click\u00a0the  button at the bottom right of the design space and select\u00a0Manufacturer Part Search from the menu.\t\t\t\t\t\tIn the Search field at the top of the panel, type\u00a0transistor bc547\u00a0and press Enter. Search results will be presented in the panel.\t\t\t\t \t\t\t\t\t\tClick the entry of the\u00a0BC547CG transistor from\u00a0ON Semiconductor to select it in the\u00a0results grid. Click the SPNs link that appears to explore the part availability.\t\t\t\t \t\t\t\t\t\tThe\u00a0\u00a0icon in a part entry means that there are models assigned to this part. Display the Details pane (if not already shown) using the\u00a0\u00a0button so that you can explore the details of the selected part, including its parameters and models.\t\t\t\t \t\t\t\t\t\t\tWhile the manufacturer lifecycle of\u00a0the\u00a0ON Semiconductor\u00a0BC547CG transistor has the\u00a0Obsolete\u00a0manufacturer lifecycle state (indicated by the red stripe in the grid and at the top right of the Details pane), it can be used to create a new component. At a later stage of this tutorial, when configuring the project BOM, another manufacturer part will be selected for the\u00a0component.\t\t\t\t\t\t\t\t\tWhen the transistor is selected in the panel, click the\u00a0\u00a0button\u00a0in the top region of the Details pane.\t\t\t\t \t\t\t\t\t\tIn the Create new component dialog that opens, select the Transistors component type and click OK.\t\t\t\t \t\t\t\t\t\tIn the Use Component Data dialog that opens, make sure that the Show only matching with template option at the top of the dialog is disabled and enable options in header rows on the\u00a0Parameters, Models, and Datasheets tabs to add all available parameters, models, and\u00a0datasheets to the component, then click OK.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Tutorial_Dlg_UseComponentData_AD24\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe Component editor will open in its Single Component Editing mode, with the chosen data loaded. At this stage, you can check that the symbol, footprint, and parameters comply with your requirements and make any required updates.\t\t\t\t\t\t\tYou can close the Manufacturer Part Search panel for now and make it visible again later using the  button menu.\t\t\t\t\t\t\t \t\t\t\t\t\tClick the Save to Server control next to the component entry in the Projects panel.\t\t\t\t \t\t\t\t\t\tIn the Edit Revision for Item dialog that opens, type in a meaningful comment to the component revision release into the Release Notes field (e.g., Initial release of the transistor component\u00a0saved from Manufacturer Part Search), then click OK. A status dialog will open while the component is saved to the Workspace. When this is complete, the Component editor will close.\t\t\t\t \t\t\tFinding and Acquiring the Capacitor\t\t\tReturn to the Manufacturer Part Search panel and use the panel&#039;s Search field to search for\u00a0capacitor 22 nF 16 V 0603.\t\t\t\t\t\tSelect the entry of the\u00a0C0603C223J4RACTU capacitor from\u00a0KEMET in the search result grid and click the\u00a0\u00a0button in the Details pane.\t\t\t\t\t\tIn the Create new component dialog that opens, select the Capacitors component type and click OK.\t\t\t\t\t\tIn the Use Component Data dialog that opens, make sure that the Show only matching with template option at the top of the dialog is disabled and enable options in header rows on the\u00a0Parameters, Models, and Datasheets tabs to add all available parameters, models, and\u00a0datasheets to the component, then click OK.\t\t\t\t\t\tThe Component editor will open. In the Name field in the Component region at the top left of the editor, change the component name to Capacitor 22nF +\/-5% 16V 0603.\t\t\t\t \t\t\t\t\t\tClick the Save to Server control next to the component entry in the Projects panel.\t\t\t\t\t\tIn the Edit Revision for Item dialog that opens, type in a meaningful comment to the component revision release into the Release Notes field (e.g., Initial release of the capacitor component\u00a0saved from Manufacturer Part Search), then click OK. A status dialog will open while the component is saved to the Workspace. When this is complete, the Component editor will close.\t\t\tFinding and Acquiring the Resistors\t\t\tReturn to the Manufacturer Part Search panel and use the panel&#039;s Search field to search for resistor 100 K 5% 0805.\t\t\t\t\t\tSelect the entry of the\u00a0ERJ-6GEYJ104V resistor\u00a0from\u00a0Panasonic in the search result grid and click the\u00a0\u00a0button in the Details pane.\t\t\t\t\t\tIn the Create new component dialog that opens, select the Resistors component type and click OK.\t\t\t\t\t\tIn the Use Component Data dialog that opens, make sure that the Show only matching with template option at the top of the dialog is disabled and enable options in header rows on the\u00a0Parameters, Models, and Datasheets tabs to add all available parameters, models, and\u00a0datasheets to the component, then click OK.\t\t\t\t\t\tIn the Name field in the Component region at the top left of the Component editor, change the component name to Resistor 100K +\/-5% 0805 125 mW.\t\t\t\t\t\tClick the Save to Server control next to the component entry in the Projects panel.\t\t\t\t\t\tIn the Edit Revision for Item dialog that opens, type in a meaningful comment to the component revision release into the Release Notes field (e.g., Initial release of the resistor component\u00a0saved from Manufacturer Part Search), then click OK. A status dialog will open while the component is saved to the Workspace. When this is complete, the Component editor will close.\t\t\t\t\t\tReturn to the Manufacturer Part Search panel and use the panel&#039;s Search field to search for resistor 1 K 5% 0805.\t\t\t\t\t\tSelect the entry of the\u00a0ERJ-P06J102V resistor\u00a0from\u00a0Panasonic in the search result grid and click the\u00a0\u00a0button in the Details pane.\t\t\t\t\t\tIn the Create new component dialog that opens, select the Resistors component type and click OK.\t\t\t\t\t\tIn the Use Component Data dialog that opens, make sure that the Show only matching with template option at the top of the dialog is disabled and enable options in header rows on the\u00a0Parameters, Models, and Datasheets tabs to add all available parameters, models, and\u00a0datasheets to the component, then click OK.\t\t\t\t\t\tIn the Name field in the Component region at the top left of the Component editor, change the component name to Resistor 1K +\/-5% 0805 500 mW.\t\t\t\t\t\tClick the Save to Server control next to the component entry in the Projects panel.\t\t\t\t\t\tIn the Edit Revision for Item dialog that opens, type in a meaningful comment to the component revision release into the Release Notes field (e.g., Initial release of the resistor component\u00a0saved from Manufacturer Part Search), then click OK. A status dialog will open while the component is saved to the Workspace. When this is complete, the Component editor will close.\t\t\tFinding and Acquiring the Connector\t\t\tThe last component to find is a 2-pin header. Return to the Manufacturer Part Search panel. This time you will use the panel&#039;s faceted searching capabilities.\t\t\t\t\t\tIn the Categories drop-down at the top left of the panel, expand the All entry and select the Connectors category.\t\t\t\t \t\t\t\t\t\tClick the\u00a0\u00a0button to display the Filters pane if it is not already shown.\t\t\t\t \t\t\t\t\t\tClick the Show more filters link at the bottom of the Filters pane to\u00a0display all of the available filters (rather than\u00a0the most commonly used filters).\t\t\t\t \t\t\t\t\t\tAn efficient way of working with the filters is to use the Search field at the top of the Filters pane (). Searching returns strings that match in either the filter name or in the filter settings. Using the following search terms, apply the filters and select the options listed below:\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSearch for\t\t\t\t\tChoose\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thas model\t\t\t\t\tHas Model =\u00a0Yes\t\t\t\t\t\t\t\t\t\t\t\t\tcontacts\t\t\t\t\tNumber of Contacts =\u00a02\t\t\t\t\t\t\t\t\t\t\t\t\tpitch\t\t\t\t\tTerminal Pitch =\u00a0100mil\t\t\t\t\t\t\t\t\t\t\t\t\tmale\t\t\t\t\tContact Gender =\u00a0Male\t\t\t\t\t\t\t\t\t\t\t\t\tstraight\t\t\t\t\tMounting Style = STRAIGHT\t\t\t\t\t\t\t\t\t\t\tThe currently selected filter options are shown below the search bar.\t\t\t\t \t\t\t\t\t\tA small number of 2-pin vertical male headers should be returned, as shown above. Select a suitable 2-pin vertical male connector with a pin pitch of 2.54 mm (0.1 in) from the search results, such as\u00a0TSW-102-26-F-S from Samtec\u00a0and click the\u00a0\u00a0button in the Details pane.\t\t\t\t\t\tIn the Create new component dialog that opens, select the Connectors component type and click OK.\t\t\t\t\t\tIn the Use Component Data dialog that opens, make sure that the Show only matching with template option at the top of the dialog is disabled and enable options in header rows on the\u00a0Parameters, Models, and Datasheets tabs to add all available parameters, models, and\u00a0datasheets to the component, then click OK.\t\t\t\t\t\tIn the Component editor, leave the data values at their defaults and click the Save to Server control next to the component entry in the Projects panel.\t\t\t\t\t\tIn the Edit Revision for Item dialog that opens, type in a meaningful comment to the component revision release into the Release Notes field (e.g., Initial release of the connector component\u00a0saved from Manufacturer Part Search), then click OK. A status dialog will open while the component is saved to the Workspace. When this is complete, the Component editor will close.\t\t\t\tAll components required for the design are available for use now. The next step is using the saved components to capture the design&#039;s schematic.\tvar p = document.getElementsByClassName(&quot;Counter&quot;);for (k = 0; k &lt; p.length; k++) {Bloberator(p[k].id, &quot;0&quot;);}document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);function Update(ss, n) {var g = (document.getElementById(ss).innerHTML) - 1;var TextArray = document.getElementsByClassName(ss + ss);var ImageArray = document.getElementsByClassName(ss);if ((g == 0) &amp; (n == -1)) {n = 0;}ImageArray[g].style.opacity = &quot;0&quot;;ImageArray[g].style.zIndex = &quot;-1&quot;;if (g &lt; TextArray.length) {TextArray[g].style.display = &quot;none&quot;;}g = g + (n);if (g == ImageArray.length) {g = 0;}var v = ImageArray[g].getElementsByTagName(&quot;video&quot;)[0];if (v != null) {v.currentTime = 0;v.play();}ImageArray[g].style.opacity = &quot;1&quot;;ImageArray[g].style.zIndex = &quot;1&quot;;if (g &lt; TextArray.length &gt; 0) {TextArray[g].style.display = &quot;inherit&quot;;}document.getElementById(ss).innerHTML = g + 1;Bloberator(ss, g);}function Bloberator(sss, m) {var dots = &quot;&quot;;var IR = document.getElementsByClassName(sss);for (d = 0; d &lt; IR.length; d++) {if (d == m) {dots = dots + &quot;&quot;;} else {dots = dots + &quot;&quot;;}}var dotrows = document.getElementsByName(sss);for (x = 0; x &lt; dotrows.length; x++) {dotrows[x].innerHTML = dots;}}","tags":"","url":"altium-designer\/24\/documentation-altium-designer-tutorial-searching-acquiring-components.html"},
{"title":"Capturing the Schematic","text":"You are now ready to begin capturing (drawing) the schematic.Placing the ComponentsMain page:\u00a0Searching for &amp; Placing ComponentsWhen Altium Designer is connected to a Workspace, the Components panel will list all components available for use in a project design, from this Workspace. For such components, the Components panel supports the same search features that are available in the Manufacturer Part Search panel, including string-based searching, faceted searching, or a combination of both, and also the Find Similar Components feature.With the Components panel, components acquired from the Manufacturer Part Search panel will be placed in the multivibrator circuit. Once you have placed the components, the schematic should look like the image below. \tAll the components have been placed, ready for wiring.\t\t\t\t\t\tNote that the components are spaced so that there is plenty of room to wire to each component pin. This is important because you cannot place a wire across the bottom of a pin to get to a pin beyond it. If you do, both pins will connect to the wire. If required, you can reposition a component after placement.\t\t\t\t\t\t\t\t\t\tThe\u00a0Components\u00a0panel can operate in two modes: normal and compact. In this tutorial, the panel in its normal mode is shown and described. Make the panel wider so it is displayed in its normal mode. The button at the top right of the panel is shown as\u00a0 when the panel is in its normal mode. When it is in its compact mode, the controls will rearrange, so they may not present exactly as it is shown and described here.\t\t\t\t\t\t\t    Notes on Object Placement and Editing    \t\t\t\t\t\tWhile the object (such as a component) is floating on the cursor, you can:\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tPress Spacebar to rotate it counterclockwise\u00a0in 90\u00ba increments\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tPress X to flip it along the X-axis\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tPress Y to flip it along the Y-axis.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTo edit the properties of an object prior to placement, press Tab\u00a0to pause the editing process and display the Properties panel. The default behavior is for the most commonly edited field to be highlighted, ready for editing. Because the editing process is paused, you can use the cursor (or press Tab on the keyboard) to move to another field in the panel. The entered values become the defaults. For a component, the designator will be auto-incremented, if it has the same prefix. When you have finished editing, click the pause button () in the design space to return to object placement ().\t\t\t\t\t\t\t\t\t\tWhile you can edit object properties\u00a0during placement, you can leave the editing until after the object\u00a0is\u00a0placed. To do this, you can double-click the placed object to select it and open the Properties panel.\t\t\t\t\t\t\t\t\t\tMultiple objects can also be selected.\u00a0Use Shift+Click to sequentially select the objects or\u00a0use a selection rectangle\u00a0(Click, Hold&amp;Drag away from objects) to select all objects that fall within the bounds of the selection area.\t\t\t\t\t\t\t\t\t\tThe Properties panel supports editing multiple selected objects\u00a0at the same time.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIf all objects share a property, that property will be available for editing.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIf all objects share the same property value, that value will be displayed.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIf objects share the same property but have different values, it will display an asterisk (*).\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe value entered or the option chosen is applied to all selected objects.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tDuring object placement, Altium Designer will automatically pan if you touch the edge of the design space. Autopanning is configured in the Schematic \u2013 Graphical Editing page of the Preferences dialog (accessed by clicking the\u00a0 button at the top left of the design space). If you accidentally pan beyond where you want, while the object is floating on the cursor, use\u00a0Ctrl+Mouse Wheel\u00a0and\u00a0Right-Click, Hold&amp;Drag\u00a0to zoom and pan or\u00a0Ctrl+PgDn to display the entire sheet again.\t\t\t\t\t\t\t\t\t\tTo reposition any object, place the cursor directly over it, click and hold the left mouse button, drag the object to a new position then release the mouse button. Movement is constrained to the current snap grid, which is displayed on the Status Bar. Press the G shortcut at any time to cycle through the current snap grid settings. The grids you cycle through when you press the G shortcut are defined in the\u00a0Schematic \u2013 Grids page of the Preferences dialog. It is recommended to position the components on a coarse grid, such as 50 or 100 mils, to keep the circuit neat and make it easy to attach wires to pins. For a simple design such as this tutorial&#039;s design, 100 mils is a good choice.\t\t\t\t\t\t\t\t\t\tYou can also re-position a selected schematic object or a\u00a0group of objects using the arrow keys on the keyboard. Select the objects\u00a0then press an arrow key while holding down the Ctrl key. Hold Shift as well to move objects by 10 times the current snap grid.\t\t\t\t\t\t\tLearn more about Schematic Placement &amp; Editing Techniques.\t\tPlacing the Transistors\t\t\tSelect View \u00bb Fit Document from the main menus to make the schematic sheet fill the design space.\t\t\t\t\t\tOpen the Components panel. To do this, click the \u00a0button at the bottom right of the design space and select Components from the menu.\t\t\t\t\t\tClick the\u00a0 button at the top left of the\u00a0Components panel to open the Categories pane. Select the All entry to access the Workspace library.\t\t\t\t \t\t\t\tAfter that, the Categories pane can be closed by clicking the\u00a0 button.\t\t\t\t\t\tClick the\u00a0 button at the top of the Components panel and select Refresh from the menu to update the panel&#039;s content with the components acquired from the Manufacturer Part Search panel.\t\t\t\t \t\t\t\t\t\tIn the\u00a0Search\u00a0field at the top of the panel, type\u00a0transistor BC547. Search results will be presented in the panel.\t\t\t\t \t\t\t\t\t\tClick the entry of the found transistor (BC547CG) in the search result grid to select it.\t\t\t\t\t\tDisplay the Details pane of the panel using the\u00a0 button so that you can explore the details of the selected component.\t\t\t\t \t\t\t\t\t\tClick the required transistor in the results grid of the panel\u00a0to select it then click the\u00a0\u00a0button in the Details pane. The cursor will automatically move\u00a0to be within the bounds of the schematic sheet and change to a crosshair, with\u00a0a symbol of the transistor floating on it. You are now in component placement mode. If you move the cursor around, the transistor will move with it.\t\t\t\tDo not place the transistor yet!\t\t\t\t \t\t\t\t\t\tWhile the transistor is still floating on the cursor, press the Tab key to open the Properties panel. As the most-used field, the Designator field will be\u00a0automatically highlighted in the panel, ready for editing.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tYou can close the Components panel for now and make it visible again later using the \u00a0button menu.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tNote that each region of the Properties panel can be individually expanded or collapsed, which means your panel might look different.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tType Q1 in the Designator\u00a0field and confirm that the visibility control for the Comment field is set to visible (shown as ).\t\t\t\t\t\t\t\t\t\tLeave all other fields at their default values and click the pause button () in the design space to return to component placement.\t\t\t\t\t\tMove the cursor, with the transistor symbol attached, to position the transistor a little to the left of the middle of the sheet. Once you are happy with the transistor&#039;s location, click to place it on\u00a0the schematic. If necessary, the location can be changed later.\t\t\t\t \t\t\t\t\t\tMove the cursor and you will find that a copy of the transistor has been placed on the schematic sheet, and you are still in component placement mode\u00a0with the transistor symbol floating on the cursor. This feature allows you to place multiple components of the same type.\t\t\t\t\t\tYou are ready to place the second transistor. This transistor is the same as the previous one\u00a0so there is no need to edit its attributes before you place it. Altium Designer will automatically increment the component designator when you place multiple instances of the same component. In this case, the next transistor will automatically be designated Q2.\t\t\t\tIf you refer to the schematic diagram shown above, you will notice that Q2 is drawn as a mirror of Q1. To horizontally flip the orientation of the transistor floating on the cursor, press the X key on the keyboard.\t\t\t\t\t\tMove the cursor to position the component to the right of Q1.\t\t\t\t\t\t\tTo position the component more accurately using the grid lines, zoom in\u00a0(Ctrl+Mouse Wheel) to see the grid.\t\t\t\t\t\t\t \t\t\t\t\t\tOnce you have positioned the component, click to place Q2. Once again, a copy of the transistor you are &quot;holding&quot; will be placed on the schematic, and the next transistor will be floating on the cursor ready to be placed.\t\t\t\t\t\tSince both of the transistors have been placed, exit component placement by right-clicking or pressing the Esc key. The cursor will revert back to a standard arrow.\t\t\tPlacing the Capacitors\t\t\tReturn to the Components panel\u00a0and use the panel&#039;s\u00a0Search\u00a0field to search for capacitor 22nF 16V 0603.\t\t\t\t\t\tSelect the entry of the found capacitor (Capacitor 22nF +\/-5% 16V 0603) in the search result grid.\t\t\t\t\t\tMany of the resistors and capacitors have several footprint models, for different density levels. Under the footprint preview in the Models region of\u00a0the Details pane, select the A variety (FP-C0603C-CF-IPC_A).\t\t\t\t\t\t\tThis footprint selection can also be done during or after placement, using the Properties panel.\t\t\t\t\t\t\t \t\t\t\t\t\tClick the\u00a0\u00a0button in the Details pane.\t\t\t\t\t\tWhile the capacitor is floating on the cursor, press the Tab key to open the Properties panel.\t\t\t\t\t\tType C1 in the Designator\u00a0field.\t\t\t\t\t\tClick the Show More link in the panel&#039;s Parameters region to show the full list of component parameters. Make sure that the visibility of the Value parameter is only enabled. The value of this parameter will be shown next to the component in the design space.\t\t\t\t \t\t\t\t\t\tLeave all other fields at their default values and click the pause button () in the design space to return to component placement.\t\t\t\t\t\tPress Spacebar\u00a0to rotate the component in 90\u00b0 increments\u00a0until it has the correct orientation.\t\t\t\t\t\tPosition the capacitor above the transistors and click to place the component.\t\t\t\t \t\t\t\t\t\tPosition and place capacitor C2.\t\t\t\t \t\t\t\t\t\tRight-click or press Esc to exit the component placement.\t\t\tPlacing the Resistors\t\t\tReturn to the Components panel\u00a0and use the panel&#039;s\u00a0Search\u00a0field to search for resistor 100K 5% 0805.\t\t\t\t\t\tSelect the entry of the found 100K resistor (Resistor 100K +\/-5% 0805 125 mW) in the search result grid.\t\t\t\t\t\tUnder the footprint preview in the Models region of\u00a0the Details pane, select the M variety (RESC2013X70X40ML20T20).\t\t\t\t\t\tClick the\u00a0\u00a0button in the Details pane.\t\t\t\t\t\tWhile the resistor is floating on the cursor, press the Tab key to open the Properties panel.\t\t\t\t\t\tType R1 in the Designator\u00a0field.\t\t\t\t\t\tClick the Show More link in the panel&#039;s Parameters region and make sure that the visibility of the Value parameter is only enabled.\t\t\t\t\t\tLeave all other fields at their default values and click the pause button () in the design space to return to component placement.\t\t\t\t\t\tPress Spacebar\u00a0to rotate the component in 90\u00b0 increments\u00a0until it has the correct orientation.\t\t\t\t\t\tPosition the resistor above and to the left of the base of Q1\u00a0and click to place the component.\t\t\t\t \t\t\t\t\t\tNext, place the other 100K resistor, R2, above and to the right of the base of Q2. The designator will automatically increment when you place the second resistor.\t\t\t\t \t\t\t\t\t\tRight-click or press Esc to exit the component placement.\t\t\t\t\t\tReturn to the Components panel\u00a0and use the panel&#039;s\u00a0Search\u00a0field to search for resistor 1K 5% 0805 fixed.\t\t\t\t\t\tSelect the entry of the found 1K resistor (Resistor 1K +\/-5% 0805 500 mW) in the search result grid.\t\t\t\t\t\tUnder the footprint preview in the Models region of\u00a0the Details pane, select the M variety (RESC2013X70X40ML20T20).\t\t\t\t\t\tClick the\u00a0\u00a0button in the Details pane.\t\t\t\t\t\tWhile the resistor is floating on the cursor, press the Tab key to open the Properties panel.\t\t\t\t\t\tType R3\u00a0in the Designator\u00a0field.\t\t\t\t\t\tClick the Show More link in the panel&#039;s Parameters region and make sure that the visibility of the Value parameter is only enabled.\t\t\t\t\t\tLeave all other fields at their default values and click the pause button () in the design space to return to component placement.\t\t\t\t\t\tPress Spacebar\u00a0to rotate the component in 90\u00b0 increments\u00a0until it has the correct orientation.\t\t\t\t\t\tPosition and place R3 directly above the collector of Q1, then place R4 directly above the collector or Q2.\t\t\t\t \t\t\t\t\t\tRight-click or press Esc to exit the component placement.\t\t\tPlacing the Connector\t\t\tReturn to the Components panel\u00a0and use the panel&#039;s\u00a0Search\u00a0field to search for connector male straight.\t\t\t\t\t\tSelect the entry of the found connector in the search result grid.\t\t\t\t\t\tClick the\u00a0\u00a0button in the Details pane.\t\t\t\t\t\tWhile the resistor is floating on the cursor, press the Tab key to open the Properties panel.\t\t\t\t\t\tType P1\u00a0in the Designator\u00a0field.\t\t\t\t\t\tLeave all other fields at their default values and click the pause button ()\u00a0in the design space to return to component placement.\t\t\t\t\t\tPress Spacebar\u00a0to rotate the component in 90\u00b0 increments\u00a0until it has the correct orientation.\t\t\t\t\t\tClick to place the connector on the schematic.\t\t\t\t \t\t\t\t\t\tRight-click or press Esc to exit the component placement.\t\t\t\t\t\tSave the schematic document locally by right-clicking its entry in the Projects panel and selecting\u00a0Save\u00a0from the context menu.\t\t\tWiring the CircuitMain page:\u00a0Creating Circuit Connectivity in Your SchematicsWiring is the process of creating connectivity between the various components of your circuit. To wire up your schematic, refer to the sketch of the circuit () and the video shown below.\t    Notes on Wiring    \t\t\t\t\t\tTo start wiring, select the Place \u00bb Wire command from the main menus (shortcut: Ctrl+W).\t\t\t\t\t\t\t\t\t\tClick to anchor the wire at the cursor position.\t\t\t\t\t\t\t\t\t\tPress Backspace to remove the last anchor point.\t\t\t\t\t\t\t\t\t\tPress Spacebar to toggle the direction of the corner. You can observe this in the video shown above toward the end\u00a0when the connector is being wired.\t\t\t\t\t\t\t\t\t\tRight-click or press Esc to exit wire placement mode.\t\t\t\t\t\t\t\t\t\tClick, Hold&amp;Drag to drag the component together with any connected wires.\u00a0Ctrl+Click, Hold&amp;Drag to move a placed component.\t\t\t\t\t\t\t\t\t\tWhenever a wire crosses the connection point of a component\u00a0or is terminated on another wire, a junction will automatically be created.\t\t\t\t\t\t\t\t\t\tA wire that crosses the end of a pin will connect to that pin.\t\t\t\t\t\t\t\t\tUse the wiring tool to wire up your circuit. Toward the end of the video, you can see how wires can be dragged.\t\t\tFirst, wire the lower pin of resistor R1 to the base of transistor Q1 in the following manner. Select the Place \u00bb Wire\u00a0command from the main menus (or use the\u00a0Ctrl+W shortcut) to enter the wire placement mode. The cursor will change to a crosshair.\t\t\t\t\t\tPosition the cursor over the bottom end of R1. When you are in the right position, a red connection marker (red cross) will appear at the cursor location. This indicates that the cursor is over a valid electrical connection point on the component.\t\t\t\t\t\tClick to anchor the first wire point. Move the cursor, and a wire will extend from the cursor position back to the anchor point.\t\t\t\t\t\tPosition the cursor over the base of Q1 until you see the cursor change to a red connection marker. If the wire is forming a corner in the wrong direction, press Spacebar to toggle the corner direction.\t\t\t\t\t\tClick to connect the wire to the base of Q1. The cursor will release from that wire.\t\t\t\t\t\tNote that the cursor remains a crosshair\u00a0indicating that you are ready to place another wire. To exit placement mode completely and go back to the arrow cursor, you would right-click or press Esc \u2013 but do not do this just now.\t\t\t\t\t\tNext, wire from the lower pin of R3 to the collector of Q1. Position the cursor over the lower pin of R3 and click to start a new wire. Move the cursor vertically until it is over the collector of Q1, then\u00a0click to place the wire segment. Again, the cursor will release from that wire\u00a0and you remain in wiring mode, ready to place another wire.\t\t\t\t\t\tWire up the rest of your circuit, as shown in the video above.\t\t\t\t\t\tWhen you have finished placing all the wires, right-click or press Esc to exit placement mode. The cursor will revert to an arrow.\t\t\tPlacing the Net LabelsEach set of component pins that you have connected to each other now forms what is referred to as a net. For example, one net includes the base of Q1, one pin of R1, and one pin of C1. Each net is automatically assigned a system-generated name, which is based on one of the component pins in that net.To make it easy to identify important nets in the design, you can add net labels to assign names. For the multivibrator circuit, you will label the 12V and GND nets in the circuit, as shown below. \tNet labels have been added to the 12V and GND nets, completing the schematic.\t\t\tSelect the Place \u00bb Net Label\u00a0command from the main menus. A net label will appear floating on the cursor.\t\t\t\t\t\tTo edit the net label before it is placed, press Tab\u00a0to open the Properties panel.\t\t\t\t\t\tType 12V in the Net Name field.\t\t\t\t \t\t\t\t\t\tClick the pause button () in the design space to return to object placement.\t\t\t\t\t\tPlace the net label so that its hotspot (the bottom-left corner) touches the uppermost wire on the schematic, as shown in the images below. The cursor will change to a red cross when the net label is correctly positioned to connect to the wire. If the cross is light gray, it means there will not be a valid connection made.\t\t\t\t \t\t\tThe net label in free space (the top image) and positioned over a wire (the bottom image), note the red cross.\t\t\t\t\t\tAfter placing the first net label, you will still be in net label placement mode.\u00a0Press the Tab key again to edit the second net label in the Properties panel before placing it.\t\t\t\t\t\tType GND in the Net Name field.\t\t\t\t\t\tClick the pause button () in the design space to return to object placement.\t\t\t\t\t\tPlace the net label so that the bottom left of the net label touches the lowermost wire on the schematic (as shown in the completed schematic image\u00a0above). Right-click or press Esc to exit net label placement mode.\t\t\t\t\t\tSave the schematic document locally by right-clicking its entry in the Projects panel and selecting\u00a0Save\u00a0from the context menu.\t\t\tCongratulations! You have just completed your first schematic capture. Before you turn the schematic into a circuit board, you need to configure the project options\u00a0and check the design for errors.Configuring Project OptionsMain page:\u00a0Accessing, Defining &amp; Managing Project OptionsProject-specific settings are configured in the Project Options dialog. The project options include error reporting settings, a connectivity matrix, class generation settings, and more. Some project options are shown and described below.\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\tJavascript ID: Tutorial_Dlg_ProjectOptions_AD24\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWhen you validate a project, Altium Designer checks for logical, electrical, and drafting errors between the schematic content and error reporting settings. The Error Reporting tab of the Project Options dialog is used to set up a wide range of checks. The Report Mode settings show the level of severity of a violation. If you want to change a setting, click on current\u00a0Report Mode next to the violation you want to change and choose the level of severity from the drop-down list.\t\t\t\t\t\t\t\t\t\t\t\t\t\tAs the design is coming along, a list of the pins in each net is built into memory. The type of each pin is detected (e.g.,\u00a0input, output, passive, etc.), then each net is checked to see if there are pin types that should not be connected to each other, for example, an output pin connected to another output pin. The Connection Matrix tab of the Project Options dialog is where you configure what pin types are allowed to connect to each other. For example, look at the entries on the right side of the matrix diagram and find Output Pin. Read across this row of the matrix until you get to the Open Collector Pin column. The square where they intersect is orange, indicating that an Output Pin connected to an Open Collector Pin on your schematic will generate an error condition when the project is validated. You can set each error type with a separate error level, i.e., from No Report\u00a0to a Fatal Error. Click on a colored square to change the setting;\u00a0it will cycle through the four possible settings.\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe Class Generation tab of the Project Options dialog is used to configure what type of classes are generated from the design (the Comparator and ECO Generation tabs are then used to control if classes are transferred to the PCB).\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe Comparator tab of the Project Options dialog sets which differences will be reported or ignored when comparing documents. When you need detailed control, you can selectively configure the comparator using the individual comparison settings.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tRight-click the project entry in the Projects panel and select the Project Options\u00a0command from the context menu to open the Project\u00a0Options\u00a0dialog, then select the Error Reporting tab of the dialog.\t\t\t\t \t\t\t\t\t\tScroll through the list of error checks and note that they are clustered in groups.\u00a0Each group can be collapsed if required.\t\t\t\t\t\tClick on the Report Mode setting for any check and note the options available.\t\t\t\t\t\tSelect the Connection Matrix tab of the Project Options\u00a0dialog.\t\t\t\t\t\tYour circuit contains only passive pins. Look down the row labels to find the Passive Pin row. Look across the column labels to find Unconnected. The square where these entries intersect indicates the error condition when a passive pin is found to be unconnected in the schematic. The default setting is green () indicating that no report will be generated.\t\t\t\t \t\t\t\t\t\tChange the default settings so that the connection matrix detects unconnected passive pins. Click on this intersection box until it turns orange () so that an error will be generated for unconnected passive pins when the project is validated. You will purposely create an instance of this violation later in the tutorial.\t\t\t\t \t\t\t\t\t\tSelect the Class Generation tab of the Project Options\u00a0dialog.\t\t\t\t\t\tFor a simple, single-sheet design such as this, there is no need to generate a component class. Clear the Component Classes checkbox for the project&#039;s schematic document.\t\t\t\t \t\t\t\t\t\tClick OK to apply changes and close the Project Options dialog.\t\t\t\t\t\tSave the project locally by right-clicking its entry in the Projects panel and selecting\u00a0Save\u00a0from the context menu.\t\t\tYou are now ready to validate the project and check for any errors.Validating the ProjectMain page: Validating Your Design ProjectValidation of a project checks for drafting and electrical rules errors in the design documents, and details all warnings and errors in the Messages panel. You have set up the check settings in the Error Checking and Connection Matrix tabs of the Project Options dialog, so you are now ready to check the design.\t\t\tTo validate the Multivibrator project, right-click its entry in the Projects panel and select\u00a0Validate PCB Project Multivibrator.PrjPcb from the context menu.\t\t\t\t \t\t\t\t\t\tAll validation warnings and errors are displayed in the Messages panel. The panel will only open automatically if there are errors detected (not when there are only warnings). To open it manually, click the \u00a0button at the bottom right of the design space and select Messages from the menu.\t\t\t\t\t\tIf your circuit is drawn correctly, the Messages panel should not contain any errors, only the message Compile successful, no errors found. If there are errors, work through each one, checking your circuit, and ensuring that all wiring and connections are correct.\t\t\t\t \t\t\tYou will now deliberately introduce an error into the circuit and validate the project again.\t\t\tClick in the middle of the wire that connects P1 to the emitters of Q1 and Q2 (the wire of net GND). Small, square editing handles will appear at each vertex of the wire and the selected color will display as a dotted line along the wire to indicate that it is selected. Press the Delete key to delete the wire.\t\t\t\t \t\t\t\t\t\tValidate the project again (select\u00a0Validate PCB Project Multivibrator.PrjPcb\u00a0from the right-click menu of the project entry in the Projects panel). The Messages panel will display error messages\u00a0indicating you have unconnected pins in your circuit.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe Messages panel is divided horizontally into two regions\u00a0as shown in the image above. The upper region lists all messages,\u00a0which can be saved, copied, cross probed to, or cleared via the right-click menu. The lower region details the warning\/error currently selected in the upper region of the panel.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWhen you double-click on an error or warning in either region of the Messages panel, the schematic view pans and zooms to the violating object.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWhen you hover the cursor over the violating\u00a0object (not the wiggly line), a message describing the violation condition will appear.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tBefore you finish this section of the tutorial, fix violations in the schematic.\t\t\tUndo the delete action (Ctrl+Z)\u00a0to restore the deleted wire.\t\t\t\t\t\tValidate the project again to check that there are no longer any violations.\u00a0The Messages panel should show no violations.\t\t\t\t\t\tSave the project to the Workspace. To do this,\u00a0click the Save to Server control next to the project entry in the Projects panel, enter a meaningful comment into the Comment field of the Save to Server dialog that opens (e.g., Schematic is created and validated), and then click the OK button.\t\t\tConfiguring the Bill of MaterialsMain page: BOM Management with ActiveBOMUltimately, every component used in a design must have detailed supply chain information. Rather than requiring that this information be added to each design component or added as a post-process in an Excel spreadsheet, you can add it at any point through the design cycle\u00a0in an ActiveBOM document (*.BomDoc).\tActiveBOM queries the supply chain in real-time using the part providers enabled in the settings of your connected Workspace. Because data is updated in real-time, the availability of the parts used in this tutorial will change over time. The list of available suppliers also changes over time. For these reasons, the results you get may be different from the results shown and described in this tutorial.\t\t\t\tRight-click on the project entry in the Projects panel then select the Add New to Project \u00bb ActiveBOM command from the context menu.\u00a0A new ActiveBOM document\u00a0will open and an entry for it will appear linked to the project in the\u00a0Projects\u00a0panel\u00a0under the\u00a0Source Documents\u00a0entry.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Tutorial_AddNewBomDoc_AD24\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tRight-click the ActiveBOM document entry in the\u00a0Projects\u00a0panel and\u00a0select the\u00a0Save As\u00a0command. The\u00a0Save As\u00a0dialog will open, ready to save the document in the same location as the project file. Type the name\u00a0Multivibrator\u00a0in the\u00a0File name\u00a0field and click the\u00a0Save\u00a0button.\t\t\t\t\t\tAdding the ActiveBOM document has changed the project, so save the project locally by right-clicking\u00a0the project entry in the\u00a0Projects\u00a0panel\u00a0and selecting\u00a0Save.\t\t\t\t\t\tThe components used in the design will be listed as BOM items. By default, there is a column titled Line\u00a0#. Click the\u00a0 button at the top of the document\u00a0to populate this column.\t\t\t\t \t\t\t\t\t\tNote that the BOM items grid includes a BOM status column on the right. Hover the mouse cursor over a status icon for information about any issues detected. The status icons should indicate that all of the BOM items include the violation\u00a0No MPN ranked. This means that you\u00a0have not yet checked through the selected manufacturer part numbers\u00a0(MPNs) and indicated that you are happy with each of them.\t\t\t\t \t\t\t\tIt is possible that the transistor may have other errors. This will be resolved shortly.\t\t\t\t\t\tAssign a 5-star rank to the MPN of each item\u00a0that shows no violation type\u00a0other than No MPN ranked\u00a0(i.e., all items except for the transistor). To do this, click on a BOM item in the grid and then click the rightmost star in the lower region of the document\u00a0that displays the supply chain information for this item. After that, the status of four of the five BOM items should change to green\u00a0indicating that these items are clear (ready to order).\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Tutorial_ActiveBOM_SetRanks_AD24\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSelect the transistor item. It may have the manufacturing lifecycle Obsolete. For this item, we will add another MPN by adding a part choice to the component\u00a0in the Workspace library. To do this, click the\u00a0 button and select Edit Part Choices in Library\u00a0from the drop-down menu.\t\t\t\t \t\t\t\t\t\tThe Edit Part Choices\u00a0dialog will open. Click the\u00a0 button to open the Add Part Choices dialog. This dialog is used to search for a suitable manufacturer part in the same way as the Manufacturer Part Search panel.\t\t\t\t \t\t\t\t\t\tIn the Search field at the top of the Add Part Choices dialog, type\u00a0BC547C\u00a0and press Enter to broaden the search.\t\t\t\t \t\t\t\t\t\tKeep an eye on the vertical colored bar at the edge of the Manufacturer Part column. This indicates the lifecycle state of that part. Ideally, you will select a part with a green lifecycle state (Volume Production). Hover the cursor over the vertical colored bar to view the lifecycle state. Note that you do not need the part to have models since\u00a0you already have a symbol on the schematic and a footprint on the PCB.\t\t\t\tChoose a part with a suitable lifecycle state and stock available (e.g., BC547CTFR from ON Semiconductor \/ Fairchild), then click OK to accept this part.\t\t\t\t \t\t\t\t\t\tYou will return to the Edit Part Choices\u00a0dialog, where the selected part will be listed.\t\t\t\t \t\t\t\tClick OK to close the dialog and return to the ActiveBOM document.\t\t\t\t\t\tThe lower region of the document will show two MPNs for the transistor: one derived from the original part choice added during the component creation\u00a0and another derived from the part choice you just added. Use the ranking feature to promote the part you selected to be the primary solution for this BOM item.\t\t\t\t \t\t\t\t\t\tAll BOM items now include proper supply chain details.\u00a0Save the ActiveBOM document locally by right-clicking its entry in the\u00a0Projects\u00a0panel and selecting\u00a0Save\u00a0from the context menu.\t\t\t\t\t\tSave the project to the Workspace. To do this,\u00a0click the Save to Server control next to the project entry in the Projects panel, enter a meaningful comment into the Comment field of\u00a0the Save to Server dialog that opens (e.g., BOM document added), and then click the OK button.\t\t\t\t\t\tClose the ActiveBOM document by right-clicking its tab at the top of the design space and selecting the Close Multivibrator.BomDoc command from the context menu.\u00a0\t\t\t\t \t\t\t\tThe schematic capture is now complete. It&#039;s time to set up the design constraints!\t\tIf\u00a0the Constraint Manager\u00a0is not available (you can quickly check if the Constraint Manager is available by opening the\u00a0Design\u00a0main menu of the Schematic editor and checking for the\u00a0Constraint Manager\u00a0command), go to the\u00a0Creating and Configuring the PCB Document\u00a0page.\tvar p = document.getElementsByClassName(&quot;Counter&quot;);for (k = 0; k &lt; p.length; k++) {Bloberator(p[k].id, &quot;0&quot;);}document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);function Update(ss, n) {var g = (document.getElementById(ss).innerHTML) - 1;var TextArray = document.getElementsByClassName(ss + ss);var ImageArray = document.getElementsByClassName(ss);if ((g == 0) &amp; (n == -1)) {n = 0;}ImageArray[g].style.opacity = &quot;0&quot;;ImageArray[g].style.zIndex = &quot;-1&quot;;if (g &lt; TextArray.length) {TextArray[g].style.display = &quot;none&quot;;}g = g + (n);if (g == ImageArray.length) {g = 0;}var v = ImageArray[g].getElementsByTagName(&quot;video&quot;)[0];if (v != null) {v.currentTime = 0;v.play();}ImageArray[g].style.opacity = &quot;1&quot;;ImageArray[g].style.zIndex = &quot;1&quot;;if (g &lt; TextArray.length &gt; 0) {TextArray[g].style.display = &quot;inherit&quot;;}document.getElementById(ss).innerHTML = g + 1;Bloberator(ss, g);}function Bloberator(sss, m) {var dots = &quot;&quot;;var IR = document.getElementsByClassName(sss);for (d = 0; d &lt; IR.length; d++) {if (d == m) {dots = dots + &quot;&quot;;} else {dots = dots + &quot;&quot;;}}var dotrows = document.getElementsByName(sss);for (x = 0; x &lt; dotrows.length; x++) {dotrows[x].innerHTML = dots;}}","tags":"","url":"altium-designer\/24\/documentation-altium-designer-tutorial-capturing-schematic.html"},
{"title":"Setting Up the Design Constraints","text":"Main page:\u00a0Defining Design Requirements Using the Constraint Manager\tDo I have the Constraint Manager?\t\tAltium Designer suggests two distinct approaches to defining design constraints: the\u00a0PCB Rule and Constraints Editor\u00a0dialog and the\u00a0Constraint Manager. The\u00a0Constraint Manager\u00a0is available in a PCB design project\u00a0only if the Constraint Management option was\u00a0enabled in the Create Project dialog when this project was created.\t\tNote that this tutorial page applies only if\u00a0the Constraint Manager\u00a0was\u00a0enabled for the tutorial\u00a0project and, therefore, is available for it. To quickly check if the Constraint Manager\u00a0is available for the tutorial project, open the Design main menu from\u00a0the Schematic editor when the project&#039;s schematic document is open and check for the Constraint Manager command (). If the Constraint Manager is not available, skip this page and go to the next\u00a0page:\u00a0Creating and Configuring the PCB Document.\tAltium Designer&#039;s PCB editor is a rules-driven environment. With a well-defined set of design constraints, you can successfully complete board designs with varying and often stringent design requirements.Design constraints are configured in the Constraint Manager accessible from both the schematic and PCB sides of the design. In this tutorial, the design constraints will be defined from the schematic side and then transferred to the PCB, along with other design data (components and nets).\tThe constraints that are needed will depend on the nature of your design and manufacturing capabilities. There is no specific set of constraints that suits every design.\tDefining the Clearance ConstraintThe first step is to define how close electrical objects that belong to different nets\u00a0can be to each other. This requirement is handled by the clearance design constraints. The\u00a0Constraint Manager\u00a0includes the Clearances view that\u00a0presents the clearance matrix where clearances between net classes in the design can be defined. For the tutorial, a clearance of\u00a00.25 mm\u00a0between all objects is suitable.\t\t\tWhen the project&#039;s schematic sheet is the active document (click the schematic document tab at the top of the design space if it is not), select the Design \u00bb Constraint Manager command from the main menus to open the Constraint Manager i. The Clearances\u00a0view of the Constraint Manager opens by default.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Tutorial_OpenCM_AD24\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSelect the Tools \u00bb Measurement Units \u00bb mm command from the main menus to switch the current measurement units from mils to millimeters in\u00a0the Constraint Manager.\t\t\t\t\t\tClick within the cell on the intersection of the All Nets row and the All Nets column, type 0.25, and press Enter.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Tutorial_CM_AllNetsClearance_AD24\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIt is not necessary to enter the measurement units. The default measurement units will be added to the entered value automatically.\t\t\t\t\t\tDefining the Width ConstraintsThe width of the routing is controlled by the applicable width design constraint, which is\u00a0automatically selected\u00a0when you start routing a net.\t\t\t\t\t\tWhen you are configuring the constraints, the basic approach is to set the generic constraint to target the largest number of nets and then add specific constraints to target nets with special width requirements, such as power nets. Constraint priority applies\u00a0automatically based on the natural hierarchy of design objects. For example, the tutorial design includes several signal nets\u00a0and two power nets. The net constraint for all nets can be configured at\u00a00.25 mm. Although the All Nets scope also targets the power nets, these nets can be specifically targeted by adding a specific constraint.\t\t\t\t\t\t\t\t\t\tThe width design constraint\u00a0included minimum, maximum, and preferred settings. Use these if you prefer to have some flexibility during routing.\t\t\t\t\t\t\t\t\t\tAvoid using the minimum and maximum settings to define a single constraint value to suit all sizes required in the entire design. Doing this means you forgo the ability to get Altium Designer to monitor that each design object is appropriately sized for its task.\t\t\t\t\t\t\t\t\tOpen the Physical view of the Constraint Manager\u00a0using the corresponding button at the top.\t\t\t\t\t\tClick\u00a0within the cell in the Min Width or Preferred Width column for All Nets and define the following width values at the bottom part of the Constraint Manager:\t\t\t\t\t\t\t\t\t\t\tMin Width\u00a0=\u00a00.2\t\t\t\t\t\t\t\t\t\t\t\t\t\tPreferred Width\u00a0=\u00a00.25\t\t\t\t\t\t\t\t\t\t\t\t\t\tMax Width\u00a0=\u00a00.25\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Tutorial_CM_AllNetsWidth_AD24\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe next step is to add another constraint to specify the routing width for the power nets. To do this, create a net class for power nets and then apply specific width constraints to this class. In the Physical view, select the rows for 12V and GND nets by holding the Ctrl key and clicking the net names, then right-click the selection\u00a0and choose the Classes\u00a0\u00bb\u00a0Add Selected to Class \u00bb New Class command from the context menu.\t\t\t\t \t\t\t\t\t\tIn the Add Class dialog that opens, type\u00a0Power in the Name field, make sure that both\u00a012V and GND nets are listed in the Member column, then click Ok.\t\t\t\t \t\t\t\t\t\tAn entry for the\u00a0net class Power\u00a0will appear in the Physical view, with the\u00a012V and GND nets listed under it. Click\u00a0within the cell in the Min Width or Preferred Width column for this\u00a0net class and\u00a0define the following width values:\t\t\t\t\t\t\t\t\t\t\tMin Width\u00a0=\u00a00.25\t\t\t\t\t\t\t\t\t\t\t\t\t\tPreferred Width\u00a0=\u00a00.5\t\t\t\t\t\t\t\t\t\t\t\t\t\tMax Width\u00a0=\u00a00.5\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Tutorial_CM_PowerNetsWidth_AD24\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tDefining the Via Style ConstraintAs you route and change layers, a via is automatically added. In this case, the via properties are defined by the applicable via style design constraint.\t\t\tIn the Physical view of the Constraint Manager,\u00a0click\u00a0within the cell in the\u00a0Via Style\u00a0column for All Nets\u00a0and define the following via style values at the bottom part of the Constraint Manager:\t\t\t\t\t\t\t\t\t\t\tDiameter\u00a0=\u00a01\t\t\t\t\t\t\t\t\t\t\t\t\t\tHole Size\u00a0=\u00a00.6\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Tutorial_CM_AllNetsViaStyle_AD24\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSince it is highly likely that the power nets can be routed on a single side of the board, it is not necessary to define a routing via style constraint specifically\u00a0for power nets.\t\t\t\t\t\t\t\t\tSave the changes made in the Constraint Manager by selecting the\u00a0File \u00bb\u00a0Save\u00a0command from the main menus.\t\t\t\t\t\tClose the Constraint Manager by right-clicking its tab at the top of the design space and selecting the Close Multivibrator.PrjPcb\u00a0[Constraints] command from the context menu.\t\t\t\tDefining the constraints is now complete. It&#039;s time to create the PCB!var p = document.getElementsByClassName(&quot;Counter&quot;);for (k = 0; k &lt; p.length; k++) {Bloberator(p[k].id, &quot;0&quot;);}document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);function Update(ss, n) {var g = (document.getElementById(ss).innerHTML) - 1;var TextArray = document.getElementsByClassName(ss + ss);var ImageArray = document.getElementsByClassName(ss);if ((g == 0) &amp; (n == -1)) {n = 0;}ImageArray[g].style.opacity = &quot;0&quot;;ImageArray[g].style.zIndex = &quot;-1&quot;;if (g &lt; TextArray.length) {TextArray[g].style.display = &quot;none&quot;;}g = g + (n);if (g == ImageArray.length) {g = 0;}var v = ImageArray[g].getElementsByTagName(&quot;video&quot;)[0];if (v != null) {v.currentTime = 0;v.play();}ImageArray[g].style.opacity = &quot;1&quot;;ImageArray[g].style.zIndex = &quot;1&quot;;if (g &lt; TextArray.length &gt; 0) {TextArray[g].style.display = &quot;inherit&quot;;}document.getElementById(ss).innerHTML = g + 1;Bloberator(ss, g);}function Bloberator(sss, m) {var dots = &quot;&quot;;var IR = document.getElementsByClassName(sss);for (d = 0; d &lt; IR.length; d++) {if (d == m) {dots = dots + &quot;&quot;;} else {dots = dots + &quot;&quot;;}}var dotrows = document.getElementsByName(sss);for (x = 0; x &lt; dotrows.length; x++) {dotrows[x].innerHTML = dots;}}","tags":"","url":"altium-designer\/24\/documentation-altium-designer-tutorial-setting-up-design-constraints.html"},
{"title":"Creating and Configuring the PCB Document","text":"You are now ready to create a PCB.Adding a PCB Document to the ProjectBefore you transfer the design from the Schematic editor to the PCB editor, you need to create the blank PCB, then name and save it as part of the project.\t\t\tRight-click on the project entry in the Projects panel then select the Add New to Project \u00bb PCB command from the context menu.\u00a0A new PCB document\u00a0will open and an entry for it will appear linked to the project in the\u00a0Projects\u00a0panel\u00a0under the\u00a0Source Documents\u00a0entry.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Tutorial_AddNewPCB_AD24\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tRight-click the PCB document entry in the\u00a0Projects\u00a0panel and select the\u00a0Save As\u00a0command. The\u00a0Save As\u00a0dialog will open, ready to save the document in the same location as the project file. Type the name\u00a0Multivibrator\u00a0in the\u00a0File name\u00a0field and click the\u00a0Save\u00a0button.\t\t\t\t\t\tAdding the PCB has changed the project, so save the project locally by right-clicking\u00a0the project entry in the Projects panel\u00a0and selecting\u00a0Save.\t\t\tBefore transferring the design from the Schematic editor, we will also change some\u00a0attributes of the new PCB.\tTo navigate in a PCB, use Ctrl+Mouse Wheel\u00a0to zoom in and out and Right-Click, Hold&amp;Drag\u00a0to pan.\u00a0There are also a number of useful commands in the View main menu, such as Fit Document\u00a0(Ctrl+PgDn).\tSetting the Origin and the Measurement UnitsMain page:\u00a0Working with the Cursor-Snap SystemThe PCB editor has two origins: the absolute origin, which is the lower left of the design space, and the user-definable relative origin, which is used to determine the current design space location. The coordinates of objects in a PCB document are defined relative to the relative origin. The coordinates shown on the Status Bar are also relative to this origin.\u00a0A common approach is to set the relative origin to the bottom-left corner of the board shape.\t\t\tZoom\u00a0in to the lower left of the current board shape to easily see both the coarse and fine grids as shown in the images below.\t\t\t\t\t\tTo set the relative origin, select the\u00a0Edit \u00bb Origin \u00bb Set\u00a0command from the main menus, then\u00a0position the cursor over the bottom-left corner of the board shape and\u00a0click.\t\t\t\t \t\t\t\t\t\tSelect\u00a0the View \u00bb Toggle Units command from the main menus\u00a0to switch the measurement units of the PCB document from mils to millimeters.\t\t\t\t\t\t\tLook at the coordinates and the grid in\u00a0the Status Bar to quickly check the\u00a0measurement units currently in use.\t\t\t\t\t\t \t\t\t\t\t\tEditing the Board ShapeMain pages:\u00a0Defining the Board ShapeThe default board shape is 6 x 4 inches. For this tutorial, you will change the board size to 30 x 30 mm.\t\t\tSelect a suitable snap grid. During the course of the design process, it is quite common to change grids, for example, you might use a coarse grid during component placement\u00a0and a finer grid for routing. Select the View \u00bb Grids \u00bb Set Global Snap Grid command from the main menus\u00a0and enter 5\u00a0in the field of the Snap Grid dialog that opens,\u00a0then click OK to close the dialog.\t\t\t\t \t\t\t\t\t\tZoom out to show all of the board, including its edges.\t\t\t\t\t\tChanging the board shape is done in board planning mode. Select the\u00a0View \u00bb Board Planning Mode\u00a0command from the main menus to switch to this mode (shortcut: 1). The display will change, and\u00a0the board area will now be shown in green.\t\t\t\t \t\t\t\t\t\tWhen in board planning mode, the PCB editor provides several commands for changing the board shape.\u00a0For a simple square or rectangle, it is more efficient to edit the existing board shape. The coarse visible grid is 25\u00a0mm (5x\u00a0the\u00a0snap grid), and the fine visible grid is 5\u00a0mm;\u00a0these can be used as a guide.\t\t\t\t\t\t\t\t\t\t\tSelect Design \u00bb Edit Board Shape from the main menus.\t\t\t\t\t\t\t\t\t\t\t\t\t\tEditing handles will appear at each corner and the center of each edge, as shown in the video below.\t\t\t\t\t\t\t\t\t\t\t\t\tNote that clicking anywhere other than on an editing handle or an edge of the shape will drop you out of board shape editing mode.\t\t\t\t\t\t\t\t\t\t\t\t\t\tYou can slide the upper edge down and slide the right edge to the left to create the correct size. To slide the upper edge down, position the cursor over the edge (but not over a handle). When the cursor changes to a double-headed arrow, click and hold, then drag the edge to the new location so that the Y cursor location is 30mm on the Status Bar, as shown in the video below.\t\t\t\t\t\t\t\t\t\t\t\t\t\tRepeat the process to move the right-hand edge in, positioning it when the X cursor location is 30mm on the Status Bar.\t\t\t\t\t\t\t\t\t\t\t\t\t\tClick anywhere in the design space to drop out of board shape editing mode.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSelect the\u00a0View \u00bb 2D Layout\u00a0Mode\u00a0command from the main menus to return to 2D Layout Mode (shortcut: 2).\t\t\t\t\t\tNow that the shape has been defined, you can set the grid (View \u00bb Grids \u00bb Set Global Snap Grid) to a value suitable for component placement, for example,\u00a01 mm.\t\t\t\t\t\tSave the PCB document locally by right-clicking its entry in the Projects panel and selecting Save from the context menu.\t\t\t\tThe board size has been defined, and the units, origin, and grid have been set.Configuring the PCB Object DefaultsWhen you place an object in the PCB editor design space, Altium Designer will define the shape and properties of the object based on:\t\t\tAn applicable design rule \u2013 if there is a rule defined that applies to that object, the properties object are defined from the rule. For example, during a layer change when you are interactively routing, a via is automatically added with its size and hole size properties taken from the applicable Routing Via Style design rule.\t\t\t\t\t\tDefault settings \u2013 if an applicable design rule does not exist or does not apply, the object properties are defined from the default settings configured in the PCB Editor \u2013 Defaults page\u00a0of the Preferences dialog. For example, if you run the Place \u00bb Via command, Altium Designer does not know if that via will be part of a net, so it will present a via at the size defined in the defaults.\t\t\tAs part of this tutorial, you will configure the default properties of component designators and comments. These properties will be applied to these component strings when the components are placed on the PCB.\tNote that the changes made in the Preferences dialog apply to the current installation of Altium Designer rather than to a specific design project or document.\t\t\t\tClick the\u00a0 button at the top of the design space to open the Preferences dialog and then expand the PCB Editor category in the left tree and select the Defaults entry in this category to open\u00a0the PCB Editor \u2013 Defaults page.\t\t\t\t \t\t\t\t\t\tSelect Designator in the Primitive List\u00a0to display the default properties of this object. Confirm that the options are set as follows:\t\t\t\t\t\t\t\t\t\t\tThe Autoposition option is set to Left-Above. This is the default location in which this string is held when the component is rotated. The string can be interactively relocated at any time during the design process.\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe Text Height\u00a0value is set to 1.5mm.\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe Font Type\u00a0option is set to TrueType, and the Font is set to Arial.\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\tSelect Comment in the Primitive List\u00a0and confirm that the\u00a0comment\u00a0visibility is set to hidden (the button at the right of the Value field is shown as\u00a0). This is a common default.\u00a0Component comment strings can be selectively displayed during the design process if required.\t\t\t\t \t\t\t\t\t\tClick OK to save the changes and close the\u00a0Preferences\u00a0dialog.\t\t\tTransferring the Design from Schematic Capture to PCB LayoutMain page: Keeping the Schematics &amp; PCB SynchronizedThe design is transferred directly between the Schematic editor and the PCB editor;\u00a0there is no intermediate netlist file created. This can be done by selecting the\u00a0Design \u00bb Update PCB Document \u00a0command from the main menus of the Schematic editor. When you run this command, a set of Engineering Change Orders (ECO) is created, which:\t\t\tList all components used in the design\u00a0and the footprint required for each. When the ECOs are executed, Altium Designer attempts to locate each footprint and place each into the PCB design space.\t\t\t\t\t\tA list of all nets (connected component pins) is created. When the ECOs are executed, Altium Designer adds each net to the PCB and then attempts to add the pins that belong to each net. If a pin cannot be added, an error will occur.\u00a0This most often happens when the footprint is not found\u00a0or the pads on the footprint do not map to the pins on the symbol.\t\t\t\t\t\tAdditional design data is then transferred, such as net and component classes.\t\t\tIn other words, an ECO is created for each change that needs to be made to the PCB so that it matches the schematic.\t\t\tClick the schematic document tab at the top of the design space to make it the active document.\t\t\t\t\t\tSelect the\u00a0Design \u00bb Update PCB Document Multivibrator.PcbDoc\u00a0command from the main menus to open the Engineering Change Order dialog.\t\t\t\t \t\t\t\t\t\tClick the\u00a0\u00a0button at the bottom left of the dialog.\u00a0If all changes are validated, a green check will appear next to each change in the Status \u2013 Check column of the dialog.\t\t\t\t\t\t\t\tIf the changes are not validated, close the dialog, check the Messages panel, and resolve any errors.\t\t\t\t\t\tIf all changes are validated, click the\u00a0\u00a0button to send the changes to the PCB editor. As each change is performed, a check will appear in the Status \u2013 Done column of the dialog.\t\t\t\t \t\t\t\t\t\tWhen all changes have been completed, the PCB will open behind the Engineering Change Order dialog. You can close the dialog now.\t\t\t\t\t\tThe components are positioned outside of the board and\u00a0ready for placement. Also, note that component pads of the same net are connected to each other with connection lines.\u00a0\t\t\t\t \t\t\t\tYou might have noticed that the pads of transistors are highlighted in green, which indicates that there are design rule violations (violations of the Clearance design rule in this case).\u00a0Design rule violations will be discussed and resolved later in the tutorial. If you find the violation markers distracting, you can clear them by running the Tools \u00bb Reset Error Markers command. This command only clears the marker;\u00a0it does not hide or remove the actual violation. The error will be flagged again the next time you perform an edit action that runs the online DRC (such as moving the component) or when you run the batch DRC.\tThere are a few steps to complete before starting the component placement process, such as configuring the placement grid and\u00a0layers.Configuring the Display of LayersMain page: Your View of the PCBYour view of your board is a bird&#039;s-eye view, i.e., looking down the Z-axis into the board from above. The PCB editor is a layered design environment;\u00a0the objects you place on signal layers become copper when the board is fabricated, the strings you place on the overlay layers are silkscreened onto the board surface, and the notes you place onto mechanical layers become instructions on the assembly drawing that you print.You design the board looking down into this stack of layers, placing components on the top and bottom sides of the board (Top Layer \/ Bottom Layer), and other design objects on the copper, overlay, mask, and mechanical layers\u00a0as you build up the design. Layer display attributes and other layers are configured in the View Configuration panel.\t\t\tOpen the View Configuration panel. To do this, click the \u00a0button at the bottom right of the design space and select View Configuration from the menu.\t\t\t\t\t\tIn the Layers region of the panel&#039;s Layers and Colors tab, confirm that the Top Layer and Bottom Layer signal layers are visible (the visibility control at the left of layer entries is shown as ).\t\t\t\t \t\t\t\t\t\tTo have less visual &quot;clutter&quot; during placement and routing, disable the display of the Component Layer Pairs (except for Overlay layers), Mechanical Layers, and the Drill Guide and Drill Drawing layers.\t\t\t\t \t\t\t\t\t\tIn the Additional Options region of the panel&#039;s\u00a0View Options tab,\u00a0confirm that the Pad Nets and Pad Numbers options are enabled.\t\t\t\t \t\t\tConfiguring the Board Layer StackMain page: Defining the Layer StackPhysical layers of a PCB (signal, plane, and dielectric layers) and other aspects related to the physical structure of the PCB such as via types and impedance profiles, are configured in the Layer Stack Manager.This tutorial PCB is a simple design that can be routed as a double-sided board with thru-hole vias.\t\t\tOpen the Layer Stack Manager. To do this,\u00a0select the Design \u00bb Layer Stack Manager command from the main menus of the PCB editor. For a new board, the default stack comprises\u00a0a dielectric core, two copper layers, and the top and bottom solder mask and overlay (silkscreen) layers.\t\t\t\t \t\t\t\t\t\tTo simplify the management of layers, make sure that the Stack Symmetry option is enabled in the Board region of the\u00a0Properties panel (if the panel is not visible, click the \u00a0button at the bottom right of the design space and select Properties from the menu). With this option enabled, layers are added in matching pairs, centered around the mid-dielectric layer.\t\t\t\t \t\t\t\t\t\tTo use a material for a specific layer (or pair of layers if symmetry is enabled), click the \u00a0button in the Material cell for the required layer\u00a0to open the Select Material dialog.\t\t\t\t \t\t\t\tSelect layer materials as follows:\t\t\t\t\t\t\t\t\t\t\tSolder mask layers (Top Solder and Bottom Solder) \u2013 SM-001\t\t\t\t\t\t\t\t\t\t\t\t\t\tSignal layers (Top Layer and Bottom Layer) \u2013 CF-004\t\t\t\t\t\t\t\t\t\t\t\t\t\tDielectric layer (Dielectric 1) \u2013 Core-043\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\tClick on the Via Types tab at the bottom of the Layer Stack Manager and confirm that there is a Thru\u00a01:2 type defined.\t\t\t\t \t\t\t\t\t\tSave changes made in the Layer Stack Manager by selecting the File \u00bb Save to PCB\u00a0command from the main menus.\t\t\t\t\t\tClose the Layer Stack Manager by right-clicking its tab at the top of the design space and selecting the\u00a0Close Multivibrator.PcbDoc\u00a0[Stackup]\u00a0command from the context menu.\t\t\tConfiguring the Snap GridMain page:\u00a0Working with Grids &amp; GuidesThe next step is to select a suitable grid for placing the components. All the objects are placed in the PCB design space on the current snap grid.\t\t\tIf the Properties panel is not already visible, make it visible by\u00a0clicking the\u00a0 button at the bottom right of the design space and selecting\u00a0Properties\u00a0from the menu that opens.\u00a0The panel displays the properties of the selected object, or if no object is selected, it displays the properties of the PCB document.\t\t\t\t\t\tIn the Grid Manager region of the panel&#039;s General tab, select the Global Board Snap Grid entry and click the \u00a0button. The Cartesian Grid Editor dialog will open.\t\t\t\t \t\t\t\t\t\tIn the\u00a0Cartesian Grid Editor dialog:\t\t\t\t\t\t\t\t\t\t\tMake sure that the Step X field has the value 1mm. Because the X and Y fields are linked, there is no need to define the Step Y value.\t\t\t\t\t\t\t\t\t\t\t\t\t\tClick the color swatch for the Fine grid and select a lighter color using the Choose Color dialog that opens (e.g., select the color in row 34 on the Basic tab \u2013 ).\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor the Coarse grid, select Lines from the drop-down and click the Darker control to automatically set its\u00a0color to a shade darker than the current fine grid color. This will\u00a0make it easier to distinguish between the fine and coarse grids.\t\t\t\t\t\t\t\t\t\t\t\t\t\tMake sure that the Multiplier\u00a0is set to 5x Grid Step. This will make the grid visible at lower zoom levels.\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\tClick OK to close the dialog. The display of the grid will be updated in the design space.\u00a0\t\t\t\t \t\t\t\t\t\tSave the PCB\u00a0document locally by right-clicking its entry in the Projects panel and selecting Save from the context menu.\t\t\t\tWith the PCB created and configured, the next step is placing the components and routing the board.\t\tIf\u00a0the Constraint Manager\u00a0is not available (you can quickly check if the Constraint Manager is available by opening the\u00a0Design\u00a0main menu of either the schematic or PCB editor and checking for the\u00a0Constraint Manager\u00a0command), go to the\u00a0Setting up the Design Rules\u00a0page first.\tvar p = document.getElementsByClassName(&quot;Counter&quot;);for (k = 0; k &lt; p.length; k++) {Bloberator(p[k].id, &quot;0&quot;);}document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);function Update(ss, n) {var g = (document.getElementById(ss).innerHTML) - 1;var TextArray = document.getElementsByClassName(ss + ss);var ImageArray = document.getElementsByClassName(ss);if ((g == 0) &amp; (n == -1)) {n = 0;}ImageArray[g].style.opacity = &quot;0&quot;;ImageArray[g].style.zIndex = &quot;-1&quot;;if (g &lt; TextArray.length) {TextArray[g].style.display = &quot;none&quot;;}g = g + (n);if (g == ImageArray.length) {g = 0;}var v = ImageArray[g].getElementsByTagName(&quot;video&quot;)[0];if (v != null) {v.currentTime = 0;v.play();}ImageArray[g].style.opacity = &quot;1&quot;;ImageArray[g].style.zIndex = &quot;1&quot;;if (g &lt; TextArray.length &gt; 0) {TextArray[g].style.display = &quot;inherit&quot;;}document.getElementById(ss).innerHTML = g + 1;Bloberator(ss, g);}function Bloberator(sss, m) {var dots = &quot;&quot;;var IR = document.getElementsByClassName(sss);for (d = 0; d &lt; IR.length; d++) {if (d == m) {dots = dots + &quot;&quot;;} else {dots = dots + &quot;&quot;;}}var dotrows = document.getElementsByName(sss);for (x = 0; x &lt; dotrows.length; x++) {dotrows[x].innerHTML = dots;}}","tags":"","url":"altium-designer\/24\/documentation-altium-designer-tutorial-creating-configuring-pcb-document.html"},
{"title":"Setting Up the Design Rules","text":"Main pages: Defining, Scoping &amp; Managing PCB Design Rules, PCB Design Rule Types\tDo I have the PCB Rules and Constraints Editor dialog?\t\tAltium Designer suggests two distinct approaches to design constraint management: the\u00a0PCB Rule and Constraints Editor\u00a0dialog and the\u00a0Constraint Manager. The\u00a0Constraint Manager\u00a0is available in a PCB design project\u00a0only if the Constraint Management option was\u00a0enabled in the Create Project dialog when this project was created.\t\tNote that this tutorial page applies only if\u00a0the Constraint Manager\u00a0was\u00a0not enabled for the tutorial\u00a0project and, therefore, is not available for it.\u00a0To quickly check if the Constraint Manager\u00a0is available for the tutorial project, open the Design main menu from the schematic or PCB editor and check for the Constraint Manager command. If the Constraint Manager is available, skip this page and go to the next\u00a0page:\u00a0Placing Components and Routing the Board.\tAltium Designer&#039;s PCB editor is a rules-driven environment. With a well-defined set of design rules, you can successfully complete board designs with varying and often stringent design requirements.Design rules are configured in the PCB Rules and Constraints Editor dialog. The rules are divided into categories, which are then further divided into design rule types.\tThe constraints that are needed will depend on the nature of your design and manufacturing capabilities. There is no specific set of constraints that suits every design.\tDefining the Width Design RulesThe width of the routing is controlled by the applicable Width design rule, which is\u00a0automatically selected\u00a0when you start routing a net.\t\t\t\t\t\tWhen you are configuring the rules, the basic approach is to set the lowest priority rule to target the largest number of nets, and then add higher-priority rules to target nets with special width requirements, such as power nets. There is no issue if a net is targeted by multiple rules because Altium Designer always looks for and only applies the highest priority rule. For example, the tutorial design includes a number of signal nets\u00a0and two power nets. The default routing width rule can be configured at 0.25 mm for the signal nets. This rule will target all nets in the design by setting the rule scope to All. Even though a scope of All also targets the power nets, these can be specifically targeted by adding a second, higher-priority rule, with a scope of\u00a0(InNet(&#039;12V&#039;) OR InNet(&#039;GND&#039;)). The image below shows the summary of these two rules.\t\t\t\t\t\t \t\t\t\tTwo Width design rules have been defined.\u00a0The lowest priority rule targets all nets, and\u00a0the higher priority rule targets objects in the 12V net or the GND net.\t\t\t\t\t\t\t\t\t\tA Width design rule\u00a0includes minimum, maximum, and preferred settings. Use these if you prefer to have some flexibility during routing.\t\t\t\t\t\t\t\t\t\tAvoid using the minimum and maximum settings to define a single constraint value to suit all sizes required in the entire design. Doing this means you forgo the ability to get Altium Designer to monitor that each design object is appropriately sized for its task.\t\t\t\t\t\tDefining the Width Design Rule for the Signal Nets\u00a0\t\t\tWith the PCB as the active document, open the PCB Rules and Constraints Editor\u00a0dialog by selecting the Design \u00bb Rules command from the main menus i.\t\t\t\t \t\t\t\t\t\tEach rules category is displayed under the Design Rules structure (left-hand side) of the dialog. Double-click on the Routing category entry to expand it\u00a0and see the related routing rules, then double-click on the\u00a0Width\u00a0rule type entry to display the currently defined width rules.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Tutorial_Dlg_PCBRulesAndConstraintsEditor_AD24\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tClick once on the existing Width rule to select it. When you click on the rule, the right-hand side of the dialog displays the settings for that rule\u00a0including\u00a0the rule&#039;s Where The Object Matches in the top section (also referred to as the rule&#039;s scope \u2013 what you want this rule to target)\u00a0with the rule&#039;s Constraints below that.\t\t\t\t \t\t\tThe default Width design rule\t\t\t\t\t\tSince this rule is to target the majority of nets in the design (the signal nets), confirm that the Where The Object Matches setting is set to All\u00a0as shown in the image above.\t\t\t\t\t\tSet the constraints for the rule by entering the following values:\t\t\t\t\t\t\t\t\t\t\tMin Width = 0.2\t\t\t\t\t\t\t\t\t\t\t\t\t\tPreferred Width = 0.25\t\t\t\t\t\t\t\t\t\t\t\t\t\tMax Width = 0.25\t\t\t\t\t\t\t\t\t\t\t\t\t\tIt is not necessary to enter the measurement units because the default measurement units will be added to the entered values automatically.\t\t\t\t\t\t\t \t\t\t\t\t\tThe rule is now defined. Click Apply to save it and keep the dialog open.\t\t\tDefining the Width Design Rule for the Power NetsThe next step is to add another design rule to specify the routing width for the power nets.\t\t\tWith the existing Width rule selected in the Design Rules tree on the left of the PCB Rules and Constraints Editor\u00a0dialog, right-click and select New Rule to add a new Width rule.\t\t\t\t \t\t\t\t\t\tA new rule named Width_1 appears. Click on the new rule in the Design Rules tree to configure its properties.\t\t\t\t \t\t\t\t\t\tClick in the Name field and enter the name Width_Power in the field.\t\t\t\t \t\t\t\t\t\tSet the rule scope so the rule targets objects that belong to the\u00a012V or GND net. We will use the\u00a0Query Builder dialog to build the query for the scope. To do this (the process is also shown in the video below):\t\t\t\t\t\t\t\t\t\t\tClick in the drop-down in the Where The Object Matches region and select Custom Query from the list.\u00a0The dialog will change to include an edit box where the custom query is entered.\t\t\t\t\t\t\t\t\t\t\t\t\t\tClick the \u00a0button to open the Query Builder dialog.\t\t\t\t\t\t\t\t\t\t\t\t\t\tClick the Add first condition text, select Belongs to Net, then set the Condition Value to 12V.\t\t\t\t\t\t\t\t\t\t\t\t\t\tClick the Add another condition text, select Belongs to Net, then set the Condition Value to GND.\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe AND operator will have appeared between the two condition statements.\u00a0Click on it and select OR from the drop-down.\t\t\t\t\t\t\t\t\t\t\t\t\t\tClick the OK button to accept the query and return to the PCB Rules and Constraints Editor\u00a0dialog. The rule scope will change to (InNet(&#039;12V&#039;) OR InNet(&#039;GND&#039;)).\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSet the constraints for the rule to allow power net routing widths in the range of\u00a00.25 to 0.5 mm. To do this,\u00a0enter\u00a0the following values:\t\t\t\t\t\t\t\t\t\t\tMin Width = 0.25\t\t\t\t\t\t\t\t\t\t\t\t\t\tPreferred Width = 0.5\t\t\t\t\t\t\t\t\t\t\t\t\t\tMax Width = 0.5\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\tClick Apply to save the rules and keep the dialog open.\t\t\tDefining the Clearance\u00a0Design RuleThe next step is to define how close electrical objects belonging to different nets\u00a0can be to each other. This requirement is handled by the Clearance design rule. For the tutorial, a clearance of 0.25 mm between all objects is suitable.\t\t\tExpand the Electrical category in the tree of design rules, then expand the Clearance rule type.\t\t\t\t \t\t\t\t\t\tClick to select the existing rule of this type.\t\t\t\t\t\t\tNote that this rule has two query fields:\u00a0Where The First Object Matches and Where The Second Object Matches. That is because this is a binary rule;\u00a0it is a rule that applies between two\u00a0objects. The rules engine checks each object targeted by the Where The First Object Matches setting and checks it against the objects targeted by the Where The Second Object Matches setting\u00a0to confirm that they satisfy the specified Constraints settings.\t\t\t\t\t\t\tFor this design, this rule will be configured to define a single clearance between All objects.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn the Constraints region of the dialog, set the Minimum Clearance to 0.25.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tNote that entering a value into the Minimum Clearance field will automatically apply that value to all of the fields in the grid region at the bottom of the dialog. You only need to edit in the grid region when you need to define a clearance based on the object type.\t\t\t\t\t\t\t\t\tClick Apply to save the rule and keep the dialog open.\t\t\tDefining the Routing Via StyleAs you route and change layers, a via is automatically added. In this situation, the via properties are defined by the applicable Routing Via Style design rule.\t\t\tExpand the Routing category in the tree of design rules then expand the Routing Via Style rule type and select the existing design rule of this type.\t\t\t\t \t\t\t\t\t\tSet the constraints for the rule to set the allowed\u00a0via diameter to 1 mm and the allowed via hole size to\u00a00.6 mm. In this case, we will set all fields (minimum, maximum, and preferred) to the same size:\t\t\t\t\t\t\t\t\t\t\tVia Diameter: Minimum, Maximum, Preferred\u00a0= 1\t\t\t\t\t\t\t\t\t\t\t\t\t\tVia Hole Size: Minimum, Maximum, Preferred = 0.6\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\t\tSince it is highly likely that the power nets can be routed on a single side of the board, it is not necessary to define a routing via style rule for signal nets and another routing via style rule for power nets.\t\t\t\t\t\t\t\t\tClick OK to save the changes and close the PCB Rules and Constraints Editor dialog.\t\t\t\t\t\tSave the PCB document locally by right-clicking its entry in the\u00a0Projects\u00a0panel and selecting\u00a0Save\u00a0from the context menu.\t\t\t\tDefining the design rules is now complete. The next step is placing the components and routing the board.\tvar p = document.getElementsByClassName(&quot;Counter&quot;);for (k = 0; k &lt; p.length; k++) {Bloberator(p[k].id, &quot;0&quot;);}document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);function Update(ss, n) {var g = (document.getElementById(ss).innerHTML) - 1;var TextArray = document.getElementsByClassName(ss + ss);var ImageArray = document.getElementsByClassName(ss);if ((g == 0) &amp; (n == -1)) {n = 0;}ImageArray[g].style.opacity = &quot;0&quot;;ImageArray[g].style.zIndex = &quot;-1&quot;;if (g &lt; TextArray.length) {TextArray[g].style.display = &quot;none&quot;;}g = g + (n);if (g == ImageArray.length) {g = 0;}var v = ImageArray[g].getElementsByTagName(&quot;video&quot;)[0];if (v != null) {v.currentTime = 0;v.play();}ImageArray[g].style.opacity = &quot;1&quot;;ImageArray[g].style.zIndex = &quot;1&quot;;if (g &lt; TextArray.length &gt; 0) {TextArray[g].style.display = &quot;inherit&quot;;}document.getElementById(ss).innerHTML = g + 1;Bloberator(ss, g);}function Bloberator(sss, m) {var dots = &quot;&quot;;var IR = document.getElementsByClassName(sss);for (d = 0; d &lt; IR.length; d++) {if (d == m) {dots = dots + &quot;&quot;;} else {dots = dots + &quot;&quot;;}}var dotrows = document.getElementsByName(sss);for (x = 0; x &lt; dotrows.length; x++) {dotrows[x].innerHTML = dots;}}","tags":"","url":"altium-designer\/24\/documentation-altium-designer-tutorial-setting-up-design-rules.html"},
{"title":"Placing Components and Routing the Board","text":"It is time to position the components in suitable locations on the board and then route it.Positioning the Components on the PCBMain page:\u00a0Component PlacementThere is a saying that PCB design is 90% placement and 10% routing. While you could argue about the percentage of each, it is generally accepted that good component placement is critical for good board design. Keep in mind that you may need to also tune the placement as you route.To move a component,\u00a0Click, Hold&amp;Drag to move the component to the required location, rotate it with the Spacebar\u00a0(in increments of 90\u00ba counterclockwise), then release the mouse button to place it. The connection lines are automatically reoptimized as you move a component. Use them to help orient and position the components to reduce the number of connection line cross-overs.Once you have placed the components, the PCB should look like the image below. \tComponents have been positioned on the board, ready for routing.\t\t\tZoom to display the board and the component.\t\t\t\t\t\tThe components will be positioned on the current snap grid. For a simple design such as this, there are no specific design requirements that dictate what placement grid should be used. As the designer, you decide what a suitable placement grid would be. To simplify the process of positioning the components, you can work with a large placement grid. Check the Status Bar to confirm that the Snap Grid is set to 1 mm. Use the View \u00bb Grids \u00bb Set Global Snap Grid\u00a0command from the main menus if required.\t\t\t\t \t\t\t\t\t\tTo place connector P1:\t\t\t\t\t\t\t\t\t\t\tPosition the cursor over the middle of the outline of the connector\u00a0and use Click, Hold&amp;Drag. The cursor will change to a crosshair and jump to\u00a0the center of the nearest pad of the component.\t\t\t\t\t\t\t\t\t\t\t\t\t\tWhile continuing to hold down the mouse button, move the mouse to drag the component. Note how the connection lines drag with the component.\t\t\t\t\t\t\t\t\t\t\t\t\t\tPress the Spacebar to rotate the component if required, and position the component towards the left-hand side of the board\u00a0as shown in the image above.\t\t\t\t\t\t\t\t\t\t\t\t\t\tWhen the connector component is in position, release the mouse button to drop it into place.\t\t\t\t\t\t\t\t\t\t\t\t\tReposition the remaining components, using the image above as a guide. Use the Spacebar to rotate components as you drag them so that the connection lines are as shown in the image.\t\t\t\t\t\tReposition the component designators. This can be done in a similar fashion.\u00a0Use Click, Hold&amp;Drag\u00a0to move the text and press the Spacebar to rotate it. Alternatively, use the Autoposition option in the Properties panel when the designator(s) are selected in the design space ().\t\t\t\t\t\tSave the PCB document locally by right-clicking its entry in the\u00a0Projects\u00a0panel and selecting\u00a0Save\u00a0from the context menu.\t\t\tWith the components positioned, it is time to do some routing!Interactively Routing the BoardMain page: Interactive RoutingIn this part of the tutorial, you will route the board.Routing is the process of laying tracks and vias on the board to connect the component pins. The PCB editor makes this job easy by providing sophisticated interactive routing tools.\u00a0These tools help maximize routing efficiency and flexibility in an intuitive way, including cursor guidance for track placement, single-click routing of the connection, pushing obstacles, and automatically following existing connections, all in accordance with applicable design constraints.\t    Notes on Interactive Routing    \t\t\t\t\t\tUse the PCB Editor \u2013 Interactive Routing page\u00a0of the Preferences dialog to configure\u00a0the interactive routing options.\t\t\t\t\t\t\t\t\t\tTo start interactive routing, select the\u00a0Route \u00bb Interactive Routing command from the main menus (shortcut: Ctrl+W), then click a net object (e.g., pad).\t\t\t\t\t\t\t\t\t\tMove the cursor to see routes following the cursor. Routes on a PCB are made from a series of straight segments and\/or arcs. Each time there is a change of direction, a new track\/arc begins.\t\t\t\t\t\t\t\t\t\tClick to place hatched track segments. Placed segments are shown as solid.\t\t\t\t\t\t\t\t\t\tWhen you click on the destination pad to finish a route,\u00a0the cursor is released from the current route.\u00a0You will remain in interactive routing mode, ready to select the next connection to be routed.\t\t\t\t\t\t\t\t\t\tAs you place tracks on the board, use connection lines\u00a0to guide you.\t\t\t\t\t\t\t\t\t\tUseful shortcuts during routing:\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tShift+F1 \u2013 pop up a menu of interactive shortcuts. Most settings can be changed on the fly by pressing the appropriate shortcut or selecting from the menu.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTab\u00a0\u2013 open\u00a0the Properties panel, where you can change the routing settings.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tShift+Spacebar\u00a0\u2013 cycle through the various track corner modes.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSpacebar\u00a0\u2013 toggle the current corner direction.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tShift+R\u00a0\u2013\u00a0cycle through routing conflict resolution modes as you interactively route.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t3 \u2013 cycle through the routing width choices: Rule Minimum \/ Rule Preferred \/ Rule Maximum \/ User Choice.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t* (on the numeric keypad) or Ctrl+Shift+Mouse Wheel\u00a0\u2013\u00a0switch to the next available signal layer. A via is automatically added in accordance with the applicable via style constraint.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tBackspace\u00a0\u2013 rip up the last-placed segment for the connection that you are currently routing.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tCtrl+Click \u2013 auto-complete the connection being routed. Auto-complete will not succeed if there are unresolvable conflicts with obstacles.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tRight-Click \u2013 drop the current connection and remain in interactive routing mode. Right-Click\u00a0again to exit\u00a0interactive routing mode.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tRefer to the PCB Editor &amp; PCB Footprint Editor Shortcuts page to learn more.\t\t\t\t\t\t\t\t\t\tIf it is required to modify an existing route, you can\u00a0Click, Hold&amp;Drag\u00a0a placed track segment to interactively slide routing across the board.\t\t\t\t\t\t\t\t\tA video that shows the board being routed. Some connections are finished using Ctrl+Click to autocomplete.\t\t\tBefore starting to route, configure the interactive routing options in the PCB Editor \u2013 Interactive Routing page of the Preferences dialog.\t\t\t\t\t\t\t\t\t\t\tClick the\u00a0 button at the top of the design space to open the Preferences dialog and then expand the PCB Editor category in the left tree and select the Interactive Routing entry in this category to open the page.\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn the Routing Conflict Resolution region of the page, set Current Mode to Walkaround Obstacles.\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn the Interactive Routing Width Sources region of the page, make sure that the Track Width Mode\u00a0and Via Size Mode options are both set to Rule Preferred.\t\t\t\t\t\t\t\t\t\t\t\t\t\tClick OK to save changes and close the dialog.\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\tSet the snap grid to 0.25 mm using the Snap Grid dialog (View \u00bb Grids \u00bb Set Global Snap Grid).\t\t\t\t\t\tClick on the Top Layer tab at the bottom of the design space to make it the active layer, ready to route on.\t\t\t\t \t\t\t\t\t\tSelect the\u00a0Route \u00bb\u00a0Interactive Routing\u00a0command from the main menus (shortcut:\u00a0Ctrl+W). The cursor will change to a crosshair, indicating you are in interactive routing mode.\t\t\t\t\t\tPosition the cursor over the lower pad on connector P1.\t\t\t\t\t\tClick to anchor the first point of the track.\t\t\t\t\t\tMove the cursor below the pad and click to place a vertical segment.\t\t\t\t\t\tRoute by clicking to commit track segments, finishing on the lower pad of R2.\t\t\t\t\t\tContinue to route all the connections on the board. The video above shows the board being interactively routed.\t\t\t\t\t\tWhen you finish routing, save the PCB document locally by right-clicking its entry in the\u00a0Projects\u00a0panel and selecting\u00a0Save\u00a0from the context menu.\t\t\t\tA powerful feature of Altium Designer is the ability to view your board as a 3-dimensional object. To switch to 3D, run the View \u00bb 3D Layout Mode command from the main menus (shortcut:\u00a03). The board will be displayed as a 3-dimensional object. The tutorial board is shown below.\t\tTo navigate a board in 3D, you can use the following controls:\t\t\t\t\t\t\tZooming \u2013 Ctrl+Mouse Wheel\t\t\t\t\t\t\t\t\t\tPanning \u2013 Right-Click, Hold&amp;Drag.\t\t\t\t\t\t\t\t\t\tRotation \u2013 Shift+Right-Click, Hold&amp;Drag. Rotational movement of the model is made about the center of a directional sphere that\u00a0appears at the current cursor position when you press Shift.\t\t\t\t\t\t\t \t\tRefer to the\u00a0Controlling the 3D View page to learn more.\t\tThe PCB design is complete. Now, confirm that the PCB complies with the defined constraints by verifying the board design.\u00a0","tags":"","url":"altium-designer\/24\/documentation-altium-designer-tutorial-component-placement-routing-board.html"},
{"title":"Verifying Your Board Design","text":"The PCB editor is a rules-driven design environment\u00a0in which you can define many types of design constraints that can be checked to ensure the integrity of your board. The online DRC feature monitors the enabled rules as you work and immediately highlights any detected design violations. Alternatively, you can also run a batch DRC\u00a0to test that the design complies with the rules and generate a report that details the enabled rules and any detected violations.Earlier in the tutorial, you examined and configured some design constraints, including electrical clearance, routing width, and routing via style. As well as these, there are a number of other design rules that are automatically defined when a new board is created.Configuring and Running a Design Rule Check (DRC)Main page:\u00a0Setting Up &amp; Running a DRCThe design is checked for violations by running the design rule check (DRC). Both online and batch DRC are configured in the Design Rule Checker dialog accessed by selecting the Tools \u00bb Design Rule Check command from the main menus. The dialog provides general reporting options (Report Options \u2013\u00a0) and the ability to configure testing of specific rule types (Rules to Check\u00a0\u2013 ).A design rule check is run by clicking the\u00a0\u00a0button at the bottom of the dialog. The DRC runs, and then the Messages panel opens and lists all detected violations. If the Create Report File option has been enabled in the dialog, a Design Rule Verification Report will open in a separate document tab. The report details the rules that are enabled for checking, the number of detected violations, and specific details about each violation.\t\t\tSelect the Tools \u00bb Design Rule Check command from the main menus to open\u00a0the Design Rule Checker dialog.\t\t\t\t\t\tOn the Report Options\u00a0page of the dialog, make sure that the\u00a0Create Report File option is enabled.\t\t\t\t \t\t\t\t\t\tOn the Rules To Check\u00a0page of the dialog, right-click in the grid area and select the Batch DRC - Used On entry.\t\t\t\t \t\t\t\t\t\tDisable batch DRC for the testpoint rules. To do this, select the Testpoint section in the tree and disable the Batch checkboxes for the four rule types in this category.\t\t\t\t \t\t\t\t\t\tClick the  button at the bottom of the dialog to run DRC. The\u00a0Design Rule Checker dialog will close and\u00a0the report will open. It will include (at least):\t\t\t\t\t\t\t\t\t\t\t4 Minimum Solder Mask Sliver violations \u2013 the minimum width of a strip of solder mask is less than the allowed value.\t\t\t\t\t\t\t\t\t\t\t\t\t\t4 Clearance Constraint violations \u2013 the measured electrical clearance value between objects on signal layers is less than the specified minimum amount.\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe upper section of the report details the rules that are enabled for checking and the number of detected violations. Click on a rule to jump to and examine those violations.\t\t\t\t\t\t\tThe lower section of the report shows each rule that is being violated, followed by a list of the offending objects. Click on a\u00a0violation entry to jump to that object on the PCB.\t\t\t\tDetected violations will also be listed in the Messages panel that opens.\u00a0\t\t\t\t \t\t\tLocating and Resolving ViolationsMain page:\u00a0Interrogating &amp; Resolving Design ViolationsAs the designer, you have to locate a violation in the PCB, establish its condition and how much it has actually failed, and work out the most appropriate way of resolving the violation.\t    Notes on Locating and Resolving Violations    \t\t\t\t\t\tAltium Designer has two techniques for displaying design rule violations:\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tViolation overlay \u2013 violations are identified by indicating the offending primitive using a pattern (by default, green circles with crosses).\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tViolation details \u2013 the nature of violations are detailed using\u00a0a numerical value that shows the constraint that is failing\u00a0and\/or an icon that\u00a0indicates the site and type of violation.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAn example of a Clearance violation is shown below. Both of the above techniques are used to indicate the violation. Offending pads are highlighted using a pattern. Also, the violation is indicated by the white arrows and the  0) {            TextArray[g].style.display = &quot;inherit&quot;;        }        document.getElementById(ss).innerHTML = g + 1;        Bloberator(ss, g);    }    function Bloberator(sss, m) {        var dots = &quot;&quot;;        var IR = document.getElementsByClassName(sss);        for (d = 0; d &lt; IR.length; d++) {            if (d == m) {                dots = dots + &quot;&quot;;            } else {                dots = dots + &quot;&quot;;            }        }        var dotrows = document.getElementsByName(sss);        for (x = 0; x &lt; dotrows.length; x++) {            dotrows[x].innerHTML = dots;        }    }","tags":"","url":"altium-designer\/24\/documentation-altium-designer-tutorial-verifying-board-design.html"},
{"title":"Creating the PCB Drawing","text":"Main page: Streamlining Board Design Documentation with DraftsmanAltium Designer&#039;s Draftsman editor provides tools for creating multi-sheet fabrication and assembly drawings in an automated manner based on the project&#039;s PCB document.Adding and Configuring a New Draftsman DocumentMain page: Setting Up a Draftsman DocumentTo start creating a new drawing, you need to add a new Draftsman document to the project.\t\t\tRight-click the project entry in the\u00a0Projects\u00a0panel and select the\u00a0Add New to Project \u00bb Draftsman Document\u00a0command from the context menu.\t\t\t\t \t\t\t\t\t\tThe New Document dialog will open. Select the [Default] entry in the Templates list and make sure that the correct project and PCB document (Multivibrator.PrjPcb\u00a0and Multivibrator.PcbDoc) are selected in the Project and Document drop-downs.\t\t\t\t \t\t\t\t\t\tClick OK in the dialog. A new blank Draftsman document will open and an entry for it will appear linked to the project in the Projects panel under the Source Documents entry.\t\t\t\t \t\t\t\t\t\tRight-click on the Draftsman document entry in the\u00a0Projects\u00a0panel and select the\u00a0Save As\u00a0command.\u00a0The\u00a0Save As\u00a0dialog will open, ready to save the document in the same location as the project file. Type the name\u00a0Multivibrator\u00a0in the\u00a0File name\u00a0field and click the\u00a0Save\u00a0button.\t\t\t\t\t\tAdding the Draftsman document has changed the project, so save the project locally by right-clicking\u00a0the project entry in the\u00a0Projects\u00a0panel\u00a0and selecting\u00a0Save.\t\t\t\t\t\tIf the\u00a0Properties\u00a0panel is not visible, click the\u00a0\u00a0button at the bottom right of the design space and select\u00a0Properties\u00a0from the menu that opens.\u00a0The panel displays the properties of the selected object, or if no object is selected, it displays the properties of the Draftsman document.\t\t\t\t\t\tOn the Page Options tab of the panel,\u00a0select Template\u00a0in the\u00a0Formatting and Size\u00a0region, then use the\u00a0Template\u00a0drop-down to select the\u00a0ANSI B Landscape\u00a0Draftsman template from those that reside in your Workspace.\t\t\t\t \t\t\t\tTo navigate in a Draftsman document, use\u00a0Ctrl+Mouse Wheel\u00a0to zoom in and out and\u00a0Right-Click, Hold&amp;Drag\u00a0to pan.\u00a0There are also a number of useful commands in the\u00a0View\u00a0main menu, such as\u00a0Fit Document\u00a0(Ctrl+PgDn).\tAdding Drawing ViewsMain page: Working with ViewsDraftsman allows a range of automated production drawings to be placed directly onto a Draftsman drawing document. The drawing data is extracted directly from the source PCB document.\t\t\tPlace a board\u00a0assembly view. To do this:\t\t\t\t\t\t\t\t\t\t\tSelect the Place \u00bb Board Assembly View command from the main menus.\t\t\t\t\t\t\t\t\t\t\t\t\t\tA top-side board assembly\u00a0view will be attached to the cursor. Move the cursor to position the view in the top left part of the drawing. Once you are happy with the view&#039;s location, click to place it on the drawing.\t\t\t\t\t\t\t\t\t\t\t\t\tIf necessary, the location of a view can be changed after placement by using the Click, Hold&amp;Drag\u00a0shortcut on the view.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tDouble-click the placed view outside component projections on the view\u00a0to open its properties in the Properties panel. On the General tab of the panel:\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSelect\u00a0the 2:1 value from the Scale drop-down in the Scale region.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSelect the Silkscreen option from the Designator drop-down in the Component Display Properties region.\u00a0When this option is selected, the position\u00a0of component designators on the assembly view is\u00a0defined by the positions of corresponding designators on the overlay layer in the PCB document.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\tPlace board fabrication views. To do this:\t\t\t\t\t\t\t\t\t\t\tSelect the Place \u00bb Board Fabrication View command from the main menus.\t\t\t\t\t\t\t\t\t\t\t\t\t\tA top-layer board fabrication view will be attached to the cursor.\u00a0Move the cursor to position the view at the right of the placed board assembly view and click to place it.\t\t\t\t\t\t\t\t\t\t\t\t\t\tDouble-click the placed view to open its properties in the Properties panel. On the General tab of the panel, select\u00a0the 2:1 value from the Scale drop-down in the Scale region.\t\t\t\t\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\tPlace another board fabrication view to show the bottom layer. Select the Place \u00bb Board Fabrication View command from the main menus.\t\t\t\t\t\t\t\t\t\t\t\t\t\tMove the cursor to position the view at the right of the placed board fabrication view and click to place it.\t\t\t\t\t\t\t\t\t\t\t\t\t\tDouble-click the placed view to open its properties in the Properties panel. On the General tab of the panel:\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSelect\u00a0the 2:1 value from the Scale drop-down in the Scale region.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSelect the Bottom Layer\u00a0option from the Layer\u00a0drop-down in the Properties region.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\tPlace a\u00a0board\u00a0isometric view. To do this:\t\t\t\t\t\t\t\t\t\t\tSelect the Place \u00bb Additional Views \u00bb Board Isometric View command from the main menus.\t\t\t\t\t\t\t\t\t\t\t\t\t\tMove the cursor to position the view at the right of the placed board fabrication views and click to place it.\t\t\t\t\t\t\t\t\t\t\t\t\t\tDouble-click the placed view to open its properties in the Properties panel. In\u00a0the panel:\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSelect\u00a0the 2:1 value from the Scale drop-down in the Scale region.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSelect the Front\u00a0option from the Face side\u00a0drop-down in the Properties region.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\tPlace a layer stack legend. To do this:\t\t\t\t\t\t\t\t\t\t\tSelect the Place \u00bb Layer Stack Legend\u00a0command from the main menus.\t\t\t\t\t\t\t\t\t\t\t\t\t\tMove the cursor to position the layer stack legend below the placed board fabrication and board isometric views and click to place it.\t\t\t\t\t\t\t\t\t\t\t\t\t\tAnnotating the DrawingMain pages: Drawing Annotation,\u00a0Dimensioning &amp; Tolerances,\u00a0Working with TablesA number of annotation, dimensioning, and other tools are supported to add important information to a Draftsman drawing document.\t\t\tObject dimension graphics can\u00a0be placed on board views\u00a0to indicate the lengths, sizes, and angles of the object outlines\u00a0or the distances between nominated objects.\t\t\t\t\t\tIndustry-standard geometric dimensioning\u00a0and\u00a0geometric tolerances\u00a0symbolic elements that define the manufacturing properties of objects included in a drawing are supported.\t\t\t\t\t\tTables of different types can be placed to convey crucial information for the PCB fabrication and assembly processes in a simple, visual way.\t\t\t\t\t\tA range of graphical element tools for placing basic, free-form drawing elements in a document is also provided.\t\t\t\t\t\tPlace linear dimensions for the horizontal and vertical size of the board on the board assembly view. To do this (the process is also shown in the video below):\t\t\t\t\t\t\t\t\t\t\tSelect the Place \u00bb Linear Dimension\u00a0command from the main menus.\t\t\t\t\t\t\t\t\t\t\t\t\t\tTo place the dimension&#039;s first reference point, hover the cursor over the top edge of the PCB on the board assembly view and click when the edge is highlighted orange.\t\t\t\t\t\t\t\t\t\t\t\t\t\tTo place the dimension&#039;s second reference point, hover the cursor over the bottom edge and click when the edge is highlighted orange.\t\t\t\t\t\t\t\t\t\t\t\t\t\tMove the cursor at the left of the view and click to set the position of the dimension text and its associated extension lines.\t\t\t\t\t\t\t\t\t\t\t\t\t\tYou will stay in dimension placement mode. Place another dimension by sequentially clicking the left and right edges of the PCB on the board\u00a0assembly view and clicking below the view.\t\t\t\t\t\t\t\t\t\t\t\t\t\tRight-click to exit\u00a0dimension placement.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tPlace callouts displaying the BOM positions of the components on the board assembly view. To do this (the process is also shown in the video below):\t\t\t\t\t\t\t\t\t\t\tSelect the Place \u00bb Annotations \u00bb Callout\u00a0command from the main menus.\t\t\t\t\t\t\t\t\t\t\t\t\t\tHover the cursor over the edge of the transistor Q1 projection on the board assembly view so it is highlighted and click to place the callout pointer.\t\t\t\t\t\t\t\t\t\t\t\t\t\tMove the cursor at the right of the view and click to confirm the placement of the callout source text.\t\t\t\t\t\t\t\t\t\t\t\t\t\tIdentify one more source for the same callout by hovering the cursor over the edge of\u00a0the\u00a0transistor Q2 projection and clicking.\t\t\t\t\t\t\t\t\t\t\t\t\t\tRight-click to\u00a0complete the placement of this callout. You will remain in callout placement mode.\t\t\t\t\t\t\t\t\t\t\t\t\t\tPlace callouts for other components on the view as shown in the image below.\t\t\t\t\t\t\t\t\t\t\t\t\t\tWhen all required callouts are placed, right-click to exit callout placement.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tPlace a BOM table. To do this:\t\t\t\t\t\t\t\t\t\t\tSelect the Place \u00bb Bill Of Materials\u00a0command from the main menus.\t\t\t\t\t\t\t\t\t\t\t\t\t\tMove the cursor to position the table below the placed board assembly view and click to place it.\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\tSave the Draftsman document locally by right-clicking its entry in the\u00a0Projects\u00a0panel and selecting\u00a0Save\u00a0from the context menu.\t\t\t\t\t\tClose the Draftsman document by right-clicking its tab at the top of the design space and selecting the\u00a0Close Multivibrator.PCBDwf\u00a0command from the context menu.\u00a0\t\t\t\t\t\tSave the project to the Workspace.\u00a0To do this,\u00a0click the\u00a0Save to Server\u00a0control next to the project entry in the\u00a0Projects\u00a0panel, enter a meaningful comment into the\u00a0Comment\u00a0field of the\u00a0Save to Server\u00a0dialog that opens (e.g.,\u00a0Drawing is created), then click the\u00a0OK\u00a0button.\t\t\t\tYou have completed the drawing and are ready to prepare outputs and release the project.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-tutorial-pcb-drawing.html"},
{"title":"Preparing Outputs and Releasing the Project","text":"Main page: Preparing Your Design for ManufactureNow that you&#039;ve completed the design and layout of the PCB, you&#039;re ready to produce the output documentation needed to get the board reviewed, fabricated, and assembled.Because a variety of technologies and methods exist in PCB manufacture, Altium Designer has the ability to produce numerous output types for different purposes, including Gerber files, ODB++ files, Pick and Place files, Bill of Material reports, etc.Adding an Output Job File to the ProjectMain page: Preparing Manufacturing Data with Output JobsWhile you can\u00a0selectively generate the required outputs from specific editors (e.g., using commands in the Fabrication Outputs\u00a0and\u00a0Assembly Outputs\u00a0sub-menus of the File main menu in the PCB editor), Altium Designer provides support for\u00a0Output Job files. An Output Job file (or &#039;OutJob&#039; for short) stores\u00a0settings for each output type. An OutJob allows you to configure each output type, configure their output naming, format, and output location. Outputs can be generated from an OutJob directly or\u00a0as a part of the integrated project release process.\t\t\tRight-click the project entry in the\u00a0Projects\u00a0panel and select the\u00a0Add New to Project \u00bb Output Job File\u00a0command from the context menu.\u00a0A new Output Job file will open and an entry for it will appear linked to the project in the Projects panel under the Settings\\Output Job Files entry.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Tutorial_AddNewOutJob_AD24\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tRight-click the OutJob entry in the\u00a0Projects\u00a0panel and select the\u00a0Save As\u00a0command. The\u00a0Save As\u00a0dialog will open, ready to save the document in the same location as the project file. Type the name\u00a0Fabrication\u00a0in the\u00a0File name\u00a0field and click the\u00a0Save\u00a0button.\t\t\t\t\t\tAdding the OutJob has changed the project, so save the project locally by right-clicking\u00a0the project entry in the\u00a0Projects\u00a0panel\u00a0and selecting\u00a0Save.\t\t\tAdding and Configuring Fabrication OutputsMain page: Preparing Fabrication DataIn this part of the tutorial, you will configure the outputs required to fabricate the board: Gerber and NC Drill files.\u00a0\t\t\tTo add a new Gerber output, click the Add New Fabrication Output\u00a0link in the Fabrication Outputs section of the OutJob&#039;s Outputs region\u00a0and select Gerber Files \u00bb [PCB\u00a0Document].\t\t\t\t \t\t\t\t\t\t\tIf you select the [PCB Document] option, the project&#039;s PCB document will be automatically used as the output source. Choosing this also means the OutJob can easily be copied between projects, as this setting will not have to be updated. If there are multiple PCB documents in the project, you will need to select the specific board.\t\t\t\t\t\t\t\t\tDouble-click the added\u00a0Gerber Files output entry. The Gerber Setup dialog will open. Configure options in the dialog as follows:\t\t\t\t\t\t\t\t\t\t\tSince the board has been designed in metric, make sure that the Units\u00a0option is\u00a0set to Millimeters.\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe smallest unit used on the board is 0.25mm for the routing and clearance, but because most of the components have their reference point at their geometric center (and were placed on a 1mm grid), some of their pads will actually be on a 0.01 grid. Set the Decimal\u00a0option to 0.001 mm. This ensures that the resolution of the output data is more than adequate to cover these grid locations.\t\t\t\t\t\t\t\t\t\t\t\t\t\tClick the\u00a0\u00a0button at the bottom of the Layer to plot tab and choose Select\u00a0Used. The layers that are used in the design will be enabled in the Plot column of the grid above.\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\t\tClick Apply\u00a0to accept the other default settings and close the Gerber Setup dialog.\t\t\t\t\t\tBecause the board has holes, an NC Drill file also needs to be generated. Same way, add the NC Drill output to the OutJob file \u2013 click the Add New Fabrication Output\u00a0link in the Fabrication Outputs section of the OutJob&#039;s Outputs region\u00a0and select NC Drill Files \u00bb [PCB\u00a0Document].\t\t\t\t \t\t\t\t\t\tDouble-click the added NC Drill Files output entry\u00a0to access the NC Drill Setup dialog. To ensure that NC Drill files will be created in the same format\u00a0as the Gerber files, set the Units to Millimeters and the Format to 4:3. Make sure that the Coordinate Position option is set to Reference to relative origin.\t\t\t\t \t\t\t\t\t\tClick OK\u00a0to accept the other default settings and close the NC Drill Setup dialog.\t\t\t\t\t\tNow that\u00a0the Gerber and NC Drill settings are configured, the next step is to configure their naming and output location. This is done by mapping them to an output container on the right side of the OutJob.\u00a0For discrete files with their own file format, use a Folder Structure container. A new OuJob includes some containers by default. Select the\u00a0Folder Structure\u00a0entry in the list of output containers, then click the radio buttons for the Gerber and NC Drill Files in the Enabled column of the Outputs region to map these outputs to the selected container, as shown below.\t\t\t\t \t\t\t\t\t\tThe last step is to configure the container. To do this, click the Change link in the container entry when it is selected\u00a0to open the Folder Structure settings dialog. At the top of the dialog, there is a set of controls that are used to configure the output location.\u00a0Make sure that the first control is set to Release Managed. The lower part of the dialog will display how the names and folder structure change as you select different options.\t\t\t\t \t\t\t\t\t\tClick OK to close the Folder Structure settings dialog.\t\t\tAdding and Configuring a DRC Validation ReportMain page: Preparing Validation ReportsAltium Designer includes a number of validation checks, which can be included as an output, during output generation. Each produces an HTML report file. During the project release process, these checks will be performed prior generation of other outputs, and if any validation checks are not passed successfully, the release will fail.\t\t\tTo add a new DRC validation output, click the Add Validation Output\u00a0link in the Validation Outputs section of the OutJob&#039;s Outputs region\u00a0and select Design Rules Check \u00bb [PCB\u00a0Document].\t\t\t\t \t\t\t\t\t\tMap the added report to the existing\u00a0Folder Structure\u00a0container. Select the Folder Structure\u00a0entry in the list on the right side of the OutJob, then click the radio button for the Design Rules Check output in the Enabled column of the Outputs region.\t\t\t\t \t\t\t\t\t\tSave the Output Job file locally by right-clicking its entry in the\u00a0Projects\u00a0panel and selecting\u00a0Save\u00a0from the context menu.\t\t\t\t\t\tClose the Output Job file by right-clicking its tab at the top of the design space and selecting the\u00a0Close Fabrication.OutJob\u00a0command from the context menu.\u00a0\t\t\tAdding and Configuring Assembly OutputsMain page: BOM Configuration in the Report ManagerThe actual output BOM file that is generated\u00a0is done using the Report Manager dialog \u2013 a highly configurable report generation engine that can generate output in a variety of formats\u00a0including text, CSV, PDF, HTML, and Excel. Excel-format BOMs can also have a template applied using one of the pre-defined templates\u00a0or one of your own.\t\t\tAdd a new OutJob file to the project by right-clicking\u00a0the project entry in the\u00a0Projects\u00a0panel and selecting the\u00a0Add New to Project \u00bb Output Job File\u00a0command from the context menu.\t\t\t\t\t\tRight-click the OutJob entry in the\u00a0Projects\u00a0panel and select the\u00a0Save As\u00a0command. The\u00a0Save As\u00a0dialog will open, ready to save the document in the same location as the project file. Type the name\u00a0Assembly\u00a0in the\u00a0File name\u00a0field and click the\u00a0Save\u00a0button.\t\t\t\t\t\tSave the project locally by right-clicking\u00a0the project entry in the\u00a0Projects\u00a0panel\u00a0and selecting\u00a0Save.\t\t\t\t\t\tTo add a new BOM output, click the Add New Report Output\u00a0link in the Report Outputs section of the OutJob\u00a0and select Bill of Materials \u00bb [ActiveBOM Document].\t\t\t\t \t\t\t\t\t\tDouble-click the added Bill of Materials output to open the Report Manager dialog.\t\t\t\t\t\tIn the Export Options\u00a0region of the Properties pane on the right side of the dialog, use the\u00a0File Format\u00a0drop-down to select\u00a0Generic XLS (*.xls, *.xlsx, *.xlsm)\u00a0and then use the\u00a0Template\u00a0drop-down to select the\u00a0BOM Template Single Supplier\u00a0template from those that reside in your Workspace.\t\t\t\t \t\t\t\t\t\tClick OK to save changes and close the Report Manager dialog.\t\t\t\t\t\tAdd a new Draftsman output by\u00a0clicking the Add New Documentation Output\u00a0link in the Documentation Outputs section of the OutJob\u00a0and selecting\u00a0Draftsman \u00bb All Draftsman Documents.\t\t\t\t \t\t\t\t\t\tMap the added BOM and Draftsman outputs to the existing\u00a0PDF output container. To do this,\u00a0select the PDF entry in the list of output containers on the right side of the OutJob\u00a0then click the radio buttons for the Bill of Materials\u00a0and Draftsman outputs in the Enabled column of the Outputs region.\t\t\t\t \t\t\t\t\t\tWhen the PDF container entry is selected, click the Change link in the entry to open the PDF settings dialog.\t\t\t\t\t\tClick the Assembly.PDF entry at the top of the PDF settings dialog, select the Separate file for each output using output name, and click the\u00a0 button.\u00a0The output BOM and drawing\u00a0will be assigned the name that is set to the output in the OutJob (Bill of Materials.pdf\u00a0and Draftsman.pdf, respectively), which can be seen in the Preview region of the dialog.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\t\t\tJavascript ID: Tutorial_Dlg_PDFsettings_Path_AD24\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tClick OK to close the dialog.\t\t\t\t\t\tAdd a new Pick &amp; Place output by\u00a0clicking the Add New Documentation Output\u00a0link in the Documentation Outputs section of the OutJob\u00a0and selecting\u00a0Generates pick and place files \u00bb [PCB\u00a0Document].\t\t\t\t \t\t\t\t\t\tDouble-click the added Generates pick and place files output to access the Pick and Place\u00a0Setup dialog.\t\t\t\t\t\tIn the Output Setting region on the bottom left part of the dialog, set the Units to Metric.\t\t\t\t \t\t\t\t\t\tClick OK to accept the other default settings and close the Pick and Place\u00a0Setup dialog.\t\t\t\t\t\tMap the added Pick &amp; Place output\u00a0to the existing\u00a0Folder Structure output container. To do this,\u00a0select the Folder Structure entry in the list of output containers on the right side of the OutJob\u00a0then click the radio button\u00a0for the Generates pick and place files output\u00a0in the Enabled column of the Outputs region.\t\t\t\t \t\t\t\t\t\tSave the Output Job file locally by right-clicking its entry in the\u00a0Projects\u00a0panel and selecting\u00a0Save\u00a0from the context menu.\t\t\t\t\t\tClose the Output Job file by right-clicking its tab at the top of the design space and selecting the\u00a0Close Assembly.OutJob\u00a0command from the context menu.\t\t\tReleasing the ProjectMain page: Design Project ReleaseWith output documentation configured in Output Job files, the project is ready to be released to the connected Workspace. The board design release process is automated, enabling you to release your board design projects without the risks associated with manual release procedures. When a particular project is released, a snapshot of the design source is taken and archived along with any generated output \u2013 which represents a tangible product that is made from that design project and sold by the company.The release process itself is performed using Altium Designer&#039;s Project Releaser, the user interface to which is provided courtesy of a dedicated view \u2013 the Release view. The release process is a staged flow, with the entries on the left-hand side of the view showing you at-a-glance, which stage you are currently at.\t\t\tRight-click the project entry in the\u00a0Projects\u00a0panel and select the\u00a0Project Releaser command from the context menu. The Release view will open\u00a0as a separate document tab.\t\t\t\t \t\t\t\t\t\tIn the first stage \u2013 1. Configure Server Release \u2013 you specify the type(s) of data that you wish to generate. Click on Details controls at the far right of each data set header to access details of what exactly is going to be generated by a data set.\t\t\t\t \t\t\t\t\t\tClick the\u00a0 button at the bottom left of the view to access the Project Release Options dialog. On the dialog&#039;s Release Options tab, make sure that the Managed -  is selected as the Release Target,\u00a0Fabrication is assigned to Fabrication Data set, and Assembly is assigned to the Assembly Data set.\t\t\t\t \t\t\t\t\t\tClick OK to close the dialog and return to the Release view.\t\t\t\t\t\tMake sure that both\u00a0Include Fabrication Data and Include Assembly Data for No Variant options are enabled.\t\t\t\t \t\t\t\t\t\tClick the \u00a0button at the bottom right of the view to proceed.\t\t\t\t\t\tThe Item Creation dialog will open, with the list of target release items to be created in the Workspace. Select the Create items option to confirm item creation.\t\t\t\t \t\t\t\t\t\tIn the Project Modified dialog that opens, select the Save and Commit changes option to save the changes locally and proceed with saving the changes to the Workspace.\t\t\t\t \t\t\t\t\t\tIn the Commit to Version Control dialog that opens, enter\u00a0a meaningful comment into the Comment field\u00a0(e.g., The project is ready for release), then click the\u00a0 button.\t\t\t\t\t\t\t\t\t\tThe next stage of the release process \u2013 2. Validate Project \u2013 is run automatically because the\u00a0Fabrication Output Job file includes the Desing Rules Check report.\t\t\t\t\t\t\tIf any validation checks are not passed successfully, the release will fail. For the project release in this tutorial, this will mean that the PCB document includes at least one DRC violation. In this case, stop the release process with the \u00a0button at the bottom right of the view, open the PCB document, resolve the DRC violations, and then start the release process again.\t\t\t\t\t\t\t\t\tAfter successful validation, the next stage of the release process \u2013 3. Generate Data \u2013 is run automatically. This is where all other outputs \u2013 defined in the OutJob file(s) assigned to the included data items \u2013 are run, to generate the data to be released into the relevant target items in the Workspace.\t\t\t\t \t\t\t\t\t\tWith all validation checks passed\u00a0and output data generated, the next stage of the release process \u2013 4. Review Data \u2013 allows you to review the generated data. Proceed with the release by clicking the\u00a0 button at the bottom right of the view.\t\t\t\t \t\t\t\t\t\tThe Confirm Release dialog will open, summarizing the configurations of the project that will be released to the Workspace. Enter a Release Note (e.g., Initial Release), and click OK.\t\t\t\t \t\t\t\t\t\tAfter confirming the release in the previous stage, the next stage \u2013 5. Upload Data \u2013 is automatically entered. It simply presents the progress of data upload into the revisions of the relevant data Items in the Workspace.\t\t\t\t \t\t\t\t\t\tThe final stage of the process \u2013 6. Execution Report \u2013 provides a summary of the release. Close the Release view by clicking the\u00a0 button at the bottom right of the view.\t\t\t\t \t\t\t\tCollaborative Design with a Workspace\tMore often than not, multiple people\u00a0are\u00a0involved in the design and development of an electronic product. To do this effectively, the members of that design team need to be able to work collaboratively.\u00a0Altium Designer, in conjunction with a connected Workspace, supports a number of collaborative design features. Some of them are listed below.\t\t\t\t\t\t\tProject history \u2013 a\u00a0dedicated History view is\u00a0an advanced graphically orientated project history timeline\u00a0that provides a progressive timeline of major events relating to the project \u2013 its creation, commits, releases, clones, and MCAD exchanges \u2013 with various actions supported where applicable (). The History view for a Workspace project can be accessed from Altium Designer by right-clicking the\u00a0project entry in the Projects panel and selecting\u00a0the History &amp; Version Control \u00bb Show Project History command from the context menu.\t\t\t\t\t\tLearn more:\u00a0Project History, Project History (Altium 365 Workspace, Enterprise Server Workspace)\t\t\t\t\t\t\t\t\t\tWeb Viewer \u2013 the Workspace&#039;s\u00a0Web Viewer\u00a0interface provides universal access to project documents through a standard browser. Much more than just a browser-based viewer, its advanced browser technology allows users to navigate through the project structure, interact with design documents, highlight areas or objects for commenting notes, and search, cross-probe, select, and inspect components and nets throughout the design.\u00a0The Web Viewer for a Workspace project can be accessed from Altium Designer by right-clicking the\u00a0project entry in the Projects panel and selecting\u00a0the Show in Web Browser command from the context menu.\t\t\t\t\t\tLearn more:\u00a0Web Viewer (Altium 365 Platform, Enterprise Server Workspace)\t\t\t\t\t\t\t\t\t\tDocument commenting \u2013 a\u00a0comment is a user-added note that is assigned to a specific point, object, or area (as applicable) on a supported data view and may be replied to by other users. Comments promote collaboration between users without altering the shared data itself because comments are stored by the Workspace independently of that data. Comments applied in the Web Viewer interface in the following places become available in Altium Designer and vice-versa. In Altium Designer, the commenting feature is managed through the Comments and Tasks panel ().\t\t\t\t\t\tLearn more:\u00a0Document Commenting, Web Viewer (Altium 365 Platform, Enterprise Server Workspace)\t\t\t\t\t\t\t\t\t\tSharing a project \u2013 once a project is saved to the Workspace, you can determine which users can actually access that project, for collaborative design and\/or reviewing this project. This is done by sharing the project, or rather, by configuring its access permissions. In Altium Designer, project sharing is managed through the Share dialog ()\u00a0accessed by\u00a0right-clicking the\u00a0project entry in the Projects panel and selecting\u00a0the Share\u00a0command from the context menu.\t\t\t\t\t\tLearn more:\u00a0Sharing a Design,\u00a0Workspace Projects (Altium 365 Workspace, Enterprise Server Workspace)\t\t\t\t\t\t\tCongratulations!\u00a0You started with a blank schematic sheet and worked through to a finished PCB with outputs released to the Workspace, which is\u00a0the entire design process in Altium Designer!\tvar p = document.getElementsByClassName(&quot;Counter&quot;);for (k = 0; k &lt; p.length; k++) {Bloberator(p[k].id, &quot;0&quot;);}document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);function Update(ss, n) {var g = (document.getElementById(ss).innerHTML) - 1;var TextArray = document.getElementsByClassName(ss + ss);var ImageArray = document.getElementsByClassName(ss);if ((g == 0) &amp; (n == -1)) {n = 0;}ImageArray[g].style.opacity = &quot;0&quot;;ImageArray[g].style.zIndex = &quot;-1&quot;;if (g &lt; TextArray.length) {TextArray[g].style.display = &quot;none&quot;;}g = g + (n);if (g == ImageArray.length) {g = 0;}var v = ImageArray[g].getElementsByTagName(&quot;video&quot;)[0];if (v != null) {v.currentTime = 0;v.play();}ImageArray[g].style.opacity = &quot;1&quot;;ImageArray[g].style.zIndex = &quot;1&quot;;if (g &lt; TextArray.length &gt; 0) {TextArray[g].style.display = &quot;inherit&quot;;}document.getElementById(ss).innerHTML = g + 1;Bloberator(ss, g);}function Bloberator(sss, m) {var dots = &quot;&quot;;var IR = document.getElementsByClassName(sss);for (d = 0; d &lt; IR.length; d++) {if (d == m) {dots = dots + &quot;&quot;;} else {dots = dots + &quot;&quot;;}}var dotrows = document.getElementsByName(sss);for (x = 0; x &lt; dotrows.length; x++) {dotrows[x].innerHTML = dots;}}","tags":"","url":"altium-designer\/24\/documentation-altium-designer-tutorial-output-documentation-project-release.html"},
{"title":"Getting Familiar with the Altium Design Environment","text":"Altium Designer brings a complete electronic product development environment, catering for all aspects of the electronic development process, including front-end design and capture, mixed-signal circuit simulation, physical PCB design, etc.This page discusses\u00a0basic working techniques with Altium Designer so you can quickly start your next product design.Main UI ElementsAltium Designer uses UI elements common to other Windows applications and CAD tools. The main of those are shown below and described afterward.\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\tJavascript\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tDesign space\u00a0\u2013 the main region of the application window where the active document is shown. In the design space, you can explore the document&#039;s content (e.g.,\u00a0a schematic document, as shown in the above image) and work with it.\t\t\t\t\t\t\t\t\t\t\t\t\t\tPanels\u00a0\u2013 provide access to different features and functionalities related to the active project or document. Panels can be accessed from the menu of the Panels button at the bottom right of the design space.\t\t\t\t\t\t\t\t\t\t\t\t\t\tMain menus\u00a0\u2013\u00a0provide you with access to commands for working with the current document type. The set of available menus and commands depends on the type of the currently active document.\t\t\t\t\t\t\t\t\t\t\t\t\t\tActive Bar\u00a0\u2013 always shown at the top of the design space of the current document, the Active Bar provides handy access to the most commonly used commands, such as commands for placing and selecting objects.\t\t\t\t\t\t\t\t\t\t\t\t\t\tQuick Access Bar\u00a0\u2013 provides you with access to high-level operations, such as saving documents and undoing\/redoing actions.\t\t\t\t\t\t\t\t\t\t\t\t\tLearn more about these and other elements of the Altium Designer environment:\u00a0Elements of the Environment.Signing in to Your Altium Account\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\tIn order to\u00a0access Altium on-demand services, such as On-Demand licensing and connection to an Altium 365 Workspace, you must be signed in to your Altium account from Altium Designer. When you are not signed in to your Altium account, the Current User\u00a0control at the top-right of the design space is presented as . To sign in, click the control and select the Sign In\u00a0entry on the associated menu. Use the subsequent\u00a0Sign In\u00a0dialog that appears to enter your Altium account credentials, then click the\u00a0Sign in\u00a0button. The control will change to your\u00a0Altium profile picture (e.g.,\u00a0).\t\t\t\t \t\t\tLearn more about available signing-in options:\u00a0Signing in to Your Altium Account.Connecting to Your Altium 365 WorkspaceWhen signed in to your Altium account, you can connect to an available Altium 365\u00a0Workspace to access its features and data.\u00a0To do so, click on the Active Workspace Control at the top-right of the design space (when you are not connected to a Workspace, the control is presented as\u00a0).\u00a0In the subsequent menu, click the entry for the Altium 365 Workspace you wish to connect to. The control will change to reflect the name of the connected Workspace (e.g., ). Learn more about available connection options:\u00a0Accessing Your Workspace.Setting Up the EnvironmentThe Preferences dialog is\u00a0a central location where you can set up global system settings\u00a0across different functional areas of Altium Designer. To access the Preferences dialog, click the\u00a0 icon at the top-right of the design space. Click a page\u00a0entry\u00a0on the left-hand side of the dialog to show its options on the right-hand side of the dialog. For convenience, pages are clustered into categories for\u00a0function areas (System, Data Management, Schematic, etc.).Learn more about Altium Designer preferences:\u00a0Accessing, Defining &amp; Managing System Preferences.Working with Design Projects and DocumentsThe starting point for every design created in Altium Designer is a project. An Altium Designer project is a set of design documents whose output defines a specific implementation.\u00a0As well as storing links to each document in the project, the project file also stores project-specific options, such as error check settings.Altium Designer supports the PCB, Multi-board and Harness types of design projects. Below is a brief description of each.\t    PCB Project    In a Printed Circuit Board (PCB) project, the electronic circuit is captured as a schematic, which is built up from libraries of component symbols that are placed and wired together.\t\tThe design is then transferred to the PCB editor where each component is instantiated as a footprint (pattern) and the circuit wiring becomes point-to-point connection lines. A shape for the final PCB is defined, along with the physical layers the board will include. Design rules specify the layout requirements, such as routing widths and clearance. The components are positioned within the board shape, and the connection lines are then replaced by routing.\t\tWhen the design is complete, standard format output files are generated which can be used to fabricate the blank board, configure an assembly machine, and so on.\t\t\t    Multi-board Project    In a Multi-board project, the logical design is captured using a schematic document that connects together sub-project modules, which in turn represent existing PCB projects. The Multi-board schematic data is then transferred to a Multi-board assembly document where the physical board assemblies, as defined by the sub-projects, are positioned together and within an added enclosure.\t\tA Multi-board project (*.PrjMbd) effectively defines the electrical and physical connectivity between existing PCB design projects through the application of a logical schematic document (*.MbsDoc) and synchronized assembly document (*.MbaDoc).\t\tLearn more about Designing with Multiple PCBs.\t\t\t    Harness Project    The Harness Design functionality allows engineers of various types (involved in the Product Design process) to work in Altium Designer. It brings comprehensive harness design support into the same environment as PCB and system design, removing the previous heavy reliance on third-party software.\t\tThe Harness Design functionality allows you\u00a0to create a full wiring harness design, from the individual pin-to-pin connections right through to manufacturing documentation. A harness design can be created as a standalone project, or as part of a Multi-board project. In the latter case, the logical connections between PCBs in the Multi-board project are used to define the connectivity within the harness.\t\tLearn more about Harness Design.\t\tThe most of project management operations (creating, opening, etc.) are performed using the File main menu and the Projects panel.\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\tJavascript\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTo create a new design project, select the File \u00bb New \u00bb Project command from the main menus. In the Create Project dialog that opens, select the location where you want to create the\u00a0project, the type of the project, and other options such as project name, storage folder, etc. After clicking the Create button, the entry of the new project will appear in the Projects panel.\t\t\t\t\t\t\t\t\t\t\t\t\t\tAll project-related data is stored in documents, which are also referred to as files. To add a new document to a project, right-click the project&#039;s entry in the Projects panel and select a required document type in the Add New to Project menu.\t\t\t\t\t\t\t\t\t\t\t\t\t\tNote that a newly created\u00a0document is initially unsaved. Use the right-click menu of the document&#039;s entry in the Projects panel to save it. Similarly, use\u00a0right-click menu of the project&#039;s entry in the Projects panel to save it when the project is changed (e.g., when its structure is changed by adding a new document).\t\t\t\t\t\t\t\t\t\t\t\t\t\tTo open an existing project, use the File \u00bb Open Project command from the main menus and the subsequent Open Project dialog. The structure of the opened project will appear in the Projects panel.\t\t\t\t\t\t\t\t\t\t\t\t\t\tDouble-click a document entry in the panel to open this document in the design space.\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe icons next to the project and document entries in the Projects panel provide a visual summary of their open\/modified and version control status.When working with a document of a &quot;graphical&quot; type (e.g., a schematic sheet or PCB document), you can zoom and pan the document to focus on a specific document area. The basic shortcuts that can be used to do this are:\t\t\tCtrl+Mouse Wheel\u00a0or\u00a0Middle-Click, Hold&amp;Drag to zoom in and out\t\t\t\t\t\tRight-Click, Hold&amp;Drag\u00a0or Mouse Wheel or Shift+Mouse Wheel to slide the document around\t\t\tThe video below demonstrates use of these shortcuts.\t\tTo learn more about working with projects and documents, refer to the following pages:\t\t\t\t\t\t\tCreating Projects and Documents\t\t\t\t\t\t\tOpening Projects and Documents\t\t\t\t\t\t\tSaving Projects and Documents\t\t\t\t\t\t\tManaging Project Documents\t\t\t\t\t\t\tNavigating a Document\t\t\tWorking with Design ObjectsCreation of a document, be it a schematic sheet, PCB, or drawing, is essentially\u00a0placing objects in the required arrangement and setting their properties. The main placement and editing techniques common for most\u00a0Altium Designer editors are listed below.\t\t\tTo place an object, select\u00a0the corresponding placement command from the main menus or the Active Bar. For example, to place a wire in a schematic sheet, select the Place \u00bb\u00a0Wire command from the main menus or click the\u00a0 icon in the Active Bar.\t\t\t\t\t\tAfter selecting a placement command, you will enter the placement mode indicated by a crosshair under the cursor. Position the cursor in the design space, then left-click\u00a0to place the object. For complex objects, such as wires or polygons, you must continue the position-and-click procedure to place all vertices of the object.\t\t\t\t\t\tWhen in placement mode, press Tab to open\u00a0to edit the object&#039;s properties in the\u00a0Properties\u00a0panel that opens, before placing the object. Once you have finished setting the properties,\u00a0click the\u00a0 button in the design space\u00a0to return to placement mode.\u00a0\t\t\t\t\t\tTo end placement mode, right-click.\t\t\t\t\t\tTo edit the properties of a placed\u00a0object, select it by clicking on\u00a0it in the design space. Its properties will be shown in the Properties panel. If the panel is not open, double-click the object to select it and open the panel.\t\t\tThe video below demonstrates the object placement process and editing its properties.\t\tGetting Help\tAltium Designer provides various ways for\u00a0you to locate additional information and help.\t\t\t\t\t\t\tPress\u00a0F1\u00a0over any object, editor, panel, menu entry, or button to open the documentation for that item.\t\t\t\t\t\t\tPress\u00a0Shift+F1\u00a0while running a command for a list of shortcuts you can use in that command.\t\t\t\t\t\t\tUse the navigation tree\u00a0on the left side of the documentation to read about a particular subject \u2013  show image.\t\t\t\t\t\t    var p = document.getElementsByClassName(&quot;Counter&quot;);    for (k = 0; k &lt; p.length; k++) {        Bloberator(p[k].id, &quot;0&quot;);    }    document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);    document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);    function Update(ss, n) {        var g = (document.getElementById(ss).innerHTML) - 1;        var TextArray = document.getElementsByClassName(ss + ss);        var ImageArray = document.getElementsByClassName(ss);        if ((g == 0) &amp; (n == -1)) {            n = 0;        }        ImageArray[g].style.opacity = &quot;0&quot;;        ImageArray[g].style.zIndex = &quot;-1&quot;;        if (g &lt; TextArray.length) {            TextArray[g].style.display = &quot;none&quot;;        }        g = g + (n);        if (g == ImageArray.length) {            g = 0;        }        var v = ImageArray[g].getElementsByTagName(&quot;video&quot;)[0];        if (v != null) {            v.currentTime = 0;            v.play();        }        ImageArray[g].style.opacity = &quot;1&quot;;        ImageArray[g].style.zIndex = &quot;1&quot;;        if (g &lt; TextArray.length &gt; 0) {            TextArray[g].style.display = &quot;inherit&quot;;        }        document.getElementById(ss).innerHTML = g + 1;        Bloberator(ss, g);    }    function Bloberator(sss, m) {        var dots = &quot;&quot;;        var IR = document.getElementsByClassName(sss);        for (d = 0; d &lt; IR.length; d++) {            if (d == m) {                dots = dots + &quot;&quot;;            } else {                dots = dots + &quot;&quot;;            }        }        var dotrows = document.getElementsByName(sss);        for (x = 0; x &lt; dotrows.length; x++) {            dotrows[x].innerHTML = dots;        }    }","tags":"","url":"altium-designer\/24\/documentation-altium-designer-design-environment.html"},
{"title":"Elements of the Environment","text":"Altium Designer is unique in its ability to support all aspects of electronic design,\u00a0from capture to generation of PCB manufacturing output. It does this in a single software application, through the support of the underlying X2 integration platform. The platform supports all of the standard user-interface elements, such as menus and toolbars (also called resources), with each editor plugging in its own specific set of resources and commands. See the below section for descriptions, access, etc., to Altium Designer&#039;s environment elements.The following sections describe some of the main elements of the design space highlighted in the image above.PreferencesPreferences dialogs are a central location in which you can set up global system settings\u00a0across different functional areas of the software. These preferences apply across projects and relevant documents. The various dialogs are accessed by clicking \u00a0at the top right of the design space. Use \u00a0on the left side of the dialog to open the selections for the required area then choose the desired\u00a0title to open that specific preference page.Active Workspace ControlThe Active Workspace control located at the right of the \u00a0icon allows you to connect to a Workspace available for you. Depending on whether you are currently signed in to your Altium account and connected to a Workspace, the control might be presented as follows:\t\t\t \u2013 you are currently connected to an available Workspace. The text reflects the name of the connected Workspace.\t\t\t\t \u2013 you are currently not connected to a Workspace. Click the control to connect to an available Workspace or select Custom connection\u00a0from the Current User control menu to connect to an Enterprise Server Workspace.\t\t\t\t\u00a0\u2013 you are currently not connected to a Workspace and not signed in to\u00a0your Altium account. Select Sign in from the Current User control menu to connect to your Altium account or select Custom connection\u00a0from the menu to connect to an Enterprise Server Workspace.\t\tRefer to Accessing Your Workspace for detailed information.Current User ControlThe Current User control reflects whether you are signed in to your Altium account and provides access to a menu that allows you to configure some aspects of your Altium Designer installation such as licensing and extensions.Sign InWhen you are not signed in to your Altium account, Current User control is presented as . To sign in to your Altium account, click on the control, then click the  entry on the associated menu. Use the subsequent Sign In dialog that appears to sign in to your Altium\u00a0account.\tRefer to Signing in to Your Altium Account for detailed information.LicensesAltium Designer provides\u00a0various license types and each is designed to suit your individual needs. The licensing system\u00a0enables you to get up and running with Altium Designer software in a timely and efficient manner. To access the License Management page, click \u00a0next to your sign-in credentials at the top right of the design space then select Licenses from the drop-down menu. \tFor full licensing information, refer to License Management.Extensions &amp; UpdatesExtensions are\u00a0add-ons to the software that\u00a0provide extended features and functionality.\u00a0You have the\u00a0ability to install, update\u00a0or remove\u00a0additional functionality, which includes a new importer or exporter, a tool for schematic symbol generation, and support for mechanical CAD collaboration.To access the Extensions &amp; Updates\u00a0page, click \u00a0next to your sign-in credentials at the top right of the design space then select Extensions and Updates\u00a0from the drop-down menu. Updating Altium Designer gives you the most recent release of the core platform software and any extensions you have installed.To access Updates,\u00a0click \u00a0next to your sign-in credentials at the top right of the design space then select Extensions and Updates\u00a0from the drop-down menu. On the Extensions &amp; Updates page, select the\u00a0Updates\u00a0tab as shown in the image below. The (n) displays the total number of updates that are available. If there is no (n), there are no updates.The\u00a0Updates\u00a0page displays any\u00a0core platform updates that are available and\u00a0a listing of System Extensions and Software Extensions\u00a0for which there is an update available.\tRefer to Extending &amp; Updating Altium Designer for detailed information.Custom ConnectionThe Custom connection entry of the Current User control menu allows you to connect to your\u00a0Enterprise Server Workspace from within Altium Designer. Select the entry, and\u00a0Sign in dialog\u00a0will appear, with which to connect to the target Workspace. Enter the URL for the Workspace and your Workspace access credentials, then click the Sign in\u00a0button.\tRefer to the\u00a0Connecting to Your Enterprise Server Workspace section of the\u00a0Accessing Your Workspace for detailed information.Buy\u00a0NowIf you are using an evaluation (Trial)\u00a0license, the\u00a0 button will be displayed at the top-right of the design space. Click the button to open a new tab in your browser in which you can select and buy the license you require.License\/Subscription Expiration NotificationIf you are using a license or subscription that will expire soon\u00a0or is already expired, the\u00a0 icon will\u00a0be displayed at the top-right of the design space. Click the icon to show a pop-up message where the issue is described and recommendations for its resolution are\u00a0suggested.PanelsPanels are essential elements of the Altium Designer environment. Whether specific to a particular document editor, or used on a more global, system-wide level, they present information and controls that aid productivity and allow you to design more efficiently. For example, the PCB panel can be used to browse by Components or Nets. When Altium Designer is first started, the Projects panel will already be open and pinned\/docked on the left side of the design space. To open other panels, click the Panels button at the bottom right of the design space then select the desired panel. Each editor has panels specific to that editor.\tPanels are used to work across the environment, for example, the Projects panel is used to open any document in the project, as well as display the project hierarchy. Document-specific panels can only be displayed when that document type is the active document.\t \tLeft image: PCB panels; right image: Schematic panels\tFor detailed information about accessing panels, panel display modes (i.e. pinned\/docked, pop-up, floating), moving and closing panels, and more, refer to Working with Panels.\tTwo panels of interest that are widely used when working in virtually every editor in Altium Designer are the Properties and Messages panel.Properties PanelThe Interactive\u00a0Properties\u00a0panel provides universal editing access to the properties of documents and objects available in each design editor. The panel dynamically determines its content (or, in other words, changes its mode) based on the document or object that is currently selected and presents specific properties and settings that relate to that document\/object. The Properties panel also supports editing the properties of multiple selected objects.\tThe Properties panel in its Components mode. This mode is active when a component is selected in a\u00a0schematic sheet.\t\t\t\t\t\tAmong other standard methods of accessing a panel, the Properties panel can be accessed by double-clicking on an object in the design space or using the\u00a0F11\u00a0keyboard shortcut.\t\t\t\t\t\t\t\t\t\tIn many cases, the Properties panel is divided into collapsible regions. For example, the General tab of the Properties panel for a component\u00a0selected on a schematic sheet (shown above) has\u00a0the following\u00a0regions: General, Location, Parameters,\u00a0Graphical, and Part Choices.\u00a0These\u00a0regions can be opened\/collapsed using\u00a0the small triangle next to the region name. In the example shown above, the Location region is collapsed, while other regions are expanded.\t\t\t\t\t\t\t\t\t\tBecause the fields available in the Properties panel change to suit the document\/object currently selected, information about each instance of the panel is distributed throughout the documentation. The best way to learn more about a specific instance of the Properties panel is to\u00a0press F1 when the cursor is hovering over the panel in Altium Designer. For example, pressing F1 over the panel when a PCB component is selected for editing will open the Component Properties collapsible section on the\u00a0Component Placement page.\t\t\t\t\t\tMessages PanelWhether validating a project, running a design rule check for the active PCB document, performing a mixed-signal simulation, or using any of the other message-enabled features of the software, the Messages panel provides an intelligent way of listing any warnings and\/or errors that may be present, as well as any status information. The panel supports\u00a0cross-probing\u00a0from the selected message in the panel to the object responsible for the message in the associated document.\tThe Messages panelActive BarThe tools most commonly used in each editor are available on the Active Bar, which is displayed at the top of the design space. Hover over an icon to view a pop-up of the icon&#039;s description. To use the icon displayed, click on it. \tTop image: PCB Active Bar; Bottom image: schematic Active Bar.The buttons on the Active Bar are either single-function or multi-function. Multi-function buttons are indicated by a small white triangle in their bottom-right corner. Click and hold anywhere on a multi-function button for one second or right-click it \u2013 a\u00a0menu will appear listing other available commands. The last-used command will become the default for that button location. \tThe Active Bar\u00a0is available when the UI.UseActiveBar option is enabled in the Advanced Settings dialog.\tMain MenusThe main menus allow access to commands and functions for the active document. The menus appear across the top left of each editor and each editor has its own set of menus. Main menus for PCB (top image) and SCH (bottom image)To use commands, click the title (e.g., Design)\u00a0then select\u00a0the desired command from the drop-down menu. \tSome commands have sub-menus, which are indicated by a\u00a0. When you hover the\u00a0cursor over such a command, the sub-menu opens.Quick Access BarThe Quick Access Bar is located at the top left of the design space and is used to quickly perform frequently used functions.\u00a0\t\t\t\u00a0- use to exit and close Altium Designer.\t\t\t\t\u00a0- use to save the currently active document.\t\t\t\t\u00a0- use to save all documents in which changes have been made.\t\t\t\t\u00a0- use to access the Open Project dialog in which you can choose the project to open.\t\t\t\t \u00a0- use to undo the last action. The icon is available only if an action has occurred.\t\t\t\t \u00a0- use to redo the last action. The icon is available only if an undo action has been performed.\tStatus BarThe Status Bar displays summary information, such as the coordinate position of the cursor,\u00a0command prompts, shortcut key information, and access to various panels (using the Panels button at the right of the Status Bar). You can toggle the display of the Status Bar by choosing View\u00a0\u00bb Status Bar from the main menus. Command Status BarThe\u00a0Command Status Bar\u00a0provides information about the command currently being used. When a command is not currently being used, this will be reflected in the bar through the status\u00a0Idle state - ready for command.\u00a0You can toggle the display of the Command Status Bar by choosing the\u00a0View\u00a0\u00bb\u00a0Command Status\u00a0command from\u00a0the main menus. \tThe Command Status Bar when the Interactive Routing command of the PCB editor is being used.Windows System Resource MonitorWhen resource consumption gets to a level considered to be high, a resource warning indicator appears at the bottom-right of Altium Designer. Hover the cursor over the indicator for information about which resource(s) are exceeding associated levels of consumption. Note that the color of the indicator changes to highlight the level of resource consumption.A warning indicator appears when Altium Designer&#039;s resource consumption becomes high, and changes color to indicate when action is required.The following resources are monitored:\t\t\tMemory used by Altium Designer\t\t\t\tCount of allocated GDI handles\t\t\t\tPercentage of allocated global and session atoms\tThe resource monitor triggers and displays a warning indicator when any of the above resources reach the following levels:\t\t\t&lt; 60% normal level (no resource indicator is displayed)\t\t\t\t61% to 75% is considered a high level, indicated by a yellow indicator\t\t\t\t76% to 90% is considered a very high level, indicated by an orange indicator. In addition, the message indicates that a restart of Altium Designer is advisable.\t\t\t\t&gt; 90% is considered a critical level, indicated by a red indicator. In addition, the message indicates that a restart of Altium Designer is advisable.\t\tOnly resources that have exceeded the permissible levels will be included in the hover tip message.\tIt is important to be aware that Windows has a default limit of 10000 GDI handles available per application, it is strongly recommended that you restart Altium Designer when advised to do so.Home PageThe Altium Designer\u00a0Home Page is a standalone web page that can be opened as a tab in Altium Designer. The page\u00a0gives you access to user-focused content, including new features, webinars, videos, blogs, and tutorials. The information on this page is continuously updated and videos are added to help keep you up-to-date on Altium Designer&#039;s functionality.The Home Page is opened when the application is started. You can close the Home Page\u00a0tab by right-clicking on the tab then choosing Close Home Page. To access the Home Page after the tab has been closed, click the\u00a0\u00a0icon at the top-right corner of the design space.\tIf you do not want the Home Page to open upon starting Altium Designer, disable the Open Home page on start option on the System - General page of the Preferences dialog.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-design-environment-elements.html"},
{"title":"Signing in to Your Altium Account","text":"\u00a0\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\tYour Altium account provides access to Altium on-demand services, such as On-Demand licensing and connection to an Altium 365 Workspace.\u00a0To sign in to your Altium account, click on the Current User\u00a0control at the top-right of the design space (when you are not signed in to your Altium account, the control is presented as ), then click the  entry on the associated menu. Use the subsequent Sign In dialog that appears to enter your Altium account credentials, then click the Sign in button.\u00a0If you don&#039;t have an Altium account, you can click the control to register for one.\t\t\t\t  Ensure you are signed in to your Altium account, using your Altium\u00a0account credentials.\t\t\t\t\t\t\t    Options and Controls of the Sign In Dialog    \t\t\t\t\t\t\t\t\t\t\t\tEmail \u2013 enter your email. This is the email that was used when your Altium account credentials were created. Contact your local Altium administrator if you do not have your Altium account credentials available.\t\t\t\t\t\t\t\t\t\t\t\t\tPassword \u2013 enter your Altium password.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSign in automatically \u2013 enable this option to automatically sign into Altium&#039;s online services when you start Altium Designer using the specified User Name and Password.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tForgot password? \u2013 select this option to open the Reset Password dialog, where you may receive a new temporary password that will then be sent to your email address.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \u2013 click this button to be directed to Google, where you may sign in using your Google account credentials.\t\t\t\t\t\t\t\t\t\t\t\t\t \u2013 click this button to be directed to Facebook, where you may sign in using your Facebook account credentials.\t\t\t\t\t\t\t\t\t\t\t\t\t \u2013 if your organization has set up single sign on access, you may sign in through the Single Sign On dialog by clicking this button.\t\t\t\t\t\t\t\t\t\t\t\t\tBy signing in you agree to Altium&#039;s Privacy Policy and Terms of Use \u2013 you may select Privacy Policy to be directed to the Altium Privacy Policy, or Terms of Use to be directed to Altium&#039;s General Terms of Service.\t\t\t\t\t\t\t\t\t\t\t\t\tRegister an account \u2013 select this option to be directed to the Altium account registration page, where you may register for a new Altium account, or sign in to a preexisting one.\t\t\t\t\t\t\t\t\t\t\t\t\tSign in \u2013 once the email and password are entered, this button becomes available. Click to continue with the sign-in process.\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe control will change to reflect you are having signed in to your Altium account by displaying your Altium profile picture, or avatar (e.g. ). The menu will display this also, with full name and with a link to quickly access your Altium account\u00a0through your default browser.\t\t\t\t\t\t\tWhen you sign in to your account, you do so through an\u00a0Altium Portal. On the Altium side, a portal is simply a secure connection through to a specific\u00a0Altium Account Management Server.\u00a0All communication with the Altium Account Management Servers through the applicable Altium Portal is secure over HTTPS.\t\t\t\t\t\tYou do not remain permanently connected to the Altium Account Management Servers. Altium Designer communicates with the Account Management Server by making a request and receiving a response. At that point, the connection is closed. There will be numerous requests to sign in, request the available licenses to display, and so on, but each request is independent, and then the connection closes.\t\t\t\t\t\t\tAlternatively, you can sign in using your Google\u00ae or Facebook\u00ae account and, in doing so, link\/associate that account with your Altium account \u2013 learn more.\t\t\t\tIf your organization is set up for SAML Single Sign-On (SSO) with an Identity Provider (e.g., Okta\u00ae), then you can sign in to your Altium account in this way \u2013 learn more.\t\t\t\t\t\t\tHow you are permitted to sign in to your organization&#039;s Altium account is determined by an Administrator for that account on the Authentication page of the Company Dashboard. An Administrator can configure and enable SSO from this page.\t\t\t\t\t\t\t\tThird-party Sign-in\t\tProviding more flexibility in how you can connect to your Altium account, Altium Designer offers popular third-party\u00a0sign-in options: Google\u00ae and Facebook\u00ae. To link an alternative sign-in option to your account, click the desired connection (Google\u00ae shown here) and sign in to that service if required. Enter your existing Altium account credentials on the following page to establish the third-party link to your account.\t\t\t\t\t\t\t\tConfirmation of the account linkage can be seen in your Altium account, which also serves to remove the association if necessary (Unlink Account).\t\t\t\t\t\t\t\t\t\t\t\tSingle Sign On\t\tTo enhance compatibility with existing company systems, you can sign in to Altium Designer using your organization&#039;s Single Sign-On (SSO) authentication system. Along with the benefits of increased security and more efficient IT user access management, the application of SSO schemes provides the convenience of signing in to Altium software using the same set of credentials that apply to your company-wide systems and services.\t\t\t\t\t\t\t\tThe Altium Designer SSO sign-in capability supports the SSO infrastructure embedded in the Altium account\u00a0management application and Altium 365, which in turn hosts your Altium 365 Workspace. With authentication communications based on the standardized Security Assertion Markup Language (SAML 2.0), the system establishes authorized identities from your company&#039;s nominated Identity Provider (IdP) \u2013 for example,\u00a0Okta, OneLogin, etc. The SSO sign-in interface for your company, if not already in place, is usually based on a template or example provided by the IdP \u2013 this instigates the SAML-based authentication assertion exchanges and provides access to company services.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tOutside of Altium Designer, you can establish an SSO session by signing in to either Altium account\u00a0or an Altium 365 Workspace directly.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tYour company&#039;s Altium account is configured for SSO interaction by an account Administrator in the Authentication page of the Company Dashboard. This backend configuration system allows account administrators to establish, test, enable and disable the SSO capability for company users.\t\t\t\t\t\t\u25ba See the SSO Setup page for configuration information and IdP integration examples.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAltium Account Management\t\tThe connection, sign in and portal server details are all available on the System - Account Management page of the Preferences dialog.\t\t\t\t \t\t\tManage connection and sign-in credentials as part of your Altium Designer preferences.\t\t\t\t\t\t\tIf you prefer to work offline, switching Altium Designer to an offline mode, and essentially severing the connection to Altium \u2013\u00a0enable the\u00a0No, I wish to remain disconnected from Altium\u00a0option. By enabling this option, your installation of Altium Designer will stay completely disconnected from Altium. While disconnected, you will not be able to access or use any of the on-demand services that require a connection with Altium. In essence, this option is a &#039;full offline&#039; switch.\t\t\tvar p = document.getElementsByClassName(&quot;Counter&quot;);for (k = 0; k &lt; p.length; k++) {Bloberator(p[k].id, &quot;0&quot;);}document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);function Update(ss, n) {var g = (document.getElementById(ss).innerHTML) - 1;var TextArray = document.getElementsByClassName(ss + ss);var ImageArray = document.getElementsByClassName(ss);if ((g == 0) &amp; (n == -1)) {n = 0;}ImageArray[g].style.opacity = &quot;0&quot;;ImageArray[g].style.zIndex = &quot;-1&quot;;if (g &lt; TextArray.length) {TextArray[g].style.display = &quot;none&quot;;}g = g + (n);if (g == ImageArray.length) {g = 0;}var v = ImageArray[g].getElementsByTagName(&quot;video&quot;)[0];if (v != null) {v.currentTime = 0;v.play();}ImageArray[g].style.opacity = &quot;1&quot;;ImageArray[g].style.zIndex = &quot;1&quot;;if (g &lt; TextArray.length &gt; 0) {TextArray[g].style.display = &quot;inherit&quot;;}document.getElementById(ss).innerHTML = g + 1;Bloberator(ss, g);}function Bloberator(sss, m) {var dots = &quot;&quot;;var IR = document.getElementsByClassName(sss);for (d = 0; d &lt; IR.length; d++) {if (d == m) {dots = dots + &quot;&quot;;} else {dots = dots + &quot;&quot;;}}var dotrows = document.getElementsByName(sss);for (x = 0; x &lt; dotrows.length; x++) {dotrows[x].innerHTML = dots;}}","tags":"","url":"altium-designer\/24\/documentation-altium-designer-signing-altium-account.html"},
{"title":"Accessing Your Workspace","text":"Interaction with your connected Workspace can be made from various areas, but there are two main places:\t\t\tFrom within Altium Designer\u00a0through the Explorer panel.\t\t\t\t\t\tThrough your preferred Browser\u00a0using the Workspace&#039;s browser-based interface.\t\t\t\tAltium Designer connects to a Workspace. That Workspace can be delivered in one of the following ways:\t\t\t\t\t\t\tA Workspace hosted on the Altium 365 cloud-based infrastructure platform,\u00a0also referred to as an Altium 365 Workspace.\t\t\t\t\t\t\tA Workspace provided through the Altium On-Prem Enterprise Server. Also referred to as an Enterprise Server Workspace, this\u00a0is installed and managed by your own IT department.\t\t\t\tFrom a purely component management perspective, much of the day-to-day interaction with your Workspace will be performed from within Altium Designer, through the Components panel.This page takes a look at accessing your Workspace from within Altium Designer.\tFor an Altium 365 Workspace, it is assumed that you have been added to the team for at least one Workspace \u2013 either your own organization&#039;s Workspace or that of another organization. If you do not yet have an Altium 365 Workspace in your own organization, Altium Designer will guide you through its activation, when you attempt to connect.\tConnecting to Your Altium 365 WorkspaceFirst, ensure that you are signed in to your AltiumLive account through Altium Designer. Use the Sign in entry of the Current User control associated menu to sign in (learn more).When signed in, you can connect to your Altium 365 Workspace. To do so, click on the  control at the top-right of the main application window. In the subsequent menu, all Altium 365 Workspaces that are available to you will be listed across two sections:\t\t\tMy Workspaces \u2013 these are Altium 365 Workspaces that you have activated for your own organization and for which you are the owner.\t\t\t\tShared With Me \u2013 these are Altium 365 Workspaces\u00a0to which you have been invited\u00a0and subsequently added as\u00a0a\u00a0member (i.e., you are not the owner of these Workspaces).\tClick the entry for the specific Altium 365 Workspace you wish to connect to.\tAll Altium 365 Workspaces are presented automatically by having signed in to your AltiumLive account.  Click to access a Workspace from all those available to you.\tIf your organization does not yet have an Altium 365 Workspace, a link will be provided to an area with which to do so. The Manage link takes you to your AltiumLive account profile page from where you can activate, and then manage, Altium 365 Workspaces available to you. Click the My Altium 365 link to access the Altium 365 Platform Interface. In either case, clicking a link will open your default Browser (if not already) and open the relevant target in a new tab.\t    Connection when Opening or Creating a Project    You can also connect to your Altium 365 Workspace from the Open Project and Create Project dialogs, when wanting to open an existing project, or create a new project, respectively. In either case, select the  entry in the Locations region of the dialog, then click on the button for the required Workspace.\t\t Connect to a Workspace through the Open Project and Create Project dialogs.\t\tYou will be connected to the Workspace, with the dialog updated to present the Workspace&#039;s name in the Locations region. For the Open Project dialog, the main area will populate with projects currently in the Workspace and that are shared with you. The Create Project dialog will present the controls and options for defining a new project within the Workspace.\t\t Once connected, the location will update with the name of the Workspace, and the relevant dialog content presented.\t\t\t    Automatic Connection to an Altium 365 Workspace    If you are a member of the team for one or more Altium 365 Workspaces and have nominated one of these to be the default Altium 365 Workspace, then you will connect directly to that Workspace when initially signing in to your Altium account (through Altium Designer) using your AltiumLive credentials. After that, each time you sign in to your account within Altium Designer the last connected Workspace will be automatically connected \u2013 all set ready to continue designing where you left off.\t\t\t\tSetting the default Altium 365 Workspace is performed from the Workspaces section of your AltiumLive profile page (https:\/\/profile.altium.com\/) by clicking the  button associated with the required Workspace and selecting the Set as default option from the associated menu (the  label will be shown in the Workspace&#039;s tile on the page).\t\tRead-only Altium 365 WorkspaceIf there is no active subscription across any of the Altium Designer licensing for a company&#039;s account with Altium (to which that company&#039;s Altium 365 Workspace is associated), then that Workspace will switch over to being Read-only. All team members will still be able to view\/work with existing content in the Workspace, but will not be able to modify that existing content in any way, nor create any new content.When connecting to a Read-only Workspace, a warning dialog will be presented and the icon for the connected Workspace will present as . Connecting to a Workspace that has been switched to Read-only mode.\tUse of existing content in a read-only Workspace is only permitted for the time period defined in the Data Retention Policy.Connecting to Your Enterprise Server WorkspaceConnect to your Enterprise Server Workspace from within Altium Designer by clicking the Current User control, at the top-right of the main application window (e.g. ). This will be the user that is currently signed into AltiumLive through this instance of Altium Designer. In the subsequent menu choose the Custom connection command. The Sign in dialog will appear, with which to connect to the target Workspace. Enter the URL for the Workspace and your Workspace access credentials, then click the  button.\tIt can be a good idea to enable the Sign in automatically option so that the entered URL and access credentials are stored and you don&#039;t have to repeatedly enter them to access the Workspace when starting Altium Designer.  Connecting to your Enterprise Server\u00a0Workspace from within Altium Designer.\t    Options and Controls of the Sign in Dialog    \t\t\t\t\t\tServer Address \u2013 use this field to enter the location URL of the Workspace to which you want to connect. The format for this is: :. Use the drop-down arrow then choose Preferences to access the Data Management \u2013 Servers page of the Preferences dialog to manage Workspaces.\t\t\t\t\t\t\tUser Name \u2013 enter an existing, valid user name for a Workspace.\t\t\t\t\t\t\tPassword \u2013 enter the password that corresponds to the User Name.\t\t\t\t\t\t\t\t\t\t\t\tSign in automatically \u2013 enable to automatically sign in to the Workspace when Altium Designer is started.\t\t\t\t\t\t\t\t\t\t\t\t\t\tUse Windows Session credentials \u2013 enable to use your active Windows Session credentials to log into the Workspace. The User Name field will display your Windows username. This enables you to log into the Workspace without the need to create and remember an additional password.\t\t\t\t\t\t\tSign in \u2013 click to log into the Workspace using the above settings.\t\t\t\t\tThe Enterprise Server Workspace&#039;s URL (Server Address) will be in the format http:\/\/: (e.g. http:\/\/impala:9780 for an Enterprise Server installed using the default port assignment). If the Workspace is being accessed from an instance of Altium Designer that is running on the same computer on which the Enterprise Server is installed, you may also use http:\/\/localhost:9780. If you want to connect using your Windows login credentials \u2013 taking advantage of the Workspace&#039;s support for Windows Authentication \u2013 enable the Use Windows Session credentials option.\tThe Altium On-Prem Enterprise Server relies on a number of Microsoft runtime components for successful operation and access, in some situations these may not be present on the target machine. If you receive an error message about a missing library (DLL) when you attempt to connect to your Enterprise Server Workspace, it indicates that there are missing Microsoft runtime components. Obtain and install the relevant Microsoft Visual C++ Redistributable Package for your OS.Connecting to a &#039;Known&#039; Enterprise Server WorkspaceIf you have previously connected to your Enterprise Server Workspace from within the same instance of Altium Designer, it will become a Known Server. If this is the case, you can connect to that Workspace from within Altium Designer in a more streamlined fashion. To do so, click on the  control at the top-right of the main application window. In the subsequent menu, choose the entry for your Workspace, in the CUSTOM CONNECTIONS grouping. If you enabled the Sign in automatically option when accessing that Workspace previously, you will be connected straight away. If this option was not enabled, the Sign in dialog will appear, with which to connect to the target Workspace. Enter the URL for the Workspace, and your Workspace access credentials, then click the  button.  Connecting to your Enterprise Server Workspace from within Altium Designer, when that Workspace is already known.\tNote that when the Sign in automatically option is enabled, you will be connected to the Workspace as the user that last connected through the Sign in dialog. If you need to connect as a different user, you will need to use the Custom connection command in the menu associated with the Current User control, at the top-right of the main application window (e.g. ).\tYou can also access your &#039;known&#039; Workspace from the Open Project and Create Project dialogs, when wanting to open an existing project, or create a new project, respectively. In either case, select the \u00a0entry in the Locations region of the dialog, then click the button relevant to that Workspace on the right-hand side. Again, if you need to connect as a different user, you will need to use the Custom connection command in the menu associated with the Current User control, at the top-right of the main application window (e.g. ).Connecting to an Enterprise Server\u00a0Workspace from Different ComputersSupport is provided for connecting to your Enterprise Server Workspace using the same credentials but from different computers (other than the computer on which the Enterprise Server is installed). If you attempt to connect to a Workspace that you are already connected to from another computer \u2013 either through Altium Designer or the Workspace&#039;s browser-based interface \u2013 a pop-up dialog will alert you to this. You can choose from two options offered in the dialog:\t\t\tTerminate existing session \u2013 close the existing session that you have on the other computer and continue to login to the Workspace from the current computer.\t\t\t\tStart new session \u2013 login to the Workspace from the current computer by using an additional connection license and thereby keep logged into the Workspace from the other computer as well.\t\tThe same user can be accessing an Enterprise Server Workspace concurrently in different ways (e.g., connected through Altium Designer AND signed-in through an external Browser) and it only counts as a single connection from the licensing perspective, when access is made from the same PC. If the same user accesses that Enterprise Server Workspace from different PCs, each different PC access will require a separate connection (so extra seat of a Client Access License). You will therefore only be able to log in from the current computer as well, provided you have enough Client Access Licenses (CAL) remaining.Application of Environment ConfigurationsWhen connecting to a Workspace that has defined\u00a0Environment Configurations, the configuration service determines the environment configuration to be used for that user, and changes the relevant areas of the Altium Designer environment to enforce the permitted data elements of that configuration.If the user is assigned to several roles, and multiple environment configurations can apply, the user will be given the choice of which environment configuration to be applied when they sign-in. Choice is made from the\u00a0Select a Configuration\u00a0dialog. \tIf multiple environment configurations apply to a user, that user will be presented with the choice at the time of connecting to the Workspace, through the Select a configuration dialog\t    Options and Controls of the Select a Configuration Dialog    \t\t\t\t\t\tName \/\u00a0Description - the name and description of the configuration that you created in the browser-based interface. Select the desired configuration.\t\t\t\t\t\t\tRemember my choice - enable to remember the selected configuration when signing in. When this is enabled, the dialog will not appear for any future sign in.\t\t\t\t\t\t\tWork as administrator - enable to work as an administrator, which allows you to work within the software and with a server without any restrictions.\t\t\t\t\t\tThe Work as administrator option is available only if you are an administrator for the server and at least one applicable Environment Configuration applies.\t\tIf the user is also an Administrator for the Workspace, they have the option to Work as administrator. This allows them to work within Altium Designer, and with the Workspace, without any restrictions.If no configuration is available for a user, then their working environment will simply be configured with the latest revision of all released Items that are supported by an environment configuration - as though a default configuration were being applied. If there is at least one released revision of a particular Data Item in the Workspace, then that Item Revision will be used - no local file-based entities (e.g., templates) will be available for use.\tIf multiple environment configurations apply to a user, but they cancel out of choosing one, they will not be able to connect to the Workspace. They will therefore be prevented from accessing design Items in that Workspace and any of the Workspace&#039;s provided services.\t\t\t\t\t\tIf multiple configuration data items have been defined for a particular design element within an environment configuration, Altium Designer will be configured to provide the user with a choice from those items.\t\t\t\t\t\t\tIf an environment configuration applicable to a user has not been fully defined - i.e. not all data configuration items have been specified\/added - those undefined elements of the environment will remain manually definable by the user. This is true also for those applicable elements that are set to Do Not Control.\t\t\t\t\t\t\tWhen connected\u00a0to an Enterprise Server Workspace and having a remembered\u00a0selection of the environment configuration (using the\u00a0Remember my choice option), the use of a specific configuration can be disabled or the choice can be changed through the Connection Properties dialog accessed from the\u00a0Data Management \u2013 Servers\u00a0page of the\u00a0Preferences\u00a0dialog by clicking the Properties control for the entry of the Workspace and selecting Connection.\t\t\t\tFor more information, see Environment Configuration Management\u00a0(Altium 365 Workspace, Enterprise Server Workspace).Checking Connection StatusYou can check whether you are currently connected to a Workspace from the following places:\t\t\tThe menu associated with the Active Server control, at the top-right of the main application window. When actively connected to a Workspace, the control will reflect the name of that Workspace (e.g.  for an Altium 365 Workspace or  for an Enterprise Server Workspace). The currently connected Workspace will also be highlighted in the associated menu (and is distinguished by the \/ icon). Clicking the entry provides access to browse the content of that Workspace through Altium Designer&#039;s Explorer panel. Clicking the  icon provides access to the Workspace&#039;s browser interface (through your default Browser).\t\t\t\t Verification of being connected to your Workspace. Shown here is an example for an Altium 365 Workspace. Hover the cursor over the image to see an example for an Enterprise Server Workspace.\t\t\t\t\t\t\tThe Current User control itself reflects the user who is currently signed in to the AltiumLive account or to the active Enterprise Server Workspace (e.g. ).\t\t\t\t\t\tThe Data Management \u2013 Servers page of the Preferences dialog. When connected to the Workspace, that Workspace will be presented as the Active Server.\t\t\t\tYou can only be actively connected to one Workspace through the software at a time and this could be an Altium 365 Workspace or an Enterprise Server Workspace. If you have previously connected to other Workspaces from that instance of Altium Designer, they will be listed as Known Servers. While actively connected to one Workspace, you could also be connected to another (it will not be the active Workspace).\t\t\t\t Once connected to the Workspace, it will become the Active Server. Shown here is an example for an Altium 365 Workspace. Hover the cursor over the image to see an example for an Enterprise Server Workspace.\t\t\t\t\t\tThe Explorer panel. When connected, the Workspace will be available from the menu associated with clicking on the name of the Workspace currently being browsed.\t\t\t\t\t\t\tNote that all connected Workspaces will be listed, but only one will be active and is distinguished by the inclusion of the  icon and its name in bold.\t\t\t\t  Browsing the Active Server through the Explorer panel in Altium Designer.\t\t\tSwitching WorkspacesYou can quickly switch between any of the Workspaces available to you. To do so, click the Active Server control, at the top-right of the main application window (e.g.  or ). In the subsequent menu choose the entry for the Workspace you wish to switch to. You will be disconnected from the current Workspace, then momentarily connected to the chosen Workspace.  When multiple Workspaces are available, you can quickly switch between them.\tIf switching to an Enterprise Server Workspace and the Sign in automatically option was enabled when accessing that Workspace previously, you will be connected straight away. If this option was not enabled, the Sign in dialog will appear, with which to connect to the target Workspace. Enter the URL for the Workspace, and your Workspace access credentials, then click the  button. Note that when the Sign in automatically option is enabled, you will be connected to the Workspace as the user that last connected through the Sign in dialog. If you need to connect as a different user, you will need to use the Custom connection command in the menu associated with the Current User control, at the top-right of the main application window (e.g. ).Managing Your WorkspaceFrom within Altium Designer, you have the ability to manage certain aspects of your connected Workspace. This is performed from the Data Management \u2013 Servers page of the Preferences dialog. Click the Properties control associated with the Workspace \u2013 in the Active Server region of the page \u2013 to access the commands, illustrated in the following image and detailed thereafter. Accessing commands to manage various properties of the actively connected Workspace. Shown here is an example for a connected Altium 365 Workspace. Hover the cursor over the image to see an example for a connected Enterprise Server Workspace.\t\t\tServer configuration \u2013 use this command to access the Workspace&#039;s browser interface in your default Browser. If you are an Administrator for the Workspace you will be taken to the Admin \u2013 Settings page of the browser interface.\t\t\t\tLifecycles \u2013 use this command to access the Edit Lifecycle Definitions dialog, with which to manage the defined lifecycles for the Workspace.\t\t\t\tNaming schemes \u2013 use this command to access the Edit Revision Naming Schemes dialog, with which to manage the defined revision naming schemes for the Workspace.\t\t\t\tOperations \u2013 use this command to access the Edit Operation Permissions dialog, with which to define and manage global operation permissions for the Workspace.\t\t\t\tConnection (only for an Enterprise Server Workspace) \u2013 use this command to access the Connection Properties dialog, with which to configure your connection to the Workspace.\t\tFor another Workspace to which you have a connection (connected or disconnected), you will only have access to the Server configuration and Connection commands.Disconnecting from Your WorkspaceYou can disconnect from your Workspace from within Altium Designer, in the following ways:\t\t\tBy clicking the Active Server control, at the top-right of the main application window (e.g.  or ). In the subsequent menu, click the disconnect control () at the far right of the entry for the currently connected Workspace.\t\t\t\t \t\t\t\t\t\tBy clicking the  button, associated with the Active Server, on the Data Management \u2013 Servers page of the Preferences dialog. A confirmation dialog will appear \u2013 click Yes.\t\t\t\t\t\t\t\tYour access to the Workspace will also be terminated when you exit Altium Designer. In addition, and for an Administrator of your Workspace, there is the provision to drop a session from the Admin \u2013 Sessions page of the Workspace&#039;s browser interface. For an Altium 365 Workspace, this would then allow the administrator to remove that user from the Workspace team (something that could not otherwise be done if the user were actively using the Workspace). For an Enterprise Server Workspace, this can be used to terminate an existing session and thereby free up a connection to that Enterprise Server Workspace.Working in the WorkspaceOnce you are connected to your Workspace, you can access and create content. From a purely component management perspective, much of the day-to-day interaction with your Workspace will be performed from within Altium Designer through the Components panel. You can also access the Workspace content from Altium Designer using the Explorer panel. When you are working in Altium Designer, you access full Workspace content through the Explorer panel. For component management only, you&#039;ll tend to use the Components panel.To display a panel:\t\t\tClick the  button at the bottom-right of Altium Designer and select the required panel from the menu that appears.\t\t\t\tChoose the required panel entry from the View \u00bb Panels main menu.\t\tTo work with Workspace design projects, an Altium Designer\u00a0VCS Provider - Git software extension must be installed (installed with Altium Designer by default). The extension can be manually installed\/removed or updated from the Altium Designer\u00a0Extensions and\u00a0Updates\u00a0page (select the\u00a0Extensions and Updates\u00a0option from the Current User\u00a0control menu\u00a0at the top-right of the design space, e.g.,\u00a0).\t\t \t\tSee Extending &amp; Updating Your Installation for more information on installing and managing Altium Designer extensions.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-workspace-access.html"},
{"title":"Creating Projects and Documents","text":"The starting point for every design created in Altium Designer is a project. An Altium Designer project collects together a set of design documents whose output ultimately defines a single implementation of what you intend to create. For example, the schematics and PCB in a PCB project include the file set required to manufacture a printed circuit board.\u00a0In contrast, the file set you output from a harness project is used to purchase and assemble a wiring harness, and\u00a0the logical schematic and physical assembly files in a multi-board project output the file set to manufacture and assemble a complete product with multiple connected PCBs.The project&#039;s set of design documents can be brought together from any accessible source, local to the machine or otherwise, the project file relating them together as a unified design. The software uses dynamic compilation to create and manage a unified data model of the project&#039;s components and their connectivity. This data model can then be used to propagate design changes between the design domains \u2013 for example, synchronizing to resolve differences between documents in the Schematic and PCB domains.The project documents can be created and stored in your Altium Workspace, within your version control system, or locally as files on the available network.The sections below describe how to create a new project and add design documents to an existing project.Creating a New Project Using the Create Project DialogA new project can be created within Altium Designer using the Create Project dialog (File \u00bb New \u00bb Project).\tThe Create Project dialog supports creating a new project in your connected Workspace, adding a new project to an existing external version control repository (with a working copy in your preferred location), and creating a new project in a specified folder on your\u00a0local hard drive. \t\t\tIn the Locations list, select the entry for your Workspace (it will appear with the name defined for it) \u2013 you must be actively connected to the Workspace to see this option in the listing. This will be the target server in which to store your new Workspace project.\t\t\t\t\t\t\tIn a nutshell, project management is focused on securely storing and tracking changes throughout the design process, and ultimately, channeling the resulting design through to the creation of a physical item \u2013 such as an assembled PCB to be used in the final product. To meet these needs, Altium Designer provides a range of project management approaches that offer increasing levels of sophistication and capabilities, yet simplify the process from a designer&#039;s perspective. These range from local file-based storage and management, to local\/remote Version Control System (VCS) storage approaches, and through to its advanced and recommended form where the management of design data is centered on the capabilities of a\u00a0Workspace.\t\t\t\t\t\tA connected Workspace and its internal VCS service hosts and manages Altium Designer projects, and also provides simplified VCS operations, inherent design collaboration capabilities, advanced design data sharing, history tracking, Lifecycle management, and much more. Projects that are integrated with a Workspace are accessed directly from Altium Designer, such as from the Projects panel, or from the Workspace itself through its browser-based interface.\t\t\t\t\t\tThanks to the intelligence built into the services provided by a Workspace, tasks such as VCS operations are simplified and automated, and additional design collaboration features such as user access control (sharing), commenting and history are available directly from within Altium Designer. The end result is a robust and secure project storage format and location that can become the central point for collaborative project design.\t\t\t\t\t\t\t\t\t\tWhen connected to a Workspace with one or more active process definitions for the Project Creations process theme, the ability to create a new project through the\u00a0Create Project dialog\u00a0is restricted to Local and VCS type projects only. Instead, the creation of Workspace-based projects comes under the control of active process definitions.\u00a0Learn more about\u00a0Process-based Project Creation.\t\t\t\t\t\tIn the Project Type list, choose the type of project you wish to create, and choose from the applicable templates available as required. The  entry will create a shell project with no initial source documents.\t\t\t\t\t\t\tIf you do not connect to your Workspace, you can still work with Altium Designer (under your valid Altium Designer license), but you will not be able to access that Workspace or any other services it provides. You will, therefore, not be able to use any Workspace project templates. You will only be able to use file-based templates defined locally and available from the templates folder specified on the Data Management \u2013 Templates page of the Preferences dialog (if the Template visibility option is set to Server &amp; Local on this page).\t\t\t\t\t\t\tLearn more about\u00a0Creating a Project Template.\t\t\t\t\t\tEnter a Project Name and, optionally, a project Description.\t\t\t\t\t\t\tThe project name should start with\u00a0and can contain A-Z, a-z, or 0-9. Underscores, dashes, and spaces are allowed, but the latter can only be used within the middle of the name (leading and trailing spaces will be ignored). You can not use the following words: AUX, COM1-COM9, LPT1-LPT9, CON, NUL, and PRN. In addition, the name cannot contain the following characters: \\ . \/ ? % * : | &quot; &lt; &gt;.\t\t\t\t\t\tThe Create Project dialog includes further options:\t\t\tCheck the Version Control option (the default) to impose all VCS capabilities on the project, such as history and advanced sharing capabilities. When unchecked, the project is stored in the Workspace and synchronized with the local copy \u2013 a &#039;mirrored&#039; project in the Simple Sync format.\t\t\t\t\t\t\tThe Version Control option is available only when connected to an Altium 365 Workspace. When connected to an Enterprise Server Workspace, this option is effectively checked.\t\t\t\t\t\tWhen creating a project of the PCB type, check the Constraint Management\u00a0option\u00a0to manage design constraints for this project using the Constraint Manager. When the option is disabled, the design rules system will be used for this project.\t\t\t\t\t\t\t\t\tThe\u00a0Constraint Management option is enabled in the\u00a0Create Project dialog\u00a0by default when the\u00a0System.ConstraintManager option is enabled in the\u00a0Advanced Settings dialog.\t\t\t\t\t\t\t\t\tWhen connected to an Enterprise Server Workspace, the Repository drop-down menu (if present) will list all design repositories managed through Workspace&#039;s Version Control Service, and which have been shared with you to use. Choose the repository in which to store the new project and its files \u2013 there is a single Git-based repository (Versioned Storage) available by default. If an SVN type repository is selected, an additional Repository Folder option is available for specifying or browsing to an alternative target folder within the repository itself.\t\t\t\t\t\t\tThe\u00a0Repository drop-down menu only presents if you have upgraded your Enterprise Server from a version or server product where use of SVN repositories was enabled.\u00a0Alternatively,\u00a0the Enterprise Server provides a single Git-based design repository for accommodating all of your Workspace design projects, and the\u00a0Repository drop-down menu will not present in this case.\t\t\t\t\t\tSVN is not supported in the Altium On-Prem Enterprise Server starting from version 7.2. To avoid limitations of managing an SVN project, it is recommended that SVN projects be migrated to the Enterprise Server Workspace&#039;s built-in Git repository. This can be done prior to upgrading the server as described here.\t\t\t\t\t\tFor more information about SVN retirement in the Altium On-Prem Enterprise Server, refer to the\u00a0SVN Discontinuation with Altium On-Prem Enterprise Server 7.2.1\u00a0Knowledge Base article.\t\t\t\t\t\t\t\t\tClick the Advanced control to specify folder paths.\t\t\t\t\t\t\t\t\t\t\tUse the Folder field to specify where the folder for the project \u2013 within the Workspace&#039;s folder structure \u2013 is to be created. The default path for new projects is specified on the Admin \u2013 Settings \u2013 Projects page of the Workspace&#039;s browser interface (by default, this will be Projects\\). Click the  button to browse to and select a different Workspace folder, if required.\t\t\t\t\t\t\t\t\tIf the user that creates a project in the connected\u00a0Workspace\u00a0does not have write permissions to the default project folder,\u00a0the system will automatically create a user-specific\u00a0Personal Folder\u00a0structure for storing the new project. This appears as a top-level folder based on the member\u2019s email address (for an Altium 365 Workspace) or username (for an Enterprise Server Workspace), with a\u00a0My Projects\u00a0sub-folder that stores that user\u2019s projects. The folder structure\/hierarchy is available only to the signed-in user and administrators \u2013 it is not visible to other users. Learn more about\u00a0Managing Project Creation Permissions\u00a0(Altium 365 Workspace, Enterprise Server Workspace).\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tUse the Local Storage field to specify where the local version of the project will be stored on your hard drive. The default location is defined on the System \u2013 Default Locations page of the Preferences dialog. Click the  button to browse to and select a different folder location, if required. This is the &#039;working&#039; folder for the project and the local Git repository it is committed to. The project is ultimately, or at the time of committal, pushed to the centralized design repository in the Workspace (Versioned Storage), which is the remote Git repository.\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\tUse the Parameters list area to add or remove custom Name\/Value parameter pairs that are associated with the project and saved in the Workspace. Use the  button to add a new parameter Name-Value pairing to the list or the\u00a0 button to remove a selected pairing. The Name and Value fields allow a maximum of 255 characters. When creating a Workspace project, these Workspace project parameters are saved in the Workspace with the new project as Workspace-side project-level parameters.\t\t\t\tWhen a\u00a0project template is selected in the Project Type list of the dialog, the\u00a0Parameters list area will be loaded with parameters from this template. If required, you can\u00a0change these parameters (names and\/or values) or remove them. When creating a Workspace project, a parameter from the selected template will be saved as a design-side project-level parameter if the parameter name has not been changed. Otherwise, it will be saved as a Workspace-side project-level parameter.\t\t\t\t\t\t\tWorkspace-side project-level parameters can be edited within the Workspace. By contrast, design-side parameters are saved in the project file (*.PrjPcb), and can be edited in Altium Designer. Project-level parameters of both types can be viewed on the Parameters tab of the Project Options dialog (Project \u00bb Project Options) and may be used as Special Strings in Altium Designer.\t\t\t\t\t\tWith the project defined as required, click the  button. The new project structure will be created in the specified local and Workspace folders. The project will be opened in the Projects panel, which will reflect the fully synchronized state that exists between the files in the remote design repository (in the Workspace) and the local (working copy) repository \u2013 as indicated by the associated  icons. If created with the Version Control option unchecked (available in an Altium 365 Workspace only), the mirrored project will be shown in the Projects panel with an associated  icon. The newly created project committed to the Versioned Storage design repository in the Workspace.Alternatively, if the new project has not been assigned a template with constituent documents, the project file (*.PrjPcb) and therefore, the structure of the project only will be created. The project is then opened in the Projects panel, which will show it as being Scheduled for addition, denoted by the associated  icon. At this point you can add documents to the project, or simply save the structure to the Workspace in its current shell state. To do so, click the Save to Server control associated with the project entry in the Projects panel \u2013 also available from the right-click context menu, and from the main File menu. In the following Save to Server dialog, select\/deselect files for inclusion, add an optional Comment, and then confirm the save process with the  button. Once the project is added to the server, the Projects panel will reflect the fully synchronized state that exists between the files in the server repository and the local working copy, as indicated by the  icons.\t\t\t\t\t\tThe project will appear in the Projects panel under an entry for the target Workspace, reflecting the name of that Workspace.\t\t\t\t\t\t\t\t\t\tIn addition, an entry for the project will appear on the Projects page of the Workspace&#039;s browser interface.\t\t\t\t\t\t\t\t\t\tThe project will initially be shared for Read\/Write access with the designer who created it (Owner), and all Administrators for the Workspace.\t\t\t\t\t\tSee Sharing a Design for more information on configuring project access permissions.\t\t\t\t\t\t\t\t\t\tA new project also can be created directly in a Workspace through its browser interface on the designs page (select Projects), and subsequently opened for editing and addition in Altium Designer.\t\t\t\t\t\t\t\t\t\tAlong with the project file (*.PrjPcb), the project structure file (*.PrjPCBStructure) is created. This file\u00a0contains information about the project hierarchy\u00a0whether it is flat or hierarchical. This file is regenerated upon the dynamic compilation of the project (when a project document opens).\t\t\t\t\t\t\t\t\t\tThe Create Project dialog can also be accessed by right-clicking\u00a0on the Workspace entry within the\u00a0Projects\u00a0panel\u00a0and choosing the\u00a0Create Project\u00a0command from the menu.\t\t\t\t\t\tCopying a ProjectTo copy a Workspace\u00a0project from within Altium Designer, right-click on the entry for the project in the Projects panel and choose the Make a copy\u00a0command from the context menu. Use the Create Project Copy dialog to determine the Project Name (by default, this will be\u00a0the original project name with the suffix - Copy), Description (which is not pre-populated), the Folder path (within the Workspace), and the Local Storage path (to the working copy).\tNo special permissions are required to copy a project. The copied project is an exact copy of the original Workspace\u00a0project and has the same editing properties with no restrictions, i.e., you cannot create a &#039;read-only&#039; project. Also note that the copied project will be made in the same design repository as the original, i.e. you cannot change this as part of the copying process.\t\tThe Workspace Folder will, by default, be the same folder in which the original project is stored. Click  to open the Choose Folder dialog (a trimmed-down version of the Explorer panel) to change folder as required. The Local Storage will, by default, be set to use the\u00a0location defined on the System - Default Locations page of the Preferences dialog.\u00a0Click  to open a standard Windows dialog with which to change this location as required.\tCopy a Workspace\u00a0project from within Altium Designer.\tEach time you copy the project, a\u00a0Project Copied\u00a0event tile will be added to the timeline of the copied project&#039;s history. Also, the Project Created tile of the project copy will include a\u00a0link to the original project. Learn more about\u00a0Project History.\tYou can copy an existing Workspace project from the Open Project dialog. Select the project within your connected Workspace, then click on the Open Project As Copy\u00a0control\u00a0at the bottom of the right-hand Information pane. In addition, when browsing the project through Altium Designer&#039;s Explorer panel \u2013 configured in its default Project View rather than Classic View \u2013 the project can be copied by clicking the\u00a0Copy button\u00a0at the top-right of the panel.\tYou can only copy a Workspace project that has been opened from the currently connected Altium Workspace. If Altium Designer is not currently connected to the project&#039;s Workspace, or the project is not a Workspace project, the Make a copy command will not be available in the right-click menu.Adding and Removing\u00a0a Design DocumentOnce a project is established design documents can be added, edited or removed from the active project. The simplest way to add new design documents to a project is to right-click on the project name in the Projects panel and select Add New to Project from the context menu options. Alternatively, choose the required document type from the Project \u00bb Add New to Project sub-menu of the main menus to add a new document to the active project.\t\t\t\t\t\tIf the chosen document type can have defaults specified on the Data Management - Templates of the Preferences dialog, the chosen document type will be created using that default as a template.\t\t\t\t\t\t\tThe document is initially unsaved.\t\t\t\tAdd a specific or another type of document to a project.Other types of project-relevant documents can also be added to a project, such as text files, PDFs, spreadsheets, etc. To do so, use the Add Existing to Project option (or the Project \u00bb Add Existing to Project command from the main menu of the active document&#039;s editor) and set the File Type drop-down list in the Choose Document to Add browser dialog to All Files (*.*) so all file types can be accessed.\tDesign projects are not limited to only containing files that have been created by Altium Designer - just about any document can be included in a project. When the document is accessed from within Altium Designer, the system will attempt to determine the corresponding authoring\/viewing tool based on the file&#039;s extension and settings in the Windows registry. Assuming a match can be found, Altium Designer will then launch the associated editor,\u00a0either within its own editing environment\u00a0or as a separate application. This means that you can include all manner of test, documentation, background, and specification documents with your design projects, and have the confidence that wherever the design project goes, all the supporting documentation will travel with it.\tWhen adding existing documents to an Altium 365 Workspace project, note that there is a limitation for zip, 7z and rar files larger than 256 MB. Projects containing such files cannot be saved to the Workspace\u00a0\u2013 you will receive a Git Error. Refer to the\u00a0How to fix project data after Git Error with status code 471\u00a0Knowledge Base article to learn how to fix this issue.To remove a document from the project structure, right-click on its name in the Projects panel and select the Remove from Project menu option or choose the Project \u00bb Exclude from Project command from the main menus. You will be prompted to choose:\t\t\tDelete File \u2013 to permanently remove the source document file itself.\t\t\t\tExclude from Project \u2013 to remove the project&#039;s link to that document (and not delete the source document file itself). If it is currently open in the design editor window, it will be removed from its parent project but remain open in the panel as a free document. If, however, it is not currently open in the design space, removal will effectively close it.\t\t\t\t\t\t\t\tYou can also remove all documents within the focused category (sub-folder) from their parent project by right-clicking on the entry for the required category and choosing the Remove All command, from the context menu.Removing\u00a0a ProjectFor local projects, removing a project is a case of deleting files from your hard drive. Open the project folder in Windows Explorer and delete its content.\tTo quickly open an instance of Windows Explorer at the location where the\u00a0project is stored, right-click the project&#039;s entry in the\u00a0Projects\u00a0panel and select the\u00a0Explore\u00a0command.For Workspace projects (and other Workspace content such as components and released data), flexible functionality is available for removing\u00a0directly from within Altium Designer, from the Explorer panel. Operating as a &#039;soft delete&#039;, the removal process provides increased options and information as you proceed, including relevant links to source items for review purposes. In the Workspace, deleted content is\u00a0moved to a dedicated Trash location, where it can be retrieved or completely removed from the Trash page of the Workspace&#039;s browser interface.\tFor a Project, only the owner or an administrator can permanently delete or restore from the Trash.To soft-delete a Workspace project, navigate to the project folder in the Explorer panel, right-click its entry and select the Delete Folder command from the context menu. Confirm the deletion in the Confirm Delete dialog that appears. If the project contains released data, another confirmation dialog will open, notifying you about the fact that this data will be deleted as well. Click Delete to proceed.\tTo quickly open the Explorer panel with the project folder selected,\u00a0right-click the project&#039;s entry in the\u00a0Projects\u00a0panel and select the\u00a0Show in Explorer\u00a0command.\tSoft delete in action. Here, a project is being deleted, along with its related release (if manufacturing packages had been created from any releases, those would also be deleted).","tags":"","url":"altium-designer\/24\/documentation-altium-designer-creating-projects-documents.html"},
{"title":"Making an Existing Project Available in the Workspace","text":"The recommended and most powerful method to work with projects is to create a new project directly within the connected Workspace. If you have an existing project, you can bring it into your Workspace by making it available online and opting to enable formal version control. In each case, the project will be stored and managed through the Workspace\u2019s native Version Control System (VCS). This gives you the full functionality for a project when working with it through Altium Designer. Having your project under full management\u00a0of\u00a0the Workspace&#039;s VCS is the only way to share that project with multiple people for editing through Altium Designer (provided they are members of the Workspace) and benefit from the platform&#039;s additional features such as History tracking and advanced project Sharing.A local project that is not under version control or is under external version control can be registered with your Workspace using a methodology called\u00a0Simple Sync. A mirror of your project is created in the Workspace and synchronized. Once local file changes are saved (or saved and committed to the external design repository), those changes are automatically synchronized with their mirrored project counterparts in the Workspace. Simple Sync allows you to enjoy the collaborative features available through the Altium 365 platform while keeping your original project right where it is. However, bear in mind that for a local design project (not under external VCS), that project can be edited by a single person only (the owner of that project \u2013 the one who made it available online to the Workspace).To make an existing project (a local project or a project currently under external version control) available to the Workspace \u2013 either as a project mirrored (Simple Sync) in an Altium 365 Workspace or one under a Workspace&#039;s native Git Version Control, open the project as normal in Altium Designer, then right-click on its entry in the Projects panel and select Make Project Available Online from the context menu, giving access to the Make Available Online dialog. When using an Enterprise Server Workspace, the Make Project Available on Server command opens the Make Available On Server dialog.When connected to a Workspace with one or more active process definitions for the Project Creations process theme,\u00a0making\u00a0an existing project available to the Workspace is performed by right-clicking the project\u00a0entry in the Projects panel and selecting a\u00a0command\u00a0from the\u00a0Convert to Managed Project\u00a0sub-menu \u2013 learn more about\u00a0Process-based Project Converting.Make an existing local project available to the Workspace, essentially &#039;registering&#039; it with the Workspace and creating a &#039;mirror&#039; of it.    Options and Controls of the Make Available Online Dialog    \tProject Name \u2013 the name of the project in the Workspace. By default, the name will be that of the original project.\tDescription \u2013 enter the desired description of the project.\tVersion Control \u2013 check this option to add a\u00a0local project to\u00a0the Workspace&#039;s own built-in VCS (Git). If this option is unchecked, the project files will simply be stored in the Workspace for basic access and to enable sharing with others for viewing and commenting only \u2013 a less formal Simple Sync as it were. It is recommended to enable formal version control, as by doing so you will have access to the maximum functionality offered through, and by, the Workspace and the Altium 365 platform. This option is available only if the project is currently not under version control.\tMigrate to Altium 365 Versioned Storage \u2013 enable this option to migrate a project that uses an external VCS to a project under full management of the Workspace&#039;s VCS. Such a project can then benefit from the Workspace&#039;s native VCS features. This option is available only if the project is currently under an external VCS.\tAdvanced \u2013 click to access an additional\u00a0option.\t\t\tFolder \u2013 this field is used to specify where the folder for the project being migrated \u2013 within the Workspace&#039;s folder structure \u2013 is to be created. The default path for new projects is specified on the Admin \u2013 Settings \u2013 Projects page of the Workspace&#039;s browser interface (by default, this will be Projects\\). Click  to open the Choose Folder dialog, which is a trimmed-down version of the Explorer panel, from where you can browse and select a different server folder\u00a0if required.\t\t    Options and Controls of the Make Available On Server Dialog    \tProject Name \u2013 the name of the project in the Workspace. By default, the name will be that of the original project.\tDescription \u2013 enter the desired description of the project.\tMigrate to Altium Versioned Storage \u2013 enable this option to migrate a project that uses an external VCS to a project under full management of the Workspace&#039;s VCS. Such a project can then benefit from the Workspace&#039;s native VCS features. This option is available only if the project is currently under an external VCS.\tAdvanced \u2013 click to access additional\u00a0options.\t\t\t\t\tRepository Folder \u2013 this field is used to specify where the folder for the project being migrated \u2013 within the Workspace&#039;s repository structure \u2013 is to be created. Click  to open the Add to Version Control dialog from where you can navigate to and create the required folder structure within the repository.\t\tThe Repository Folder option is available only when migrating a regular project (not a project under external VCS) and\u00a0if the use of SVN repositories is enabled for your Enterprise Server Workspace. To learn more, see Local Version Control Service.\t\t\t\tFolder \u2013 this field is used to specify where the folder for the project being migrated \u2013 within the Workspace&#039;s folder structure \u2013 is to be created. The default path for new projects is specified on the Admin \u2013 Settings \u2013 Projects page of the Workspace&#039;s browser interface (by default, this will be Projects\\). Click  to open the Choose Folder dialog, which is a trimmed-down version of the Explorer panel, from where you can browse and select a different Workspace folder if required.\t\tUse the Make Available Online dialog to change the project Name and add a Description. By default, the name will be that of the original project.Check the Version Control option to add the project under the Workspace&#039;s own built-in VCS (Git). When this option is unchecked (an Altium 365 Workspace option only), the project files will simply be stored in the Workspace for basic access and to enable sharing with others for viewing and commenting only \u2013 the Simple Sync arrangement. It is recommended to enable version control, as by doing so you will have access to the maximum functionality offered through, and by, the Workspace and the Altium 365 platform. Note that ability to mirror a project in a Workspace (Simple Sync) is available only when connected to an Altium 365 Workspace.If the local project is already under version control (an external design repository), the Migrate to Altium 365 Versioned Storage option will be available in the Make Available Online dialog. Learn more about\u00a0 Moving from External VCS to Workspace Native VCS.Project Sharing in an Altium 365 Workspace:If the Version Control option is disabled \u2013 thereby using the informal Simple Sync feature for a local\u00a0project (that is not under external VCS) \u2013 the design project can be edited by a single person only (the owner of that project, who is the one that made it available in the Workspace). The strength of Simple Sync comes when you do not want anyone else editing your design, but where you do want to take advantage of Altium 365&#039;s Global Sharing paradigm and be able to share that design with multiple other people for viewing and commenting.When the Version Control option is enabled \u2013 through the use of the Workspace&#039;s Versioned Storage Git-based design repository \u2013 then multiple people can be shared the project for editing, or for viewing and commenting.Click the dialog&#039;s Advanced link to expose the Folder field. This field is used to specify where the folder for the mirrored project \u2013 within the Workspace&#039;s folder structure \u2013 is to be created. The default path for new projects is specified on the Admin \u2013 Settings \u2013 Projects page of the Workspace&#039;s browser interface (by default, this will be Projects\\). Click the  button to browse and select a different Workspace folder, if required.With the properties for the project transition defined as required in the Make Available Online dialog, click OK.\u00a0For a project that is not under external version control and when made available online (in an Altium 365 Workspace, the Version Control\u00a0option was checked), the project and files will be committed and pushed to the Workspace&#039;s Versioned Storage design repository. The Projects panel will then reflect the fully synchronized state that exists between the Workspace design repository and the local (working copy) repository, as indicated by the associated  icons. The project becomes a true Workspace project \u2013 not just &#039;registered&#039; in the Workspace, but actually committed and under the Workspace&#039;s version control. Any changes made to the design must be saved (committed\/pushed) back to the repository in the Workspace.The\u00a0project made available in the Workspace will subsequently be available from the\u00a0Projects\u00a0page of the Workspace&#039;s browser interface.The project made available in the Workspace\u00a0will initially be shared for Read\/Write access with the designer who created it (Owner), and all Administrators for the Workspace. For more information on configuring project access permissions, see Sharing a Design.Limitations when using an Existing External Version Control RepositoryAs mentioned previously, your local designs may already be tracked under an existing, external version control system (Git, SVN, EPDM, etc...). When using an Altium 365 Workspace, you can continue using this setup as before and simply make the designs available to your Workspace by registering them with that Workspace \u2013 using the Make Project Available Online feature.In this mode, every time you make changes to a design and commit those changes to your external VCS repository, that design data will be mirrored to the Workspace in the background, and all needed processing will be performed as usual \u2013 preview, where used, etc. There are some limitations to be aware of, however:\tCreation of a new design project still has to follow the previous flow, i.e.\u00a0it is manually created in the external VCS system. The project is then registered and mirrored to the Workspace using the Make Project Available Online feature.\tIf design changes are made but the commit\/push is performed by external tools rather than through Altium Designer, then those changes will not appear for the mirrored project in the Workspace. This is corrected when the project is next reopened in Altium Designer, which automatically synchronizes the local project with the mirrored Workspace version. If the changes were made by another user, then the reopened project file(s) will show as Out Of Date () and can be corrected using the version control Update command.\tOpening of the project by a second person will require access to that external VCS repository.\tRights management will have to be set up\/maintained in two places \u2013 in the Workspace and in the master source (the external Git\/SVN\/etc VCS repository).\tSome features delivered through the Altium 365 platform work only by having a project under the Workspace&#039;s native version control system. By keeping your project under an external version control system such features, as they become available to the platform, will not be available to you. You can move from using your external VCS to the Workspace&#039;s native VCS \u2013 see the following section for the procedure to achieve this.Working with GitHubUsing the GitHub platform as an external version control system (VCS) is a popular way to host and share design projects, and Git repositories are supported by Altium Designer. As described above for an Altium 365 Workspace, the existing external VCS arrangement can be synchronized with (mirrored to) the Workspace, which allows you to benefit from its advanced data management and collaboration features.How you normally work with GitHub itself will vary depending on company practices or simply the Git tools you have at hand. In general, however, a design project is created in a local Git repository and then Pushed to a GitHub (remote) repository, or an existing project is Cloned to a local repository from GitHub. Once in the local Git repository, the project can be opened in Altium Designer for editing \u2013 the software will recognize and use the local\/remote GitHub repositories.If the Git-based project is mirrored to an Altium 365 Workspace (Make Project Available Online), the project can be managed and worked within Altium Designer like any other project stored in the Workspace. In this arrangement, the Workspace still provides all the advantages of its project management system and also transparently communicates with GitHub to perform the major VCS actions \u2013 commit, push, pull, etc. Altium Designer will request your GitHub login credentials and retain these for subsequent GitHub interaction.Note that Altium Designer is not able to connect with GitHub automatically if the GitHub account has been configured for two-factor authentication.GitHub ProtocolsWhile there is a range of data transfer protocols offered by the Git VCS, Altium Designer currently supports the HTTP\/HTTPS protocol only for connections between a local Git repository and its remote master repository. In practice, the applied protocol is set by the URL prefix specified for the remote repository connection \u2013 https:\/\/, ssh:\/\/, git:\/\/, and so on.GitHub supports both the SSH and HTTPS protocols and recommends using HTTPS URLs for connections.\u25ba See Which remote URL should I use? on GitHub for more information.The HTTPS protocol offers the advantage of a secure connection that is simple to use and implement, whereas SSH is more complex to deal with \u2013 due to the need for public keys, and firewall\/proxy port requirements \u2013 is arguably less secure, and does not provide the convenience of SSO (single sign-on) authentication.Similarly, the GIT connection protocol is not recommended (or supported here) due to its lack of authentication and setup complexity.If your external VCS system is bound to a protocol other than HTTPS, such as a GitHub SSH connection, this will be preset in a repository that has been cloned from the remote. As this protocol is incompatible with Altium Designer, an error will be thrown when attempting to integrate the project with an Altium Workspace. For the SSH connection, you will be offered to try to have that repository updated to use the supported HTTPS connection protocol instead (provided the repository itself supports this protocol).\u00a0If you are unsure of the remote URL protocol that is used for a local Git repository, this can be checked using the git remote \u2013 v command.Use the Git Bash command line interface to check a repository&#039;s remote URL setting. The repository can be reconfigured for a different URL, such as the HTTPS protocol to enable compatibility with Altium Designer, by using the git remote set-url   command, where the URL&#039;s prefix specifies the protocol type.Changing the remote repository connection URL protocol and then confirming with the remote command.Moving from External VCS to Workspace Native VCSWhen connected to an Altium 365 Workspace, Altium Designer also offers the ability to faithfully migrate projects that use an external VCS system to a fully-managed Workspace project that hosts the design files in its own Git repository. The converted design project, which will retain the previous history of VCS commits, can then benefit from the Workspace&#039;s native VCS-enabled features, such advanced project sharing, single authentication, and the event-based History timeline.The project VCS migration feature supports both Git and SVN external version control systems and is available when making a local file-based project available online, or when promoting a mirrored (synchronized only) project to one under the Workspace&#039;s own Git VCS.To simply migrate a project that is stored under external version control, right-click on the project name in the Projects panel and choose the Make Project Available Online option from the context menu, or select Project \u00bb Make Available Online from the main menu. In the following Make Available Online dialog, check the Migrate to Altium 365 Versioned Storage option and confirm the operation (OK).The enabled Migrate to Altium 365 Versioned Storage option effectively causes the external VCS repository to be replaced with the Workspace Git repository, converts the project to one stored and managed in the Altium 365 Workspace, and where possible, brings across the version commit history from the external VCS. Note that If the migrate option is left unchecked, the project is mirrored to the Workspace (the Simple Sync arrangement) while maintaining the external repository as its VCS storage.VCS migration is also available when Altium Designer is connected to an Enterprise Server Workspace. In this case, the Migrate to Altium Versioned Storage option is available in the Make Available On Server dialog.\u00a0Note that If the migrate option is left unchecked, the project&#039;s\u00a0external repository is maintained as its VCS storage\u00a0(the\u00a0Simple Sync arrangement is not supported for an Enterprise Server Workspace).To port a local VCS project to a fully managed VCS project in your Altium 365 Workspace check the VCS migrate option when making it available online.The\u00a0Migrate Project\u00a0dialog will open\u00a0and warn\u00a0you that the project is going to be migrated under full management of the Workspace&#039;s VCS. Click the\u00a0Browse\u00a0button to select a folder on your hard drive where a new (git-based) local project repository will be created. Click the\u00a0Migrate\u00a0button to proceed with the migration. The Migrate Project dialogAfter following the prompts, which includes making a final VCS commit, the project is now under version control in the Workspace Git repository. The external VCS commit history and its comment\/messages are ported to the new Workspace VCS project, which can be accessed in the Altium Designer History view \u2013 right-click on the project name in the Projects panel and select the History &amp; Version Control \u00bb Show Project History command.When migrated, the project&#039;s external VCS commit history (shown on the left) is transferred to the Altium Designer History view (right).Note that the first time you open Project History after the migration process you may see that data is being calculated for all included commits. The Workspace needs some time to process these commits and also the differences between them.If the external VCS project is already managed in the Altium 365 Workspace as a mirrored project (synchronized local-server files), its VCS files can be migrated to the server&#039;s native Git repository using the Migrate to Altium Versioned Storage command, which is available from the Project History view, the Project Options dialog\u00a0or the Projects panel&#039;s History &amp; Version Control right-click context menu.\u00a0A VCS project that has been synchronized with (mirrored to) your Workspace is migrated using the Migrate Project to Altium Version Control option.The migration performance is fastest when the source external VCS is Git-based \u2013 the process is simpler because the Altium 365 Workspace VCS is also Git-based. For SVN however, the migration can take some time depending on the size of the repository and the number of commits it contains.VCS Migration limitations\tGit\t\t\tGit repositories that contain multiple PCB projects are supported when connected to an Altium 365 Workspace. After clicking OK in the Make Available Online dialog, you will be prompted to choose the files to migrate.\t\tThe project file (*.PrjPcb) should be located in the Git repository&#039;s root folder.\t\t\tSVN\t\t\tThe basic SVN File protocol is not supported.\t\tIf your SVN repository contains multiple projects, the migration process will create new local folders in addition to the existing SVN working copy. This is because the Altium 365 Workspace storage is Git-based, and a Git repository cannot be stored inside the SVN working copy.\t\tCommits that include an external file relative to the project folder may not be shown, since the migration process recognizes commits to the project folder only.\t\tAfter\u00a0successful migration of an external VCS project to the Altium 365 Workspace, the link to the external repository is removed automatically. This feature has been implemented in Altium Designer 23.0. If the project has been made available in the Altium 365 Workspace using a previous version of Altium Designer, an entry for the repository can appear on the Data Management - Design Repositories page of the Preferences dialog. If you are an administrator of the Workspace, and the repository has\u00a0no reference to a Workspace project, the repository can be removed from the Workspace by selecting its entry and clicking the Remove button. Note that if a project has been soft deleted (moved to Trash), it must be deleted permanently so the repository referencing it\u00a0can be removed. The Workspace&#039;s\u00a0Versioned Storage\u00a0repository cannot be removed.Collaboration after migration\tWhen a Workspace team member has migrated a project to Altium Versioned Storage, they need to ensure that other project collaborators connect to the team Workspace and then update their local (working) project copies. The latter is indicated in the Projects panel by the  icon (Out of Date) associated with the project file and actioned by the Project \u00bb History &amp; Version Control \u00bb Update Whole Project command.\tOnce the migrated project has been updated, Altium Designer will offer to update the links to the new repository by rebuilding the project&#039;s local working folder. Choose the recommended option in the Fix version control link dialog to finish the local project update.\tNote that if a project collaborator does not connect to the team Workspace and then commits VCS design changes, these will continue to be registered with the external repository and therefore out of sync with the migrated Workspace VCS project.\tDuring migration, Altium Designer executes a commit to the original repository to set a notification mark so it can be recognized as having been migrated by other team members&#039; instances of Altium Designer.    Manually migrating a project from External VCS to Workspace VCS    In some cases, it may be desirable to manually migrate a project that uses an external VCS repository to one that is fully managed on an Altium Workspace and its native Git VCS repository. This can be done by creating a snapshot of your project, which disconnects it from external VCS and from the Workspace (if already made available there), and then making it available to the Workspace again, but under the Workspace&#039;s VCS \u2013 starting afresh as it were. To do so, follow the procedure below:\tDisconnect (remove) your project from the external version control system. This can be performed from your external interface tool to your current VCS, or through Altium Designer. In the case of the latter, while there are commands to remove the project from version control in both the Projects panel and the Storage Manager panel, the cleanest way is to use the Project Packager. Using the Project Packager will create a snapshot of your project, without the baggage of version control and, if you have previously made the project available to the Workspace, it will strip the links to the project in the Workspace.\tIf you have already made the project available to the Workspace, you&#039;ll want to unlink it as part of the packaging process. To do so, in the Managed Projects region on the Zip File Options page of the Project Packager wizard, make sure to enable the option to Unlink project from the server during packaging. This will ensure the link information to the mirrored project in the Workspace \u2013 which resides within the project file (*.PrjPcb) \u2013 is removed as part of the packaging process.\t\tUnpack your &#039;cleaned&#039; project from the Zip archive created by the Project Packager.\tOpen the project in Altium Designer \u2013 notice that it is neither managed (if it was previously) nor under version control. It is therefore a clean, unmanaged project.\tThis next step is only if you had previously made the project available to the Workspace. The packaging process unlinked the project, but the mirrored project in the Workspace still remains untouched. You should delete the server-side project first. Access the Workspace&#039;s browser interface (through the Altium 365 Platform Interface). From the Projects page, click to select the project to be deleted, then click the  control and choose the Delete command from the context menu.\tShould you wish to keep the older version of the project in the Workspace, you should either rename it, or rename the fresh instance of the project when making it available online \u2013 whichever best suits your requirements.\t\tNow make the project available online again to the Workspace. To do this, right-click on its entry in the Projects panel and select Make Project Available Online from the context menu, giving access to the Make Available Online dialog. Make sure you enable the Enable Formal Version Control option, as this is what adds the project under the Workspace&#039;s own built-in VCS (Git).\tAs an alternative to the above step, the unpacked project snapshot (see step 2, above) can be directly uploaded to the Workspace using the New \u2013 Upload Project option available in the Projects view of the Workspace browser interface. The resulting created project, available for opening in Altium Designer, is fully managed by the Workspace and its native VCS repository.\tNote that the project essentially starts its history afresh \u2013 no previous version history is kept. By using the Project Packager, and taking a snapshot of your design at that point rather than removing the project from version control, you will retain the history of the previous VCS-linked project up to that point in time.Moving from the Workspace&#039;s SVN to the Workspace&#039;s GitWhen Altium Designer is connected to an Enterprise Server Workspace and a design project is stored in an SVN repository managed through the Workspace&#039;s\u00a0Version Control Service, you can migrate this project from the\u00a0SVN repository to the Workspace&#039;s built-in Git repository (Versioned Storage). To do this,\u00a0right-click its entry in the Projects panel and select the\u00a0History &amp; Version Control \u00bb\u00a0Migrate Project to Altium Versioned Storage\u00a0command\u00a0from the context menu. Alternatively, click the Migrate to Server Versioned Storage button in the Project Options dialog.After following the prompts, which include making a final VCS commit,\u00a0the project will be migrated to the version control of\u00a0the Workspace Git repository.Controlling Project SynchronizationOnce a local project has been made available to an Altium 365 Workspace, controls over its online availability and synchronization are provided through the General tab of the Project Options dialog.Note that the General tab is presented only when Altium Designer is connected to an Altium 365 Workspace, rather than an Enterprise Server Workspace.Note that the General tab is presented only when Altium NEXUS is connected to an Altium 365 Workspace, rather than a NEXUS Server Workspace.Options and controls relating to having made the project available online are presented on the General tab of the Project Options dialog.Use the option available in the General region of the tab to make changes to the project description. This affects the mirrored project within the Workspace only.In the Online Availability and Synchronization region of the tab, the Version Control option reflects the current style of online availability:\tOption Enabled \u2013 the project (and its source files) are stored under the Workspace&#039;s own native VCS (Git). This is the recommended approach, as by doing so you will have access to the maximum functionality offered through, and by, the Workspace and the Altium 365 platform.\tOption Disabled \u2013 the project files are stored in the Workspace for basic access and to enable sharing with others for viewing and commenting only \u2013 the Simple Sync arrangement.Use the option to change between these two as desired.This option is not available if the project is stored under an external VCS repository.Should you wish to stop the synchronization between your local project, and the managed incarnation of it that was made available in the Workspace, click the  button. The Turn off project synchronization window will appear. Click on the Unlink option, then click OK back in the Project Options dialog. The local project will no longer be associated with the project in the Workspace.This is reflected in the Projects panel after saving the local project, by the project being presented under the active Project Group (*.DsnWrk), rather than as an entry under the active Workspace. A save is required since the links to the project in the Workspace are removed from the project file.The project in the Workspace remains untouched \u2013 it is not removed by this action.You can sever the connection between your local project and the incarnation of it made available in the Workspace.You can always make the local project available online again, as a mirrored or full VCS project (Version Control). The General tab of the Project Options dialog will present the  button, with which to access the Make Available Online dialog.If you are making a local project available online again after having turned off synchronization, you may need to change the project name. Since turning off synchronization does not remove the project in the Workspace, this project, with the same name and folder location, may still exist. If you need to have the same project name, then the previous project instance in the Workspace can always be removed.A local project can also be made available online \u2013 in the Workspace \u2013 from the General tab of the Project Options dialog.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-making-existing-project-available-workspace.html"},
{"title":"Mirroring a Project in the Workspace Using Simple Sync","text":"The recommended and most powerful method to work with projects is to create a new project directly within the connected Workspace or make an existing project available in the\u00a0Workspace\u00a0while opting to enable the Workspace&#039;s version control. In this case, the project will be stored and managed through the Workspace\u2019s native Version Control System (VCS).However, a new project or an existing project\u00a0that is not under version control or is under external version control can also be registered with your Workspace using a methodology called\u00a0Simple Sync. In this case, a\u00a0mirror of your project is created in the Workspace and synchronized.\u00a0The strength of Simple Sync comes when you do want to take advantage of Altium 365&#039;s Global Sharing paradigm and be able to share that design with multiple other people for viewing and commenting while keeping your original project right where it is. However, bear in mind that for a local design project (not under external VCS), that project can be edited by a single person only (the owner of that project \u2013 the one who created it or made it available to the Workspace).\tNote that the ability to mirror a project in a Workspace (Simple Sync) is available only when connected to an Altium 365 Workspace.\tNote that projects larger than 200 MB cannot be made available in\u00a0the Workspace using the Simple Sync feature.Mirroring a ProjectTo mirror a project in the connected Altium 365 Workspace using the Simple Sync arrangement, use the following approaches:\u00a0\t\tWhen creating a new project \u2013 disable the Version Control option in the Create Project dialog. When the project is created, its entry will be shown in the Projects panel with the  icon only.\u00a0Saved local files are automatically synchronized with their mirrored project counterparts in the Workspace.\t\t\t\tWhen making an existing project\u00a0that is not under external version control available in the Workspace \u2013 disable the\u00a0Version Control\u00a0option in the Make Available Online dialog. When the project is made available in the Workspace, its entry will be shown in the Projects panel with the  icon only.\u00a0Saved local files are automatically synchronized with their mirrored project counterparts in the Workspace.\t\t\t\tWhen making an existing project\u00a0that is under external version control available in the Workspace \u2013 disable the\u00a0Migrate to Altium 365 Versioned Storage\u00a0option in the Make Available Online dialog.\u00a0When the project is made available in the Workspace, its entry will be shown in the Projects panel with the  icon, along with the  icons associated with the project and its documents reflecting\u00a0the fully synchronized state that exists between the external design repository and the local working copy. Once local file changes are saved and committed\/pushed to the external design repository, those changes are automatically synchronized with their mirrored project counterparts in the Workspace.\t\t\tThe\u00a0\u00a0icon indicates the project as being registered with the Workspace, that a mirrored project exists, and that the two are synchronized using the Simple Sync methodology. For information on the various states used by Simple Sync, see Simple Sync States.\tThe mirrored project will subsequently be available from the\u00a0Projects\u00a0page of the Workspace&#039;s browser interface.\tThe mirrored project\u00a0will initially be shared for Read\/Write access with the designer who created it (Owner)\u00a0and all Administrators for the Workspace. For more information on configuring project access permissions, see Sharing a Design.Simple Sync StatesWhere a project is stored in an Altium 365 Workspace using the Simple Sync approach, the current state of the synchronization between local and Workspace-side projects is presented in the Projects panel through a range of icons. The icons, and their meaning, are as follows:\t\t\t\t\t\t \t\t\tSynchronized\t\t\tThe local project and the mirrored project in the Workspace are synchronized.\t\t\t\t\t\t\t \t\t\tSync-in-progress\t\t\t\t\t\tChanges made to the local project are being synchronized to the mirrored project in the Workspace. For a local project not under external VCS, this occurs when saving a local file. For a local project under external VCS, this occurs when saving and committing local file changes to the external design repository.\t\t\t\t\t\t\t\t\t\t \t\t\tProject is Read-only\t\t\t\t\t\tThe project has been shared with you, but you have Read-only access to it. Under the Simple Sync methodology, the design project can be edited by a single person only (the owner of that project \u2013 the one who made it available online to the Workspace).\t\t\t\t\t\t\t\t\t\t \t\t\tNot Synchronized\t\t\t\t\t\tChanges have been made locally, but these have not been synchronized yet with the mirrored project in the Workspace. This can happen, for example, when the same project is open for editing by the owner\/author on two computers (PC1 and PC2). On PC1, the Workspace is subsequently disconnected. On PC2, connection to the Workspace remains and changes are made. On saving the local file(s) the project remains unsynchronized. If you attempt to close the project on PC2, the Closing unsynchronized projects dialog will appear alerting you to this fact. If you choose to close the project, changes will not be available on PC1. To remedy the situation, disconnect from and then reconnect to, the Workspace on PC2. The project will be synchronized with the Workspace. The synchronized data will be reflected on PC1 once the Workspace is connected there too. Alternatively,\u00a0right-click on the project and choose the\u00a0Resolve Project Clone Conflict command.\u00a0The\u00a0Location of local projects has changed\u00a0dialog will open. You will have the option to register the existing project as a\u00a0New Project,\u00a0where\u00a0the data from the mirrored project in the Workspace will be used and local modifications will be lost,\u00a0Move Project, where the data from the local project will be used and synced to overwrite the current data for the mirrored project in the Workspace, or\u00a0Unregister, which unlinks the project and the data will not be sent to the Workspace.\t\t\t\t\t\t\t\t\t\t \t\t\tConflict\t\t\t\t\t\tThere is a conflict between the data for the local project and the data for the mirrored project in the Workspace. This can happen, for example, when the same project is opened for editing by the owner\/author on two computers (PC1 and PC2). On PC1, the project is opened and the Workspace is subsequently disconnected. Changes are then made and local files saved. Later, on PC2, the same project is opened and, while still connected to the Workspace, changes are made and saved. Later still, connection is made to the Workspace back on PC1. A conflict exists because there are changes locally on PC1, but the Workspace contains the updated data from changes made and synced on PC2.\t\t\tTo remedy the situation, on PC1 right-click on the project and choose the Resolve Conflicts command. The Resolve Conflicts dialog will open. You have the option to Use Server files (the data from the mirrored project in the Workspace will be used and local modifications will be lost), or Use Local files (the data from the local project will be used and synced to overwrite the current data for the mirrored project in the Workspace).","tags":"","url":"altium-designer\/24\/documentation-altium-designer-simple-sync.html"},
{"title":"Opening Projects and Documents","text":"To work on a project in Altium Designer, it should be opened first.\u00a0This is performed directly from within Altium Designer using the Open Project dialog accessed by selecting the\u00a0File \u00bb Open Project command from the main menus.\u00a0The\u00a0Open Project\u00a0dialog provides a single location to open, search for and browse projects.Opening a Project Using the Open Project DialogOpening a Workspace ProjectTo work on a Workspace project, you effectively check it out as a local working copy. What happens once the File \u00bb Open Project command is selected\u00a0depends on whether you are a member of the Workspace team\u00a0or have been shared a project outside of the Workspace team.Workspace Team MemberThe Open Project dialog will open in which\u00a0you can choose which Workspace project to open from your connected Workspace (when connected to a Workspace, that Workspace will appear in the Locations region of the dialog, distinguished by the  icon, and appear\u00a0with the name given to the Workspace). Only those Workspace projects that have been shared with you (you have permission to access them) will be listed.\tThe\u00a0Open Project\u00a0dialog when the Workspace location is selectedFor each project in the list, the following information is\u00a0presented:\t\t\tName \u2013 the name of the project; the location path of the project appears below the name.\t\t\t\tLast Modified \u2013 the date and time the project was last modified. The date and time display in accordance with your personal computer settings. To configure each project&#039;s modification dates and times in a specific format, you can do so in your computer&#039;s system Region settings.\t\t\t\t\t\t\tThe Name and Last Modified columns can be sorted in ascending or descending order by clicking (and toggling) the header for each column.\t\t\tTo view and navigate through the project folder hierarchy, select the folder view button () to access project folders and the breadcrumb path in the dialog\u2019s Search bar.\tThe project list view in the dialog. Hover the cursor over the image to see the folder structure view.\tWhen the folder view is enabled in the dialog and if you have projects located in a folder, a folder entry () will appear, which you can double-click to view the existing projects located within.When  is clicked, the right-hand side of the dialog displays additional details about the selected project, including the basic project information (the General tab of the details pane) and all project Parameters (the Parameters tab of the details pane).Once opened by clicking the Open button, the project will appear under an entry for the Workspace, in the Projects panel.\tChoose which Workspace project to open from your connected Workspace\u00a0within Altium Designer\u00a0from those currently shared with you.\t\t\t\t\t\tYou have the option to open the project to the default checkout path or use the  drop-down menu to specify a custom path. The default checkout path is defined as a property of the design repository in which the project resides. For a Git repository (e.g. the Versioned Storage repository that is native to the Workspace), this is the Local Path field found in the Git Repository dialog. For an SVN repository, this is the Default Checkout Path field found in the SVN Design Repository dialog. Access the properties dialog by selecting the entry for the repository on the Data Management \u2013 Design Repositories page of the Preferences dialog\u00a0then\u00a0clicking the  button.\t\t\t\t\t\t\tChoose the Open Project As Copy option to create a cloned version of the project under a different name. Learn more about\u00a0Cloning a Project.\t\t\t\tWhen accessing the Altium 365 location of the Open Project dialog before signing in to your Altium account, connecting to a Workspace or activating a Workspace,\u00a0the right-hand side of the dialog will\u00a0display\u00a0the relevant text and controls.\tInvited Stakeholder Outside of the Workspace TeamThe Open Project dialog will open in which\u00a0you can access any Workspace project that has been shared with you from the Shared With Me location.\tThe\u00a0Open Project\u00a0dialog when the Shared With Me location is selectedFor each project in the list, the following information is presented:\t\t\tName \u2013 the name of the project.\t\t\t\tCreated By \u2013 the name of the person who created the project.\t\t\t\tLast Modified \u2013 the date and time the project was last modified. The date and time display in accordance with your personal computer&#039;s settings. To configure each project&#039;s modification dates and times in a specific format, you can do so in your computer&#039;s system Region settings.\t\t\t\t\t\t\tThe Name and Last Modified columns can be sorted in ascending or descending order by clicking (and toggling) the header for each column.\t\t\tOnce opened by clicking the Open button, the selected project will appear under the entry Shared with me, in the Projects panel. What you can do with the project depends on the access rights you have been given to it. If editing rights were assigned to you, you will be able to edit the design normally, which would typically be the case for an external contractor. If you have viewing rights only, you will be able to comment on the WIP design.\tThe projects that are available under Shared With Me are those that have been shared with your sign-in name (your Altium account) from an Altium 365 Workspace. Note that Altium Designer does not need to be connected to a Workspace to access shared projects.\tChoose which Workspace project to open, from within Altium Designer, from those currently shared with you as an external stakeholder. Note that access is made to such projects without having access to the Workspace.\tYou have the option to open the project to the default checkout path or use the  drop-down menu to specify a custom path. The default checkout path is taken from the Document Path field on the System \u2013 Default Locations page of the Preferences dialog.\tWhen an updated project file name has been synchronized to the Workspace, the Workspace automatically changes the Workspace project&#039;s Name parameter to match. Conversely, when the name of a Workspace project is updated in the Workspace (via the Edit mode on the Workspace Projects page or the design client&#039;s Explorer panel), the change is propagated to the client-side when the project is next opened. When the updated project is opened (File \u00bb Open Project), the Name of the project and project file name are different dialog will open, providing the option to align the project file name with the new project Name, force the project Name to match the existing project file name, or allow the two names to be different.\tOpening a Local ProjectSelect the\u00a0Local Projects\u00a0location to see the\u00a0list of projects stored in the current default location as specified in the System \u2013 Default Locations page\u00a0of the Preferences dialog.\tThe\u00a0Open Project\u00a0dialog when the Local Projects location is selectedFor each project in the list, the following information is presented:\t\t\tName \u2013 the name of the project; the location path of the project appears below the name. You may double-click the folder icon () to view the existing contents located within.\t\t\t\tLast Modified \u2013 the date and time the project was last modified. The date and time display in accordance with your personal computer&#039;s settings. To configure each project&#039;s modification dates and times in a specific format, you can do so in your computer&#039;s system Region settings.\t\t\t\t\t\t\tThe Name and Last Modified columns can be sorted in ascending or descending order by clicking (and toggling) the header for each column.\t\t\tWhen  is clicked, the right-hand side of the dialog displays the name, last modified date\/time and location of the project currently selected in the list.Once opened by clicking the Open button, the selected project will appear in the Projects panel.Click the Browse\u00a0button at the bottom left of the Open Project dialog to browse to and open a project through the Windows\u00a0Open\u00a0dialog.Opening a Recent ProjectSelect the\u00a0Recent\u00a0location to see the\u00a0list of recently opened projects from local or Workspace sources.\tThe\u00a0Open Project\u00a0dialog when the Local Projects location is selectedFor each project in the list, the following information is presented:\t\t\tName \u2013 the name of the project; the location path of the project appears below the name.\t\t\t\tLast Modified \u2013 the date and time the project was last modified. The date and time display in accordance with your personal computer&#039;s settings. To configure each project&#039;s modification dates and times in a specific format, you can do so in your computer&#039;s system Region settings.\t\t\t\t\t\t\tThe Name and Last Modified columns can be sorted in ascending or descending order by clicking (and toggling) the header for each column.\t\t\tWhen  is clicked, the right-hand side of the dialog displays the name, last modified date\/time and location of the project currently selected in the list.\tRecent projects, documents\u00a0and project groups can also be opened through the File main menu: learn more.Searching for a ProjectUse the Search field at the top of the Open Project dialog to filter the project list by entering alpha\/numeric characters. When opening Workspace projects, the Search filter will also respond to Parameters\/Value pairs available from Workspace projects. These include Project and Workspace parameters, and the Analytics parameters generated by the Workspace.\t    Workspace parameter-based searches    The Workspace project search will return a list of projects based on simple or specific search strings. Parameter Value searches are case-insensitive, whereas Parameter names are referred to in full and are case-sensitive. A space in the search string indicates a boolean AND, and quoted (literal) searches are valid.\t\t\t\t\t\t\tEnter abc to list projects that include a parameter value that contains the character string abc\t\t\t\t\t\t\tEnter abc 123 to list projects that include a parameter value that contains abc AND 123\t\t\t\t\t\t\tEnter \u201cabc 123\u201d to list projects that include a parameter value which (literally) contains abc 123\t\t\t\t\t\t\tEnter MyParameter=123 to list projects that include the MyParameter parameter with a value that contains 123\t\t\t\t\t\t\tEnter \u201cMy Other Parameter\u201d=abc to list projects that include the My Other Parameter parameter with a value that contains 123. Most project parameter names include spaces, so a quoted (literal) name is needed.\t\t\t\t\t\t\tEnter MyParameter=abc 123 to list projects that include the MyParameter parameter with a value that contains abc, and also have any parameter with a value containing 123.\t\t\t\t\t\t\tEnter MyParameter= to list projects that include the MyParameter parameter, regardless of its value.\t\t\t\t\u25ba  View search examples\t\tClick the\u00a0 icon at the right of the Search bar to remove the currently defined search string.When viewing the list of Workspace projects (in the folder structure view) or the list of local projects, the path to the currently selected folder will be shown in the Search bar. Click on a folder name to show the content of this folder in the dialog. Click the\u00a0 button at the right of the bar or use the Alt + Up Arrow\u00a0shortcut to show the content of the folder one level higher.Project GroupsIn Altium Designer, you can open and edit multiple projects, and if desired, save the collective set of projects as a Project Group (*.DsnWrk).\u00a0In the\u00a0Projects\u00a0panel, the entry of the current Project Group \u2013 either the default one (Project Group 1.DsnWrk), or one you have created or opened \u2013 is shown with the\u00a0\u00a0icon.This can be of particular advantage when the set of projects is related or linked, such as a product design that is composed of multiple PCBs. Creating a Project Group that includes all the relevant projects allows you to open, manipulate, and save multiple projects as a single entity.\tA default design Project Group (ProjectGroup1.DsnWrk) is assigned to the\u00a0Projects\u00a0panel when:\t\t\t\t\t\t\tNo specific design Project Group has been opened.\t\t\t\t\t\t\tThe creation of a new design Project Group is specified.\t\t\t\t\t\t\tWhen all open projects and documents - part of a specific design Project Group or not - are closed.\t\t\t\tThis default design Project Group is initially unsaved. Its name is used as the default entry in the\u00a0Save As\u00a0dialog, when you proceed to save the design Project Group.\t\t    Notes on Using Project Groups    \t\t\t\t\t\tThe current Project Group is listed along with open projects in the Projects panel \u2013 either the default one (Project Group 1.DsnWrk), or one you have created or opened.\t\t\t\t\t\t\tTo save the currently opened set of projects as a group, select File \u00bb Save Project Group As from the main menu.\t\t\t\t\t\t\tTo open an existing group, select File \u00bb Open Project Group from the main menu, or right-click in the panel and select Open Project Group from the context menu. Use the same access for the Save Project Group command.\t\t\t\t\t\t\t\t\t\tAttempting to open a Design Project Group that is already open will result in the Design Project Group being closed and reopened. You will be prompted to save any changes made to open documents.\t\t\t\t\t\t\t\t\t\tTo save a project group,\u00a0right-click on its entry in the Projects panel and choose the\u00a0Save Project Group command, from the context menu.\t\t\t\t\t\t\tTo save a copy of the currently active design Project Group in the\u00a0Projects panel, with a new name (if required), and to a specified location on the hard disk, choose\u00a0the\u00a0File \u00bb Save Project Group As\u00a0command\u00a0from the main menus or right-click\u00a0on its entry in the\u00a0Projects panel\u00a0and choose\u00a0the\u00a0Save Project Group As\u00a0command\u00a0from the context menu.\t\t\t\t\t\t\tTo create a new Project Group, select File \u00bb New \u00bb Design Project Group from the main menu \u2013 this will load the default (blank) Project Group (Project Group 1.DsnWrk). The same method can be used to close the current Project Group file.\t\t\t\t\t\t\tOnly one Project Group can be open at a time, so when opening a different Project Group the current group will close. You will be prompted to save any unsaved documents, projects or changes to the current group first.\t\t\t\t\t\t\tTo add another project to a Project Group, open or create a project and then save the current Project Group. Alternatively, right-click in the panel and select the Add Existing Project option.\t\t\t\t \t\tA set of related local projects as a Project Group\t\tOpening a DocumentTo open a document, double-click it in the Projects panel or right-click its entry and select Open command from the context menu. Multiple documents may be opened simultaneously and each open document has its own tab on the Documents Bar at the top of the design window.\tIf you have enabled the Opens and shows documents\/objects option in the Single Click region on the System - Projects Panel page of the Preferences dialog, then a single click on a document&#039;s entry in the panel will open it in the main design window.You can also open documents as follows:\t\t\tBy choosing the File \u00bb Open command from an editor&#039;s main menus (the  button on the Quick Access Bar; shortcut: Ctrl+O). Any document that is opened this way will be opened as a free document (appearing in the relevant sub-folder of the Free Documents folder in the Projects panel) and made the active document in the main design window. Any project file that is opened will be added to the Projects panel and made the focused project.\t\t\t\tAll documents within the focused category (sub-folder) in the Projects panel can be opened by right-clicking on the entry for the required category, then choosing the Open All command from the context menu.\t\t\t\tAll schematic documents of the focused project can be opened by right-clicking on a Source Document folder that contains schematic documents, then selecting the Open All Schematic Documents command from the context menus.\t\t\t\tOne or more documents, either in the currently focused project or all open projects in the active design project groups, can be opened by choosing the Project \u00bb Project Documents command from the main menus (shortcut: Alt+Ctrl+O).\t\t\t\tAfter launching the command, the Open Project Documents dialog will open. Use this dialog to select the documents that you want to open. You can restrict the view to only list documents in the project that is currently focused in the Projects panel or all projects open in the active design project groups. Use the standard Windows shortcuts (Ctrl+Click and Shift+Click) to select multiple items from the list. With the required document(s) selected, clicking OK will cause those documents to be opened.\t\t\t\t \t\t\tThe Open Project Documents dialog\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tYou can also double-click on the document name in the dialog to open it.\t\t\t\t\t\t\t\t\t\t\t\t\tAll selected documents will be opened as tabbed document views in the main design window. The last document selected will be the last document opened, with its parent project becoming the active project (and also the focused project) in the Projects panel.\t\t\t\t\t\t\t\t\t\t\t\t\tTo display the current status of documents in the Projects panel, click the  button at the top of the panel, then enable the Open\/modified status option within the Sorting grouping of pop-up controls. Alternatively, enable this option on the System - Projects Panel page of the Preferences dialog.\t\t\t\t\t\t\t\t\t\t\t    Active Versus Focused Projects    In the Projects panel&#039;s main tree, the active project is highlighted. When there are no documents open in the design editor window, a project is made active by selecting it from a list of all currently open (loaded) projects in the panel. As soon as a project document is opened (in an editor\/viewer), the parent project of that document automatically becomes the active project. The active document in the design editor window will also be highlighted in the panel.\t\t \t\tThe highlighting of an open active document and its active parent project.\t\t\t\tIf no project documents are open in the design editor window, opening an additional project will automatically make it the active project in the panel.\t\t\t\t\t\tThe ability to search for a particular document is made possible with the Search function featured near the top of the panel. You may enter keywords to narrow down a search, or to find a particular document.\t\tWith numerous documents open in the design editor window, changing the active document using the editor&#039;s document tabs will cause the Projects panel to update accordingly, i.e. to reflect both the active document and the active project (if the document made active does not reside in the same project as the previously active document). Conversely, clicking on the entry for a document that is already open (and that belongs to a non-active project) will make the parent project of that document the active project.\t\tOnly one project and document may be active at any given time, however, the panel allows you to focus and perform actions on any project or document. Right-clicking on the entry for a non-active project or a non-active document will bring up an associated menu with commands targeting the focused project or focused document, respectively.\t\tIn the case of focusing a document, the document will only become focused if it is closed, otherwise, it will become the active document and its parent project will become the active project. For example, in the image below, the active project is MiniPC.PrjPcb and the active document DDR4.SchDoc. The focused document is Ethernet-HPS.SchDoc (distinguished in the panel by a dotted outline box).\t\t \t\tAn opened active document (blue) and a selected focused document are indicated by the dotted outline.\t\t\t    Open Versus Active Documents    When you open a document, it becomes the active document. In Altium Designer, you are allowed to have as many documents open as you wish, however, only one document can be the &#039;active&#039; document. The active document is open in the design space allowing you to make any required updates. The tab of the currently active document displays with a medium gray background; documents that are open and not currently active display with a charcoal gray\/black background.\t\t \t\tTo make another open document the active document, click on its tab. Alternatively, use the Ctrl+Tab or Ctrl+Shift+Tab keys to cycle forward or backward (respectively) through all open documents, in accordance with the order in which they were originally opened.\t\t\t\tIf the Ctrl+Tab switches to the last active document option is enabled, on the System - View page of the Preferences dialog, the functionality of this shortcut is overridden, and using it will simply switch between the currently active document and the previously active document.\t\tThe list of currently open documents is also available from most editors, at the bottom of the main Window menu (the documents are listed in the order that they were opened). Up to a maximum of nine documents can be accessed in this manner. Use a command to make the indicated, open document, the active document in the main design window.\t\tIf you have a large number of documents open, you can choose to group them by enabling the Group documents if need option in the Documents Bar options on the System - View page of the Preferences dialog. Documents can be grouped by document kind or by project. Documents grouped by document kind are sorted alphabetically in a grouped tab. Documents grouped by project are sorted alphabetically within each document kind sub-group in a grouped tab.\t\t\t\tYou can also toggle the display of the current document&#039;s editor (in the schematic editor, schematic symbol editor, PCB editor, PCB footprint editor, CAMtastic editor, and SimView editor) between maximized and not maximized by choosing the View \u00bb Full Screen command, from the main menus or using the Alt+F5 keyboard shortcut. Using this command, any docked panels will be hidden from display, as well as the application&#039;s main banner. Literally, all you see is the editor for the document itself.\t\t\t    Document Window Management    With Altium Designer, you are not limited to viewing and working with a single design document at a time. Documents can occupy the entire design space, or the design space can be shared between multiple open documents. Various commands are provided that allow you to effectively manage the open documents and tailor their display to your preferred working habits.\t\tRight-click on a document tab to access various commands for managing the document. These commands include those affecting the display of all open documents within the main design window, as shown below. Commands for splitting the main design window vertically (Split Vertical) or horizontally (Split Horizontal) are invaluable when performing cross-document tasks, such as cross-probing between a schematic and its PCB.\t\t \t\tWhen split, the regions are treated as though they are individual windows. One document may be active in each region, but only one document, across all regions, can have the focus at any given time. When a new document is added, or an existing document is opened, it will be opened as part of the region in which the currently focused document resides. The image below shows the design space split vertically; the highlighted schematic document is the currently active document.\t\t\t\tThe right-click commands also allow you to tile the documents (Tile All, shortcut: Shift+F4), which opens each document in the design space as shown in the below image. In the image, the highlighted PCB document is the currently active document.\t\t\t\t\t\t\t\t\t\t\tOpening a subsequent document after using this command, will place it as a new tab in the currently active region. Run the command again in order to place this newly-opened document in its own tiled region.\t\t\t\t\t\t\t\t\t\tYou can also use the Window \u00bb Tile Horizontally and Window \u00bb Tile Vertically commands accessed from the main menus of most editors to present all open design documents in their own individually, horizontally- or vertically-tiled regions, within the main application design window.\t\t\t\t\t\t\t\t\t\t\tWhen documents are split or tiled, you can drag and drop them to another region.\t\tUse the Merge All command to &#039;merge&#039; all documents back into a single design window.\t\tYou can also open a document in its own separate design window by right-clicking on its tab then choosing Open In New Window from the menu or by clicking on its tab and dragging it to a point outside of the current Altium Designer window.\t\t\t\tAltium Designer also provides a visually orientated project navigation aid \u2013 Design Insight \u2013 that applies to individual document entries in the Projects panel \u2013 as a Document Insight. Refer to the Document Insight section of the Design Insight page to learn more.\t\t\t    Altium Designer Window Management    When multiple Altium Designer windows are opened, you can use the Window \u00bb Arrange All Windows Horizontally or Window \u00bb Arrange All Windows Vertically command from the main menus to arrange all Altium Designer windows on the desktop horizontally or vertically, respectively, so that they are all visible and do not overlap. After launching the command, all Altium Designer windows that exist on the desktop and are not minimized will be tiled horizontally\/vertically, allowing you to see all windows at once.\t\t\t\t\t\t\t\t\t\t\tIf you have multiple Altium Designer windows displayed across multiple monitors, all windows will be moved to the monitor displaying the Altium Designer window in which this command is launched.\t\t\t\t\t\t\t\t\t\tIf you restore a currently minimized Altium Designer window, immediately after running this command, it will be tiled horizontally or vertically accordingly.\t\t\t\t\t\t\t\t    Opening Recent Documents, Projects and Project Groups    Recently closed documents, projects and project groups can be opened from any editor by using indexed\u00a0commands of the\u00a0File \u00bb Recent Documents, File \u00bb Recent Projects, or\u00a0File \u00bb Recent Project Groups\u00a0sub-menu, respectively. A list shows the most recently closed entities (up to a maximum of nine entities). Position 1 (at the top) reflects the last entity closed.\t\t\t\t\t\t\t\t\t\t\tIf a recent document is opened that does not currently reside in an opened project in the\u00a0Projects panel, it will be opened as a free document.\t\t\t\t\t\t\t\t\t\tWhen opening a recent project group, any open projects (and documents thereof) of the previously active project group will be closed. You will be prompted to save any changes.\t\t\t\t\t\t\t\t\tYou can also choose the\u00a0All Recent Documents and Projects\u00a0command from any of these menus to open the Recent Documents, Projects and Project Groups dialog. The dialog lists all recently closed documents, projects, and design project groups conveniently within one location. Information listed includes:\t\t\t\t\t\t\tDocument Name - name of the opened document.\t\t\t\t\t\t\tDocument Type - type of opened document (PCB, schematic, etc.).\t\t\t\t\t\t\tLocation - location path of the opened document.\t\t\t\t\t\t\tModified - date and time document was last modified.\t\t\t\tSelect what you want to open then either click OK\u00a0to close the dialog and open your selection\u00a0or Open Selected Documents\u00a0to open your selection - keeping the dialog open for further selection. Use the standard Windows shortcuts (Ctrl+click and Shift+click) to select multiple items from the list.\t\t\t\tThe Recent Documents, Projects and Project Groups dialog\t\t\t\t\t\t\t\t\t\t\tDouble-clicking on an entry in the dialog also will open the associated document, project or project groups.\t\t\t\t\t\t\t\t\t\tIf your selection includes documents and\/or projects AND project groups, only the project groups will be opened (and their constituent projects\/documents).\t\t\t\t\t\t\t\tAlternatively, you can drag and drop\u00a0a document, project file, or project group file\u00a0directly into Altium Designer to open it.Closing Projects and DocumentsTo close\u00a0the currently focused project in the\u00a0Projects\u00a0panel,\u00a0right-click\u00a0on its entry and choose\u00a0the\u00a0Close Project\u00a0command, from the context menu. The active project can be closed by choosing the\u00a0Project \u00bb Close Project\u00a0command, from the main menus.Right-click on any document tab to access a drop-down of commands to close the document on which you right-clicked, close all documents of the same editor (e.g., all PcbDoc, all SchLib, or all PcbLib documents) as the one on which you right-clicked, or close all open documents. Open documents can also be closed from the following locations:\t\t\tan open document can be closed by right-clicking on its entry in the Projects panel and choosing the Close command from the context menu.\t\t\t\tthe active document can be closed by choosing the File \u00bb Close command from the main menus (shortcut: Ctrl+F4).\t\t\t\tall currently open documents associated with the active project can be closed by choosing the Project \u00bb Close Project Documents command from the main menus.\t\t\t\tall currently open documents associated with the focused project in the Projects panel can be closed by right-clicking on the entry for the required project and choosing the Close Project Documents command from the context menu.\t\t\t\tall open documents within the focused sub-folder in the Projects panel can be closed by right-clicking on the entry for the required category (sub-folder) and choosing the Close All command from the context menu.\t\t\t\tall currently open documents can be closed by choosing the Window \u00bb Close Documents command\u00a0from the main menus.\t\t\t\tall currently open documents and projects in the current Design Project Group can be closed by choosing the Window \u00bb Close All or File \u00bb New \u00bb Design Project Group command from the main menus.\tThe entry of a free document will be removed from the Projects panel upon closure.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-opening-projects-documents.html"},
{"title":"Managing Project Documents","text":"Projects PanelThe\u00a0Projects\u00a0panel displays all projects that are currently open and their constituent documents and structure.\u00a0The panel&#039;s right-click context menus offer the majority of commands required for working with design documents. \tThe Projects panelNote that the presentation of documents in the Projects panel does not reflect how they are stored on the hard drive or elsewhere. The panel&#039;s contents can be considered as a logical representation of the project, whereas the physical location and organization of the document file storage (and its type) are up to you \u2013 the documents might be stored in a folder on your local machine or a LAN, and of course, hosted in a version-controlled repository provided by a basic Git\/SVN VCS system or a fully managed system such a\u00a0Workspace.\tThe behavior of the Projects panel can be configured using the options on the System \u2013 Projects panel page of the Preferences dialog. These options can also be accessed using the\u00a0 control at the top of the panel.When\u00a0connected to a Workspace, the Workspace icon (\/) is shown next to the uppermost entry of this Workspace. When a Workspace project is opened, its entry is\u00a0shown with an indicative icon, such as\u00a0 for a PCB project. When the local working copy of a project is opened but the Workspace where the project resides is not connected, a grayed-out Workspace icon (\/) will appear, and the project icon will change (e.g. it\u00a0appears as \u00a0for a PCB project).A Workspace project can also be shared with you without inviting you to the team of the\u00a0Workspace where this project resides.\u00a0A project that has been opened from shared access is indicated by an associated Shared with me label with the icon next to it.If a project was shared with you so you can only view it, the View Only label will be shown next to the project entry in the panel to indicate this \u2013 show example.Local projects are listed under the entry of the project group\u00a0( *.DsnWrk) \u2013 either the default one (Project Group 1.DsnWrk), or one you have created or opened.To access the context menu regarding your currently connected Workspace, right-click on your Workspace name or click the \u00a0control at its far right. These commands include:\t\t\tOpen Project \u2013 opens the Open Project dialog.\t\t\t\tCreate Project \u2013 opens the Create Project dialog.\t\t\t\tShow in Explorer \u2013 opens the Explorer panel.\t\t\t\tShow in Web Browser \u2013 opens the Projects page of the Workspace&#039;s browser interface in your default browser.\t\t\t\tSign out \u2013 signs you out of the Workspace.\t\t\t\tSign in\u00a0\u2013 signs you in to\u00a0the Workspace. This command is available provided that you have at least one Workspace item (e.g., project) opened in the Projects panel and you are currently disconnected from the Workspace where this\u00a0item resides.\tYou must be connected to a Workspace to access these commands. When signed out of a Workspace, right-click the Workspace you want to connect to, and click the Sign In command.\t\t\t\t\t\t To open the Web Viewer of a Workspace project listed in the Projects panel, right-click its entry and select the\u00a0Show in Web Browser\u00a0command or choose\u00a0the\u00a0Project \u00bb Show In Web Browser\u00a0command\u00a0from the main menus. To show the project in the Explorer panel, select the\u00a0Show in Explorer\u00a0command or choose\u00a0the\u00a0Project \u00bb Show In Explorer\u00a0command\u00a0from the main menus.\t\t\t\t\t\t\tThe Assembly view of\u00a0the Web Viewer for the active\u00a0Workspace project can be\u00a0accessed using the Project \u00bb Assembly Assistant\u00a0command from the main menus.\t\t\tProject Documents Tree\tWhen you open an existing project or create a new one, its entry will appear in the Projects panel. Any existing documents that are part of a project (and any new ones that have been added) will appear under sub-folders according to their purpose and\/or type. For example, the following common folders and content document types can appear under a project:\t\t\tSource Documents \u2013 core design documents such as schematics, PCBs, etc.\t\t\t\tSettings \u2013 provides various files used within the project, including Output Job Files, Harness Definitions Files, and Annotation Documents, among other pertinent files.\t\t\t\tLibraries \u2013 local source library documents. Documents are further subdivided based on library type (e.g.,\u00a0schematic libraries, PCB libraries, etc.).\t\t\t\tDocumentation \u2013 additional documents that have been added to the project, of a type that is known by Altium Designer (e.g.,\u00a0text, PDF, etc.).\t\t\t\tOther Documents \u2013 additional documents that have been added to the project, of a type that is not known by Altium Designer. These can be opened by Altium Designer if the owner application is known by Windows (e.g., Word documents, Excel spreadsheets, etc.).\t\t\t\tGenerated \u2013 documents generated as output. Documents are further subdivided based on type (e.g., BOM documents, text documents, etc.). As project output is generated, the corresponding sub-folders in the main tree will be created and become populated.\t\t\t\tComponents \u2013 this folder lists each component and the number of components in each group. Validate the project if this folder does not appear (Project\u00a0\u00bb Validate). Components are grouped by the first letter in the designator by default -\u00a0right-click\u00a0on the entry for a component (or component grouping folder) and choose\u00a0the\u00a0Component Grouping\u00a0command from the context menu\u00a0to quickly access the\u00a0Components Grouping\u00a0controls for the\u00a0Projects panel and change the style of grouping, or disable grouping, as required. See the\u00a0Searching for Components and Nets in the Project Structure\u00a0section of the Creating Circuit Connectivity in Your Schematics\u00a0page to learn more.\t\t\t\tNets \u2013 this folder lists each net used in the project. Validate the project if this folder does not appear (Project\u00a0\u00bb Validate). See the\u00a0Searching for Components and Nets in the Project Structure\u00a0section of the Creating Circuit Connectivity in Your Schematics\u00a0page to learn more.\t\tDocuments that are stored in the project folder or a sub-folder of the project folder are associated in the project file using relative referencing. Documents that are stored in a different folder path are associated in the project file using absolute referencing. These documents include a small arrow in the bottom corner to indicate that they are linked to the project, as shown by the  file in the image above.Notes on working in the documents tree:\t\t\tAny documents that are independent of a project will appear as Free Documents and will appear under corresponding sub-folders. By right-clicking on a free document and choosing the Add to Project  command from the context menu, you can add a currently open free document to the active project. Alternatively, you can drag and drop it onto the required project name, in the Projects panel.\t\t\t\tAlong with allowing multiple documents to be open for editing, the environment also supports multiple projects being open at the same time. These could be related or unrelated projects.\t\t\t\tDocuments in the Projects panel are automatically arranged in logical groups or &#039;folders&#039;, such as Source Documents (Schematic, PCB, etc.), Settings documents (Harness, Outjob, etc.,) and, in the case of a hierarchical design, top-level schematic documents. The documents within each folder group are displayed by default in the order they were added but can be dragged and dropped to a new order position within the group.\t\t\t\tIn the case of a new hierarchical design, the parent-child relationship between documents will be displayed in the panel. Note that the connectivity relationships cannot be defined by dragging and dropping schematic documents since the inter-sheet connections and design hierarchy are in fact defined by Sheet Symbols and Port definitions.\t\t\t\tRight-click a\u00a0project document sub-folder, whether expanded or closed, to access additional document management commands, such as\u00a0opening,\u00a0closing, or saving\u00a0all documents\u00a0within the focused project document sub-folder.\t\t\t\tDocuments can be transferred between projects in the panel by clicking and dragging. The document does not have to be dragged into the correct sub-folder; it will be placed correctly within the project structure automatically.\t\t\t\tThe keyboard shortcuts Up Arrow, Home, End, and Down Arrow can be used to display the previous, first, last, and next entry in the panel, respectively. Use the Right Arrow and Left Arrow keys to expand and collapse a top-level entry or its sub-folder, respectively.\t\t\t\tTo cross-probe from the selected component or net entry in the\u00a0Projects panel, to that entity on the schematic or PCB document of the parent PCB design project,\u00a0right-click on the entry and choose\u00a0the\u00a0Cross Probe to Schematic\u00a0or Cross Probe to PCB\u00a0command from the context menu.\t\t\t\tTo open an instance of Windows Explorer, at the location where a project document is stored, right-click its entry in the\u00a0Projects\u00a0panel and select the\u00a0Explore\u00a0command. For the document focused in the\u00a0Projects\u00a0panel, it can be done by clicking the\u00a0 control at the top of the panel.\tProject OptionsAn existing or newly created Project is associated with a range of Option settings that are specific to that project. These are stored in the project file (*.PrjPcb, for example) and will vary depending on the type of project.The option settings are configured in the Project Options dialog, which can be accessed from Project \u00bb Project Options on the main menu or by right-clicking on the project name in the Projects panel and then selecting Project Options from the context menu. For the project focused in the Projects panel, the dialog can be accessed\u00a0by clicking the\u00a0 control at the top of the panel.Other project settings that are defined in other dialogs and then stored in the project file include:\t\t\tSchematic annotation settings.\t\t\t\tOutput settings such as\u00a0reports, print, Gerber, and so on. Note that these are the output settings accessed via the schematic or PCB editor menus, rather than the output settings defined in an OutJob document.\tIndicating Document StatusAs you work with project documents in Altium Designer, the Projects panel provides a visual summary of which document files are modified or saved through status icons that are associated with each design document, and the main project file. This provides a quick visual summary of which documents are modified, saved, whether they are Workspace or local, and their version control status. The document icons and meanings are listed below.Open\/Modified Status Icons\t\t\t\t\t\t[blank]\t\t\tThe document is closed.\t\t\t\t\t\t\t \t\t\tOpen \u2013 The document is open as a tabbed document in the design editor window.\t\t\t\t\t\t\t \t\t\tOpen\/Modified \u2013 The document is open and has been modified (yet to be saved).\t\t\t\t\t\t\t\t\t\tA modified document is flagged by an asterisk suffix next to its entry in the Projects panel. A modified document also has an asterisk next to its name in its open document tab (or on the associated pop-up menu if documents are grouped).\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\tThe document file is open and locked by this instance of Altium Designer.\t\t\t\t\t\t\t \t\t\tThe document file is open and has been locked by another instance of Altium Designer.\t\t\t\t\t\t\t \t\t\tThe document is being edited by another user. This status condition is enabled by the Collaborators Visualization &amp; Conflict Prevention feature.\t\t\t\t\t\t\t \t\t\tThe document being edited by another user is currently open in the editor. This status condition is enabled by the Collaborators Visualization &amp; Conflict Prevention feature.\t\t\t\t\t\t\t \t\t\tThe document is missing (learn more about missing documents).\t\t\t\tA modified document or project that has yet to be saved locally is distinguished by an asterisk next to its entry in the Projects panel. Modified documents are also indicated by an asterisk inside their tab in the main editor window. When file locking is enabled (see Data Management \u2013 File Locking), the icons associated with documents in the panel indicate when a file is open, modified, open, and locked by this instance of Altium Designer, or open and locked by another instance of Altium software. Regardless of file locking, a modified document is indicated by an asterisk associated with its file name.Version Control Status IconsThe version control system essentially monitors and compares the document files in the working folder to their counterparts in the design repository. Altium Designer both requests and exchanges information with the version control system via its VCS interface, and responds to the comparative file status conditions accordingly. In practice, this manifests itself in the Projects file icons, through a range of VCS alerts, and by appropriate changes in the available file management commands.\t\t\t\t\t\tSelect the History &amp; Version Control \u00bb Refresh option from the panel&#039;s right-click menu or select the Project \u00bb History &amp; Version Control \u00bb Refresh command from the main menus (or press F5) to refresh the current VCS status of each document entry. It compares the documents in the working folder to their counterparts in the design repository, refreshing the status of each document accordingly.\t\t\t\t\t\t\tHover over a VCS icon to see a definition of its meaning.\t\t\t\t\t\t\tClick a VCS icon to receive more information on the VCS status of the document and access options to perform relevant actions.\t\t\tThe icons and their meaning are as follows:\t\t\t\t\t\t[blank]\t\t\tN\/A\t\t\tThe document is not under version control in a VCS repository.\t\t\t\t\t\t\t \t\t\tNo modification\t\t\tThe local copy of the document matches the document in the repository and is up to date.\t\t\t\t\t\t\t \t\t\tScheduled for Addition\t\t\tA document has been added to version control but not yet Committed (checked in) to the VCS repository.\t\t\t\t\t\t\t \t\t\tModified\t\t\tThe local copy of the document has been modified and saved to the working folder. Commit the document to create a new revision in the repository.\u00a0For a PCB document, you can also use the\u00a0PCB CoDesign\u00a0functionality to compare local changes with the latest commit in the Workspace using\u00a0the Local Changes to Remote Document Version command from the History &amp; Version Control \u00bb Compare To right-click menu of the Projects panel or the Projects \u00bb History &amp; Version Control \u00bb Compare To main menu.\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\tOut of date\t\t\t The local copy of the document (in the working folder) is older than its counterpart in the repository and is therefore out of date. Use the Update Project From Server command from the History &amp; Version Control right-click menu of the Projects panel or the Projects \u00bb History &amp; Version Control main menu to retrieve the latest document from the Workspace. Note that\u00a0saving\u00a0a document in this state\u00a0will create a conflict condition.\t\t\t\t\t\tWhen the\u00a0project contains only documents in Out of date and\u00a0No Modification states, you can also use the\u00a0Update from Server control that\u00a0appears next to the project name in the Projects panel to retrieve the latest documents of outdated documents from the Workspace \u2013  show image.\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\tConflict Prevention\t\t\tAnother user has committed the document before you have committed your own edited and locally saved version of that document. Use the Version Control Revert Local Changes command to discard\u00a0local modifications for the project document. For a PCB document, you can also use the\u00a0PCB CoDesign\u00a0functionality to compare and merge changes.\t\t\t\t\t\t\t \t\t\tConflict Detected\t\t\tWhen attempting to save a project to the Workspace when the project contains\u00a0documents in the\u00a0Conflict Prevention state, these documents will be in the Conflict Detected\u00a0state. The Action Required\u00a0information dialog will be presented, listing the conflicting document(s) that need resolution. Use the following commands from the History &amp; Version Control \u00bb Resolve Conflict\u00a0right-click menu of the Projects panel\u00a0to\u00a0resolve the conflict:\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tCompare To Remote Version &amp; Merge \u2013 use this command to resolve the conflict for a PCB document\u00a0by comparing and merging changes using the PCB CoDesign functionality.\t\t\t\t\t\t\t\t\t\t\t\t\tUse Remote Version \u2013\u00a0use this command to resolve the conflict by updating the document\u00a0with its latest revision from the Workspace.\t\t\t\t\t\t\t\t\t\t\t\t\tKeep Local Version \u2013 use\u00a0this command to resolve the conflict by using the local version of the document.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\tAhead of server (Git)\t\t\tThe document in the local working repository is newer than its counterpart in the remote Git repository. This occurs when a local document has been modified, saved and committed to the local repository, but not yet Pushed to the remote repository.\t\t\t\t\t\t\t \t\t\tScheduled for Deletion\t\t\tThe project document has been removed from version control and will be deleted from the VCS repository and database during the Version Control Commit process. This icon also appears when a document is missing from the local working folder (it has been deleted, renamed or moved), which is resolved by re-populating the folder from the repository with the Restore document from VCS\u00a0command of the VCS context menu.\t\t\t\t\t\t\t \t\t\tMerged\t\t\tThe PCB document has been merged with a newer revision from the repository using the PCB CoDesign\u00a0functionality. Commit the project to the Workspace to save the merged PCB document to the Workspace&#039;s repository.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe\u00a0Projects panel&#039;s\u00a0History &amp; Version Control\u00a0right-click menu for a document and the VCS context menu of a document\u00a0in the\u00a0Out of date,\u00a0Conflict Prevention, or\u00a0Conflict Detected\u00a0state\u00a0includes the\u00a0Open Remote Document Version\u00a0command that opens the latest document revisions from the Workspace in a new document tab.\t\t\t\t\t\t\tFor schematic and PCB documents in\u00a0Modified,\u00a0Out of date,\u00a0Conflict Prevention,\u00a0and\u00a0Conflict Detected\u00a0states, the VCS context menu includes a command to compare the local document with the\u00a0latest document revisions in the Workspace using the Workspace&#039;s schematic comparison functionality for a schematic document or the PCB CoDesign functionality for a PCB document.\t\t\tChange Project Document OrderDocuments in the Projects panel are automatically arranged in logical groups or &#039;folders&#039;, such as Source documents (Schematic, PCB, etc.), Settings documents (Harness, Outjob, etc.,) and in the case of a hierarchical design, top-level schematic documents. The documents within each folder group are displayed, by default, in the order they were added, but can be dragged and dropped to a new order position within the group.In the case of a new hierarchical design, the parent-child relationship between documents will be displayed in the Projects panel. Note that the connectivity relationships cannot be defined by dragging and dropping schematic documents since the inter-sheet connections and design hierarchy are in fact defined by Sheet Symbols and Port definitions.\u25ba For more information about project hierarchy, see Creating Connectivity and the Net Identifier Scope section in the Options tab of the Project Options dialog.Document RenamingYou can directly change the name of any of PCB project constituent design documents (*.PcbDoc, *.SchDoc, etc.), the PCB project itself (*.PrjPcb) or the project group (*.DsnWrk) by using the Rename command \u2013 available from the right-click context menu for a project in the Projects panel.Examples of renaming a project and one of its design documents, locally from within Altium Designer. Those changes will be synchronized with the Workspace when you save and send the changes to that Workspace.With renaming performed, save the changes to the Workspace using the Save to Server command (available from the same context menu for the project). File rename synchronization is maintained between the local working copy of the project and its counterpart in the Workspace. Additionally, when the project file name has been renamed and the project saved to the server, the Workspace automatically changes the managed project&#039;s Name parameter to match.Conversely, when the name of a managed project is updated through the Workspace&#039;s browser interface, the change is propagated to Altium Designer when the project is next opened.\tTo edit the properties of an existing managed project in the Workspace, select its entry on the Projects page, click the  control above the listing of projects, and choose the Edit entry on the associated menu. Change the name for the project in the subsequent Edit Project window that appears.When the updated project is opened in Altium Designer (File \u00bb Open Project), an initial dialog provides the option to align the local project file name with the new project Name, or force the server project Name to match the existing project file name.Options available if you have renamed the project on the Workspace side.Share Documents Between ProjectsBecause an Altium Designer project defines and saves links to stored document files, any number of projects can be created that link to those same document files.While this may be a convenient way to re-use established design documents \u2013 say, including a standard power supply schematic in several projects \u2013 it is not recommended practice because a change in the document will affect all projects it is linked to. A far better approach for design reuse is to establish and apply Managed Sheets.For more information about design document reuse and Managed Sheets, see the Managed Sheets page.Managing Missing Documents\tThis feature is available when the WSM.ManageMissingFiles option is enabled in the Advanced Settings dialog.\tIf a project document defined within the project file is not found within the project folder (for example, the document was removed from within Windows Explorer), it is considered missing. Upon opening a project containing a missing file, a corresponding notification will be shown in the Messages panel. The document entry will be grayed out and marked as missing with a distinguishing icon in the Projects panel. Associated commands are available that give you full control over handling missing documents. Use the right-click menu of a missing document in the Projects panel to remove the selected or all missing files from the project or to update the path to the file (i.e. to replace the missing file with a selected one). For a project under version control, you also can revert local modifications to restore a missing file from the project&#039;s VCS repository. When adding an existing file to the project using the Add Existing to Project command from the project entry&#039;s right-click menu and the name and the path of the file being added are the same as the name and the path of a missing file (which is possible when, for example, the missing file was added to the project folder after opening the project in Altium Designer), a confirmation dialog will open asking if you would like to replace the missing file with the selected one. Compare Local Documents with Commit or Release DataFor projects hosted by a Workspace, you can compare locally saved schematic,\u00a0PCB and BOM documents with the data of a commit or release of this project. Commands for selecting a required data set with which the local documents should be compared can be chosen from the following locations:\t\t\tThe History &amp; Version Control \u00bb Compare To right-click menu of the project document in the Projects panel.\t\t\t\tThe Compare\u00a0button menu in the Save to Server dialog.\t\t\t\tThe  control menu of the Local Changes tile of the Project History view.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\tJavascript ID: LocalCompare_AD24\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tWhen the Latest Commit or Latest Release command is selected, the project data comparison with those from the latest commit\/release entry will start.\t\t\t\tWhen the Select Document Version or Release\u00a0command (from the Projects panel) or\u00a0Select Commit or Release\u00a0command (from the Save to Server dialog) is selected, the Document History\u00a0or\u00a0Project History view, respectively, will open for the selected document\/project. Select the tile of a commit or release to compare the locally saved data with the data of this commit\/release.\tOnce complete, the comparison results are presented in the Compare view, which opens as a new tab in your default browser.\tTo learn more about design data comparison features provided by the Workspace, see Design Data Comparisons\u00a0(Altium 365 Workspace, Enterprise Server Workspace).Clipboard Panel\tThe Clipboard panel\u00a0is available when the UI.PanelClipboard option is enabled in the Advanced Settings dialog.\tTo store and display copied objects that can be added (pasted) to Altium Designer documents at any stage, allowing for multiple copy\/paste operations, the Clipboard panel can be used.View and apply (paste) Clipboard panel content for all design data types.\t    Clipboard Panel Contents and Use    \tPanel Contents\tThe Clipboard panel supports a variety of data formats depending on the origin and object type. It can be set to display either only objects copied or cut from within the Altium Designer environment, or the entire Windows clipboard (this setting is accessed through Preferences on the System - General page of the Preferences dialog). Note that not all data types are supported by each design editor (PCB editor, schematic editor, etc.).\t\tThe data types supported are:\t\t\t\t\t\t\tAny design object copied or cut from a schematic-based (schematic\/schematic library) or PCB-based (PCB\/PCB library) document.\t\t\t\t\t\t\tUni-code text copied or cut from any text-based document (e.g., text file, scripting file, constraint file, Microsoft Word\/Excel document, etc.).\t\t\t\t\t\t\tBitmap images created from 3D view modes for pasting into other applications.\t\t\t\t\t\t\tWindows enhanced meta-file image formats (e.g., simple bitmap images\/text cut\/copied from Microsoft Word\/Excel documents). This data type is supported in the PCB editor only.\t\t\t\tPanel Use\tAs objects or text are copied\/cut; a matching entry will appear in the main list area of the panel in their native formats - that is, graphics or text.\t\t\t\tTo paste an item into the active document in the design editor window, click on the item in the Clipboard panel. The nature of the paste depends on the object being pasted and the target document type as described below:\t\t\t\t\t\t\tWhen pasting schematic-based or PCB-based objects into a document, the object will appear floating with the cursor. Position the object as required in the workspace and click to place.\t\t\t\t\t\t\tWhen pasting text into a text-based document, the text will be placed at the current cursor position in the document.\t\t\t\tUse the Paste All button at the top of the panel to paste all objects in the panel into the active document. Again, the nature of the paste depends on the target document:\t\t\t\t\t\t\tThe target document will only paste compatible objects to the document type. Each object in the panel will appear floating, in turn, on the cursor in the main design workspace. Place each object at the desired location and click to place.\t\t\t\t\t\t\tWhen pasting into PCB documents, if the object is re-sizeable, handles will appear that can be dragged to resize. Right-click to enable the resizing and progress to the next pasting object.\t\t\t\t\t\t\tWhen the target document is text-based, only text entries will be pasted. Each text entry in the panel will be pasted, in order, starting from the current position of the text cursor.\t\t\t\tRight-click over an entry in the panel to open a context menu allowing you to either paste that entry or delete it.\t\t \t\t\t\tTo delete all current entries from the panel, click the Clear All button.\t\t\t\tNotes\t\t\t\t\t\tYou can only paste objects from the panel if they are supported in the target document that is open (the active document) in the design editor window. For example, if you try to paste a schematic-based object into a text-based document, there is no result, and vice versa.\t\t\t\t\t\t\tText objects copied to the panel will appear as though they are unformatted. However, when pasted they will appear with the original formatting that existed before they were copied.\t\t\t\t\t\t\tIt is advisable to place the text cursor in the required position before pasting text from the panel into a text-based document.\t\t\t\t\t\t\tWhen using Paste All to paste multiple text entries into a text-based document, the pasted text will, in effect, be concatenated - that is, each subsequent text entry is pasted immediately after the last.\t\t\t\t\t\t\tClipboard panel content is not persistent across design sessions. All content will be cleared when the software is closed and restarted.\t\t\t\tvar p = document.getElementsByClassName(&quot;Counter&quot;);for (k = 0; k &lt; p.length; k++) {Bloberator(p[k].id, &quot;0&quot;);}document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);function Update(ss, n) {var g = (document.getElementById(ss).innerHTML) - 1;var TextArray = document.getElementsByClassName(ss + ss);var ImageArray = document.getElementsByClassName(ss);if ((g == 0) &amp; (n == -1)) {n = 0;}ImageArray[g].style.opacity = &quot;0&quot;;ImageArray[g].style.zIndex = &quot;-1&quot;;if (g &lt; TextArray.length) {TextArray[g].style.display = &quot;none&quot;;}g = g + (n);if (g == ImageArray.length) {g = 0;}var v = ImageArray[g].getElementsByTagName(&quot;video&quot;)[0];if (v != null) {v.currentTime = 0;v.play();}ImageArray[g].style.opacity = &quot;1&quot;;ImageArray[g].style.zIndex = &quot;1&quot;;if (g &lt; TextArray.length &gt; 0) {TextArray[g].style.display = &quot;inherit&quot;;}document.getElementById(ss).innerHTML = g + 1;Bloberator(ss, g);}function Bloberator(sss, m) {var dots = &quot;&quot;;var IR = document.getElementsByClassName(sss);for (d = 0; d &lt; IR.length; d++) {if (d == m) {dots = dots + &quot;&quot;;} else {dots = dots + &quot;&quot;;}}var dotrows = document.getElementsByName(sss);for (x = 0; x &lt; dotrows.length; x++) {dotrows[x].innerHTML = dots;}}","tags":"","url":"altium-designer\/24\/documentation-altium-designer-managing-project-documents.html"},
{"title":"Navigating a Document","text":"When working with a graphical document, such as a schematic sheet, PCB document, or Draftsman document, you can zoom and pan the document to focus on a specific document area. The basic shortcuts that can be used to do this are:\tCtrl+Mouse Wheel to zoom in and out\tRight-Click, Hold&amp;Drag to slide the document aroundThe View main menu includes a number of commands that can be used to control the view of the current document.Use commands of the View main menu to control the view of your document. In the top image, the View menu of the schematic editor is shown. In the bottom image, the View menu of the PCB editor is shown.These commands include:\tFit Document - display the entire area of the current document.\tFit All Objects - display all design objects on the current document.\tArea - zoom into a user-defined area of the current document.\tAround Point - redefine the display area about a specified point in the current document.\tSelected Objects - change the view in the design space, such that all selected objects are visible.\tZoom In - bring the design closer to you, relative to the cursor position, in the current document.\tZoom Out - move the design away from you, relative to the cursor position, in the current document.\tZoom Last - return the display to the previous view of the screen, in the current document.You can also use the Z shortcut to access the pop-up menu with zoom commands.In the PCB and PCB footprint editors, this menu allows you to access the Select command that opens the Zoom Value (0.001x..4x) dialog from where you can change the magnification of the display of the current document by a specified value. Values greater than 1 are entered in order to zoom in to a greater extent (increase magnification). Values less than 1 are used to zoom out to a greater extent (decrease magnification). The Zoom Value dialogWhen viewing a PCB or PCB footprint document in 3D, additional commands, shortcuts, and controls are available to fluidly navigate the view. Refer to the Controlling the 3D View page to learn more.Jumping to a Specific Point in a DocumentUsing the commands of the Edit \u00bb Jump sub-menu from the main menus of the schematic, schematic symbol, PCB or PCB footprint editor, you can jump to a specific point in the active document. The Jump pop-up menu also can be accessed by pressing the J key in the design space. For example, you can jump to:\tthe document&#039;s origin coordinate:\t\t\tthe origin point of a schematic sheet (that corresponds to the bottom-left corner) - Origin;\t\tthe absolute origin of the PCB document - Absolute Origin;\t\tthe relative origin of the current PCB document - Current Origin;\t\tthe location of the component reference point in the PCB footprint document - Reference;\t\t\t\tany location within the current document, based on user-specified XY coordinates - select the New Location command to enter values for the X and Y coordinates within the design space, for the location you wish the cursor to jump to, in the Jump To Location dialog that appears. In the PCB editor, you can also use the Delta X and Delta Y fields to specify the delta X and Y coordinates for the required location to which you want to jump.\t  \tThe Jump To Location dialog - in the schematic editor (the first image) and in the PCB editor (the second image)\t\tan object within the document. Use the following commands to jump to an object of interest:\t\t\t\t\ta component on the schematic sheet - Jump Component. After launching the command, the Component Designator dialog will appear. Enter the component designator for the component you wish to jump to. If the designator is valid and the component exists on a schematic source document within the active project, then the relevant schematic document will be made the active document, and the target component will be zoomed and centered (where possible) within the design space. The found component (or all parts for a multi-part component) is also listed in the Messages panel. Double-click a message entry to jump to that component (or part thereof) in the design space.\t\t \t\tThe Component Designator dialog\t\tWhen targeting a multi-part component, only enter the root designator. Do not include the part suffix. For example to jump to a 2-part IC component, whose parts are designated IC1_CPA and IC1_CPB, enter IC1_CP into the Component Designator dialog. For a multi-part component, the first part will be highlighted, with the Find Text - Jump dialog opened. Use this dialog to jump between sub-parts of the component.\t\tEnable the Physical option in the Component Designator dialog to confine the jump feature to only physical component designators - those appearing on the Compiled Document tabbed views of the source schematic documents. With this option disabled, the jump feature will only consider logical designators - those appearing on the Editor tabbed views of the source schematic documents.\t\t\t\t\t\ta specific component in the PCB document - Component. After launching the command, the Component Designator dialog will appear. Type in the component designator to jump to that component. If you are unsure of the designator, type ? and click OK to launch the Components Placed dialog, which lists all components in the design. Enter text into the Mask field to search for the desired component. As you type, the list is filtered to show only strings that match the mask string. You can use the ? (any single character) and * (any characters) wildcards in the string. The cursor will jump to the reference point of the component you select.\t\t \t\tType ? in the Component Designator dialog to access the Components Placed dialog listing all components in the PCB.\t\t\t\t\t\ta specific net in the PCB document - Net. After launching the command, the Net Name dialog will appear. Type in the name of the net you wish to jump to, or type ? and press OK to open the Nets Loaded dialog, containing a list of all loaded nets for the design. Enter text into the Mask field to search for the desired net. As you type, the list is filtered to only show strings that match the mask string. You can use the ? (any single character) and * (any characters) wildcards in the Mask string. If the target Net is already displayed within the main design window, the cursor will jump to the nearest design object that is a member of that Net. If the Net is out of view, the cursor will be positioned at the nearest design object that is a member of that Net, centered within the design space (where possible).\t\t Type ? in the Net Name dialog to access the Nets Loaded dialog listing all nets in the PCB.\t\t\t\t\t\ta specific component pad in the PCB document - Pad. After launching the command, the Jump To Pad Number dialog will appear. Enter the required pad of the desired component in the form ComponentDesignator-PadDesignator (e.g., U1-6) and click OK. If the target pad is already displayed within the design space, the cursor will simply jump to the center of that pad. If the pad is out of view, the cursor will be positioned at the center of the pad, centered within the design space (where possible).\t\t \t\tThe Jump To Pad Number dialog\t\t\t\t\t\ta specific string in the PCB document - String. After launching the command, the Jump To String dialog will appear. Type in the string that you wish to jump to, or type ? and click OK to open the Strings dialog, containing a list of all strings found within the active board document (free and children of other group objects). Use this dialog to quickly locate the string to which you want to jump. If the target string is already displayed within the design space, the cursor will simply jump to anchor point of the string - the point by which it is held during a move operation, or rotated around. If the string is out of view, the cursor will be positioned at the anchor point of the string, centered within the design space (where possible).\t\t \t\tType ? in the Jump To String dialog to access the Strings dialog listing all nets in the PCB.\t\tThe system will perform three searches: first for a string that matches the specified string in both case, characters and length; then for a string with the same characters in it but perhaps having more characters; and finally for a string with the same characters, ignoring case.\t\t\t\t\t\tjump to, and cycle through, all error markers in the current design document - Error Marker. After launching the command, the cursor will jump to the first Design Rule Check (DRC) error marker, centered in the main design window. Repeatedly using the command will cause a jump to a second error marker and so on. This command will jump to an error marker, irrespective of whether or not the violation is waived.\t\tInterrogate the violation(s) associated to the object under the cursor by right-clicking and choosing the relevant command from the Violations sub-menu.\t\t\t\t\t\tjump to, and cycle through, all selected design objects in the current document - Selection. After launching the command, the cursor will jump to the first selected object, zoomed and centered in the main design window. Repeatedly using the command will jump to a second selected object and so on, cycling through all selected objects in the current document. The command cycles through the selected objects in the order in which they were originally added to the selection.\t\t\t a position in the current schematic or PCB document, whose coordinates have been previously stored in the indicated location marker - select the Location Marks \u00bb n command to jump to the position that has been stored in the indicated location marker using the Set Location Marks \u00bb n command.\tFor a schematic document, a stored location is only available while the document remains open (active or not). If the document is closed and opened again, the location marker will be empty. For a PCB document, location markers are saved with the design, so that the user-defined positions contained within can still be accessed between design sessions.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-navigating-document.html"},
{"title":"Saving Projects and Documents","text":"Saving a DocumentThe currently active document can be saved locally by:\t\t\tChoosing the File \u00bb Save command, from the main menus.\t\t\t\tClicking the  button on the Quick Access Bar.\t\t\t\tClicking the  button on the editor&#039;s main toolbar.\t\t\t\tUsing the Ctrl+S keyboard shortcut.\tThe currently focused document in the Projects panel (if the document is actually open) can also be saved by right-clicking on its entry in the panel and choosing the Save command, from the context menu.The currently focused item (document, project, or project group) in the Projects panel can be saved by clicking the  button at the top of the Projects panel. When the focused item is a project, only the project document is saved. The constituent design documents are not saved by this command. When the focused item is the design project group, only the design Project Group document is saved (*.DsnWrk). The constituent projects and their design documents are not saved by this command.A document in a modified state can also be saved by using the corresponding command from its document tab - right-click on the tab to access a context menu of commands. Note that this command will not be available if multiple documents of the same type are open and currently grouped.\tFor schematic documents, if the current file format is not Binary Version 5.0, the File Format dialog will appear, from where you can choose the format in which to save. It is recommended to choose the option to save in SCH Binary Version 5.0. If you have used features that were not available in previous versions of Altium Designer, saving in an earlier format may result in loss of data.\t\tFor PCB documents, if the current file format is not Binary Version 6.0, the File Format dialog will appear, from where you can choose the format in which to save. It is recommended to choose the option to save in PCB Binary Version 6.0. If you have used features that were not available in previous versions of Altium Designer, saving in an earlier format may result in loss of data.\t\tFor a document that is a part of a Workspace project,\u00a0the Save command will save the changes locally, i.e. only\u00a0your local working copy of the document file will be saved. After saving changes locally, the project&#039;s VCS status will be changed to Modified, and the document&#039;s VCS status icon will be changed to .\u00a0To make the changes available in the connected Workspace, the project must be saved to this Workspace - learn more.An open project document can be saved under a new name using the File \u00bb Save As command or the Save As command from the right-click menu of the document entry in the Projects panel, which creates a copy of the document file under the nominated new name. This process automatically adds (links) the new document copy to the active project in place of the existing (source) document, which remains intact in the source folder. If the open document is not part of a project \u2013 a free document \u2013 the new copy is simply opened in the editor in place of the original document.After launching the command, the standard Windows Save As dialog appears. Use this dialog to browse to a particular destination in which to save the file, give the file a new name (if required) and also to select the format in which to store the file (where available). The newly saved file will be opened in place of the original file as the active document.\tNote that files stored in the same folder as the project file itself (or in a child\/grandchild folder) are linked to the project using relative referencing, whereas files stored in a different location are linked using absolute referencing.\t\tThe parent project must be saved in order to point to the copy of the document the next time the project is opened, otherwise the project will include the original document still.If the intention is just to make a backup copy of a document, use the Save Copy As option. This creates a named copy of the document file without affecting its host project. After launching the command, the standard Windows Save A Copy Of dialog appears. Use this dialog to browse to a particular destination in which to save the file, give the file a new name (if required) and also to select the format in which to store the file (where available). The newly saved file will not be opened in place of the original file.\tIf the intention is to rename a document, see the Document Renaming section.\tAll projects and documents that have been modified can be saved locally by:\t\t\tChoosing the File \u00bb Save All command, from an editor&#039;s main menus.\t\t\t\tClicking the  button on the Quick Access Bar.\t\t\t\tRight-clicking on the entry for the design project group in the Projects panel, and choosing the Save All command, from the context menu.\tIf the projects are part of an existing (previously saved) Project Group, and project membership has changed (projects added or removed since last save), then the Project Group document (*.DsnWrk) will also be saved.To save all documents that are currently open within the focused category (sub-folder) in the Projects panel or descendant folders thereof, right-click on the entry for the required category (sub-folder) and choose the Save All command, from the context menu.Saving a ProjectWhen you perform a change on an open project&#039;s structure or options, it becomes modified. A modified\u00a0project is distinguished by an asterisk next to its entry and the\u00a0 status icon in the\u00a0Projects\u00a0panel. To save the changes of a project document file, right-click the project entry in the Projects panel and select the Save command. The focused project in the panel can be saved by\u00a0clicking the\u00a0 control at the top of the panel.For a Workspace project, the Save command will save the changes locally, i.e. only\u00a0your local working copy of the project document file will be saved. After saving changes locally, the project&#039;s VCS status will be changed to Modified, and the\u00a0project&#039;s\u00a0VCS status icon will be changed to .\u00a0To make the changes available in the connected Workspace, the project\u00a0must be saved to this Workspace. To do this, use one of the following ways:\t\t\tClick the Save to Server control next to the project entry.\t\t\t\t\t\t\t\t\tThe Save to Server control\u00a0is available when the UI.SaveToServerPromotion option is enabled in the Advanced Settings dialog.\t\t\t\t\t\t\t\t\tRight-click\u00a0on the\u00a0project entry and select\u00a0Save to Server\u00a0from the context menu.\t\t\t\t\t\tClick the Modified status icon () next to the project entry and select Commit Project.\t\t\tThis saves the project&#039;s source design documents that have been modified\u00a0but not yet saved locally and\u00a0opens the Save to Server dialog, in which you can select the documents to be saved to the Workspace. By default, all modified documents are selected in the dialog when accessed as described above.\t    Options and Controls of the Save to Server Dialog    \tUpper Pane\tThis upper pane lists all files in the selected project and lists whether or not they are in VCS. Additional relevant information is also listed, including whether a file is marked for addition or deletion. You can select files to commit to version control. The Path column shows the path of each file, the Status column shows the file&#039;s current status. This part of the dialog also features a right-click menu with the following options:\t\t\t\t\t\t\tSelect All \u2013 click to select all files listed in the dialog. Selected files will be added to VCS.\t\t\t\t\t\t\tSelect None \u2013 click to deselect all files listed in the dialog. These files will not be added to VCS.\t\t\t\t\t\t\tSelect Project Documents \u2013 click to select only project files.\t\t\t\tLower Pane\t\t\t\t\t\tComment \u2013 you can write comments before committing the files to version control in this text box.\t\t\t\t\t\t\t\t\t\tAs the hint within this field states, you can add a task ID to the comment (as it appears in the Comments and Tasks panel), and the task will be linked to the project commit that will be created after clicking OK in the dialog.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe link to the commit will be shown in the task detail pane when the task tile is selected on the Tasks page of the Workspace&#039;s browser interface\u00a0(Altium 365 Workspace, Enterprise Server Workspace) or the Tasks view of the project&#039;s detailed management page\u00a0(Altium 365 Workspace, Enterprise Server Workspace). Click the link to open the project&#039;s History view with the related commit highlighted on the timeline.\t\t\t\t\t\t\t\t\t\t\t\t\t\tCompare \u2013 click to select a command to compare the locally saved schematic, PCB, or BOM data with a commit or release of the project. The results of the comparison will be presented in a new tab of your default browser.\u00a0For more information, see Design Data Comparisons (Altium 365 Workspace, Enterprise Server Workspace).\t\t\t\tAfter clicking\u00a0OK, the documents are saved to the Workspace, and the\u00a0Save to Server\u00a0link disappears from the\u00a0Projects panel.\t\t\tThe Save to Server dialog can also be accessed by clicking\u00a0the Modified\u00a0VCS status icon () next to the entry of the Workspace project&#039;s\u00a0document and selecting Save to Server. Note that in this case, only that document will be selected by default in the dialog.\t\t\t\tWhen attempting to use the\u00a0Save to Server\u00a0command when the project contains files in the Conflict Prevention\u00a0state, with the\u00a0 VCS icon in the\u00a0Projects\u00a0panel, the Action Required\u00a0information dialog will be presented, listing the conflicting file(s) that need resolution. Such files will have the\u00a0Conflict Detected\u00a0state with the\u00a0 VCS icon. Use the VCS content menu of a document in the\u00a0Conflict Detected\u00a0state to resolve the conflict by updating the document with its latest revision from the Workspace or by using the local document (or, for a PCB document, by comparing and merging changes using the PCB CoDesign functionality).\t\t\t\t\t\t\t\t\t\tIf the target Workspace\u00a0in which the focused Workspace project resides is not currently connected, Altium Designer will connect to this Workspace automatically.\t\tYou can\u00a0discard local modifications for a project document by\u00a0right-clicking on the entry for the document entry and selecting the History &amp;\u00a0Version Control\u00a0\u00bb Revert Local Modifications\u00a0command from the right-click menu. You can also\u00a0discard local modifications for the project file in a similar way or by selecting the\u00a0Project\u00a0\u00bb History &amp; Version Control\u00a0\u00bb Revert Local Modifications\u00a0command from the main menus. All local modifications to the project document will be lost, and the file will be reverted back to its base revision (the last revision of the file checked out\/updated to the working folder). The status\u00a0of a file that has been reverted depends on its previous status (for example, a file showing as\u00a0Modified\u00a0will revert back to\u00a0No modification).\t\t\t\t\t\tWhen a user can only view a project, the\u00a0Save to Server link next to the project file and the Save to Server command from the project entry&#039;s right-click menu will not be available.\t\t\t\t\t\t\tThe fully qualified file name of a project document\u00a0must be less than 260 characters, and the directory name must be less than 248 characters. You can configure your Windows OS and Altium Designer to support long path names. Refer to the Support for Long Path Names\u00a0page to\u00a0learn more.\t\t\t\t\t\t\tWhile you can add existing project-relevant documents to your Altium 365 Workspace projects, note that there is a limitation for zip, 7z and rar files larger than 256 MB. Projects containing such files cannot be saved to the Workspace\u00a0\u2013 you will receive a Git Error. Refer to the\u00a0How to fix project data after Git Error with status code 471\u00a0Knowledge Base article to learn how to fix this issue.\t\t\t\t    Working Copy to Workspace Project Sync Resolution    The application of fully managed, version-controlled PCB projects relies on tight synchronization between the project&#039;s local working folder contents and the Workspace&#039;s versioned storage. If this relationship is disrupted by changes made outside of the normal processes, the managed project structure can become corrupted.\t\tPossible changes that break the local-remote storage synchronization include manual actions such as renaming, moving, or copying\/cloning a working project folder. These issues are detected and addressed through a choice dialog that highlights a recommended action based on the situation. In general, its options are to resynchronize the folder project as the current managed project or to remove the project&#039;s relationship with the server (make the project unmanaged).\t\t\t\tOptions to get you back into sync if you have manually changed the location of your local working copy of a project.\t\tOther more complex synchronization disruptions may be caused by changes in the server identity, such as when the server itself has been renamed or moved when a local project file has been overwritten with one that contains different server identity parameters, or the project&#039;s target repository has changed. Such issues create a disparity between the server and the local project repositories and are reported by warning dialogs or dialogs that provide a resolution choice.\t\t\t\tOptions to get you back on track if the repository targeted by the local working copy of your design project has changed.\t\t\tTo save a copy of the\u00a0project,\u00a0with a new name (if required), and to a specified location on the hard disk, use the\u00a0File \u00bb Save Project As\u00a0command\u00a0from the main menus or\u00a0right-click\u00a0on its entry in the Projects panel and choose\u00a0the\u00a0Save Project As\u00a0command\u00a0from the context menu. After launching the command, the standard Windows\u00a0Save As\u00a0dialog appears. Use this dialog to browse to a particular destination in which to save the project file, and give the file a new name (if required). The newly saved project will be opened in place of the original project.Saving when Closing a ProjectIf you close a project and that project has two or more modified\u00a0documents that have not yet been saved, the Confirm Save for Modified Documents dialog will open. Use this dialog to decide what to do with those documents.\tThe dialog will also appear when attempting to close Altium Designer and\u00a0there are at least two open, modified design documents across multiple projects that have not yet been saved. Use the Confirm Save for Modified Documents dialog to decide how to handle unsaved documents when closing one or more\u00a0projects or Altium Designer itself.The main area of the dialog lists all open and modified documents (by name and\u00a0path to the local copy) for which you need to make a decision about whether or not to save. Documents are grouped by type (e.g., PCB Documents, PCB Projects, Schematic Documents, BOM Documents and so on).The possible decisions are listed below. Which decisions are actually presented for a document will depend on whether that document is local or Workspace-based and, if the latter,\u00a0whether or not that document has also been saved locally already. \u00a0- this decision is available for a local document\u00a0or for a Workspace document that has not already been saved locally. In the case of the latter, it allows you to save the document locally without committing\u00a0changes to the connected Workspace. \u00a0-\u00a0this decision is available for a local document\u00a0or for a Workspace document that has not already been saved locally. Any changes to the\u00a0document will\u00a0be discarded. \u00a0- this decision is available for a Workspace document, irrespective of whether it has already been saved locally or not. Changes to the\u00a0document will be saved locally (where applicable) and to the connected Workspace. \u00a0-\u00a0this decision is available for a Workspace document when it has already been saved locally. Since there is nothing to save locally, nothing will be done with this document.\tNote that if a modified document is open from a Workspace and that Workspace is not the active Workspace, then the decision to Save to Server will not be available. Such a document can only be saved locally (if applicable).The following buttons are available at the bottom of the dialog to quickly make decisions en-masse: \u00a0- use this button to quickly set decisions for each document in a &#039;save locally&#039; way. For a local document or Workspace document that has not already been save locally, its decision will be set to Save. For a Workspace document that has already been save locally, its decision will be set to Do nothing. \u00a0-\u00a0use this button to quickly set decisions for each document in a &#039;save none&#039; way. For a local document or Workspace document that has not already been save locally, its decision will be set to Don&#039;t Save. For a Workspace document that has already been save locally, its decision will be set to Do nothing. \u00a0-\u00a0use this button to quickly set decisions for each document in a &#039;save fully&#039; way. For a local document its decision will be set to Save. For a Workspace document\u00a0its decision will be set to Save to Server.\tUse standard Ctrl+click and Shift+click techniques to select multiple\u00a0entries, then make a decision from the right-click context menu to apply to all in the selection. The actual decision applied will be in accordance with whether the document is local\/Workspace-based, as described previously. Note that multiple selection only works across documents in the same grouped category.Auto Save BackupsDeveloping an electronic product in an environment like Altium Designer results in a large number of electronic files. These files are valuable\u00a0since they are your company&#039;s IP (Intellectual Property)\u00a0and must be stored and maintained in an appropriate way. Altium Designer includes a number of features to ensure that your files remain safe, are backed up, and older versions can be retrieved if necessary.Altium Designer includes the capability to\u00a0automatically save multiple versions of all open files\u00a0at the specified time interval. Configured in the Data Management \u2013 Backup page of the Preferences dialog, the Auto Save feature saves a copy of all currently open files that have been modified (in the Projects panel, this is indicated by an asterisk after the filename)\u00a0into the specified location\u00a0and at the specified time interval. Up to 10 versions of each file can be saved\u00a0in the location specified by the Path entry in the Preferences dialog.This feature is intended for disaster recovery, for example, if the power fails and your PC shuts down unexpectedly. AutoSave files are identified by the addition of .~(X) into their filename, for example, the file MySchematic.SchDoc is auto saved as MySchematic.~(1).SchDoc, then MySchematic.~(2).SchDoc, etc. Note that once the specified number of versions have been saved, the filenames are re-used. That means that the file&#039;s timestamp should be used to identify the latest file, rather than the number within the brackets in the filename.\tAutosave files can also be included in the Local History by enabling the Add autosaved documents to history option in the Data Management \u2013 Local History page of the Preferences dialog. When this option is enabled the file is saved in both locations when an autosave event occurs. The copy saved to the local history has a date and timestamp included in the filename and is saved in the compressed ZIP format used by the Local History feature. Refer to the Local History section of the Storage Manager Panel page to learn more about the Local History feature.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-saving-projects-documents.html"},
{"title":"Project History","text":"Altium Designer, in conjunction with a connected Workspace, allows you to view and interact with an advanced graphically orientated Project History timeline. The dedicated History view provides a progressive timeline of major events relating to the PCB, Multi-board\u00a0or Harness project \u2013 its creation, commits, releases, copies, and MCAD exchanges \u2013 with various actions supported where applicable.\tGetting the most out of this feature requires your project to be fully managed\u00a0by ensuring the project is under the Workspace&#039;s own built-in VCS (Git).\t\t\t\t\t\t\tIf your project is under external version control, you can convert it to a fully managed project hosted in the Altium 365 Workspace by migrating the project to the Workspace&#039;s native VCS. For detailed information on how to do this, see Moving from External VCS to Workspace Native VCS.\t\t\t\t\t\t\tFor information on working with the History view for a project through the Workspace&#039;s browser interface, see Project History.\t\t    Enabling Project History    The Project History functionality is delivered through a purpose-made extension \u2013 the Project History extension.\t\tThe Project History extension.\t\t\t\tThis feature is only made available, provided the Project History extension is installed as part of your Altium Designer installation. This extension is installed by default when installing the software, but in case of inadvertent uninstall can be found back on the Purchased tab of the Extensions &amp; Updates page (click on the current user control (e.g. ) at the top-right of the main application window, then choose Extensions and Updates from the associated menu).\t\tAccessing the Project HistoryTo access the History view for a Workspace project from within Altium Designer, right-click on its entry in the Projects panel and choose the History &amp; Version Contol \u00bb Show Project History command from the context menu. Alternatively,\u00a0select\u00a0the\u00a0History &amp; Version Control\u00a0\u00bb\u00a0Show Project History\u00a0command from the\u00a0Projects\u00a0main menu to open the History view for the active Workspace project. The History view presents as a distinct tabbed document (.PrjPcb History).\tFor a project in your Workspace that already existed prior to the arrival of the Project History feature, its history will initially not be complete. Reindexing of the event data for that project will be performed automatically when the History view is first accessed for that project. Notification will appear at the bottom of the view once the reindexing has completed \u2013 click the  control to update the timeline with the full historical event data.\tTo access the History view for a file of a Workspace project, i.e. the\u00a0timeline of the project&#039;s major events relating to the file,\u00a0right-click\u00a0on the file in the\u00a0Projects\u00a0panel, then choose\u00a0the\u00a0History &amp; Version Control\u00a0\u00bb\u00a0Show File History\u00a0command from the context menu.History Timeline \u2013 OverviewThe History view presents a timeline of basic events that have occurred during the project&#039;s evolution. It can essentially be broken down into three key sections, as shown in the following image and details.Identifying the three key components of the History view.\t\t\tMain trunk of the timeline. Direction of event chronology is from the bottom up. The first event \u2013 the creation of the project \u2013 will appear at the bottom of the timeline. Subsequent events appear above, with the latest (the most current event) appearing at the top of the timeline.\t\t\t\tEvents. Each time a supported event (see below) happens in association with the project, that event is added to the timeline as a dedicated tile. Each type of event will have a different colored tile and will either be linked directly to the main trunk of the timeline or have some additional icon next to it (as is the case for MCAD Exchange events).\t\t\t\tSearch. Click the  control at the top-right of the view to access a search field that facilitates basic searching of the project history. As you type your search string, filtering will be applied to the timeline to present only the events relevant to that search. For more information, see Filtered Searching.\tSupported EventsThe timeline shows a progression of events that happen during the life of a project. Each of these events appears along the timeline as a dedicated &#039;event tile.&#039; The following expandable sections examine the range of events currently supported and presentable as part of a project&#039;s historical timeline.\t    Project Creation    Refer to: Creating a Project, Making an Existing Project Available Online\t\tWhen a project is created, the Project Created event tile will be added to the timeline. This event marks the beginning of the historical timeline for the project. As such, it can always be found as the entry at the bottom of the timeline. The tile for this event can appear in two distinct variations:\t\t\t\t\t\t\tWhen a project is newly created within the Workspace. The creator of the project is presented by name (and picture), along with the date and time of the project&#039;s creation. The description for the project is also displayed within the tile if one was entered at the time of creation.\t\t\t\t \t\t\t\t\t\t\tWhen the project is a copy of an existing project. The person who created the copied project is presented by name, along with the date and time of the project&#039;s creation. The description for the project is also displayed within the tile if one was entered at the time of copying. A link is provided to the original project; clicking this will access the detailed management page for that project through the Workspace&#039;s browser interface.\t\t\t\t \t\t\t\tThe Project Created event tile is physically connected to the main trunk of the timeline with a solid blue connection line and node: .\t\t\t    Project Commit    \t\t\tThis type of event is only supported for a project that is fully managed and stored under the Workspace&#039;s native VCS (within its Versioned Storage Git repository). For a local\u00a0project made available to the Altium 365 Workspace but not under formal version control \u2013 thereby using the Simple Sync methodology \u2013 you will not see any VCS-related commit events on the history timeline. To get this information, you can switch the style of online availability by enabling the Version Control option on the General tab of the Project Options dialog. This brings the project under the Workspace&#039;s native VCS.\t\t\t\tFor a project made available to an Altium 365 Workspace but already under external version control, you will also not see any VCS-related commit events on the history timeline. Use your external version control client to examine the project&#039;s version control history. Alternatively, you can effectively switch to Workspace&#039;s native VCS. You can create a snapshot of your project \u2013 performed most efficiently and cleanly using Altium Designer&#039;s Project Packager. This disconnects it from external VCS and from the Workspace (if already made available there), after which you can then make it available to the Workspace again, but under the Workspace&#039;s VCS \u2013 starting afresh as it were. For detailed information on how to do this, see Moving from External VCS to Workspace Native VCS.\t\tEach time you Commit a project to the Workspace (where the project is managed under the Workspace&#039;s internal Versioned Storage Git repository), a Project Committed event tile will be added to the timeline. The person who performed the commit (Save to Server) is presented by name (and picture), along with the date and time. If a comment was added at the time of the commit and pushed \u2013 using the Commit to Version Control dialog \u2013 then that will also be displayed within the tile.\t\t\t\tIf the project was a local, unmanaged project that was subsequently made available online, then the description that was entered in the Make Available Online dialog will be used in both the Project Created event tile and the initial Project Committed event tile since the project commit is performed as part of making the project available online \u2013 provided of course that the Version Control option was enabled.\t\t Example initial Project Committed event tile.\t\tThe tile also supports and presents design diffing information, showing more detailed information on what has changed between the current and previous commits. Elements supported include files, components, nets, variants, and PCB structure. The diffing section of the tile summarizes the various elements affected by the commit event, grouped by the following states:\t\t  \u2013 element added.\t\t  \u2013 element removed.\t\t  \u2013 element modified.\t\tClicking on the  control in the tile will expand this diffing section to present the affected elements by name.\t\t\t\tUse the available Show More and Show Less controls to interrogate the full listing for each element type. Click on the  control in the tile to return to the summary display.\t\tClick the  control at the tile&#039;s top-right corner to access a menu with the following commands:\t\t\t\t\t\t\tDownload Sources - use to download and open that specific revision of the PCB or Harness project in the Projects panel. The project name will include the date and time at which that revision was committed. Note that this revision is read-only; you can view it but not edit it.\t\t\t\t\t\t\t\t\t\tYou can open (for viewing only) any specific revision of the project \u2013 directly from the corresponding Project Committed event tile for that revision.\t\t\t\t\t\t\t\t\t\tCompare: Schematic to, PCB to, BOM to \u2013 allows you to compare the PCB project&#039;s Schematic, PCB\u00a0or BOM\u00a0data in this commit against that of another commit or release event. Use the sub-menu to compare against the previous commit or select from all possible releases and commits. Once the data has been chosen for comparison, the results of the comparison are presented in the associated differences view, which opens as a new tab in your default browser. For more information, see Design Data Comparisons\u00a0(Altium 365 Workspace, Enterprise Server Workspace).\t\t\t\t\t\t\tCreate Tag\u00a0\u2013 add a single, custom-named tag to any commit of a design project (and only where that project is stored in a Workspace under its internal Git VCS system).\u00a0You can create a tag only for the commit that is already saved in the Workspace.\u00a0After running the command, the\u00a0Create Tag\u00a0dialog opens. Enter the desired tag then click\u00a0Create.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAn information pop-up will open alerting you if there are illegal characters in the name of the Tag. The Tag will not be created until the illegal characters are removed.\t\t\t\tIf the project has commits that have not yet been pushed, the\u00a0Save To Server\u00a0dialog will open, asking if you want to perform a push. If the commit is pushed, the\u00a0Create Tag\u00a0dialog will open.\t\tWhen the project is released using the\u00a0Project Releaser\u00a0and its latest commit does not yet have a tag, a tag will be assigned automatically to this latest commit. This tag will be in the form of\u00a0RELEASE_, where\u00a0\u00a0is the revision number of released project sources (A.1,\u00a0A.2, etc.,), for\u00a0example,\u00a0RELEASE_A.3.\t\t\t\tTo rename or delete a tag, click \u00a0then hover\u00a0over the Tag entry. A dialog will open in which you can enter the new name of the tag. If Remove is selected, the tag is deleted immediately.\u00a0\t\t \t\t\t\tThe Create Tag command can also be accessed by right-clicking on the name of a project or document in the Projects panel and then choosing\u00a0History &amp; Version Control\u00a0\u00bb Create Tag to create a tag for the last\/latest commit.\t\t\t\tNotes:\t\t\t\t\t\t\t\t\tThere is no tag support for external version control.\t\t\t\t\t\t\t\t\t\tOnly one (1) tag per commit can be created.\t\t\t\t\t\t\t\t\t\t\t\tMake a copy\u00a0\u2013 use to create a copy from that specific revision of the project. The Create Project Copy\u00a0dialog opens in which you enter a\u00a0Project Name\u00a0(by default, this will be\u00a0the original project name with the suffix &#039; -\u00a0Copy&#039;),\u00a0Description\u00a0(which is not pre-populated), the\u00a0Folder\u00a0path (within the Workspace), and the\u00a0Local Storage\u00a0path (to the working copy). The project will be created, and a Project Copied event tile will be added to the timeline.\t\t\t\t\t\tThe Workspace Folder will, by default, be the same folder in which the original project is stored. Click   to open the Choose Folder dialog (a trimmed-down version of the Explorer panel) to change the folder as required. The Local Storage will, by default, be set to use the\u00a0location defined on the System - Default Locations page of the Preferences dialog.\u00a0Click   to open a standard Windows dialog with which to change this location as required.\t\t\t\t\t\t\tRevert to \u2013 use this command to revert to using the data from that specific revision of the project. The data from the project source documents in that specific revision overwrites the data in your local working copy of the project. Effectively, the project is momentarily closed and then reopened with that reverted data. If you want to complete the reversion and make that data the Head Revision (current version), you must commit and push the project back to the Workspace.\t\t\t\t\t\t\u00a0You can revert to any specific revision of the project directly from the corresponding Project Committed event tile for that revision.\t\t\t\t\t\t\t\t\t\tAfter reverting to a specific revision and before committing, you can restore your local working copy to the latest revision by using the Revert to command associated with the latest Project Committed event tile on the timeline.\t\t\t\t\t\t\t\t\tA Project Committed event tile is physically connected to the main trunk of the timeline with a solid blue connection line and node: . The latest revision of the project (i.e. the last commit) is distinguished by having a white fill for its node: .\t\t\t    Project Release    Related page: Design Project Release\t\tEach time you perform a release of the PCB project \u2013 using Altium Designer&#039;s Project Releaser \u2013 a Project Released event tile will be added to the timeline. The person who performed the release is presented by name (and picture), along with the date and time. If a release note was added at the time of releasing the generated data to the Workspace \u2013 through the Confirm Release dialog \u2013 then that will also be displayed within the tile. Each of the data sets included in the release will also be listed.\t\tExample Project Released event tile.\t\tClick the  control at the tile&#039;s top-right corner to access a menu with the following commands:\t\t\t\t\t\t\tDownload Sources \u2013 use this command to download and then open (in the\u00a0Projects\u00a0panel) the specific revision of the project from which this release package was generated. The project name will include the release version. Note that this revision is Read-only; you can view, but not edit it in any way.\t\t\t\t\t\t\tCompare: Schematic to, PCB to, Gerber to,\u00a0BOM to \u2013 allows you to compare the Schematic, PCB\u00a0or\u00a0BOM data in this release against that of another release or commit event. For generated Gerber,\u00a0you can compare the data for this release against that of another release or, when using an Altium 365 Workspace,\u00a0against an uploaded Gerber file set. Use the sub-menu to compare against the required data set.\u00a0Once the data has been chosen for comparison, the results of the comparison are presented in the associated differences view, which opens as a new tab in your default browser. For more information, see\u00a0Design Data Comparisons\u00a0(Altium 365 Workspace, Enterprise Server Workspace).\t\t\t\t\t\tAs a release of a project is a very significant event, the Project Released event tile is made more prominent \u2013 rather than just a &#039;connected&#039; event, it straddles the timeline as a &#039;major&#039; event.\t\t    Copying a Project    Each time you copy the project, either through the Workspace&#039;s browser interface or from within Altium Designer \u2013 a Project Copied event tile is added to the timeline. The person who performed the copy is presented by name, picture, and date and time. If a description was added at the time of copying through the Clone Project window (browser-based) or Create Project Copy\u00a0dialog (Altium Designer), it will also be displayed within the tile. A link is provided to the copied project. Clicking it will access the detailed management page for that project through the Workspace&#039;s browser interface. Example Project Copied event tile.\tThe main Make a copy commands are available from within Altium Designer (right-click on the entry for the project in the Projects panel or from the Projects page of the Workspace&#039;s browser interface), acting on the latest (or Head) revision of the project. When accessing the History view for the project through the Workspace&#039;s browser interface, you also have the ability to copy a specific revision of that project. To do so, locate the Project Committed event tile for the required revision of the project, then click the\u00a0 control at the tile&#039;s top-right corner. From the subsequent menu, choose the Make a copy\u00a0command.\tThe Project Copied event tile is physically connected to the main trunk of the timeline with a dotted green connection line and unfilled node: .\t\t\t    MCAD Exchanges    Related page: Altium MCAD CoDesigner\t\t\t\tWhen working between the electronic and mechanical design domains, the Workspace acts as the bridge between the two \u2013 facilitating direct ECAD-MCAD codesign. Whenever changes are made to the project&#039;s PCB design and those changes are pushed to the Workspace through the relevant CoDesigner panel, an MCAD Changes Suggested event tile will be added to the timeline. The person who performed the push is presented by name (and picture), along with the date and time. If a message was posted at the time of pushing \u2013 through the MCAD CoDesigner panel (Altium Designer), or Altium CoDesigner panel (in the supported MCAD software) \u2013 then that will also be displayed within the tile.\t\t\t\t\t\t\tOnly Push events are currently supported.\t\t\t\t Example MCAD Changes Suggested event tile.\t\t\t\tWhen the MCAD engineer makes changes to the PCB in their supported MCAD software and pushes them back to the Workspace, the corresponding push event will be available on the project&#039;s history timeline only after pulling the changes from the Workspace into Altium Designer.\t\t\t\tExample showing two MCAD-related events. On the left of the timeline&#039;s trunk, the push event from the ECAD side, while on the right, the push event from the MCAD side.\t\t\t\t\t\t\tThe MCAD Changes Suggested event tile is not physically connected to the main trunk of the timeline. Instead, a directional arrow symbol is used, which points towards the trunk: .\t\t\t\t\t\t\t\t    Local Changes    When there are PCB project documents saved locally but to the Workspace yet,\u00a0a Local Changes\u00a0event tile will be added at the top of\u00a0the timeline. The person who performed the local save (i.e. the current user) is presented by name (and picture).\t\t\t\t \t\t\tExample Local Changes event tile.\t\t\t\tClick the  control at the tile&#039;s top-right corner to access a menu with the following command:\t\t\t\t\t\t\t\t\t\t\tCompare: Schematic to, PCB to, BOM to \u2013 allows you to compare the locally saved Schematic, PCB,\u00a0or BOM\u00a0data in this commit against that of a commit or release event. Use the sub-menu to compare against the previous release&#039;s source data, previous commit&#039;s source data, or select from all possible releases and commits. Once the data has been chosen for comparison, the results of the comparison are presented in the associated differences view, which opens as a new tab in your default browser. For more information, see Design Data Comparisons\u00a0(Altium 365 Workspace, Enterprise Server Workspace).\t\t\t\t\t\t\t\t\t\tThe Local Changes\u00a0event tile is not physically connected to the main trunk of the timeline. Instead, a dotted circle symbol is used: .\t\t\t\t\t\t\t\tFiltered Search\tClick the  control at the top-right of the view to access a search field with which to quickly find events of interest along the timeline. The search facility supports basic searching of the project history, with dynamic filtering applied as you type your search string \u2013 leaving only the events relevant to that search displayed on the page. The matching text within an event tile is highlighted.\t\t\t\tThe search facility is not case-sensitive.\t\tExample search of a project&#039;s history. The timeline is dynamically filtered as you type your (case insensitive) search term, with matching entries highlighted within each relevant event tile.\t\t\t\tA box is provided above the filtered selection that summarizes how many events are currently being shown, along with controls to quickly remove the filter\/search string.\t\tThe search facility works with the following information:\t\t\t\t\t\t\tEvent tile title.\t\t\t\t\t\t\tPerson&#039;s name who performed the event.\t\t\t\t\t\t\tDescriptive text (the text sourced from a comment\/note\/description when the relevant event occurred).\t\t\t\t\t\t\tDiffing data text \u2013 in a Project Committed event tile.\t\t\t\t\t\t\tData set name \u2013 in a Project Released event tile.\t\t\t\t\t\t\tProject name \u2013 in a Project Copied event tile and Project Created event tile (when created through copying).\t\t\t\t\t\tTo clear the current filtering and return to the full timeline, clear the search field \u2013 either by selecting the current text and pressing the Backspace key or by clicking the  control at the far right of the field. Alternatively, click on either the Clear Filter control in the box summarizing how many events are being shown (at the top of the view).\t\tUpdating with New Events\tWhenever a supported event happens in relation to the project, that event will be detected and made available to the History view automatically. Notification will appear at the bottom of the view shortly after the event takes place \u2013 click the  control to update the timeline with the new event.\t\t\t\tA manual refresh is also provided by clicking the  control at the top right of the view.\t\tCreating a Project History Report\tA Project History report in PDF format can be created for a Workspace project. The report displays all information about the history of the project including creation, commits, and releases, as well as a description of changes from the previous event. You can also set the time period for the report (described below) so you will get the definitive report you need.\t\t\t\tFrom an OutJob\tTo create the report, in the OutputJob file\u00a0(*.OutJob), right-click on the\u00a0[Add New Report Output] associated with the\u00a0Report Outputs\u00a0entry then choose Project History, as shown below.\t\t\t\tConnect the newly-created report to a PDF output container.\u00a0Set the time period for the report by right-clicking on the created output then select\u00a0Configure. Enable the desired time Period: For all time (from the creation of the project to the present), or Specific releases (use the From\/To field drop-downs to set the desired releases. The exported report will contain the information for the time period you selected.\t\t\t\tAfter your report has been created, linked to a PDF output container, and configured, in the PDF container region, click Generate content,\u00a0or if desired, you can generate the project history report as part of the project release process.\t\tFrom the Reports Menu\t\t\tThe Project History can be exported to a PDF by choosing\u00a0Reports\u00a0\u00bb Project History\u00a0from the main menus. The\u00a0Project History Report Configuration\u00a0dialog opens where you can set the\u00a0Period\u00a0for which the report should be exported:\u00a0either the entire project history or from\/to a specific (or the latest) project release. Click\u00a0Export\u00a0then enter a name for the exported PDF in the\u00a0Explorer\u00a0window that opens then click\u00a0Save. The PDF report opens in a\u00a0browser.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-project-history.html"},
{"title":"Sharing a Design","text":"Since the essence of collaboration is multiple people working together to achieve a common outcome, an essential collaboration factor is the ability to provide and manage access to that common element \u2013 in this case, a design project and its associated data. The\u00a0Workspace delivers this capability with controlled permission-based sharing of a project design \u2013 in its current work-in-progress (WIP) state \u2013 or as a fixed snapshot of the design at that time.Note that a newly created project, or one made available in the Workspace, is shared with the following by default:\t\t\tThe Owner of the project, which is usually the designer who created it (or made it available in the Workspace): with full (Read\/Write) access permissions.\t\t\t\tThe Administrators role: with full (Read\/Write) access permissions.\tThe following levels of sharing are supported from within Altium Designer:\t\t\tSharing of a live design \u2013 the work-in-progress (WIP) design itself, which can be shared:\t\t\t\t\t\t\t\t\tWith other members of your Workspace team \u2013 for editing and\/or viewing. An invited team member can view the design through Altium Designer or through the team&#039;s Workspace. Editing is performed only through Altium Designer. The invited team member must be registered with AltiumLive and have an active Altium Designer license subscription.\t\t\t\t\t\t\t\t\t\tWith people outside of your Workspace team \u2013 for viewing or editing, through email invite. This capability is available only when connected to an Altium 365 Workspace. This type of sharing allows invited stakeholders to view\/edit (as applicable) a live, work-in-progress design project, without gaining access to your full Workspace or design data. The invited person must be registered with AltiumLive, and can access the shared design from their Altium 365 Personal Space (or their organization&#039;s Workspace, if available), or open it in Altium Designer.\t\t\t\t\t\t\tIf granted viewing access only, the invited stakeholder can view and comment on the design from within Altium Designer, or through their Altium 365 Workspace interface. As people with editing rights make changes to the design and commit them, those changes can be viewed &#039;live&#039; by those external people. To view the shared design through the browser interface, from anywhere, all that&#039;s needed is registration with AltiumLive to gain access.\t\t\t\tIf the invited stakeholder has been granted editing rights to the design, then they can open and edit it from within Altium Designer \u2013 perfect for external contractors.\t\t\t\t\t\t\tNote that sharing live WIP designs with those outside of your Workspace team is possible when connected to an Altium 365 Workspace, and not when using an Enterprise Server Workspace. You can, however, share a design Snapshot for viewing and downloading with someone outside of your Workspace team (see below).\t\t\t\t\t\t\tAltium Designer provides additional features that complement design collaboration through Workspace project sharing, including Document Commenting and Collaborators Conflict Prevention.\t\t\t\t\t\tSharing of a design &#039;snapshot&#039; \u2013 a static snapshot of the design at a particular point in time and shared:\t\t\t\t\t\t\t\t\tBy link \u2013 available to anyone through a browser. Shared design access at this level requires neither active subscription for your Altium Designer licensing, nor registration with AltiumLive. A recipient of the shared link opens the Standalone Altium 365 Viewer to view (but not comment) on the design. Viewing requires no registration with AltiumLive and the link is available for 48 hours.\t\t\t\t\t\t\t\t\t\tWith specific people \u2013 available to specified people through email invite. Shared design access at this level requires registration with AltiumLive, but does not require active subscription for Altium Designer licensing. A recipient accesses the design snapshot through the Altium 365 Platform Workspace interface Web Viewer from their email invitation. Viewing requires registration with AltiumLive, but the snapshot is available permanently. Commenting on the design is also available.\t\t\t\t\t\t\tNote that a design Snapshot shared in this way is essentially read-only. It can be downloaded or viewed in an Altium 365 Workspace, but unlike a shared WIP design, it cannot be opened for viewing\/editing in Altium Designer.\t\t\t\t\t\t\tIf the recipient of a design (or design snapshot) shared with them through the Altium 365 platform does not have an AltiumLive account, they will need to register for one first \u2013 a link is provided on the Altium 365 Sign In page.\t\t\t\t\t\t\t\t\tFor more information on uploading a design snapshot from within the Altium 365 Platform Interface and then sharing with others, see Sharing Design Snapshots.\t\t\t\t\t\t\tFor more information on sharing an actual live design with non-team members while viewing the design in your browser, see Sharing Live Designs outside of the Workspace.\t\t\t\t\t\t\tFor more information on sharing a project from within the Workspace&#039;s browser interface, see\u00a0Sharing a Project (Altium 365 Workspace,\u00a0Enterprise Server Workspace).\t\t\tAccessing Sharing ControlsControls for sharing a design from within Altium Designer can be found in the Share dialog \u2013 accessed in the following ways:\t\t\tFor the active project \u2013 by clicking the  button at the top-right of the main application window, or by choosing the Project \u00bb Share command from the main menus.\t\t\t\tFor the focused project in the Projects panel \u2013 by right-clicking on the entry for the project and then choosing the Share command from the context menu.\t\t\t\tWhen\u00a0commenting a design document, by posting a comment with a mentioned\u00a0user that does not have\u00a0access to the current project.\t\tIf there is no active project \u2013 i.e. no project document currently open \u2013 then the  button will act on the currently focused project in the Projects panel.\tAccessing the Share dialog \u2013 command central for sharing a design from within Altium Designer.\t    Pre-sharing Preparation    In order to be able to share a live WIP design through an Altium 365 Workspace:\t\t\t\t\t\t\tYou must be signed in to your Altium account (using your AltiumLive credentials).\t\t\t\t\t\t\tYou must have an active (valid) Altium Subscription for your Altium Designer licensing.\t\t\t\t\t\t\tYou must be connected to your Altium 365 Workspace.\t\t\t\t\t\t\tThe design project must be registered with (made available to) the Workspace.\t\t\t\t\t\t\tYou must have permissions to share the project.\t\t\t\tIn order to be able to share a WIP design through an Enterprise Server Workspace:\t\t\t\t\t\t\tYou must have an active (valid) Altium Designer license.\t\t\t\t\t\t\tYou must be connected to your\u00a0Workspace.\t\t\t\t\t\t\tThe design project must be registered with (made available to) the Workspace.\t\t\t\tIn order to be able to share a design Snapshot through a Workspace:\t\t\t\t\t\t\tYou must be connected to your Altium Workspace.\t\t\t\t\t\t\tThe design project must be registered with (made available to) the Workspace.\t\t\t\t\t\t\tA recipient of a shared Snapshot Link requires a standard browser only.\t\t\t\t\t\t\tA recipient a Snapshot specifically shared with their name needs to be:\t\t\t\t\t\t\t\t\t\t\t\tregistered with and signed in to AltiumLive.\t\t\t\t\t\t\t\t\t\t\t\t\tconnected to their Altium 365 Personal Space.\t\t\t\t\t\t\t\t\t\t\tThe Share dialog will present guidance in order to properly prepare you for sharing your chosen design project. The following are examples of this when sharing with an Altium 365 Workspace (a similar set of relevant advice dialogs are presented when working with an Enterprise Server Workspace):\t\t\t\t\t\t\tIf not signed in to your Altium account, the dialog will present a link to do so (to access the Sign In dialog), or to register with AltiumLive, if you don&#039;t yet have credentials. You will typically connect to a Workspace (if you have one) once signed in to your account, and if that Workspace has been set as the default.\t\t\t\t\t\t\t\t\t\tIf you are signed in to your Altium account and are attempting to share an open project that is not registered with a Workspace (i.e. it is a local or VCS project), and you don&#039;t have a Workspace available to you, the dialog will present a control to activate the Workspace for your company.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIf you are signed in to your Altium account and are attempting to share an open project that is registered with a Workspace, and you are not currently connected to that Workspace, the dialog will present a control to connect to that specific Workspace, or switch to it if currently connected to a different Workspace.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIf you are signed in to your Altium account and are attempting to share an open project that is not registered with a Workspace (i.e. it is a\u00a0local or VCS project), and you are not currently connected to a Workspace, the dialog will present a list of all Workspaces available to you, prompting you to select which Workspace to register the project with.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIf you are already connected to a Workspace, then that will be used as the target in which to register the project. Note that the project will be made available in the target Workspace at the time the project is shared with nominated people.\t\t\t\t\t\t\t\t\t\tIf you are signed in to your Altium account, are attempting to share an open project, and don&#039;t have permission to do this, the dialog will show you the message stating this fact. This could happen if you don&#039;t have editing rights for this project or if a Workspace administrator or the project owner restricted the re-sharing ability for editors inside and\/or outside the Workspace.\t\t\t\t\t\t\t\t\t\t\t\t\tSharing a Live DesignWith a design project registered with (made available to) an Altium 365 Workspace, you have the ability to share that design with other people. This can be to other members of your Workspace team, or to people outside of the team. To share in this manner, click to select the  entry, on the left side of the Share dialog.\tWorkspace team Administrators can always share a project with others for either editing or viewing. Non-administrative members of the Workspace team, or users with whom a project has been shared with outside of the Workspace team, can share a project with others for editing or viewing, depending on the level of access they themselves have. So if they have editing rights, they can share with others for either editing or viewing. If they only have viewing rights, then they can only share with other users for viewing and commenting.Accessing the controls to share a live\/WIP design with others. Note that the image shows the case for a project already available in a connected Workspace.Use the Copy Link control to copy a direct link to the project that can be used by those who already have access to the project to open the project in the Workspace&#039;s Web Viewer.Sharing with New PeopleWith preparation complete, a project selected, and a target Workspace connected, you can proceed to specify which person (or people) the project is to be shared with. To check who already has access to the project, click on the Shared with control. The region will expand to show with whom the project is shared and whether they have editing rights (Can Edit), or can view and comment on the project only (Can View).\tCheck with whom the project is currently shared by clicking the Share with field. Hover over the image to see the result.You can share the project with anyone \u2013 other AltiumLive users from within your own organization, AltiumLive users from different organizations, and non-AltiumLive users (who will need to then register for AltiumLive accounts). Note that when connected to an Enterprise Server Workspace, you can share the WIP project with registered users of that Workspace only \u2013 for sharing externally, see Sharing a Design Snapshot or the sharing approach available in your Altium 365 Personal Space.To add an entry, begin typing the desired name\/email\/role in the field so the matching user\/role can be selected from the dynamic list \u2013 which will only contain filtered users in your Workspace team or within your organization, and existing roles defined for the Workspace. Multiple users\/roles can be chosen. To remove an entered user\/role, click the  control associated with the entry.\tTo share with a person outside of your organization \u2013 irrespective of whether they have an AltiumLive account or not \u2013 you must enter their full email address and press Enter.Set the sharing access permissions for the added people\/roles from the associated drop-down menu by selecting Can View () or Can Edit (), where the latter option inherently includes viewing capability. The setting initially applies to all entries (people\/roles) included in the field. Use the optional note field to include information that relates to the sharing arrangement for this project.\tWorkspace team Administrators can always share a project with others for either editing or viewing. Non-administrative members of the Workspace team can share a project with others for editing or viewing, depending on the level of access they themselves have.Additional sharing permissions are available to administrators and the project owner in the Share dialog. Use the\u00a0Advanced Settings options to specify the re-sharing and download rights for users that the design is to be shared with.Only those shared users with Edit permissions applied can re-share a project with others. Additional control of this sharing is available from the Sharing Settings dialog&#039;s Who can share the project options:\t\t\tEditors in the Workspace \u2013 allow Workspace team members that have Edit rights for the shared design to re-share it with others.\t\t\t\tEditors outside the Workspace \u2013 allow non-Workspace team members that have Edit rights for the shared design to re-share it with others.\tAll shared users with Edit rights can download the project&#039;s design files. For users with View (read-only) share permissions, the ability to download files is set by the dialog&#039;s Who can download files options:\t\t\tViewers in the Workspace \u2013 allow Workspace team members that have View rights for the shared design to download design files.\t\t\t\tViewers outside the Workspace \u2013 allow non-Workspace team members that have View rights for the shared\u00a0project to download design files.\tWhen connected to an Enterprise Server Workspace, the Sharing Settings dialog includes options that define\u00a0re-sharing and download rights for the Workspace members only:\t\t\tEditors can share \u2013 allow Workspace team members that have Edit rights for the shared design to re-share it with others.\t\t\t\tViewers can download \u2013 allow Workspace team members that have View rights for the shared design to download design files.\tWith target recipient(s) defined and access rights specified, click the  button to proceed with sharing the project. The dialog will present a message that the project has been shared successfully. From here, you can click the Who has access control to return to the list of users who have access to the project, click the\u00a0\u00a0button to copy the direct link to the project, or simply close the dialog by clicking OK.Sharing with a non-Team Member\tWhen connected to an Enterprise Server Workspace,\u00a0a WIP design cannot be shared with those that are not registered users of that Workspace (non-team members). For sharing externally from an Enterprise Server Workspace, see Sharing a Design Snapshot, or the Upload sharing approach available in your Altium 365 Personal Space.If you attempt to share an Altium 365 Workspace project with a person outside of the team, the Confirm\u00a0dialog will appear that warns you that the user will have access to the source documents of the project being shared, placed comments and release packages. Click OK\u00a0to proceed with sharing the project.You can share a project with anyone outside of the Workspace team, for editing or viewing.\tSharing with a user outside of the Workspace team for editing is perfect for contractors \u2013 where you want them to actively work on the design, but without bringing them into your team.Sharing a Local ProjectIf you are sharing a\u00a0local project (not under external VCS), the project will be made available in the currently connected Workspace at the time the project is shared with the nominated people. What actually happens depends on whether you are sharing for viewing or editing:\t\t\tWhen sharing for viewing only (and connected to an Altium 365 Workspace) \u2013 the project is made available through Simple Sync. Under this mode, the design project can be edited by a single person only (the owner of that project). The strength of Simple Sync comes when you do not want anyone else editing your design, but where you do want to take advantage of Altium 365&#039;s Global Sharing paradigm, and be able to share that design with multiple other people for viewing and commenting. For more information on this functionality, see Mirroring a Project in the Workspace Using Simple Sync.\t\t\t\tWhen sharing for editing \u2013 the project needs to be added to the Workspace&#039;s Versioned Storage Git design repository. Under this mode, multiple people can be shared the project for editing, as well as being able to utilize Altium 365&#039;s Global Sharing support for shared viewing and commenting. A dialog will be presented alerting you to this and giving you the Use Altium 365 VCS\u00a0option to do so. Click\u00a0Learn More\u00a0to access the\u00a0Sharing page, which will help guide you through project sharing.\tWhen sharing a local project (not under VCS) with a person for editing, the project will need to be brought under version control by addition to the Workspace&#039;s Versioned Storage Git design repository.\tIf the local project is already under version control (in an external design repository) it will remain under the external VCS design repository, and not be added to the Workspace&#039;s own built-in VCS (Git) design repository. In this case,\u00a0Simple Sync (mirroring) applies, but of course multiple collaborators can continue to work on\/edit the design, since it is under VCS.\t\tHowever, the full functionality delivered through the Altium 365 platform \u2013 or more specifically an Altium 365 Workspace \u2013 can only be experienced by having your project fully\u00a0stored under the Workspace&#039;s native VCS (within its Versioned Storage Git repository). What you can do is migrate your project from using the external VCS system to the Workspace&#039;s native VCS system Altium Designer&#039;s built-in VCS repository migration feature.\t\t\u25ba For information on this, see Moving from External VCS to Workspace Native VCS.\t\t\t\t\t\t\tWhen connected to an Enterprise Server Workspace, a local project to be shared with another Workspace user is automatically added to the Workspace&#039;s VCS. The now Workspace project will be shared with the specified Workspace user with View or Edit rights, as was selected in the Share dialog.\t\t\t\t\t\t\tNote that an Enterprise Server Workspace cannot share a WIP project with anyone who is outside of the Workspace team \u2013 who is not a registered User of the Workspace.\t\t\tSharing ResultWhat happens next depends on the type of user being invited:\t\t\tA user that is already part of your Workspace Team will be added to the sharing access list for the project directly, and they will receive an email notifying them that the project has been shared with them. They can open the project in Altium Designer, or access it through the Workspace interface (from the Projects page).\t\t\t\tWhen an existing Role for the Workspace is added it will appear on the access list for the project, and all members of the role will receive an email notifying them that the project has been shared with them. They can open the project in Altium Designer, or access it through the Workspace interface (from the Projects page).\t\t\t\tWhen using an Altium 365 Workspace for sharing with a person outside of your Workspace team, they will be added to the sharing list and will receive an email notifying them that the project has been shared with them. They can open the project in Altium Designer from the Shared with Me option, or access it through their Altium 365 Platform Personal Space Interface (from the Shared with Me page). Their received email provides direct access to the design through Altium 365. Once they click the  button in the email they will be taken to the Altium 365 Sign In page (unless already signed in to the platform, or their AltiumLive account). Upon signing in, they will be taken to the Web Viewer directly, with the shared design loaded.\t\t\t\t\t\t\tYou cannot share a WIP design outside of the team (external users) when connected to an Enterprise Server Workspace. However:\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor sharing externally from an Enterprise Server Workspace, see Sharing a Design Snapshot.\t\t\t\t\t\t\t\t\t\t\t\t\tAlso, you can upload a design for sharing to your Altium 365 Personal Space. Once shared with another user with an AltiumLive account, they can access the project through both Altium Designer (Shared with Me) and the Web Viewer available in their own Personal Space.\t\t\t\t\t\t\t\t\t\t\tIf the person does not have an AltiumLive account, they will need to sign up for one first \u2013 a link is provided on the Altium 365 Sign In page.\tAccessing a shared live design from the email invite received by the user that is not a member of the Workspace Team.Modifying Access Rights for Existing PeopleAt any time, an Administrator (or Workspace team member with editing rights) can modify the existing access permissions for a project. To access the list of existing shared people and roles for a project click the  entry on the left side of the Share dialog, then expand the Shared with field on the right.Accessing the list of people and roles who currently have shared access to the project.Things to be aware of:\t\t\tIn terms of permissions, a person\/role has full editing access to the project when the Can Edit option () is selected. Otherwise, they have View-only access ().\t\t\t\tThe Owner and the Administrators role always have full editing access (Can Edit).\t\t\t\tWith the exception of the Owner and Administrators role, permissions for all included people\/roles may be individually set as Can View or Can Edit, or access rights completely removed. Also, project ownership can be transferred to another user (see below). Click on the current permission state to access controls.\t\t\t\t\t\t\t\t\t\tA project may be explicitly shared with specific people and\/or roles, or simply shared with all members of the Workspace team. For the latter, set the required access for the Workspace Members\u00a0entry. To not share the project with the entire team, set this entry to None.\tMake changes to access permissions as required. Each changed entity is highlighted in the list with a darker background.Example changes to the permissions for two existing people with which a project is currently shared.To affect changes, click the  button. The changes will be applied, with confirmation reflected through the dialog. To see the updated list of shared access, click the Who has access link.After saving permission changes, you can view the updated result directly through the Share dialog.\t\t\t\t\t\tNote that the sharing of a project with another user can be revoked at any time by choosing the Remove option for that user in the Share dialog.\t\t\t\t\t\t\tAlso note that if you are changing permissions to Can Edit for someone outside of the Altium 365 Workspace team, you will be alerted \u2013 through the Sharing Outside of the Workspace dialog \u2013 to confirm whether to give them view-only rights, or editing rights.\t\t\tTransferring Project OwnershipAdministrators\u00a0and Owners are able to transfer ownership to another user using the\u00a0Owner\u00a0option from the current permission state drop-down. The option can be used by the current project owner or a Workspace Administrator.\tOwnership can be transferred to another Workspace member only. Transfer to a non-Workspace user is not available.When selecting the Owner option for a user, the Transfer Ownership dialog will open. Click Yes to process.The changes of permissions for the current owner and the\u00a0transferee will be reflected in the dialog. Click Save to proceed with the changes.\tWith the transfer, access rights for the current owner are assigned as follows:\t\t\t\t\t\t\tEdit rights are transferred\u00a0if the project is under version control.\t\t\t\t\t\t\tView rights are transferred\u00a0if the project is under SimpleSync.\t\t\tThe user to which ownership is transferred will receive an email notification.Accessing a Shared Live DesignAccess to a project shared with a user depends on whether that user is a member of the Workspace team, or is outside of the Workspace team.Workspace Team MemberFor a member of the Workspace team, they can access the shared project through Altium Designer, or through the Projects page of the Workspace&#039;s interface. Note that editing of the project \u2013 if they have editing rights \u2013 is only possible through Altium Designer.Within Altium Designer, access the project using the File \u00bb Open Project command or the ellipsis button associated with the Workspace entry in the Projects panel. The Open Project dialog will appear, from where you can choose which Workspace project to open from your connected Workspace \u2013 when connected to a Workspace, that Workspace will appear in the Locations region of the dialog, distinguished by the  icon, and appearing with the name given to the Workspace. Only those Workspace projects that have been shared with you (and you have permission to access) will be listed.Once opened, the project will appear under an entry for the Workspace, in the Projects panel. Choose which Workspace project to open from your connected Workspace, from within Altium Designer, from those currently shared with you.\tYou have the option to open the project to the default checkout path, or use the  drop-down menu to specify a custom path. The default checkout path is taken from the Document Path field on the System \u2013 Default Locations page of the Preferences dialog.\tWhen browsing the project through Altium Designer&#039;s Explorer panel \u2013 configured in its default Project View rather than Classic View \u2013 click the  button, at the top-right of the panel, to open the project in Altium Designer (adding it to the Projects panel). Use the  button to open the project for viewing the connected Workspaces browser interface.Invited Stakeholder Outside of the Workspace TeamFor a person outside of the Altium 365 Workspace team with whom the project has been shared, they can access that project through Altium Designer or through the Altium 365 Platform Interface (from the Shared with Me page). To open the project, select the design&#039;s tile and click on the project name, or choose the Open option from the tile&#039;s ellipsis menu. Alternatively, double-click directly on the tile. Note that editing of the project \u2013 if they have editing rights \u2013 is only possible through Altium Designer.\tA WIP Project design cannot be shared outside of the team (to external users) when using an Enterprise Server Workspace.\t\tHowever, if you are the recipient of a design that has been shared with you from a member of an Altium 365 Workspace, it will be available In Altium Designer from the Shared with Me location as described below \u2013 and also available for viewing in your Personal Space.\tWithin Altium Designer, access the project using the File \u00bb Open Project command. The Open Project dialog will appear, from where you can choose which Workspaece project to open from the Shared With Me location.Once opened, the project will appear under the entry Shared with me, in the Projects panel. What you can do with the project depends on the access rights you have been given to it. If editing rights were assigned to you, you will be able to edit the design normally, which would typically be the case for an external contractor \u2013 since the design is shared from a Workspace, design changes are synchronized in both directions. If you are restricted to viewing rights, you still will be able to comment on the WIP design.Choose which Workspace project to open, from within Altium Designer, from those currently shared with you as an external stakeholder. Note that access is made to such projects without having access to the Workspace.\tYou have the option to open the project to the default checkout path, or use the  drop-down menu to specify a custom path. The default checkout path is taken from the Document Path field on the System \u2013 Default Locations page of the Preferences dialog.Sharing a Design SnapshotCreating a read-only snapshot of a design allows you to quickly share that design \u2013 at that specific point in time of the project&#039;s development \u2013 for wider collaboration with others through the Web. This can be useful for an on-the-fly design review, sharing a particular design milestone, or even to stimulate contextual discussion. To share in this manner, click to select the  entry, on the left side of the Share dialog.Accessing the controls to share a snapshot of a design.\tAny user who is currently viewing a project within Altium Designer can share a snapshot of that design.Sharing by LinkBy default, the dialog is set to Share By Link, meaning that anyone who is given the link will have access to view the design snapshot through their browser for a time-limited period of 48 hours. Commenting on the design is not possible with this level of sharing.\tThis level of sharing does not require you to be signed in to your Altium account within Altium Designer.\tNote that design snapshots shared by a link may be indexed by search engines and available to its users.Click the  button to generate the link to the design snapshot. In the background, the project itself is packaged into a Zip archive using Altium Designer&#039;s Project Packager. Once the link is ready, click the  button to copy it, and then share with the required people as needed.Generating the time-limited link that can be shared with anyone, anywhere.When the recipient of the link opens it in a Browser they will be taken to an instance of the Altium 365 Viewer \u2013 on the main altium.com site \u2013 with the design processed and loaded.Using the shared link, a recipient can browse the design snapshot using Altium 365 Viewer, loaded on the main altium.com site. Shown here is a schematic \u2013 hover over the image to see the PCB.\tWhen the design (in the Zip archive) is uploaded to the Altium 365 Viewer, it is removed as soon as it is processed. As a result, viewing of the design is time-limited \u2013 available for the duration of your browser session (and no longer available if you close your browser tab). Alternatively, use the link again, at any time during the permitted period of 48 hours.Sharing with Specific PeopleClicking the Share with specific people control will switch the sharing mode (for sharing a design snapshot) to allow you to share with one or more specific people \u2013 by email invitation. Recipients will have access to view, share or download the design snapshot through the browser-based Altium 365 Platform Interface. Such a design snapshot is available permanently through the platform and commenting on the design is possible with this level of sharing.\tThis level of sharing requires that you be signed in to your Altium account within Altium Designer (using your AltiumLive account credentials). If you are not currently signed in to your Altium account the dialog will present a link to do so (to access the Sign In dialog), or to register with AltiumLive, if you don&#039;t yet have credentials.Switch mode to be able to share a design snapshot with specific people on a permanent basis.Enter the full email of a person with whom you want to share the snapshot and press Enter. Multiple people can be specified in this way, as needed. You can also add an optional note \u2013 to let them know anything pertinent about this specific snapshot being shared.Example sharing of a design snapshot with a specific person, by email.\tUse the Share dialog&#039;s Advanced Settings options to specify the permissions applied to the shared project Snapshot. Select Allow sharing to allow the project snapshot to be re-shared by the specified person, and the Allow downloading option to enable downloading of the (zipped) snapshot.Once ready, click the  button. The project itself is packaged into a Zip archive using Altium Designer&#039;s Project Packager, then uploaded to the Altium 365 platform. Confirmation of upload is provided once the process completes.The shared snapshot is packaged and then uploaded to the Altium 365 platform, where it is available on a permanent basis.The person with whom you shared the uploaded design snapshot will receive an email invite to access that snapshot through Altium 365. Once they click the  button in the email they will be taken to the Altium 365 Sign In page (unless already signed in to the platform, or their AltiumLive account). Upon signing in, they will be taken to the Web Viewer, with the shared design snapshot loaded.\tIf the person does not have an AltiumLive account, they will need to register for one first \u2013 an account creation form is provided when the Altium 365 link is opened.Accessing the design snapshot from the email invite received by the user with whom the snapshot was shared.Accessing a Shared Design SnapshotIn addition to following the link in their email invite, a person with whom a permanent design snapshot has been shared will be able to access (open, share and view) that snapshot at any time from the Shared with Me page of the\u00a0 Altium 365 Platform Interface. A design snapshot is denoted by the  icon within its tile.To open in the integrated Viewer, select the design&#039;s tile and click on the project name, or choose the Open option from the tile&#039;s ellipsis menu. Alternatively, double-click directly on the tile. Note that a shared design snapshot is not able to be edited and is therefore not accessible to Altium Designer through the Shared With Me location in the Open Project dialog \u2013 it can, however, be downloaded if it has been shared with that permission enabled.Accessing a design snapshot from the Shared with Me page of the Altium 365 Platform Interface. In this example a Comment has been placed in the shared design.\tThe person who originally shared the design snapshot \u2013 uploading it permanently to the Altium 365 platform \u2013 will also be able to access that snapshot from the Files page of their Personal Space.Disabling SharingTo disable sharing completely, uncheck the Altium Cloud option, on the System \u2013 Network Activity page of the Preferences dialog. If you attempt to share a design through the Share dialog \u2013 either live, or as a snapshot \u2013 a Warning dialog will appear, alerting you to the fact this option has been disabled.\tDisabling connectivity to the Altium Cloud will prevent sharing of design projects.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-sharing-design.html"},
{"title":"Document Commenting","text":"When integrated with a connected Workspace, Altium Designer projects enable a dispersed design team to work collaboratively on centrally stored and managed projects. The design interface supports commenting on various design documents to enhance the design collaboration process. Comments, i.e., user-added notes,\u00a0can be placed in documents and replied to by other users.\tThe Comments and Tasks\u00a0panelPlaced comments are available in real-time to collaborating users (those that have shared access to the document)\u00a0and are saved to the server independently of the project without altering its constituent documents in any way. The commenting feature is managed through the Comments and Tasks panel.\u00a0When a comment entry is selected in the Comments and Tasks panel, the system will open (and load, if necessary) the associated design document.The Comments and Tasks panel allows you to add comments to a defined area or point in the active document of a Workspace project and assign these comments to Workspace members, essentially creating tasks for them. The panel allows all users who are working on the document to add comments and view all comments without actually modifying the document itself. This feature allows for the facilitation of strong collaboration processes and is invaluable when issues within the document need to be pointed out without physically merging and receiving conflicts. The Comments and Tasks panel can essentially be used to create a &#039;to-do&#039; list, and\u00a0as the design matures,\u00a0the comments can be resolved and closed.\u00a0Placed comments are available in real-time to collaborating users \u2013 those that have shared access to the document \u2013 and are saved to the Workspace independently of the project without altering its constituent documents in any way.\tIf you do not have access to\u00a0the functionality for creating and managing tasks,\u00a0this functionality will not be available, and the panel will be named Comments.\t\tFor information on Projects from a Workspace perspective, see Workspace Projects (Altium 365 Workspace, Enterprise Server\u00a0Workspace).Note that comments and tasks can be added and managed in both Altium Designer and in the related Workspace via its browser interface design view. The functionality of the two commenting systems is essentially the same, and since both the project and commenting data are stored in the Workspace, the systems work together in real time.See Commenting in the Web Viewer (Altium 365 Workspace, Enterprise Server Workspace) for detailed information on the commenting system in a Workspace&#039;s browser interface.Where Commenting is SupportedSchematicA comment can be applied to an object, a specific point, or an area in a schematic document.PCBA comment can be applied to an object, a specific point, or an area in a PCB document (in 2D layout mode) \u2013 .\tNote that focusing a comment in a PCB document will auto-switch to the same view the reviewer had (visible layers, active layer, top\/bottom view).\u00a0An example of view configuration switch when focusing a comment is shown below.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\t\t\tJavascript ID: PCB_LayerSpecificComments_AD23\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe view configuration before focusing on a comment: all signal layers are enabled, Bottom is the active layer, and the board is shown from the bottom side.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe board after focusing on a comment (the same view is applied as it was when the comment was added): Top is the only signal layer enabled, Top is the active layer, and the board is shown from the top side.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tDraftsmanA comment can be applied to a specific point or an area in a Draftsman document of a PCB or Harness Design project \u2013 .Harness Wiring Diagram and Layout Drawing\tComments in Harness Wiring Diagram and Layout Drawing documents are available when the Harness.Comments option is enabled in the Advanced Settings dialog.\tA comment can be applied to an object, a specific point, or an area in a Wiring Diagram or Layout Drawing document of a Harness Design\u00a0project.Multi-board Schematic\tComments in Multi-board Schematic documents are available when the MBS.Comments option is enabled in the Advanced Settings dialog.\tA comment can be applied to an object or a specific point in a Multi-board Schematic document \u2013 .ActiveBOM\tComments in ActiveBOM documents are available when the BOM.Comments option is enabled in the Advanced Settings dialog.\tA comment can be applied to a row in an ActiveBOM document \u2013 .Comments and Tasks Panel AccessThe panel is accessed from a Workspace project in the following ways:\t\t\tClick the\u00a0Panels button on the bottom-right of the design space, then select\u00a0Comments and Tasks.\t\t\t\t\t\t\tThe Workspace icon next to a panel&#039;s name in the menu at the bottom-right of the design space indicates that a connection to a Workspace is required\u00a0to view the associated panel&#039;s data. A blue icon () signifies that there is currently a connection to a Workspace. A\u00a0gray icon () indicates that there is currently no\u00a0connection to a Workspace, and you will be directed to connect to a Workspace before the panel&#039;s data can be accessed.\t\t\t\t\t\tSelect the\u00a0View \u00bb Panels \u00bb Comments and Tasks\u00a0command from the main menus.\t\t\t\tDouble-click on the marker pin of a comment placed in the design space.\t\tIn order to access the Comments and Tasks panel, the active document must be a schematic, PCB, ActiveBOM, Multi-board schematic,\u00a0or Draftsman document of an opened Workspace project. Only those projects currently shared with you will be available for selection.Adding a Comment When Not Connected to a WorkspaceBefore using the commenting feature, ensure that you are connected to your Workspace and have opened a project and one of the document kinds that supports comments (including schematic, 2D PCB, Draftsman, and ActiveBOM). Use the File \u00bb Open Project command to choose a Workspace project from those that have been shared with you. The Comments and Tasks panel will provide hints for these prerequisites.\tIf you enjoy\u00a0the benefits of your subscription but have not created an Altium 365 Workspace for your company yet, you can test commenting features in demo mode. When signed in to your Altium account from Altium Designer and working with a local project, you can place up to 3 comments. For using the commenting feature in full functionality mode and for saving the placed comments, the project must be made available to the Workspace \u2013 an appropriate control will be provided for doing this in the message box under the pop-up comment dialog in the design space.\t\t\t\tTry the commenting feature in its demo mode when not having an activated Altium 365 Workspace yet.\tComments and Tasks Panel OptionsUse the buttons at the top of the Comments and Tasks panel to set the availability of comments in the panel and editor space and to specify if mentioned users are notified.The panel&#039;s\u00a0 button toggles the visibility of comment marker pins on the document. Comment entries in the Comments and Tasks panel listing may still be selected as usual.Use the filter drop-down menu in the\u00a0Comments and Tasks\u00a0panel ()\u00a0to configure comment filtering and the associated\u00a0\u00a0button to toggle between the filtered and unfiltered view.\t\t\tTasks only\u00a0-\u00a0enable this option to show only comments that are assigned to a user.\t\t\t\tASSIGNED TO\u00a0- all options are disabled\u00a0by default. Consequently,\u00a0all tasks\/comments are shown and sorted by name (the first entry in the list is the current user). When checkboxes are enabled for a user(s), the entries of those enabled will be displayed.\u00a0\tUse the options of the \u00a0button menu\u00a0to configure comment visibility and notifications:\t\t\tUnresolved Only\u00a0\u2013 comments that have been resolved are not included in the listing.\t\t\t\tCurrent document only\u00a0\u2013\u00a0show only comments that have been placed on the currently active document.\t\t\t\tNotification settings\u00a0\u2013 click to open the Notification Settings dialog and configure email alerts receiving for all comment activity in this design (All), for only those comments where you are mentioned or assigned (My), or not receiving\u00a0email alerts at all (None). \u25ba Email content example.\t\t\t\tExport Comments\u00a0\u2013 click to open the Comment Export Configuration dialog to configure the export of comments into a PDF file.\t\t\t\t \t\t\t\tThe output PDF will include information about comments in the design: comment ID, author, date and time of creation, comment text, assignee (for tasks), and status (for a comment, if it is Resolved; for a task, its To Do \/ In Progress \/ Resolved status).\u00a0You can choose to export all comments associated with the design, irrespective of when those comments were made or only comments made between specific design releases. There are also a few options to define which screenshots to include in the generated PDF document. Together, both give information on where a comment is and what it applies to (point, component, area). If you leave both unchecked, you&#039;ll get just the comments themselves. Once configured, click Export to generate the PDF, using the subsequent dialog to determine where and with what name (by default, that of the project).\t\t\t\t\t\t\t\t\t\t\tEntire designs snapshots - include a snapshot of each source document with a comment within the nominated time Period. This provides a visual confirmation of where on the document the comment resides by numbered comment marker.\t\t\t\t\t\t\t\t\t\tOriginal design screenshots - include the Original Snapshot that was taken when a comment was created (and is the snapshot available from the Contextual Commenting window when a comment marker is clicked in the main design space). This shows the point, area or component to which the comment applies.\t\t\t\t\t\t\t\t\t\tExporting comments to a PDF can also be configured and generated through an Output Job file as part of releasing the project. Add an\u00a0Export Comments\u00a0outputter as part of the\u00a0Report Outputs\u00a0category.\t\t\t\t\t\t\tNote that the comment export feature is only available for members of the Workspace where the project resides. It is unavailable for users with whom the project has been shared outside the Workspace.\t\t\tPlacementTo place a comment\u00a0in the design space of an object-based graphical editor, such as schematic, 2D PCB\u00a0or Draftsman, run the command for it first. This can be done\u00a0by performing one of the following:\t\t\tClick the\u00a0\u00a0button available in the Comments and Tasks panel.\t\t\t\tClick \u00a0near the top right-hand corner of the design space.\t\t\t\tClick Place \u00bb Comment from the main menus.\t\t\t\tUsing the\u00a0Ctrl+Alt+C\u00a0keyboard shortcut.\t\t\t\tRight-click, then select Comment from the design space.\tDepending on the document type (see above), comments can be assigned to an object, a specific point, or an area on the active document. The command invokes the comment placement mode, and the cursor changes to a crosshair with a blue circle that detects and highlights objects for selection:\t\t\tClick a highlighted object to attach (pin) a comment to that object.\t\t\t\tClick in an un-highlighted area to attach a comment to that specific point on the document.\t\t\t\tClick away from an object and drag the cursor to create a rectangular highlighted area, and then click again to confirm its final shape to attach a comment to the specified area. \u25ba See example.\tIn an ActiveBOM document, click on a cell in an ActiveBOM document to add a comment to that row of the BOM. Right-click on a row and then select the Comment command to add a comment to this row.The placement action then opens a comment entry dialog that offers a field for entering the comment text and, for graphical documents, also an additional option\u00a0for adding a freehand drawing to the comment where applicable (). Select the Assign a task to option to assign a task to yourself or to one of the users mentioned in the comment (see details below).\u00a0Click\u00a0\u00a0to confirm the comment creation, which will associate the comment with a numbered pin marker on the document, and also add a comment summary entry to the Comments and Tasks panel.\t\tPlacing a comment on an object, mentioning another registered user in the comment, moving the comment&#039;s pin indicator, and adding a freehand drawing to the comment.\tA placed comment is immediately available to all users with access to the project and will also be available in the browser-based project view of the connected Workspace.Mentions and Task\u00a0AssignmentsAlong with text in the comment entry dialog, a &#039;mention&#039; reference can be added for any other user or role registered with the connected Workspace by entering the @ character. Select a name\/email from the dropdown list to add the user (Workspace member) reference to the comment, and also as an Assign a task to entry \u2013 essentially, a task will be assigned to the user. Uncheck the latter option if you do not wish the comment to be regarded as specifically assigned to that user. A Role group (e.g.,\u00a0&#039;Engineers&#039;), and therefore its constituent users, may also be added as a mention.If a mentioned user does not have access to the current project, you will be invited to share it\u00a0with that user. This option is available if you are the project owner or a Workspace administrator. User Access Rights are granted through the Share dialog;\u00a0the user will receive an email notifying them of the shared access. If you cancel the Share dialog, the project will not be shared, but the comment will be placed as usual.\u25ba See more information about sharing a design.When a task is assigned to a user, the image\/photo of this user will be shown at the top-left of the comment dialog and the comment tile in the Comments and Tasks panel. Also, the task will be named with the\u00a0project name and the sequence number (e.g., Kame_FMU-1) instead of a simple number as is done for normal comments. This name is also shown in the\u00a0comment dialog and the comment tile. Click it to open the Tasks page of the project in\u00a0the Workspace&#039;s browser interface\u00a0with the selected task focused in the task list.\tA task can be referenced to a project commit when saving the project to the connected Workspace. As the hint in the Save to Server dialog states,\u00a0add the task ID to the\u00a0Comment\u00a0field (as it appears in the\u00a0Comments and Tasks panel); the task will be linked to the project commit that will be created after clicking\u00a0OK\u00a0in the dialog.\t\t\t\tThe link to the commit will be shown in the task detail pane when the task tile is selected on the Tasks page of the Workspace&#039;s\u00a0browser interface\u00a0(Altium 365 Workspace, Enterprise Server Workspace) or the Tasks view of the project&#039;s detailed management page\u00a0(Altium 365 Workspace, Enterprise Server Workspace). Click the link to open the project&#039;s History view with the related commit highlighted on the timeline.\t\t\t\tThe link to the connected commit will be shown in the task detail pane. Hover the cursor over the image to see the History page that opens after clicking the link and the related commit highlighted on the timeline.\tPositioningA comment&#039;s location in the editor space is moved by dragging its associated &#039;pin&#039; to a new position \u2013 during or after its placement. When selected, the comment pin includes a connecting line to its associated object or area.\tWhile you can move (drag) a comment pin around in the document editor, the initial defined point or area cannot be modified.Note that a comment may also be positioned during its initial placement by clicking and dragging when in placement mode. \u25ba See example.Pasting ImagesYou can add an image to a comment by first copying the image from an\u00a0Explorer\u00a0window or a browser page by right-clicking\u00a0on the image, which copies the image to the clipboard. To attach the image, use right-click\u00a0Paste\u00a0(or\u00a0the\u00a0Ctrl+V\u00a0shortcut) in the comment itself (in the field that states Add others with @ or paste images).\u00a0Each image can be a maximum of\u00a02MB. After it is pasted into the comment, click the image to display the full image, as shown in the image on the right.You also can post\u00a0a comment if it includes only a pasted\u00a0image\u00a0without any text, as shown below. DrawingWhen placing or editing a comment, select the\u00a0 option button to add a freehand drawing with the resulting pen cursor. Click and drag to create lines, and then right-click to finish and associate the drawing with the currently selected comment. To access the Freehand Drawing mode of the Properties panel, press the Tab key when freehand drawing mode is active (this is\u00a0indicated by the\u00a0 icon in the design space). These options allow you to undo and redo comments under the Commands drop-down and change the width, size and color under the Properties drop-down.General TasksGeneral tasks (tasks applied\u00a0to the current project but are not associated with a project comment or document)\u00a0are listed in the panel in a separate group under the entry of the project. The same content and attributes are shown in the panel for general tasks (assignee, priority, etc.).\tGeneral tasks are listed in the Comments and Tasks panel.Click a General Task entry in the panel to access its commenting dialogs. Use the dialog to post comments (including those with pasted images) for the selected General Task.\tA general task\u00a0for a project can be created from the Tasks page of the Workspace browser interface when accessing the\u00a0detailed management page for the project. To learn more, see\u00a0Management of a Specific Project\u00a0( Altium 365 Workspace, Enterprise Server Workspace).Detached CommentsWhen a project document is removed, or its UniqueID has changed, the comments for the document can become &quot;detached.&quot; Those comments can still be accessed from the panel&#039;s Detached Comments\u00a0collapsible region. Click on a detached comment&#039;s tile in the Comments and Tasks panel to show its dialog in the design space of the currently opened document.Working with CommentsComments placed in a design document are registered in both the Comments and Tasks panel (as a sequence of numbered entries) and in the corresponding document editor (as numbered pin graphics). Each panel entry represents a comment thread and provides summary information, including who placed the comment and when, the initial comment text, any applied mentions\/assignments, and the number of thread replies.A comment thread is opened by selecting its entry in the Comments and Tasks panel or by clicking on its associated pin in the design space. This highlights the comment in the document editor and opens the comment entry dialog, which includes the initiating comment and any user replies. If a selected comment is associated with another design document, the system will open (and load, if necessary) that document.\t\tNavigating comments by selecting pin markers in the design space, and by selecting entries in the Comments and Tasks panel.Comments DialogInteraction with a placed comment is through the pop-up comment dialog, which shows all entries in the selected comment thread and includes options to preview, reply, edit, resolve, and delete an entry. The dialog is opened when initially placing a comment or when a placed comment is selected in the Comments and Tasks panel or in the design space. Press Esc or click in the design space to close the comment dialog. \tStep through all available comments sequentially using the previous\/next buttons () in the dialog&#039;s header.PreviewSelect the Original Snapshot option in the initial comment to see a graphical capture of the editor area when the comment was placed. Click the  icon at the top-right of the screenshot or the screenshot itself to open a full-size preview (click the \u00a0icon at the top-right of this preview or the image itself to close it). ReplyEnter text, and optionally a user mention (&#039;@&#039;)\u00a0in the Reply field to add a new entry to the comment thread. Select the Assign a task to option to create a task assigned to a user specified in the drop-down.\u00a0Click\u00a0\u00a0to confirm the entry. Edit and DeleteAn existing comment may be edited by the author of that comment using the Edit option available from the comment&#039;s\u00a0 menu. Click the\u00a0 button to confirm the comment edit.Use the Delete option to remove the currently selected comment. Note that the entire thread will be removed if the initial comment (instead of a Reply) is deleted.Use the Convert to Task option to convert the comment to a task assigned to yourself.Use the Copy Link option to copy the URL to the comment thread. This link can be used to open this project in the Web Viewer of the Workspace&#039;s browser interface, with an object, point, or area of the comment zoomed and centered. ResolveClick the  \/  button to toggle the comment state between Resolved and Unresolved (the default). A resolved comment (closed as complete) is inactive and non-editable, and both its entry in the Comments and Tasks panel and its pin marker on the document are grayed out. Setting Task Priorities and StatusesIf a task comment has been assigned to a user, its priority and status can be set. A\u00a0task is initially immediately set to Medium priority and to To Do status, but they can be changed by clicking an\u00a0associated control at the top of the comment dialog. Commit Tag and Release Revision ID Information\u00a0Commit tags and release revision IDs are\u00a0displayed when viewing the applicable comments\/tasks in both the\u00a0Comments and Tasks\u00a0panel and the commenting dialog in Altium Designer.\t\t\tComments created in the Web Viewer when reviewing the design snapshot of a tagged commit\u00a0will include the associated tag name. Click the tag name link to open the related commit snapshot in the Web Viewer.\t\t\t\tComments created in the Web Viewer\u00a0when\u00a0reviewing a specific release will include the release revision ID.\u00a0Click the release revision ID\u00a0link to open the Manufacturing Portal for this release.\t Working with Jira TasksIf Jira Integration is enabled for your Altium 365 Workspace and the Jira application has been configured, then a placed comment will include the additional option of placing and linking with a Jira issue in your Atlassian Jira\u00ae service. Like conventional comments and their associated tasks, placed Jira issues can be viewed, edited, and commented on from within the design documents, and viewed\/selected via the Comments and Tasks panel.A placed Jira task instance is synchronized with its respective issue in the Jira space. The bidirectional data synchronization between Jira issues and Workspace tasks allows design project management to be conducted through the Jira space in conjunction with Altium 365.\t\t\t\t\t\tRefer to the Jira Integration\u00a0page for a functionality\u00a0overview.\t\t\t\t\t\t\tRefer to the\u00a0Exploring the Browser-based Interface page\u00a0for details on configuring Jira Integration for your Altium 365 Workspace.\t\t\t\t\t\t\tRefer to the Web Viewer page for details on working with Jira tasks in the Altium 365 Workspace browser interface&#039;s Web Viewer.\t\t\tCreate a Jira IssueTo place a Jira Issue task for a design project, first place a comment instance in the usual way and then select the Jira Issue option in the comment dialog. Follow by choosing an Issue type and adding a summary to create the synchronized Jira issue task.\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\tJavascript ID: CommentsAndTasks_JiraIntegration_CreateIssue_AD24_8\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tPlace a Jira task in the current project document by first placing a comment instance. The alternative Jira mode is available from the Comment drop-down menu.\t\t\t\t\t\t\t\t\t\t\t\t\t\tInvoke the Jira task placement by selecting the Jira Issue option from the dialog&#039;s Comment menu.\t\t\t\t\t\t\t\t\t\t\t\t\t\tClick the Create Issue option if not already selected.\t\t\t\t\t\t\t\t\t\t\t\t\t\tSelect the type of issue to be created from the Issue Type drop-down list, which includes those available in your Jira service.\t\t\t\t\t\t\t\t\t\t\t\t\t\tEnter an issue Summary and optional description\/assignee. The Assignee drop-down list will include only those users who are registered members of your Jira account. Select Post to confirm.\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe Jira issue is placed in the initial document comment position, is included in the Comments and Tasks panel, provides a link to the issue in the Jira space, and includes interactive access to its task priority (Medium, High, etc.) and status (To Do, In Progress, etc.) settings.\t\t\t\t\t\t\t\t\t\t\t\t\tSelect the Task ID of the Workspace Jira issue in the comment dialog or Comments and Tasks panel to directly open that issue in the Jira space in\u00a0a new tab of your default browser. The Workspace Task ID maps to the Issue Key in the Jira space, and the main Jira parameters, such as Summary, Description, Assignee, and Comments, are mapped between the two instances. The Workspace user who created the Jira Issue is the Issue Reporter on the Jira side. Note that a snapshot image of the current Workspace document is included as a Jira attachment if the Attach original snapshot option was selected when creating the Workspace Jira issue (see above).\tA placed Workspace Jira task will create a synchronized Jira issue in the Jira space. The two are linked by the mapping of the Workspace Task ID with the Jira Issue Key.Along with the parameters mapped between the Workspace and Jira issues, the task-related Priority and Progress status settings are also synchronized. For example, moving the Workspace issue task from a Medium to High priority state will immediately be reflected in the issue on the Jira side, and changing the progress state from To Do to In Progress on the Jira side will similarly change the state of the Workspace Jira issue. A data refresh (run by clicking the\u00a0 button at the top of the Comments and Tasks panel) may be required to see updated data.Link to a Jira IssueAltium 365 Jira Integration also allows a Workspace Task to be linked to an existing Jira issue in your Atlassian Jira service through the comment dialog\u2019s Jira Issue mode. You can link to any issue in the specified Jira project, which is then synchronized with the Workspace Jira task.\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\tJavascript ID: CommentsAndTasks_JiraIntegration_LinkIssue_AD24_8\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tPlace a comment instance on the document area or object you would like to associate with an existing Jira issue, then select the Jira Issue mode and the Link Issue option in the comment dialog.\t\t\t\t\t\t\t\t\t\t\t\t\t\tUse the Select or search issues drop-down to select the Jira issue (shown as a\u00a0Summary text) that will link to the newly placed Jira task instance. Begin typing in the text field to search for a required Jira issue.\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe dialog\u2019s Jira Issue drop-down will show the selected issue from the Jira space. If required, check the Attach original snapshot option to transfer an image of the current document view to Jira.\t\t\t\t\t\t\t\t\t\t\t\t\t\tClick the Post button to establish the link between the Workspace Jira task and the selected Jira issue.\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe new Jira issue task is shown in the Comments and Tasks panel and the comment dialog, which will include any existing (or added) comments \u2013 select the dialog\u2019s Show all Replies option to see the full list.\t\t\t\t\t\t\t\t\t\t\t\t\tThe linked Jira issue is now synchronized with the Workspace Jira task, which includes the issue\u00a0Comments\u00a0and is set to the\u00a0Progress\u00a0and\u00a0Priority\u00a0states defined by the Jira issue \u2013\u00a0In Progress\u00a0and\u00a0High\u00a0in this example. Note the Jira issue\u00a0Web links\u00a0entries will now indicate that an Altium 365 Workspace Jira task has been linked (or re-linked) to this issue.\tAn existing Jira issue is linked to a Workspace task by specifying its Jira Issue entry in the Workspace comment dialog&#039;s Link Issue mode.To-Do Panel\tThe To-Do panel\u00a0is available when the UI.PanelToDoList option is enabled in the Advanced Settings dialog.\tWhile your\u00a0connected Workspace provides a comprehensive set of features for commenting and task assignment described above, you can also access the\u00a0To-Do\u00a0panel to keep\u00a0track of your tasks. The To-Do panel lists all To-Do items that are currently defined for the active project. A To-Do item is used as a reminder for a task that needs to be carried out later in relation to a document. \tThe To-Do panel\t    To-Do Panel Content and Use    The To-Do panel can list two varieties of &#039;to-do&#039;\u00a0items for the active project:\t\t\t\t\t\t\tA project-level To-Do item.\t\t\t\t\t\t\tA document-level To-Do item - added to a text-based document within the project.\t\t\t\tFor each To-Do item, the following information is displayed:\t\t\t\t\t\t\tDone - this check box lets you check the item when its defined task has been completed.\t\t\t\t\t\t\tAction Item - the actual task that needs to be performed.\t\t\t\t\t\t\tPriority - the importance of the task to be performed (Lowest, Low, Normal (default), High, Highest).\t\t\t\t\t\t\tDocument - a reference to the source document to which a document-level To-Do item has been added.\t\t\t\t\t\t\tOwner - this could be the name of the person entering the task or who is actually to perform the task.\t\t\t\t\t\t\tCategory - this could be the particular area within the project that the task to be performed falls under (e.g., schematics, design rules, routing, constraints, etc.).\t\t\t\tAdding Project-level To-Do Items\tProject-level To-Do items are added from within the panel itself. Before adding any items, ensure that the active document in the design editor window is one of the design documents for the project for which you want to define To-Do items.\t\tTo add a new To-Do item, right-click within the panel and choose the Add Project To-Do Item entry from the subsequent context menu that appears. The Edit To-Do Item dialog will open.\t\t \t\tUse this dialog to enter suitable text for the task that must be carried out for the project. Use the available fields in the dialog to define a task&#039;s Priority, Owner, and Category. After defining the item as required, click\u00a0OK to add the new item to the panel.\t\tAdding Document-level To-Do Items\tDocument-level To-Do items are added to a text-based source document (e.g., VHDL file, Constraint file, Embedded Source code document, etc.). Before adding any items, ensure that the required document is active in the design editor window and that this document belongs to the project whose overall To-Do items you are currently defining.\t\tTo add a new To-Do item, place the text cursor at the required position within the document at which you wish to place a To-Do item, right-click and choose the Add To-Do Item entry from the subsequent pop-up menu that appears. The Edit To-Do Item dialog appears.\u00a0Use this dialog to enter suitable text pertaining to the task that must be carried out in the document. Use the available fields in the dialog to define a Priority,\u00a0Owner\u00a0and Category for the task (e.g., Formatting pass, Code Review pass, etc.).\u00a0After defining the To-Do item as required, click\u00a0OK to close the dialog and return focus to the current document. An entry for the To-Do item will appear in the To-Do panel and also at the point marked by the current text cursor position. The entry will appear as a comment (between the comment delimiter(s) defined for that document type), including the actual text for the item and a unique identifier, as shown in the image below.\t\t\t\tRight-click Menu\tThe right-click menu provides the following commands:\t\t\t\t\t\t\tGoto Source - this command becomes available when the selected item in the panel is a document-level To-Do item. Use this command to open (if not already) the associated source document referenced in the Document field of the item and make it the active document in the design editor window. The text cursor will be placed at the beginning of the To-Do item text.\t\t\t\t\t\t\tAdd Project To-Do Item - add a project-level To-Do item to the panel for the active project.\t\t\t\t\t\t\tEdit - edit the selected To-Do item. The Edit To-Do Item dialog will appear, allowing you to make the required changes.\t\t\t\t\t\t\tDelete - delete the selected To-Do item from the panel.\t\t\t\t\t\t\tShow Completed Items - with this option enabled, only To-Do items that have been marked as complete (Done option enabled) will remain displayed in the panel.\t\t\t\t\t\t\tReport - generate a report containing all To-Do items currently displayed in the panel. After launching the command, the Report Preview dialog will open in which you can configure,\u00a0print and export the report in various file formats.\t\t\t\tNotes\t\t\t\t\t\tIf a document-level To-Do item has been defined in the panel and the corresponding source document is the active document in the design editor window, the text for the entire To-Do entry in the panel will become bold.\t\t\t\t\t\t\tDouble-clicking on a To-Do item entry in the panel will open the Edit To-Do Item dialog, enabling you to modify the task&#039;s definition.\t\t\t\t\t\t\tThe entries in the panel may be sorted by any column by clicking on the header for that column. Click once to sort in ascending order; click again to sort in descending order.\t\t\t\t\t\t\tDirect filtering lets you quickly jump to a To-Do item entry by directly typing within the panel. You can filter based on any data column in the panel. Use the Right Arrow and Left Arrow keys to switch between columns for filtering, or click directly on a field within a column.\u00a0To use this filter feature, click within a data column and type the first letter of the entry to which you want to jump. The first entry in that column, starting with the letter you type, will become selected, and the letter will be highlighted to show that filtering of the column content is based upon the letter typed.\t\t\t\t    var p = document.getElementsByClassName(&quot;Counter&quot;);    for (k = 0; k &lt; p.length; k++) {        Bloberator(p[k].id, &quot;0&quot;);    }    document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);    document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);    function Update(ss, n) {        var g = (document.getElementById(ss).innerHTML) - 1;        var TextArray = document.getElementsByClassName(ss + ss);        var ImageArray = document.getElementsByClassName(ss);        if ((g == 0) &amp; (n == -1)) {            n = 0;        }        ImageArray[g].style.opacity = &quot;0&quot;;        ImageArray[g].style.zIndex = &quot;-1&quot;;        if (g &lt; TextArray.length) {            TextArray[g].style.display = &quot;none&quot;;        }        g = g + (n);        if (g == ImageArray.length) {            g = 0;        }        var v = ImageArray[g].getElementsByTagName(&quot;video&quot;)[0];        if (v != null) {            v.currentTime = 0;            v.play();        }        ImageArray[g].style.opacity = &quot;1&quot;;        ImageArray[g].style.zIndex = &quot;1&quot;;        if (g &lt; TextArray.length &gt; 0) {            TextArray[g].style.display = &quot;inherit&quot;;        }        document.getElementById(ss).innerHTML = g + 1;        Bloberator(ss, g);    }    function Bloberator(sss, m) {        var dots = &quot;&quot;;        var IR = document.getElementsByClassName(sss);        for (d = 0; d &lt; IR.length; d++) {            if (d == m) {                dots = dots + &quot;&quot;;            } else {                dots = dots + &quot;&quot;;            }        }        var dotrows = document.getElementsByName(sss);        for (x = 0; x &lt; dotrows.length; x++) {            dotrows[x].innerHTML = dots;        }    }","tags":"","url":"altium-designer\/24\/documentation-altium-designer-document-commenting.html"},
{"title":"Collaborators Visualization &amp; Conflict Prevention","text":"\u00a0The combination of Altium Designer\u00a0and a connected Workspace provides a highly effective data sharing platform that supports design collaboration between team members, based on version-controlled (VCS) projects stored in that\u00a0Workspace.A key part of the design collaboration process is managing that shared access and handling the potential for data conflicts, which might typically occur where more than one user is editing the same design document (their &#039;copy&#039; of that Workspace-based file). Such data conflicts are ultimately dealt with by the Workspace&#039;s VCS when the document is saved to the Workspace, but up until that point, you have no real insight into the active shared status of the document.To fulfill the need for real-time document sharing information and control in the design editing environment, Altium Designer works with a connected\u00a0Workspace\u00a0to provide an integrated system for visualizing and reacting to the current status of shared documents. The system is enabled by the free flow of document-sharing data between design clients (via the Workspace), and is realized through a series of new status icons, a Collaborators Bar and additional file locking logic.PrerequisitesThe real-time collaboration information and control for shared documents are available under the following conditions:\t\t\tThe project to be shared is hosted on a connected Workspace as a Workspace project under version control (VCS).\t\t\t\tThe collaborators are members of and connected to the Workspace.\t\t\t\tThe Workspace project has been shared with all collaborators \u2013 with editing rights for those users that require full access.\t\t\t\tThe\u00a0collaborators have the System.Softlocks option enabled in the Advanced Settings dialog.\t\tFor demonstration purposes, the below overview shows the collaboration feature when Altium Designer is connected to an Altium 365 Workspace.\tCollaborators Notification Bar\tThis feature is available when the UI.UseCollaborationBar option is enabled in the Advanced Settings dialog.\tThe Collaborators notification bar () will appear in the upper right corner of the Altium Designer document editor when the currently active document has been opened by another user. Hover the cursor over the user icons within the bar to see the live sharing status. Note that a &#039;viewing&#039; status indicates that the user has opened the document in Altium Designer but has not made any changes. The open status of a local document is indicated by the  icon in the Projects panel. Editing StatusAlong with reporting who is viewing a document, the system also provides information regarding who is editing a shared document. A document is considered in &#039;editing&#039; status when it has been changed by another user. This is indicated by the Collaborators bar, which dynamically separates collaborator user icons into those viewing and those editing \u2013 the latter group is associated with the  icon. Above: Hover the mouse to trigger the animation.The document that is being edited by another user will have a\u00a0 icon associated with its entry in the Projects panel or a\u00a0 icon if that document is currently open in the editor. Note that the hover text will also report the names of multiple users who are editing (or have edited) the shared document. \tIf another user performed a local change more than two\u00a0days ago and did not save this document back to the Workspace, the\u00a0\u00a0icon will be associated with its entry. The hover text of the icon will display an actual date of the last local change by another user. This might reduce the potential for confusion when using the Soft Locks feature and help users to make an informed decision on whether to start\u00a0editing such a document.\t\t \tConflict PreventionTo manage file editing access and avoid the possibility of data conflicts, the system effectively locks a document to the first user that edits it. or has caused it to be modified. This user &#039;soft-lock&#039; remains associated with the file until the user finishes editing \u2013 commits or reverts the changes, or is overruled by another user or an administrator.In the below example image where two users have opened the same project schematic, the designer using the lower screen has edited the document, causing it to be (soft) locked to that user. This editing status is indicated to the other user (upper screen) via the Collaborators bar and the Projects panel document icon. If another user attempts to make a change to the soft-locked document, its locked (editing) status will trigger pop-up dialogs for both users. The effective owner of the document (lower screen in the below image) will be altered that another user has modified the document and there is an associated risk of conflicted revisions.Conversely, the user who has edited the locked document (upper screen) is presented with the option to cancel their changes (Revert My Edits) or overrule the condition by retaining their edits (Ignore Lock). In the normal course of events, the user would abandon the change (Revert) and wait until the other user has completed the current editing session.If the Ignore Lock option is selected, however, it means there will be more than one edited version of the document that could be committed to the Workspace \u2013 the user edits are potentially in conflict, as indicated by the document&#039;s  icon in the Projects panel for both users.\tWhen a PCB document is edited by more than one user, the pop-up dialog will notify users that collaborative editing is supported. PCB document revisions can be compared and merged using the PCB CoDesign functionality.\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\tJavascript ID: SoftLocks_ConflictWarnings_AD24_5\t\t\t\t\t\t\t\t\t\t\t\t\tIn this situation, where more than one user is editing a document, its icon will change to  if the document is saved. This indicates that the local edits have been completed, but the document state remains in conflict with the copy being edited by another user. The document icon will change to  if the document is closed. To resolve the conflict at this stage, you can revert your local edits by clicking the icon and selecting the Revert My Edits to Resolve Conflict command from the pop-up.And finally, if all users persist in committing their edits to the Workspace \u2013 while overruling file locks and version control warnings \u2013 the different file versions will invoke a VCS Conflict, as indicated by the file&#039;s  icon in the Projects and Storage Manager panels. This can be resolved by adopting the &#039;head&#039; version of the file (though a &#039;pull&#039; or update from the Workspace), or the conflicted file can be maintained as a local-only version. Click the icon to select a required action. var p = document.getElementsByClassName(&quot;Counter&quot;);for (k = 0; k &lt; p.length; k++) {Bloberator(p[k].id, &quot;0&quot;);}document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);function Update(ss, n) {var g = (document.getElementById(ss).innerHTML) - 1;var TextArray = document.getElementsByClassName(ss + ss);var ImageArray = document.getElementsByClassName(ss);if ((g == 0) &amp; (n == -1)) {n = 0;}ImageArray[g].style.opacity = &quot;0&quot;;ImageArray[g].style.zIndex = &quot;-1&quot;;if (g &lt; TextArray.length) {TextArray[g].style.display = &quot;none&quot;;}g = g + (n);if (g == ImageArray.length) {g = 0;}var v = ImageArray[g].getElementsByTagName(&quot;video&quot;)[0];if (v != null) {v.currentTime = 0;v.play();}ImageArray[g].style.opacity = &quot;1&quot;;ImageArray[g].style.zIndex = &quot;1&quot;;if (g &lt; TextArray.length &gt; 0) {TextArray[g].style.display = &quot;inherit&quot;;}document.getElementById(ss).innerHTML = g + 1;Bloberator(ss, g);}function Bloberator(sss, m) {var dots = &quot;&quot;;var IR = document.getElementsByClassName(sss);for (d = 0; d &lt; IR.length; d++) {if (d == m) {dots = dots + &quot;&quot;;} else {dots = dots + &quot;&quot;;}}var dotrows = document.getElementsByName(sss);for (x = 0; x &lt; dotrows.length; x++) {dotrows[x].innerHTML = dots;}}","tags":"","url":"altium-designer\/24\/documentation-altium-designer-collaborators-visualization-conflict-prevention.html"},
{"title":"Interactive Process Workflows","text":"Collaboration is all about human interaction and is not something that can be simply characterized and packaged into a single software feature or interface. Acknowledging that collaboration happens on many levels and in a variety of ways, Altium provides a number of capabilities to help designers work collaboratively, including advanced project sharing,\u00a0design comments\u00a0and ECAD-MCAD CoDesign.A key collaboration feature of Altium Designer is the support for formalized workflows based on configurable Process Definitions. The\u00a0Workspace includes a range of preconfigured Process Definitions that provide defined sequences of event steps (Process Workflows) for tasks such as design reviews and project creation.Process Definitions are managed, edited and created in the Workspace, and their workflows can be invoked from both the Workspace and Altium Designer. The Process Workflows interact with users through Process Forms and flow diagrams, both of which are configured (or created) in the Workspace.To learn more about creating and managing processes in your Workspace, refer to the\u00a0Creating and Managing Processes\u00a0page (Altium 365 Workspace, Enterprise Server Workspace).A Workflow diagram and its associated Forms can capture:\tWho is involved (e.g., admin, design engineer, anyone from the librarian group, etc.)\tWhat actions need to be taken, and in which order\tWhat data needs to be provided (name, description, attachments, etc.)\tWhat are the decision points (e.g., approvals, assignments, etc.)From within Altium Designer, activated design review and publishing process definitions \u2013 that are part of the Project Activities theme \u2013 can be accessed from the project entry right-click context menu Project Activities sub-menu in the Projects panel, or from the main Project \u00bb Project Activities menu.After launching the command, what happens depends on the type of project activity:\tDesign Review\u00a0- an initial dialog will open. Use the dialog to specify initial requirements (as defined for the process) and start the process (start the design review). Refer to the\u00a0Performing Design Reviews\u00a0page to learn more.\tPublish to PLM\u00a0- an initial\u00a0Publish_to_PLM\u00a0dialog will open. Use this to select the project to publish to your PLM instance, then start the process. Refer to the\u00a0Publishing to a PLM\u00a0page to learn more.TasksUsers interact with process workflows by working with Tasks. In Altium Designer, this interaction is performed through the Tasklist panel.Tasks are created in a Workflow Process. Behind each Task element placed in the diagram, a User Form can be created. When this form requires interaction from a designer, that designer is presented with a related Task in their Tasklist panel.When a designer clicks on an active task entry in the\u00a0Tasklists panel a task dialog will open. This provides access to the Form defined for that Task and an image of the interaction diagram (under the Diagram tab) that shows where this Task fits into the process. The Form, which details which fields are mandatory and which are optional, is used by the designer to fulfill their contribution to that Task.If the designer is the initiator of the Task, their Tasklist panel also includes details of any Activities they have initiated.To learn more about tasks, refer to the\u00a0Working with Tasks\u00a0page (Altium 365 Workspace, Enterprise Server Workspace).Tasklist PanelThe Tasklist panel presents all assigned process workflow Tasks and Activities. Note that the panel displays only Tasks and Activities assigned to the user that is currently connected to a Workspace. All information on this page relates to the connected user. The Tasklist panel lists all Tasks and Activities assigned to the currently connected user.Tasks RegionThe upper region of the panel lists all process workflow Tasks assigned to this user; any shown with a  icon have not yet been assigned to a user. A Task appears in the panel when a process workflow, such as a design review or a new part request, has been created and there is an outstanding task in that workflow assigned to the current user.Click once on a Task in the list to open the Form that has been created for that Task. The Diagram tab option, when available, includes a graphic representation of the Process workflow as shown in the following Activities section. Below shows an example of an Ad Hoc Review workflow feedback task assigned to the current user.User Form for a Review Feedback task that was created by the Ad Hoc Review process workflow.In the example Task shown above, once the assigned user (Bruce) has completed their review and added any pertinent Comments or Attachments, they select the appropriate option from the Vote drop-down then click the Submit button. Once that has been done, that Task is automatically removed from their Tasklist.The Tasklist presents the next outstanding task in a workflow. Once a task is completed by all of that task&#039;s assignees, any subsequent task in that workflow that is assigned to that user will appear in their tasklist.  \u2013 click to configure which types of Tasks are currently shown (All Tasks or Project) to filter the listing to those that apply to the current project.Activities RegionThe Activities region of the panel lists the Activities, or workflows, that the current user has initiated. It does not mean that the current user is required to complete a Task as part of that workflow; it simply reflects the workflows that this user has created.Click on an Activity to open an information dialog about that activity. The dialog includes tabs that show the workflow Diagram and the Data associated with the Task. The diagram will include a blue icon that indicates which task the process workflow is currently up to. Hover the cursor over the icon to see for which designer(s) the task is waiting.The diagram for a workflow launched by the signed-in user. The blue icon indicates which task the process workflow is currently up to and for whom it is waiting.  \u2013 click to configure which types of Activities (workflows) are currently shown. The choices include, but are not limited to, Project Activity (such as design reviews) and Part Requests. If the Show closed option is enabled, only closed (completed) workflow activities are listed.  \u2013 click to update (refresh) the panel&#039;s Activities list.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-interactive-process-workflows.html"},
{"title":"Process-based Part Requests","text":"The number of design components available to an engineer when capturing their next design can vary from a few hundred scattered across individual symbol and model libraries\u00a0to hundreds of thousands, stored in a dedicated company parts database. But no matter how many components are available to hand, there will always be more that aren&#039;t, and that need to be created and added for reuse.For a small design house, an engineer will simply change &#039;hats&#039; and become the Librarian \u2013 whipping up required components that are missing from their design arsenal. However, for a larger organization that employs a dedicated library department to grow and maintain the design components \u2013 accessible to all engineers and designers in that organization \u2013 it makes sense to submit requests for new (missing) components to that department. Providing an elegant solution to this, Altium Designer offers the Part Requests feature.An engineer can simply put in a request for one or more parts to be created, and get notified when that request has either been completed, and the component(s) made available or rejected (and why). The requestor supplies as much key information to support their request as possible (manufacturer and part number(s), description(s), any relevant datasheet (PDF or URL)). Stub Component Items can even be created that the librarian can then run with (and finish off).\tNote this document looks\u00a0at the default Part Request functionality, based on Workflows. Should you wish to use the legacy Part Request approach when connected to an Enterprise Server Workspace, you can. To do so, enable the Legacy Part Requests Active option, on the Admin \u2013 Settings \u2013 Vault \u2013 Legacy Part Requests page of the\u00a0Enterprise Server Workspace&#039;s browser interface.\tPart Request Process WorkflowsRelated page: Creating &amp; Managing Processes (Altium 365 Workspace,\u00a0Enterprise Server Workspace)Altium Designer provides a powerful collaborative design environment. Part of that is the support for Workflows\u00a0that guide a company&#039;s designers through typical, everyday design processes such as the creation of new parts. Each Workflow that is used to implement a particular design process is created as part of a Process Definition. It can therefore be referred to as that process&#039;s underlying Workflow, or simply a Process Workflow.Processes\u00a0and their Workflows\u00a0are created and managed through the Workspace&#039;s browser interface \u2013 by an Administrator of that Workspace. A single predefined process definition for Part Requests is activated for use out-of-the-box (New Part Request). This can be found on the Part Requests tab of the Admin \u2013 Processes page of the browser interface. Use this, modify it, or create your own as required, to suit the needs of making part requests within your company. In addition, five more sample process definitions are available \u2013 New Part Request Assign, New Part Request Multiple Tasks, Part Request with PLM Part Create, Part Request with lifecycle change, and\u00a0New Part Request Notify 3rd party.\u00a0These cannot be activated and used as is. Each of these is therefore more like a &#039;template&#039; \u2013 edit to suit your company&#039;s requirements, name, and save as a new process definition, which you can then activate and use, along with all other definitions in the Part Requests process theme.\t\t\tNew Part Request \u2013 active for use, and the workflow diagram for which is shown below.\t\t\t\t\t\t\tThe workflow diagram of the\u00a0New Part Request\u00a0process definition.\t\t\t\t\t\tNew Part Request Assign \u2013 template sample definition, from which you can make your own definition (edit, name, then save\/deploy). The workflow diagram is shown below.\t\t\t\t\t\t\tThe workflow diagram of the\u00a0New Part Request Assign\u00a0sample process definition.\t\t\t\t\t\tNew Part Request Multiple Tasks \u2013 template sample definition, from which you can make your own definition (edit, name, then save\/deploy). The workflow diagram is shown below.\t\t\t\t\t\t\tThe workflow diagram of the\u00a0New Part Request Multiple Tasks\u00a0sample process definition.\t\t\t\t\t\tPart Request with PLM Part Create \u2013 template sample definition, supporting the automatic creation of a Component in your PLM instance, and then propagation of the generated part number back to the component in the Workspace. The workflow diagram is shown below.\t\t\t\t\t\t\tThe workflow diagram of the\u00a0Part Request with PLM Part Create\u00a0sample process definition.\t\t\t\t\t\t\tOne important thing to note is that when you modify this sample definition to create your own, you must specify the PLM instance into which parts are to be created. Select the Create Part in PLM entity in the workflow diagram and choose the PLM instance from the drop-down menu associated with the PLM Instance field. This menu lists all currently defined PLM instances (as defined on the PLM Integration page of the interface).\t\t\t\t\t\tPart Request with lifecycle change \u2013 template sample definition,\u00a0providing the ability to change lifecycle state of a component.\u00a0The workflow diagram is shown below.\t\t\t\t\t\t\tThe workflow diagram of the\u00a0Part Request with lifecycle change\u00a0sample process definition.\t\t\t\t\t\tNew Part Request Notify 3rd party \u2013 sample definition, providing the ability to trigger EDS notification with parameters from the workflow, and await a response from EDS. This can be used to integrate a 3rd party system into Enterprise Server processes (requires access to Enterprise Server SDK), giving you the ability to further customize your workflows, and support influencing of decisions in the workflow for a process from an external source. The workflow diagram is shown below.\t\t\t\t\t\t\tThe workflow diagram of the\u00a0New Part Request Notify 3rd party\u00a0sample process definition.\t\t\t\tA powerful Process Workflow Editor provides the flexibility for you to build processes with workflows that can be as simple, or as complex as needed, and in-line with your company&#039;s requirements.Initiating Part RequestsOnce the required set of process definitions for the Part Requests process theme are crafted as required for your company, those definitions that are activated will be available for use by all users once they are actively connected to the Workspace. The following sections take a look at where a designer can access, and start these active processes \u2013 both through the Altium Designer, as well as the Workspace&#039;s browser interface.\tAdministrators for the Workspace can start a new instance of any activated process definition \u2013 directly from the Part Requests tab within the Processes area of the Workspace&#039;s browser interface \u2013 by clicking the  control.From within the Altium DesignerFrom within Altium Designer, activated process definitions that are part of the Part Requests theme can be accessed in the following places:\t\t\tFrom the Components panel. Right-click within the main area of the panel \u2013 the active part request process definitions are available from the Operations \u00bb Submit Request sub-menu. Alternatively, click on the Submit request link under the Need more components? section.\t\t\t\t\t\t\tInitiating a Part Request from within\u00a0the Component panel.\t\t\t\t\t\t\tIf no active process definitions are available for the Part Requests process theme, the Submit Request sub-menu will be grayed out (not available). You may need to sign out of the Workspace and back in again, or restart Altium Designer, to refresh.\t\t\t\t\t\tFrom the Manufacturer Part Search panel. If the currently selected search item has no  icon, the Details pane (accessed by clicking ) will present the  button. Click the drop-down part of the button to access a menu of the active part request process definitions. Clicking the main part of the button directly will launch the first process definition in the list.\t\t\t\t\t\t\tRequesting a part through the Manufacturer Part Search panel provides the added benefit that it will auto-fill key information for you, including all data sheets and parametric information.\t\t\t\t\t\t\tInitiating a Part Request from within\u00a0the Manufacturer Part Search\u00a0panel, from\u00a0a component without models.\t\t\t\t\t\t\tIf no active process definitions are available for the Part Requests process theme, the  button will be grayed out (not available). You may need to sign out of the Workspace and back in again, or restart Altium Designer, to refresh.\t\t\t\tIf the currently selected search item has an  icon, the active part request process definitions will be available from the menu associated with the  button (click on the drop-down part of the button).\t\t\t\t\t\t\tInitiating a Part Request from within\u00a0the Manufacturer Part Search\u00a0panel, from a component with\u00a0models.\t\t\t\tThe active part request process definitions can also be accessed from the right-click menu for the main area of the panel, from the Submit Request sub-menu.\t\t\t\t\t\t\tInitiating a Part Request from within\u00a0the Manufacturer Part Search\u00a0panel&#039;s main area.\t\t\t\t\t\t\tIf no active process definitions are available for the Part Requests process theme, the Submit Request sub-menu will be grayed out (not available). You may need to sign out of the Workspace and back in again, or restart Altium Designer, to refresh.\t\t\t\t\t\tFrom the Explorer panel, when the dedicated Part requests folder is selected or after having conducted a search. The  button will be available which, when pressed, will present the active part request process definitions available to choose from.\t\t\t\t\t\t\tInitiating a Part Request from within\u00a0the Explorer\u00a0panel.\t\t\t\t\t\t\tNote that if the Legacy Part Requests feature has been enabled for an Enterprise Server Workspace, then the button will appear as . An additional entry relating to new part requests using that legacy functionality will also appear on the menu. This will have the suffix (Legacy). If no active process definitions are available for the Part Requests process theme, and the Legacy Part Requests feature is not enabled, the Submit Request button will not be shown. You may need to sign out of the Workspace and back in again, or restart Altium Designer, to refresh.\t\t\tStarting a RequestAfter choosing the required part request process definition, the Start Part Request dialog will appear. This will present controls for defining the requested part \u2013 supply as much information as possible so that the person assigned to make the component can deliver the part exactly as needed.The actual information contained in the dialog will depend on the content defined in the associated form for the Start element of the process workflow. The following image shows the form defined for the Start element of the New Part Request process definition, along with the resulting Start Part Request dialog when that definition is run from the Components panel, or the Explorer panel.\tExample showing the Start Part Request dialog when running the New Part Request process definition from within the Components panel or Explorer panel. The content of the dialog is determined to a great extent from the underlying form for the Start element of that definition&#039;s process workflow.The following image shows the Start Part Request dialog when the New Part Request process definition is run from the Manufacturer Part Search panel. Submitting a part request from this panel has the added benefit that it will auto-fill key information for you, including all data sheets and parametric information.\tExample showing the Start Part Request dialog when running the New Part Request process definition from within the Manufacturer Part Search panel. Notice that a lot of information is pre-filled for you (highlighted in green for the part chosen here).For the default part request process definitions, the following controls are available:\t\t\tRequest title \u2013 a title is automatically generated with, and assigned to, the request, in the format  #n. This field contains the text AUTO and is non-editable.\t\t\t\tPart number \u2013 this is a mandatory field indicating to the librarian the specific part number of the part you need them to make.\t\t\t\tManufacturer \u2013 this is a mandatory field to indicate to the librarian who actually makes the part.\t\t\t\tDescription \u2013 this field can be used to give a rich description of the part (typically taken from the manufacturer datasheet).\t\t\t\tPriority \u2013 this is a mandatory field used to indicate the priority of the request. Choose either Low, Medium, or High. The default setting is Medium.\t\t\t\tNeeded by \u2013 use this field to specify the date by which you need the component to be ready. Clicking within the field will pop-up a calendar window, with which to specify the required date.\t\t\t\tLink \u2013 if you have a URL for the part&#039;s datasheet, enter it into this field.\t\t\t\tDatasheets \u2013 if you have any datasheets available for the part, add them using this field, either through a dialog by clicking the  button, or by dragging and dropping them onto the indicated area. Files of any format can be attached. To remove a file, click on its remove control ().\t\t\t\tPreliminary components \u2013 use this field to add links to any existing symbol, footprint, and component in your Workspace, and which can be used as a basis for creation of the requested part. Click in the field and start typing to access a list of available Items (by Item ID). Choosing an entry will add it to the field. Alternatively, click the  button to access the Choose Items dialog (a trimmed variant of the Explorer panel), with which to browse for the required preliminary components. To remove an entry, click on its close control ().\t\t\t\t\t\t\tAdd links to existing content in the Workspace, which can be used when creating the requested part.\t\t\t\t\t\tProperties \u2013 this field is only available when starting the request from a chosen part in the Manufacturer Part Search panel and simply loads\/presents the parameters for that part, along with their values.\t\tRemember, the controls available to you will depend on how the form for the Start element for your part request process definition has been defined. You may have similar controls, more controls, less controls, and different controls \u2013 that&#039;s the beauty of being able to tailor-make the process flows and their elements to your company&#039;s needs.With all data entered\/specified as required, click the  button to initiate the request. The Part number, Manufacturer, and Priority fields are the bare minimum pieces of data that are required for a part request to be processed, and hence they are mandatory fields. If you try to start the request without one of these fields defined, the field will be flagged as required, presented with a red exclamation sign icon, and the  button made unavailable.\tThe Part number, Manufacturer and Priority are essential pieces of information needed to create the new part and, as such, are mandatory \u2013 you cannot proceed with the request while one of these remains undefined.From the Browser Interface of the WorkspaceFrom the Workspace&#039;s browser interface, activated process definitions that are part of the Part Requests theme can be accessed from the Part Requests page, by clicking the  button at the top-right of the page.\tAccessing activated Part Requests definitions from the Part Requests page of the Workspace&#039;s browser interface. Shown here is accessing the definitions in an Altium 365 Workspace. Hover the cursor over the image to see accessing the definitions in an Enterprise Server Workspace.\tIf no active process definitions are available for the Part Requests process theme, the  button will be unavailable. If only one process definition exists, the button will not appear with drop-down functionality, and will start that process immediately upon being clicked.Starting the RequestAfter choosing the required part request process definition, a window will appear whose title reflects the name of the chosen process definition. This will present controls for defining the requested part \u2013 supply as much information as possible so that the person assigned to make the component can deliver the part exactly as needed.The actual information contained in the dialog will depend on the content defined in the associated form for the Start element of the process workflow. The following image shows the form defined for the Start element of the New Part Request process definition, along with the resulting New Part Request window.\tExample showing the New Part Request window when running the New Part Request process definition from within the Workspace&#039;s browser interface. The content of the window is determined to a great extent from the underlying form for the Start element of that definition&#039;s process workflow.For the default part request process definitions, the following controls are available:\t\t\tRequest title \u2013 a title is automatically generated with, and assigned to the request, in the format  #n. This field contains the text AUTO and is non-editable.\t\t\t\tPart number \u2013 this is a mandatory field indicating to the librarian the specific part number of the part you need them to make.\t\t\t\tManufacturer \u2013 this is a mandatory field to indicate to the librarian who actually makes the part.\t\t\t\tDescription \u2013 this field can be used to give a rich description of the part (typically taken from the manufacturer datasheet).\t\t\t\tPriority \u2013 this is a mandatory field used to indicate the priority of the request. Choose either Low, Medium, or High. The default setting is Medium.\t\t\t\tNeeded by \u2013 use this field to specify the date by which you need the component to be ready. Clicking within the field will pop-up a calendar window, with which to specify the required date.\t\t\t\tLink \u2013 if you have a URL for the part&#039;s datasheet, enter it into this field.\t\t\t\tDatasheets \u2013 if you have any datasheets available for the part, add them using this field, either through a dialog by clicking the  button, or by dragging and dropping them onto the indicated area. Files of any format can be attached. To remove a file, click on its remove control ().\t\t\t\tPreliminary components \u2013 use this field to add links to any existing symbol, footprint, and component in your Workspace, and which can be used as a basis for creation of the requested part. Click in the field and start typing to access a list of available Items (by Item ID). Choosing an entry will add it to the field. Alternatively, click the  button to access the Explorer window, with which to browse for the required preliminary components. To remove an entry, click on its close control ().\t\t\t\t\t\t\tAdd links to existing content in the Workspace, which can be used when creating the requested part.\t\t\t\tRemember, the controls available to you will depend on how the form for the Start element for your part request process definition has been defined. You may have similar controls, more controls, less controls, and different controls \u2013 that&#039;s the beauty of being able to tailor-make the process flows and their elements to your company&#039;s needs.With all data entered\/specified as required, click the  button to initiate the request. The Part number, Manufacturer, and Priority fields are the bare minimum pieces of data that are required for a part request to be processed, and hence they are mandatory fields. If you try to start the request without one of these fields defined, the field will be flagged as required.\tThe Part number, Manufacturer and Priority are essential pieces of information needed to create the new part and, as such, are mandatory \u2013 you cannot proceed with the request while one of these remains undefined.Initial Request AssignmentHow a new part request initially gets assigned, depends on the settings defined for Assignee, Except, and Task ownership \u2013 defined for the initial User Task encountered after request submission, as part of the process definition&#039;s underlying workflow.\t\t\tAssignee \u2013 could be a single user for your Workspace, multiple users, or a specific role (grouping of users).\t\t\t\tExcept \u2013 who is not allowed to work on the task, even if they are part of the assignee scope (for example the requestor should not approve their own part request!).\t\t\t\tTask ownership \u2013 determines who can act on a task, in relation to the user(s) specified in the Assignee field. The following options are available:\t\t\t\t\t\t\t\t\tOne of assigned users \u2013 if there is only a single user in the Assignee field, the initial task of working on the request is assigned directly to that user. If there are multiple assignees, all users see the task in their tasklist, and one of those users assigns the task to themself.\t\t\t\t\t\t\t\t\t\tAll assigned users \u2013 all assignees receive the task.\t\t\t\t\t\tFor the default Part Request process definitions, the Assignee is defined to be the admins for the Workspace (members of the Administrators role). Task ownership is set to One of assigned users, meaning that one of those administrative users must take on the request.\tWhich user initially receives the task of working on a new part request depends on how the settings for Assignee, Except, and Task ownership have been defined, for the initial user task \u2013 in the underlying workflow for the applicable process definition. The image above shows the settings for the default New Part Request process definition.Working on a Part RequestRelated page: Working with Tasks (Altium 365 Workspace, Enterprise Server Workspace)Once a Part Request has been initiated, interaction with that request \u2013 or rather its defined process workflow \u2013 is through the concept of Tasks. A Task relates to a user task defined within the workflow \u2013 a point at which action by a user is necessary for the workflow to progress. For a Part Request, the initial task in the workflow will be directed to the person assigned to, and responsible for, creation of that part.Accessing Tasks from within Altium DesignerWhen you are connected to your Workspace through Altium Designer, your current list of tasks will be available through the Tasklist panel. For Part Request-related tasks, look to the Title of the task, which reflects the name of the associated process, along with an instance suffix (e.g.,\u00a0New Part Request #1). The task&#039;s name is simply the name given to the user task element in the process&#039;s underlying workflow. \tExample Part Request tasks currently assigned to, or available for assignment to, the user currently connected to the Workspace.\tAn unassigned task is displayed in the listing of tasks with the  icon. Tasks assigned to you are distinguished by the  icon.Clicking on a task&#039;s entry will access a dialog containing the form associated with that task. The form presents all information and fields that have been defined for that specific user task \u2013 by an administrator when crafting the process workflow \u2013 in order to obtain choices, information, or data from the user, which will facilitate the onward progress of that workflow.\tIf the task is currently unassigned, all users who can take on the task \u2013 Candidates for that task \u2013 will be able to see it in their Tasklist panel. To work on such a task, you will need to assign it to yourself first. When you click such a task, the subsequent form provides an button \u2013 click this to take on the task. After that, you will be able to work on the task, in accordance with its underlying process flow.\tExample form for a user task associated with the default New Part Request process, when accessed from the Tasklist panel in Altium Designer.To view the underlying workflow for the task&#039;s parent process, make the Diagram tab active. The diagram shows the complete workflow for the process, and the point that has been reached in that flow \u2013 the user task which you are currently addressing, reflected by the inclusion of your name. Accessing the workflow diagram for the default New Part Request process, highlighting the user task requiring action, and by whom.Interact with the form as necessary to complete your task. This could mean choosing an option, making a comment, or attaching additional files\/data. For the default New Part Request process for example, the task for the creator of the part has three key fields:\t\t\tComponents \u2013 use this field to add links to any existing symbol, footprint, and component in your Workspace, and which have been created to deliver the requested part.\t\t\t\tNext step \u2013 use this field to determine what happens next in the life of this part request:\t\t\t\t\t\t\t\t\tCompleted \u2013 choose this option if you have created the part (and related domain models if applicable).\t\t\t\t\t\t\t\t\t\tRejected \u2013 choose this option if you do not intend to create the part (and crucially, adding a reason why in the Note field).\t\t\t\t\t\t\t\t\t\tNeeds more info \u2013 choose this option if you cannot create the part at this time without further information from the requestor (and crucially, add what is needed in the Note field).\t\t\t\t\t\t\t\t\tNote \u2013 use this field to provide a comment in relation to the task. For example, indicating that the newly-created component is &#039;good to go&#039;, or a concise explanation of why the requested part will not be created. And if you require more information from the requestor, this is the place to flag what was missing from the original request!\t\tOnce again, the fields available to you will depend on the form crafted for that task as part of the process definition being used. What needs to happen is typically specified within the form, and any data you require to perform your task is usually provided with the form, or as a link. Provided the form for a user task has been crafted intuitively by an administrator at the time the process (and its workflow) were defined, you will be able to efficiently complete each and every task assigned to you, with no ambiguity, and no need to query what needs to be done \u2013 unless of course a user has requested a new\u00a0part for example, and has not provided enough information for you to act upon, in which case you can complete your task by choosing that more information is required!Once you have filled in the form for your task as required click the  button, so that the process can flow to the next relevant stage. The task will be deemed complete and will be removed from the panel. If the next task in the flow is also assigned to you, the associated form will be presented automatically.\tIf any required fields for the form have not been addressed, the software will detect this. Required fields will be highlighted for you to go back and handle as necessary, before attempting to submit again.Accessing Tasks from the Browser Interface of the WorkspaceSign in to your Workspace&#039;s browser interface and access the Tasks page, to see a list of your currently outstanding tasks, which require action. Each task is a specific stage reached within an associated process workflow.For Part Request related tasks, look to the Title of the task, which reflects the name of the associated process, along with an instance suffix (e.g. New Part Request #1). The task&#039;s name is simply the name given to the user task element in the process&#039;s underlying workflow. \tExample Part Request tasks currently assigned to, or available for assignment to, the user currently connected to the Workspace. Shown here are Part Request tasks in an Altium 365 Workspace. Hover the cursor over the image to see Part Request tasks in an Enterprise Server Workspace.\tAn unassigned task is displayed in the listing of tasks with the  icon. Tasks assigned to you are distinguished by the  icon.\tFor a user added to Task management global operation in the Edit Operation Permissions dialog from within Altium Designer, a filter control is provided at the top of the listing of tasks. Use this to quickly switch between viewing all your tasks (My tasks) and all tasks across all users (All tasks). For other users, the list of tasks is automatically filtered so that only tasks requiring their attention are listed. An administrator can also browse all outstanding tasks \u2013 from a process workflow perspective \u2013 from the Browser tab of the Processes page.Click on the applicable task entry \u2013 relevant to the Part Request \u2013 to have its associated form presented on the Form tab, on the right-hand side of the page. The form presents all information and fields that have been defined for that specific user task \u2013 by an administrator when crafting the process workflow \u2013 in order to obtain choices, information, or data from the user, which will facilitate the onward progress of that workflow.\tIf the task is currently unassigned, all users who can take on the task \u2013 Candidates for that task \u2013 will be able to see it. To work on such a task, you will need to assign it to yourself first. This can be done by clicking within the Assignee field and starting to type your name \u2013 select your entry in the dynamic list. After that, you will be able to work on the task, in accordance with its underlying process flow.\tExample form for a user task associated with the default New Part Request process, when accessed from the Tasks page in the Workspace&#039;s browser interface.To view the underlying workflow for the task&#039;s parent process, make the Diagram tab active. The diagram not only shows the complete workflow for the process, but also the point that has been reached in that flow \u2013 the user task which you are currently addressing, reflected by the inclusion of your name. \tAccessing the workflow diagram for the default New Part Request process, highlighting the user task requiring action, and by whom. In this case, user Pavel.Demidov@altium.com\u00a0is tasked with creating the requested part, and needs to address the task in order for the workflow to proceed to its next event.Interact with the form as necessary to complete your task. This could mean choosing an option, making a comment, or attaching additional files\/data. For the default New Part Request process for example, the task for the creator of the part has three key fields:\t\t\tComponents \u2013 use this field to add links to any existing symbol, footprint, and component in your Workspace, and which have been created to deliver the requested part.\t\t\t\tNext step \u2013 use this field to determine what happens next in the life of this part request:\t\t\t\t\t\t\t\t\tCompleted \u2013 choose this option if you have created the part (and related domain models if applicable).\t\t\t\t\t\t\t\t\t\tRejected \u2013 choose this option if you do not intend to create the part (and crucially, adding a reason why in the Note field).\t\t\t\t\t\t\t\t\t\tNeeds more info \u2013 choose this option if you cannot create the part at this time without further information from the requestor (and crucially, add what is needed in the Note field).\t\t\t\t\t\t\t\t\tNote \u2013 use this field to provide a comment in relation to the task. For example, indicating that the newly-created component is &#039;good to go&#039;, or a concise explanation of why the requested part will not be created. And if you require more information from the requestor, this is the place to flag what was missing from the original request!\t\tOnce again, the fields available to you will depend on the form crafted for that task as part of the process definition being used. What needs to happen is typically specified within the form, and any data you require to perform your task is usually provided with the form, or as a link. Provided the form for a user task has been crafted intuitively by an administrator at the time the process (and its workflow) were defined, you will be able to efficiently complete each and every task assigned to you, with no ambiguity, and no need to query what needs to be done \u2013 unless of course a user has requested a new part for example, and has not provided enough information for you to act upon, in which case you can complete your task by choosing that more information is required!Once you have filled in the form for your task as required, click the  button. The task will be deemed complete and will be removed from your list of tasks. If the next task in the flow is also assigned to you, the associated form will be presented automatically.\tIf any required fields for the form have not been addressed, the software will detect this and flag that there are errors. Required fields will be highlighted for you to go back and handle as necessary, before attempting to submit again.Viewing Part RequestsAt any time, any user can view part request activities \u2013 both active requests, and closed requests. This can be done from two places.Part Requests Page (Workspace Browser Interface)From the Part Requests page of the Workspace&#039;s browser interface, you can centrally browse all part requests.\tPart request activities will be visible to all users from the Part Requests page, helping to prevent multiple requests for the same parts being raised.\tBrowse all part request processes from the one convenient location. Shown here is accessing the Part Requests page in an Altium 365 Workspace. Hover the cursor over the image to see accessing the page in an Enterprise Server Workspace.\tBy default, the upper region of the tab presents all Active (running) part request processes. Switch to viewing all Closed processes (e.g. completed, rejected, or terminated) using the drop-down field above the list.For each entry, the following information is presented (where applicable):\t\t\tStatus \u2013 the state of the part request process. This can be one of the following:\t\t\t\t\t\t\t\t\t\u00a0Active \u2013 the part request process is currently active, and its associated workflow is progressing.\t\t\t\t\t\t\t\t\t\t\u00a0On hold \u2013 the part request process is currently active, but is awaiting initial input, such as assignee allocation, before its workflow can progress.\t\t\t\t\t\t\t\t\t\t\u00a0Closed \u2013 the part request process is now closed, for example was either successfully completed, or rejected.\t\t\t\t\t\t\t\t\t\t Terminated \u2013 the part request process is now closed, and was terminated directly by either the initiator of the request, or a Workspace Administrator.\t\t\t\t\t\t\t\t\tProcess Name \u2013 the name of the part request process definition.\t\t\t\tTitle \u2013 this field is used to distinguish between multiple instances of the same part request process. The title is the process name, with an instance suffix (#1, #2, and so on).\t\t\t\tState \u2013 this is the state currently reached within the process&#039;s associated workflow.\t\t\t\tAssignee (Active process only) \u2013 this is the user who now has a task to perform to move the part request process along from its current workflow state.\t\t\t\tStarted By \u2013 the user who initiated the part request process.\t\t\t\tStarted At \u2013 the date and time at which the part request process was started.\t\t\t\tEnded At (Closed process only) \u2013 the date and time at which the part request process was ended.\tFor an active part request process, there is also a Terminate control (). Click this to force-end a part request process. The process will move to the Closed listing of part request processes. Only the initiator of a part request, or a member of the Administrators role for the Workspace, can terminate a part request process.\tPart request processes can be sorted by any column possessing the  control \u2013 click on the control, or the column name. Searching can also be conducted, using the Search field at the top of the list. Data in all fields except Status, Started At and Terminate can be used to search.Click on an entry for a part request process to view a diagram of its underlying workflow (on the Diagram tab below the list), showing what needs to happen for the process to be completed, and where that process is at along its flow, in terms of who now has a task to perform to move the process along.\tClick the  control at the bottom-right to highlight the current point reached in the workflow \u2013 the user(s) entry will flash momentarily.\tViewing the underlying workflow for a selected part request process on its Diagram tab. Each workflow is built diagrammatically allowing you to see at-a-glance where in the workflow a part request currently sits, and who now has the next task in order to continue progress of that request.The following additional tabs are also available:\t\t\tData \u2013 showing all pertinent data for the process. For a part request process, this can include attached datasheets, parametric data, and any preliminary components.\t\t\t\t\t\t\tApplicable entities, such as datasheets, will appear as hyperlinks for quick navigation to, or opening of.\t\t\t\t\t\tHistory \u2013 showing a history of actions taken along the process&#039;s workflow.\t\tUse the Data and History tabs to browse more detail for the part request process, and a trail of its workflow activity, respectively.Tasklist Panel (Altium Designer)When you are connected to your Workspace through Altium Designer, all process-based activities that you have initiated will be available to browse in the Activities region of the Tasklist panel. To list only Part Request processes, click the  button, and disable the Project Activity and Project Creation entries (leaving only the Part Request entry enabled). \tAccess the part requests that you have initiated, directly from within Altium Designer.\tBy default, the region presents all Active (running) part request processes. Switch to viewing all Closed processes (e.g. completed, rejected, or terminated) by clicking the  button, and enabling the Show closed entry.For each entry, the following information is presented (where applicable):\t\t\tState \u2013 the state of the part request process. This can be one of the following:\t\t\t\t\t\t\t\t\t\u00a0Active \u2013 the part request process is currently active, and its associated workflow is progressing.\t\t\t\t\t\t\t\t\t\t\u00a0On hold \u2013 the part request process is currently active, but is awaiting initial input, such as assignee allocation, before its workflow can progress.\t\t\t\t\t\t\t\t\t\t\u00a0Closed \u2013 the part request process is now closed, for example was either successfully completed, or rejected.\t\t\t\t\t\t\t\t\t\t\u00a0Terminated \u2013 the part request process is now closed, and was terminated directly by either the initiator of the request, or a Workspace Administrator.\t\t\t\t\t\t\t\t\tTitle \u2013 this field is used to distinguish between multiple instances of the same part request process. The title is the process name, with an instance suffix (#1, #2, and so on).\t\t\t\tType \u2013 the name of the part request process definition.\t\t\t\tStarted \u2013 the date and time at which the part request process was started.\t\tYou can only view your own part requests through Altium Designer, even if you are an administrator. Also, you cannot terminate a part request process (or any other process activity for that matter) through the Tasklist panel.Clicking on an entry will access a dialog presenting the underlying workflow for the task&#039;s parent process \u2013 on that dialog&#039;s Diagram tab \u2013 showing what needs to happen for the process to be completed, and where that process is at along its flow, in terms of who now has a task to perform to move the process along. Switch to the dialog&#039;s Data tab to show all pertinent data for the process. For a part request process, this can include attached datasheets, parametric data, and any preliminary components.\tViewing the underlying workflow for a selected part request process on its Diagram tab. Each workflow is built diagrammatically allowing you to see at-a-glance where in the workflow a part request currently sits, and who now has the next task in order to continue progress of that request. Switch to the Data tab to see attachments for the request.\tApplicable entities, such as datasheets, will appear as hyperlinks for quick navigation to, or opening of.Email NotificationsOnly the original requestor and any user required to perform a task relating to that request, will receive applicable email notifications. The requestor, who initiated the request, receives notification when that new part request has been submitted and also when it is completed (either the part has successfully been created, or the request has been rejected). A user working on the request will receive notification of any task relating to that request, and that requires their attention. This could be the original requestor, if more information is required from them.Email notifications will be received when the Email Notifications feature is enabled. This is performed by an Administrator, on the Email Notifications page (Admin \u2013 Settings \u2013 Email Notifications) of the Workspace&#039;s browser interface.\tAn example email received when the part request is completed.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-process-based-part-requests.html"},
{"title":"Performing Design Reviews","text":"An essential part of any design process is reviewing its progress and validity at key development stages, whether this takes the form of collaborative peer discussions or rigid sign-off mechanisms. Inherent in that process, at whatever level, is providing access to all relevant project data, files, comments, visual representations and feedback tools needed by the target reviewer(s).Altium Designer provides this capability in a highly flexible form through the application of review Process Workflows that are hosted by a connected Workspace\u00a0and accessed from within Altium Designer.\u25ba For more information on processes and their workflows, see Creating &amp; Managing Processes (Altium 365 Workpace, Enterprise Server Workspace).The process workflows incorporate interactive forms that are presented to the user as they progress through the process flow steps and provide the opportunity to comment, attach files, view design documents, and much more. Review processes may be started by any Altium Designer\u00a0user that has access to the project, and are assigned to other users (Team members) or groups of users (team Roles).On the\u00a0Workspace side, an administrator works with processes as diagram-based flows where the user forms and steps incorporated into the flows are fully customizable. This allows for very specific processes, say, that target established company review requirements, to be constructed (and enforced) if required. Any number of workflow processes can be created.\u25ba For more information, see Defining a Process Workflow (Altium 365 Workspace, Enterprise Server Workspace).Review ProcessesThe\u00a0Workspace offers three default review processes that may be accessed as supplied or used as the basis of more advanced custom processes:\tAd Hoc Review \u2013 An informal review process without a logged conclusion.\tHandoff Review \u2013 A more formal review process where the review initiator (submitter) logs a pass\/fail (Completed\/Rejected) conclusion when closing the review. A completed status indicates that the design is ready to be handed off to the next development stage.\tMilestone Review \u2013 A more elaborate closed loop review process where the submitter uses the review feedback to decide if the status is Completed, Rejected or the design should be corrected (Reworked). In the latter case, the reworked design is then verified and the Completed\/Rejected\/Rework decision is repeated. The review would be closed when the aim or project milestone is successfully achieved.In all the above cases both the review submitter\/approver (Initiator) and reviewers (Assignees) are guided through the process flow by a sequence of user interface forms. The requirements and options in each of the process flow steps are determined by the matching Process entry in the\u00a0Workspace, which is in turn managed by the server Administrator \u2013 who is also able to both initiate and cancel a review process.Note that a review initiator also may invoke a review process from the Web Viewer Activities page in the\u00a0Workspace (Altium 365 Workspace, Enterprise Server Workspace), and the assigned reviewers can complete their part of the process from the Workspace&#039;s Tasks page (Altium 365 Workspace, Enterprise Server Workspace).Performing a ReviewA review typically takes the form of three sequential stages:\tThe user who initiates the review (the submitter) defines what will be reviewed and by whom, and adds any data or information that will be needed.\tThe reviewers access the project data and provide suitable feedback, and if needed, add relevant data or information.\tThe review approver (usually the initiator) assesses and summarizes the feedback from reviewers and closes off the process.All stages in a review are represented by a matching Task (Altium 365 Workspace, Enterprise Server Workspace) in the software&#039;s Tasklist panel, which prompts each user that action is required and provides information on completed tasks. Selecting a pending Task will activate that stage of the review.Initiate and Define ReviewA review process is initiated from the Project \u00bb Project Activities menu in Altium Designer. The review will initially apply to the currently active project.Taking the Ad Hoc Review process as an example, in its default unmodified format, the opening form dialog allows the submitter (Barry in the below example) to specify the project that will be reviewed and which users are assigned to complete the review feedback stage.The entry fields and menus in the Ad Hoc Review dialog are:\tRequest title \u2013 the default AUTO mode adopts the process name as the basis of the active process name (the Activity title). A custom name may be entered in its place.\tProject \u2013 the name of the project that will be reviewed. This is the active project when the process is initiated, but any available project can be selected from the type-sensitive drop-down menu options.\tDescription \u2013 text to provide further information to reviewers.\tReviewers \u2013 specified team members or role groups that will be assigned the task of submitting review feedback. Begin typing to see the available entries.Click the  button to commence the process workflow and step to the data definition form.The following Prepare review data form dialog allows you to specify particular design data resources and add attachments. Note that any form text highlighted in blue is an active link to that source data. The dialog also includes a descriptive flow diagram of the process under the Diagram tab, which also indicates your current position in the flow steps.Notable options in the form dialog are:\tData \u2013 use the drop-down menu to select a particular project release dataset (by date), or use the associated  option to browse to and select a specific set of release data. In the default state where no data is selected, the reviewer(s) will have access to the project source data only.\tAttachments \u2013 browse to () or drag and drop files that you wish to add as review data or information sources.During the above Review submission stage, Altium Designer&#039;s\u00a0Tasklist panel will show this as an active Task (Prepare review data), assigned to you. If the stage is interrupted and the current form dialog has been closed, click the Task to reopen the form and continue.When all review data has been specified or added to the form, click the  button to move the process to the Review stage.At this point the active Prepare review data Task is closed in the Tasklist panel since the review submission stage is complete \u2013 note that the Altium Designer user at this point is the review process submitter (Initiator). The ongoing review process is shown in the panel&#039;s Activities listing with an active status. Click the  button to ensure that you see the latest Activities status.To view the progress status of the active review process, select its entry in the Activities list to display the current data and the annotated flow diagram (Diagram tab).Provide Review FeedbackWith the review process configured and submitted by the Initiator, the activity will automatically generate Tasks to be completed by those specified as Reviewers. When a Reviewer (say, Norm Smith in this example) then signs in to Altium Designer, the Tasks area will show an assigned Provide review feedback task.Selecting this Task will activate the Review stage of the process flow for the Reviewer. The following Provide review feedback form dialog offers the relevant project data (as specified by the review submitter), the opportunity to include comments and file attachments or open the project in the Web Viewer () and the requirement to submit a feedback Vote.Notable options in the Provide Review feedback dialog are:\tOpen Project \u2013 select to open the project&#039;s design in the Workspace Web Viewer. This provides a wealth of project data and fully rendered interactive views of the design source documents, which allows highlighted comments to be added and optionally assigned to a specific user (Workspace member).\t\u25ba For more information, see the Web Viewer page (Altium 365 Workspace, Enterprise Server Workspace).\tComment \u2013 comment notes included here will be attributed to the reviewer&#039;s name when the review process is finalized.\tVote \u2013 select an appropriate summary of the review conclusion.\tReviewers attachments \u2013 browse to () or drag and drop files, such as more detailed notes or reference documents, that will be included with the review feedback.Note that any text highlighted in blue is an active link to that source data. Select the  button to complete the review process \u2013 this is indicated in the Tasklist panel which will close (remove) that active task.The options and requirements presented in the form dialogs shown here only relate to one example of how a review process behaves and is constructed. Altium Designer Process Workflows, as defined in the connected Workspace, are extremely flexible and can be used to create highly elaborate process activities that will be available to Altium Designer.Summarize and Close ReviewWhen all specified Reviewers have completed the review feedback tasks assigned to them, the active Review process moves to its summarize\/close stage. A Summarize review task is generated for the user assigned to assess the review activity \u2013 in this case, Barry, the same user that submitted (initiated) the review. Note that for this user, the review process is shown in an active state in the Tasklist panel under Activities. For reviewers, the activity is now closed because their contribution tasks have been completed.A review process could be configured to accept the first reviewer in a role group (of say, Engineers) that completes the feedback task, rather than requiring all users in that role to complete their task before the process moves to the summarize\/close stage.Selecting the Summarize review task in the Tasklist panel will move the review flow to its final stage, as presented in the Summarize review form dialog.The notable inclusions in this form are:\tInformation provided by reviewers\t\t\tComment \u2013 a list of the comments provided by reviewers at the completion of their review Tasks.\t\tVote \u2013 the review conclusion rating selected by each reviewer.\t\tReview attachments \u2013 any related files added to the Task by reviewers.\t\t\tSummary\t\t\tSummary note \u2013 concluding notes that are added by the review process assessor (the submitter\/initiator in this case) that will be recorded when the review is closed.\t\tClicking the dialog&#039;s  button will close off the active Design Review process. Note that with the more advanced Design Review processes that are available, further steps such as specifying a completed\/rejected conclusion or instigating a design Rework task are included in the assessment stage.To examine the completed Design Review, refresh the Activities entries in the Tasklist panel (), check the Show Closed option in the  menu and select the closed task from the list. The following dialog includes a summary of the review information (under the Data tab) and the process flow diagram (Diagram tab) with the progress state highlighted \u2013 which is Completed, as you would expect.Custom Review ProcessesDesign Review processes, as ultimately presented to a user\u00a0in Altium Designer, are developed and edited in the connected\u00a0Workspace by a designated Administrator. The versatility of the flow step elements and UI Forms that combine to form a Design Review process workflow allow reviews to be created that satisfy a wide range of specific needs.Some of the further options that can be applied to the steps and forms are:\tassigning any step in the flow to a specific user or role, other than those designated as reviewers or an assessor.\tdenying a user or role access to a specific workflow step (an Exception) so it will be bypassed in the flow, for them.\tforcing a form field entry to be compulsory before the form dialog can be submitted.\tadding intervening workflow steps that impose further tasks and user forms.\tthe forming of a workflow decision loop where only a specific action will close that loop.\texposing or hiding particular data or event\/error messages in a workflow step UI form.\tusing the Workspace&#039;s Web Viewer feature to allow design document inspection and comment for reviewers that do not have direct access to the design source documents.Note that a\u00a0Workspace Administrator is able to initiate processes, terminate active processes and view both active and closed user Tasks.As previously outlined, any number of review processes can be created and made available to Altium Designer, and these can be developed for review levels ranging from informal feedback input from peers to company ratified formal review processes that feed into other company systems (such as PLM).\u25ba For detailed information on creating custom processes, see Defining a Process Workflow\u00a0(Altium 365 Workspace, Enterprise Server Workspace).","tags":"","url":"altium-designer\/24\/documentation-altium-designer-performing-design-reviews.html"},
{"title":"Publishing to a PLM","text":"Design data that has been released from Altium Designer\u00a0to a connected\u00a0Workspace\u00a0\u2013 via the Project Releaser \u2013 also needs to be available to the wider enterprise through data management processes such as PLM (Product Lifecycle Management).\u00a0 The presence of up to date ECAD engineering data in a company PLM system provides the design production information necessary for managing procurement, component sources and supply chains at the enterprise level.The combination of Altium Designer and a connected\u00a0Workspace offers a relatively simple way for users to propagate (or \u2018publish\u2019) released engineering files to PLM by harnessing the flexibility of\u00a0process-based Workflows,\u00a0that are defined within the Workspace and can be accessed directly in the Altium Designer design environment.\u25ba For more information about processes and their underlying Workflows, see Creating &amp; Managing Processes (Altium 365 Workspace, Enterprise Server Workspace).The configurable Processes specify the user interface, process flow and error handling for the PLM publishing procedures, while the data connection to the PLM system is (currently) handled by editable XML files. Set up in the Workspace, typically by an administrator, the Processes and PLM data connection files are configured to suit the company PLM instance and data management policies.As a starting point, PLM configuration files are available for popular systems such as PTC Windchill\u00ae, Arena\u00ae etc, and the Workspace also offers preloaded Processes for common PLM publishing tasks. The supplied sample Processes are effectively read-only templates that must be re-saved as an available named process.\u25ba For more information on configuring PLM Process Workflows and PLM Instance connections, see PLM Integration (Altium 365 Workspace, Enterprise Server Workspace).The following PLM publishing Processes (when enabled in the connected Workspace) are available in Altium Designer:\t\t\tWorkspace sample process: Project Releaser with Publish \u2013 publish released project data to PLM as a final stage in the Project Releaser.\t\t\t\tWorkspace sample process: Project with Initialise in PLM \u2013 initialize a release structure in PLM when creating a new Project.\t\t\t\tWorkspace sample process: Publish to PLM (User selects) \u2013 publish selected released data of a nominated project to PLM.\tEach process, available as a re-saved name from the Altium Designer menus, initiates the matching publishing action in the connected Workspace. This pushes the appropriate release data to the specified PLM instance, and accepts return parameter data such as the identification numbers associated with items or objects created in PLM \u2013 PLM part numbers.\tIf the Change Order (ECO) workflow is configured in the\u00a0PLM interface instance (learn more), an additional Change Order Form will be presented during project publishing, where the Change Order&#039;s setup and options are specified ().\tNote that the below overviews of PLM Publishing processes in Altium Designer interact with a Windchill PLM instance.Project Releaser with PublishWhen enabled in the\u00a0Workspace, the Project Releaser with Publish process adds a new final stage to the Project Releaser in Altium Designer.The additional Publish to PLM step is available to run when all stages of the project release have successfully completed, where it will push all released object data to the specified PLM instance. For an overview of this PLM publishing process, see the Publish to PLM section below.\u25ba See Design Project Release for more information on releasing a design.Project with Initialize in PLMWhere a company engineering workflow is fully integrated with PLM, it may be desirable to establish a design project\u2019s release structure in PLM at the very beginning of the ECAD design cycle. This can be achieved in Altium Designer\u00a0by applying the Workspace Project with Initialize in PLM process to create a new PCB Project, which also creates a corresponding set of release framework entries in PLM.In the example case shown here, the Process is named New Project with PLM initialize. This was derived from the Project with Initialise in PLM template process in the Workspace.To start the process, select File \u00bb New \u00bb Project in  \u00bb New Project with PLM initialize (or your equivalent process) from the main menu. Note that an additional New Project menu option, which was derived from the Workspace Project process is available here for creating a standard Project.The New Project with PLM initialize dialog (as named in this example) is defined in the matching Workspace Process workflow and its user interface Form. Enter the new project name, type, applied template, etc., and if necessary, edit the project storage paths under the dialog\u2019s Advanced tab.Use the following Login Credentials dialog to select the Workspace PLM template that applies, and therefore the targeted PLM instance, along with your PLM sign-in credentials. The credentials are saved with the Project and will not be requested for subsequent PLM interactions with the project.As the process proceeds, its steps and status may be monitored in the Tasklist panel (View \u00bb Panels \u00bb Tasklist). When all active tasks are completed, the final status of the process activity may be viewed by selecting the Show Closed option in the Activities listing. Select the refresh button () to update the entries.Successful completion of the New Project with PLM initialize process will have the following results:\t\t\tA new project is created in the active Workspace and made available in Altium Designer.\t\t\t\tThe project release structure items, with associated PLM Part Numbers, are added to the PLM instance.\t\t\t\tThe part numbers generated by the PLM are ported back to Altium Designer as PLM PartNumber parameters.\tThe items (generally shown as files) created within the PLM instance correspond to the Altium Designer project release packages, as shown in Releases section of Altium Designer&#039;s\u00a0Explorer panel (Project View). The naming of the items, and their associated attributes, are defined by the PLM instance configuration in the Workspace (Altium 365 Workspace, Enterprise Server Workspace) \u2013 specifically, within the XML configuration file.\tNote that the release entries in the PLM instance are normally accessed by the wider enterprise (procurement, etc.,) and are generally not the domain of an ECAD design engineer. They are shown here in a typical format by way of example.Within the PLM structure, the included Project parent item defines the parent-child relationships in the release \u2013 here titled Altium Designer Project \u2013 Project 7, with an associated PLM Part number of 0000023627. The PLM project structure will be updated and added to when the Altium Designer Project has been developed and then released to the Workspace and PLM.The PLM item part numbers generated by the PLM instance are transferred back to the Workspace\u00a0during the PLM structure initialization process. They become available as Workspace-hosted Parameters in the Project and can be applied as special text strings in a schematic document. Note that the names of the generated parameters and their Value number format are determined by the PLM installation itself.Publish to PLM - User selectsThe Publish to PLM (User selects) process allows you to choose specific revisions of released Project data to be pushed to a PLM instance.Where items already exist in the PLM for a given project, such as the initialized PLM structure for a project as outlined above (Project with Initialize in PLM), the items are updated and added to as required. Where released data for a Project does not already exist in the PLM instance, the structure and data are added to PLM. In both cases, PLM part numbers will be assigned to any new PLM items and passed back to Altium Designer as parameters.In the example shown here, the Process is named Publish to PLM \u2013 select and was derived from the Publish to PLM (User Selects) template process in the\u00a0Workspace.\u00a0 Note that if the selected project has not been released to the Workspace, no release packages will be available for propagation to PLM. To start the process from the design environment select Project \u00bb Project Activities \u00bb Publish to PLM \u2013 select (or your equivalent process) from the main menu.The following Publishing to PLM \u2013 select dialog automatically selects the currently active Altium Designer project for publishing to PLM, however the Project drop-down menu and its type ahead filtering may be used to select any released project in the\u00a0Workspace as an alternative.The dialog&#039;s Request title field allows the process to be renamed for this publish to PLM task. The AUTO setting names the task as its process name \u2013 in this case, Publish to PLM - select. Click the dialog&#039;s\u00a0 button to invoke the Publish to PLM process.The following Select data to publish dialog allows you to choose a particular project revision release and then release packages from within that release.Alternatively, select the dialog\u2019s browse button () to open the Choose Design Review Dataset explorer dialog where specific sets of released data can be specified for publishing. Note that to see all revisions of the released data, the Show only latest option must be deselected in the dialog\u2019s  menu.Through either of the above two methods, a list of dataset revisions for publishing can be built up in the Select data to publish dialog.Submitting that list () for publishing accesses the PLM instance, which will respond by requesting your PLM user credentials. Submit these to confirm and start the publish to PLM action.The progress of the publishing process can be monitored in the Tasklist panel (View \u00bb Panels \u00bb Tasklist), where the named task and its status will be included in the panel\u2019s Tasks list and as a closed activity when successfully completed. With the panel&#039;s Show closed option enabled, selecting a closed activity will open a corresponding information dialog that includes a task&#039;s related PLM publish details (Data tab) and a graphic representation of its process flow status (Diagram tab).\tUnder the dialog&#039;s Data tab, click the PLM Publish Completed Log file entry (*.log) to download a plain text file that reports the sequence of events in the activity workflow.\u00a0Within the PLM instance itself (Windchill in this example) the item entries will be added to include the specified project release data. Note that the structure of the created Windchill entries and data will depend on its setup and the configuration of the Altium Designer PLM publishing template.In this example, PLM items have been added for the specified revisions of the released Assembly and Fabrication files for Project 5, along with entries for the Components used in the design. Note that component CAP01005 already existed in PLM from a previous publishing process.Content and StructureFor all types of Altium Designer to PLM data interaction, the PLM parent-child structure of the entries can be seen by selecting a file release item, or in Altium Designer terms, a release package, which will show its constituent file collection.The PLM publishing process will also include components used in the design, as shown above.The configuration of the Workspace PLM publishing template (Altium 365 Workspace, Enterprise Server Workspace) will determine when\/if component entries are created in PLM. With the template\u2019s default configuration, component entries that already exist in PLM will be linked to, and those that are not in PLM will be created and linked to.When a new component item has been created in PLM, its PLM part number is ported back to the matching Component in the Workspace as a parameter. The below image shows a component\u2019s parameters list in the Explorer panel before and after it has been published to PLM with a released design project.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-publishing-plm.html"},
{"title":"Process-based Project Creation","text":"Related pages: Processes &amp; Workflows (Altium 365 Workspace, Enterprise Server Workspace), Creating &amp; Managing Processes (Altium 365 Workspace, Enterprise Server Workspace)Creating a New Process-based Workspace ProjectWhen one or more process definitions for the Project Creations process theme are active, the ability to create a new project through the\u00a0Create Project dialog\u00a0is restricted to Local and VCS type projects only. Instead, the creation of Workspace-based projects comes under the control of active process definitions.From within Altium Designer, activated process definitions that are part of the Project Creations theme can be accessed from the main\u00a0File \u00bb New \u00bb Project in  sub-menu.\u00a0After launching the chosen command, the\u00a0Create New Project\u00a0dialog (actually named after the chosen process) opens. Use the\u00a0General\u00a0tab of the dialog to give the project a name and description, specify its type,\u00a0and assign a template, if desired. On the\u00a0Advanced tab, you can specify the local working directory for the project, choose the target repository and folder and also specify in which folder, within the Workspace&#039;s folder structure, it is to reside. Once ready, click\u00a0Start to create the new Workspace project in accordance with the underlying workflow for that process.\t\t\t\t\t\tTo use the Constraint Manager for managing the design constraints for your process-based Workspace PCB project, ensure to assign an appropriate project template when creating that project. This should be a template that was saved from a PCB project that was created with its Constraint Management option enabled in the Create Project dialog.\t\t\t\t\t\t\t\t\t\tIf the Change Order (ECO) workflow is configured in the\u00a0PLM interface instance (learn more), an additional Change Order Form will be presented during project creation, where the Change Order&#039;s setup and options are specified ().\t\t\t\t\t\t\tThe dialog with which to start creation of a project, based on a define process workflow. Note that the name of the dialog will reflect the name of the chosen process.\t    Options and Controls of the Create New Project Dialog    \tGeneral Tab\t\t\t\t\t\t\t\tProject Name - enter a suitable name for the Workspace project.\t\t\t\t\t\t\t\t\t\tThe project name must start with\u00a0and can contain lower or uppercase letters or 0-9. Underscores, dashes, and spaces are allowed\u00a0but can only be used in the middle of the name (beginning and ending spaces will be ignored). You cannot use the following words:\u00a0AUX,\u00a0COM1-COM9,\u00a0LPT1-LPT9,\u00a0CON,\u00a0NUL, or\u00a0PRN. In addition, the name cannot contain the following characters: \\ . \/ ? % * : | &quot; &lt; &gt;.\t\t\t\t\t\t\t\t\t\tDescription - enter a meaningful description of the project.\t\t\t\t\t\t\tPCB Project Type - use the drop-down to select a suitable project type.\t\t\t\t\t\t\tProject Template - use the drop-down to select the desired template from\u00a0a list of installed templates. Click\u00a0\u00a0to open a version of the Explorer panel\u00a0(titled Select Project Template) to select the desired template.\t\t\t\t\t\t\tStart - when clicked, the\u00a0project will be created in accordance with the underlying workflow process.\t\t\t\tAdvanced Tab\t\t\t\t\t\t\t\tLocation - use to specify the location where the project will be located. Click\u00a0\u00a0to browse and select the desired location.\t\t\t\t\t\t\tCreate Project Folder - check to create a new project folder automatically.\t\t\t\t\t\t\tRepository - use the drop-down to select the desired repository for the project.\t\t\t\t\t\t\tRepository Folder - click\u00a0\u00a0to open the Add to Version Control dialog in which you can specify the repository folder.\t\t\t\t\t\t\t\t\t\tThe folder name must start with\u00a0and can contain lower or uppercase letters or 0-9 and underscores. dashes, and spaces are allowed\u00a0but can only be used in the middle of the name (beginning and ending spaces will be ignored). You cannot use the following words:\u00a0AUX,\u00a0COM1-COM9,\u00a0LPT1-LPT9,\u00a0CON,\u00a0NUL, or\u00a0PRN.\t\t\t\t\t\t\t\t\t\tServer Folder - use to specify the server folder. Click\u00a0\u00a0to open the Choose Folder dialog in which you can choose the desired folder.\t\t\t\t\t\t\t\t\t\tThe server folder path can start with any symbol except space or slash and can contain any symbol except space at the end. Spaces are allowed in the middle of the server folder name.\t\t\t\t\t\t\tProcess-based Project ConvertingWhen the connected Workspace includes activated process definitions that are part of the Project Creations theme, the\u00a0indexed\u00a0commands can be\u00a0accessed by right-clicking on a local project in the\u00a0Projects\u00a0panel and selecting the desired process from the Convert to Managed Project\u00a0sub-menu.\tIf no active process definitions are available for the Project Creations process theme - in your active Workspace - the sub-menu\u00a0will not be visible.After launching the command, the Create\u00a0Project dialog\u00a0(actually named after the chosen process) opens. Use the General tab of the dialog to\u00a0describe the project and\u00a0specify the type of project and template, if desired. On the Advanced tab, you can specify the location of the project\u00a0and choose the repository, and repository and Workspace folders. Once ready, click Start to create the new Workspace project in accordance with the underlying workflow for that process.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-process-based-project-creation.html"},
{"title":"Design Variants","text":"\u00a0 When a product needs to be designed and produced as a number of variations of that product, where each has different options or capabilities, the ability to implement Design Variants avoids the need to create a unique version of the design for each variation.In practice, a Design Variant uses the same base design, but the PCB assembly is loaded with the set of components specified by the variation. A variation may then be nominated when generating the design\u2019s manufacturing output (BOM, P&amp;P, Assembly drawings, etc), which will, in turn, determine how the product is assembled.The ability to create variations of the same base design adds significant flexibility to how PCB projects are created in Altium Designer. Using Variants, you can define any number of variations of the board design, where each component may be configured as:\tFitted to the board.\tNot fitted to the board.\tFitted to the board, but with modified component parameters, such as its value.\tA completely different component, as an alternative replacement part.Design Variants that use any of these types of variations are all referred to as Assembly Variants, as they only impact the assembly process \u2013 in this case, all variants share the same fabricated bare board.Altium Designer also supports variations to component overlay information on the PCB, such as changing a component\u2019s Comment, for example. Such a variation requires the production of two overlay screens, which results in the manufacture of two different bare boards. This type of variant is referred to as a Fabrication Variant.Design Variants are managed, created and edited in Altium Designer&#039;s Variant Management dialog or the Variant Manager document-based interface. Use the\u00a0Project \u00bb Variants\u00a0command\u00a0from the main menus or the Variants\u00a0command, from the context menu of the project&#039;s entry in the Projects panel to access. To learn more, refer to the following pages:\tWorking with the Variant Management Dialog\u00a0\tWorking with the Variant ManagerLogical and Physical ComponentsIt is helpful to understand that there are essentially two types of components in Altium Designer; logical components and physical components. The distinction is that components placed on the schematic sheet are logical components, where each is a conceptual entity that represents the physical component that is ultimately mounted on the assembled PCB.While this one-to-one, logical-to-physical model works well for a simple design, it cannot support some of Altium Designer&#039;s more powerful features. Examples of this are multi-channel designs, where a section of circuitry is &#039;stamped out&#039; as many times as required, and variants, where a single design can be implemented with different components fitted to each variation of the board design. Such features require the ability for one logical component to represent multiple physical components.Altium Designer delivers this one-to-many capability through its compiler technology. When the logical design is compiled (an automated process), each physical component is instantiated in memory, ready for transfer to the board design space.To cater for situations where access to the physical components is required at a schematic level, such as when defining design variations, the physical design is also made available in the schematic editor through tabs located at the bottom of the schematic sheet. Here, the left-most Editor tab selects the (normal) captured logical design, and the other &#039;compiled&#039; tabs represent the equivalent physical design as it will be transferred to the PCB design space \u2013 note that the schematic under a compiled tab is read-only.To learn more about working with design variants in the design, refer to the\u00a0Working with Variants in the Design\u00a0page. The schematic editor&#039;s physical schematic design view. Select the desired project variation by double-clicking on a Variant entry in the Projects panel.To examine design variations, double-click on the required variant in the Projects panel and switch to a compiled (physical design) tab of the schematic. The compiled tab displays a different Active Bar at the top of the design space, which includes variant-specific buttons. These buttons are only available when a variant is selected in the Projects panel.The last variant that was set prior to closing a project is remembered and will be the variant presented when the project is reopened.Note that when you switch to a compiled tab the available menu entries will change, reflecting the commands that can be run when you are viewing the physical design. Click on the logical design tab (Editor) at the bottom of the schematic sheet to return to the standard editing menus.Types of VariationsThe Variants feature, as the name implies, creates variations of the original, or \u2018base\u2019, PCB design. Once this base design has been established, Variants are established in the variant manager by configuring the board components to be\u00a0Fitted, Fitted with varied parameters, Not Fitted, or to use an Alternate Part.Fitted&#039;Fitted&#039; is the default state of a component before any variations are applied \u2013 if it is Fitted, then it is not varied. All components default to Fitted when a new variation is created in the Variant Management dialog (see below), which represents a Fitted component state as an empty cell.Fitted with Varied Parameter(s)The variant definition process allows a component to have any of its parameters varied. Modifying the value of a parameter is a local variation and will only affect the output documentation \u2013 the original schematic, and the component whose parameter is being varied, are not modified in any way. In the image below, C8 has the Value parameter varied, and this variation is indicated by the italic font used to display its value string.Not FittedWhen a component is set to Not Fitted it still exists on the schematic and will be transferred to the PCB (so the footprint can be placed), but it is removed from the appropriate output documentation, such as the BOM. The way in which Not Fitted components are presented in the documentation can be configured, for example, set as marked with a cross on the schematic and in PCB drawing outputs \u2013 see the Configuring Display of Varied Components in Design Documents. With the selected variation (BGA); C6\u00a0is fitted, C5 and C7 are not fitted, and C8 is fitted, but with a varied parameter value.Alternate PartA variation can also be set to an entirely different component, as an Alternate Part. When the compiled tab is selected in the schematic editor, the alternate part will be shown when changing between Variants. For this type of variation, the alternate part must share the same set of schematic pins, placed in the same locations, as the base part. This is an essential requirement to ensure that the connectivity remains valid when the design is compiled. Hover the cursor over the image below to show the alternate parts for R3 and Q1 in the TSOP variant. Q1 is an NPN transistor in the BGA variant, and a JFET in the TSOP variant (hover the mouse over the image to show the TSOP) \u2013 note that the same pins are used in each case.There are two ways an Alternate Part is handled on the PCB:\tIf the footprint is the same \u2013 if the chosen Alternate Part has the same footprint name as the base part, then only one instance of that footprint will be transferred to the PCB. As multiple footprints can be assigned to a component, you should ensure that the correct footprint is selected in the Variant Management dialog for each variant.\tIf the footprint changes \u2013 if the chosen Alternate Part has a different footprint name from the base part, then both footprints are transferred to the PCB. You must then decide how to position the two footprints on the PCB. Note that both footprints will have the same designator, as only one or the other component is ever fitted. The animation below shows how this situation could be handled when one variant has BGA SRAM, and the other variant has TSOP SRAM.Changing the Type of ComponentThe ability to select an alternate part is not restricted to choosing the same type of component, so you can, for example, have a base component that is a resistor, then define an alternate part that is a capacitor. It is important to be aware of the consequences of this type of alternate part:\tDesignator \u2013 there is only one designator for each logical, base component, and it is this designator that is used for all variants. If a resistor is swapped for a capacitor, for example, you might want to consider using a special designator prefix to indicate this, such as R_C\u00a0or R-C.\tPins \u2013 the alternate component must have the same number of pins as the base component, and these pins must be in the same location and of the same electrical type. A warning will appear if these conditions are not met.Multi-Channel DesignsMain article: Multi-Sheet and Multi-Channel DesignMulti-channel design allows the designer to nominate a single schematic sheet, or a tree of sheets, to be repeated \u2013 effectively stamping out this section of the design multiple times. Manual copying and pasting are not required since the software manages the stamping-out process, while the designer simply defines the annotation method used to identify the repeated components.In Altium Designer, multi-channel designs, the ability to replace a base component with a completely different component is supported for a selected variant.  In the animation, the BGA variant has two SRAM fitted, while the TSOP variant has four SRAM fitted. This is achieved by Not Fitting one of the two memory channels in the BGA variant.In terms of channels, a variant can have components varied across all channels or within a specific channel, which includes the variations of\u00a0components Fitted\/Not Fitted, specific component parameters varied, or Alternate Parts.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-design-variants.html"},
{"title":"Working with the Variant Management Dialog","text":"Variants are created and configured in the Variant Management dialog. To open the dialog, select Variants from the Project menu (shortcut: C, V) or\u00a0right-click on the project name in the\u00a0Projects panel\u00a0then select\u00a0Variants.\tThe dialog can also be accessed by\u00a0right-clicking on a placed component in the schematic editor,\u00a0then selecting\u00a0Part Actions \u00bb Variants. In this case, the dialog will be populated with the parts that are currently selected in the schematic editor.\tThe\u00a0Variant Management dialog is available when the UI.ModernVariantsManager option is disabled in the Advanced Settings dialog. When the UI.ModernVariantsManager option is enabled, the Variant Manager\u00a0is used for creating and configuring design variants.\tThe dialog has two main regions:\t\t\tThe upper Components for project region, which lists all of the components in the base design, and if applicable, columns for the applied Variants.\t\t\t\tThe lower Component Parameters region, which details all of the parameters of the component(s) currently selected in the upper region, and if applicable, columns for the applied Variants.\t \tVariants are created and configured in the Variant Management dialog.\t    Options and Controls of the Variant Management Dialog    \tComponents\t\t\t\t\t\tProject Components \u2013 this region lists each component in the project. For each component, the Hierarchy Path and Logical designator are listed\u00a0as well as Name\u00a0and physical Designator. The Document and Original Library Link lists where source documents are located.\t\t\t\t\t\t\t\t\tDouble-click on a component\u00a0or right-click then select the Cross Probe option\u00a0to jump to that component on the schematic.\t\t\t\t\t\t\tVariant of\u00a0\u2013\u00a0after a new variant is added, a dedicated column appears to the right of Project Components. The name given the new variant appears as the title and the Component Variation column lists any variations for each component. Once the variant has been created, you can configure the state of each component. This is done by clicking the component cell in the new column to reveal \u00a0or by right-clicking to access the context menu commands. When \u00a0is clicked, the Edit Component Variation dialog opens and presents three choices:\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tFitted \u2013 the original component as used in the base design is also fitted\/used in this variant of that design. For a newly added variant, all components are Fitted by default and the cell is empty. Note that individual parameters can also be varied for a Fitted component \u2013 type in the new parameter value. Varied parameters are shown in bold.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tNot Fitted \u2013 the original component as used in the base design is not fitted\/used in this variant of that design. For a Not Fitted component, the cell displays the text Not Fitted.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAlternate Part \u2013 this option gives access to browsing and selecting the alternate part. Once chosen, the cell displays the alternate part&#039;s Library Link or server component, whichever was chosen. The lower region of the dialog will display all of the parameters in the alternate part.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tTo make a variant active in the dialog, either click on that variant&#039;s name in the column header\u00a0or click in any of that variant&#039;s cells.\t\t\t\tWhen you configure variations in this dialog, the settings are saved in the project file. This includes the Not Fitted state, local parameter variations to a Fitted component, and the parameter values of Alternate Parts. The Alternate Parts are stored in the file .PrjPcbVariants.\t\t\t\tTo change the order the variants are listed, click and hold on the column heading, then drag that column to a new location. Use this in combination with the Fit to Width checkbox to position and size the variant of interest in your preferred working location.\t\t\t\t\t\t\tRight-click Commands \u2013 the following commands are available on the Components region&#039;s right-click menu:\t\t\t\t\t\t\t\t\tColumns \u2013 click to see\/hide columns that are not needed. Toggle the visibility of any column.\t\t\t\t\t\t\tEdit Selected \u2013 make changes to the selected component.\t\t\t\t\t\t\t\t\tSet Selected As \u2013 click to change to Fitted, Not Fitted, or Alternate.\t\t\t\t\t\t\tOnly Show Varied Components \u2013 click to show varied components in the listing.\t\t\t\t\t\t\tFilter \u2013 click to filter components listed by Show Fitted with Varied Parameters, Show Not Fitted, or Show Alternate.\t\t\t\t\t\tIf you have been experimenting with the Filter options and have applied different filters, you may need to reset the filter before attempting another update. To do this, disable the Only Show Varied Components option to clear the filter system, then re-apply it and clear the Filter options as required.\t\t\t\t\t\t\tCut \u2013 click to delete the selected variant.\t\t\t\t\t\t\tCopy \u2013 click to make a copy of the selected item.\t\t\t\t\t\t\tReport \u2013 click to open the Report Preview dialog to create a printout of the Components region.\t\t\t\t\t\t\tSave All \u2013 click to open a\u00a0dialog to save a listing of all project components to another location\u00a0as a tab formatted text file.\t\t\t\t\t\t\tSave Selected \u2013 click to open a\u00a0dialog to save a listing of all selected project components to another location\u00a0as a tab formatted text file.\t\t\t\t\t\t\tSelect All \u2013 click to select all cells.\t\t\t\t\t\t\tSelect Column \u2013 click to select the current column.\t\t\t\t\t\t\tInvert Selection \u2013 click to select all components other than those that are currently selected.\t\t\t\t\t\t\tCross Probe \u2013 click to show\u00a0the selected component&#039;s location on the schematic.\t\t\t\t\t\tStandard Windows multi-select techniques are supported; use these to select and configure multiple components simultaneously.\t\tComponent Parameters\tEach component in the dialog can have Parameter Variations. The Parameter Name and its Original Value are listed\u00a0along with New Value listings for columns representing variants that have been added. The New Value that appears is a copy of the base design component value until changes are made. Right-click in a cell to access the range of parameter commands from the pop-up menu. The menu offers the following options:\t\t\t\t\t\t\tEdit Selected \u2013 click to change New Value of the selected variant cell.\t\t\t\t\t\t\tReset Selected \u2013 click to restore New Value back to original value.\t\t\t\t\t\t\tReset All \u2013 click to restore all New Value cells to their original value, regardless of current selection.\t\t\t\t\t\tEdit Selected, Reset Selected, and Reset All are available only when right-clicking in an added variant column.\t\t\t\t\t\t\tUpdate Values From Library \u2013 click to bring any parameter changes made to a library component that has been used as an Alternate Part into the variant definitions. Note that this updates the parameters only\u00a0and not the component itself.\t\t\t\t\t\t\tOnly Show Varied Values \u2013 click to show only those values that have been varied from the original values.\t\t\t\t\t\t\tCut \u2013 click to delete cell contents. A Confirm window opens for confirmation before deletion occurs.\t\t\t\t\t\tCut is available only when right-click is done in the Component Variation and New Value columns.\t\t\t\t\t\t\tCopy \u2013 click to make a copy of the selected item.\t\t\t\t\t\t\tReport \u2013 click to open the Report Preview dialog to create a printout of the Component Parameters region.\t\t\t\t\t\t\tSave All \u2013 click to open a\u00a0dialog to save all parameters for the selected component to a formatted text file in another location.\t\t\t\t\t\t\tSave Selected \u2013 click to open a\u00a0dialog to save all selected parameters to a formatted text file in another location.\t\t\t\t\t\t\tSelect All \u2013 click to select all cells.\t\t\t\t\t\t\tSelect Column \u2013 click to select the current column.\t\t\t\t\t\t\tInvert Selection \u2013 click to select all parameters other than those that are currently selected.\t\t\t\tAdditional Controls\t\t\t\t\t\tAdd Variant\u00a0\u2013 click to open the Edit Project Variant dialog to create a new variant of the base design. Use this dialog to add, edit\u00a0or remove a variant\u00a0and specify any required variant-level parametric data. This button includes a drop-down that is used to access the Make a copy of the Selected Variant command. Copying is particularly useful when you need to define a number of variants that are very similar.\t\t\t\t\t\t\tDelete Variant \u2013 click to delete selected variant(s). A\u00a0dialog opens for confirmation before deletion occurs.\t\t\t\t\t\t\tEdit Variant \u2013 click to open Edit Project Variant dialog to edit a variant.\t\t\t\t\t\t\tDetailed Report \u2013 click\u00a0to open the Variant Report dialog to generate a detailed variant report in HTML format.\t\t\t\t\t\t\tDrawing Style \u2013 click\u00a0to access the Variant Options dialog in which you can define how non-fitted components and varied parameters will appear, both in the compiled document view of the schematic and in schematic prints. You can also define the appearance for these components in PCB assembly drawings.\t\t\t\t\t\t\tFit to Width \u2013 check this option to automatically adjust the width of the columns\u00a0based on the content.\t\t\t\t\t\tFor information on how to add and view variants to an Output Job file, visit the Preparing Manufacturing Data with Output Jobs page.\t\t\tDouble-click on a component in the Variant Management dialog to jump to that component on the schematic or select Cross Probe from the right-click context menu.\tCreating a New VariantClick the  button in the Variant Management dialog to create a new variant of the base design. The Edit Project Variant dialog will open.At the very minimum, enter a name for the variant in the Description field, which, by default, will have the entry Variant of . If Fabrication Variants need to be generated from the design, enable the\u00a0Allow variation of fabrication outputs\u00a0option in\u00a0the\u00a0Edit Project Variant dialog. If Paste Mask outputs need to be generated for a design that includes variants with &#039;Not Fitted&#039; components, enable the\u00a0Allow variation for paste mask\u00a0option. These components will no longer have Paste Mask included on their pads.You can also define parameters for the variant. For details on how to do this and how variant-level parameters fit into the parametric hierarchy within Altium Designer, see Working with Variant Parameters.With the variant defined as required, click OK. An additional column will then appear on the right of the Variant Management dialog, with the new Variant name as the column title. All the cells will be empty, where an empty cell indicates that this component is Fitted and unchanged from the base design. The components can now be configured for the new variant. The image below shows a project that has had two variants created, BGA and TSOP. \tRegion 1\u00a0details the components in the base design, region 2 details the components in the BGA variant, and region 3 details the components in the TSOP variant.\tTo make a variant the active selection, click its variant name in the column header, or click in any of that variant&#039;s cells.\tThe Variant Management dialog includes a number of interface features that assist the display of useful information. These are configured via the right-click context menu. Useful commands include:\t\t\tColumns:\t\t\t\t\t\t\t\t\tHierarchy Path column \u2013 shows the location of the component in the design hierarchy.\t\t\t\t\t\t\t\t\t\tOriginal Library Link column \u2013 details where the base component was sourced from.\t\t\t\t\t\t\t\t\tSet Selected As \u2013 submenu used to choose the type of variation (Fitted, Not Fitted, Alternate). Can be used instead of clicking the  control in the component cell. Only available when you right-click on a Variant&#039;s component cell.\t\t\t\tOnly Show Varied Parameters \u2013 only display components that have some form of variation applied, in the Variant Management dialog.\t\t\t\tFilter \u2013 submenu that gives control of which types of variations are displayed in the Variant Management dialog (Varied Parameters, Not Fitted, Alternate). Works well in combination with the Only Show Varied Parameters command.\t\tVaried parameters \u2013 a parameter that is varied from the base design is shown in bold in the Component Parameters area of the Variant Management dialog, making it easy to visually identify.\tDefining Component VariationsOnce the Variant itself has been created, the state of each component is ready to be varied. This can be done by clicking on a component cell in the variant column to reveal the  control, or by right-clicking on the cell\u00a0and choosing the required entry from the\u00a0Set Selected As\u00a0context sub-menu.The  control opens the Edit Component Variation dialog.\tThe Edit Component Variation dialog can also be accessed from the compiled tab of a schematic by right-clicking on a component with a defined variant, then choosing\u00a0Part Actions\u00a0 \u00bb Choose Alternate Part. Three choices are offered:\t\t\tFitted \u2013 The original component as used in the base design is also fitted\/used in this variant of that design. For a newly added variant, all components are fitted by default, and the cells for these fitted components are empty. Note that individual parameters can also be varied for a fitted component, by simply typing in a new parameter value in the dialog&#039;s Component Parameters region for that Variant.\t\t\t\tNot Fitted \u2013 The original component as used in the base design is not fitted\/used in this variant of that design. For a Not Fitted component status, the cell displays the text Not Fitted and the dialog&#039;s lower Component Parameters region will be blank.\t\t\t\tAlternate Part \u2013 This option allows a different (alternate) part to be selected. The dialog will expand to include controls to browse and locate the required replacement component.\u00a0Once that part is chosen, the cell displays the alternate part&#039;s source Link. The lower Component Parameters region of the dialog will display all of the parameters in the alternate part. See the next section for more information.\t\tStandard Windows multi-select techniques are supported. Use these to select and configure multiple components simultaneously.\tChoosing an Alternate PartWhen the Alternate Part option is selected, the Edit Component Variation dialog expands to show the base parameters of the existing part. Use the  button to browse and locate the required alternate part component in the Replace Component dialog\u00a0\u2013 a modal dialog version of the Components panel. All of Altium Designer&#039;s component storage models are supported, such as independent libraries, database libraries, as well as Workspace Library components (as shown in the example below).\tAfter selecting an alternate part, the software checks for pin compatibility between the selected alternate component and the original base design component. To be pin-compatible, the alternate must have the same number of pins as the original component, and those pins must be identical in their location and electrical type. The graphical primitives used in the symbols for the two components are not required to match. If the software detects that the alternate component is not pin-compatible, a Confirm dialog must be dismissed before the replacement is accepted. In this case, you need to be mindful of the potential impact on the wiring, and that an error violation may be encountered as the design is validated (Project \u00bb Validate, ).\t \tAn example of an Alternate Part variation.The newly applied alternative component can be checked back in the design space. In the applicable schematic sheet for that component, switch to the compiled tab view and then select the required variant in the Variants section of the project, in the Projects panel.The Schematic editor will use the symbol graphics for the alternate component, however, if the component is pin-compatible and graphically similar there may be little noticeable change.You can choose an alternate part with no changes to a symbol on a schematic or needing to add a footprint to the PCB.\u00a0In the Edit Project Variant dialog, enable the\u00a0Do not overwrite schematic symbol\u00a0and\/or\u00a0Do not overwrite PCB footprint\u00a0options as needed. When the latter is enabled,\u00a0a footprint of an alternative component applied to a variant will not be transferred to the PCB as part of the PCB update (an ECO to add the footprint to the PCB will not be generated).\u00a0Parameters for the chosen alternate are faithfully presented in the ActiveBOM.To help make it easy to visually identify varied components, the color and font of varied parameters (such as the component comment string), can also be varied. This is configured in the Variant Options dialog. Click Drawing Style\u00a0in the Variant Management dialog to open the dialog. Note the green italic font used for the alternate component in the animation below. Graphically identifying the varied component; in this example, both variants use the same component symbol, but the BGA variant uses a different size SRAM.\tIf an alternate component is not already used in some part of the design, the symbol graphics for the alternate component are stored in the project folder as a dedicated file type: [ProjectName].PrjPcbVariants. Using the .PrjPcbVariants file keeps the project independent from the source libraries that were used to create the design. Note that parameters change\u00a0for the alternate components defined in the Variant Management dialog are saved in the project file itself.\tSymbol Display ModeIf a base component uses a graphical display mode other than the default Normal Mode, and it also has an alternate component defined in a variant, then the alternate component will attempt to use the same graphical display mode. Conversely, if the alternate component does not include this graphical display mode, then the Normal mode is used.Part view Modes are defined in the Schematic Library Editor\u00a0and are selected for a placed component in the Graphical section of the Properties panel, as shown below. In this example the base part symbol uses Mode, Alternate 1. \tAn Alternate Part will attempt to use the same graphical display mode number as the base part.\tRefer to the\u00a0Creating a Schematic Symbol\u00a0- Display Modes page to learn more.Variants When a DbLink File is UsedAltium Designer supports several ways of storing and working with components, including the use of a DBLink file with the project. A DBLink file is an interface between the components on the schematic and a company database.Rather than just creating a reference from each component to a specific database record (as is typically done when you place a component from a DBLib-type library), the DBLink model relies on the designer initiating a query action based on one or more component parameters. The software then searches the database for a record with fields that contain matching values, and when a match occurs, other field values from that record (such as the Part Number) can be returned to the Altium Designer component. The component parameter-to-database field mapping is defined in the DBLink document, as is the target database.\u25ba Learn more about Database LibrariesIn a design that does not use Variants, the query action is performed via the Update Parameters from Database command, and can also be performed during BOM generation by enabling the Include Parameters from Database option (see below), to extract BOM-specific component data, such as price.For a design that includes Variants, the parameters used to query the database are varied in the Variant Management dialog. Since those parameter values only exist in the Variant Management dialog, the Update Parameters from Database command is not used to retrieve database information \u2013 instead the parameters are extracted from the database when the BOM is being generated.Display of Variant Management Dialog\u00a0DataThe Variant Management dialog includes features to help control the amount of data displayed, which is particularly useful when working on a large design.\t\t\tTo remove columns that are not of interest, right-click in the\u00a0upper part of the dialog and use the Columns option in the context menu to toggle the visibility of any column.\t\t\t\tTo display only those components being varied, right-click in the upper part of the dialog and select Only Show Varied Components option from the context menu.\t\t\t\tWhen the Only Show Varied Components mode has been selected, right-click again and configure the Filter options. In the image shown below, the Filter has been configured to display only those components that use Alternate Parts.\t\t\t\tTo change the order of the listed Variants, select and drag a variant column heading to a new location. Use this in combination with the Fit to Width checkbox to position and size the variant of interest.\t \tThe Variant Management dialog, with columns hidden and a filter applied to only show components that use an Alternate Part.Resetting and Updating Variant DataDesign variations set up in the Variant Management dialog are ultimately saved in the project file. This includes the Not Fitted state, local parameter variations to a Fitted component, and the parameter values of Alternate Parts. The actual Alternate Parts are stored in a [ProjectName].PrjPcbVariants file. The Variant Management dialog includes commands for resetting parameters and updating components, which helps to ensure that they are in sync with the source component libraries.Updating a Varied ParameterParameters modified locally in the Variant Management dialog can be restored to their original value by right-clicking on the modified parameter (shown in bold) in the Variant Parameter list, and then choosing Reset Selected from the context menu \u2013 as shown below. Note that multiple parameters can be selected at once then reset in a single action, or Reset All used to reset all parameters for that component. \tModified parameter(s) can have their value(s) restored using the Reset Selected command.Updating an Alternate Part ParameterIf a library component that is used as an Alternate Part has had parameters changed in the library, you can bring those changes directly into the variant definitions in your project by right-clicking in that Variant&#039;s Parameter list and selecting Update Values from Library from the menu (as shown below). Note that this updates the parameters;\u00a0if you need to update the graphic, use the technique described below. \tIf an Alternate Part component has been modified in the library, use the Update Values from Library command to refresh the copy used in the project.Following the Update Values from Library command, browse to and locate the component in the source library via the Browse Libraries dialog\u00a0and click OK to open the Update Project Variants From Library dialog. Select\/deselect the Parameters from Library Component and Variants to Update, then click OK to complete the update process.\tIf the component selected for a parameter update is a Workspace component, a basic modal dialog version of the Components panel will be opened rather than the Browse Libraries dialog. Browse or Search to locate the component, click OK to open the Update Project Variants From Library dialog then select\u00a0the desired parameters for updating, as described here. \tUpdating a varied component from the source library. Here you configure which parameters are updated, and to which variant the updates are applied.\t    Options and Controls of the Browse Libraries Dialog    \t\t\t\t\t\tLibraries - displays the current library. Use the drop-down arrow to access a list of available libraries then select the desired\u00a0target library. Click the\u00a0\u00a0button to open the Available File-based Libraries dialog in which you can add or remove libraries.\t\t\t\t\t\t\tFind - click to open the\u00a0File-based Libraries Search dialog to locate additional libraries.\t\t\t\t\t\t\tMask - enter the desired key words to mask results in the Component Name list. The drop-down lists previously used key words.\t\t\t\tUpper Grid\u00a0\t\t\t\t\t\tComponent Name - displays the name of the component.\t\t\t\t\t\t\tLibrary - displays in which library the component is located. \u00a0\t\t\t\t\t\t\tDescription\u00a0- a brief description of the component.\t\t\t\t\t\t\tFootprint - displays the associated footprint (if any).\t\t\t\t\t\t\t components - displays the total number (nn) of components.\t\t\t\tLower Grid\t\t\t\t\t\tModel Name\u00a0- displays the model name of a component currently selected in the upper grid.\t\t\t\t\t\t\tType\u00a0- displays the model type of a component currently selected in the upper grid.\t\t\t\tPreview Windows\t\t\t\t\t\tUpper Window - displays the schematic symbol of the component currently selected in the upper grid.\t\t\t\t\t\t\tLower Window - displays the footprint of the component currently selected in the upper grid.\t\t\t\t\t\t\t\t\t\t\t\t\u00a02D\/3D\u00a0- use to toggle between 2D and 3D preview images.\u00a0\t\t\t\t\t\t\t\t\t\t\t\t    Options and Controls of the Update Project Variants From Library Dialog    \t\t\t\t\t\tParameters from Grid\u00a0- lists of\u00a0all parameters and their values of the selected component. Check the box to select\u00a0the parameters to be updated. Parameters are grayed out if they cannot be used to update (e.g.,\u00a0when no components contain\u00a0a parameter of that name).\t\t\t\t\t\t\tProject Variants To Update\u00a0Grid -\u00a0a list of all variants that currently exist in the project. Check the box to select\u00a0the variants to be updated.\t\t\t\t\t\t\tChoose Component\u00a0- click to open a dialog\u00a0in which you can search for components.\t\t\t\tAll parameters are listed on the left of the Update Project Variants From Library dialog \u2013 if required, any parameter can be deselected to exclude it from the update process. On the right of the dialog, the target Project Variant can be changed (Project Variant To Update). This will default to select the Variant that was selected when the Update Values from Library command was activated.\tNote that this parameter update process brings parameter values directly from the library into the Variant Management dialog, and does not update the copy of the component that is stored in the [ProjectName].PrjPcbVariants file. If you later perform one of the Reset commands to reset parameter values, which retrieves values from the PrjPcbVariants file, it may revert a parameter value to an earlier value and overwrite any current changes. To ensure that this cannot happen, update the component in the PrjPcbVariants file using the process described below.\tCompletely Updating an Alternate PartIf the source component for an Alternate Part has been edited in its library, it can be updated in the design by running the Update from Library dialog.Launched from the Tools menu in the schematic editor, the dialog includes an option to Include Variants. When this option is enabled, the component list will expand to include any components that have been used as Alternate Parts. Check the components in the list to be updated, and then complete the Wizard to update the required parts from the source.\tTo fully update an Alternate Part, including its graphic, enable the Include Variants checkbox and enable the part to be updated.\tIf there have been changes made to library components used in the base design, these are also updated in the usual way:\t\t\t\t\t\t\tvia the Schematic editor Tools \u00bb Update from Library command\t\t\t\t\t\t\tor the Schematic Library editor Tools \u00bb Update Schematics command.\t\t\tChange Multiple Parameters for Multiple ComponentsThe Variant Management dialog supports multi-select, which means that any number of components can be selected simultaneously in the upper (Component) part of the dialog, and then updates performed on any number of parameters selected in the lower (Parameters) part of the dialog. The dialog also offers Filters (via the right-click context menu), to further refine the selection and the displayed data.By way of example, to reset the manually-varied parameters for all components, in all variants:\t\t\tIn the upper (Component) part of the dialog, use the Only Show Varied Components right-click menu option in combination with the right-click Filter options to only Show Fitted with Varied Parameters. The component list should now display only those components that have manually varied parameters.\t\t\t\tRight-click in the component list and choose Select All from the context menu. All components currently displayed in the upper part of the dialog will be selected.\t\t\t\tThen right-click in the lower (Parameters) part of the dialog and choose Select All from that context menu. All parameters for all components will now be selected. Note that the Select Column command could have been chosen instead, which would allow an action (such as Reset) to be applied to the components in a specific Variant (column).\t\t\t\tRight-click again in the parameters list and choose Reset Selected from the context menu. Hover the cursor over the image below to show steps 2, 3 and 4.\t \tResetting all manually varied parameters, for all components, in all variants. Hover the cursor over the image to show steps 2, 3 and 4.\tIf you have been experimenting with the Filter options and have applied different filters, you may need to reset the filter before attempting another update. To do this, disable the Only Show Varied Components option to clear the filter system, then re-apply it and clear the Filter options as required.\t\t\tWorking with Variant ParametersAltium Designer supports Parameters at various levels of a project. For example, document-level parameters can be added to each schematic sheet in the Parameters tab of the Schematic editor Properties panel (available when nothing is selected). Project-level parameters can also be added to a project on the Parameters tab of the Project Options\u00a0dialog (Project \u00bb Options).Further to this, parameters can also be added to a Variant via the Edit Project Variant dialog. In the Variant Management dialog, select the variant column and click the Edit Variant button to open this dialog.\u00a0To add a new parameter, click the\u00a0Add\u00a0button. Use the\u00a0Parameter Properties\u00a0dialog that opens to enter the\u00a0Name\u00a0and set the\u00a0Value\u00a0of the new parameter then click\u00a0OK. The new parameter is now displayed in the\u00a0Edit Project Variant\u00a0dialog. \tParameters included at various levels in a project exist in a hierarchy, which means you can, in fact, create a parameter with the same name at different levels in the project, where each has a different value. Altium Designer resolves this situation using priorities, in the following way:\t\t\t\t\t\t\tVariant (highest priority)\t\t\t\t\t\t\tSchematic document\t\t\t\t\t\t\tProject\t\t\t\tThis arrangement means that the parameter value defined in a schematic document overrides the value defined in the Project options, and the parameter&#039;s value defined in a Variant overrides the value defined in the schematic document. Note that schematic-level parameters are not available on the PCB or in the BOM \u2013 for these types of output, project or variant parameters should be used.\t\tA variant parameter can be shown in a\u00a0schematic or PCB document by placing a special string. Learn more about Special Strings on a\u00a0Schematic\u00a0and Special Strings on a PCB.In the images below, a Parameter called ProjectTitle has been defined for the project, and also for each variant. The animation shows the behavior on the PCB as the Variants selector is used to show the base design, then each variant. \tA ProjectTitle parameter added to the project (via the Project\u00a0Options dialog) has also been added to each design Variant, but with a different Value in each case.  A special string .ProjectTitle has been placed on the PCB overlay, which is automatically linked to project and variant parameters of the same name. Generating a Variant ReportThe\u00a0Variant Report\u00a0dialog accessed by clicking the\u00a0Detailed Report\u00a0button\u00a0at the bottom of the\u00a0Variant Management dialog allows you to configure and generate a detailed HTML-formatted report of the defined project variants. \tThe Variant Report dialog\t    Options and Controls of the Variant Report Dialog    \t\t\t\t\t\tReport Only Varied Components - use this option to determine the exact information featured in the report:\t\t\t\t\t\t\t\t\t\t\t\tFull Non-Varied Information (option disabled) - all components are listed, showing their inclusion state in each enabled variant. For each component, all parameters and their values are listed.\t\t\t\t\t\t\t\t\t\t\t\t\tFull Varied Information (option enabled) - only those components that vary in some way between enabled variants are listed, showing their inclusion state in each variant. For each component, only those parameters that vary in some way between variants are listed, along with their values.\t\t\t\t\t\t\t\t\t\t\t\t\t\tProject Variants - this region lists the original base design () and all defined variants. The generated report could compare one specific variant against the base design, compare one variant against another, or compare all variants against the base design. By default, all defined variants, as well as the original base design, will be enabled for inclusion into the report. Use the associated checkbox to include\/exclude entities as required.\t\t\t\t\t\t\tRun - click this button to generate the report. The report will be created and opened as the active document within the main design window.\t\t\t\tVariant ErrorsVariant settings are stored in the project file (*.PrjPcb), and this data is read, analyzed and loaded into the Variant Management dialog when that dialog is opened. If issues are detected when the data loads, such as any mismatches between component designators or component UIDs, an Information dialog will open to outline the problem. \tResolve designator and UID mismatches before continuing with the design process.Component UID mismatches are automatically resolved, and these corrections will be retained when the project is saved. Duplicate designators must be corrected at the schematic level. To resolve these, validate the project (Project \u00bb Validate ) and check the Messages panel for warning\/error details.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-variant-management-dialog.html"},
{"title":"Working with the Variant Manager","text":"The Variant Manager is a document-based user interface that allows you to view, create, and manage design variants of your PCB design project.\u00a0To access the Variant Manager, right-click the project entry in the Projects panel and select Variants or choose Project \u00bb Variants from the main menus of the schematic or PCB editor.\tThe\u00a0Variant Manager is in Open Beta and available when the UI.ModernVariantsManager option is enabled in the Advanced Settings dialog. When the UI.ModernVariantsManager option is disabled, the\u00a0Variant Management dialog is used for creating and configuring design variants. Refer to the Working with the Variant Management Dialog page to learn more.\tWorking with VariantsCreating a New VariantTo add a new variant, use the Add Variant button located at the top-left of the Variant Manager when the Variants tab is active. An additional variant column with a\u00a0default title will appear in the grid area as shown in the image below.\u00a0All the cells of the new column will be empty, where an empty cell indicates that this component is Fitted and unchanged from the base design.\tA new variant is added with all components Fitted by default.\t\t\t\t\t\tTo save the Variant Manager after making changes, choose File\u00a0\u00bb Save Variants from the main menus (shortcut Ctrl+S).\t\t\t\t\t\t\tWhen the number of variants exceeds 100, automatic pagination\u00a0applies\u00a0to the Variant Manager, with each hundred variant columns shown on a separate page. In this case, the current page number and the total amount of pages are shown at the bottom of the Variant Manager. Use the arrow buttons to navigate between pages.\t\t\t\t\t\t \t\t\t\t\t\tYou can filter the variants that are displayed in the Variant Manager using the Variants Filter dialog, which is accessed by clicking\u00a0\u00a0in the upper right corner. To filter the displayed variants, enable the checkbox associated with the variant(s) you want to be displayed. When OK is clicked in the dialog, the variants are filtered according to the enabled checkboxes. When a filter is applied, the filter button is displayed as\u00a0. To remove or change filtering, click the filter button to reopen the Variants Filter dialog, then update the checkboxes. When the Project Variants\u00a0checkbox is enabled, all variants in the project are displayed.\u00a0Configuring Variant PropertiesTo change variant options, use the Properties panel in its Variant mode, which can be accessed by right-clicking the column header of the required variant and selecting Properties.\tAccess the Properties panel in Variant mode to change the options of a variant.\t\t\tDefine a meaningful name for the variant using the Name field.\t\t\t\t\t\t\tThe name of a variant can also be changed using the Rename Variant dialog that is accessed by clicking the variant column header to select it and then clicking \u00a0at the top-left of the Variant Manager or by right-clicking the variant column header and then selecting Rename Variant.\t\t\t\t\t\tIf Fabrication Variants need to be generated from the design, enable the Allow variation of fabrication outputs option. If an output job has a variant nominated for a fabrication output, and that variant does not have the option enabled, the job&#039;s variant name will be displayed in red. Note that the red variant name is simply a warning flag, and the variant-specific output files will still be generated.\t\t\t\tIf Paste Mask outputs need to be generated for a design that includes variants with &#039;Not Fitted&#039; components, enable the\u00a0Allow variation for paste mask\u00a0option. These components will no longer have Paste Mask included on their pads.\t\t\t\t\t\t\tFor information on how to add and view variants to an Output Job file, visit the Preparing Manufacturing Data with Output Jobs page.\t\t\t\t\t\tUse the Variant&#039;s Parameters region of the panel to define the list of variant-level parameters.\t\t\t\t\t\t\tA variant parameter can be shown in a\u00a0schematic or PCB document by placing a special string. Learn more about Special Strings on a\u00a0Schematic\u00a0and Special Strings on a PCB.\t\t\t\t\t\t\tAltium Designer supports parameters at various levels of a project: project, schematic document, and variant.\u00a0Parameters included at various levels in a project exist in a hierarchy, which means you can, in fact, create a parameter with the same name at different levels in the project, where each has a different value. Altium Designer resolves this situation using priorities in the following way:\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tVariant (highest priority)\t\t\t\t\t\t\t\t\t\t\t\t\tSchematic document\t\t\t\t\t\t\t\t\t\t\t\t\tProject\t\t\t\t\t\t\t\t\t\tThis arrangement means that the parameter value defined in a schematic document overrides the value defined in the Project options, and the parameter&#039;s value defined in a Variant overrides the value defined in the schematic document.\t\t\t\t\t\tProperties of a VariantRight-click on a cell, then choose Properties to open the Properties panel that displays the details of the chosen Component\/Group. The Component Parameters of the variant can be edited as needed.\u00a0The parameters can also be viewed and edited by selecting a component in the grid and then expanding the Parameter region that appears at the bottom of the grid.\tCell contents of variants can be copied, pasted, or cut using the respective commands in the right-click context menu or by using the appropriate shortcuts (Ctrl+C, Ctrl+V, Ctrl+X, respectively).\u00a0Defining Component VariationsEach component in the base design can be configured to be:\t\t\tFitted\u00a0\u2013 the default setting when a new variant is created.\t\t\t\tNot Fitted\u00a0\u2013 the original component as used in the base design is not fitted\/used in this variant of that design.\t\t\t\tFitted with modified component parameters, such as the component&#039;s value.\t\t\t\tAlternate Part\u00a0\u2013 completely replacing one component with another.\tChanging the state of a component in a design variant can be done\u00a0by clicking the component cell in the variant column and accessing the cell drop-down that offers three choices:\t\t\t(Fitted)\u00a0\u2013 the original component as used in the base design is also fitted\/used in this variant of that design. Note that individual parameters can also be varied for a fitted component \u2013 see below.\t\t\t\tNot Fitted\u00a0\u2013 the original component as used in the base design is not fitted\/used in this variant of that design.\t\t\t\tAlternate Part\u00a0\u2013 this option allows a different (alternate) part to be selected. Use the Replace dialog (which is a modal dialog version of the\u00a0Components\u00a0panel) to select\u00a0the required alternate part. Once that part is chosen, the cell displays the alternate part&#039;s ID.\t\t\t\t\t\t\tAfter selecting an alternate part, the software checks for pin compatibility between the selected alternate component and the original base design component. To be pin-compatible, the alternate must have the same number of pins as the original component, and those pins must be identical in their location and electrical type. The graphical primitives used in the symbols for the two components are not required to match. If the software detects that the alternate component is not pin-compatible, a\u00a0Confirm\u00a0dialog must be dismissed before the replacement is accepted. In this case, you need to be mindful of the potential impact on the wiring.\t\t\tYou can choose an alternate part with no changes to a symbol on a schematic or needing to add a footprint to the PCB.\u00a0In the\u00a0Properties\u00a0panel, enable the\u00a0Do not overwrite schematic symbol\u00a0and\/or\u00a0Do not overwrite PCB footprint\u00a0options as needed. When the latter is enabled,\u00a0a footprint of an alternative component applied to a variant will not be transferred to the PCB as part of the PCB update (an ECO to add the footprint to the PCB will not be generated).\u00a0Parameters for the chosen alternate are faithfully presented in the ActiveBOM.\tThe above-listed states of components can also be found by right-clicking in the grid,\u00a0choosing Set Selected As then selecting the desired state from the associated menu as shown below.\t\t\tDefine component variation using the drop-down in the cell of the required variant column. When selecting the Alternate Part option, use the Replace dialog to select an alternate part.Individual parameters can be varied for a fitted or alternate component by typing in a new parameter value in the Properties panel.\u00a0Click the cell of a component in the required variant column, and use the column of the selected variant\u00a0in the\u00a0Component Parameters region of the Properties panel in its Component for\u00a0variant mode to type in a varied parameter value. For the\u00a0Footprint parameter, click the cell drop-down to select a footprint if multiple footprint models are assigned to the component.\u00a0A parameter value different from the base design will be shown in yellow, and the component cell in the grid area will show the component name.\tExample of defining an alternate parameter of a fitted component. Type in a new parameter value as shown in the image. Hover the cursor over the image to see the component cell after defining a new parameter value.\tIf you want to only view components that have been changed, enable the Changed Only option at the top right of the Variant Manager (or right-click within the main area of the Variant Manager and then select Only Show Varied Components). In the image below, four changes were made to variants then the Changed Only option was enabled, which changed the display to show only the five varied components. This option is very helpful with large designs that have numerous variants within them.\t\t\t\tEnable the Changed Only option to effectively filter the component list and display only varied components.\t\u00a0Updating an Alternate Part ParameterIf a library component that is used as an Alternate Part has had parameters changed in the library, then you can bring those changes directly into the variant definitions in your project.\u00a0Select the\u00a0Update Values from Library\u00a0command from the right-click menu of the\u00a0Parameter\u00a0region at the bottom of the\u00a0Variant Manager\u00a0or in the\u00a0Component Parameters\u00a0region of the\u00a0Properties\u00a0panel when the required alternate component is selected in the main grid area to bring any parameter changes made to a library component.\tAccess the Update Values from Library command in the Variant Manager. Shown here is access from the right-click menu of the\u00a0Parameter\u00a0region when the required component entry is selected.\u00a0Hover the cursor over the image to see access from the Properties panel when the alternate part entry is selected.Browse to and locate the component in the source library via the\u00a0Replace\u00a0dialog\u00a0and click\u00a0OK\u00a0to open the\u00a0Update Project Variants From Library\u00a0dialog. All parameters are listed on the left of the\u00a0Update Project Variants From Library\u00a0dialog \u2013 if required, any parameter can be deselected to exclude it from the update process. On the right of the dialog, the target Project Variant can be changed (Project Variant To Update). This will default to select the variant that was selected when the\u00a0Update Values from Library\u00a0command was activated.\u00a0Click\u00a0OK\u00a0to complete the update process.\tNote that this updates the parameters only\u00a0and not the component itself.Copying a VariantYou can copy a variant using the Make a copy\u00a0command. Right-click\u00a0in the header of the variant name column and then choose the Make a copy\u00a0option. A new column with the same data and\u00a0name (appended with &quot;Copy&quot;) will be added.\u00a0You can use the Rename option to name the new column a suitable title.Removing a VariantTo delete the variant, select the header, then use the\u00a0\u00a0icon. The ability to delete this or all variants is also included in the right-click context menu as shown below.\u00a0A\u00a0dialog opens for confirmation before the deletion occurs. Working with GroupsTo facilitate the management of a large number of design variants, the\u00a0Variant Manager also allows you to create groups of components from a chosen schematic sheet, sheets\u00a0referenced by a chosen sheet symbol, or a chosen component class with a\u00a0functional-based view of component variations. For each group, you can define one or more \u2018options\u2019, which essentially reflect some variation of one or more components in the group.\u00a0Variants can then be created based on these defined groups and options, with support for creating a hierarchy of variants. When a change is required, editing a value within a group option\u00a0is instantly reflected in all variants that use that group option.The workflow of working with groups is the following:\t\t\tSwitch to the Groups tab\u00a0using the control at the top of the Variant Manager.\t\t\t\tUsing the drop-down menu of the Add Group button, select a schematic document, sheet symbol, or component class for which a group should be created.\t\t\t\t\t\t\tAdd a group to facilitate further variant management based on this group.\t\t\t\t\t\tA new group will be listed in the left-hand pane of the Variant Manager, while the components of the selected group will be listed on the right.\t\t\t\t\t\t\tBy default, the name of the selected schematic sheet, sheet symbol, or component class will be assigned to the newly created group. Use the Rename button at the bottom of the group list region to rename the group as needed.\t\t\t\tUse the Add Option button to add an option for the currently selected group.\u00a0An additional option column with a\u00a0default title will appear in the grid area.\u00a0All the cells of the new column will be empty, where an empty cell indicates that this component is Fitted and unchanged from the base design.\t\t\t\t\t\t\tAdd an option for the selected group as shown in the image. Hover the cursor over the image to see the default option column.\t\t\t\t\t\tAssign a meaningful name for the newly created option by changing the default name. Click the option&#039;s column header to select it and then click the Rename button at the bottom of the grid area or right-click the header and select Rename to access the dialog to enter a new name.\t\t\t\t\t\t\tSet a meaningful name for an option.\t\t\t\t\t\tUsing the component cells in the column of the required option, configure the component\u00a0variations. The process is the same as when defining component variations for a variant.\t\t\t\t\t\t\tConfigure component variations for\u00a0the selected option.\t\t\t\t\t\t\tIt is not recommended to manually change component parameters. Additionally, alternate components are highly recommended. To use alternate footprints, use a separate component when working with groups.\t\t\t\t\t\t\tCell contents of variant group options can be copied, pasted, or cut using the respective commands in the right-click context menu or by using the appropriate shortcuts (Ctrl+C, Ctrl+V, Ctrl+X, respectively).\t\t\t\t\t\tAdd further options for the selected group by right-clicking in the grid area and selecting Add Option. Configure the new option as required.\t\t\t\t\t\t\tAdd and configure further options as required.\t\t\t\t\t\tIn the Variants tab of the Variant Manager, the components for which a group was created will be shown under the appropriate entry in the grid area.\u00a0Using the drop-down of the cell for a group entry, select an option created for this group on the Groups tab. Variations configured for the components in this group will be applied.\t\t\t\t\t\t\tAdd an option for the selected group as shown on the image. Hover the cursor over the image to see the default option column.\t\t\tCopy a Group OptionTo copy an option of a variant group,\u00a0on the Groups tab, right-click in the  column heading then choose Make a copy.\u00a0A new column with the same data and\u00a0name (appended with &quot;Copy&quot;) will be added.\u00a0You can use the Rename option to name the new column a suitable title.Notes\t\t\tWhen you configure variants, the settings are saved in the project file. This includes the Not Fitted state, local parameter variations to a Fitted component, and the parameter values of Alternate Parts. The Alternate Parts are stored in the file .PrjPcbVariants.\t\t\t\tVariant columns can be pinned to show them first, at the left of unpinned columns. To pin a variant column, hover the cursor over its header and click .\t\t\t\tDouble-click on a component\u00a0or right-click, then select the Cross Probe option\u00a0to jump to that component on the schematic.\t\t\t\tUse the Select All command\u00a0from the right-click menu of the\u00a0grid area on\u00a0the Variants tab or the\u00a0Parameter\u00a0region to quickly select all grid content.\t\t\t\tUse the Invert Selection command from the right-click menu of the\u00a0grid area on\u00a0the Variants tab or the\u00a0Parameter\u00a0region to quickly select\u00a0non-selected\u00a0and deselect\u00a0selected entries.\t\t\t\tClick\u00a0the View Report\u00a0button at the bottom left of the Variant Manager\u00a0to generate a detailed variant report in HTML format using the Variants Report dialog that opens.\t\t\t\tRight-click in the grid area of the Variants tab or the\u00a0Parameter\u00a0region\u00a0and use the following commands of the context menu to generate report files:\t\t\t\t\t\t\t\t\tReport\u00a0\u2013 click to open the\u00a0Report Preview\u00a0dialog to create a printout of the grid.\t\t\t\t\t\t\t\t\t\tSave All\u00a0\u2013 click to open a\u00a0dialog to save a listing of all\u00a0components \/ all parameters for the selected component to a tab-formatted text file (*.txt).\t\t\t\t\t\t\t\t\t\tSave Selected\u00a0\u2013 click to open a\u00a0dialog to save a listing of selected components \/\u00a0selected parameters\u00a0as a tab-formatted text file (*.txt).\t\t\t\t\t\t\t\t\tWhen the schematic is changed, an appropriate notification is shown at the top of the Variant Manager. Click the Refresh control next to the notification to update the data in the Variant Manager.\t\t\t\tThe\u00a0Delete option found when right-clicking on a cell can be used to delete a variant, a group or an option.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-variant-manager.html"},
{"title":"Working with Variants in the Design","text":".Container {position:relative; user-select:none; display:inline-block; margin:0 30px 0 30px;}\t.SlidesTable td {border:none;padding:0;}\t.FirstText {border:none; display:inherit;padding: 0 30px 0 40px;}\t.FirstText {border:solid 1px lightgray; display:block; padding:8px;}\t.OverlayText {border::none;; display:none;padding: 0 30px 0 40px;}\t.OverlayText {border:solid 1px lightgray; display:block; padding:8px;}\th5 {font-family:dinpro-medium; line-height:1.2; font-size:17px; letter-spacing:normal; color:#424242; margin: 0 0 12px;}\t.Next,.Previous {font-size:25px; cursor:pointer; position:absolute; top:40%; color:blue; padding:2px 8px 5px 8px;}\t.Next {right:-30px;}\t.Previous {left:-30px;}\ta.Next, a.Previous {opacity:0.6; transition:0.3s;}\ta:hover.Next, a:hover.Previous {opacity:1; background-color:lightgray; text-decoration:none;}\t.Overlay {z-index:-1; position:absolute; top:0; transition:0.5s ease; opacity:0;  padding:10px; border:solid 1px; border-color:lightgray;}\t.First {transition:1s ease-in; padding:10px; border:solid 1px; border-color:lightgray;}\t.blob {height:15px; width:15px; margin:0 5px; background-color:#bbb; border-radius:50%; display:inline-block; cursor:pointer;}\t.blobs {text-align:center; padding:0; color:blue;}\t.Counter {display:none;}Configuring Display of Varied Components in Design DocumentsThe way in which varied components are presented in schematic design documents (and PCB outputs) is configured in the\u00a0Drawing Style\u00a0dialog. Those settings subsequently affect how the component variations are presented in printed or PDF outputs, and in PCB printouts such as assembly drawings. To access the\u00a0Drawing Style\u00a0dialog, click the\u00a0Drawing\u00a0Style\u00a0button\u00a0at the bottom left of the Variant Manager or at the bottom of the\u00a0Variant Management\u00a0dialog, after selecting a cell in the relevant variant column.Use the Drawing Style dialog to configure how variants are presented on the schematic and in PCB printouts.    Options and Controls of the Variant Options Dialog    Schematic Drawing OptionsThese options are used to control which graphics are drawn on top of the schematic components that are not fitted. The components themselves will automatically be drawn as if they are being masked.\tUse Graphics\u00a0- enable\u00a0to have graphics displayed over schematic components that are not fitted while the documents are being displayed or printed. Choose from the following options:\t\t\tUse Red Cross\u00a0- select\u00a0to overlay non-fitted components with a red cross.\t\tUse\u00a0Gray Box\u00a0and Mesh \u2013 select\u00a0to overlay non-fitted components with a gray mesh box.\t\t\tUse Text\u00a0- enable to display a string of characters over the not-fitted logical component. If this option is checked, the following options are available:\t\t\tText\u00a0Box \u2013 enter the text that will be overlayed on non-fitted components.\t\tFont\u00a0- click the color swatch to access the Choose Color dialog to change the color of the overlay text. Click the Change button to access a dialog to change the appearance of the overlay text.\t\tThese options are used to control the appearance of varied parameters.\tModify Text and Font- enable this option to modify the appearance of varied parameters, both in the compiled document view of the schematic\u00a0and in schematic prints.\u00a0If this option is checked, the following options are available:\t\t\tSuffix\u00a0- enter a suffix that will be added to all varied parameters.\t\tFont\u00a0- click the color swatch to access the Choose Color dialog to change the color of the text displayed in relation to varied parameters. Click the Change button to access a dialog to change the appearance of the text.\t\t\t\tPreview region \u2013 this region of the dialog displays of preview according to your settings.\t\tNote that the Preview region displays the presentation of both the Not Fitted components and the Parameter Variation options.\u00a0However, because a component can not be both Not Fitted and Varied, these options are not displayed together on the actual schematic sheet.\t\tPCB Drawing Options\tHide Not Fitted Components \u2013 enable\u00a0to have not-fitted components excluded on generated assembly drawings.\tDisplay Not Fitted Components in Draft Mode\u00a0- use to enable the display of non-fitted components in assembly drawings\u00a0in draft mode. Any combination of the following options can be enabled and configured when this option is enabled:\t\t\tStrike-through Designator \u2013 enable\u00a0to display the designator text for a non-fitted component with a strike-through.\t\tUse Graphics \u2013 enable this option to apply a graphical overlay for non-fitted components in assembly drawings. Choose one of the following options:\t\t\t\t\tUse Cross \u2013 select to overlay non-fitted components with a cross.\t\t\tColor \u2013 click the color swatch to access the Choose Color dialog\u00a0to change the color of the overlay cross\/mesh box.\t\t\tUse Mesh Box -\u00a0select\u00a0to overlay non-fitted components with a mesh box.\t\t\t\t\t\t\tUse Text \u2013 enable this option to apply a textual overlay for non-fitted components\u00a0in assembly drawings.\t\t\tText Box \u2013 enter the text that will be overlayed on non-fitted components.\t\tFont \u2013 click the color swatch to access the Choose Color dialog to change the color of the overlay text. Click the Change button to access a dialog to change the appearance of the text.\t\t\tPreview region -\u00a0this region displays of preview according to your settings. Click 2D\/3D\u00a0to toggle between\u00a02D and 3D images.To see how the chosen options apply, ensure the preview window is set to display the component in 2D mode.Working with Variants in the Schematic EditorAltium Designer&#039;s schematic editor includes a range of features that provide full visibility of component variations during the schematic capture process, as described below.Examine Varied ComponentsAs previously outlined, the actions to examine variant detail on the schematic are:\tSelect the required variant in the Variants section in the Projects panel by double-clicking\u00a0on its entry or by on the desired variant and selecting the Set as current command. The current variant is displayed in bold, white text.\tSelect the named compiled tab located at the bottom of the schematic sheet.\tComponents varied on the sheet will then be displayed, in the style configured in the Variant Options dialog. Select the variant and then the compiled sheet to view the components that are varied on a schematic sheet (identified by their varied parameters).The compiled tab displays a different Active Bar at the top of the design space, which includes variant-specific buttons. These buttons are only available when a variant is selected in the Projects panel.Note that when you switch to a compiled tab the available menu entries will change, reflecting the commands that can be run when you are viewing the physical design. Click on the logical design tab (Editor) at the bottom of the schematic sheet to return to the standard editing menus.When viewing variants on a compiled tab\u00a0of a schematic document, alternate part properties\u00a0are displayed in the Properties panel (in a read-only state).\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\tJavascript ID: AltComponentProperties\t\t\t\t\t\t\t\t\tSelecting Variant Components from the SchematicAs opposed to scrolling through and selecting components from the list in the Variant Management dialog, it can be more convenient to make specific selections directly on the schematic. To do so, right-click\u00a0over a placed component (not selected) and select Part Actions \u00bb Variants from the context menu or\u00a0select the component(s) on the sheet, then right-click and select Part Actions \u00bb Variants. When in\u00a0a\u00a0Compiled View\u00a0tab, you can also click the \u00a0button in the Active Bar and then choose a component in the design space. Here, two components (LEDs) have been selected on the compiled tab of the schematic for the BGA variant \u2013 the right-click Variant command will open just those components in the Variant Management dialog.Note that the right-click Part Actions sub-menu also includes commands to Toggle Fitted\/Not Fitted, and to Choose Alternate Part.The Variants command on the right-click menu (above) will open the Variant Management dialog, where only the selected components will be listed, or the Variant Manager, where the selected component will be highlighted.\u00a0The required variations can then be performed as usual\u00a0and OK clicked to apply those variations to the design. Here, the Variant Management dialog has been opened from two selected components on the schematic sheet and therefore includes just those two (LED) components.\tThis selection technique can be used when first setting up component variations, or when an existing component variation needs to be modified.\tWhen accessed from the\u00a0Editor\u00a0tab or [No Variations]\u00a0is selected (i.e. the base design), the\u00a0Variant Management\u00a0dialog will present all defined variants.\u00a0When accessed from a\u00a0Compiled View\u00a0tab, the\u00a0dialog will present only the currently active variant, as chosen under the\u00a0Variants\u00a0folder for the project, in the\u00a0Projects panel.Graphically Editing Component VariationsComponent Variants can also be created and edited by working directly in the schematic at a symbol level. Note that the Schematic Editor must be in compiled variant view (as selected by the lower tab), and the required variant selected in the Projects panel.A command is provided to quickly toggle the Fitted or Not Fitted state of a component for the variant design. Launch this command using the  button on the Variant Active Bar (available when a variant is selected in the Projects panel).\tWhen no component is selected in the design space, this will change the cursor to a cross-hair, where clicking on a component will cause it to toggle between the Fitted and Not Fitted states.\tWhen there are components selected in the design space, clicking the button will toggle the Fitted\u00a0\/\u00a0Not Fitted state of the selected components.To quickly toggle the fitted\/not fitted state of the component under the cursor, you can also right-click over the required placed component and choose the\u00a0Part Actions \u00bb Toggle Fitted\/Not Fitted\u00a0command from the context menu.The component\u2019s fitted state will be graphically indicated as defined in the Variant Options dialog. Toggle a specific component&#039;s fitted state directly on the schematic.To choose an alternate part for a component in the chosen variant of the design, you can use the Choose Alternate Part command available from the Part Actions menu of the component&#039;s right-click menu or by clicking the  button on the Active Bar. After launching the command, the Edit Component Variation dialog will open. Use the dialog to browse and locate the required alternate part component.You can check the chosen alternate component in the design space. The Schematic Editor will use the symbol graphics for the chosen alternate component. If the component is pin-compatible and graphically similar, you should see very little change. The tell-tale sign for the use of a different component is the different comment for the alternate part.\tIf an alternate component is not already used elsewhere in the design, the symbol graphics for the alternate component are stored in a dedicated file - .PrjPcbVariants. This file is stored in the same location as the project file. Parameters changes for the alternate components\u00a0saved in the project file. Using the\u00a0.PrjPcbVariants file keeps the project independent from the source libraries that were used to create the design.\tIf a base component uses a graphical display mode other than the default Normal\u00a0and it has an alternate component defined in a variant, the alternate component will also attempt to use the same graphical display mode. If the alternate component does not include this graphical display mode, the Normal mode is used.Graphical Parameter EditingChanges can be made directly to a displayed component variant parameter by selecting the parameter text then clicking the text a second time to enable editing mode. Any changes made will be adopted by that component\u2019s entry in the Variant\u00a0Management\u00a0dialog.Note that a component\u2019s parameter visibility is configured in the Properties panel. With a component parameter selected, use the  icon associated with the parameter Value to toggle its visibility. Select a parameter, then click a second time to enable direct editing.A variant parameter may also be directly edited in the Parameter Variation dialog, which is opened by double-clicking on the parameter text. As usual, this function is only available when in the compiled schematic view, and any changes made will also register in the Variant Management\u00a0dialog. When in the compiled view, double click on a variant parameter access editing in the Parameter Variation dialog.    Options and Controls of the Parameter Variation Dialog    \tName \u2013 this is a non-editable field that is populated by the logical, as opposed to physical, component parameter information (the name of the parameter).\t\t\tVisible \u2013 when this option is enabled, the parameter is displayed (non-editable; set in the base design).\t\tLock \u2013 when this option is enabled, the parameter cannot be reassigned (non-editable; set in the base design).\t\t\tValue \u2013 this is a non-editable field that is populated with the logical component parameter data (the value of the parameter).\t\t\tVisible \u2013 when this option is enabled, the value is displayed (non-editable; set in the base design).\t\tLock \u2013 when this option is enabled, the value cannot be reassigned (non-editable; set in the base design).\t\t\tVariation (will be saved in )\t\t\tVaried Value \u2013 uncheck this option to disable the parameter variation. When checked, the varied value is active\u00a0and can be edited in the associated textbox.\u200b\t\tGraphical Designator EditingTo change a component&#039;s physical designator, directly within the compiled document view of a source schematic, simply click once on the designator to focus it, then click again to begin editing. Note that in-place designator editing is only possible when the Enable In-Place Editing option is enabled in the Schematic \u2013 General page of the Preferences dialog. Select the designator, then click a second time to enable direct editing.In-place editing of designators is essentially a graphical shortcut to defining a Locked Physical Designator, which can also be defined in the Physical Component Properties dialog by double-clicking on the component. Both the associated component and designator dialogs provide access to designator editing and annotation options.    Options and Controls of the Physical Component Properties Dialog    Annotation\tLogical Designator \u2013 this uneditable field displays the logical designator for the component.\t\tVisible \u2013 this checkbox indicates the current display state of the component&#039;s Designator \u2013 whether it is visible in the workspace or not. The checkbox is\u00a0not editable.\tYou can change the visibility of designators from either the base design itself using the Editor tab\u00a0or directly within a compiled document view using the SCH List panel.\t\tAnnotate \u2013 enable this option to access the following controls to define the desired annotation. These controls are available only when Annotate is checked:\t\t\tLock Physical Designator \u2013 select to enter a custom physical designator in the text box. The text box is available only when Lock Physical Designator is selected.\t\tApply Naming Scheme \u2013 select to generate a designator using a current naming scheme (use the Annotate Options button\u00a0to change the scheme).\t\tAnnotate Options \u2013 use to access the Board Level Annotation Options dialog in which you can either choose a predefined naming scheme or specify your own custom scheme.\t\tComponent\u2013 this uneditable field is populated based on the logical designator information for the component. The field and information shown will depend on the chosen naming scheme.\t\tRoom Name \u2013 this uneditable field is populated based on the logical designator information for the component. The field and information shown will depend on the chosen naming scheme.\t\tPhysical Designator \u2013 this uneditable field presents the calculated physical designator based on the logical designator information and the specified naming scheme that will be assigned when you click OK.\t\tEnable the Annotate option to specify either:\tA custom designator, using the Lock Physical Designator option and entering the new designator. This is the option that is set when graphically editing a designator, as outlined above.\t\tA designator generated using a specified Naming Scheme. In this case, enable the Apply Naming Scheme option and use the Annotate Options button to access the Board Level Annotation Options dialog. From here, you can either choose a predefined naming scheme\u00a0or specify your own, custom scheme. The Physical designator will be generated based on the logical designator information and the specified naming scheme.\t\u25ba Refer to Annotating the Components for detailed information on Annotation and Naming Schemes.The options defined in the Board Level Annotation Options dialog\u00a0when defining a naming scheme\u00a0are global to the project and override the naming scheme defined on the Multi-Channel tab of the Project Options dialog\u00a0(Project \u00bb Project Options).Working with Variants in the PCB EditorIn Altium Designer&#039;s PCB editor all of the component footprints, for all variants, are always shown. This is necessary because all footprints, for all assembly variations, must be fabricated as part of the bare board. It is the loading of components during the assembly process that then determines which variant is being built.Because all footprints are always visible on the PCB, it can be difficult to know which components belong to which variant. However, the only visible clue to tell if a particular component is fitted or not fitted in that variant is if the component includes a 3D Body model. The body will appear\/disappear to indicate whether the component is fitted or not fitted. This visual behavior is more easily seen when the PCB is in 3D Layout Mode\u00a0as demonstrated in the animated image below.Alternate Part PCB designThere is only one type of variation that affects component placement in the PCB design process \u2013 when an Alternate Part is specified, and that Alternate Part uses a different footprint from the base design. In this situation, two footprints must be placed on the board.There are different ways that these two footprints might be positioned, such as:\tThe footprints are placed next to one another.\tThe smaller footprint is placed inside the larger footprint, as shown in the animation below, where an SRAM component is available in either a TSOP package or a BGA package.\tThe footprints are exactly stacked (placed one on top of the other). For example, when the footprints are identical but have different 3D models, and therefore must have different footprint names. This is also shown in the image below, where two LED footprints are stacked for both DS1 and DS2.  A simple animation showing how Alternate Parts that use different footprints can be positioned on the board. The two instances of LED DS1 use exactly the same footprint pattern (but have different 3D models in each variant) and can therefore be stacked.Altium Designer includes design rule checking support for stacked alternate components, so no additional design rules are required. The alternate parts share the same component UID, however, the software is aware that they are alternate parts and can prevent the rules engine from flagging stacked or overlapping alternate-part footprints.Working with Variants in ActiveBOMMain article: BOM Management with ActiveBOMAlthough a BOM can be generated directly from the schematic or from an OutputJob file, the recommended approach is to use ActiveBOM. Beyond the components fitted to the board, ActiveBOM allows additional components and BOM-specific data to be added directly in ActiveBOM, for example; yet-to-be-detailed parts, fasteners, the blank board, or the mounting glue. Custom columns can also be added, including a specific Line number column, which supports both auto and manual numbering, with full copy\/paste support.For design components that include manufacturer information, ActiveBOM can use the Altium Cloud Services to access detailed and up-to-date supply chain information. This support extends beyond components placed from a managed content server, also supporting Supplier-linked parts, as well as parts that already have suitable manufacturer details in their parameters.ActiveBOM supports variants in the following ways:\tDisplay the BOM for a specific variant in Base view mode or Flat view mode\tOption to include the Not Fitted items in the BOM Items list\tDisplay a consolidated list of all parts used in all variants, in Consolidated view mode\tDefine manual solutions for both base components and varied components ActiveBOM includes a consolidated view mode, allowing a single BOM to detail the parts in all variants. \u25ba Learn more about working with variants in ActiveBOMVariant Output GenerationAssembly variants affect all output documentation that includes detail about the purchase or loading of components. This includes:\tBill Of Materials (using ActiveBOM or directly via the Report Manager)\tSchematic Prints\tPCB 3D Prints\tPCB 3D Videos\tAssembly Drawings\tPick and Place files\tTest Point ReportFabrication variants also affect the following outputs:\tGerber overlay layers\tODB++ overlay layersSelecting the Variant for OutputIf you are running a command from the schematic editor or PCB editor, such as a schematic printout or Gerber files generated directly from the PCB editor, the output will be generated based on the variant currently selected in the Projects panel. Output generated directly from the schematic or PCB editor menus is based on the variant selected in the Projects panel.If the output is generated via another interface, for example, the Report Manager or an OutputJob, it will include a Variant selector.Right-click in the Report Manager to switch from one variant to another.Working with Variants in the OutputJob EditorMain page: Preparing Manufacturing Data with Output JobsThere are two approaches to configuring an OutputJob file to support variants:\tChoose a single variant for the whole OutputJob file \u2013 use this when you prefer to use a separate OutputJob for each variant, or\tChoose a different variant for each output \u2013 use this when you have a single OutputJob configured to generate outputs for multiple variants.The option is selected in the Variant Choice region of the OutputJob editor. When the second option is enabled the required variant must be selected for each output that supports Variant-type output, as shown in the image below.An OutputJob where the Choose a different variant option is selected and outputs for both variants have been set up for each Job in the OutputJob file.If the first &#039;blanket&#039; approach is used, then every output file that is variant-specific will automatically be configured for that variant. The advantage of this option is that the variant does not need to be specifically selected, whereas the disadvantage is that an OutputJob file is required for each variant in the design.If Fabrication Variants need to be generated from the design, enable the Allow variation of fabrication outputs option in\u00a0the Edit Project Variant dialog. If an output job has a variant nominated for a fabrication output, and that variant does not have the option enabled, the job&#039;s variant name will be displayed in red.Note that the red variant name is simply a warning flag, and the variant-specific output files will still be generated. If a fabrication variant is not required, ensure that the Variant dropdown menu for that output job is set to [No Variations] \u2013 in this mode, the output will be generated from the base design.If Paste Mask outputs need to be generated for a design that includes variants with &#039;Not Fitted&#039; components, enable the\u00a0Allow variation for paste mask\u00a0option in the\u00a0Edit Project Variant dialog. These components will no longer have Paste Mask openings included on their pads.\u25ba See Preparing Manufacturing Data with Output Jobs for more information on Variants in Output JobsViewing Variants in the Web ViewerDesign variants are also supported when viewing the project in a\u00a0Workspace&#039;s Web Viewer.To learn more, refer to the Variant Support section of the Web Viewer page (Altium 365 Workspace, Enterprise Server Workspace).To learn more, refer to the Variant Support section of the Web Viewer page (for an Altium 365 Workspace or NEXUS Server Workspace).    var p = document.getElementsByClassName(&quot;Counter&quot;);    for (k = 0; k &lt; p.length; k++) {        Bloberator(p[k].id, &quot;0&quot;);    }    document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);    document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);    function Update(ss, n) {        var g = (document.getElementById(ss).innerHTML) - 1;        var TextArray = document.getElementsByClassName(ss + ss);        var ImageArray = document.getElementsByClassName(ss);        if ((g == 0) &amp; (n == -1)) {            n = 0;        }        ImageArray[g].style.opacity = &quot;0&quot;;        ImageArray[g].style.zIndex = &quot;-1&quot;;        if (g &lt; TextArray.length) {            TextArray[g].style.display = &quot;none&quot;;        }        g = g + (n);        if (g == ImageArray.length) {            g = 0;        }        var v = ImageArray[g].getElementsByTagName(&quot;video&quot;)[0];        if (v != null) {            v.currentTime = 0;            v.play();        }        ImageArray[g].style.opacity = &quot;1&quot;;        ImageArray[g].style.zIndex = &quot;1&quot;;        if (g &lt; TextArray.length &gt; 0) {            TextArray[g].style.display = &quot;inherit&quot;;        }        document.getElementById(ss).innerHTML = g + 1;        Bloberator(ss, g);    }    function Bloberator(sss, m) {        var dots = &quot;&quot;;        var IR = document.getElementsByClassName(sss);        for (d = 0; d &lt; IR.length; d++) {            if (d == m) {                dots = dots + &quot;&quot;;            } else {                dots = dots + &quot;&quot;;            }        }        var dotrows = document.getElementsByName(sss);        for (x = 0; x &lt; dotrows.length; x++) {            dotrows[x].innerHTML = dots;        }    }","tags":"","url":"altium-designer\/24\/documentation-altium-designer-variants-design.html"},
{"title":"Design Object Selection","text":".Container {position:relative; user-select:none; display:inline-block; margin:0 30px 0 30px;}.SlidesTable td {border:none;padding:0;}.FirstText {border:none; display:inherit;padding: 0 30px 0 40px;}.FirstText {border:solid 1px lightgray; display:block; padding:8px;}.OverlayText {border::none;; display:none;padding: 0 30px 0 40px;}.OverlayText {border:solid 1px lightgray; display:block; padding:8px;}\/*h5 {font-family:dinpro-medium; line-height:1.2; font-size:17px; letter-spacing:normal; color:#424242; margin: 0 0 12px;}*\/.Next,.Previous {font-size:25px; cursor:pointer; position:absolute; top:40%; color:blue; padding:2px 8px 5px 8px;}.Next {right:-30px;}.Previous {left:-30px;}a.Next, a.Previous {opacity:0.6; transition:0.3s;}a:hover.Next, a:hover.Previous {opacity:1; background-color:lightgray; text-decoration:none;}.Overlay {z-index:-1; position:absolute; top:0; transition:0.5s ease; opacity:0;  padding:10px; border:solid 1px; border-color:lightgray;}.First {transition:1s ease-in; padding:10px; border:solid 1px; border-color:lightgray;}.blob {height:15px; width:15px; margin:0 5px; background-color:#bbb; border-radius:50%; display:inline-block; cursor:pointer;}.blobs {text-align:center; padding:0; color:blue;}.Counter {display:none;}Object selection is one of the most important and frequently used operations when working with the main editors of the Altium Designer environment: schematic editor, PCB editor, Draftsman, etc. A design object must be selected before performing an operation on it, such\u00a0as:\t\t\tediting object location or size;\t\t\t\tbrowsing and changing object\u00a0properties;\t\t\t\tperforming a clipboard operation (cut\/copy) or\u00a0removal, etc.\tAltium Designer provides a number of tools to select an object or group of objects. Many of them are similar to those that can be found\u00a0in other Windows applications.When an object is selected, it is highlighted in the selection color. You can configure the schematic selection color on the Schematic \u2013\u00a0Graphical Editing page of the Preferences dialog, and the PCB selection color in the View Configuration panel. If the object can be graphically edited, colored editing handles are displayed when the object is selected.\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\tJavascript ID: ObjectSelection\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tSelected objects are visually distinguished in the design space. Shown here is a component selected on a schematic sheet.\t\t\t\t\t\t\t\t\t\t\t\t\t\tHere a group of tracks is selected in a PCB document.\t\t\t\t\t\t\t\t\t\t\t\t\tSimple SelectionIn the most basic case, you can select an individual design object by hovering the cursor over it and\u00a0clicking. Once selected, certain design objects can be changed graphically\u00a0with respect to their size and\/or shape. The object will become selected and\u00a0editing handles\u00a0will be shown at various editing points around the object. To change the shape and\/or size of the object, click &amp; drag an editing handle. The exact nature of the change will depend on the object you are editing.Click a selected object again or click away from the object to deselect it.Note that selection with clicking is not cumulative. The selected object deselects when you click on another object. To select multiple objects, hold the Shift key then sequentially click the objects you want selected or deselected. In other words, the Shift+Click\u00a0shortcut changes the selection status of the object currently under the cursor without affecting the status of other objects.\t\t\t\t\t\tIf you do not want to deselect all design objects by clicking anywhere on the design space, disable the Click Clears Selection option in the Schematic \u2013\u00a0Graphical Editing page\u00a0or PCB Editor \u2013 General page of the Preferences dialog.\t\t\t\t\t\t\t\t\t\tIf you find that you repeatedly and inadvertently select\u00a0certain objects, you can make them harder to select by enabling the Shift Click to Select option in the Schematic \u2013\u00a0Graphical Editing page\u00a0or the\u00a0PCB Editor \u2013 General page of the Preferences dialog. Click the Primitives button to access the\u00a0Must Hold Shift To Select dialog or the\u00a0Shift Click To Select dialog\u00a0in which you can configure which objects require Shift to be held during selection.\t\t\t\t\t\t\u00a0\t\t\t\tThe\u00a0Must Hold Shift To Select and\u00a0Shift Click To Select dialogs\t\t\t\t\t\t\t\t\t\tWhere a group of objects overlap, use the command repeatedly to cycle through the objects, selection-wise, with the object at the front selected first\u00a0then the object drawn next behind it selected, and so on.\t\t\t\t\t\tThis approach is ideal when the number of objects to be selected is small, or perhaps when there are different kinds of objects to be edited simultaneously.Selection RectangleTo select a number of objects located in a specific area of the design document,\u00a0you can use a selection rectangle. Click and Hold\u00a0away from objects in the corner of the imaginary rectangle enclosing the objects to be selected then drag to the opposite corner of this rectangle. Note that the behavior of selection using the selection rectangle depends on the direction of dragging, from Left to Right or from Right to Left.Select Within or Select Touching?Selection can either be objects that are\u00a0within the selection rectangle or touching the selection rectangle. This is controlled by the direction you move the mouse as you draw the selection rectangle:\t\t\t\t\t\t \t\t\t\u00a0Select Within - click and drag a blue rectangle from left to right to select all visible objects that are completely within the selection rectangle.\t\t\t\t\t\t\t \t\t\tSelect Touching - click and drag a green rectangle from right to left to select all visible objects that touch the selection rectangle.\t\t\t\tThis behavior of the selection rectangle works when the\u00a0Use Left\/Right Selection\u00a0option is enabled in the\u00a0System \u2013 General page of the Preferences dialog. When this option is disabled, only a blue rectangle is used independently of the mouse move direction, i.e. only objects that fall completely inside the selection rectangle are selected.Partial Selection - Selecting a Child ObjectCertain objects, including schematic components, sheet symbols, and harness connectors, are parent objects because they contain child text strings that can be edited independently. If a child object is selected but the parent is not, the parent&#039;s editing handles are displayed without color, indicating that a child of that object is currently selected, but not the entire object.Certain editing actions, such as a move command, will include the child object, while other editing actions, such as a delete command, will not. To delete a parent object and its children, it must be selected (displaying colored editing handles). These differences are demonstrated in the video below. \tNote how the component selection handles change when a child object is selected or the entire component.Selection\/Deselection CommandsTo select\/deselect objects you can use the commands of the Edit \u00bb\u00a0Select and Edit \u00bb DeSelect sub-menus of the main menus. These selection commands include:\t\t\tInside Area\u00a0\u2013\u00a0select\/deselect design objects inside of a user-defined rectangular area.\t\t\t\t\t\tOutside Area\u00a0\u2013\u00a0select\/deselect design objects outside of a user-defined rectangular area.\t\t\t\t\t\tLasso Select\u00a0\/ Lasso Deselect \u2013\u00a0select\/deselect design objects within a user-defined, free-form &#039;lasso&#039; area.\t\t\t\t\t\tTouching Rectangle\u00a0\u2013\u00a0select\/deselect any design objects that are touched by a user-defined rectangle.\t\t\t\t\t\tTouching Line\u00a0\u2013\u00a0select\/deselect any design objects that are touched by a user-defined line.\t\t\t\t\t\tAll (shortcut: Ctrl+A)\u00a0\u2013\u00a0select all objects on the current document.\t\t\t\t\t\tToggle Selection\u00a0\u2013\u00a0objects that are currently selected will be deselected. Conversely, objects that are not currently\u00a0selected will become selected.\t\t\t\tThe S key pops up the Select menu. The X key pops up the DeSelect menu. Selection commands can also be accessed from the\u00a0 button menu in the Active Bar.Selection MemoryEight selection memories are available in the schematic and PCB editors, which can be used to store and recall the selection state of up to eight sets of objects on the schematic or PCB. Select the objects you want to remember and then store them for quick recall later.The following selection memory options are available:\t\t\tStore in memory (Ctrl\u00a0+ number 1 to 8) -\u00a0store the current selection in the\u00a0design space, into the indicated selection memory location.\t\t\t\t\t\tAdd to memory (Shift\u00a0+ number 1 to 8) -\u00a0add the current selection in the\u00a0design space, to the objects already stored in the indicated selection memory location.\t\t\t\t\t\tRecall from memory (Alt\u00a0+ number 1 to 8) -\u00a0select the objects in the design space of the current document, that are currently stored in the indicated selection memory location.\t\t\t\t\t\tRecall and Add from memory (Shift\u00a0+ Alt + number 1 to 8) -\u00a0select objects in the design space of the current document, that are currently stored in the indicated selection memory location, in addition to any objects already selected.\t\t\t\t\t\tApply memory as a design space filter (Shift\u00a0+ Ctrl\u00a0+ number 1 to 8) -\u00a0apply a filter to the current document, essentially using the content of the indicated selection memory location as its scope.\t\t\tYou can also access the selection memories using the Edit \u00bb Selection Memory sub-menu.Alternatively, use the Selection Memory\u00a0dialog that is opened by pressing Ctrl+Q.\u00a0\tThe Selection Memory dialog: in the schematic editor (the first image) and in the PCB editor (the second image)Click on an\u00a0STO button to store a selection or RCL to recall a selection.\u00a0Click Apply\u00a0to highlight the related memory contents. Click\u00a0the\u00a0Clear\u00a0button or choose the\u00a0Edit \u00bb Selection Memory \u00bb Clear \u00bb n\u00a0command\u00a0from the main menus to clear the content of the indicated selection memory location (this command will not clear the content of the memory location if the\u00a0Lock\u00a0option for that location has been enabled in the\u00a0Selection Memory\u00a0dialog).As well as providing controls for manipulating each of the eight available selection memory locations, the dialog also summarizes the content status of each location. Selection content is summarized in terms of quantity of specific object (if the selection contains objects of a single type) or total number of objects (if the selected objects are of differing types).The visual result of the applied filtering in the design space is determined by a series of controls\u00a0defined at the bottom of the\u00a0Selection Memory\u00a0dialog:\t\t\tMask\u00a0- the filtered objects will appear fully visible in the design space with all other objects becoming dimmed. With masking applied, all objects not under the scope of the filter will be unavailable for selection\/editing.\t\t\t\t\t\tSelect\u00a0- the filtered objects will be selected in the design space.\t\t\t\t\t\tZoom\u00a0- the filtered objects will be zoomed and centered (where possible) in the design space.\u00a0The zoom action can be determined by the\u00a0Zoom Library Components\u00a0options on the\u00a0Schematic - Library AutoZoom page of the\u00a0Preferences\u00a0dialog.\t\t\t\t\t\tDocument Scope\u00a0(schematic editor only) - choose a document scope for the selection.\u00a0\t\t\tAny combination of these options can be enabled. For example, you might want to have all filtered objects zoomed, centered and selected in the design space\u00a0while applying masking to take away the clutter of other design objects.The\u00a0Clear Existing\u00a0option, also in the dialog, enables you to extend an existing filter, essentially refining the filter further by applying a new filter in addition to the existing one. To do this, make sure this option is disabled. If it is enabled (default), the existing filter will be cleared before applying the new one.You can manually clear an existing (and applied) filter at any time by using the\u00a0Shift+C\u00a0keyboard shortcut\u00a0or by clicking the Clear\u00a0button in the\u00a0Selection Memory\u00a0dialog.\tTo prevent accidentally overwriting a selection memory, enable the Confirm Selection Memory Clear option in the Schematic \u2013\u00a0Graphical Editing page\u00a0or PCB Editor \u2013 General page of the Preferences dialog. Selection Memory locations can be locked from being overwritten by checking the Lock checkbox associated with that selection memory.Notes\t\t\tBefore starting a selection, it is a good idea to deselect all objects first.\t\t\t\t\t\tRefer to the following pages to learn more about advanced object selection techniques:\t\t\t\t\t\t\t\t\t\t\tWorking with the Selection Filter\t\t\t\t\t\t\t\t\t\tUsing Find Similar Objects Tools\t\t\t\t\t\t\t\t\t\tUsing Queries\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\tTo select corresponding objects between PCB and schematic documents (e.g., components), Altium Designer includes the\u00a0Cross Select\u00a0functionality. Refer to the Cross Selecting section of the\u00a0Cross-Probing &amp; Selecting\u00a0page to learn more.\t\t\t\t\t\tAltium Designer features a number of tools that can be used to select routes of interest in the PCB editor design space. Refer to the\u00a0Strategies for Selecting the Routing\u00a0page to learn more.\t\t\tvar p = document.getElementsByClassName(&quot;Counter&quot;);for (k = 0; k &lt; p.length; k++) {Bloberator(p[k].id, &quot;0&quot;);}document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);function Update(ss, n) {var g = (document.getElementById(ss).innerHTML) - 1;var TextArray = document.getElementsByClassName(ss + ss);var ImageArray = document.getElementsByClassName(ss);if ((g == 0) &amp; (n == -1)) {n = 0;}ImageArray[g].style.opacity = &quot;0&quot;;ImageArray[g].style.zIndex = &quot;-1&quot;;if (g &lt; TextArray.length) {TextArray[g].style.display = &quot;none&quot;;}g = g + (n);if (g == ImageArray.length) {g = 0;}var v = ImageArray[g].getElementsByTagName(&quot;video&quot;)[0];if (v != null) {v.currentTime = 0;v.play();}ImageArray[g].style.opacity = &quot;1&quot;;ImageArray[g].style.zIndex = &quot;1&quot;;if (g &lt; TextArray.length &gt; 0) {TextArray[g].style.display = &quot;inherit&quot;;}document.getElementById(ss).innerHTML = g + 1;Bloberator(ss, g);}function Bloberator(sss, m) {var dots = &quot;&quot;;var IR = document.getElementsByClassName(sss);for (d = 0; d &lt; IR.length; d++) {if (d == m) {dots = dots + &quot;&quot;;} else {dots = dots + &quot;&quot;;}}var dotrows = document.getElementsByName(sss);for (x = 0; x &lt; dotrows.length; x++) {dotrows[x].innerHTML = dots;}}","tags":"","url":"altium-designer\/24\/documentation-altium-designer-design-object-selection.html"},
{"title":"Working with the Selection Filter","text":"\u00a0Even a small circuit can involve dozens of components spread over multiple schematic sheets, to which you can easily add hundreds of pads, vias, and tracks as you design the PCB. As you work on the design, you will be constantly adding and editing. In order to do that efficiently, you need an editing interface that allows you to easily select, examine and modify only those objects you are after.\u00a0To edit multiple objects you first need to select them; the challenge is selecting only those objects you are after.Altium Designer simplifies this challenge with the Selection Filter. The filter is available at the top of the Properties panel, which is displayed whenever there is nothing selected in the schematic or PCB editor&#039;s design space.\tThe Selection Filter is used to define which objects can be selected; it does not select those objects. Once a filter has been applied, all of the standard selection techniques can be used; more on these below.\tAccessing the Selection FilterThe Selection Filter is located at the top of the Properties panel. To open the panel, press F11, or use the\u00a0  button on the bottom right. It is displayed in the Document Options\u00a0(schematic and Board (PCB)\u00a0panels when there is nothing selected in the design space and\u00a0is used to configure the base properties in the current editor.A blue button indicates that object kind can be selected.  The schematic and PCB editor selection filters\u00a0are available in the Properties panel when there is nothing selected in the design space.\tThe Selection Filter is also available on the Active Bar.\u00a0The defined filtering in the pop-up pane will be reflected in the\u00a0Properties\u00a0panel. Conversely, changes made to the filter in the\u00a0Properties\u00a0panel will be instantly reflected in the pop-up pane.\t\t \tWorking with the Selection FilterAll editing actions require the target objects to be selected first, so selecting is core to becoming proficient at editing in Altium Designer. The selection filter greatly simplifies the selection process, allowing you to quickly create a filter that only allows the object kinds of interest to be available for selection. All object kinds that are not enabled remain visible\u00a0but cannot be moved or edited.\t\t\tThe All - On button is a global toggle; use it to toggle all object types on. With this button, you can turn all object types on, and still selectively enable only the one(s) you need.\t\t\t\tThe All - Off button is a global toggle; use it to toggle all object types off. With this button, you can turn all object types off, and still selectively enable only the one(s) you need.\t\t\t\tThe Custom button is used to toggle only certain object types on. With this button, you can turn certain object types on or off. If the object-type button is blue, that specific object-type is enabled.\t Use the Custom button to toggle all object types you need.Once you have applied a filter, you can select the objects of interest using the standard selection techniques.Post Selection FilterA common challenge is selecting certain object types within a group of objects. Rather than attempting to carefully select only the objects of interest, another approach is to perform a broader selection\u00a0and then filter down the result set.The post-selection filter is available at the top of the\u00a0Properties panel, as shown in the image below. To use the post-selection filter:\t\t\tSelect the objects.\t\t\t\t\t\tClick the post-selection filter arrow (highlighted in the image above) to display the object type button then enable only those objects required. In the image above, a section of the circuit was selected then the post-selection filter\u00a0was used to filter out all objects except power ports.\t\t\t\t\t\tClick the funnel icon to clear the post-selection filter.\t\t\t\tThe Selection Filter applies to the objects in the document or design space (defining what can be selected); the post-selection filter\u00a0only applies to the objects currently selected in the Properties panel.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-selection-filter.html"},
{"title":"Using Find Similar Objects Tools","text":"The Find Similar Objects process uses the attributes of a target object as a reference for finding several other objects with similar characteristics. The use interface to this process is the Find Similar Objects dialog that\u00a0can be accessed from the schematic, schematic symbol, PCB, PCB footprint, wiring diagram, and layout drawing editors\u00a0in the following ways:\t\t\tSelect\u00a0Edit\u00a0\u00bb Find Similar Objects\u00a0from the main menus, then click on an object in the design space. This object will be used as the template for finding similar objects.\t\t\t\t\t\tPress\u00a0Shift+F then click on an object in the design space to use as the template.\t\t\t\t\t\tRight-click over the required object in the design space\u00a0then choose\u00a0Find Similar Objects\u00a0from the context menu to open the Find Similar Objects dialog.\t\t\t\u00a0\tThe Find Similar Objects dialog for a schematic object and a PCB objectThe data displayed in each region (Kind,\u00a0Object Specific, and\u00a0Graphical) of the grid depends on the object that was clicked on when the dialog was accessed. If a 3D body object is selected in a PCB or PCB footprint, an additional\u00a03D Model Properties\u00a0region will be available.The grid for the reference object is divided into three columns:\t\t\tLeft column - lists the names of all the attributes of the reference object.\t\t\t\t\t\tCenter column - lists the value of those attributes taken from the reference object.\t\t\t\t\t\t\tTo search for objects with different values, enter the search pattern into the attribute value column directly. The &#039;*&#039; character can be used as a wildcard for finding any group of characters. For example,\u00a0C* will find C1, C2, C20, C397, Cap5, etc. Edits made to the attribute value in the dialog will not alter the attributes of the reference object.\t\t\t\t\t\t\t\t\tRight column - provides a drop-down list of options used for specifying how the associated attribute should be used to find similar objects. The options are:\t\t\t\t\t\t\t\t\tAny - find similar objects with any value for this attribute.\t\t\t\t\t\t\t\t\t\tSame - find similar objects with the same value set for this attribute\u00a0as that of the reference object.\t\t\t\t\t\t\t\t\t\tDifferent - find similar objects with a different value set for this attribute\u00a0as that of the reference object.\t\t\t\t\t\t\tBy default, the\u00a0Object Kind\u00a0parameter will be set to\u00a0Same, with all other parameters set to\u00a0Any. This basically means &#039;find all objects of the same kind, regardless of other parameteric values&#039;. Make changes to narrow the search as required.\t\t\tThe options in the lower section of the Find Similar Objects dialog define the action to be taken for the identified items.\u00a0The checkboxes and drop-down fields operate as follows once the Apply or OK button is clicked:\t\t\tZoom Matching - enable this option to have all objects matching the search criteria zoomed and centered (where possible) in the design space.\t\t\t\tSelect Matching \/ Select Matched\u00a0- enable this option to have all objects matching the search criteria selected in the design space.\t\t\t\tScope\u00a0(schematic, schematic symbol,\u00a0wiring diagram and layout drawing editors only) -\u00a0use the drop-down to determine the scope of the filtering. The options available depend on the editor you are in:\t\t\t\t\t\t\t\t\tSchematic,\u00a0wiring diagram and layout drawing editors\u00a0- choose to apply the filtering to the\u00a0Current Document,\u00a0Open Documents\u00a0in the active project, or all\u00a0Project Documents.\t\t\t\t\t\t\t\t\t\tSchematic symbol editor\u00a0- choose to apply the filtering to the\u00a0Current Component\u00a0or\u00a0All Components\u00a0in the active library.\t\t\t\t\t\t\t\t\tClear Existing\u00a0- enable this option to clear any existing selection or editing mask before performing the search. Disable this option if doing successive Find Similar Objects searches\u00a0and it is desirable for the results to accumulate.\t\t\t\tWhole Library (the PCB footprint editor only) - enable this option to determine the scope of the filtering, either within the active component only (disabled) or across all components in the library (enabled).\t\t\t\tMask Matching\u00a0(schematic, schematic symbol,\u00a0wiring diagram and layout drawing editors only) - enable this option to have those objects matching the search criteria appear fully visible in the design space with all non-matching objects becoming dimmed. With this option applied, non-matching objects will be unavailable for selection and editing.\t\t\t\tCreate Expression -\u00a0enable this option to create a query\u00a0expression that matches the criteria specified by the\u00a0dialog, and enter it into an associated\u00a0Filter panel. The\u00a0Filter panel will be opened if it is not already. This option makes it possible to use the Find Similar Objects dialog as a quick way of constructing complicated filtering operations.\t\t\t\t\t\t\tLearn more about\u00a0Working with the Query Language.\t\t\t\t\t\tFiltering drop-down\u00a0(the PCB and PCB footprint editors\u00a0only) - use this field to set the style of filtering applied in the design space. Choose from the following options:\t\t\t\t\t\t\t\t\tNormal\u00a0- choose this option to have those objects matching the search criteria appear fully visible in the design space. The appearance of non-matching objects remains unchanged.\t\t\t\t\t\t\t\t\t\t\t\t\t\tMask\u00a0- choose this option to have those objects matching the search criteria appear fully visible in the design space with all non-matching objects being made monochrome. With this option applied, non-matching objects will be unavailable for selection and editing.\t\t\t\t\t\t\t\t\t\t\t\t\t\tDim\u00a0- choose this option to have those objects matching the search criteria appear fully visible in the design space with all non-matching objects retaining their colors, but being shaded (dimmed). With this option applied, non-matching objects will still be available for selection and editing.\t\t\t\t\t\t\t\t\t\t\t\t\tOpen Properties - enable to automatically open the Properties panel.\t\t\t\t\t\t\tUse the\u00a0Apply\u00a0button to test and fine tune search criteria to yield the desired results, without closing the dialog.\t\t\t\t\t\t\t\t\t\tFor the schematic and schematic library editors, adjust the level of masking applied to objects not falling under the scope of the active filter, by using the slider bar - accessed from the applicable filter panel. This is only possible provided the\u00a0Create Expression\u00a0option was enabled in the\u00a0Find Similar Objects\u00a0dialog. This is needed to load the filter panel with the correct filter expression, since changing the slider position is only effected upon applying the currently defined filter (so needs to be the filter expression that was applied from the\u00a0Find Similar Objects\u00a0dialog).\t\t\t\t\t\t\t\t\t\tFor the PCB and PCB footprint editors, if the highlighting method in the dialog has been set to Mask, adjust the level of masking applied to objects not falling under the scope of the active filter\u00a0by using the Masked Objects slider bar in the Mask and Dim Settings section\u00a0on the View Options tab of the View Configuration panel. If the highlighting method in the dialog has been set to Dim, adjust the level of dimming applied to objects not falling under the scope of the active filter\u00a0by using the Dimmed Objects slider bar in the Mask and Dim Settings section of the same panel.\t\t\t\t\t\t\t\t\t\tTo clear filtering currently applied to the design space through use of the Find Similar Objects feature, use the\u00a0Shift+C\u00a0shortcut. Alternatively, right-click within the design space and choose the\u00a0Clear Filter\u00a0command.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-find-similar-objects-tools.html"},
{"title":"Using Queries","text":"Underlying Altium Designer&#039;s schematic and PCB editors is a powerful query engine. By entering queries into this engine, you can logically scope precisely those objects you require. A query is a string you enter using specific keywords and syntax, which will return the targeted objects.There are a number of places where you can apply a query but command central is the\u00a0Filter\u00a0panels shown in the images below.\tThe PCB Filter and SCH Filter panels with queries\tThe PCBLIB Filter and SCHLIB Filter panels with queriesQueries can be defined in a Filter panel to select a group of objects\u00a0in the schematic, schematic symbol, PCB, or PCBLIB editor.\u00a0To use a Filter panel to select a required group of objects, perform the following steps:\t\t\tOpen the Filter\u00a0panel by clicking the \u00a0button in the lower right corner of the design space or by pressing\u00a0F12\u00a0to display\/hide the panel.\t\t\t\t\t\tIn the text field of the panel, define a query by typing into the field. As you type, a prompt list of possible keywords appear as an aid. To provide aid in the creation of queries, a number of tools are available:\t\t\t\t\t\t\t\t\t\t\tQuery Helper dialog.\t\t\t\t\t\t\t\t\t\t\t\t\t\tDefining the objects to be found in the Find Similar Objects dialog with the Create Expression option enabled.\t\t\t\t\t\t\t\t\t\t\t\t\t\tUsing the PCB Filter or PCBLIB Filter panel settings in the Object and Layer regions of the panel and the Query Builder dialog.\t\t\t\t\t\t\t\t\t\t\t\t\tEnable the Select option in the panel.\t\t\t\t\t\tConfigure other settings in the panel to define the scope of searching, i.e., what should be done with non-matching objects, etc.\t\t\t\t\t\tClick the Apply \/ Apply to All \/ Apply to Selected button.\t\t\tAll of the objects that are members of the query result set subsequently acquire a selected state, ready to be edited.\tTo learn more about working with the query language and the Filter panels, refer to the\u00a0Working with the Query Language\u00a0page.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-using-queries.html"},
{"title":"Editing Multiple Design Objects","text":".Container {position:relative; user-select:none; display:inline-block; margin:0 30px 0 30px;}\t.SlidesTable td {border:none;padding:0;}\t.FirstText {border:none; display:inherit;padding: 0 30px 0 40px;}\t.FirstText {border:solid 1px lightgray; display:block; padding:8px;}\t.OverlayText {border::none;; display:none;padding: 0 30px 0 40px;}\t.OverlayText {border:solid 1px lightgray; display:block; padding:8px;}\th5 {font-family:dinpro-medium; line-height:1.2; font-size:17px; letter-spacing:normal; color:#424242; margin: 0 0 12px;}\t.Next,.Previous {font-size:25px; cursor:pointer; position:absolute; top:40%; color:blue; padding:2px 8px 5px 8px;}\t.Next {right:-30px;}\t.Previous {left:-30px;}\ta.Next, a.Previous {opacity:0.6; transition:0.3s;}\ta:hover.Next, a:hover.Previous {opacity:1; background-color:lightgray; text-decoration:none;}\t.Overlay {z-index:-1; position:absolute; top:0; transition:0.5s ease; opacity:0;  padding:10px; border:solid 1px; border-color:lightgray;}\t.First {transition:1s ease-in; padding:10px; border:solid 1px; border-color:lightgray;}\t.blob {height:15px; width:15px; margin:0 5px; background-color:#bbb; border-radius:50%; display:inline-block; cursor:pointer;}\t.blobs {text-align:center; padding:0; color:blue;}\t.Counter {display:none;}Altium Designer provides a range of editing tools and capabilities that have been designed to help with making large-scale edits to a design. The main tools for large-scale\u00a0or global\u00a0edits in Schematic, Schematic Symbol, PCB and PCB Footprint editors are the corresponding\u00a0Filter panel, List panels and Find Similar Objects capabilities.The process of editing multiple items in Altium Designer involves three steps:\t\t\tSelect the objects to be targeted.\t\t\t\tInspect the properties of those objects.\t\t\t\tEdit the properties that need to be amended.\tWith this editing paradigm in mind, Altium Designer\u00a0offers a range of different ways to select, inspect, and edit multiple objects. Each method has its strengths and by having an understanding of how they work, you are equipped to choose the method that is most applicable to your specific editing challenge.Selecting ObjectsObjects can be selected in a variety of ways\u00a0and they all fall into two categories:\t\t\tGraphical selection \u2013 objects are selected in one of the following ways:\t\t\t\t\t\t\t\t\t\t\tIndividually by mouse clicks.\t\t\t\t\t\t\t\t\t\tAccumulatively by Shift+mouse clicks.\t\t\t\t\t\t\t\t\t\tUsing one of the sub-menu selection commands from the main menu (Edit\u00a0\u00bb Select).\t\t\t\t\t\t\t\u00a0\t\t\t\t\t\tLogical selection \u2013 objects are selected using an interactive or query-based process that targets and filters objects using specific parameters and\/or attributes as the search criteria. GUI elements that support this type of selection are:\t\t\t\t\t\t\t\t\t\t\tThe Selection Filter option of the Properties panel.\t\t\t\t\t\t\t\t\t\tThe Find Similar Objects dialog.\t\t\t\t\t\t\t\t\t\tA\u00a0Filter panel.\t\t\t\t\t\t\t\t\t\tA List panel.\t\t\t\t\t\t\t\t\t\tThe PCB panel\u00a0(in the PCB editor).\t\t\t\t\t\t\t\u00a0\t\t\t\tSee the\u00a0Design Object Selection\u00a0page to learn more.Inspecting ObjectsThe attributes of objects can be inspected or viewed in a variety of ways:\t\t\tDirect Inspection \u2013 the attributes of one or more objects are inspected directly through the Properties panel\u00a0or graphically in the main editor.\t\t\t\tIndirect Inspection \u2013 the attributes of one or more objects that have previously been selected are viewed using the List panel.\tEditing ObjectsSimilarly, objects can be edited in different ways:\t\t\tDirect editing \u2013 the attributes of one or more objects are edited directly through the Properties panel\u00a0or graphically in the main editor.\t\t\t\t\t\t\tTo edit all selected objects, open the Properties panel by clicking the Panels button, then choose Properties. To edit only the last object selected, right-click and then choose Properties.\t\t\t\t\t\tIndirect editing \u2013 the attributes of one or more objects that have previously been selected can be edited using the List panel.\t \tExamples of viewing and editing properties of polygon pours selected in a PCB document directly through the Properties panel\u00a0or indirectly through the PCB List panel.Modifying Data Strings using the Properties PanelUsing FormulasThe Properties panel has the ability to modify data strings using formulas in the schematic and PCB editors. Formulas and expressions offer a convenient method of modifying attribute parameters of multiple selected objects to change their location or string-based values such as the Designator and Comment. This allows you to apply a specific expression to the selected string objects. The expression can include any built-in arithmetic operators and functions that apply to strings.\tFor lists of operators and functions available for use, refer to the Arithmetic Operators and Global System Query Functions sections of the Working with the Query Language page.\tIf you want to use the current value for the attribute as part of the expression, you will need to make reference to this original value either by using the full name of the attribute or by using the exclamation character (the supported substitute for the name of the attribute currently being modified). When using attribute names, if any names contain spaces, these must be replaced by the underscore character. For example, use of the Component Designator field within a formula should be entered as Component_Designator.Using the Smart Edit FeatureSome parameter string fields also provide access to the Smart Edit dialog when multiple objects are selected, which is opened from the associated  button.The Properties panel offers further support for string modification through its Smart Edit feature. Select the cell entries pertaining to the attribute that you want to modify for all required objects, right-click then choose Smart Edit from the menu that appears. The Smart Edit dialog will open. The dialog offers two methods for performing string modification accessed from the Batch Replace and Formula tabs.MaskingMasking is a way of explicitly removing an object&#039;s eligibility for selection and\/or editing. It can be faster to first mask out what is not required instead of selecting what is required.Consider a design where all vias sitting under a specific BGA device need to have their diameter changed. One way to perform this operation would be to run a query that masks out all non-via objects on the design, then use the Edit \u00bb Select \u00bb Inside Area menu command to draw a rectangle around the BGA device to select the vias to be targeted.\u00a0Masked objects appear faded, where the selected object passes the applied filter and is displayed normally, with all other design objects faded in gray.\u00a0The level of fading can be adjusting using the Dimming options in the Highlight Methods region of the System - Navigation\u00a0page of the Preferences dialog. Clearing SelectionsThe current selection can be cleared in the following ways:\t\t\tPressing the Shift+C shortcut.\t\t\t\tUsing one of the Edit\u00a0\u00bb Deselect sub-menu commands.\tSelection CommandsThe following selection-based commands are available from the Edit \u00bb Select sub-menu.\t\t\tSelect overlapped - use this command to single select the next design object in a set of co-located (overlapping) objects, without utilizing a selection pop-up window\u00a0(shortcut: Shift+Tab).\t\t\t\tSelect next - with an initial object selected in the design, use this command to extend the selection to include the next higher-level object (or objects), based on logical hierarchy\u00a0(shortcut: Tab).\t\t\t\tLasso Select - use this command to select design objects within a user-defined, free-form &#039;lasso&#039; area.\t\t\t\tInside Area \u2013 use this command to select design objects within a user-defined area. All objects that fall completely inside this defined area will become selected.\t\t\t\tOutside Area \u2013 use this command to select design objects outside of a user-defined area. All objects that fall completely inside the defined area will remain non-selected. All objects outside of this area will become selected.\t\t\t\tTouching Rectangle \u2013 use this command to select design objects touched by a user-defined bounding rectangle.\t\t\t\tTouching Line \u2013 use this command to select design objects touched by a user-defined line.\t\t\t\tAll \u2013 use this command to select all design objects in the current document, including the board shape. (Shortcut: Ctrl+A).\t\t\t\tBoard \u2013 use this command to select the board shape and all design objects that lay within its bounding rectangle. (Shortcut: Ctrl+B).\t\t\t\tNet \u2013 use this command to select all routed track and electrical objects associated with a particular net. Simply click on an object within the required net. Click on an area of the design, away from any objects, to access the Net Name dialog in which the name of the net can be entered directly. If unsure of the name, enter ? and click OK to access the Nets Loaded dialog, which lists all currently loaded nets for the design.\t\t\t\t\t\t\tSelection is not cumulative for most of these commands including Net. When a new item is selected, the previous object will become deselected.\u00a0Press the Spacebar to accumulate selected items.\t\t\t\t\t\tConnected Copper \u2013 use this command to select all routed track and electrical objects that are all connected to the same piece of copper. Click on an electrical object (track, pad, fill, etc.) and all electrical objects that are connected by the same piece of copper will become selected. (Shortcut: Ctrl+H).\t\t\t\tPhysical Connection \u2013 use this command to select all routed track between two pad objects. Simply click on a track or pad and all contiguous tracks between the two pads will become selected, including any vias. The pads themselves will not be included in the selection.\t\t\t\tPhysical Connection Single Layer \u2013 use this command to select connected track segments on the current layer, i.e., to select contiguous copper until the layers change or a component pad is encountered.\t\t\t\tComponent Connections \u2013 use this command to select all routed connections emanating from the pads of a chosen component. The component&#039;s pads, along with connected tracks and vias will be selected, up to the next encountered pad in each case.\t\t\t\tComponent Nets \u2013 use this command to select all nets attached to a chosen component. All nets (and member net objects therein) attached to that component will be selected.\t\t\t\tRoom Connections \u2013 use this command to select all pad-to-pad routed connections that fall completely within the boundaries of the chosen room.\t\t\t\tAll on Layer \u2013 use this command to select all design objects on the current layer. The current layer is distinguished by the active tab at the bottom of the main design window.\t\t\t\tFree Objects \u2013 use this command to select all free primitive objects within the design. Group objects (such as components, coordinates, dimensions, and polygons) will not be selected. These objects must be converted to their free primitives in order for this selection mode to apply.\t\t\t\tAll Locked \u2013 use this command to select all design objects that have their Locked property enabled.\t\t\t\tOff Grid Pads \u2013 use this command to select all pads that are not placed on a defined snap grid.\t\t\t\tToggle Selection - use this command to change the selection status of one or more design objects in the current PCB document.\t\tAll currently selected objects will be deselected when using this command\u00a0unless the Click Clears Selection option is disabled on the PCB Editor \u2013 General page of the Preferences dialog.\tVarious de-selection commands are available from the Edit \u00bb Deselect sub-menu, including\u00a0deselection of all selected objects, all selected objects inside or outside of a user-defined area, all selected objects on the current layer, and all selected free objects.List PanelsThe Schematic, Schematic Symbol, PCB and PCB Footprint editors provide access to List\u00a0panels (SCH List, SCHLIB List, PCB List and PCBLIB List panels, respectively) that\u00a0display design objects\u00a0in tabular format, enabling you\u00a0to quickly inspect and\/or modify object attributes. When used in conjunction with the corresponding\u00a0Filter panel, it enables you to display just those objects falling under the scope of the active filter, allowing you to target and edit multiple design objects with greater accuracy and efficiency. Objects do not need to be selected in order for them to be displayed (and edited) in a List panel. \tIn addition to the main ways to access a panel (the Panels button at the bottom-right of the design space and the View\u00a0\u00bb\u00a0Panels\u00a0sub-menu\u00a0from the main menus), you can use the Shift+F12 shortcut key to toggle the visibility of the List panel on and off in the corresponding editor.The List panels are divided into two main regions:\t\t\tFiltering controls to define which objects are displayed in the panel (display scope).\t\t\t\tA tabular, spreadsheet-like region listing all objects falling under the defined display scope.\tDefining Panel Display ScopeControls at the top of the panel allow you to filter which objects are displayed in the panel and also define the current mode of the panel, allowing you to enable\/disable the panel&#039;s direct editing functionality. View\/Edit ModeUse the first field to choose the List panel mode. Click it\u00a0and choose from the following options:\t\t\tView\u00a0\u2013 this mode allows you only to view the\u00a0object attributes. Direct editing from within the panel will not be possible in this mode, as indicated by the gray background of the tabular region.\t\t\t\tEdit\u00a0\u2013 this mode allows you to view and edit the attributes of design objects\u00a0directly in the tabular region of the panel.\tDisplay ScopeClick on the next highlighted control to choose from the following options:\t\t\tnon-masked objects (default) \u2013 select\u00a0this option\u00a0to display in the tabular region only design objects that are not masked out in the design space (i.e.\u00a0only those objects that fall under the scope and specific query expression of the currently applied filter). This option is most effective when filtering is applied to the design space and the associated masking highlight\u00a0option is enabled.\t\t\t\tselected objects \u2013 select\u00a0this option\u00a0to display in the tabular region only design objects that are currently selected in the design space.\t\t\t\tall objects \u2013 select\u00a0this option\u00a0to display all design objects in the tabular region.\t\tWhen any filtering currently applied to the design space is cleared, the option to display non-masked objects in the panel will produce the same result as choosing the option to display all objects.Document\/Component ScopeThis control is available in the\u00a0SCH List, SCHLIB List, and PCBLIB List panel and allows you to select the documents\/components from which\u00a0object attributes should be displayed in the panel (the\u00a0PCB List\u00a0panel always displays design objects from the active PCB document).\u00a0Click on the next highlighted control to choose from the following options:\t\t\tcurrent document\u00a0(SCH List) \u2013 only display target objects from the active schematic document in the design space.\t\t\t\tcurrent component\u00a0(SCHLIB List, PCBLIB List) \u2013 only display target objects from the active library component in the design space.\t\t\t\topen documents\u00a0(SCH List)\u00a0\u2013 display target objects from all open schematic documents regardless of their parent project.\t\t\t\topen documents of the same project\u00a0(SCH List) \u2013 display target objects from all open schematic documents that are source documents of the same parent project.\t\t\t\tall project documents\u00a0(SCH List) \u2013 display target objects from all schematic documents (including closed ones) that are source documents of the same parent project.\t\t\t\tall components\u00a0(SCHLIB List) \/\u00a0whole library (PCBLIB List) \u2013 display target objects from all components contained in the active schematic\/PCB library document.\tTypes of ObjectsThe right-most highlighted control allows you to determine the type of objects that can be displayed in the tabular region. Click on the control to reveal a selection pop-up. Use the pop-up to choose which object types you want to include in the currently displayed list \u2013 either all objects (Display all objects) or specific objects. To choose one or more specific object types, enable the\u00a0Display only\u00a0option, then enable the checkbox next to the required object(s) in the list beneath. The list will only contain those object types currently displayed in the tabular\u00a0region of the panel.\tThe No\u00a0option in the PCB List panel refers to other object primitives that are featured in the PCB document but are not denoted in this list, such as Layer Stack Table and Drill Table objects.When enabling specific object types for display, the control will reflect the choice by listing the enabled types, separated by commas. Working with Filtered ObjectsThe main tabular region of the panel displays all design objects that pass the defined display scope for the panel in spreadsheet\u00a0form.Object data is initially unsorted. Data may be sorted by any attribute by clicking on the header for that attribute&#039;s column. Clicking once will sort in ascending order; click again to sort in descending order.Making Selections in the List PanelAs objects are selected in the panel, those objects\u00a0will appear distinguished in the list by the use of a blue background for all of its cells.\u00a0The list supports single or multiple selections, the latter using standard Ctrl+Click, Shift+Click, and click-and-drag features.Design objects selected in the List panel become selected in the design space, as demonstrated in the slides below.\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\tJavascript ID: Pnl_List_ObjectSelection\t\t\t\t\t\t\t\t\t\t\t\t\tTo work in the other direction, when you want to locate objects in the list as you select them in the design space, use the Selected Objects\u00a0option in the filter at the top of the List panel, as shown in the animation below.\tDouble-clicking on an entry in the List panel will open the Properties panel for that object, where you can make changes as needed.\tIn the PCB List panel, user-defined classes can only be edited with respect to their name. As such, double-clicking on a class entry will have no effect.\tDisplaying Filtering ResultsWhen a filter has been applied\u00a0based on a query expression entered into the corresponding Filter panel, only those objects under the scope of the filter will be shown, provided that:\t\t\tThe\u00a0Mask out\u00a0option is enabled in the Objects not passing the filter\u00a0region of the\u00a0SCH Filter\u00a0or\u00a0SCHLIB Filter\u00a0panel or the Mask option is selected in the Non-matching\u00a0region of the\u00a0PCB Filter\u00a0or\u00a0PCBLIB Filter\u00a0panel.\t\t\t\t\t\tThe display scope\u00a0option for the\u00a0List\u00a0panel is set to\u00a0non-masked objects.\t\t\t\tIf the\u00a0Select\u00a0option has also been enabled\u00a0in the Objects passing the filter\u00a0region (SCH Filter, SCHLIB Filter, PCBLIB Filter) or in the Matching\u00a0region\u00a0(PCB Filter, PCBLIB Filter) of the\u00a0Filter\u00a0panel, all filtered objects will appear selected in the list.\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\tJavascript ID: Pnl_List_FilteringResults\t\t\t\t\t\t\t\t\t\t\t\t\tEditing Object Attributes\tEditing is only possible if the panel is in\u00a0Edit\u00a0mode. When the panel is in\u00a0View\u00a0mode, you will be able to only view object properties.You can edit attributes of an object by editing the relevant entry in the List panel. Click on a cell to focus it and then either right-click and choose Edit\u00a0or click again to edit the attribute value directly. Depending on the attribute, you will need to type a value, toggle a checkbox, or select an option from a drop-down. The change will take effect after pressing Enter or clicking outside of the cell being edited. This is one of the advantages of using the panel to edit object properties;\u00a0the panel will remain open, allowing you to change many attributes\u00a0as needed.Another advantage of using the panel for editing is that multiple objects can be edited from one place. Selected objects can be of the same or differing types. Those attributes that are common to all objects in the selection will be displayed in the panel. Select the required cells \u2013 across all required objects \u2013 for the shared attribute to be modified. Then either right-click and choose the Edit command or press the F2 key (or the Spacebar). Edit the value for the chosen attribute with respect to the focused object in the selection (whose cell is distinguished by a dotted outline). Clicking outside the attribute&#039;s cell or pressing Enter will effect the change, which will subsequently be applied to all remaining objects in the selection.By using filtering, you can apply a query (an expression for the filter) to target a specific group of objects in the design\/library and then use the List panel to edit the attributes for these multiple objects directly.Editing Attributes with the Smart Grid ToolsThere are two Smart Grid commands available from the panel&#039;s right-click menu. These commands allow any Windows-compliant tabular data such as an external table (e.g., PDF) or a spreadsheet (e.g., Microsoft Excel or Google Sheets) to be used to either update the values of existing objects in a List panel (Smart Grid Paste, shortcut:\u00a0Shift+Ctrl+V) or insert newly-created objects (Smart Grid Insert, shortcut:\u00a0Ctrl+Ins).\tThe\u00a0List\u00a0panel must be in the\u00a0Edit\u00a0mode in order to have copy and paste commands enabled.Respective dialogs (Smart Gride Paste and Smart Grid Insert) for these commands are used to map the external tabular data coming in on the Windows clipboard\u00a0to the attributes of objects in the List panel, providing a preview of what changes will be made.Using the Smart Grid Paste CommandBefore opening the Smart Grid Paste\u00a0dialog, copy the required tabular data and\u00a0select the List panel\u00a0content you would like to update. The top half of the\u00a0dialog (the\u00a0Clipboard Table View region) will contain the table information from the clipboard. The selected tables from the\u00a0List\u00a0panel fill the bottom half of the dialog (the\u00a0List View region). Information moved into this region using the provided controls will be saved into the\u00a0List\u00a0panel after clicking\u00a0OK\u00a0to exit the dialog.There are two ways to update attributes of design objects using the\u00a0Smart Grid Paste\u00a0command: updating attributes one at a time with no header data\u00a0and updating attributes as a group in one operation with header data.You need to determine whether the tabular data has a\u00a0Header Row\u00a0or\u00a0No Header Row. These options are located at the top right of the\u00a0Smart Grid Paste dialog. If the tabular data has the header row, you can map and update multiple attributes in one operation.\u00a0Otherwise, you will have to do different attributes one by one.\t\t\tHeader Row\u00a0\u2013 if a header row is included in the information copied to the clipboard, enable this option. The header information will be used to form a header row of columns.\t\t\t\tNo Header Row\u00a0\u2013 if no header row is included in the information copied to the clipboard, enable this option. If a header row is included in the copied information and this option is enabled, the header information will be included in the main table area instead of being placed into column headers.\tUse the following controls to copy information from the\u00a0Clipboard Table View\u00a0into the\u00a0List View:\t\t\tPaste Column to Attribute \u2013 select a column in both sections of the dialog then click this button to copy the information from the Clipboard Table View and paste it into the List View.\t\t\t\tUndo Paste to Attribute \u2013 undo the last performed instance of the Paste to Attribute command (using the Paste Column to Attribute or Automatically Determine Paste buttons).\t\t\t\tAutomatically Determine Paste \u2013 use this button to allow the software to automatically determine where in the List View the clipboard information belongs.\t\t\t\tReset All \u2013 reset the entire dialog. The Clipboard Table View is refreshed. If new information is in the Clipboard, the top panel of the dialog will contain the new information. The List View will revert any changes that have not been saved, including which columns are visible.\t\t\t\tChoose Visible Columns \u2013 click to open the Choose Visible Columns dialog and select which columns to display in the\u00a0List View section of the Smart Grid Paste dialog. Enable\/disable options to Show\/Hide columns.\tFor example, to change attributes as a group using the\u00a0Smart Grid Paste\u00a0tool, copy the data using the\u00a0Copy With Header\u00a0command from the right-click\u00a0menu from the\u00a0List\u00a0panel, then paste the tabular data,\u00a0including the header row, in an Excel workbook. The updated tabular data from this workbook can then be pasted back into the same\u00a0List\u00a0panel using the\u00a0Smart Grid Paste\u00a0command from the pop-up menu. Make sure the selected entries in the\u00a0List\u00a0panel correspond to the pasted tabular data;\u00a0however, you can always select the entries first before doing a paste.Make sure the\u00a0Header Row\u00a0option on the top right of the dialog is enabled. The\u00a0Smart Grid Paste\u00a0dialog is then updated with the top half of the dialog representing the copied table data, while the bottom half shows the proposed\u00a0List\u00a0panel content. Click the\u00a0Automatically Determine Paste\u00a0button to map the attributes from the\u00a0Clipboard Table View\u00a0region to the\u00a0List View\u00a0region.All proposed data object mappings set by the\u00a0Automatically Determine Paste\u00a0button can be previewed before committing the new attributes to your document(s). Attributes that are being targeted by the\u00a0Paste\u00a0action are marked with a blue flag (the  icon), and those whose values are changing are marked in a bold font.You also can use the\u00a0Paste Column to Attribute\u00a0and\u00a0Undo Paste to Attribute\u00a0buttons to selectively update attributes. To restore all the attributes to their original values, click the\u00a0Reset All\u00a0button in the\u00a0Smart Grid Paste\u00a0dialog.Likewise, if you copy the tabular data without the row header and\u00a0update the tabular data in an external spreadsheet\u00a0then do a smart paste back into the\u00a0List\u00a0panel, you can only do a singular update of each attribute. That is, you use the\u00a0Paste Column to Attribute\u00a0and\u00a0Undo Paste to Attribute\u00a0buttons to update each targeted attribute and to undo this same attribute each time. The proposed changes are not committed to the document\u00a0until the\u00a0OK\u00a0button is pressed. Using the Smart Grid Insert CommandWith the\u00a0Smart Grid Insert\u00a0command, you can create new objects using the\u00a0Smart Grid Insert dialog\u00a0from the\u00a0List\u00a0panel. You must specify the object type in your tabular data before you can successfully insert new objects in the\u00a0List\u00a0panel and its associated document.\u00a0When the Smart Grid Insert\u00a0dialog is opened, the\u00a0List View region of the dialog is populated with information to be added to the List panel. Once the new data objects are mapped from the\u00a0Clipboard Table View\u00a0region to the proposed\u00a0List View\u00a0region, they are flagged with green indicators (the\u00a0 icon).\u00a0Click\u00a0OK\u00a0to close the dialog and to add information from the\u00a0List View\u00a0region into the List panel and create new objects in the document. \t\t\t\t\t\tThe easiest way is to copy the existing object data from the\u00a0List\u00a0panel using the\u00a0Copy with Header\u00a0command, make additions\/changes in a spreadsheet then insert the updated data back into the\u00a0List\u00a0panel.\t\t\t\t\t\t\tThe\u00a0Smart Grid Insert\u00a0tool in the SCHLIB List panel can be used to import multiple pins from a spreadsheet into the current schematic symbol\u00a0\u2013\u00a0learn more about\u00a0Accelerating Schematic Symbol Creation with the Smart Grid Insert Tool.\t\t\tEditing Attributes with Numeric ValuesFor a numerical-based attribute of a selected object, the simplest modification to that attribute&#039;s value is made by typing a new value to replace the existing one. The plus and minus operators can be used to specify the value&#039;s sign. A value entered without a specified sign is assumed to be positive. Therefore, entering 20 is the same as entering +20.You can enter specific units of measurement for a value entered. The software will convert the value into the current units defined for the document. If no units are specified, the default units set for the document will be used.Modification Using an ExpressionMore advanced modification can be achieved by using an arithmetic expression. Select the entry for the attribute you want to modify and type the expression that will be used to modify its value. You can enter any arithmetic expression\u00a0using any built-in arithmetic operators and functions.\tFor lists of operators and functions available for use, refer to the Arithmetic Operators and Global System Query Functions sections of the Working with the Query Language page.\tIf you want to use the current value for the attribute as part of the expression, you will need to make reference to this original value\u00a0either by using the full name of the attribute\u00a0or by using the exclamation character (the supported substitute for the name of the attribute currently being modified). If you want, you may use any other attribute field name in an expression. When using attribute names, if any names contain spaces, these must be replaced by the underscore character.To illustrate an example of using a simple expression, consider a component pin, the Length attribute of which is currently 30. If you wanted to extend this length to 45, you could enter the expression:Length + 15or, in shortened form:! + 15Note that the spaces are optional. When you press Enter, the value will be updated to 45.If instead you want to shorten the pin to a length of 20, you could use the subtraction operator\u00a0as illustrated by the following expressions:Length - 10\t! - 10To illustrate use of a function, the previous expression could be rewritten as:! - sqrt(100)The result would be the same \u2013 a length of 20.By using the attribute&#039;s name (or substitution character (!)), the previous expressions add to or subtract from the current value for the attribute. Without such entries in the expression, you would be setting the attribute&#039;s value to the evaluated result of the expression. For example, if the attribute name or substitution character had been left out of the previous expressions, the resulting pin length would have been 15 and -10.Again, you can enter specific units of measurement for a value entered into an expression. Altium Designer will convert the value into the current units defined for the document. If no units are specified, the default units set for the document will be used.By selecting multiple objects in the panel, you can change numerical attributes simultaneously using an expression. For example, you may want to adjust the length of a series of component pins\u00a0or shift components vertically or horizontally by a specific distance.Batch Replacement of String-based AttributesThere are times when you may want to modify a string-based attribute that is common to multiple selected objects in the design space. For example, you may want to rename selected data bus net label objects from D1, D2, D3, etc., to Data1, Data2, Data3, etc. To perform this type of batch replacement, the use of string substitution syntax is supported in the panel.A string substitution entry is enclosed in braces and has the form:{oldstring=newstring}An entry of this form causes all occurrences of oldstring found in the attribute&#039;s value to be replaced with newstring. In the case of the data bus net labels, you would select the associated Text attribute cell for each net label, right-click then choose Edit (or press F2), then enter {D=Data} in the active value field.If you want to replace multiple, differing string portions in the same target string, type multiple substitution entries, each enclosed in its own set of curly braces. For example, consider the following net labels, associated to the output wiring of a WB_PRTIO component, configured to have four, 8-bit I\/O ports:XPort8A_Out[7..0]\tXPort8B_Out[7..0]\tXPort8C_Out[7..0]\tXPort8D_Out[7..0]Now consider having placed a second WB_PRTIO component\u00a0configured to have four, 32-bit I\/O ports. Instead of placing individual net labels of a similar fashion on each output wire of each port in this second device, you could select all four of the above net labels, copy them, paste them onto the corresponding wires of the new port device, then rename them. It is in this last operation that batch string substitution comes into play.If the intended format of the new net labels is to be YPort32x_Out[31..0], where x represents the port (A, B, C or D), then you could select the Name attribute for the four net labels in the panel, enter edit mode then enter the following into the active value field:{X=Y}{8=32}{7=31}Altium Designer\u00a0takes this entry and effectively performs a batch substitution \u2013 substituting for the first expression, then the second, and so on.Smart Editing of String-based AttributesA List panel offers support for string modification through its Smart Edit feature. Select the cell entries pertaining to the attribute to be modified for all required objects, right-click, then choose Smart Edit from the context menu. This opens the Smart Edit dialog.\u00a0The dialog offers two methods for performing string modification\u00a0accessed from the Batch Replace and Formula tabs.Batch Replace\u00a0Tab The Batch Replace tab provides straightforward substitution, along the lines of the string substitution discussed previously (but without having to enter the curly braces). Click inside the\u00a0From\u00a0field and enter the portion of the current string that you want to replace. Then click inside the\u00a0To\u00a0field and enter the string to be used as the replacement. Note that the string substitution that is about to be performed is displayed at the bottom of the tab.For example, consider pins of a component\u00a0that currently have the prefix B\u00a0and you need to change them to the prefix A instead. In this case, select the\u00a0Pin Designator\u00a0attribute for each of the pins in the panel, then open the\u00a0dialog. On the\u00a0Batch Replace\u00a0tab, enter B in the\u00a0From\u00a0field and A in the\u00a0To\u00a0field (the replacement string is therefore\u00a0{B=A}). After clicking\u00a0OK, the pin designators will be modified accordingly.As with basic string substitution, the\u00a0Batch Replace\u00a0tab provides for replacement of multiple, differing string portions in the same target string. Enter the various substitutions as distinct\u00a0From-To\u00a0entries. Consider the previous WB_PRTIO example (see Batch Replacement of String-based Attributes), where strings of the form\u00a0XPort8x_Out[7..0]\u00a0need to be changed to\u00a0YPort32x_Out[31..0]. In this case, you would enter three distinct substitution entries on the\u00a0Batch Replace\u00a0tab, as shown in the image above.\tThe change is only applied to the characters entered into the\u00a0From\u00a0field. Any other characters in each targeted string, such as an incrementing numerical identifier, is not changed.Formula Tab The Formula tab provides for more advanced modification, allowing you to apply a specific expression to the selected string objects.\u00a0The expression can include any built-in arithmetic operators and functions that apply to strings.\tFor lists of operators and functions available for use, refer to the Arithmetic Operators and Global System Query Functions sections of the Working with the Query Language page.\tOnce again, if you want to use the current value for the attribute as part of the expression, you will need to make reference to this original value, either by using the full name of the attribute\u00a0or by using the exclamation character (the supported substitute for the name of the attribute currently being modified). When using attribute names, if any names contain spaces, these must be replaced by the underscore character. For example, use of the Component Designator field within a formula should be entered as\u00a0Component_Designator.For example, three selected memory components are specified in a design\u00a0with designators U1, U3 and U5. You might want to extend the designators of these components by including some indication of their role. First, select the cell entries for the Component Designator attributes of these components in the List panel and open the Smart Edit dialog. Then, on the Formula tab of the dialog, you could write an expression using the addition operator to add to the existing string value of the\u00a0Component Designator\u00a0attribute. This would take the existing (original) string value and concatenate it with a specified new string, as illustrated below:Component_Designator + &#039;_MEM&#039;or, in shortened form:! + &#039;_MEM&#039;Note that the spaces are optional. After clicking OK, the designators of the components will be updated to U1_MEM, U3_MEM and U5_MEM, respectively.\tExpressions entered in the Formula tab of the Smart Edit dialog are saved so they can easily be used again in the future. To re-use previously entered expressions, click \u00a0at the right end of the text field, then select an expression from the drop-down menu.To illustrate the use of string-based functions, consider the\u00a0Copy\u00a0function that can be used to take a portion of an original string and place it within an expression to create a new string. Using the previous WB_PRTIO example (see Batch Replacement of String-based Attributes), where strings of the form XPort8x_Out[7..0] need to be changed to YPort32x_Out[31..0], you could select the cell entries for each net label&#039;s\u00a0Text\u00a0attribute, access the\u00a0Smart Edit dialog,\u00a0then write the following expression on the\u00a0Formula\u00a0\u00a0tab:&#039;Y&#039; + Copy(Text,2,4) + &#039;32&#039; + Copy(Text,7,6) + &#039;31..0]&#039;or, in shortened form:&#039;Y&#039; + Copy(!,2,4) + &#039;32&#039; + Copy(!,7,6) + &#039;31..0]&#039;Another formula example \u2013 change the middle character of component designators CAB and CYB\u00a0to X:Copy(!, 1, 1) + &#039;X&#039; + Copy(!, 3, 1)If the replacement is more complex, such as if the parts of the string have varying lengths, use the Length function to calculate the values for the starting position and amount of characters, as shown below.Component designators CAAAAAB and CYYYB have a varying length middle part:\t\t\tReplace the entire middle part with a single X:\t\t\t\tCopy(!, 1, 1) + &#039;X&#039; + Copy(!, Length(!), 1)\t\t\t\t\t\tReplace the last character of the middle part with an X:\t\t\t\tCopy(!, 1, Length(!)-2) + &#039;X&#039; + Copy(!, Length(!), 1)\t\t\tPanel Right-click MenuThe right-click menu for the main list area of the panel provides the following commands:\t\t\tSwitch to View Mode\u00a0\/\u00a0Switch to Edit Mode \u2013 toggle between View and Edit mode.\t\t\t\tEdit \u2013 edit single or multiple selected objects with respect to a particular attribute in the list. When editing a single object, the command becomes available when an attribute cell entry for a design object is editable. After launching the command, you will be able to edit the value in the selected cell directly. Click outside the cell or press Enter to effect the change. When\u00a0simultaneously editing multiple objects, the command will become available only if the chosen attribute is editable for all objects in the selection. After launching the command, you will be able to edit the value in the focused cell directly. Click outside the cell or press Enter to effect the change across all cells in the selection.\u00a0The\u00a0List panel must be in Edit mode to access this command.\t\t\t\tSmart Edit \u2013 open the Smart Edit dialog, in which you can specify the criteria used to perform batch replacement of string-based attributes. The\u00a0List panel must be in Edit mode to access this command. Learn more about\u00a0Smart Editing of String-based Attributes.\t\t\t\tCopy \u2013 copy the selected cells in the list to the Windows clipboard for use in other applications.\t\t\t\tCopy with Header \u2013 copy tabular data, including the header row.\t\t\t\tPaste \u2013 paste the current content of the Windows clipboard into the list. Combined with the Copy command, Paste enables you to copy cell content out to another spreadsheet application, make modifications, and then paste the modified data back into the List panel.\u00a0The\u00a0List panel must be in Edit mode to access this command.\t\t\t\tSmart Grid Paste \u2013 open the Smart Grid Paste dialog to\u00a0change the value of existing objects from pasted tabular data. The\u00a0List panel must be in Edit mode to access this command. Learn more about\u00a0Editing Attributes with the Smart Grid Tools.\t\t\t\tSmart Grid Insert \u2013 open the Smart Grid Insert dialog to\u00a0create\u00a0new objects from the tabular data.\u00a0The\u00a0List panel must be in Edit mode to access this command. Learn more about\u00a0 Editing Attributes with the Smart Grid Tools.\t\t\t\tShow Children\u00a0(SCH List, SCHLIB List) \u2013 add object entries to the list with respect to the primitives that constitute group objects (e.g., Parts).\t\t\t\tZoom Selected \u2013 zoom\u00a0and center\u00a0(where possible) the selected objects in the design space.\t\t\t\tApply Filter (PCB List, PCBLIB List) \u2013 apply\u00a0filtering based on the selected object(s) in the list. The object(s) will be displayed in the design editor window in accordance with the Mask \/ Dim \/ Normal, Select and Zoom options\u00a0defined in the corresponding\u00a0Filter panel. The object(s) will be selected regardless of the status of the Select option in the Filter panel. Only those objects in the selection will be displayed in the list.\t\t\t\tClear Filter (PCB List, PCBLIB List) \u2013 clear\u00a0the currently applied filter and repopulate the list with all objects in the design.\t\t\t\tRemove Non-Selected (PCB List, PCBLIB List) \u2013 remove all objects from the list that are not currently selected.\t\t\t\tReport \u2013 generate a report containing all objects displayed in the list. After launching the command, the Report Preview dialog will open, in which you can view, print and export the report in various file formats. The report will contain only data that is visible in the panel.\t\t\t\tReport Selected \u2013 generate a report containing only those objects that are currently selected in the list. After launching the command, the Report Preview dialog will open, in which you can view, print and export the report in various file formats. The report will contain only data that is visible in the panel.\t\t\t\tShow Component Children (PCB List, PCBLIB List) \u2013 add object entries to the list with respect to the primitives that constitute components.\t\t\t\tShow Net Children (PCB List, PCBLIB List) \u2013 add object entries to the list with respect to all net objects that constitute nets in the design.\t\t\t\tShow Polygon Children (PCB List, PCBLIB List) \u2013 add object entries to the list with respect to the primitives that constitute polygons.\t\t\t\t\t\t\tThe Show Children-based commands are particularly useful when a small selection of parent objects have been previously selected and filtered.\t\t\t\t\t\tAdvanced (sub-menu) (PCB List, PCBLIB List) \u2013 this sub-menu has commands that allow you to switch to owner components, owner nets or owner polygons from selected child primitives or members belonging to those group objects. In each case, filtering will be applied to each owner object affected and the list will display only those owner objects and their primitives\/members\u00a0if the corresponding option to show children for an object is enabled.\t\t\t\tSelect All \u2013 select all objects in the list. The corresponding design objects will become selected in the\u00a0design space.\t\t\t\tSelect Column(s) \u2013 select all cells in the column(s) associated with the currently selected cell(s). All corresponding objects will become selected in the design space. This command is particularly useful when editing a particular attribute of multiple objects.\t\t\t\tSelect Row(s) \u2013 select all cells in the row(s) associated with the currently selected cell. All corresponding objects will become selected in the design space. This command is particularly useful when editing a particular attribute of multiple objects.\t\t\t\tChoose Columns \u2013\u00a0open the\u00a0Columns Setup dialog,\u00a0in which you can select the available columns that are displayed in the panel and the order\u00a0in which the columns appear.\u00a0By default, the Display Mode for each attribute is set to Automatic. In this mode, an attribute column will be automatically displayed if it is common to all design objects currently displayed in the panel. Click on the mode to open\u00a0options that allow you to force the display of the attribute (Show) or hide it completely (Hide).\t\t\t\t \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tEnable the\u00a0Show All Attributes\u00a0option to show all possible attributes.\t\t\t\t\t\t\t\t\t\t\t\t\tClicking the Default button will reset the Available Columns to present attributes only for enabled primitives in the design space and reset the Display Mode to Automatic for all.\t\t\t\t\t\t\t\t\t\t\t\t\tCommands are also available on the right-click context menu for the Available Columns region with which to curate the attributes presented:\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tEdit Selected\u00a0- edit the selected attribute&#039;s\u00a0Display Mode.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tShow All Attributes\u00a0- show all possible attributes.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tShow Enabled Primitive Attributes\u00a0- show only attributes with enabled primitives in the design space.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tAdvanced\u00a0- from the\u00a0sub-menu, select specific attributes to display. The\u00a0Hide All Attributes\u00a0option\u00a0will clear the\u00a0Attribute\u00a0column.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tIn terms of the ordering of columns, their display (left-to-right) in the panel reflects the top-to-bottom order in the Visible Columns region of the dialog. Use the Up and Down buttons to move a selected column entry, or click and drag it to the required position.\u00a0\t\t\t\t\t\t\t\t\t\tPanel ShortcutsThe following table summarizes key shortcuts that are available when using the main list region of the panel.\t\t\t\t\t\tArrow Keys\t\t\t\t\t\t\t\t\tShift focus to next cell in direction of arrow key\t\t\t\t\t\t\t\t\t\t\t\t\tLeft-Click+Drag\t\t\t\t\t\t\t\t\tMulti-select in direction of mouse movement\t\t\t\t\t\t\t\t\t\t\t\t\tCtrl+Click\t\t\t\t\t\t\t\t\tMulti-select (non-sequential)\t\t\t\t\t\t\t\t\t\t\t\t\tShift+Click\t\t\t\t\t\t\t\t\tMulti-select (sequential)\t\t\t\t\t\t\t\t\t\t\t\t\tSpacebar\u00a0or F2\t\t\t\t\t\t\t\t\tEdit selected cell\t\t\t\t\t\t\t\t\t\t\t\t\tEnter\t\t\t\t\t\t\t\t\tFinish editing current cell and enter edit mode for the cell below\t\t\t\t\t\t\t\t\t\t\t\t\tCtrl+C (or Ctrl+Insert)\t\t\t\t\t\t\t\t\tCopy\t\t\t\t\t\t\t\t\t\t\t\t\tCtrl+V (or Shift+Insert)\t\t\t\t\t\t\t\t\tPaste\t\t\t\t\t\t\t\t\t\t\t\t\tPage Up\t\t\t\t\t\t\t\t\tJump selection to top of visible list area\t\t\t\t\t\t\t\t\t\t\t\t\tPage Down\t\t\t\t\t\t\t\t\tJump selection to bottom of visible list area\t\t\t\t\t\t\t\t\t\t\t\t\tMouse-wheel\t\t\t\t\t\t\t\t\tPan up or down\t\t\t\t\t\t\t\t\t    var p = document.getElementsByClassName(&quot;Counter&quot;);    for (k = 0; k &lt; p.length; k++) {        Bloberator(p[k].id, &quot;0&quot;);    }    document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(3);    document.getElementById(&#039;slidesCSS&#039;).sheet.deleteRule(4);    function Update(ss, n) {        var g = (document.getElementById(ss).innerHTML) - 1;        var TextArray = document.getElementsByClassName(ss + ss);        var ImageArray = document.getElementsByClassName(ss);        if ((g == 0) &amp; (n == -1)) {            n = 0;        }        ImageArray[g].style.opacity = &quot;0&quot;;        ImageArray[g].style.zIndex = &quot;-1&quot;;        if (g &lt; TextArray.length) {            TextArray[g].style.display = &quot;none&quot;;        }        g = g + (n);        if (g == ImageArray.length) {            g = 0;        }        var v = ImageArray[g].getElementsByTagName(&quot;video&quot;)[0];        if (v != null) {            v.currentTime = 0;            v.play();        }        ImageArray[g].style.opacity = &quot;1&quot;;        ImageArray[g].style.zIndex = &quot;1&quot;;        if (g &lt; TextArray.length &gt; 0) {            TextArray[g].style.display = &quot;inherit&quot;;        }        document.getElementById(ss).innerHTML = g + 1;        Bloberator(ss, g);    }    function Bloberator(sss, m) {        var dots = &quot;&quot;;        var IR = document.getElementsByClassName(sss);        for (d = 0; d &lt; IR.length; d++) {            if (d == m) {                dots = dots + &quot;&quot;;            } else {                dots = dots + &quot;&quot;;            }        }        var dotrows = document.getElementsByName(sss);        for (x = 0; x &lt; dotrows.length; x++) {            dotrows[x].innerHTML = dots;        }    }","tags":"","url":"altium-designer\/24\/documentation-altium-designer-editing-multiple-design-objects.html"},
{"title":"Working with Panels","text":"Panels are essential elements of the Altium Designer environment. Whether specific to a particular document editor\u00a0or used on a more global, system-wide level, they present information and controls that aid productivity and allow you to design more efficiently.Accessing PanelsWhen the software is first started, a number of panels will already be open. Some panels, including the Projects panel and Navigator panel, will appear grouped and docked to the left side of the application window. Others, including the Components panel, will be in pop-out mode and appear as buttons on the right-hand border of the application window.At the bottom-right of the application window, the Panels button provides quick access to the available panels\u00a0in context with the document editor you are currently using.\tThe Panels button is located on the Status Bar. If this bar is not currently displayed, it can be made visible by choosing the View \u00bb Status Bar command from the main menus. \t \tUse the Panels button at the lower right of the design space to quickly access available panels in context with the document editor you are currently using.Click on an entry in the menu to open the corresponding panel. If a panel is open but not visible, for example, it is an inactive panel in a group of docked panels, or it is currently in pop-out mode, click its entry in the menu to make it visible\u00a0and it will become the active panel.\t\t\t\t\t\tA check\u00a0(  \u200b) next to a panel&#039;s name in the menu\u00a0indicates that the panel is open and visible in the design space. Note that the panel may be displayed on another monitor, in a multi-monitor design environment.\t\t\t\t\t\t\t\t\t\tThe cloud icon denotes that a Workspace connection is required to access the associated panel&#039;s\u00a0data. A blue icon ( \/ ) indicates\u00a0that you are connected to a Workspace and the associated panel&#039;s data is available to you.\u00a0If the cloud icon is grayed out ()\u00a0when the associated panel is selected, you will be directed to connect to a Workspace.\t\t\t\t\t\t\t\t\t\tAll currently available panels can also be accessed from the View \u00bb Panels sub-menu.\t\t\t\t\t\tPanel Display ModesDepending on the particular document editor that is currently active, a large number of panels may be accessible\u00a0or open\u00a0at any given time. To facilitate the layout and use of multiple panels in the design space, various panel display modes and management features are provided.Three different display modes are supported for panels:\t\t\tDocked Mode - panels are permanently displayed within the design space.\t\t\t\tPopup Mode - panels are hidden and appear\u00a0when their button is hovered over or clicked.\t\t\t\tFloating Mode - panels float over the design space and\u00a0become transparent when\u00a0the cursor is near.\tDocked ModeIn this mode, a panel can be docked horizontally\u00a0or vertically\u00a0within the main application window. Right-click on a panel&#039;s title bar (or tab) and choose Allow Dock from the context menu to configure its docking capability - Horizontally and\/or Vertically. When docking vertically, a panel will dock to the right or left of the main design space. When docking horizontally, a panel will dock either above the main design space (and below the main menus) or below the main design space (and above the Status Bar).\tWhen a panel is already docked, the corresponding docking control will be grayed out.\t\tFor ease of access, frequently used panels can be docked within the main environment.Popup ModeThis mode is essentially an extension of the standard docked mode. A docked panel can be put into this mode by clicking on the pin symbol next to the panel&#039;s close cross. The pin symbol will change to indicate the mode. \u00a0- the pin symbol, in this case, appears as \u00a0indicating that the panel is in docked mode. \u00a0- the pin symbol, in this case, appears as \u00a0indicating that the panel is in popup mode.In this mode, a panel will appear as a button on the application border, giving back valuable design space. Moving the cursor over the panel button will result in the panel sliding out from the border. Moving the cursor away from the panel will cause it to slide back again.  Example panel in popup mode, which is accessed by hovering the cursor over the panel button on the application border.\u00a0\tClicking on the panel button will expand the panel without sliding. In this case, click away from the panel to slide it back again.\tThe speed at which the panel slides in and out is configured on the System - View page of the Preferences dialog.Configure popup panel display attributes as part of your software preferences.Floating ModeIn this mode, a panel can be placed anywhere within\u00a0or outside of\u00a0the design environment. This is the standard opening mode for panels that have not been previously placed in docked\u00a0or popup mode. An example floating panel, which can be placed over\u00a0or outside of\u00a0the main application window.\tUse the F4 shortcut\u00a0to toggle the display of all panels that are currently in &#039;floating&#039; mode. Upon pressing F4,\u00a0all currently floating panels will either disappear or reappear, depending on whether they are currently visible or not.A floating panel positioned over the editing area of the main design space can also be made transparent when carrying out an interactive operation in the design space\u00a0in accordance with options defined on the System - Transparency page of the Preferences dialog.Configure floating panel transparency attributes as part of your software preferences.These options allow for making such panels (and toolbars, for that matter) transparent immediately when launching an interactive editing process. You can also make the transparency dynamic\u00a0so that floating entities become more transparent as the cursor approaches\u00a0as illustrated below.  Floating panels can be configured to become transparent whenever performing an editing action in the design space\u00a0and also dynamically as the cursor approaches\u00a0so as not to impede your activity.Grouping PanelsPanels may be grouped by dragging and dropping one panel on top of another. Two modes of grouping panels are supported:\t\t\tTabbed Grouping - this mode displays a set of panels as a tabbed group, with only one panel in the group visible at any time.\t\t\t\t\t\tFractal Grouping - this mode displays a set of panels as a fractal grouping, with multiple panels in the group visible at the same time.\t\t\tThe resulting display of the group depends on where you drop the panel being added. If you drop it in the center of the target panel, it will become a tabbed group. If you drop the moving panel onto one of the small arrows that appear on each edge of the target panel, it will become a fractal group.Tabbed Panel GroupingTo group a panel with other panels\u00a0in tabbed fashion:\t\t\tClick on the source panel&#039;s name then drag it over the center of the target panel (or existing group). The entire target panel will become shaded blue, indicating that the panels will become a single tabbed group.\t\t\t\tA small positional arrow will appear to the right of the target panels&#039; tabs, indicating that the source panel will be added to the group as another tab. You can control where the source panel will appear in the tabbed set\u00a0by moving the mouse near the existing tabs.\t\t\t\tDrop the source panel (release the mouse button) to group the panels together.\t An example of dragging a source panel onto an existing tabbed grouping of panels.Once grouped, use the small down arrow at the top-right of the panel grouping to change the visible panel. Alternatively, make another panel in the group the visible panel by clicking directly on its tab. The order of the panels in a tabbed group of panels can be changed at any time by clicking\u00a0on a panel&#039;s tab and then dragging to the left or right as required. A positional arrow will appear marking the position in the group order at which the panel will be placed when the mouse button is released. Illustrating how to change the visible panel\u00a0and panel tab order\u00a0within a tabbed grouping of panels.Fractal Panel GroupingThis mode displays a set of panels as a fractal grouping\u00a0with multiple panels in the group visible at the same time. Fractal grouping is similar to horizontal\/vertical tiling of open windows. You can drag a panel to dock it within another panel, essentially tiling them. A fractal grouping can consist of individual panels and\/or standard tabbed panels.\u00a0\tFractal grouping is available when the UI.DisableFractalMode option is disabled in the Advanced Settings dialog.\tTo group a panel with other panels\u00a0in fractal fashion:\t\t\tClick on the source panel&#039;s name then drag it over the target panel. The entire target panel will become shaded blue\u00a0with icons presented at the top (), bottom (), left (), and right ().\t\t\t\tMove the cursor over the required icon. Only that side of the target panel will become shaded, indicating where\u00a0in relation to the target panel\u00a0the source panel will appear.\t\t\t\t\t\t\tEnsure that only the shading for the required side is displayed\u00a0and not full shading, otherwise, the source panel will be added into a tabbed grouping\u00a0rather than a fractal one. This can also be verified by looking at the tab of the target panel (or tabs if already grouped). If there is a positional arrow, the source panel will be added as a member of the tabbed grouping. For fractal grouping, ensure this positional arrow is not present.\t\t\t\t\t\tDrop the source panel (release the mouse button) to group the panels together.\t\t\t\t \t\t\tAn example of dragging a source panel onto an existing fractal grouping of panels\u00a0to further split the region occupied by a target panel.\t\t\tTo make a panel active in a fractal grouping, click on it. If the required panel is part of a tabbed grouping within the overall fractal structure, make it visible\/active either by clicking on its corresponding tab or by choosing the required panel from the menu associated with the small down arrow\u00a0at the top-right of the panel grouping. Illustrating how to change the active\/visible panel\u00a0within a fractal grouping of panels.Moving PanelsThe following points relate to moving panels within the Altium Designer environment.\t\t\tA single floating\u00a0or docked panel is moved by clicking within the panel&#039;s title bar and dragging it to a new position. If a single panel is in popup mode, it can also be moved by clicking on its corresponding button in the application border and dragging the panel to the required position.\t\t\t\tWhen multiple panels have been grouped, clicking within a panel&#039;s caption bar and dragging will move all panels in that group. To move a single panel out of a group, click and drag the panel name in the caption bar (or its tab if available).\t\t\t\tMoving a panel to an application border that already contains one or more panels will result in the panel being added in the same mode (docked or popup) as those already present.\t\t\t\tTo take a panel out of fractal grouping mode (where it has been tiled) and back into a standard tabbed grouping, drag the tiled panel by its caption bar into free space,\u00a0or to a target panel, or existing tabbed group\u00a0until a positional arrow appears (target becomes fully shaded) and then release. The panel will be added to the tabbed grouping.\t\t\t\tAs you move a panel close to another floating panel, the edges will snap together. Similarly, moving a panel toward\u00a0the extremities of the desktop will snap the panel to the desktop&#039;s edge. This &#039;snap attraction&#039; feature allows for the easier arrangement of floating panel sets within the environment.\t\t\t\tTo prevent a moving panel from automatically docking, grouping, or snapping, hold the Ctrl key.\tClosing PanelsA panel can be closed by:\t\t\tRight-clicking in its caption bar and then choosing the Close command from the context menu.\t\t\t\tRight-clicking on its tab (where available) and choosing the Close command from the context menu.\t\t\t\tClicking the close cross at the far right of the panel&#039;s caption bar.\t\tIf the panel is part of a group (tabbed or fractal), doing this will close all panels in the group.\tIf a panel is closed and then accessed again, it will be displayed (restored) in the same location as that prior to its closure. If you have closed a grouping of panels, the group can be restored\u00a0exactly as it was\u00a0by opening the independent panels in the group.Maximizing\/Restoring PanelsWhen in floating mode, a panel (or grouping of panels) can be maximized by right-clicking in its caption bar (or on its tab, where available) and choosing the Maximize entry from the context menu. To restore a maximized panel (or grouping of panels) back to its original size, right-click in its caption bar (or tab) and choose the Restore command from the context menu. Alternatively, double-click in the caption bar to toggle between maximized and restored state.\tMaximizing\/restoring any visible panel in a fractal grouping of panels will cause the entire fractal grouping to be maximized\/restored.Resetting, Saving, and Loading Panel ArrangementsYou can save and reload panel arrangements\u00a0and also reset them to the installation defaults\u00a0using the buttons available for layouts\u00a0in the Desktop region\u00a0on the System - View page of the Preferences dialog.Access controls for managing desktop layouts\u00a0as part of your software preferences.For example, to reset all panels back to their default locations and visibility, click the\u00a0 button.\tEnvironment layout information, including the application window, which toolbars and panels are open, where they are open, and how they are sized\u00a0is stored in a Desktop Layout file (*.TLT). When you close Altium Designer, the layout information - how you have configured your environment - is stored in the UserTools.TLT file (found in the following location for a default installation: \\Users\\\\AppData\\Roaming\\Altium\\Altium Designer ). This file will be used when Altium Designer is next run. Since this file is overwritten with any changes to the environment each time you shut down, you may want to create and save specific layouts (using the\u00a0 button on the System - View page of the Preferences dialog), which can then be reloaded at any time (using the\u00a0 button on the System - View page of the Preferences dialog).\tDefault layout files are found in the \\Program Files\\Altium\\AD\\System\\Desktop Layouts folder\u00a0for a default installation.","tags":"","url":"altium-designer\/24\/documentation-altium-designer-working-panels.html"},
{"title":"Shortcuts","text":"\u00a0Perhaps the single thing you can do to become more productive in any software environment is to learn the\u00a0shortcuts\u00a0and, once learned, they become second nature. This article takes a look\u00a0at the\u00a0default shortcuts available across\u00a0various key design domains, including how you can access listings while you work, and how you can edit them.Shortcut ListingsThe following sections provide more information (or links to more information) about the shortcuts assigned for use in the software and its various editors. When looking at any of the shortcut key listings, keep in mind the following:\t\t\tWhen referring to shortcuts, use of the plus (+) symbol denotes holding multiple keys down on the keyboard in the indicated sequence. For example,\u00a0Shift+F1 means holding down the Shift key\u00a0then pressing the F1 key. Likewise, Shift+Ctrl+PgUp means holding down the Shift key\u00a0then holding down the Ctrl key at the same time\u00a0and pressing the PgUp key.\t\t\t\tWhere use of the standard mouse buttons is made, Click refers to a single click of the\u00a0left-hand mouse button, Double-Click refers to two clicks of the left-hand\u00a0mouse button, and Right-Click refers to a single click of the right-hand mouse\u00a0button.\tGeneral Altium Environment ShortcutsThe following shortcuts are typically always available,\u00a0irrespective of the type of editor that is currently active.\t\t\t\t\t\tShortcut\t\t\tDescription\t\t\t\t\t\t\t\t\tF1\t\t\tAccess technical documentation for the resource currently under the cursor (menu or toolbar command, dialog, panel, design object, Query Language keyword).\t\t\t\t\t\t\tCtrl+O\t\t\tOpen an existing document using the\u00a0Open dialog.\t\t\t\t\t\t\tCtrl+F4\t\t\tClose the active document.\t\t\t\t\t\t\tCtrl+S\t\t\tSave the active document.\t\t\t\t\t\t\tCtrl+Alt+S\t\t\tSave the current document as a new revision of the associated parent item in the connected Workspace. This command is used only when performing a direct edit on a Workspace item.\t\t\t\t\t\t\tCtrl+P\t\t\tPrint the active document (where supported).\t\t\t\t\t\t\tAlt+F4\t\t\tExit Altium Designer.\t\t\t\t\t\t\tCtrl+Tab\t\t\tCycle forward to the next open tabbed document, making it the active document in the design space.\t\t\t\t\t\t\tShift+Ctrl+Tab\t\t\tCycle backward to the previous open tabbed document, making it the active document in the design space.\t\t\t\t\t\t\tF4\t\t\tToggle the display of all floating panels.\t\t\t\t\t\t\tShift+F4\t\t\tTile all open documents.\t\t\t\t\t\t\tShift+F5\t\t\tToggle the focus between the last active panel and the currently active design document in the main design window.\t\t\t\t\t\t\tAlt+Right Arrow\t\t\tStep forward to the next document in the sequence of documents that have been made active in the main design window.\t\t\t\t\t\t\tAlt+Left Arrow\t\t\tStep back to the previous document, in the sequence of documents that have been made active in the main design window.\t\t\t\t\t\t\tF5\t\t\tRefresh the active document when that document is a web-based document.\t\t\t\t\t\t\tHold Ctrl while moving a panel\t\t\tPrevent automatic docking, grouping, or snapping.\t\t\t\t\t\t\tDrag and drop from Windows Explorer into Altium Designer\t\t\tOpen a document, project, or project group.\t\t\t\t\t\t\tShift+Ctrl+F3\t\t\tMove to the next message (down) in the Messages panel\u00a0and cross-probe to the object responsible for the message in the associated document (where supported).\t\t\t\t\t\t\tShift+Ctrl+F4\t\t\tMove to the previous message (up) in the Messages panel\u00a0and cross-probe to the object responsible for the message in the associated document (where supported).\t\t\tEditor-specific ShortcutsUse the following links to access pages of shortcuts specific to the indicated editor(s).\t\t\tSchematic Editor &amp; Schematic Symbol Editor Shortcuts\t\t\t\tPCB Editor &amp; PCB Footprint Editor Shortcuts\t\t\t\tComponent Editor Shortcuts\t\t\t\tOutput Job Editor Shortcuts\t\t\t\tDraftsman Editor\u00a0Shortcuts\t\t\t\tMulti-board Schematic\u00a0Editor\u00a0Shortcuts\t\t\t\tMulti-board Assembly Editor\u00a0Shortcuts\t\t\t\tCAMtastic Editor\u00a0Shortcuts\t\t\t\tSimData Editor\u00a0Shortcuts\t\t\t\tText-based Document Editor\u00a0Shortcuts\tAccessing ShortcutsIn a multi-editor environment like Altium Designer, it can be hard to remember the shortcuts, particularly those special-purpose ones that are available when you are running a command. To help with this, the software provides some ways to &#039;look up&#039; key shortcuts.While Running an Interactive CommandWhen running an interactive command\u00a0within the Schematic and PCB editors - for example Place \u00bb Wire in a schematic\u00a0or Route\u00a0\u00bb Interactive Routing in the PCB - use the Shift+F1 keyboard shortcut to access a menu\u00a0listing\u00a0all valid shortcuts for that stage of the interactive command. You can either process another command by choosing it from the menu, or\u00a0press\u00a0Esc to close the menu without impact on the currently running command (and use the desired shortcut thereafter).Use the Shift+F1 shortcuts menu to refresh your memory about the shortcuts available\u00a0or use it in the traditional menu sense\u00a0to select the required option with the mouse. Shown here is the menu when placing a wire on a schematic. Hover over the image to see the menu when interactively routing a connection on a PCB.Alternatively, and for some interactive commands, use the F1 keyboard shortcut. This gives access to the Graphical Editing Hot key List dialog, providing\u00a0a list of the shortcuts available. Click the Current Process Help\u00a0button to open the documentation page specific to the interactive command you are using. Note that the dialog is purely for guidance - the commands cannot be launched from within the dialog.Use the Graphical Editing Hot key List dialog to refresh your memory about the shortcuts available for the currently running interactive command. Shown here is the dialog when placing a wire on a schematic. Hover over the image to see the dialog when interactively moving a component on a PCB.\tRather than using the Close button to exit the dialog, which can affect the currently running command with a change to the current cursor location, press Esc\u00a0or Enter\u00a0instead.When Configuring Editor ResourcesWhen customizing the menus and toolbars for an editor in Altium Designer, a listing of the general shortcuts available in that editor, as well as interactive shortcuts (where supported), will be available to browse.\tQuickly enter customization mode for the active editor\u00a0by double-clicking in the blank area to the right of the main Help menu entry. For more information on customizing your installation of Altium Designer, see Configuration &amp; Customization.Access a listing of shortcuts when customizing an editor. Shown here is the listing of general shortcuts for the Schematic Editor (notice that there is also a listing of interactive shortcuts). Hover over the image to see the listing of general shortcuts for the PCB Editor.Editing ShortcutsThe fastest way to add or edit the shortcut(s) assigned to a command\u00a0is to Ctrl+click on the entry for that command on the relevant menu or toolbar. This will open the Edit Command dialog, from where you can add a shortcut\u00a0or edit the currently assigned one.\tTo add or edit a shortcut for a particular command, hold Ctrl as you click on that command&#039;s menu or toolbar entry to open the Edit Command dialog.To define the shortcut, click in the Primary field (in the Shortcuts region of the dialog), then press the key combination you want to use on your keyboard. Alternatively, use the drop-down list then scroll to the required key(s). If you want a second, different shortcut associated to the command, use the Alternative field, in the same way you setup the Primary field. If a shortcut key combination is currently in use, the command using it will be displayed below in the relevant\u00a0Currently in use by field. If you continue with the new assignment, it will be removed from that other command.Accelerator KeysIn addition to standard keyboard shortcuts, Altium Designer also employs the use of Accelerator Keys. These are used as part of the main menu system (not right-click context menus)\u00a0to be able to access commands\u00a0through the sequential use of one or more such keys.Specifying an Accelerator KeyAn accelerator key is specified as part of a menu (main or sub) or command&#039;s caption\u00a0by adding the ampersand (&amp;) character immediately before the letter that you want to use as the accelerator. Within a menu, the current accelerator key is distinguished by the use of underlining.\tCtrl+Click on a main menu or sub-menu entry, to access the Edit Drop Down Menu dialog. Ctrl+Click on a command entry to access the Edit Command dialog. Add the &amp; character at the required position within the defined Caption.An accelerator key is created by placing an &amp; character before that letter in a command or menu&#039;s caption. Shown here is the accelerator key &#039;R&#039; for the Rules command. Hover over the image to see the definition of the accelerator (&#039;m&#039;) for the Rooms sub-menu.\tWithin any given menu\u00a0or sub-menu, a particular letter can be used only once as an accelerator key.Main Menu AcceleratorsStrictly speaking, access to a root main menu through its accelerator key requires holding down the Alt key. This is because the same key\u00a0may also be assigned to a pop-up menu. So for example, access to the Simulate menu in the Schematic Editor (with\u00a0the Mixed Simulation system extension installed) would, at first sight, look to be a case of clicking the S key. However, while this is the menu&#039;s defined accelerator key, doing so will pop-up the Select\u00a0sub-menu (from the main Edit menu). By using Alt+S, the intended Simulate menu is accessed.The accelerator key for a main menu could be used as the popup key for a different sub-menu. Using Alt+ will always access that\u00a0main menu.In many cases, a main menu\u00a0will also have a pop-up key assigned (and typically the same key as its accelerator). Where this is the case, using that key will access the menu in pop-up form. For example, the Design\u00a0menu in the PCB Editor can strictly be accessed using Alt+D, but also in pop-up form using D. This functionality is defined for a menu in the Edit Drop Down Menu dialog, by using the Popup Key field.A menu can be accessed as a pop-up by specifying a popup key.\tFor obvious reasons, pop-up keys are not assigned to menus in text-based editors, and so main menus can only be accessed through use of the Alt key.The following table summarizes the accelerator and pop-up keys assigned to various main menus available across editors:\t\t\t\t\t\tMenu\t\t\tAccelerator Key\t\t\tPopup Key\t\t\t\t\t\t\t\t\tFile\t\t\tF\t\t\tF\t\t\t\t\t\t\tEdit\t\t\tE\t\t\tE\t\t\t\t\t\t\tView\t\t\tV\t\t\tV\t\t\t\t\t\t\tProject\t\t\tC\t\t\tC\t\t\t\t\t\t\tPlace\t\t\tP\t\t\tP\t\t\t\t\t\t\tDesign\t\t\tD\t\t\tD\t\t\t\t\t\t\tTools\t\t\tT\t\t\tT\t\t\t\t\t\t\tRoute\t\t\t(PCB Editor only)\t\t\tU\t\t\tU\t\t\t\t\t\t\tReports\t\t\tR\t\t\tR\t\t\t\t\t\t\tSimulate\t\t\t(Schematic Editor only)\t\t\tS\t\t\t-\t\t\t\t\t\t\tWindow\t\t\tW\t\t\tW\t\t\t\t\t\t\tHelp\t\t\tH\t\t\tH\t\t\tAccelerator Key Sequence ExamplesExpand one of the following collapsible sections\u00a0to access a listing of example accelerator key sequences available for the indicated editor. With hundreds of permutations available, you will soon build your own list of favorite keyboard sequences that you will want to keep in mind\u00a0and use\u00a0as you design.\tWhen referring to accelerator key sequences, use of the comma (,) symbol denotes pressing each key in the sequence in succession. For example,\u00a0T, V, U means press\u00a0the T key, then press\u00a0the V key, and then press\u00a0the U key.\tIn some of the examples, accelerator keys are used in combination with key sequences within dialogs, ultimately arriving at a quick sequence of keystrokes to achieve a dialog setting and apply it.\t\t    Schematic Keyboard Sequences    \t\t\t\t\t\t\t\t\t\tUse the Accelerator Key Sequence...\t\t\t\tTo...\t\t\t\t\t\t\t\t\t\t\t\t\t\tV, D\t\t\t\tFit document.\t\t\t\t\t\t\t\t\t\tV, F\t\t\t\tFit all objects.\t\t\t\t\t\t\t\t\t\tX, A\t\t\t\tDeselect all objects on the current sheet.\t\t\t\t\t\t\t\t\t\tV, G, S\t\t\t\tAccess the Choose a snap grid size dialog\u00a0in which\u00a0you can set the snap grid to a user-specified value.\t\t\t\t\t\t\t\t\t\tE, W\t\t\t\tBreak wire.\t\t\t\t\t\t\t\t\t\tT, A\t\t\t\tAccess the Annotate dialog.\t\t\t\t\t\t\t\t\t\tT, A, E\t\t\t\tReset schematic designators.\t\t\t\t\t\t\t\t\t\tT, A, I\t\t\t\tReset duplicate schematic designators.\t\t\t\t\t\t\t\t\t\tP, P\t\t\t\tUse to open the Components panel\u00a0with which to browse and place components from your own libraries.\t\t\t\t\t\t\t\t\t\tP, W\t\t\t\tStart wiring.\t\t\t\t\t\t\t\t\t\tP, V, K\t\t\t\tPlace Compile Mask Directive.\t\t\t\t\t\t\t\t\t\tP, V, N\t\t\t\tPlace Generic No ERC directive.\t\t\t\t\t\t\t\t\t\tM, M\t\t\t\tMove object.\t\t\t\t\t\t\t\t\t\tR, I\t\t\t\tAccess the Report Manager dialog\u00a0presenting a Bill of Materials for the active design project.\t\t\t\t\t\t\t\t\t\tT, P\t\t\t\tAccess the Schematic - General page of the Preferences dialog. If you have previously accessed a different page of the Schematic preferences, then that page will be presented.\t\t\t\t\t\t\t\t    PCB Keyboard Sequences    \t\t\t\t\t\t\t\t\t\tUse the Accelerator Key Sequence...\t\t\t\tTo...\t\t\t\t\t\t\t\t\t\t\t\t\t\tV, D\t\t\t\tFit document.\t\t\t\t\t\t\t\t\t\tV, F\t\t\t\tFit board.\t\t\t\t\t\t\t\t\t\tS, Y\t\t\t\tSelect all on current layer.\t\t\t\t\t\t\t\t\t\tX, A\t\t\t\tDeselect all.\t\t\t\t\t\t\t\t\t\tO, D\t\t\t\tAccess the View Options tab of the View Configuration panel.\t\t\t\t\t\t\t\t\t\tG, G, 5, Enter\t\t\t\tSet default Global Board Snap Grid to 5mil (both Step X and Step Y) when the board measurement units are Imperial.\u00a0G, G accesses the Snap Grid (1..1000) dialog. Depending on the grid size required\u00a0and the current measurement units, change the sequence after this\u00a0and before the final Enter\u00a0as needed.\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tT, M\t\t\t\tReset error markers.\t\t\t\t\t\t\t\t\t\tD, R\t\t\t\tAccess the PCB Rules and Constraints Editor dialog.\t\t\t\t\t\t\t\t\t\tT, G, M\t\t\t\tAccess the Polygon Pour Manager dialog.\t\t\t\t\t\t\t\t\t\tT, D, R\t\t\t\tRun a batch Design Rule Check.\t\t\t\t\t\t\t\t\t\tP, S\t\t\t\tPlace string.\t\t\t\t\t\t\t\t\t\tP, T\t\t\t\tStart interactive routing.\t\t\t\t\t\t\t\t\t\tM, M\t\t\t\tMove object.\t\t\t\t\t\t\t\t\t\tM+X\t\t\t\tOpens the Get X-Y Offsets dialog to move the current selection by a specified distance in the horizontal (X) and\/or vertical (Y) planes.\t\t\t\t\t\t\t\t\t\tT, P\t\t\t\tAccess the PCB Editor - General page of the Preferences dialog.\u00a0If you have previously accessed a different page of the PCB preferences, then that page will be presented.\t\t\t\t\t\t\t\t    Draftsman Keyboard Sequences    \t\t\t\t\t\t\t\t\t\tUse the Accelerator Key Sequence...\t\t\t\tTo...\t\t\t\t\t\t\t\t\t\t\t\t\t\tV, D\t\t\t\tFit document\t\t\t\t\t\t\t\t\t\tV, F\t\t\t\tFit selected sheet\t\t\t\t\t\t\t\t\t\tP, S\t\t\t\tPlace Board Assembly View\t\t\t\t\t\t\t\t\t\tP, F\t\t\t\tPlace Board Fabrication View\t\t\t\t\t\t\t\t\t\tP, V, E\t\t\t\tPlace Board Realistic View\t\t\t\t\t\t\t\t\t\tT, I\t\t\t\tImport changes from the PCB document\t\t\t\t\t\t\t\t\t\tT, A\t\t\t\tAdd new sheet\t\t\t\t\t\t\t\t\t\tM, S\t\t\t\tMove selected object(s)","tags":"","url":"altium-designer\/24\/documentation-altium-designer-shortcut-keys.html"},
{"title":"QuickNav - Panels","text":".Container {position:relative; user-select:none; display:inline-block; margin:0 30px 0 30px;}\t.SlidesTable td {border:none;padding:0;}\t.FirstText {border:none; display:inherit;padding: 0 30px 0 40px;}\t.FirstText {border:solid 1px lightgray; display:block; padding:8px;}\t.OverlayText {border::none;; display:none;padding: 0 30px 0 40px;}\t.OverlayText {border:solid 1px lightgray; display:block; padding:8px;}\th5 {font-family:dinpro-medium; line-height:1.2; font-size:17px; letter-spacing:normal; color:#424242; margin: 0 0 12px;}\t.Next,.Previous {font-size:25px; cursor:pointer; position:absolute; top:40%; color:blue; padding:2px 8px 5px 8px;}\t.Next {right:-30px;}\t.Previous {left:-30px;}\ta.Next, a.Previous {opacity:0.6; transition:0.3s;}\ta:hover.Next, a:hover.Previous {opacity:1; background-color:lightgray; text-decoration:none;}\t.Overlay {z-index:-1; position:absolute; top:0; transition:0.5s ease; opacity:0;  padding:10px; border:solid 1px; border-color:lightgray;}\t.First {transition:1s ease-in; padding:10px; border:solid 1px; border-color:lightgray;}\t.blob {height:15px; width:15px; margin:0 5px; background-color:#bbb; border-radius:50%; display:inline-block; cursor:pointer;}\t.blobs {text-align:center; padding:0; color:blue;}\t.Counter {display:none;}\t\u00a0Panels are an essential part of the Altium Designer environment. Editor-specific panels provide an alternate view into the data being edited, while system-wide panels\u00a0give access to design data across multiple editors. This page provides quick reference information about the various panels that can be used within Altium Designer, giving you a means to quickly navigate to more detailed information about each.\tPanels themselves can be accessed through the\u00a0View \u00bb Panels\u00a0sub-menu\u00a0or by using the Panels button at the bottom-right of the main design window. In both cases, the panels listed are those in context with the document editor you are currently using.\u00a0For an overview on working with panels, including general tips and tricks, see Working with Panels.Key Panels SlideshowTake a look through the slides below to see a variety of\u00a0panels highlighted &#039;in action&#039;.\u00a0Note that focus is primarily on the panels that you&#039;ll use more regularly when capturing and laying out your designs.\t\t\t\t\t\t\t\t\t\t\t\t\t\u276f \u276e\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t1\t\t\t\t\t\t\t\t\tJavascript\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe Projects panel\u00a0is command central for interacting with projects and their documents. In this example, you can see a project (Sample - Kame_FMU.PrjPcb) opened from the currently connected (active) Workspace (Company Workspace), along with one of its source schematic documents (5_spi_memory.SchDoc). A few local projects are also open, gathered into the project group Project Group 1.DsnWrk. Learn more...\t\t\t\t\t\t\t\t\u00a0On the right of the image you can see the Properties panel, which is typically used to interrogate and modify the properties of selected design objects (in this case a serial memory component). The Properties panel also provides access to properties\u00a0at the document\/editor-level too, when no design objects are currently selected, as well as properties associated with certain interactive design processes (such as routing and length tuning on a PCB document). Learn more...\t\t\t\t\t\t\t\t\t\t\t\t\t\tAs part of your day-to-day activities with components you will come to use, and rely on, two particular panels within Altium Designer - the Components panel and Manufacturer Part Search panel. The Components panel provides a powerful interface with which to interact with all your components - both Workspace and local (database and file-based). For components in your Workspace Library, the\u00a0panel\u00a0also offers\u00a0basic component management functions such as component creation, editing and cloning, and editing a selected component&#039;s Part Choices and Type. Learn more...\t\t\t\t\t\t\t\t\u00a0The Manufacturer Part Search panel provides the ability for you to search for real-world manufactured parts by offering a sophisticated search feature based on categories and parametric filtering. The panel harnesses the manufacturer and supplier data resources of the\u00a0Altium Parts Provider\u00a0service to source the most pertinent and up-to-date component data. A selected manufactured part can be saved to a\u00a0connected Workspace\u00a0or downloaded as a library, or its parameters and datasheets added to an existing part in the design space. Learn more...\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe\u00a0Navigator\u00a0panel allows you to browse either the compiled active source schematic document\u00a0or all compiled source schematic documents in the active project. It utilizes the connective model of the design, which is created upon compilation, as its foundation for navigation. When using the panel&#039;s Interactive Navigation mode,\u00a0you are able to spatially navigate the design directly on the document(s).\u00a0As you navigate a design document, the\u00a0panel will update\u00a0with the information relative to your selection in the main design space. In this example,\u00a0you can see interactive navigation in action, with the connective graph option enabled to highlight the connectivity between objects in the VCC3 net. Learn more...\t\t\t\t\t\t\t\t\t\t\t\t\t\tUnderlying Altium Designer&#039;s schematic and PCB editors is a powerful query engine. By entering queries into this engine you can logically scope precisely those objects you require. A query is a string you enter using specific keywords and syntax, which will return the targeted objects. In this example, the SCH Filter panel has been configured to use the logical query expression\u00a0IsPin And (PinElectrical = &#039;Passive&#039;)\u00a0to quickly find, select and zoom all passive pins in the active schematic document. All other objects not matching the defined filter are left unselected and masked (fading their appearance in the design space). Learn more...\t\t\t\t\t\t\t\t\t\t\t\t\t\tFor message-enabled features of the software (e.g.,\u00a0project validation, running a DRC\u00a0for the active PCB document, autorouting and performing a mixed-signal simulation) the Messages panel is your go-to place for status information and is where any warnings and\/or errors will be presented. Shown here are example messages from the Compiler after performing a project validation. Three components are flagged as not being the latest revision. Since no errors (or fatal errors) were detected, an information message reflects that the validation was successful. For messages involving design objects, the panel provides additional details, with the ability to cross-probe to an offending object (on the applicable document) within the design space. Learn more...\t\t\t\t\t\t\t\t\t\t\t\t\t\tThe PCB panel (on the left) is your daily-use panel when laying out your board in the PCB editor. It provides a key aid in browsing\u00a0various design objects, especially nets and components, while also providing a myriad of functional modes used to work with various elements of the PCB design (e.g., layer stack regions, polygon pours and xSignals). In this example,\u00a0a specific net (IMU_HEAT_CTL) is being explored, with filtering to dim all other design objects in the design space. On the right, you can see the Properties panel being used to view the properties of a selected via (a member of that net). Learn more...\t\t\t\t\t\t\t\t\t\t\t\t\t