(function ($, Drupal) {

  /**
   * Save Feedback Domo entity.
   */
  Drupal.behaviors.altiumDocFeedback = {
    attach: function (context, settings) {

      if (typeof drupalSettings.spaceName !== 'undefined' && $('#space-value').length) {
        document.getElementById("space-value").value = drupalSettings.spaceName;
      }

      $(once('init', '#feedback_custom-message-page', context)).each(function() {
        if (typeof drupalSettings.altiumDocMenu === 'undefined' ||
          typeof drupalSettings.altiumDocMenu.basePage === 'undefined') {
          return;
        }

        var node_nid = drupalSettings.altiumDocMenu.basePage;

        if (Cookies.get('feedback_send_' + drupalSettings.altiumDocMenu.basePage) == 1) {
          return;
        }

        $('#feedback_custom-message-page').css('display', 'block');

        $('#feedback_custom-message-page ._like-item .b-score__num').load('/documentation/feedback/vote/get/up/' + node_nid);
        // Hide thumb down stats.
        if ($('body').hasClass('role-author_user') || $('body').hasClass('role-administrator')) {
          $('#feedback_custom-message-page ._dislike-item .b-score__num').load('/documentation/feedback/vote/get/down/' + node_nid);
        }

        if (Cookies.get('feedback_send_' + node_nid) == 'up') {
          $('#feedback_custom-message-page ._like-item .b-score__control').addClass('_active');
        }
        if (Cookies.get('feedback_send_' + node_nid) == 'down') {
          $('#feedback_custom-message-page ._dislike-item .b-score__control').addClass('_active');
        }

        $('#feedback_custom-message-page ._like-item a').on('click', function (e) {
          e.preventDefault();
          e.stopPropagation();
          feedback_send_go('up');
        });

        $('#feedback_custom-message-page ._dislike-item a').on('click', function (e) {
          e.preventDefault();
          e.stopPropagation();
          feedback_send_go('down');
        });

        $('#feedback_custom-message-page ._dislike-item a ._dislike').on('click', function (e) {
          if ($('#feedback_custom-message-page ._dislike-item a ._active').length) {
            e.preventDefault();
            e.stopPropagation();
            feedback_send_go('down');
          }
          else {
            if ($('body').hasClass('role-anonymous')) {
              e.preventDefault();
              e.stopPropagation();
              feedback_send_go('down');
            }

            var ajaxSettings = {
              url: '/documentation/feedback-reports/create',
              dialogType: 'modal',
              dialog: { width: 645, dialogClass: 'feedback-ui-dialog aa-form' },
            };
            var myAjaxObject = Drupal.ajax(ajaxSettings);
            myAjaxObject.execute();
          }
        });

        function feedback_send_go(type) {
          $('#feedback_custom-message-page .b-score__control').addClass('_disabled');
          if (typeof Cookies.get('feedback_send_' + node_nid) === 'undefined') {
            feedback_send_do_vote(type, 'plus');
          }
          else {
            if (Cookies.get('feedback_send_' + node_nid) == type) {
              feedback_send_do_vote(type, 'minus');
            }
            else {
              if (type == 'up') {
                feedback_send_do_vote('down', 'minus');
                feedback_send_do_vote('up', 'plus');
              }
              else {
                feedback_send_do_vote('up', 'minus');
                feedback_send_do_vote('down', 'plus');
              }
            }
          }
        }

        function feedback_send_do_vote(type, operation) {
          if (operation == 'plus') {
            Cookies.set('feedback_send_' + node_nid, type);
            $('#feedback_custom-message-page .b-score__control').removeClass('_active');
            $('#feedback_custom-message-page .b-score__control').addClass('_disabled');
            $.ajax({
              url: '/documentation/feedback/vote/set/' + type + '/' + node_nid + '/plus',
              success: function (data) {
                // Hide thumb down stats.
                if (type == 'up' || $('body').hasClass('role-author_user') ||
                  $('body').hasClass('role-administrator')) {
                  $('#feedback_send_button_' + type + ' .b-score__num').html(data);
                }

                $('#feedback_custom-message-page .b-score__control')
                  .removeClass('_active')
                  .removeClass('_disabled');
                $('#feedback_send_button_' + type + ' .b-score__control').addClass('_active');
              },
            });
          }
          else {
            Cookies.remove('feedback_send_' + node_nid);
            $('#feedback_send_button_' + type + ' .b-score__control')
              .removeClass('_active');
            $.ajax({
              url: '/documentation/feedback/vote/set/' + type + '/' + node_nid + '/minus',
              success: function (data) {
                // Hide stats from thumb down.
                if (type == 'up' || $('body').hasClass('role-author_user') ||
                  $('body').hasClass('role-administrator')) {
                  $('#feedback_send_button_' + type + ' .b-score__num').html(data);
                }
                $('#feedback_custom-message-page .b-score__control').removeClass('_disabled');
              },
            });
          }
        }
      });

    }
  };

  $('body').on('click', '.feedback-ui-dialog .feedback-close', function() {
    $('.ui-dialog-titlebar-close').click();
  });

})(jQuery, Drupal);
