(function ($, Drupal) {

  /**
   * Advanced image Show in popup option.
   */
  Drupal.behaviors.altiumDocImageShowInPopup = {
    attach: function (context, settings) {
      $(once('move', 'img[data-show-in-popup="1"]', context)).each(function() {
        var src = $(this).attr('src'); // Get the source of the image
        var extension = src
          .split(/[?#]/)[0] // Remove query string from URL.
          .split('.').pop().toLowerCase(); // Get the extension and convert to lowercase

        if ($(this).attr('title') !== null &&
          $(this).attr('title') !== undefined &&
          $(this).attr('title').trim() !== '') {
          var tooltip_text = $(this).attr('title');
        }
        else {
          var tooltip_text = Drupal.t("Show Image");
        }

        $(this).wrap('<a data-tooltip="{&quot;content&quot;:&quot;' + tooltip_text + '&quot;,&quot;placement&quot;:&quot;top&quot;,&quot;arrow&quot;:true}" tabindex="0" data-popper-placement="top" href="' + src + '" class="fancybox"></a>');
        if (extension === 'gif') {
          $(this).parent().addClass('popup-icon-gif');
          $(this).parent().attr("onclick", "this.children[0].src='" + src.split('?')[0] + "?t=' + new Date().getTime();");

          $(this).parent().fancybox({
            afterShow: function(instance, current) {
              var src = $('.fancybox-inner .fancybox-image').attr('src');
              $('.fancybox-inner .fancybox-image').attr('onclick', "this.src='" + src.split('?')[0] + "?t=' + new Date().getTime();");

              $('.fancybox-inner .fancybox-image').click();
            },
            'autoHeight' : true,
            'maxWidth': '90%',
            'minHeight': 5,
            'minWidth': 5,
          });
        }
        else {
          $(this).parent().addClass('popup-icon');
          $(this).parent().fancybox();
        }

      });
    }
  };

})(jQuery, Drupal);
