(function ($, Drupal) {
  Drupal.behaviors.altiumDocMenuAjax = {
    attach: function (context, settings) {
      $(once('arrow', 'li.menu-item ._arrow', context)).each(function() {
        $(this).on('click', function(e) {
          e.stopPropagation();
          e.preventDefault();
          var $this = $(this);
          var $menuItem = $this.closest('li.menu-item');
          if (!$menuItem.hasClass('menu-item--collapsed')) {
            return false;
          }
          if ($(this).hasClass('ajax-progress')) {
            return false;
          }

          $(this).addClass('ajax-progress');

          var urlParams = new URLSearchParams(window.location.search);
          urlParams.get('version');
          var version = urlParams.get('version');
          var uuid = $menuItem.data('menu-uuid');
          var url = Drupal.url('ajax/menu-load-tree/' + uuid);
          if (version) {
            url = url + '?version=' + version;
          }
          Drupal.ajax({
            url: url,
            progress: {
              type: 'throbber'
            },
            element: $this.siblings('a'),
            complete: function() {
              $(this).removeClass('ajax-progress');
            },
          }).execute();
          return false;
        });
      });

      // Load subtree instead of opening Structure Menu link items.
      $(once('structure-page', 'li.menu-item > div > a.structure-page', context)).each(function() {
        $(this).on('click', function(e) {
          if ($(this).siblings('._arrow').length) {
            e.preventDefault();
            $(this).siblings('._arrow').click();
          }
        });
      });

      $(once('arrow-click', 'li.menu-item.menu-item--expanded ._arrow', context)).each(function() {
        $(this).on('click', function() {
          var $li = $(this).closest('li.menu-item');
          $li.removeClass('menu-item--expanded _active-level').addClass('menu-item--collapsed');
          $li.find('ul.menu').hide();
        });
      });

      $('li.menu-item a.is-active').closest('li.menu-item').addClass('_active');

      // Move SVG icon inside link. See menu-levels.html.twig template.
      $('.l-nav-pages__menu .menu-item--ico', context).each(function() {
        if (!$(this).hasClass('moved')) {
          $(this).appendTo($(this).siblings('a'));
          $(this).addClass('moved');
        }
      });

      $('.disable-expanded').siblings('._arrow').remove();
    }
  };
})(jQuery, Drupal);
