(function () {
  // --- Configuration / names you actually use ---
  const DARK_CLASS = '_theme-dark';
  const FOOTER_DARK_CLASS = 'footer-v2_style-dark';

  // Read cookie
  function getCookie(name) {
    const safe = name.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
    const match = document.cookie.match(new RegExp('(?:^|;\\s*)' + safe + '\\s*=\\s*([^;]*)'));
    return match ? decodeURIComponent(match[1]) : null;
  }

  const isDark = getCookie('documentation-theme') === DARK_CLASS;

  if (isDark) {
    // Apply to <html> immediately for first paint
    document.documentElement.classList.add(DARK_CLASS);
    document.documentElement.style.colorScheme = 'dark';

    // If <body> is already parsed, apply right away
    if (document.body) {
      document.body.classList.add(DARK_CLASS);
    } else {
      // If not yet, ensure it’s set once body exists
      new MutationObserver((mutations, observer) => {
        if (document.body) {
          document.body.classList.add(DARK_CLASS);
          observer.disconnect();
        }
      }).observe(document.documentElement, { childList: true });
    }

    // Same for footer (might or might not exist yet)
    const footer = document.querySelector('.footer-v2');
    if (footer) {
      footer.classList.add(FOOTER_DARK_CLASS);
    } else {
      new MutationObserver((mutations, observer) => {
        const footerNow = document.querySelector('.footer-v2');
        if (footerNow) {
          footerNow.classList.add(FOOTER_DARK_CLASS);
          observer.disconnect();
        }
      }).observe(document.documentElement, { childList: true, subtree: true });
    }

    // Switch CodeMirror themes (for existing instances)
    document.querySelectorAll('.CodeMirror-wrap').forEach(el => {
      el.classList.remove('cm-s-default');
      el.classList.add('cm-s-base16-dark');
    });
    // If CodeMirror is injected later, MutationObserver again if needed
  }
})();
