(function ($, Drupal, cookies, drupalSettings) {
  $(document).ready(function () {
    var popupCookie = cookies.get('techdocs_redirect', { path: '/', domain: '.altium.com' });
    if (!popupCookie || typeof popupCookie === undefined) {
      return;
    }

    if (popupCookie != 1) {
      return;
    }
    cookies.remove('techdocs_redirect', { path: '/', domain: '.altium.com' });

    if (!$('body').hasClass('page-node-type-page-404') && drupalSettings.path.isFront === false) {
      return;
    }

    const modalContent = `
  <div title="${Drupal.t('Notice')}">
    ${Drupal.t("Welcome to Altium's latest online Technical Documentation. You've been redirected here because the legacy techdocs.altium.com site has now been closed and the page and/or feature you are seeking is no longer part of the current documentation.")}
    <br><br>
    ${Drupal.t("This page provides a gateway to an expansive set of technical documentation, provided across the range of design solutions available from Altium. Click a tile to explore a particular solution's documentation or, alternatively, use the Search facility.")}
    <br><br>
    ${Drupal.t('For more information, see <a href="https://www.altium.com/documentation/readme" target="_blank">Using Altium Documentation</a>.')}
  </div>
`;

    $(modalContent).dialog({
      modal: true,
      title: Drupal.t("You've been redirected"),
      width: 600,
      buttons: {
        OK: function () {
          $(this).dialog('close');
        }
      },
      classes: {
        'ui-dialog': 'notice',
        'ui-widget-overlay': 'notice',
        'ui-front': 'notice',
      }
    });
  });


})(jQuery, Drupal, window.Cookies, drupalSettings);
