(function ($, Drupal) {
  Drupal.behaviors.altiumReportIssue = {
    attach: function (context, settings) {
      var self = this;
      $(once('typo-message', 'body', context)).each(function() {
        self.init();
      });
    },
    init: function () {
       // Adding a delay before the window closes.
      $(document).ajaxComplete(function (event, xhr, options) {
        if (!xhr.responseJSON) {
          return;
        }

        for (let key in xhr.responseJSON) {
          if (!xhr.responseJSON.hasOwnProperty(key)) {
            continue;
          }

          if (!xhr.responseJSON[key].hasOwnProperty('settings') || (xhr.responseJSON[key].settings === null)) {
            continue;
          }

          if (!xhr.responseJSON[key].settings.hasOwnProperty('report_issue_result')) {
            continue;
          }

          setTimeout(function () {
            $(`#issue-feedback`).modal('hide');
          }, 10000);
        }

      })
    }
  };
})(jQuery, Drupal);
