/**
 * @file
 * Attaches behaviors for Drupal's active link marking.
 */

(function (Drupal, drupalSettings) {
  Drupal.behaviors.altiumDocMenuactiveLinks = {
    attach(context) {
      if (typeof drupalSettings.altiumDocMenu === 'undefined') {
        return;
      }
      if (typeof drupalSettings.altiumDocMenu.basePage === 'undefined') {
        return;
      }
      const basePageid = drupalSettings.altiumDocMenu.basePage;
      if (basePageid !== null) {
        const basePagePath = 'node/' + basePageid;
        const selectors = [
          `.menu [data-drupal-link-system-path="${basePagePath}"]`,
        ];
        const activeLinks = context.querySelectorAll(selectors.join(','));
        const il = activeLinks.length;
        for (let i = 0; i < il; i++) {
          activeLinks[i].classList.add('is-active');
          const parentLi = activeLinks[i].closest('li');
          if (parentLi !== null) {
            parentLi.classList.add('_active');
          }
        }
      }
    },
  };
})(Drupal, drupalSettings);
