(function ($, Drupal, cookies) {
  Drupal.behaviors.altiumDocVersionRedirect = {
    attach: function (context, settings) {
      if (!drupalSettings.altium_doc_version) {
        return;
      }

      if (!drupalSettings.altium_doc_version.redirect) {
        return;
      }

      if (drupalSettings.altium_doc_version.redirect !== '1') {
        return;
      }

      if (!drupalSettings.altium_doc_version.url) {
        return;
      }

      if (!drupalSettings.altium_doc_version.new_version) {
        return;
      }

      cookies.set('altium_doc_version_redirect', JSON.stringify({
        'show_popup': 1,
        'new_version': drupalSettings.altium_doc_version.new_version,
        'url': drupalSettings.altium_doc_version.url
      }));
      window.location.href = drupalSettings.altium_doc_version.url;
    }
  };
})(jQuery, Drupal, window.Cookies);
