(function ($, Drupal) {

  /**
   * Frontend enhancements.
   */
  Drupal.behaviors.altiumDocFrontendEnhancements = {
    attach: function (context, settings) {
      $(once('move', '.messages-top', context)).each(function() {
        $(this).insertBefore($('.l-main-content__title'));
      });

      $(once('remove-href', '.b-quick-links__link-group a[href=""]', context)).each(function() {
        $(this).removeAttr('href');
      });

      const queryString = window.location.search;
      $(once('add-get-parameter', '.breadcrumb a', context)).each(function(index) {
        if (index == 0) {
          return true;
        }
        if (queryString !== 'undefined' && $(this).attr('href').indexOf('?') === -1) {
          var newHref = $(this).attr('href') + queryString;
          $(this).attr('href', newHref);
        }
      });

      $(once('remove-checkbox', '.tmgmt-content-translate-form #edit-languages tbody tr', context)).each(function() {
        if (!$(this).find('.dropbutton-wrapper').length) {
          $(this).find('.form-type-checkbox').remove();
        }
      });

      $(once('copy', '.note-block', context)).each(function() {
        $(this).clone().insertBefore($('.l-main-content__body'));
      });

      $(once('copy-footer', '.pre_links .print a', context)).each(function() {
        // Get the value of the 'query' parameter from the URL
        var urlParams = new URLSearchParams(window.location.search);
        var queryParam = urlParams.get('version');

        // If the 'query' parameter exists, add it to the <a> tag
        if (queryParam) {
          var href = $(this).attr('href');
          $(this).attr('href', href + '?version=' + queryParam);
        }

        $(this).clone().appendTo($('#typo-message .right-column'));
        $(this).remove();
      });

      $(once('copy-lang', '.footer-v2__lang', context)).each(function() {
        $(this).clone(true).appendTo($('#typo-message .left-column'));
        $('#typo-message .left-column .footer-v2__lang-list')
          .removeClass('footer-v2__lang-list')
          .addClass('lang-list');
      });

      once('lang-cookie-clear', 'ul.tabs.primary a[href*="/node/"][href*="/edit"]', context)
        .forEach(link => {
          link.addEventListener('click', event => {
            event.preventDefault(); // Pause navigation

            // Delete the cookies for .altium.com.
            ['lang_selected_code', 'lang_selected_code_new'].forEach(name => {
              document.cookie = `${name}=; expires=Thu, 01 Jan 1970 00:00:00 GMT; path=/; domain=.altium.com;`;
            });

            // Resume navigation.
            window.location.href = link.href;
          });
        });

      // It's not working. See template altium-navigation-a365-blocks-footer.html.twig.
      // $(once('copy-lang', '.l-footer__lang__wrap', context)).each(function() {
      //   $(this).clone(true).appendTo($('.b-typo-message .left-column'));
      //   $('.b-typo-message .left-column .l-footer__lang-list')
      //     .removeClass('l-footer__lang-list')
      //     .addClass('lang-list');
      // });

      $(once('add-class', '.region-footer .dams-banner', context)).each(function() {
        $(this).closest('.block-block-content').addClass('dams-banner-wrapper');
      });

      function frontendSetCookie(name, value, days, domain) {
        let expires = "";
        if (days) {
          const date = new Date();
          date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
          expires = "; expires=" + date.toUTCString();
        }
        let domainString = "";
        if (domain) {
          domainString = "; domain=" + domain;
        }
        document.cookie = name + "=" + (value || "")  + expires + "; path=/" + domainString;
      }

      $('#typo-message .left-column .footer-v2__lang li a').on('click', function(e) {
        e.preventDefault();
        e.stopPropagation();

        frontendSetCookie('lang_selected_code', $(this).data('language'), 365, '.altium.com');
        frontendSetCookie('lang_selected_code_new', $(this).data('language'), 365, '.altium.com');
        frontendSetCookie('lang_selected_code', $(this).data('language'), 365, '.altium365.com');
        frontendSetCookie('lang_selected_code_new', $(this).data('language'), 365, '.altium365.com');

        window.location.href = $(this).attr('href');
      });

      $(once('click', '#typo-message .left-column .footer-v2__lang-active', context)).each(function() {
        $(this).on('click', function() {
          $('#typo-message .left-column .footer-v2__lang').toggleClass('active');
        });
      });

      setTimeout(function() {
        $(once('click', '#typo-message .left-column .footer-v2__lang-active', context)).each(function() {
          $(this).on('click', function() {
            $('#typo-message .left-column .footer-v2__lang').toggleClass('active');
          });
        });
      }, 2000);

      $(once('wrap', '.horizontal-scroll', context)).each(function(){
        $(this).wrap('<div class="horizontal-scroll-wrapper"></div>');
      });

      $(once('wrap', '.vertical-scroll', context)).each(function(){
        $(this).wrap('<div class="vertical-scroll-wrapper"></div>');
      });

      $(once('wrap', '.table-scroll', context)).each(function(){
        $(this).wrap('<div class="table-scroll-wrapper"></div>');
      });

      $(once('add-host', '.domain-altium365_com .menu--quick-links .menu .menu-item a', context)).each(function() {
        $(this).attr('href', 'https://www.altium.com' + $(this).attr('href'));
      });

      $(once('marginBottom', '.l-main-content .field--name-body img', context)).each(function() {
        var $imgHeight = $(this).height();
        if (Math.floor($imgHeight) < 12 && Math.floor($imgHeight) !== 0) {
          $(this).css('margin-bottom', 0);
        }
        switch (Math.floor($imgHeight)) {
          case 12:
            $(this).css('margin-bottom', -1);
            break;

          case 13:
            $(this).css('margin-bottom', -1);
            break;

          case 14:
            $(this).css('margin-bottom', -2);
            break;

          case 15:
            $(this).css('margin-bottom', -2);
            break;

          case 16:
            $(this).css('margin-bottom', -3);
            break;

          case 17:
            $(this).css('margin-bottom', -3);
            break;

          case 18:
            $(this).css('margin-bottom', -4);
            break;

          case 19:
            $(this).css('margin-bottom', -4);
            break;

          case 20:
            $(this).css('margin-bottom', -4);
            break;

          case 21:
            $(this).css('margin-bottom', -4);
            break;

          case 22:
            $(this).css('margin-bottom', -5);
            break;

          case 23:
            $(this).css('margin-bottom', -5);
            break;

          case 24:
            $(this).css('margin-bottom', -6);
            break;

          case 25:
            $(this).css('margin-bottom', -6);
            break;

          case 26:
            $(this).css('margin-bottom', -7);
            break;

          case 27:
            $(this).css('margin-bottom', -7);
            break;

          case 28:
            $(this).css('margin-bottom', -8);
            break;

          case 29:
            $(this).css('margin-bottom', -8);
            break;

          case 30:
            $(this).css('margin-bottom', -9);
            break;

          case 31:
            $(this).css('margin-bottom', -9);
            break;

          case 32:
            $(this).css('margin-bottom', -10);
            break;
        }

        if ($(this).attr('data_margin_bottom') != '') {
          $(this).css('margin-bottom', parseFloat($(this).attr('data_margin_bottom')));
        }
      });

    }

  };

  /**
   * HTML Offline Javascript.
   */
  $(document).ready(function(){
    if ($('#tipue_search_input').length) {
      $('#tipue_search_input').tipuesearch();
    }

    if ($('body').hasClass('offline')) {
      $('.breadcrumb > a').first().attr('href', $('#wikimenu > li > a').attr('href'));

      $('.am-form._version .select2-selection__arrow').remove();
      $('.version-switcher').remove();

      $('form.am-form.am-form-search').off('submit');
    }

    if ($('#wikimenu').length === 0) {
      return;
    }

    if ($('#wikimenu_offline_link_nid_' + drupalSettings.altiumDocMenu.basePage).length) {
      $('#wikimenu_offline_link_nid_' + drupalSettings.altiumDocMenu.basePage)
        .parents('li')
        .addClass('menu-item--expanded')
        .addClass('_active-level');

      $('#wikimenu_offline_link_nid_' + drupalSettings.altiumDocMenu.basePage)
        .parents('li')
        .first()
        .addClass('_active');
    }

    $('#wikimenu li._active-level').each(function() {
      $(this).find('ul.menu').first().show();
    });

    $('#wikimenu ._arrow').on('click', function() {
      $(this).closest('li').find('ul.menu').first().toggle();
    });

    var $container = $('.l-page-cols__scroll-wrap.custom-scroll');
    var $target = $('#wikimenu li._active');

    var top = $target.offset().top - $container.offset().top + $container.scrollTop();
    $container.scrollTop(top - 300);

    if ($('#wikimenu_offline_link_nid_303363').length &&
      $('#wikimenu_offline_link_nid_303363').parent().parent().hasClass('_active-level')) {
      $('.b-enabled-version.eol').hide();
    }
  });

})(jQuery, Drupal);

