(function ($, Drupal, cookies) {
  Drupal.behaviors.altiumDocVersionPopup = {
    attach: function (context, settings) {
      var popupCookie = cookies.get('altium_doc_version_redirect');
      if (!popupCookie || typeof popupCookie === undefined) {
        return;
      }
      var popupData = JSON.parse(popupCookie);
      if (!popupData.show_popup || popupData.show_popup != 1 || !popupData.url) {
        return;
      }

      var windowLocationUrl = window.location.href.replace('http:', 'https:');
      var popupDataUrl = popupData.url.replace('http:', 'https:');
      if (windowLocationUrl != popupDataUrl) {
        return;
      }

      cookies.remove('altium_doc_version_redirect');

      var ajaxSettings = {
        url: '/documentation/modals/version_popup/' + popupData.new_version,
        dialogType: 'modal',
        dialog: {
          width: 600,
          buttons: [
            {
              text: Drupal.t('OK'),
              'class': 'close_version_popup',
            }
          ],
          classes: {
            'ui-dialog': 'notice',
            'ui-widget-overlay': 'notice',
            'ui-front': 'notice',
          }
        },
      };

      var myAjaxObject = Drupal.ajax(ajaxSettings);
      myAjaxObject.execute();
    }
  };

  $('body').on('click', '.ui-dialog-buttonset button.close_version_popup', function() {
    $('.ui-dialog-titlebar-close').click();
  });

})(jQuery, Drupal, window.Cookies);
